from viavi.evm import *
from viavi.diag import *
import viavi.mts.uts_spi as utsspi
import viavi.mts.uts_bdt as utsbdt  # /usr/lib/python3.8/site-packages/viavi/mts/uts_bdt.py
import time, os
import smbus
import serial

import subprocess
from datetime import datetime

from viavi.mts.fth_reg_def import *
#
#***************************************************
def show_tacb_glu_reg_contents(reg_name, reg_value):
#***************************************************
#
    print("\n* %s register read value = 0x%x" %(reg_name, reg_value))

    #---------------------------------
    # TACB "glu" registers
    #---------------------------------

    if reg_name == 'TACB_GLU_IP_VERSION':
        reg_addr = REG_TACB_GLU_IP_VERSION

    return None
#
#***************************************************
def show_tacb_bdt_reg_contents(reg_name, reg_value):
#***************************************************
#
    print("\n* %s register read value = 0x%x" %(reg_name, reg_value))

    #---------------------------------
    # TACB "TimeBase" (bdt) registers
    #---------------------------------

    if reg_name == 'TACB_TEETH_NUMBER':
        bit_range = '(17:0)'
        mask      = 0x3ffff
    elif reg_name == 'TACB_XOFFSET_DURATION':
        bit_range = '(9:0)'
        mask      = 0x3ff
    elif reg_name == 'TACB_MASK_DURATION':
        bit_range = '(17:0)'
        mask      = 0x3ffff
    elif reg_name == 'TACB_WAIT_DURATION':
        bit_range = '(17:0)'
        mask      = 0x3ffff
    elif reg_name == 'TACB_NOISE_DURATION':
        bit_range = '(13:0)'
        mask      = 0x3fff
    elif reg_name == 'TACB_AVG_NUMBER':
        bit_range = '(15:0)'
        mask      = 0xffff
    elif reg_name == 'TACB_RAMP_INCR':
        bit_range = '(3:0)'
        mask      = 0xf
    elif reg_name == 'TACB_RAMP_RST_VAL':
        bit_range = '(7:0)'
        mask      = 0xff
    elif reg_name == 'TACB_COMB_NUMBER':
        bit_range = '(8:0)'
        mask      = 0x1ff
    elif reg_name == 'TACB_COMB_INCR':
        bit_range = '(7:0)'
        mask      = 0xff
    elif reg_name == 'TACB_MISC':
        bit_range = '(15:0)'
        mask      = 0xffff
    elif reg_name == 'TACB_HW_CFG':
        bit_range = '(23:0)'
        mask      = 0xffffff
    elif reg_name == 'TACB_TOT_TEETH_NB_CALC':
        bit_range = '(17:0)'
        mask      = 0x3ffff
    elif reg_name == 'TACB_FORCE_COMB_ID':
        bit_range = '(9:0)'
        mask      = 0x3ff
    elif reg_name == 'TACB_RECUR_PRIME_NB':
        bit_range = '(17:0)'
        mask      = 0x3ffff
    elif reg_name == 'TACB_FSM_STATE_DBG':
        bit_range = '(?:0)'
        mask      = 0x3ffff
        print(reg_msg)
    elif reg_name == 'TACB_SPI_STEP_VAL':
        bit_range = '(7:0)'
        mask      = 0xff
    elif reg_name == 'TACB_SEQ_CORE_IP_VERSION':
        bit_range = '(31:0)'
        mask      = 0xffffffff
    else:
        print()
        print_error("* Error : Unknown register")
        return False

    reg_msg = "  read_data = "+reg_name+bit_range
    print(reg_msg)
    print("     > %s%s = 0x%x" %(reg_name, bit_range, (reg_value & mask)))

    return None
#
#***************************************************
@DIAG("TACB GLU registers write access")
def t_tacb_glu_reg_wr(cmd):
#***************************************************
#
    try:
        if len(cmd.split(' ')) == 2:
            cmd_lgth = 2
            (command, consigne) = cmd.split(' ')
            verbose = False
        else:
            cmd_lgth = 3
            (command, consigne, verbose_flag) = cmd.split(' ')
            
            if verbose_flag == "verbose":
                verbose = True
            else:
                print_error("   Syntax error : 2nd arg must be : verbose")
                return False

        (reg_name, reg_value_str) = consigne.split('-')
        reg_value_wr = int(reg_value_str, base=16)
    
    except:
        print()
        print_error("   Syntax error : Command must be : t_tacb_glu_reg_wr <consigne> <verbose>      ")
        print_error("   where <consigne is : <reg_name>-<reg_value>                                  ")
        print_error("                                                                                ")
        print_error("                        <reg_name> is :                                         ")
        print_error("                           TACB_GLU_MTS_PS                                      ")
        print_error("                           TACB_GLU_LED                                         ")
        print_error("                           TACB_GLU_MSEL                                        ")
        print_error("                           TACB_MTS_PWR_DIAG                                    ")
        print_error("                        <reg_value> is : hexa data value to write into register ")
        print_error("                                                                                ")
        print_error("         <verbose_flag> = MUST be verbose ONLY                                  ")
        print_error("                          Note : <verbose_flag> is optional                     ")
        print()
        return False
    
    print("reg_name parameter = %s" %reg_name)

    if reg_name == 'TACB_GLU_MTS_PS':
        reg_addr = REG_TACB_GLU_MTS_PS
        bit_range = '(17:0)'
        mask      = 0x3ffff
    elif reg_name == 'TACB_GLU_LED':
        reg_addr = REG_TACB_GLU_LED
        bit_range = '(2:0)'
        mask      = 0x3
    elif reg_name == 'TACB_GLU_MSEL':
        reg_addr = REG_TACB_GLU_MSEL
        bit_range = '(7:0)'
        mask      = 0xff
    elif reg_name == 'TACB_MTS_PWR_DIAG':
        reg_addr = REG_TACB_MTS_PWR_DIAG
        bit_range = '(1:0)'
        mask      = 0xffffffff
    else:
        print()
        print_error("* Error : Unknown register")
        return False

    tacb_glu_base_addr = get_tacb_pci_glu_base_addr()
    reg_addr = tacb_glu_base_addr + reg_addr

    data_wr = reg_value_wr
    print("\n* %s register write (@ addr = 0x%x) = 0x%x" %(reg_name, reg_addr, data_wr))
    reg_write(reg_addr, data_wr)
    
    reg_value = get_reg_value(reg_addr)
    print("\n* %s reg_value readback (@ addr = 0x%x) = 0x%x" %(reg_name, reg_addr, reg_value))
    return None
#
#********************************************************************************
@DIAG("TACB GLU registers readback values")
def t_tacb_glu_reg_rdbk(cmd):
#
# Note regarding TACB_GLU_MTS_PS register :
#   it is resetted when detecting hot plug activity on module_pres_b signal
# 
# Note regarding REG_TACB_MTS_PWR_DIAG register :
# TACB_MTS_PWR_EN_STATUS(31: 16) reflects real power enable values :
# those values depends on diag_mode value :
# I. if diag_mode = 0, TACB_MTS_PWR_DIAG values depends on module_pres_b signal :
#   I.1. if module_pres_b = '0' (i.e module present), 
#   TACB_MTS_PWR_DIAG(31: 16) = TACB_GLU_MTS_PS()
#   I.2. if module_pres_b = '1'(module absent), 
#   > they are = '0'
# II. if diag_mode = 1, whatever is module_pres_b value, :
#   > TACB_MTS_PWR_DIAG(31: 16) = TACB_GLU_MTS_PS()
#
#********************************************************************************
#
    try:
        if len(cmd.split(' ')) == 2:
            cmd_lgth = 2
            (command, reg_name) = cmd.split(' ')
            verbose = False
        else:
            cmd_lgth = 3
            (command, reg_name, verbose_flag) = cmd.split(' ')

            if verbose_flag == "verbose":
                verbose = True
            else:
                print_error("   Syntax error : 2nd arg must be : verbose")
                return False

        err_nb = True
        i = 0
        for elt in enumerate(tacb_glu_reg_name_list):
            #print("\nelt_%d = " %i, elt)
            if reg_name == elt[1]:
                err_nb = False
            i+=1

        if err_nb:
            print("\n")
            print_error("* Parameter error : reg_name = %s is not a correct register name" %reg_name)
            return False
    except:
        print()
        print_error("   Syntax error : Command must be : t_tacb_glu_reg_rdbk <reg_name>    ")
        print_error("   where <reg_name> is :                                              ")
        print_error("                         TACB_GLU_IP_VERSION                          ")
        print_error("                         TACB_GLU_SYNTH_DATE                          ")
        print_error("                         TACB_GLU_MTS_PS                              ")
        print_error("                         TACB_GLU_LED                                 ")
        print_error("                         TACB_GLU_MSEL                                ")
        print_error("                         TACB_MTS_PWR_DIAG                            ")
        return False

    if verbose:
        print("\n* reg_name is", reg_name)

    if reg_name == 'TACB_GLU_IP_VERSION':
        reg_addr = REG_TACB_GLU_IP_VERSION
        bit_range = '(31:0)'
        mask      = 0xffffffff
    elif reg_name == 'TACB_GLU_SYNTH_DATE':
        reg_addr = REG_TACB_GLU_SYNTH_DATE
        bit_range = '(31:0)'
        mask      = 0xffffffff
    elif reg_name == 'TACB_GLU_MTS_PS':
        reg_addr = REG_TACB_GLU_MTS_PS
        bit_range = '(31:0)'
        mask      = 0xffffffff
    elif reg_name == 'TACB_GLU_LED':
        reg_addr = REG_TACB_GLU_LED
        bit_range = '(31:0)'
        mask      = 0xffffffff
    elif reg_name == 'TACB_GLU_MSEL':
        reg_addr = REG_TACB_GLU_MSEL
        bit_range = '(31:0)'
        mask      = 0xffffffff
    elif reg_name == 'TACB_MTS_PWR_DIAG':
        reg_addr = REG_TACB_MTS_PWR_DIAG
        bit_range = '(31:0)'
        mask      = 0xffffffff
    else:
        print()
        print_error("* Error : Unknown register")
        return False

    tacb_glu_base_addr = get_tacb_pci_glu_base_addr()

    if verbose:
        print("* tacb_glu_base_addr = 0x%x\n" %tacb_glu_base_addr)
    else:
        print()

    reg_value = get_reg_value(tacb_glu_base_addr + reg_addr)
    
    reg_msg = "  read_data = "+reg_name+bit_range
    print(reg_msg)
    print("     > %s%s = 0x%x" %(reg_name, bit_range, (reg_value & mask)))

    if reg_name == 'TACB_GLU_IP_VERSION':
        version_major = (reg_value >> 16) & 0xffff
        version_minor = reg_value & 0xffff
    
        print("\n##############################################")
        print("FPGA revision: ", end='')
        print("%d.%d" %(version_major, version_minor))
        print("##############################################\n")

    elif reg_name == 'TACB_GLU_SYNTH_DATE':
        print("\n##############################################")
        print("FPGA Synthesis date: ", end='')
        # print(sd)
        d = (reg_value >> 27)
        M = ((reg_value >> 23) & 15)
        Y = ((reg_value >> 17) & 63)
        h = ((reg_value >> 12) & 31)
        m = ((reg_value >> 6) & 63)
        s = ((reg_value) & 63)
        print("%02d/%02d/20%02d %02d:%02d:%02d" % (d, M, Y, h, m, s))
        print("##############################################\n")

    elif reg_name == 'TACB_GLU_MTS_PS':
        enable_vee_12v8_bit0 = reg_value & 0x1
        enable_vdd_12v8_bit1 = (reg_value & 0x2) >> 1
        enable_vdd_5v_bit2   = (reg_value & 0x4) >> 2
        enable_vdd_3v3_bit3  = (reg_value & 0x8) >> 3
        enable_vdd_1v8_bit4  = (reg_value & 0x10) >> 4
        enable_vdd_5v8_bit5  = (reg_value & 0x20) >> 5
        enable_vee_5v8_bit6  = (reg_value & 0x40) >> 6
        enable_vin_bit7      = (reg_value & 0x80) >> 7
        enable_sync_bit8     = (reg_value & 0x100) >> 8
        
        fpga_en_clk80M_bit16  = (reg_value & 0x10000) >> 16
        mts_reset_b_bit17     = (reg_value & 0x20000) >> 17
        
        bit24                 = (reg_value & 0x1000000) >> 24
        
        bit28                 = (reg_value & 0x10000000) >> 28
        bit29                 = (reg_value & 0x20000000) >> 29
        bit30                 = (reg_value & 0x40000000) >> 30
        bit31                 = (reg_value & 0x80000000) >> 31
        
        if bit31:
            pres_msg1 = "=> Module Absent"
            pres_msg2 = "=> Module Absent : MTS power supplies CAN'T be enable in normal mode\
                          \n                   then they can't be measured\
                          \n                   => change to DIAG mode to measure them by launching following cmdes :\
                          \n                      t_tacb_glu_reg_wr TACB_MTS_PWR_DIAG-0x3 \
                          \n                      t_tacb_check_mts_ps 1"
        else:
            pres_msg1 = "=> Module Present"
            pres_msg2 = " Module Present : MTS power supplies CAN be enable in normal mode\
                          \n                   then they CAN be measured by launching following cmde :\
                          \n                      t_tacb_check_mts_ps 1"

        if bit30:
            pres_b_re_msg = "=> Module has been hot unplugged"
        else:
            pres_b_re_msg = "" 

        if bit29:
            pres_b_fe_msg = "=> Module has been hot plugged"
        else:
            pres_b_fe_msg = ""
        
        print("         - MTS_PS(0) = ENABLE_VEE_12V8_MTS = %d (R/W)" %enable_vee_12v8_bit0)
        print("         - MTS_PS(1) = ENABLE_VDD_12V8_MTS = %d (R/W)" %enable_vdd_12v8_bit1)
        print("         - MTS_PS(2) = ENABLE_VDD_5V_MTS   = %d (R/W)" %enable_vdd_5v_bit2)
        print("         - MTS_PS(3) = ENABLE_VDD_3V3_MTS  = %d (R/W)" %enable_vdd_3v3_bit3)
        print("")   
        print("         - MTS_PS(4) = ENABLE_VDD_1V8_MTS  = %d (R/W)" %enable_vdd_1v8_bit4)
        print("         - MTS_PS(5) = ENABLE_VDD_5V8_MTS  = %d (R/W)" %enable_vdd_5v8_bit5)
        print("         - MTS_PS(6) = ENABLE_VEE_5V8_MTS  = %d (R/W)" %enable_vee_5v8_bit6)
        print("         - MTS_PS(7) = ENABLE_VIN_MTS      = %d (R/W)" %enable_vin_bit7)
        print("")
        print("         - MTS_PS(8) = ENABLE_SYNC_MTS     = %d (R/W)" %enable_sync_bit8)
        print("")
        print("         - MTS_PS(16) = FPGA_EN_CLK80M     = %d (R/W)" %fpga_en_clk80M_bit16)
        print("         - MTS_PS(17) = MTS_RESET_B        = %d (R/W)" %mts_reset_b_bit17)
        print("")
        print("         - MTS_PS(28) = FORCE_MTS_RSTn              = %d (RO)" %bit28)
        print("         - MTS_PS(29) = FPGA_MOD_PRES_B_fe_detected = %d (RO) %s" %(bit29, pres_b_fe_msg))
        print("         - MTS_PS(30) = FPGA_MOD_PRES_B_re_detected = %d (RO) %s" %(bit30, pres_b_re_msg))
        print("         - MTS_PS(31) = FPGA_MOD_PRES_B             = %d (RO) %s" %(bit31, pres_msg1))
        
        diag_value = get_reg_value(tacb_glu_base_addr + REG_TACB_MTS_PWR_DIAG)
        diag_bit0 = diag_value & 0x1
        diag_bit1 = (diag_value & 0x2) >> 1

        print("")
        print("* Note1 : MTS_PWR_DIAG_FLAG = %d (RW)" %diag_bit0)
        print("          MTS_PWR_EN_DIAG   = %d (RW)" %diag_bit1)
        
        print("\n*%s" %pres_msg2)

        print("\n* Note2 : launch pydiag cmd : t_tacb_glu_reg_rdbk TACB_MTS_PWR_DIAG")
        print("          to see real MTS pwr_en values" )

    elif reg_name == 'TACB_GLU_LED':
        bit0 = reg_value & 0x1
        bit1 = (reg_value & 0x2) >> 1
        bit2 = (reg_value & 0x4) >> 1

        print("         - FP_LED_GREEN (bit0) = %d (R/W)" %bit0)
        print("         - FP_LED_RED   (bit1) = %d (R/W)" %bit1)
        print("         - USE_ZYNQ_I2CAS_I2C_SOL (bit2) = %d (R/W)" %bit2)

    elif reg_name == 'TACB_GLU_MSEL':
        bit0_to_4 = reg_value & 0x1f
        bit5      = (reg_value & 0x20) >> 5
        bit7      = (reg_value & 0x80) >> 7
        bit8      = (reg_value & 0x100) >> 8
        bit9      = (reg_value & 0x200) >> 9
        bit30     = (reg_value & 0x40000000) >> 30
        bit31     = (reg_value & 0x80000000) >> 31
        
        print("         - MSEL_NB_NOR_CS (4:0) = 0x%x (R/W)" %bit0_to_4)
        print("         - MSEL_START    (bit5) = %d (R/W)" %bit5)
        print("         - USE_ZYNQ_I2C_AS_I2C_SOLUTION (bit7) = %d (R/W)" %bit7)
        print("         - MSEL_STATUS (bit8) = %d (RO)" %bit8)
        print("         - MTS_OUT_LOC (bit9) = %d (RO)" %bit9)
        print("         - MTS_IRQ_B (bit31)  = %d (RO)" %bit31)

    elif reg_name == 'TACB_MTS_PWR_DIAG':
        bit0 = reg_value & 0x1
        bit1 = (reg_value & 0x2) >> 1
        
        bit16 = (reg_value & 0x10000) >> 16
        bit17 = (reg_value & 0x20000) >> 17
        bit18 = (reg_value & 0x40000) >> 18
        bit19 = (reg_value & 0x80000) >> 19
        
        bit20 = (reg_value & 0x100000) >> 20
        bit21 = (reg_value & 0x200000) >> 21
        bit22 = (reg_value & 0x400000) >> 22
        bit23 = (reg_value & 0x800000) >> 23
        
        bit24 = (reg_value & 0x1000000) >> 24
        
        print("         - MTS_PWR_DIAG_FLAG (bit0) = %d (RW)" %bit0)
        print("         - MTS_PWR_EN_DIAG (bit1)   = %d (RW)" %bit1)
        
        print("         - MTS_PS_VLD(0) = VEE_12V8_MTS_EN = %d (R/W)" %bit16)
        print("         - MTS_PS_VLD(1) = VDD_12V8_MTS_EN = %d (R/W)" %bit17)
        print("         - MTS_PS_VLD(2) = VDD_5V_MTS_EN   = %d (R/W)" %bit18)
        print("         - MTS_PS_VLD(3) = VDD_3V3_MTS_EN  = %d (R/W)" %bit19)
        print("")   
        print("         - MTS_PS_VLD(4) = VDD_1V8_MTS_EN  = %d (R/W)" %bit20)
        print("         - MTS_PS_VLD(5) = VDD_5V8_MTS_EN  = %d (R/W)" %bit21)
        print("         - MTS_PS_VLD(6) = VEE_5V8_MTS_EN  = %d (R/W)" %bit22)
        print("         - MTS_PS_VLD(7) = VIN_MTS_EN      = %d (R/W)" %bit23)
        print("")
        print("         - MTS_PS_VLD(8) = SYNC_MTS_EN     = %d (R/W)" %bit24)
    else:
        pass

    return None
#
#***************************************************
@DIAG("TACB BDT registers write access")
def t_tacb_bdt_reg_wr(cmd):
#***************************************************
#
    try:
        if len(cmd.split(' ')) == 2:
            cmd_lgth = 2
            (command, consigne) = cmd.split(' ')
            verbose = False
        else:
            cmd_lgth = 3
            (command, consigne, verbose_flag) = cmd.split(' ')
            
            if verbose_flag == "verbose":
                verbose = True
            else:
                print_error("   Syntax error : 2nd arg must be : verbose")
                return False

        (reg_name, reg_value_str) = consigne.split('-')
        reg_value_wr = int(reg_value_str, base=16)
    
    except:
        print()
        print_error("   Syntax error : Command must be : t_tacb_bdt_reg_wr <consigne> <verbose>     ")
        print_error("   where <consigne is : <reg_name>-<reg_value>                                 ")
        print_error("                                                                               ")
        print_error("                        <reg_name> is :                                        ")
        print_error("                           TACB_TEETH_NUMBER                                   ")
        print_error("                           TACB_XOFFSET_DURATION                               ")
        print_error("                           TACB_MASK_DURATION                                  ")
        print_error("                           TACB_WAIT_DURATION                                  ")
        print_error("                           TACB_NOISE_DURATION                                 ")
        print_error("                           TACB_AVG_NUMBER                                     ")
        print_error("                           TACB_RAMP_INCR                                      ")
        print_error("                           TACB_SPI_STEP_VAL                                   ")
        print_error("                                                                               ")
        print_error("                       <reg_value> is : hexa data value to write into register ")
        print_error("                                                                               ")
        print_error("         <verbose_flag> = MUST be verbose ONLY                                 ")
        print_error("                          Note : <verbose_flag> is optional                    ")
        print()
        return False
    
    print("reg_name parameter = %s" %reg_name)
    
    reg_name = "TACB_SPI_STEP_VAL"

    tacb_bdt_base_addr = get_tacb_pci_bdt_base_addr()
    reg_addr = tacb_bdt_base_addr + REG_TACB_SPI_STEP_VAL

    data_wr = reg_value_wr
    print("\n* %s register write = 0x%x" %(reg_name, data_wr))
    reg_write(reg_addr, data_wr)
    
    reg_value = get_reg_value(reg_addr)
    print("\n* %s reg_value readback (@ addr = 0x%x) = 0x%x" %(reg_name, reg_addr, reg_value))

    return None
#
#********************************************
@DIAG("TACB BDT registers read access")
def t_tacb_bdt_reg_rdbk(cmd):
#********************************************
#
    try:
        if len(cmd.split(' ')) == 2:
            cmd_lgth = 2
            (command, reg_name) = cmd.split(' ')
            verbose = False
        else:
            cmd_lgth = 3
            (command, reg_name, verbose_flag) = cmd.split(' ')

            if verbose_flag == "verbose":
                verbose = True
            else:
                print_error("   Syntax error : 2nd arg must be : verbose")
                return False

        err_nb = True
        i = 0
        for elt in enumerate(tacb_seq_core_reg_name_list):
            #print("\nelt_%d = " %i, elt)
            if reg_name == elt[1]:
                err_nb = False
            i+=1
        if err_nb:
            print("\n")
            print_error("* Parameter error : reg_name = %s is not a correct register name" %reg_name)
            return False
    except:
        print()
        print_error("   Syntax error : Command must be : t_tacb_bdt_reg_rdbk <reg_name>    ")
        print_error("   where <reg_name> is :                                              ")
        print_error("                         TACB_TEETH_NUMBER                            ")
        print_error("                         TACB_XOFFSET_DURATION                        ")
        print_error("                         TACB_MASK_DURATION                           ")
        print_error("                         TACB_WAIT_DURATION                           ")
        print_error("                         TACB_NOISE_DURATION                          ")
        print_error("                         TACB_AVG_NUMBER                              ")
        print_error("                         TACB_RAMP_INCR                               ")
        print_error("                         TACB_RAMP_RST_VAL                            ")
        print_error("                         TACB_COMB_NUMBER                             ")
        print_error("                         REG_TACB_COMB_INCR                           ")
        print_error("                         TACB_MISC                                    ")
        print_error("                         TACB_HW_CFG                                  ")
        print_error("                         TACB_TOT_TEETH_NB_CALC                       ")
        print_error("                         TACB_RECUR_PRIME_NB                          ")
        print_error("                         TACB_FSM_STATE_DBG                           ")
        print_error("                         TACB_SPI_STEP_VAL                            ")
        print_error("                         TACB_SEQ_CORE_IP_VERSION                     ")
        print_error("                                                                      ")
        print_error("       <verbose_flag> = MUST be verbose ONLY                          ")
        print_error("                        Note : <verbose_flag> is optional             ")
        print()
        return False

    if verbose:
        print("\nreg_name is", reg_name)

    if reg_name == 'TACB_TEETH_NUMBER':
        reg_addr = REG_TACB_TEETH_NUMBER
    elif reg_name == 'TACB_XOFFSET_DURATION':
        reg_addr = REG_TACB_XOFFSET_DURATION
    elif reg_name == 'TACB_MASK_DURATION':
        reg_addr = REG_TACB_MASK_DURATION
    elif reg_name == 'TACB_WAIT_DURATION':
        reg_addr = REG_TACB_WAIT_DURATION
    elif reg_name == 'TACB_NOISE_DURATION':
        reg_addr = REG_REG_TACB_NOISE_DURATION
    elif reg_name == 'TACB_AVG_NUMBER':
        reg_addr = REG_TACB_AVG_NUMBER
    elif reg_name == 'TACB_RAMP_INCR':
        reg_addr = REG_TACB_RAMP_INCR
    elif reg_name == 'TACB_RAMP_RST_VAL':
        reg_addr = REG_TACB_RAMP_RST_VAL
    elif reg_name == 'TACB_COMB_NUMBER':
        reg_addr = REG_TACB_COMB_NUMBER
    elif reg_name == 'TACB_COMB_INCR':
        reg_addr = REG_TACB_COMB_INCR
    elif reg_name == 'TACB_MISC':
        reg_addr = REG_TACB_MISC
    elif reg_name == 'TACB_HW_CFG':
        reg_addr = REG_TACB_HW_CFG
    elif reg_name == 'TACB_TOT_TEETH_NB_CALC':
        reg_addr = REG_TACB_TOT_TEETH_NB_CALC
    elif reg_name == 'TACB_FORCE_COMB_ID':
        reg_addr = REG_TACB_FORCE_COMB_ID
    elif reg_name == 'TACB_RECUR_PRIME_NB':
        reg_addr = REG_TACB_RECUR_PRIME_NB
    elif reg_name == 'TACB_FSM_STATE_DBG':
        reg_addr = REG_TACB_FSM_STATE_DBG
    elif reg_name == 'TACB_SPI_STEP_VAL':
        reg_addr = REG_TACB_SPI_STEP_VAL
    elif reg_name == 'TACB_SEQ_CORE_IP_VERSION':
        reg_addr = REG_TACB_SEQ_CORE_IP_VERSION
    else:
        print()
        print_error("* Error : Unknown register")
        return False

    # if is_dtss_fpga_present() == True:
    #     pass
    # else:
    #     return False

    tacb_bdt_base_addr = get_tacb_pci_bdt_base_addr()
    reg_value = get_reg_value(tacb_bdt_base_addr + reg_addr)
    print("\n* %s reg_value read (@ addr = 0x%x) = 0x%x" %(reg_name, reg_addr, reg_value))

    if verbose:
        show_tacb_bdt_reg_contents(reg_name, reg_value)

    return None
#
#*****************************************
@DIAG("OSB TACB bdt register check")
def t_tacb_bdt_reg_check(cmd):
#*****************************************
#
    verbose = False

    reg_name  = []
    reg_addr  = []
    reg_range = []

    for elt in enumerate(tacb_seq_core_reg_name_list):
        reg_name.append(elt[1])

    for elt in enumerate(tacb_seq_core_reg_addr_list):
        reg_addr.append(elt[1])

    for elt in enumerate(tacb_seq_core_reg_range_list):
        reg_range.append(elt[1])

    print("")

    tacb_bdt_base_addr = get_tacb_pci_bdt_base_addr()
    print("* tacb_bdt_base_addr = 0x%x\n" %tacb_bdt_base_addr)
    
    i = 0
    while i < len(reg_name):
        addr = tacb_bdt_base_addr + reg_addr[i]
        reg_value = get_reg_value(addr)

        print("* TACB %s%s read (@ addr 0x%x) = 0x%x" %(reg_name[i], reg_range[i], reg_addr[i], reg_value))

        if verbose:
            show_tacb_bdt_reg_contents(reg_name[i], reg_value)

        i += 1
    
    return None

