from viavi.evm import *
from viavi.diag import *
import viavi.mts.uts_spi as utsspi
import viavi.mts.uts_bdt as usbdt  # /usr/lib/python3.8/site-packages/viavi/mts/uts_bdt.py
import time, os
import smbus
import serial

import subprocess
from datetime import datetime

from viavi.mts.fth_reg_def import *


DIAG_VERSION        = "2.0"

#
#*********************************************************************************************
# Pydiag procedures
#*********************************************************************************************
#
#=============================================================================================
def i2c_table_parser(FileName, debug):
#=============================================================================================
#
    i2c_detected_list = []

    with open(FileName,'r') as tmpfile:
        for line in tmpfile.readlines():
            col = 0
            if ':' in line:
                (addr_list, data_list) = line.split(': ')
                if debug:
                    print("* addr = ", addr_list, " ; data_list = ", data_list)

                var = data_list.split(' ')
                if debug:
                    print("     - var = ", var, " ; length = %d" %len(var))

                if len(var) > 17:
                    j = 0
                    var1 = []
                    while j < len(var):
                        if var[j] == '':
                            var1.append('  ')
                            j += 2
                        else:
                            var1.append(var[j])
                        j += 1

                    var = var1

                    if debug:
                        print("         > var1 = ", var1, " ; length = %d" %len(var1))
                        print("         > var  = ", var, " ; length = %d" %len(var))

                for elt in enumerate (var):
                    if elt[1] != '  ' and elt[1] != '--' and  elt[1] != '\n':
                        if debug:
                            print("     - elt[%d][%d]" %(int(addr_list), col), "= %s" %elt[1])
                            print("     - elt[%X][%x]" %(int(addr_list, base=16), col), "= %s" %elt[1])

                        i2c_addr = int(addr_list, base=16) + col
                        i2c_addr_h = "%x" %i2c_addr

                        i2c_detected_list.append(i2c_addr_h)
                    col += 1

    tmpfile.close()

    return i2c_detected_list
#
#**********************************************************************************************
#************************ OSB Fan functionalities *********************************************
#**********************************************************************************************
#
#=============================================================================================
#
# find the correspondance of hwmon<x> drivers and fan positions, knowing that :
#
# lateral_fan1 is @ REAR position and is controlled by REG_SYS_FAN1_CTRL register
# lateral_fan0 is @ MIDDLE position and is controlled by REG_SYS_FAN2_CTRL register
# lateral_fan2 is @ FRONT position and is controlled by REG_SYS_FAN3_CTRL register
#
#=============================================================================================
#
#=============================================================================================
@DIAG("OSB : functional fans test")
def t_osb_func_fans_test(cmd):
#=============================================================================================
#
    error_flag = False
    debug = 0

    try:
        (command, consigne) = cmd.split()

        if len(consigne.split('-')) == 2:
            consigne_lgth = 2
            (fan_localisation, verbose_flag) = consigne.split('-')
        else:
            consigne_lgth = 1
            fan_localisation = consigne

        if fan_localisation == "LATERAL" or fan_localisation == "FRONT_PANEL":
            print_info("fan_localisation is %s" %fan_localisation)
            if fan_localisation == "LATERAL":
                res_consigne = 6
            elif fan_localisation == "FRONT_PANEL":
                res_consigne = 4
            else:
                res_consigne = 10
        else:
            print_error("* Parameter Error : fan_localisation %s is an incorrect value : \
                                             MUST be LATERAL or FRONT_PANEL" %fan_localisation)
            error_flag = True

        if consigne_lgth == 2:
            if verbose_flag == "verbose":
                verbose = True
            else:
                print_error("*   Parameter error : 2nd arg must be : verbose")
                error_flag = True
        else:
            verbose = False

        if error_flag:
            return False

    except:
        print_error("   Syntax error : Command must be : t_osb_func_fans_test <consigne> ")
        print_error("                                                                    ")
        print_error("   where <consigne> is : <FAN_LOCALISATION> <verbose_flag>          ")
        print_error("                                                                    ")
        print_error("   With                : <FAN_LOCALISATION> = LATERAL|FRONT_PANEL   ")
        print_error("                                                                    ")
        print_error("                       : <verbose_flag> = MUST be verbose ONLY      ")
        print_error("                         Note : <verbose_flag> is optional          ")
        print()
        return False

    fan_topo_list = OSB_fan_topology()  # OSB_fan_topology fct : see fth_reg_def.py

    if verbose:
        print ("\n* fan_topo_list is ", fan_topo_list, "\n")

    if len(fan_topo_list) == 0:
        print_error("* Error : Fan topology CAN'T be extracted")
        return False

    print("")

    enable_list = []
    driver_list = []
    fan_list = []
    position_list = []
    osb_fpga_pwm_reg_list = []

    glu_reg_base_addr = get_glu_base_addr()

    if fan_localisation == "FRONT_PANEL":

        psu_ctrl_value = get_reg_value(glu_reg_base_addr + REG_PSU_CTRL)
        psu_mask_FAN_12V = 0x200

        if (psu_ctrl_value  & psu_mask_FAN_12V) == psu_mask_FAN_12V:
            psu_currently_en = 'Yes'
            print("=> FAN_12V is currently enable (psu_ctrl_value = 0x%x" %psu_ctrl_value+")")
        else:
            psu_currently_en = 'No'
            print("=> FAN_12V need to be enable (psu_ctrl_value = 0x%x" %psu_ctrl_value+")")
            data_val = psu_ctrl_value | psu_mask_FAN_12V
            reg_write(glu_reg_base_addr + REG_PSU_CTRL, data_val)
            time.sleep(0.5)

    i = 0
    for elt in enumerate(fan_topo_list):
        if debug:
            print("elt_%d = " %i, elt)
        if i == 0 or i%2 == 0:
            driver_list.append(elt[1])
        else:
            fan_list.append(elt[1])
            if "fan0" in elt[1]:
                position_list.append("REAR")
                osb_fpga_pwm_reg_list.append(REG_SYS_FAN1_CTRL)
                if fan_localisation == "LATERAL":
                    enable_list.append("FAN_EN")
                else:
                    enable_list.append("FAN_DIS")
            elif "fan1" in elt[1]:
                position_list.append("MIDDLE")
                if fan_localisation == "LATERAL":
                    enable_list.append("FAN_EN")
                else:
                    enable_list.append("FAN_DIS")
                osb_fpga_pwm_reg_list.append(REG_SYS_FAN2_CTRL)
            elif "fan2" in elt[1]:
                position_list.append("FRONT")
                if fan_localisation == "LATERAL":
                    enable_list.append("FAN_EN")
                else:
                    enable_list.append("FAN_DIS")
                osb_fpga_pwm_reg_list.append(REG_SYS_FAN3_CTRL)
            elif "fan4" in elt[1]:
                position_list.append("RIGHT")
                if fan_localisation == "FRONT_PANEL":
                    enable_list.append("FAN_EN")
                else:
                    enable_list.append("FAN_DIS")
                osb_fpga_pwm_reg_list.append(REG_OSB_FAN2_CTRL)
            else:
                position_list.append("LEFT")
                if fan_localisation == "FRONT_PANEL":
                    enable_list.append("FAN_EN")
                else:
                    enable_list.append("FAN_DIS")
                osb_fpga_pwm_reg_list.append(REG_OSB_FAN1_CTRL)

        if debug:
            print("driver_list is", driver_list)
            print("fan_list is", fan_list)
            print("position_list is", position_list)

        i += 1

    res = 0

    temp_cmde = "/sys/class/thermal/thermal_zone0/emul_temp"
    temp_value_str = "50000"
    if verbose:
        print("sys_cmde is :", "echo "+temp_value_str+" > "+temp_cmde)

    sysfs_write(temp_cmde, temp_value_str)

    time.sleep(5)

    temp_cmde = "/sys/class/thermal/thermal_zone0/emul_temp"
    temp_value_str = "79000"
    if verbose:
        print("sys_cmde is :", "echo "+temp_value_str+" > "+temp_cmde)

    sysfs_write(temp_cmde, temp_value_str)

    time.sleep(3)

    i = 0
    while i < 5:
        hwmon_val = driver_list[i]
        fan_num   = fan_list[i]
        position  = position_list[i]

        if enable_list[i] == 'FAN_EN' :
            if debug:
                print("\nhwmon_val[%d] :" %i, hwmon_val)
                print("fan_num[%d]     :" %i, fan_num)
                print("position[%d]    :" %i, position)
                print("enable_list[%d] :" %i, enable_list[i])

            pwm_reg_value = get_reg_value(glu_reg_base_addr + osb_fpga_pwm_reg_list[i])
            speed_percent = pwm_reg_value & 0xff
            #print("     *", fan_num, "(", position, ")", "pwm_reg_value   = 0x%x (%d" %(pwm_reg_value, speed_percent), "%)")

            fan_tachi_cmde = "/sys/platform/osb_tachi/"+fan_num
            if verbose:
                print("sys_cmde is :", "cat "+fan_tachi_cmde)

            tachi_value = sysfs_read(fan_tachi_cmde)
            tachi_value_str = sysfs_read_string(fan_tachi_cmde)

            display_message = "     * "+fan_num+" ("+position+") pwm_speed = "+str(speed_percent)+"% : tachi_value is "+tachi_value_str+":"

            if tachi_value > 0x120:
                res += 1
                ret_message = display_message+" PASS"
                print_ok(ret_message)
            else:
                msg = " FAIL"
                ret_message = display_message+" FAIL"
                print_error(ret_message)

        i += 1

    temp_value_str = "50000"
    if verbose:
        print("sys_cmde is :", "echo "+temp_value_str+" > "+temp_cmde)
    sysfs_write(temp_cmde, temp_value_str)

    time.sleep(7)

    temp_value_str = "25000"
    if verbose:
        print("sys_cmde is :", "echo "+temp_value_str+" > "+temp_cmde)
    sysfs_write(temp_cmde, temp_value_str)

    time.sleep(7)

    temp_value_str = "10000"
    if verbose:
        print("sys_cmde is :", "echo "+temp_value_str+" > "+temp_cmde)
    sysfs_write(temp_cmde, temp_value_str)

    time.sleep(7)

    i = 0
    while i < 5:
        hwmon_val = driver_list[i]
        fan_num   = fan_list[i]
        position  = position_list[i]

        if enable_list[i] == 'FAN_EN' :

            pwm_reg_value = get_reg_value(glu_reg_base_addr + osb_fpga_pwm_reg_list[i])
            speed_percent = pwm_reg_value & 0xff
#           print("     *", fan_num, "(", position, ")", "pwm_reg_value   = 0x%x (%d" %(pwm_reg_value, speed_percent), "%)")

            fan_tachi_cmde = "/sys/platform/osb_tachi/"+fan_num
            if verbose:
                print("sys_cmde is :", "cat "+fan_tachi_cmde)

            tachi_value = sysfs_read(fan_tachi_cmde)
            tachi_value_str = sysfs_read_string(fan_tachi_cmde)

            display_message = "     * "+fan_num+" ("+position+") pwm_speed = "+str(speed_percent)+"% : tachi_value is "+tachi_value_str+":"

            if tachi_value > 0x50 and tachi_value < 0x120:
                res += 1
                ret_message = display_message+" PASS"
                print_ok(ret_message)
            else:
                ret_message = display_message+" FAIL"
                print_error(ret_message)

        i += 1

    # Set PWM value @ 25%

    fan_pwm_value_str = "64"
    i = 0
    while i < 5:
        fan_pwm_cmde = "/sys/class/hwmon/"+driver_list[i]+"/pwm1"
        if verbose:
            print("* sys_cmde is :", "echo "+fan_pwm_value_str+" > "+fan_pwm_cmde)
        sysfs_write(fan_pwm_cmde, fan_pwm_value_str)

        i += 1

    if debug:
        print("* res = ", res)

    if res == res_consigne:
        ret_flag = True
    else:
        ret_flag = False

    return ret_flag
#
#================================================================================
@DIAG("B200 : peripheral fans Test")
def t_osb200_periph_fans_test(cmd):
#================================================================================
#
# Module board MUST be set to 2 (SWITCH board selected) to run this test
#
#  REAR   = Fan1 : Measured with cAddress_SyncMeas1LSB/cAddress_SyncMeas1MSB
#  MIDDLE = Fan2 : Measured with cAddress_SyncMeas2LSB/cAddress_SyncMeas2MSB
#  FRONT  = Fan3 : Measured with cAddress_SyncMeas3LSB/cAddress_SyncMeas3MSB
#
#  pwm1_duty_value = 0x70000 + fan1_pwm_value   => meas = 0x420
#  pwm1_duty_value = 0x90000 + fan1_pwm_value   => meas = 0x528
#  pwm1_duty_value = 0xb0000 + fan1_pwm_value   => meas = 0x630
#
#  PWM_reg = x"0" & PWM_DIV(11:0) & (x"00" & '0' & PWM_DUTY(6:0)
#
    try:
        if ' ' not in cmd:
            verbose = False
        else:
            (command,consigne) = cmd.split()
            if consigne == "verbose":
                verbose = True
            else:
                print()
                print_error("*   Parameter error : arg must be : verbose")
                print()
                return False

    except:
        print_error("   Syntax error : Command must be : t_osb200_periph_fans_test <verbose_flag> ")
        print_error("                                                                             ")
        print_error("                  with <verbose_flag> = MUST be verbose ONLY                 ")
        print_error("                        Note : <verbose_flag> is optional                    ")
        print_error("                                                                             ")
        return False

    return_flag = True
    error_nb = 0

    glu_reg_base_addr = get_glu_base_addr()
    b200_module_type_set("SWITCH", verbose)

    # pwrside
    side = 0
    slice = B200_SLICE
    if (os.path.exists("/dev/uts_spi")):
        Utsspi = utsspi.SpiModule(side, slice, "/dev/uts_spi")
    else:
        print("Utsspi driver (/dev/uts_spi) not found")
        return False

    fan1_pwm_value = 0x1e
    fan2_pwm_value = 0x32
    fan3_pwm_value = 0x4b
    fan1_ctrl_value = 0x90000 + fan1_pwm_value
#   fan1_ctrl_value = 0xb0000 + fan1_pwm_value

    fan2_ctrl_value = 0xc0000 + fan2_pwm_value
#   fan2_ctrl_value = 0x70000 + fan3_pwm_value

    fan3_ctrl_value = 0xd0000 + fan3_pwm_value
#   fan3_ctrl_value = 0x90000 + fan1_pwm_value

    periph_reset_gen("release", verbose)

    if verbose:
        value = Utsspi.read_mod_register8(SPI_ADDR_MISC)
        print(" Read cAddress_Misc reg. value @ 0x%1x after reset : 0x%x" %(SPI_ADDR_MISC, value))

        show_z112_B200_misc_reg_contents()
        
    # fan_position = "REAR"
    reg_write(glu_reg_base_addr + REG_SYS_FAN1_CTRL, fan1_ctrl_value)
    sys_fan1_tachi_value = get_reg_value(glu_reg_base_addr + REG_SYS_FAN1_TACHI_VAL)

    # fan_position = "MIDDLE"
    reg_write(glu_reg_base_addr + REG_SYS_FAN2_CTRL, fan2_ctrl_value)
    sys_fan2_tachi_value = get_reg_value(glu_reg_base_addr + REG_SYS_FAN2_TACHI_VAL)

    # fan_position = "FRONT"
    reg_write(glu_reg_base_addr + REG_SYS_FAN3_CTRL, fan3_ctrl_value)
    sys_fan3_tachi_value = get_reg_value(glu_reg_base_addr + REG_SYS_FAN3_TACHI_VAL)

    time.sleep(1)

    # Set misc_reg(4) = '1' to launch the measure
    #
    wr_data = 0x10
    if verbose:
        print("* Write data = 0x%x into cAddress_Misc reg (@ addr 0x%1x ) : " %(wr_data, SPI_ADDR_MISC))

    ver = Utsspi.write_mod_register8(SPI_ADDR_MISC, wr_data)

    if verbose:
        value = Utsspi.read_mod_register8(SPI_ADDR_MISC)
        print(" Read cAddress_Misc reg. value @ 0x%1x after launching measure: 0x%x" %(SPI_ADDR_MISC, value))

        show_z112_B200_misc_reg_contents()

    time.sleep(1)

    # fan1 measure :

    fan1_lsb_value = Utsspi.read_mod_register8(SPI_ADDR_SYNC_MEAS1_LSB)
    fan1_msb_value = Utsspi.read_mod_register8(SPI_ADDR_SYNC_MEAS1_MSB)

    fan1_val = (float(fan1_msb_value) * 256) + float(fan1_lsb_value)
    fan1_period = (fan1_val * 30.3)/1000000000

    if fan1_period == 0.0:
        fan1_freq = 0.0
    else:
        fan1_freq = 1.0/fan1_period

    if fan1_freq > 24000.0 and fan1_freq < 25100.0:
        msg = "PASS"
    else:
        msg = "FAIL"
        error_nb += 1

    print(" - fan1 PWM frequency = %5.3fHz : %s" %(fan1_freq, msg))

    sys_fan1_tachi_value = get_reg_value(glu_reg_base_addr + REG_SYS_FAN1_TACHI_VAL)
#   print("     => sys_fan1_tachi_value read = 0x%x" % sys_fan1_tachi_value)
    fan1_tachi = float(sys_fan1_tachi_value)

    if fan1_tachi > 24000.0 and fan1_tachi < 25100.0:
        msg = "PASS"
    else:
        msg = "FAIL"
        error_nb += 1

    print(" - fan1 TACHI frequency = %5.3fHz : %s" %(fan1_tachi, msg))

    # fan2 measure :

    fan2_lsb_value = Utsspi.read_mod_register8(SPI_ADDR_SYNC_MEAS2_LSB)
    fan2_msb_value = Utsspi.read_mod_register8(SPI_ADDR_SYNC_MEAS2_MSB)

    fan2_val = (float(fan2_msb_value) * 256) + float(fan2_lsb_value)
    fan2_period = (fan2_val * 30.3)/1000000000

    if fan2_period == 0.0:
        fan2_freq = 0.0
    else:
        fan2_freq = 1.0/fan2_period

    if fan2_freq > 19100.0 and fan2_freq < 19300.0:
        msg = "PASS"
    else:
        msg = "FAIL"
        error_nb += 1

    print(" - fan2 PWM frequency = %5.3fHz : %s" %(fan2_freq, msg))

    sys_fan2_tachi_value = get_reg_value(glu_reg_base_addr + REG_SYS_FAN2_TACHI_VAL)
#   print("     => sys_fan2_tachi_value read = 0x%x" % sys_fan2_tachi_value)
    fan2_tachi = float(sys_fan2_tachi_value)

    if fan2_tachi > 19100.0 and fan2_tachi < 19300.0:
        msg = "PASS"
    else:
        msg = "FAIL"
        error_nb += 1

    print(" - fan2 TACHI frequency = %5.3fHz : %s" %(fan2_tachi, msg))

    # fan3 measure :

    fan3_lsb_value = Utsspi.read_mod_register8(SPI_ADDR_SYNC_MEAS3_LSB)
    fan3_msb_value = Utsspi.read_mod_register8(SPI_ADDR_SYNC_MEAS3_MSB)

    fan3_val = (float(fan3_msb_value) * 256) + float(fan3_lsb_value)
    fan3_period = (fan3_val * 30.3)/1000000000

    if fan3_period == 0.0:
        fan3_freq = 0.0
    else:
        fan3_freq = 1.0/fan3_period

    if fan3_freq > 17700.0 and fan3_freq < 17900.0:
        msg = "PASS"
    else:
        msg = "FAIL"
        error_nb += 1

    print(" - fan3 PWM frequency = %5.3fHz : %s" %(fan3_freq, msg))

    sys_fan3_tachi_value = get_reg_value(glu_reg_base_addr + REG_SYS_FAN3_TACHI_VAL)
#   print("     => sys_fan3_tachi_value read = 0x%x" % sys_fan3_tachi_value)
    fan3_tachi = float(sys_fan3_tachi_value)

    if fan3_tachi > 17700.0 and fan3_tachi < 17900.0:
        msg = "PASS"
    else:
        msg = "FAIL"
        error_nb += 1

    print(" - fan3 TACHI frequency = %5.3fHz : %s" %(fan3_tachi, msg))

    wr_data = 0x00
    if verbose:
        print("\n* Write data = 0x%x into cAddress_Misc reg (@ addr 0x%1x ) : " %(wr_data, SPI_ADDR_MISC))

    ver = Utsspi.write_mod_register8(SPI_ADDR_MISC, wr_data)

    if verbose:
        value = Utsspi.read_mod_register8(SPI_ADDR_MISC)
        print(" Read cAddress_Misc reg. value @ 0x%1x: 0x%x" %(SPI_ADDR_MISC, value))

        show_z112_B200_misc_reg_contents()

#   print(" error_nb = %d" %error_nb)

    if error_nb > 0:
        return_flag = False

    return return_flag
#
#================================================================================
@DIAG("B200 : OSB front panel fans test")
def t_osb200_front_fans_test(cmd):
#================================================================================
#
#  osb_fan_1 (LEFT) , osb_fan_2 (RIGHT)
#
# OSB_FAN1_PWM              :
# OSB_FAN2_PWM              :
#
    try:
        if ' ' not in cmd:
            verbose = False
        else:
            (command, consigne) = cmd.split()
            if consigne == "verbose":
                verbose = True
            else:
                print_error("*   Parameter error : arg must be : verbose")
                print()
                return False

    except:
        print_error("   Syntax error : Command must be : t_osb200_front_fans_test <verbose_flag> ")
        print_error("                                                                            ")
        print_error("                  <verbose_flag> = MUST be verbose ONLY                     ")
        print_error("                        Note : <verbose_flag> is optional                   ")
        print_error("                                                                            ")
        print()
        return False

    # pwrside
    side = 0
    slice = B200_SLICE
    if (os.path.exists("/dev/uts_spi")):
        Utsspi = utsspi.SpiModule(side, slice, "/dev/uts_spi")
    else:
        print("Utsspi driver (/dev/uts_spi) not found")
        return False

    b200_module_type_set("SWITCH", verbose)

    error_nb = 0

    glu_reg_base_addr = get_glu_base_addr()

    fan1_pwm_value = 0x1e
    fan2_pwm_value = 0x32
    osb_fan1_ctrl_value = 0x90000 + fan1_pwm_value
#   osb_fan1_ctrl_value = 0xb0000 + fan1_pwm_value

    osb_fan2_ctrl_value = 0xc0000 + fan2_pwm_value
#   osb_fan2_ctrl_value = 0x70000 + fan3_pwm_value

    periph_reset_gen("release", verbose)

    # fan_position = "RIGHT"
    reg_write(glu_reg_base_addr + REG_SYS_FAN1_CTRL, osb_fan1_ctrl_value)
    sys_fan1_tachi_value = get_reg_value(glu_reg_base_addr + REG_OSB_FAN1_CTRL)

    # fan_position = "LEFT"
    reg_write(glu_reg_base_addr + REG_SYS_FAN2_CTRL, osb_fan2_ctrl_value)
    sys_fan2_tachi_value = get_reg_value(glu_reg_base_addr + REG_OSB_FAN2_CTRL)

    wr_data = 0x10
    if verbose:
        print("* Write data = 0x%x into cAddress_Misc reg @ addr 0x%1x : " %(wr_data, SPI_ADDR_MISC))

    ver = Utsspi.write_mod_register8(SPI_ADDR_MISC, wr_data)

    if verbose:
        value = Utsspi.read_mod_register8(SPI_ADDR_MISC)
        print(" Read cAddress_Misc reg. value @ 0x%1x after launching measure: 0x%x" %(SPI_ADDR_MISC, value))

        show_z112_B200_misc_reg_contents()

    time.sleep(1)

    # osb_fan1 measure :

    osb_fan1_lsb_value = Utsspi.read_mod_register8(SPI_ADDR_SYNC_MEAS5_LSB)
    osb_fan1_msb_value = Utsspi.read_mod_register8(SPI_ADDR_SYNC_MEAS5_MSB)

    osb_fan1_val = (float(osb_fan1_msb_value) * 256) + float(osb_fan1_lsb_value)
    osb_fan1_period = (osb_fan1_val * 30.3)/1000000000

    if osb_fan1_period == 0.0:
        osb_fan1_freq = 0.0
    else:
        osb_fan1_freq = 1.0/osb_fan1_period

    if osb_fan1_freq > 24000.0 and osb_fan1_freq < 25100.0:
        msg = "PASS"
        print_ok(" - fan1 PWM frequency = %5.3fHz : %s" %(osb_fan1_freq, msg))
    else:
        msg = "FAIL"
        print-error(" - fan1 PWM frequency = %5.3fHz : %s" %(osb_fan1_freq, msg))
        error_nb += 1

    # osb_fan2 measure :
    osb_fan2_lsb_value = Utsspi.read_mod_register8(SPI_ADDR_SYNC_MEAS6_LSB)
    osb_fan2_msb_value = Utsspi.read_mod_register8(SPI_ADDR_SYNC_MEAS6_MSB)

    osb_fan2_val = (float(osb_fan2_msb_value) * 256) + float(osb_fan2_lsb_value)
    osb_fan2_period = (osb_fan2_val * 30.3)/1000000000

    if osb_fan2_period == 0.0:
        osb_fan2_freq = 0.0
    else:
        osb_fan2_freq = 1.0/osb_fan2_period

    if osb_fan2_freq > 24000.0 and osb_fan2_freq < 25100.0:
        msg = "PASS"
        print_ok(" - fan2 PWM frequency = %5.3fHz : %s" %(osb_fan2_freq, msg))
    else:
        msg = "FAIL"
        print_error(" - fan2 PWM frequency = %5.3fHz : %s" %(osb_fan2_freq, msg))
        error_nb += 1

    wr_data = 0x00
    if verbose:
        print("\n* Write data = 0x%x into cAddress_Misc reg (@ addr 0x%1x ) : " %(wr_data, SPI_ADDR_MISC))

    ver = Utsspi.write_mod_register8(SPI_ADDR_MISC, wr_data)

    if verbose:
        value = Utsspi.read_mod_register8(SPI_ADDR_MISC)
        print(" Read cAddress_Misc reg. value @ 0x%1x: 0x%x" %(SPI_ADDR_MISC, value))

        show_z112_B200_misc_reg_contents()

    if error_nb > 0:
        return_flag = False
    else:
        return_flag = True

    return return_flag
#
#********************************
def osb_uart_mod_init (verbose):
#********************************

    glu_reg_base_addr = get_glu_base_addr()

    if verbose:
        print("glu_reg_base_addr = 0x%x" %glu_reg_base_addr, "\n")

    # Verify Internal Optical module present : MOD_PRESENCE_RDBK reg

    # MOD_PRESENCE_RDBK(0) = SWITCH_PRESENCE ( value = 1 => Switch_module present ; value = 0 => Switch_module absent)
    # MOD_PRESENCE_RDBK(1) = DTSS_PRESENCE   ( value = 1 => DTSS_module present   ; value = 0 => DTSS_module absent)
    # MOD_PRESENCE_RDBK(2) = DTSS_FPGA_READY ( value = 1 => DTSS_FPGA present ?   ; value = 0 => DTSS_FPGA absent ?)

    UART_BASE_ADDR = UART_MOD_BASE_ADDR

    if verbose:
        print("UART_BASE_ADDR = 0x%x" % UART_BASE_ADDR, "\n")

    module_presence_rdback_value = get_reg_value(glu_reg_base_addr + REG_MOD_PRESENCE_RDBCK)
    switch_bit = module_presence_rdback_value & 0x1
    dtss_bit = (module_presence_rdback_value & 0x2)/2
    dtss_fpga_rdy_bit = (module_presence_rdback_value & 0x4)/4

    if verbose:
        print("* OSB module_presence_rdback register details :")
        print("  module_presence_rdback_value read = 0x%x" % module_presence_rdback_value)
        print("     * module_presence_rdback(2) = DTSS_FPGA_RDY = %d ('0' = ABSENT ; '1' = present)" %dtss_fpga_rdy_bit)
        print("     * module_presence_rdback(1) = DTSS_PRES     = %d ('0' = ABSENT ; '1' = present)" %dtss_bit)
        print("     * module_presence_rdback(0) = SWITCH_PRES   = %d ('0' = ABSENT ; '1' = present)\n" %switch_bit)

    # Read LCR register (0x100C) : verify LCR(7) = 0
    LCR_value = get_reg_value(glu_reg_base_addr + (UART_BASE_ADDR + UART_LCR))
    if verbose:
        print("Read LCR_value = 0x%x" % LCR_value, "@ addr = 0x%x (LCR reg.)" %UART_LCR)

    # LCR(7) = 0 : read @ 0x01000 addr i.e RBR register
    RBR_value = get_reg_value(glu_reg_base_addr + (UART_BASE_ADDR + UART_RBR_DLL))
    if verbose:
        print("Read RBR_value = 0x%x" % RBR_value, "@ addr = 0x%x (RBR_DLL reg.)" %UART_RBR_DLL)

    # LCR register (0x100C) : set LCR(7) = 1
    data_val =  0x80
    if verbose:
        print("Write = 0x%x" % data_val, " @ addr = 0x%x (LCR reg.)" %UART_LCR)
    reg_write(glu_reg_base_addr + (UART_BASE_ADDR + UART_LCR), data_val)

    LCR_value = get_reg_value(glu_reg_base_addr + (UART_BASE_ADDR + UART_LCR))
    if verbose:
        print("Read LCR_value = 0x%x" % LCR_value, "@ addr = 0x%x (LCR reg.)" %UART_LCR)

    # LCR(7) = 1 : read @ 0x01000 addr i.e DLL register
    DLL_value = get_reg_value(glu_reg_base_addr + (UART_BASE_ADDR + UART_RBR_DLL))
    if verbose:
        print("Read DLL_value = 0x%x" % DLL_value, "@ addr = 0x%x (RBR_DLL reg.)" %UART_RBR_DLL)

    # Program uart baudrate :

    data_val =  0x8b
    if verbose:
        print("Write = 0x%x" % data_val, "@ addr = 0x%x (LCR reg.)" %UART_RBR_DLL)
    reg_write(glu_reg_base_addr + (UART_BASE_ADDR + UART_RBR_DLL), data_val)

    DLL_value = get_reg_value(glu_reg_base_addr + (UART_BASE_ADDR + UART_RBR_DLL))
    if verbose:
        print("Read DLL_value = 0x%x" % DLL_value, "@ addr = 0x%x (RBR_DLL reg.)" %UART_RBR_DLL)

    # LCR(7) = 1 : read @0x01004 addr i.e DLM register
    DLM_value = get_reg_value(glu_reg_base_addr + (UART_BASE_ADDR + UART_DLM))
    if verbose:
        print("Read DLM_value = 0x%x" % DLM_value, "@ addr = 0x%x" %UART_DLM)

    data_val =  0x2
    if verbose:
        print("Write = 0x%x" % data_val, "@ addr = 0x%x (LCR reg.)" %UART_DLM)
    reg_write(glu_reg_base_addr + (UART_BASE_ADDR + UART_DLM), data_val)

    DLM_value = get_reg_value(glu_reg_base_addr + (UART_BASE_ADDR + UART_DLM))
    if verbose:
        print("Read DLM_value = 0x%x" % DLM_value, "@ addr = 0x%x" %UART_DLM)

    # Write 0x3 into LCR register (0x100C) : clear LCR(7)
    #
    # LCR(1:0) = WLS (Word Length Select) = b'11 => 8 bits/character
    # LCR(2) = STB (STop Bit) => 0 = 1 Stop bit

    data_val =  0x3
    if verbose:
        print("Write = 0x%x" % data_val, "@ addr = 0x%x (LCR reg.)" %UART_LCR)
    reg_write(glu_reg_base_addr + (UART_BASE_ADDR + UART_LCR), data_val)

    LCR_value = get_reg_value(glu_reg_base_addr + (UART_BASE_ADDR + UART_LCR))
    if verbose:
        print("Read LCR_value = 0x%x" % LCR_value, "@ addr = 0x%x (LCR reg.)" %UART_LCR)

    # LCR(7) = 0 : write 0x1 @ 0x01008 addr i.e FCR register (Fifo Control register)
    data_val =  0x1
    if verbose:
        print("Write = 0x%x" % data_val, "@ addr = 0x%x (FCR reg.)" %UART_FCR)
    reg_write(glu_reg_base_addr + (UART_BASE_ADDR + UART_FCR), data_val)

    if verbose:
        print("**** Ready to launch Tx values" )

    return 0
#
#=============================================================================================
@DIAG("OSB : PYDIAG VERSION")
def t_osb_diag_ver(cmd):
#=============================================================================================
#
# Current version of OSB python diag
#
    print("\n* OSB PYDIAG version is", DIAG_VERSION)
    return None
#
#=============================================================================================
@DIAG("OSB : PCIe Test")
def t_osb_pcie(cmd):
#=============================================================================================
#
    npcied = 0
    if (os.path.isdir("/sys/bus/pci/devices/0000:06:00.0")):
        vendor = sysfs_read_string("/sys/bus/pci/devices/0000:06:00.0/vendor")
        device = sysfs_read_string("/sys/bus/pci/devices/0000:06:00.0/device")
        print_info("# OSB board : FPGA Func 0 detected: %s %s"%(vendor,device))
        npcied = npcied + 1
    else:
        print_error("# OSB board : FPGA Func 0 not detected")

    if(npcied == 1):
        print_ok("# OSB board PCIe : 1/1 device detected")
        return True
    else:
        print_error("# OSB board PCIe : only %d/1 device detected"%(npcied))
        return False
#
#========================================================================================
def oth_usb_topology():
#========================================================================================
#
    debug = False

    FileName = "/usr/share/pydiag/oth/usb_topology.txt"

    os_base_cmd = "ls /sys/bus/usb/devices/"

    os_cmde = os_base_cmd+" > "+FileName

    if debug:
        print("\n * os_cmde is :", os_cmde, "\n")

    (os.system(os_cmde))

    tmp_list = []
    usb_topology = []
    line_num = 1

    with open(FileName,'r') as tmpfile:
        for line in tmpfile.readlines():
            if debug:
                print("\n****** line is ", line)

            tmp_list = line.split()

            if debug:
                print(" * line_num = %d :" %line_num)
                print(" ==================\n")
                print("   => tmp_list is", tmp_list)

            for elt in tmp_list:
                fileidVendor = "/sys/bus/usb/devices/"+elt+"/idVendor"
                if(os.path.isfile(fileidVendor)):
                    msg = "idVendor file exist"
                    mfg = sysfs_read_string(fileidVendor)
                else:
                    msg = "idVendor file don't exist"
                    mfg = "False"

                fileidProduct = "/sys/bus/usb/devices/"+elt+"/idProduct"
                if(os.path.isfile(fileidProduct)):
                    msg = "idProduct file exist"
                    prod = sysfs_read_string(fileidProduct)
                else:
                    msg = "idProduct file don't exist"
                    prod = "False"

                if debug:
                    print("   elt is ", elt, ":", msg)
                    print("           mfg  = ", mfg)
                    print("           prod = ", prod)

                usb_topology.append(elt)
                usb_topology.append(mfg)
                usb_topology.append(prod)

                if debug:
                    print("\n***** usb_topology is ", usb_topology)

            line_num = line_num + 1

    tmpfile.close()

    os_cmde = "rm -f "+FileName

    if debug:
        print("\nos_cmde is", os_cmde)

    (os.system(os_cmde))

    return usb_topology
#
#=============================================================================================
@DIAG("OSB : USB Test")
def t_osb_usb(cmd):
#=============================================================================================
#
    debug = False

    usb_topology_list = oth_usb_topology()

    i = 0
    driver_list = []
    mfg_list = []
    prod_list = []

    for elt in enumerate(usb_topology_list):
        if debug:
            print("\nelt_%d = " %i, elt)

        if i == 0 or i%3 == 0:
            driver_list.append(elt[1])
        elif i%3 == 1:
            mfg_list.append(elt[1])
        else:
            prod_list.append(elt[1])

        if debug:
            print("\ndriver_list is", driver_list)
            print("mfg_list    is", mfg_list)
            print("prod_list   is", prod_list)

        i += 1

    print("\n OTH USB topology :")

    i = 0
    while i < len(driver_list):
        driver_str = driver_list[i]
        mfg_str    = mfg_list[i]
        prod_str   = prod_list[i]
        print("     * i = %d :" %i, driver_str, mfg_str, prod_str)
        i += 1
    print("")

#======================================================================================

    nbusb = 0
    if(os.path.isdir("/sys/bus/usb/devices/1-1.1")):
        mfg = sysfs_read_string("/sys/bus/usb/devices/1-1.1/idVendor")
        prod = sysfs_read_string("/sys/bus/usb/devices/1-1.1/idProduct")
        print_info("# CPB USB HUB 2514: %s %s"%(mfg,prod))
        nbusb = nbusb + 1
    else:
        print_error("# CPB USB HUB 2514 not detected")

    if(os.path.isdir("/sys/bus/usb/devices/1-1.3")):
        mfg = sysfs_read_string("/sys/bus/usb/devices/1-1.3/idVendor")
        prod = sysfs_read_string("/sys/bus/usb/devices/1-1.3/idProduct")
        print_info("# USB A CPB FRONT PANEL: %s %s"%(mfg,prod))
        nbusb = nbusb + 1
    else:
        print_error("# USB A CPB FRONT PANEL not detected")

    # if(os.path.isdir("/sys/bus/usb/devices/1-1.3")):
    #     mfg = sysfs_read_string("/sys/bus/usb/devices/1-1.3/manufacturer")
    #     prod = sysfs_read_string("/sys/bus/usb/devices/1-1.3/product")
    #     print_info("# USB J6: %s %s"%(mfg,prod))
    #     nbusb = nbusb + 1
    # else:
    #     print_error("# USB J6 not detected")
    #
    # if(os.path.isdir("/sys/bus/usb/devices/1-1.4")):
    #     mfg = sysfs_read_string("/sys/bus/usb/devices/1-1.4/manufacturer")
    #     prod = sysfs_read_string("/sys/bus/usb/devices/1-1.4/product")
    #     print_info("# USB J5: %s %s"%(mfg,prod))
    #     nbusb = nbusb + 1
    # else:
    #     print_error("# USB J5 not detected")

    if(nbusb==2):
        print_ok("# USB: 2 devices detected")
        return True
    else:
        print_error("# USB only %d/2 devices detected"%(nbusb))
        return False
#
#=============================================================================================
@DIAG("OSB : Ethernet test")
def t_osb_eth(cmd):
#=============================================================================================
#
    try:
        (command, hostname) = cmd.split()
    except:
        print_error("# Command must be: t_osb_eth <hostname> ")
        return False

    FileName = "/usr/share/pydiag/oth/ethernet_tmp.txt"

    # hostname = "10.33.17.16"
    # response = os.system("ping -I eth1 -c 1 " + hostname)

    os_cmde = "ping -c 1 " + hostname + "> " + FileName

    response = os.system(os_cmde)

    #print("reponse is %s" %response)

    os_cmde = "rm -f "+FileName
    (os.system(os_cmde))

    # and then check the response...
    if response == 0:
        pingstatus = "Network Active"
        print(pingstatus)
        return True
    else:
        pingstatus = "Network Error"
        print(pingstatus)
        return False
#
#=============================================================================================
@DIAG("OSB : I2C devices detection")
def t_osb_i2cdetect(cmd):
#=============================================================================================
#
    try:
        if ' ' not in cmd:
            verbose = False
        else:
            (command, verbose_flag) = cmd.split()
            if verbose_flag == "verbose":
                verbose = True
            else:
                print()
                print_error("*   Parameter error : arg. must be : verbose")
                print()
                return False
    except:
        print_error("   Syntax error : Command must be : t_osb_i2cdetect <verbose_flag> ")
        print_error("                                                                   ")
        return False

    osb_i2c_bus_nb = sysfs_read_string("/sys/platform/uts_scan/i2c_master_pw")

    i2c_to_detect_list = ['20', '50', '54', '71', '72', '74', '75']

    if verbose:
        print("osb_i2c_bus_nb is ", osb_i2c_bus_nb)

    i2c_cmde = "i2cdetect -y "+osb_i2c_bus_nb

    if verbose:
        print("\n================")
        print("**** i2c-%s bus:" %osb_i2c_bus_nb)
        print("================\n")

        (os.system(i2c_cmde))
        print("")

    file_name = "/usr/share/pydiag/oth/osb_i2c_detect_tmp.txt"

    os_cmde = i2c_cmde+ " > "+file_name
    (os.system(os_cmde))

    debug = 0
    osb_i2c_detected_list = i2c_table_parser(file_name, debug)

    if verbose:
        print("\nosb_i2c_detected_list is ",osb_i2c_detected_list)

    os_cmde = "rm -f "+file_name
    (os.system(os_cmde))

    ret_flag = True

    for elt in enumerate (i2c_to_detect_list):
        if (elt[1]) in osb_i2c_detected_list:
            if verbose:
                print_ok("I2C device at addr 0x%s" %elt[1], "detected")
        else:
            if verbose:
                print_error("I2C device at addr 0x%s" %elt[1], "not detected")
            ret_flag = False

    return ret_flag
#
#=============================================================================================
@DIAG("OSB : FPGA_VERSION readback using /sys/platform")
def t_osb_fpga_ver(cmd):
#=============================================================================================
#
    if os.path.exists('/sys/platform/osb_fpga/fpga_ver'):
        osb_fpga_version = sysfs_read_string("/sys/platform/osb_fpga/fpga_ver")
        print("\n* OSB FPGA version is", osb_fpga_version)

        osb_fpga_synth_date = sysfs_read_string("/sys/platform/osb_fpga/fpga_synt_date")
        print("* OSB FPGA synthesis date is", osb_fpga_synth_date)

        version_major = (int(osb_fpga_version, base = 16) >> 16) & 0xffff
        version_minor = int(osb_fpga_version, base = 16) & 0xffff
    
        print("\n##############################################")
        print("FPGA revision: ", end='')
        print("%d.%d" %(version_major, version_minor))
        print("##############################################")
        
        print("\n##############################################")
        print("OSB FPGA Synthesis date: ", end='')
        # print(sd)
        d = (int(osb_fpga_synth_date, base=16) >> 27)
        M = ((int(osb_fpga_synth_date, base=16) >> 23) & 15)
        Y = ((int(osb_fpga_synth_date, base=16) >> 17) & 63)
        h = ((int(osb_fpga_synth_date, base=16) >> 12) & 31)
        m = ((int(osb_fpga_synth_date, base=16) >> 6) & 63)
        s = ((int(osb_fpga_synth_date, base=16)) & 63)
        print("%02d/%02d/20%02d %02d:%02d:%02d" % (d, M, Y, h, m, s))
        print("##############################################\n")
        return True
    else:
        print("* Error : /sys/platform/osb_fpga/fpga_ver can't be found")
        return False
#
#=============================================================================================
@DIAG("OSB : PSU check")
def t_osb_psu_check(cmd):
#=============================================================================================
#
#   OSB_FPGA_PSU_CTRL(0) = ENABLE_VEE_12V8_EXT
#   OSB_FPGA_PSU_CTRL(1) = ENABLE_VDD_12V8_EXT
#   OSB_FPGA_PSU_CTRL(2) = ENABLE_VDD_5V_EXT
#   OSB_FPGA_PSU_CTRL(3) = ENABLE_VDD_3V3_EXT
#   OSB_FPGA_PSU_CTRL(4) = ENABLE_VDD_1V8_EXT
#   OSB_FPGA_PSU_CTRL(5) = ENABLE_VDD_5V8_EXT
#   OSB_FPGA_PSU_CTRL(6) = ENABLE_VEE_5V8_EXT
#   OSB_FPGA_PSU_CTRL(7) = Unused
#   OSB_FPGA_PSU_CTRL(8) = ENABLE_RS485_PWR_FPGA
#   OSB_FPGA_PSU_CTRL(9) = ENABLE_OSB_FAN_12V
#
# See also /sys/platform/osb_fpga/fpga_pwr_ctl
#
    psu_name_list = ["VEE_12V8", "VDD_12V8", "VDD_5V", "VDD_3V3", "VDD_1V8", "VDD_5V8", "VEE_5V8",
                     "RS485_PWR", "FAN_12V"]

    psu_mask_list = [0x01, 0x02, 0x4, 0x8, 0x10, 0x20, 0x40, 0x100, 0x200]

    glu_reg_base_addr = get_glu_base_addr()

    shifter_ctrl_value = get_reg_value(glu_reg_base_addr + REG_SHIFTER_CTRL)
    print("\n* shifter_OEn_value = 0x%x" % shifter_ctrl_value)
    
    psu_ctrl_value = get_reg_value(glu_reg_base_addr + REG_PSU_CTRL)
    print("\n* psu_ctrl_value = 0x%x" % psu_ctrl_value)

    i = 0
    while i < len(psu_name_list):

        val = psu_ctrl_value & psu_mask_list[i]

        if val == psu_mask_list[i]:
            print_ok("* %s : ENABLE" %psu_name_list[i])
        else:
            print_ok("* %s : DISABLE" %psu_name_list[i])
        i += 1

    return None
#
#=============================================================================================
@DIAG("OSB : PSU SET")
def t_osb_psu_set(cmd):
#=============================================================================================
#
    debug = False

    try:
        (command, consigne) = cmd.split()

    except:
        print_error("   Syntax error : Command must be : t_osb_psu_set <consigne>")
        print_error("                                                            ")
        print_error("   where            <consigne> is : <PSU_LIST>-<FLAG>")
        print_error("   with                <PSU_LIST> = VDD_12V8|VEE_12V8|VDD_5V8|VEE_5V8|")
        print_error("                                    VDD_5V|VDD_3V3|VDD_1V8|RS485_PWR|FAN_12V|ALL")
        print_error("                       <FLAG>     = ON|OFF")
        return False

    print_info("* consigne is "+consigne)
    (psu_list, en_flag) = consigne.split('-')
    print_info("     * psu_list is "+psu_list)
    print_info("     * en_flag  is "+en_flag)

    arg_list = psu_list.split('|')
    if debug:
        print("     * arg_list is ", arg_list,"\n")

    psu_name_list =     ["VEE_12V8", "VDD_12V8", "VDD_5V", "VDD_3V3", "VDD_1V8", "VDD_5V8", "VEE_5V8", "RS485_PWR", "FAN_12V"]
    psu_mask_list =     [ 0x01,       0x02,       0x4,      0x8,       0x10,      0x20,      0x40,      0x100,       0x200]
    psu_mask_list_bar = [0xffe,       0xffd,      0xffb,    0xff7,     0xfef,     0xfdf,     0xfbf,     0xeff,       0xdff]

    psu_todo_list =     ["NO",        "NO",       "NO",     "NO",      "NO",      "NO",      "NO",      "NO",        "NO"]

    for elt in enumerate(arg_list):
        if debug:
            print(elt)
        if elt[1] not in psu_name_list:
            if elt[1] != 'ALL':
                print("Error : ", elt[1], "is not a correct arg")
                return False

    if 'ALL' in arg_list:
        i = 0
        while i < len(psu_name_list):
            psu_todo_list[i] = "YES"
            i += 1
    else:
        i = 0
        for elt in enumerate(psu_name_list):
            if elt[1] in arg_list:
                psu_todo_list[i] = "YES"
            i += 1

    glu_reg_base_addr = get_glu_base_addr()

    i = 0
    while i < len(psu_name_list):
        if debug:
            print("     * psu_name_list[%d] = "%i, psu_name_list[i], "psu_mask_list[%d] = 0x%x" %(i, psu_mask_list[i]), "psu_mask_list_bar[%d] = 0x%x" %(i,psu_mask_list_bar[i]))
            print("     * psu_todo_list[%d] = "%i, psu_todo_list[i])

        if psu_todo_list[i] == 'YES':
            psu_ctrl_value = get_reg_value(glu_reg_base_addr + REG_PSU_CTRL)

            if (psu_ctrl_value  & psu_mask_list[i]) == psu_mask_list[i]:
                psu_currently_en = 'Yes'
            else:
                psu_currently_en = 'No'

            to_reprogram = 'No'

            if en_flag == "ON":
                if psu_currently_en == 'No':
                    to_reprogram = 'Yes'
                    data_val = psu_ctrl_value | psu_mask_list[i]
                    msg = " need to be ENABLE (psu_reg_val = 0x%x)" %data_val
                else:
                    msg = " is currently ENABLE"
            else:
                if psu_currently_en == 'Yes':
                    to_reprogram = 'Yes'
                    data_val = psu_ctrl_value & psu_mask_list_bar[i]
                    msg = " need to be DISABLE (psu_reg_val = 0x%x)" %data_val
                else:
                    msg = " is currently DISABLE"

            print_ok("* %s" %psu_name_list[i]+msg)

            if to_reprogram == 'Yes':
                reg_write(glu_reg_base_addr + REG_PSU_CTRL, data_val)
        i += 1

    return True
#
#=============================================================================================
@DIAG("OSB : PSU TEST")
def t_osb_psu_test(cmd):
#=============================================================================================
#
# VAUX_0  : K_VDD_12V8 = 8.25/108.25 = 0.07621    ; expected : 976mV
# VAUX_8  : K_VDD_5V8  = 1.78/11.78  = 0.15110    ; expected : 876mV
# VAUX_1  : K_VDD_5V   = 2.26/12.26  = 0.18434    ; expected : 922mV
# VAUX_9  : K_VDD_3V3  = 3.32/13.32  = 0.24925    ; expected : 823mV
# VAUX_2  : K_VDD_1V8  = 6.81/16.81  = 0.40512    ; expected : 729mV
# VAUX_10 : K_VEE_12V8 = 2.26/12.26  = 0.18434    ; expected : 861mV <- warning : partir de 4.68V au lieu de 12.8V
# VAUX_11 : K_VEE_5V8  = 2.26/12.26  = 0.18434    ; expected : 842mV <- warning : partir de 4.57V au lieu de 5.8V
#
    try:
        (command, consigne) = cmd.split()

    except:
        print_error("   Syntax error : Command must be : t_osb_psu_test <consigne>         ")
        print_error("                                                                      ")
        print_error("   where            <consigne> is : <PSU_NAME>;<Min_value>;<Max_value>")
        print_error("   with                <PSU_LIST> = VDD_12V8|VEE_12V8|VDD_5V8|VEE_5V8|")
        print_error("                                    VDD_5V|VDD_3V3|VDD_1V8            ")
        #print_error("   And <Min_value>, <Max_value> MUST be decimal values")
        return False

    print_info("* consigne is "+consigne)
    (psu_name, min_value_str, max_value_str) = consigne.split(';')

    print_info("     * psu_name  is "+psu_name)
    print_info("     * min_value is "+min_value_str+"V")
    print_info("     * max_value is "+max_value_str+"V")

    min_value = float(min_value_str)
    max_value = float(max_value_str)

    if min_value > max_value:
        print_error(" Error : min_value > max_value")
        return False

    psu_name_list = ["VDD_12V8", "VDD_5V", "VDD_1V8", "VEE_5V8", "VDD_5V8", "VDD_3V3", "VEE_12V8"]
    psu_mask_list = [0x02, 0x4, 0x10, 0x40, 0x20, 0x8, 0x01]

    xadc_aux_list = [XADC_VAUX_0_REG, XADC_VAUX_1_REG, XADC_VAUX_2_REG, XADC_VAUX_11_REG, XADC_VAUX_8_REG,
                     XADC_VAUX_9_REG, XADC_VAUX_10_REG]

    coeff_list = [0.07621, 0.18434, 0.40512, -0.18434*(4.57/5.8), 0.15110, 0.24925, -0.18434*(4.68/12.8)]

    parameter_flag = False

    i = 0
    for elt in enumerate(psu_name_list):
        if elt[1] == psu_name:
            xadc_aux_addr = xadc_aux_list[i]
            coeff_value = coeff_list[i]
            psu_mask = psu_mask_list[i]
            parameter_flag = True
        i += 1

    if parameter_flag:
        pass
    else:
        print_error("* Error : Unknown parameter %s: abort" %psu_name)
        return False

    glu_reg_base_addr = get_glu_base_addr()

    # Enable PSU into PSU_CTRL register

#   psu_ctrl_value = get_reg_value(glu_reg_base_addr + REG_PSU_CTRL)

#   data_val = psu_ctrl_value | psu_mask
#   reg_write(glu_reg_base_addr + REG_PSU_CTRL, data_val)

    # Read PSU_Value from XADC

    xadc_vaux_value = int(get_reg_value(glu_reg_base_addr + xadc_aux_addr)/16)
    vaux_value = float(xadc_vaux_value * 0.244)/1000

    psu_value = vaux_value / coeff_value

    print(" PSU value measured : %3.3fV" %psu_value)
    if psu_value > min_value and psu_value < max_value:
        return True
    else:
        return False
#
#=============================================================================================
@DIAG("OSB : SYNCHRO Frequency test")
def t_osb_sync_freq_meas_test(cmd):
#=============================================================================================
#
    try:
        if len(cmd.split()) == 3:
            cmd_lgth = 3
            (command, consigne, verbose_flag) = cmd.split()
            if verbose_flag == "verbose":
                pass
            else :
                print()
                print_error("     * Error : 2nd arg <%s> is not a correct arg : must be : verbose" %verbose_flag)
                return False
        else:
            verbose_flag = False
            (command, consigne) = cmd.split()

        print_info("* consigne is "+consigne)
        arg_list = consigne.split('|')
    except:
        print("")
        print_error("   Syntax error : Command must be : t_osb_sync_freq_meas_test <consigne> ")
        print_error("                                                                         ")
        print_error("   where            <consigne> is : <SYNC_LIST> <verbose_flag>           ")
        print_error("                                                                         ")
        print_error("   with             <SYNC_LIST>    = SYNC_700K|SYNC_640K|SYNC_320K|ALL   ")
        print_error("                                     example : SYNC_700K|SYNC_320K       ")
        print_error("                                                                         ")
        print_error("                    <verbose_flag> = MUST be verbose ONLY                ")
        print_error("                             Note  : <verbose_flag> parameter is optional")
        print("")
        return False

    sync_name_list     = ["SYNC_700K", "SYNC_640K", "SYNC_320K"]
    sync_todo_list =     ["NO",        "NO",        "NO"]

    arg_error_nb = 0

    for elt in enumerate(arg_list):
        if elt[1] not in sync_name_list:
            if elt[1] != 'ALL':
                if arg_error_nb == 0:
                    print("")
                print_error("     * Error : %s is not a correct arg" %elt[1])
                arg_error_nb += 1

    if arg_error_nb > 0:
        return False

    err_nb = 0
    
    print("")
    
    i = 0
    if 'ALL' in arg_list:
        while i < len(sync_name_list):
            sync_todo_list[i] = "YES"
            i += 1
    else:
        for elt in enumerate(sync_name_list):
            if elt[1] in arg_list:
                sync_todo_list[i] = "YES"
            i += 1

    glu_reg_base_addr = get_glu_base_addr()

    i = 0
    while i < len(sync_name_list):

        if sync_todo_list[i] == 'YES':
            if sync_name_list[i] == "SYNC_700K":
                reg_addr = REG_SYS_PSYNC_700K_MEAS
                period_min = 690000
                period_max = 710000
            elif sync_name_list[i] == "SYNC_640K":
                reg_addr = REG_SYS_PSYNC_640K_MEAS

                period_min = 630000
                period_max = 650000
            else:
                reg_addr = REG_SYS_PSYNC_320K_MEAS
                period_min = 310000
                period_max = 330000

            reg_val = get_reg_value(glu_reg_base_addr + reg_addr)

            if verbose_flag:
                print("* %s : value read @ addr 0x%x = 0x%x" %(sync_name_list[i], reg_addr, reg_val))

            period_nb_for_1ms = float(reg_val)
            period_nb_for_1s = period_nb_for_1ms * 1000


            if period_nb_for_1s > period_min and period_nb_for_1s < period_max:
                msg = "PASS"
                print_ok("* %s frequency = %5.3fHz : %s" %(sync_name_list[i], period_nb_for_1s, msg))
            else:
                msg = "FAIL"
                print_error("* %s frequency = %5.3fHz : %s" %(sync_name_list[i], period_nb_for_1s, msg))
                err_nb += 1
        i += 1

    print()
    if err_nb == 0:
        return True
    else:
        return False
#
#=============================================================================================
@DIAG("OSB : CPLD Frequency 33MHz test")
def t_osb_cpld_freq_meas_test(cmd):
#=============================================================================================
#
    glu_reg_base_addr = get_glu_base_addr()

    reg_val = get_reg_value(glu_reg_base_addr + REG_CPLD_33M_FREQ_MEAS)

    period_nb_for_1ms = float(reg_val)
    period_nb_for_1s = period_nb_for_1ms * 1000

    if period_nb_for_1s > 33000000 and period_nb_for_1s < 33500000:
        msg = "PASS"
        print_ok("\n* CPLD 33MHz frequency = %5.3fHz : %s\n" %(period_nb_for_1s, msg))
        return True
    else:
        msg = "FAIL"
        print_error("\n* CPLD 33.33MHz frequency = %5.3fHz : %s\n" %(period_nb_for_1s, msg))
        return False

#
#=============================================================================================
@DIAG("OSB : XADC TEST using /sys/platform drivers")
def t_osb_sys_xadc_test(cmd):
#=============================================================================================
#
# To test PSU when they are ENABLE
#
    try:
        if ' ' not in cmd:
            pass
            verbose = False
        else:
            length = len(cmd.split(' '))
            if length > 2:
                print_info("\nError : This command accepts 1 (optional) parameter ONLY ")
                raise
            elif length == 2:
                (command, verbose_flag) = cmd.split(' ')
                if verbose_flag == "verbose":
                    verbose = True
                else:
                    print()
                    print_error("*   Parameter error : arg must be : verbose")
                    return False
            else:
                verbose = False
                pass

    except:
        print()
        print_error("   Syntax error : Command must be : t_osb_sys_xadc_test <verbose_flag>      ")
        print_error("                                                                            ")
        print_error("         <verbose_flag> is : MUST be verbose ONLY                           ")
        print_error("                             Note : <verbose_flag> parameter is optional    ")
        print()
        return False

    print()

    res = 0

    R1 = 100000
    R2 = 8250
    val_hex = sysfs_read_string("/sys/platform/osb-xadc/aux0")
    if verbose:
        print(" * aux0 : val_hex = ", val_hex, "; %d" % int(val_hex, 16))
    val = int(val_hex, 16) / 16
    val_mv = (val * 1000 / 4095)
    if verbose:
        print("   VDD12V8 / AUX0 = %d mV" % ( ((R2 + R1) * val_mv) / R2))
    res = res + sysfs_check("/sys/platform/osb-xadc/aux0", "tension VCC12V8",
                            vmin=int(CONST("mtsps.aux0.min", ((((12650 * R2) / (R1 + R2)) * 4095) / 1000) * 16)),
                            vmax=int(CONST("mtsps.aux0.max", ((((12950 * R2) / (R1 + R2)) * 4095) / 1000) * 16)))
    if verbose:
        print("     VDD12V8. res = %d" %res)

    R1 = 10000
    R2 = 2260
    val_hex = sysfs_read_string("/sys/platform/osb-xadc/aux1")
    if verbose:
        print(" * aux1 : val_hex = ", val_hex, "; %d" % int(val_hex, 16))
    val = int(val_hex, 16) / 16
    val_mv = (val * 1000 / 4095)
    if verbose:
        print("   VDD5V0 / AUX1 = %d mV" % ( ((R2 + R1) * val_mv) / R2))
    res = res + sysfs_check("/sys/platform/osb-xadc/aux1", "tension VCC5V",
                            vmin=int(CONST("mtsps.aux1.min", ((((4950 * R2) / (R1 + R2)) * 4095) / 1000) * 16)),
                            vmax=int(CONST("mtsps.aux1.max", ((((5050 * R2) / (R1 + R2)) * 4095) / 1000) * 16)))
    if verbose:
        print("     VDD5V0. res = %d" %res)

    R1 = 10000
    R2 = 6810
    val_hex = sysfs_read_string("/sys/platform/osb-xadc/aux2")
    if verbose:
        print(" * aux2 : val_hex = ", val_hex, "; %d" % int(val_hex, 16))
    val = int(val_hex, 16) / 16
    val_mv = (val * 1000 / 4095)
    if verbose:
        print("   VCC1V8 / AUX2 = %d mV" % ( ((R2 + R1) * val_mv) / R2))
    res = res + sysfs_check("/sys/platform/osb-xadc/aux2", "tension VCC1V8",
                            vmin=int(CONST("mtsps.aux2.min", ((((1750 * R2) / (R1 + R2)) * 4095) / 1000) * 16)),
                            vmax=int(CONST("mtsps.aux2.max", ((((1850 * R2) / (R1 + R2)) * 4095) / 1000) * 16)))
    if verbose:
        print("     VDD1V8. res = %d" %res)

    R1 = 10000
    R2 = 1780
    val_hex = sysfs_read_string("/sys/platform/osb-xadc/aux8")
    if verbose:
        print(" * aux8 : val_hex = ", val_hex, "; %d" % int(val_hex, 16))
    val = int(val_hex, 16) / 16
    val_mv = (val * 1000 / 4095)
    if verbose:
        print("   VDD5V8 / AUX8 = %d mV" % ( ((R2 + R1) * val_mv) / R2))
    res = res + sysfs_check("/sys/platform/osb-xadc/aux8", "tension VCC5V8",
                            vmin=int(CONST("mtsps.aux8.min", ((((5750 * R2) / (R1 + R2)) * 4095) / 1000) * 16)),
                            vmax=int(CONST("mtsps.aux8.max", ((((5950 * R2) / (R1 + R2)) * 4095) / 1000) * 16)))
    if verbose:
        print("     VDD5V8. res = %d" %res)

    R1 = 10000
    R2 = 3320
    val_hex = sysfs_read_string("/sys/platform/osb-xadc/aux9")
    if verbose:
        print(" * aux9 : val_hex = ", val_hex, "; %d" % int(val_hex, 16))
    val = int(val_hex, 16) / 16
    val_mv = (val * 1000 / 4095)
    if verbose:
        print("   VDD3V3 / AUX9 = %d mV" % ( ((R2 + R1) * val_mv) / R2))
    res = res + sysfs_check("/sys/platform/osb-xadc/aux9", "tension VCC3V3",
                            vmin=int(CONST("mtsps.aux9.min", ((((3250 * R2) / (R1 + R2)) * 4095) / 1000) * 16)),
                            vmax=int(CONST("mtsps.aux9.max", ((((3380 * R2) / (R1 + R2)) * 4095) / 1000) * 16)))
    if verbose:
        print("     VDD3V3. res = %d" %res)

    R1 = 10000
    R2 = 2260
    R1P = 22600
    R2P = 8250
    val_hex = sysfs_read_string("/sys/platform/osb-xadc/aux10")
    if verbose:
        print(" * aux10 : val_hex = ", val_hex, "; %d" % int(val_hex, 16))
    val = int(val_hex, 16) / 16
    val_mv = (val * 1000 / 4095)
    valn_mv = ((R2 + R1) * val_mv) / R2
    if verbose:
        print("   VEE12V8 / AUX10 = -%d mV" % ( ((R1P * valn_mv) / R2P)))
    res = res + sysfs_check("/sys/platform/osb-xadc/aux10", "tension VEE12V8",
                            vmin=int(CONST("mtsps.aux10.min",
                                           (((((R2P * (12600) / R1P) * R2) / (R1 + R2)) * 4095) / 1000) * 16)),
                            vmax=int(CONST("mtsps.aux10.max",
                                           (((((R2P * (12900) / R1P) * R2) / (R1 + R2)) * 4095) / 1000) * 16)))
    if verbose:
        print("     VEE12V8. res = %d" %res)

    R1 = 10000
    R2 = 2260
    R1P = 22600
    R2P = 17800
    val_hex = sysfs_read_string("/sys/platform/osb-xadc/aux11")
    if verbose:
        print(" * aux11 : val_hex = ", val_hex, "; %d" % int(val_hex, 16))
    val = int(val_hex, 16) / 16
    val_mv = (val * 1000 / 4095)
    valn_mv = ((R2 + R1) * val_mv) / R2
    if verbose:
        print("   VEE5V8 / AUX11 = -%d mV" % ( (R1P * valn_mv) / R2P))
    res = res + sysfs_check("/sys/platform/osb-xadc/aux11", "tension VEE5V8",
                            vmin=int(CONST("mtsps.aux11.min",
                                           (((((R2P * (5600) / R1P) * R2) / (R1 + R2)) * 4095) / 1000) * 16)),
                            vmax=int(CONST("mtsps.aux11.max",
                                           (((((R2P * (5900) / R1P) * R2) / (R1 + R2)) * 4095) / 1000) * 16)))
    if verbose:
        print ("     VEE5V8. res = %d" %res)

    print()
    if res == 7:
        return True
    else:
        return False
#
#=============================================================================================
@DIAG("OSB : UART test")
def t_osb_uart_test(cmd):
#=============================================================================================
#
    verbose = True

    try:
        (command,consigne) = cmd.split()

        if consigne != "MOD" and consigne != "RS485":
            print_error("Error : consigne undefined : MUST be MOD or RS485")
            return False

    except:
        print_error("   Syntax error : Command must be : t_osb_uart_test <consigne>")
        print_error("   where            <consigne> is : <MOD|RS485>")

        return False

    glu_reg_base_addr = get_glu_base_addr()
    if verbose:
        print("glu_reg_base_addr = 0x%x" %glu_reg_base_addr, "\n")

    if consigne == "RS485":

        UART_BASE_ADDR = UART_RS485_BASE_ADDR

        # OSB_FPGA_PSU_CTRL(8) = ENABLE_RS485_PWR_FPGA Must be set to '1'

        psu_ctrl_value = get_reg_value(glu_reg_base_addr + REG_PSU_CTRL)
        if verbose:
            print("psu_ctrl_value = 0x%x" %psu_ctrl_value)

        data_val = psu_ctrl_value | 0x100
        reg_write(glu_reg_base_addr + REG_PSU_CTRL, data_val)
        if verbose:
            print("Write = 0x%x" %data_val, "@ addr = 0x%x" %REG_PSU_CTRL)
    else:
        # Verify Internal Optical module present : MOD_PRESENCE_RDBK reg

        # MOD_PRESENCE_RDBK(0) = SWITCH_PRESENCE ( value = 1 => Switch_module present ; value = 0 => Switch_module absent)
        # MOD_PRESENCE_RDBK(1) = DTSS_PRESENCE ( value = 1 => DTSS_module present   ; value = 0 => DTSS_module absent)
        # MOD_PRESENCE_RDBK(2) = DTSS_FPGA_READY  ( value = 1 => DTSS_FPGA present ?   ; value = 0 => DTSS_FPGA absent ?)

        UART_BASE_ADDR = UART_MOD_BASE_ADDR

        if verbose:
            print("UART_BASE_ADDR = 0x%x" % UART_BASE_ADDR, "\n")

        module_presence_rdback_value = get_reg_value(glu_reg_base_addr + REG_MOD_PRESENCE_RDBCK)
        if verbose:
            print("module_presence_rdback_value = 0x%x" % module_presence_rdback_value)

    # Read LCR register (0x100C) : verify LCR(7) = 0
    LCR_value = get_reg_value(glu_reg_base_addr + (UART_BASE_ADDR + UART_LCR))
    if verbose:
        print("Read LCR_value = 0x%x" % LCR_value, "@ addr = 0x%x (LCR reg.)" %UART_LCR)

    # LCR(7) = 0 : read @ 0x01000 addr i.e RBR register
    RBR_value = get_reg_value(glu_reg_base_addr + (UART_BASE_ADDR + UART_RBR_DLL))
    if verbose:
        print("Read RBR_value = 0x%x" % RBR_value, "@ addr = 0x%x (RBR_DLL reg.)" %UART_RBR_DLL)

    # LCR register (0x100C) : set LCR(7) = 1
    data_val =  0x80
    if verbose:
        print("Write = 0x%x" % data_val, " @ addr = 0x%x (LCR reg.)" %UART_LCR)
    reg_write(glu_reg_base_addr + (UART_BASE_ADDR + UART_LCR), data_val)

    LCR_value = get_reg_value(glu_reg_base_addr + (UART_BASE_ADDR + UART_LCR))
    if verbose:
        print("Read LCR_value = 0x%x" % LCR_value, "@ addr = 0x%x (LCR reg.)" %UART_LCR)

    # LCR(7) = 1 : read @ 0x01000 addr i.e DLL register
    DLL_value = get_reg_value(glu_reg_base_addr + (UART_BASE_ADDR + UART_RBR_DLL))
    if verbose:
        print("Read DLL_value = 0x%x" % DLL_value, "@ addr = 0x%x (RBR_DLL reg.)" %UART_RBR_DLL)

    # Program uart baudrate :

    data_val =  0x8b
    if verbose:
        print("Write = 0x%x" % data_val, "@ addr = 0x%x (LCR reg.)" %UART_RBR_DLL)
    reg_write(glu_reg_base_addr + (UART_BASE_ADDR + UART_RBR_DLL), data_val)

    DLL_value = get_reg_value(glu_reg_base_addr + (UART_BASE_ADDR + UART_RBR_DLL))
    if verbose:
        print("Read DLL_value = 0x%x" % DLL_value, "@ addr = 0x%x (RBR_DLL reg.)" %UART_RBR_DLL)

    # LCR(7) = 1 : read @0x01004 addr i.e DLM register
    DLM_value = get_reg_value(glu_reg_base_addr + (UART_BASE_ADDR + UART_DLM))
    if verbose:
        print("Read DLM_value = 0x%x" % DLM_value, "@ addr = 0x%x" %UART_DLM)

    data_val =  0x2
    if verbose:
        print("Write = 0x%x" % data_val, "@ addr = 0x%x (LCR reg.)" %UART_DLM)
    reg_write(glu_reg_base_addr + (UART_BASE_ADDR + UART_DLM), data_val)

    DLM_value = get_reg_value(glu_reg_base_addr + (UART_BASE_ADDR + UART_DLM))
    if verbose:
        print("Read DLM_value = 0x%x" % DLM_value, "@ addr = 0x%x" %UART_DLM)

    # Write 0x3 into LCR register (0x100C) : clear LCR(7)
    #
    # LCR(1:0) = WLS (Word Length Select) = b'11 => 8 bits/character
    # LCR(2) = STB (STop Bit) => 0 = 1 Stop bit

    data_val =  0x3
    if verbose:
        print("Write = 0x%x" % data_val, "@ addr = 0x%x (LCR reg.)" %UART_LCR)
    reg_write(glu_reg_base_addr + (UART_BASE_ADDR + UART_LCR), data_val)

    LCR_value = get_reg_value(glu_reg_base_addr + (UART_BASE_ADDR + UART_LCR))
    if verbose:
        print("Read LCR_value = 0x%x" % LCR_value, "@ addr = 0x%x (LCR reg.)" %UART_LCR)

    # LCR(7) = 0 : write 0x1 @ 0x01008 addr i.e FCR register (Fifo Control register)
    data_val =  0x1
    if verbose:
        print("Write = 0x%x" % data_val, "@ addr = 0x%x (FCR reg.)" %UART_FCR)
    reg_write(glu_reg_base_addr + (UART_BASE_ADDR + UART_FCR), data_val)

    if verbose:
        print("**** Launch Tx values :" )

    Tx_value = [0x1, 0x2, 0x4, 0x8, 0x10, 0x20, 0x40, 0x80]
    i = 0
    while i < len(Tx_value):
        reg_write(glu_reg_base_addr + (UART_BASE_ADDR + UART_RBR_DLL), Tx_value[i])
        if verbose:
            print("Write = 0x%x" % Tx_value[i], "@ addr = 0x%x (RBR reg.)" %UART_RBR_DLL)

        if i == 0:
            time.sleep(10)
        else:
            time.sleep(2)
        i += 1

    time.sleep(2)

    Tx_value = 0x71
    reg_write(glu_reg_base_addr + (UART_BASE_ADDR + UART_RBR_DLL), Tx_value)
    if verbose:
        print("Write = 0x%x" % Tx_value, "@ addr = 0x%x (RBR reg.)" %UART_RBR_DLL)

    return None
#
#=============================================================================================
@DIAG("OSB : FPGA XADC On-Chip Temperature test")
def t_osb_temp_fpga_test(cmd):
#=============================================================================================
#
## FPGA XADC block address = 0x00_4000_2000
#
    debug = False
    res = 0

    try:
        (command, consigne) = cmd.split()

    except:
        print_error("   Syntax error : Command must be : t_osb_xadc_temp_test <consigne>")
        print_error("                                                            ")
        print_error("   where            <consigne> is : <Min_value>;<Max_value>")
        return False

    print_info("* consigne is "+consigne)
    (min_value_str, max_value_str) = consigne.split(';')

    print_info("     * min_value is "+min_value_str+"C")
    print_info("     * max_value is "+max_value_str+"C")

    val_hex = sysfs_read_string("/sys/platform/osb-xadc/temperature")
    val = int(val_hex, 16) / 16
    val_temperature = (val * 504 / 4095) - 273

    min_value = int(min_value_str)
    max_value = int(max_value_str)
    if val_temperature == min_value or (val_temperature > min_value and val_temperature < (max_value+1)):
        msg= "PASS"
        res += 1
    else:
        msg= "FAIL"

    print("\n   * Using osb-xadc driver, XADC temperature = %d C : %s" %(val_temperature, msg))

    glu_reg_base_addr = get_glu_base_addr()

    if debug:
        print("glu_reg_base_addr = 0x%x" %glu_reg_base_addr, "\n")

    xadc_temp_value = int(get_reg_value(glu_reg_base_addr + XADC_TEMP_REG)/16)
    val_temperature_reg = (xadc_temp_value * 504 / 4095) - 273

    if val_temperature_reg == min_value or (val_temperature_reg > min_value and val_temperature_reg < (max_value+1)):
        msg= "PASS"
        res += 1
    else:
        msg= "FAIL"
    print("   * Using OSB_FPGA register, XADC temperature = %d C : %s" %(val_temperature_reg, msg))

    if res == 2:
        return True
    else:
        return False
#
#=============================================================================================
@DIAG("OSB : sicutil init for Board V1")
def t_osb_sicutil_init(cmd):
#=============================================================================================
#
    try:
        (command) = cmd.split()

    except:
        print_error("# Command must be: t_osb_sicutil_init")
        return False

    Hetnet_Module = "4"
    fab_date = datetime.today().strftime('%Y%m%d')
    err = 0
    p = subprocess.Popen("sicutil -w -sys %s  HardwareSetName OSB" % (Hetnet_Module), shell=True,
                         stdin=subprocess.PIPE, stdout=subprocess.PIPE, stderr=subprocess.STDOUT, close_fds=True)
    p.wait();
    err += p.returncode;
    print(".", end='', flush=True)
    p = subprocess.Popen("sicutil -w -sys %s  HardwareSetId 703100B01-001" % (Hetnet_Module), shell=True,
                         stdin=subprocess.PIPE, stdout=subprocess.PIPE, stderr=subprocess.STDOUT, close_fds=True)
    p.wait();
    err += p.returncode;
    print(".", end='', flush=True)
    p = subprocess.Popen("sicutil -w -sys %s  Revision 2" % (Hetnet_Module), shell=True, stdin=subprocess.PIPE,
                         stdout=subprocess.PIPE, stderr=subprocess.STDOUT, close_fds=True)
    p.wait();
    err += p.returncode;
    print(".", end='', flush=True)
    p = subprocess.Popen("sicutil -w -sys %s  SerialNumber 00001" % (Hetnet_Module), shell=True, stdin=subprocess.PIPE,
                         stdout=subprocess.PIPE, stderr=subprocess.STDOUT, close_fds=True)
    p.wait();
    err += p.returncode;
    print(".", end='', flush=True)
    p = subprocess.Popen("sicutil -w -sys %s  ManufactureDate %s" % (Hetnet_Module, fab_date), shell=True,
                         stdin=subprocess.PIPE, stdout=subprocess.PIPE, stderr=subprocess.STDOUT, close_fds=True)
    p.wait();
    err += p.returncode;
    print(".", end='', flush=True)
    p = subprocess.Popen("sicutil -w -sys %s  CalibrationDate 20000101" % (Hetnet_Module), shell=True,
                         stdin=subprocess.PIPE, stdout=subprocess.PIPE, stderr=subprocess.STDOUT, close_fds=True)
    p.wait();
    err += p.returncode;
    print(".", end='', flush=True)
    p = subprocess.Popen("sicutil -w -sys %s  MinimumPower 1" % (Hetnet_Module), shell=True, stdin=subprocess.PIPE,
                         stdout=subprocess.PIPE, stderr=subprocess.STDOUT, close_fds=True)
    p.wait();
    err += p.returncode;
    print(".", end='', flush=True)
    p = subprocess.Popen("sicutil -w -sys %s  CriticalTemp 85" % (Hetnet_Module), shell=True, stdin=subprocess.PIPE,
                         stdout=subprocess.PIPE, stderr=subprocess.STDOUT, close_fds=True)
    p.wait();
    err += p.returncode;
    print(".", end='', flush=True)
    p = subprocess.Popen("sicutil -w -sys %s  PcieEndpoints 4" % (Hetnet_Module), shell=True, stdin=subprocess.PIPE,
                         stdout=subprocess.PIPE, stderr=subprocess.STDOUT, close_fds=True)
    p.wait();
    err += p.returncode;
    print(".", end='', flush=True)
    p = subprocess.Popen("sicutil -w -sys %s  ParentSerialNumber none" % (Hetnet_Module), shell=True,
                         stdin=subprocess.PIPE, stdout=subprocess.PIPE, stderr=subprocess.STDOUT, close_fds=True)
    p.wait();
    err += p.returncode;
    print(".", end='', flush=True)
    p = subprocess.Popen("sicutil -r -sys %s" % (Hetnet_Module), shell=True, stdin=subprocess.PIPE,
                         stdout=subprocess.PIPE, stderr=subprocess.STDOUT, close_fds=True)
    p.wait();
    err += p.returncode;
    print(".", flush=True)
    lines = p.stdout.readlines()
    for l in lines:
        l = l.decode("utf-8").strip()
        if l:
            print_info("# %s" % (l))
            columns = [item.strip() for item in l.split(':')]
    return err == 10


#
#=============================================================================================
@DIAG("OSB : sicutil init for Board V2")
def t_osb_sicutil_init_v2(cmd):
#=============================================================================================
#
    try:
        (command) = cmd.split()

    except:
        print_error("# Command must be: t_osb_sicutil_init")
        return False

    Hetnet_Module = "4"
    fab_date = datetime.today().strftime('%Y%m%d')
    err = 0
    p = subprocess.Popen("sicutil -w -sys %s  HardwareSetName OSB" % (Hetnet_Module), shell=True,
                         stdin=subprocess.PIPE, stdout=subprocess.PIPE, stderr=subprocess.STDOUT, close_fds=True)
    p.wait();
    err += p.returncode;
    print(".", end='', flush=True)
    p = subprocess.Popen("sicutil -w -sys %s  HardwareSetId 70310EB01-001" % (Hetnet_Module), shell=True,
                         stdin=subprocess.PIPE, stdout=subprocess.PIPE, stderr=subprocess.STDOUT, close_fds=True)
    p.wait();
    err += p.returncode;
    print(".", end='', flush=True)
    p = subprocess.Popen("sicutil -w -sys %s  Revision 2" % (Hetnet_Module), shell=True, stdin=subprocess.PIPE,
                         stdout=subprocess.PIPE, stderr=subprocess.STDOUT, close_fds=True)
    p.wait();
    err += p.returncode;
    print(".", end='', flush=True)
    p = subprocess.Popen("sicutil -w -sys %s  SerialNumber 00001" % (Hetnet_Module), shell=True, stdin=subprocess.PIPE,
                         stdout=subprocess.PIPE, stderr=subprocess.STDOUT, close_fds=True)
    p.wait();
    err += p.returncode;
    print(".", end='', flush=True)
    p = subprocess.Popen("sicutil -w -sys %s  ManufactureDate %s" % (Hetnet_Module, fab_date), shell=True,
                         stdin=subprocess.PIPE, stdout=subprocess.PIPE, stderr=subprocess.STDOUT, close_fds=True)
    p.wait();
    err += p.returncode;
    print(".", end='', flush=True)
    p = subprocess.Popen("sicutil -w -sys %s  CalibrationDate 20000101" % (Hetnet_Module), shell=True,
                         stdin=subprocess.PIPE, stdout=subprocess.PIPE, stderr=subprocess.STDOUT, close_fds=True)
    p.wait();
    err += p.returncode;
    print(".", end='', flush=True)
    p = subprocess.Popen("sicutil -w -sys %s  MinimumPower 1" % (Hetnet_Module), shell=True, stdin=subprocess.PIPE,
                         stdout=subprocess.PIPE, stderr=subprocess.STDOUT, close_fds=True)
    p.wait();
    err += p.returncode;
    print(".", end='', flush=True)
    p = subprocess.Popen("sicutil -w -sys %s  CriticalTemp 85" % (Hetnet_Module), shell=True, stdin=subprocess.PIPE,
                         stdout=subprocess.PIPE, stderr=subprocess.STDOUT, close_fds=True)
    p.wait();
    err += p.returncode;
    print(".", end='', flush=True)
    p = subprocess.Popen("sicutil -w -sys %s  PcieEndpoints 4" % (Hetnet_Module), shell=True, stdin=subprocess.PIPE,
                         stdout=subprocess.PIPE, stderr=subprocess.STDOUT, close_fds=True)
    p.wait();
    err += p.returncode;
    print(".", end='', flush=True)
    p = subprocess.Popen("sicutil -w -sys %s  ParentSerialNumber none" % (Hetnet_Module), shell=True,
                         stdin=subprocess.PIPE, stdout=subprocess.PIPE, stderr=subprocess.STDOUT, close_fds=True)
    p.wait();
    err += p.returncode;
    print(".", end='', flush=True)
    p = subprocess.Popen("sicutil -r -sys %s" % (Hetnet_Module), shell=True, stdin=subprocess.PIPE,
                         stdout=subprocess.PIPE, stderr=subprocess.STDOUT, close_fds=True)
    p.wait();
    err += p.returncode;
    print(".", flush=True)
    lines = p.stdout.readlines()
    for l in lines:
        l = l.decode("utf-8").strip()
        if l:
            print_info("# %s" % (l))
            columns = [item.strip() for item in l.split(':')]
    return err == 10
#
#================================================================================
@DIAG("OSB : sicutil read")
def t_osb_sicutil_r(cmd):
#================================================================================    
#
# t_osb_sicutil_r 4 all
#
# lines is [b'HardwareSetName\t: CPB\n', b'HardwareSetId  \t: 703100B11-001\n', b'Revision       \t: 0\n', b'SerialNumber   \t: EBAP00005\n', #b'ManufactureDate\t: 20210412\n', b'CalibrationDate\t: 20220110\n', b'MinimumPower   \t: 6\n', b'CriticalTemp   \t: 85\n', b'PcieEndpoints  \t: 3\n', #b'ParentSerialNumber\t: none\n']
#
    try:
        (command, field) = cmd.split()
    except:
        print_error("# Command must be: t_osb_sicutil_r field/'all'")
        return False

    Hetnet_Module = "4"
    if (field == "all"):
        p = subprocess.Popen("sicutil -r -sys %s" % (Hetnet_Module), shell=True, stdin=subprocess.PIPE,
                             stdout=subprocess.PIPE, stderr=subprocess.STDOUT, close_fds=True)
    else:
        print(field)
        p = subprocess.Popen("sicutil -r -sys %s %s" % (Hetnet_Module, field), shell=True, stdin=subprocess.PIPE,
                             stdout=subprocess.PIPE, stderr=subprocess.STDOUT, close_fds=True)
    p.wait()
    err = p.returncode
    lines = p.stdout.readlines()
    #print("err is %s; lines is %s" %(err,lines))
    l = False
    for l in lines:
        l = l.decode("utf-8").strip()
        if l:
            print_info("# %s" % (l))
            columns = [item.strip() for item in l.split(':')]
    #print("l is", l)
    if l:
        return True
    else:
        return False
#
#=============================================================================================
@DIAG("OSB : sicutil write")
def t_osb_sicutil_w(cmd):
#=============================================================================================
#
    try:
        (command, field, field_value) = cmd.split()
    except:
        print_error("# Command must be: t_osb_sicutil_w field field_value")
        print_error(
            "# Possible field are: # HardwareSetName  # HardwareSetId # Revision # SerialNumber # ManufactureDate # CalibrationDate # MinimumPower # CriticalTemp # PcieEndpoints # ParentSerialNumber")
        return False

    print(field)
    Hetnet_Module = "4"

    p = subprocess.Popen("sicutil -w -sys %s %s %s" % (Hetnet_Module, field, field_value), shell=True,
                         stdin=subprocess.PIPE, stdout=subprocess.PIPE, stderr=subprocess.STDOUT, close_fds=True)
    p.wait()
    err = p.returncode
    print(err)
    lines = p.stdout.readlines()
    for l in lines:
        l = l.decode("utf-8").strip()
        if l:
            print_info("# %s" % (l))
            columns = [item.strip() for item in l.split(':')]
            return False
    return True
#
#================================================================================
@DIAG("OSB : Write QSPI Flash if necessary")
def t_osb_prog_flash(cmd):
#================================================================================
#
    try:
        (command) = cmd.split()
    except:
        print_error("# Command must be: t_osb_prog_flash ")
        return False

    if (os.path.exists("/lib/firmware/viavi/osb.bin")):
        p = subprocess.Popen("fiberprogfpga ste1 -sf 4 /lib/firmware/viavi/osb.bin" , shell=True, stdin=subprocess.PIPE,
                        stdout=subprocess.PIPE, stderr=subprocess.STDOUT, close_fds=True)
        p.wait()
        err = p.returncode
        print(err)
    else:
        print("/lib/firmware/viavi/osb.bin not found")
        return False

    lines = p.stdout.readlines()
    for l in lines:
        l = l.decode("utf-8").strip()
        if l:
            print_info("# %s" % (l))
            columns = [item.strip() for item in l.split(':')]

    if err == 0 or err == 11:
        return True
    else:
        return False
#
#================================================================================
@DIAG("OSB : Write QSPI Flash with all '1' (erase)")
def t_osb_erase_flash(cmd):
#================================================================================
#
    try:
        (command) = cmd.split()
    except:
        print_error("# Command must be: t_osb_erase_flash ")
        return False

    byte_arr = [255]
    binary_format = bytearray(byte_arr)
    print_info("# Creating /tmp/erase.bin")
    f = open('/tmp/erase.bin', 'w+b')
    for i in range(2*1024*1024):
        f.write(binary_format)
    f.close()

    print_info("# Flashing /tmp/erase.bin")
    p = subprocess.Popen("fiberprogfpga ste1 -sf 4 /tmp/erase.bin" , shell=True, stdin=subprocess.PIPE,
                         stdout=subprocess.PIPE, stderr=subprocess.STDOUT, close_fds=True)
    p.wait()
    err = p.returncode
    print(err)

    lines = p.stdout.readlines()
    for l in lines:
        l = l.decode("utf-8").strip()
        if l:
            print_info("# %s" % (l))
            columns = [item.strip() for item in l.split(':')]

    if err == 0 or err == 11 or err == 7:
        return True
    else:
        return False
#
#================================================================================
def udev_add_rules():
#================================================================================
#
    lines = ['SUBSYSTEM=="tty", KERNELS=="3-1.1.1:1.0", SYMLINK="ttyUSB_M1"','SUBSYSTEM=="tty", KERNELS=="3-1.1.4:1.0", SYMLINK="ttyUSB_M2"']
    with open('/etc/udev/rules.d/99-tmp-pydiag.rules', 'w') as f:
        for line in lines:
            f.write(line)
            f.write('\n')
    f.close()

    #Reload rules
    p = subprocess.Popen("udevadm control --reload-rules", shell=True,
                         stdin=subprocess.PIPE, stdout=subprocess.PIPE, stderr=subprocess.STDOUT, close_fds=True)
    p.wait();
    p = subprocess.Popen("udevadm test $(udevadm info -q path -n /dev/ttyUSB0)", shell=True,
                         stdin=subprocess.PIPE, stdout=subprocess.PIPE, stderr=subprocess.STDOUT, close_fds=True)
    p.wait();
    p = subprocess.Popen("udevadm test $(udevadm info -q path -n /dev/ttyUSB1)", shell=True,
                         stdin=subprocess.PIPE, stdout=subprocess.PIPE, stderr=subprocess.STDOUT, close_fds=True)
    p.wait();
    return True;
#
#================================================================================
@DIAG("OSB : RS485 test")
def t_osb_rs485(cmd):
#================================================================================
#
    buffer = b'{aM\\\xe1\x8a\xe5L\xc4+rW9\xed\x8eFR\x10\xff\xe9\xcf;[' \
             b'\xe3\x1d\x1b\xa3\xab\x84\xdf\xe0NA\xad\xd5VQ\xeb\x15\x15"\xdf\x14\xe4\xc4\xa1\x83\xaa\x87\xd0\x1e&7' \
             b'\x8b\xc1\xbd\x04\xa0/:\xfb\xa0\xbb\xf0!\xa8\x08<\xe7%\x99\xb2#\xd8y{\xebzMt\xce| ' \
             b'\x01\xed\xb8\x99\xbb\xa3\xb1j;\xbe\xc7J`\xe3\xe1\x8eg\xfdC\x97@&D\x10\x08Vd4R"\n\x9b\xeaz\x07\xc7>5' \
             b'\xe9\xdd\xcfmK\xbb\xc3\xbb!\xf1\x83\x81]N\xe6=\xe3\xd6\x84\xb1;\xac\xde\x87\x91\x7fq#\xe3\xc4\xf00[' \
             b'\xd3\x8e\x9at\xa3\x10\xbf\x8a\xc7\xd8\xa9\x15\xcfK\xfc\x0b\x86\x1a\xfa\xfb\x17iX,' \
             b'\r\x96\x18\xbf\xd7\xb7=\xad\xc0\xfd{' \
             b'\x94\xecG\x03\xf7\x89\xaa\xc9\xe6\x89\x94l\x85\x1aU\x13\x07\xd7\'\x0b\xfc!*\x89\xad\xe6\x1eK\xd9E\xed' \
             b'\x01\x86C\x84\xdc\xe7\x0f\x95\xc9\x9d"z\x9a^7\xd1RI:\xbb\xa1\x84$\xe4\x1e\x8c\xed\x90\xe3\\?e3\xc1S' \
             b'\xe5\xf9|\x1a\xc4\xefC\xee\xab\xb4\xb3\x81\xd6\n\x17\xf1\xaaJPm\xb9\xf5\xec\xbb\xe87\xfe\xaf\x9c\xc5' \
             b'\x8d\xbd\xed2/\xb9\xe9\x8d\x9a\x99\xf8\xe4\xd5L\xc9\xe0\xac3\xf2\xe3}\xa2@?\xfc\xde>^$C&\xcd\xe7\xb2' \
             b'\xa9\xddY/a\xcbE\x92sJ\xc0\xb4Y\x84\x14\xbaR!\xb1!\xbe\xcdv!\xa4\xde\x85\xd0\x0b\xa8\\p~\xfd\x807\x17' \
             b'\xd8\xcc\xc3\x07\xea_\xab\x8fF8\x1e\x0ed\x86\x88\x14\xb4\xbe{\xa9\xbd\x0b6O\x0cB\xf9\x8e\xf8# ' \
             b'\xd5\xbb\xeb\x15\x10f\x9b\x1axx\x98\xc8y]\xee\xde\xae\xbfh\xa6\x12\xb9\x18\xb8N\x17\x7f\xaau\x9dp\x99' \
             b'\x93\xa1<_F\x11\x154O\xb9\x97<nYz>j\x91\t\xdc2\xc3\xfc[' \
             b'\xdd\xc6\x0b1I\x83\x99\xf8\xf2BI\x97\r\x8a\xd2}!\xa13\x0e\x9b1\xbf\xb5 ' \
             b'\x92\xfe\xd9\xbfrtW\xe7\xe3\x12\xb1\x84\xf7z\x15\xcdRGa\xf6\x9c\xf3\xfc\xe7\x7f\xbb\xefq\xc9BRAc\x9e' \
             b'\x8b\x8a\x99\xde\xed\xa1\x14\x8a\xf6C@\x17\x114\x92\xd0\xbf\xb1$1\xb0lS\x86\x02\x83\xb9\xbf\x1b\xb3' \
             b'\x1bE}\x94chO\xf9yNs\xe5Lm*\xf5\x80\xba\xf9\x97wrh"T\x81a\x0b\xaf\xa6\x8f,' \
             b'\xfe\x8a].\xd1\x16Fi\x14\x8b\xe3\x06;\xdeGMq\x1e\xbe{' \
             b'\xcd\xb3\xd5\x95\'9\xeew\x06\x12s\xf2\x1f\\E\xb2\xa3\x9bP\xfc\x05\xca\x81\x03\xcb\x1f\xe1\xa2\xc0R\xbe' \
             b'\x07N\x0c\xe0\xb7\xb4$\xf9\xdf\x87\xbc\x86\x05U\xc7\x00\xd5\xac\x96\xd4sz\xd0\x9d7\x10\xf2\x01Z~\xed' \
             b'\xf5\xc6\x8aUA{\x17\x8a\xdc\x02GA\x8d\x98\x0f\xb9p\xef9\x91\x19k\x0f\x8c\x0eS\x17\x03\x12\xdf\x11\xcd' \
             b'\x1f\xc3V\x8e=M\x1f\x97\x0fW\xde\x04\x1e!y6 ' \
             b'\n\xbe\xca\x86\xe3\x13D\x89\x84N\xfbK\xf2L\xc9\xe0\x1f\xb4\xc1r\r\x91\x1c\xe7P\xae\x11\xe2^Z\xf9\xa5' \
             b'-\n\xcf\xad\x97Wl\xa3\x94\xfc\xffD\xf0\xc0\xb5\x88\xb0>\x16(' \
             b'\xdb\xd9\x82\x13\x9d\x82^O\xa4\xc0E\xea\xf8\xd5i)\x03\x1e\x01\xc3N\x89S\x97\x94\xeabs\x85K\xb7\xf0\x8e' \
             b'\xf2\xd3\xe7s!\xa1bp\xd70kgilz\x04\x07\xf8\xa4]D\xb9x9\x83\x88H\xe1P\x8c%S\xfb\x12\x14\xd1\x845`\x92' \
             b'\x84W\xfdO\x82\xc6\xa1Q\x01\x1e\xa8P\x17mS\x14\xf2\x8e\xc1\xbeu\xc0Q\x96\x1d\xdb\xbb\xf0\x9b\xa7i\xb6' \
             b'\xf5\xf4\x01AJf<\xeb;\x86\xea\x05J\x02\x14.\xd0@\xe1\xd9\xd8D4\xd5z"\r\nbh\x19\xec\x18\xe4W\xd0\x83' \
             b'\x95\xe8\x84\x05\xc0/s\xa1\xbbB\xdc\x7f\x91\xf0\xe5\x89\xc7\r\xef\xc2\x1e\\\xf8?\x1c\xf5\x82\xd1' \
             b'}\xf4NL\x85\x15\xf3\xb1\x89\xa8\xa5e\x1aJ\x9f\xfa\x0bL\xdb\xd7\rS\n\xcf\xba|\xe2\xae\x0fd\xb9\xc5\xe05' \
             b'\x7f\x0bQ\xaaO>C\x84G\xa0\xd8\xc9\x9e\x13:2Ni\x12\xb3\xd2\xab+gh\xb4\xf3\xecwm\xda\xfam\xea4\x1a\x966h' \
             b'=\xe9\x8a\xcc\xca\xe4g\xaa6\x89\x90\x0bF\xb4\xe3\xa9\x1b\x1a\xc6\x17\x8c\xba\xcb)\xdb\xd9\x17\xd0\xb7' \
             b'\xd4=\x91\x8f\x04'
    buffer_size = len(buffer)

    udev_add_rules()

    serial_device = "/dev/ttyUSB_M1"
    rs485_device = "/dev/ttyRS485"

    exit_flag = False
    
    if not os.path.exists(rs485_device, ):
        print_error("# RS485 not detected")
        exit_flag = True
    if not os.path.exists(serial_device):
        print_error("# Testing serial port not detected")
        exit_flag = True

    if exit_flag:
        return False

    b200_serial = serial.Serial(serial_device, baudrate=115200, bytesize=8, parity='N', stopbits=1, timeout=15,
                               xonxoff=0, rtscts=0)
    b01_serial = serial.Serial(rs485_device, baudrate=115200, bytesize=8, parity='N', stopbits=1, timeout=15, xonxoff=0,
                               rtscts=0)

    print()
    serials = [b200_serial, b01_serial]
    for _ in range(1, 3):
        serials[0].flushOutput()
        serials[0].flushInput()
        serials[1].flushOutput()
        serials[1].flushInput()
        print_info("# transferring buffer from {} to {}".format(serials[0].name, serials[1].name))
        serials[0].write(buffer)
        read_buff = serials[1].read(buffer_size)
        if buffer != read_buff:
            print_error("# Communication error for {} <-> {}, send {} - received {}".format(
                serials[0].name, serials[1].name, len(buffer), len(read_buff)))
            file = open("/var/tmp/buffer.bin", 'wb')
            file.write(buffer)
            file.flush()
            file = open("/var/tmp/read_buffer.bin", 'wb')
            file.write(read_buff)
            file.flush()
            return False
        serials[0], serials[1] = serials[1], serials[0]

    b200_serial.close()
    b01_serial.close()

    return True
#
#=============================================================================================
@DIAG("B200 : Check if I2C SWITCH eeprom is present at 0x52")
def t_osb_i2c_switch(cmd):
#=============================================================================================
#
    try:
        (command) = cmd.split()
    except:
        print_error("# Command must be: t_osb_i2c_switch ")
    f = open("/sys/platform/uts_scan/i2c_master_s3_pw", "r")
    i2c_bus = f.readline()
    f.close()
    i2c_bus = int(i2c_bus)
    print(print("i2c_bus = %d" %i2c_bus))
    if i2c_bus <= 0:
        print("Bad i2c_bus %d detected in /sys/platform/uts_scan/i2c_master_s3_pw" %i2c_bus)
        return False

    eeprom = smbus.SMBus(i2c_bus)
    address = 0x52
    try:
        val = eeprom.read_i2c_block_data(address, 0, 4)
        print("B200 SWITCH EEPROM detected")
        return True
    except:
        print("B200 SWITCH EEPROM Not detected")
        return False
#
#=============================================================================================
@DIAG("B200 : Check if IC DTS2S eeprom is present at 0x52")
def t_osb_i2c_dtss(cmd):
#=============================================================================================
#
    try:
        (command) = cmd.split()
    except:
        print_error("# Command must be: t_osb_i2c_dtss  ")

    f = open("/sys/platform/uts_scan/i2c_master_s4_pw", "r")
    i2c_bus = f.readline()
    f.close()
    i2c_bus = int(i2c_bus)
    print("i2c_bus = %d" %i2c_bus)

    if i2c_bus <= 0:
        print("Bad i2c_bus %d detected in /sys/platform/uts_scan/i2c_master_s4_pw" %i2c_bus)
        return False

    eeprom = smbus.SMBus(i2c_bus)
    address = 0x52
    try:
        val = eeprom.read_i2c_block_data(address, 0, 4)
        print("B200 DTSS EEPROM detected")
        return True
    except:
        print("B200 DTSS EEPROM Not detected")
        return False
#
#=============================================================================================
@DIAG("B200 : SPI read test")
def t_osb200_spi_test(cmd):
#=============================================================================================
#
    try:
        (command, b200_cpld_version) = cmd.split()
    except:
        print_error("# Command must be: t_osb200_spi_test <B200_cpld_version> (hex)")
        return False

    # pwrside
    side = 0
    slice = B200_SLICE
    if (os.path.exists("/dev/uts_spi")):
        Utsspi = utsspi.SpiModule(side, slice, "/dev/uts_spi")
    else:
        print("Utsspi driver (/dev/uts_spi) not found")
        return False

    # Read B200 CPLD VERSION
    cpld_version = Utsspi.read_mod_register8(SPI_ADDR_VERSION)
    
    if cpld_version == int(b200_cpld_version, 16):
        print_ok("B200 : CPLD Version read_value = 0x%2x" % cpld_version)
        return True
    else:
        print_error("B200 : CPLD Version read_value = 0x%2x (exp_value = 0x%x"\
                     %(cpld_version, B200_cpld_version))
        return False
#
#=============================================================================================
@DIAG("B200 : UART test")
def t_osb200_uart_test(cmd):
#=============================================================================================
#
    debug = False
    verbose = False

    glu_reg_base_addr = get_glu_base_addr()
    if debug:
        print("glu_reg_base_addr = 0x%x" %glu_reg_base_addr, "\n")

    my_verbose = False
    periph_reset_gen("release", my_verbose)

    UART_BASE_ADDR = UART_MOD_BASE_ADDR

    module_presence_rdback_value = get_reg_value(glu_reg_base_addr + REG_MOD_PRESENCE_RDBCK)
    switch_bit = module_presence_rdback_value & 0x1
    dtss_bit = (module_presence_rdback_value & 0x2)/2
    dtss_fpga_rdy_bit = (module_presence_rdback_value & 0x4)/4

    if debug:
        print("* OSB module_presence_rdback register details :")
        print("  module_presence_rdback_value read = 0x%x" % module_presence_rdback_value)
        print("     * module_presence_rdback(2) = DTSS_FPGA_RDY = %d ('0' = ABSENT ; '1' = present)" %dtss_fpga_rdy_bit)
        print("     * module_presence_rdback(1) = DTSS_PRES     = %d ('0' = ABSENT ; '1' = present)" %dtss_bit)
        print("     * module_presence_rdback(0) = SWITCH_PRES   = %d ('0' = ABSENT ; '1' = present)\n" %switch_bit, "\n")

    if debug:
        print("UART_BASE_ADDR = 0x%x" % UART_BASE_ADDR, "\n")

    # Use spi_switch

    side = 0
    slice = B200_SLICE
    if (os.path.exists("/dev/uts_spi")):
        Utsspi = utsspi.SpiModule(side, slice, "/dev/uts_spi")
    else:
        print("Utsspi driver (/dev/uts_spi) not found")
        return False

    value = Utsspi.read_mod_register8(SPI_ADDR_BOARD_PRES)
    switch_pres_b_bit = value & 0x1
    dtss_pres_b_bit   = (value & 0x2)/2
    toggle_bit        = (value & 0x4)/4
    board_id          = (value & 0x80)/128

    if debug:
        print("* B200 module_presence_rdback register details (after write) :")
        print("     * module_presence_rdback read (@ addr 0x%1x) = 0x%x" %(SPI_ADDR_BOARD_PRES, value))
        print("         - BOARD_ID           = %d (2 = SWITCH ; 1 = DTSS)" %board_id)
        print("         - toggle_board_state = %d " %toggle_bit)
        print("         - DTSS_PRES_B        = %d ('0' = Selected ; '1' = DeSelected)" %dtss_pres_b_bit)
        print("         - SWITCH_PRES_B      = %d ('0' = Selected ; '1' = DeSelected)\n" %switch_pres_b_bit)

    if board_id == 1:
        print ("* Run b200_module_type_set(SWITCH)")
        b200_module_type_set("SWITCH", verbose)

    b200_UART_reg = Utsspi.read_mod_register8(SPI_ADDR_UART)
    ctsn_bit  = b200_UART_reg & 0x1
    rtsn_bit  = (b200_UART_reg & 0x2)/2
    dtrn_bit  = (b200_UART_reg & 0x4)/4

    if debug:
        print("* B200_UART_reg at init = 0x%x" % b200_UART_reg, "@ addr = 0x%x" %SPI_ADDR_UART)
        print("     * bit_2 = OSB_UART_DTR_N     = %d" %dtrn_bit)
        print("     * bit_1 = OSB_UART_RTS_N     = %d" %rtsn_bit)
        print("     * bit_0 = OSB_UART_CTS_N_bit = %d\n" %ctsn_bit)

    # Modem Status Register (MSR)  : to read CTS = MSR(4)

    print("* CTSn test")

    MSR_value = get_reg_value(glu_reg_base_addr + (UART_BASE_ADDR + UART_MSR))
    DCTS_bit = MSR_value & 0x1
    DDSR_bit = (MSR_value & 0x2)/2
    TERI_bit = (MSR_value & 0x4)/4
    DDCR_bit = (MSR_value & 0x8)/8
    CTS_bit  = (MSR_value & 0x10)/16
    DSR_bit  = (MSR_value & 0x20)/32

    if debug:
        print("\nRead OSB MSR_value at init = 0x%x" % MSR_value, "@ addr = 0x%x (MSR reg.)" %UART_MSR)
        print("     * DSR_bit  = %d" %DSR_bit)
        print("     * CTS_bit  = %d" %CTS_bit)
        print("     * DDCD_bit = %d" %DDCR_bit)
        print("     * TERI_bit = %d" %TERI_bit)
        print("     * DDSR_bit = %d" %DDSR_bit)
        print("     * DCTS_bit = %d\n" %DCTS_bit)

    wr_data = 0x1
    ver = Utsspi.write_mod_register8(SPI_ADDR_UART, wr_data)

    b200_UART_reg = Utsspi.read_mod_register8(SPI_ADDR_UART)
    ctsn_bit  = b200_UART_reg & 0x1
    rtsn_bit  = (b200_UART_reg & 0x2)/2
    dtrn_bit  = (b200_UART_reg & 0x4)/4

    if debug:
        print("* B200_UART_reg  after writing '1' = 0x%x" % b200_UART_reg, "@ addr = 0x%x" %SPI_ADDR_UART)
        print("     * bit_2 = OSB_UART_DTR_N     = %d" %dtrn_bit)
        print("     * bit_1 = OSB_UART_RTS_N     = %d" %rtsn_bit)
        print("     * bit_0 = OSB_UART_CTS_N_bit = %d\n" %ctsn_bit)

    MSR_value = get_reg_value(glu_reg_base_addr + (UART_BASE_ADDR + UART_MSR))
    DCTS_bit = MSR_value & 0x1
    DDSR_bit = (MSR_value & 0x2)/2
    TERI_bit = (MSR_value & 0x4)/4
    DDCR_bit = (MSR_value & 0x8)/8
    CTS_bit  = (MSR_value & 0x10)/16
    DSR_bit  = (MSR_value & 0x20)/32

    if debug:
        print("Read OSB MSR_value after writing '1' = 0x%x" % MSR_value, "@ addr = 0x%x (MSR reg.)" %UART_MSR)
        print("     * DSR_bit  = %d" %DSR_bit)
        print("     * CTS_bit  = %d" %CTS_bit)
        print("     * DDCD_bit = %d" %DDCR_bit)
        print("     * TERI_bit = %d" %TERI_bit)
        print("     * DDSR_bit = %d" %DDSR_bit)
        print("     * DCTS_bit = %d\n" %DCTS_bit)

    wr_data = 0x0
    ver = Utsspi.write_mod_register8(SPI_ADDR_UART, wr_data)

    b200_UART_reg = Utsspi.read_mod_register8(SPI_ADDR_UART)
    ctsn_bit  = b200_UART_reg & 0x1
    rtsn_bit  = (b200_UART_reg & 0x2)/2
    dtrn_bit  = (b200_UART_reg & 0x4)/4

    if debug:
        print("* B200_UART_reg  after writing '0' = 0x%x" % b200_UART_reg, "@ addr = 0x%x" %SPI_ADDR_UART)
        print("     * bit_2 = OSB_UART_DTR_N     = %d" %dtrn_bit)
        print("     * bit_1 = OSB_UART_RTS_N     = %d" %rtsn_bit)
        print("     * bit_0 = OSB_UART_CTS_N_bit = %d\n" %ctsn_bit)

    MSR_value = get_reg_value(glu_reg_base_addr + (UART_BASE_ADDR + UART_MSR))
    DCTS_bit = MSR_value & 0x1
    DDSR_bit = (MSR_value & 0x2)/2
    TERI_bit = (MSR_value & 0x4)/4
    DDCR_bit = (MSR_value & 0x8)/8
    CTS_bit  = (MSR_value & 0x10)/16
    DSR_bit  = (MSR_value & 0x20)/32

    if debug:
        print("Read OSB MSR_value after writing '0' = 0x%x" % MSR_value, "@ addr = 0x%x (LCR reg.)" %UART_MSR)
        print("     * DSR_bit  = %d" %DSR_bit)
        print("     * CTS_bit  = %d" %CTS_bit)
        print("     * DDCD_bit = %d" %DDCR_bit)
        print("     * TERI_bit = %d" %TERI_bit)
        print("     * DDSR_bit = %d" %DDSR_bit)
        print("     * DCTS_bit = %d" %DCTS_bit)

    # Modem Control Register (MCR) : to pilot RTS = MCR(0), DTR = MCR(1) bits

#   print("\n*=====================")
    print("* RTSn and DTRn test")
#   print("*=====================\n")

    MCR_value  = get_reg_value(glu_reg_base_addr + (UART_BASE_ADDR + UART_MCR))
    DTR_bit = MSR_value & 0x1
    RTS_bit = (MCR_value & 0x2)/2
    Out1_bit = (MCR_value & 0x4)/4
    Out2_bit = (MCR_value & 0x8)/8
    loop_bit  = (MCR_value & 0x10)/16

    if debug:
        print("Read OSB MCR_value = 0x%x" % MCR_value, "@ addr = 0x%x (MCR reg.)" %UART_MCR)
        print("     * bit_4 = loop_bit = %d" %loop_bit)
        print("     * bit_3 = Out2_bit = %d" %Out2_bit)
        print("     * bit_2 = Out1_bit = %d" %Out1_bit)
        print("     * bit_1 = RTS_bit  = %d" %RTS_bit)
        print("     * bit_0 = DTR_bit  = %d\n" %DTR_bit)

    b200_UART_reg = Utsspi.read_mod_register8(SPI_ADDR_UART)
    ctsn_bit  = b200_UART_reg & 0x1
    rtsn_bit  = (b200_UART_reg & 0x2)/2
    dtrn_bit  = (b200_UART_reg & 0x4)/4
    dtrn_re_bit  = (b200_UART_reg & 0x8)/8
    dtrn_fe_bit  = (b200_UART_reg & 0x10)/16

    if debug:
        print("* B200_UART_reg  after writing '0' = 0x%x" % b200_UART_reg, "@ addr = 0x%x" %SPI_ADDR_UART)
        print("     * bit_4 = OSB_UART_DTR_N_FE  = %d" %dtrn_fe_bit)
        print("     * bit_3 = OSB_UART_DTR_N_RE  = %d" %dtrn_re_bit)
        print("     * bit_2 = OSB_UART_DTR_N     = %d" %dtrn_bit)
        print("     * bit_1 = OSB_UART_RTS_N     = %d" %rtsn_bit)
        print("     * bit_0 = OSB_UART_CTS_N_bit = %d\n" %ctsn_bit)

    data_val =  0x3     # drive RTS_N and DTR_N low
    if debug:
        print("Write = 0x%x" % data_val, " @ addr = 0x%x (MCR reg.)\n" %UART_MCR)
    reg_write(glu_reg_base_addr + (UART_BASE_ADDR + UART_MCR), data_val)

    MCR_value  = get_reg_value(glu_reg_base_addr + (UART_BASE_ADDR + UART_MCR))
    DTR_bit = MSR_value & 0x1
    RTS_bit = (MCR_value & 0x2)/2
    Out1_bit = (MCR_value & 0x4)/4
    Out2_bit = (MCR_value & 0x8)/8
    loop_bit  = (MCR_value & 0x10)/16

    if debug:
        print("Read OSB MCR_value = 0x%x" % MCR_value, "@ addr = 0x%x (MCR reg.)" %UART_MCR)
        print("     * bit_4 = loop_bit = %d" %loop_bit)
        print("     * bit_3 = Out2_bit = %d" %Out2_bit)
        print("     * bit_2 = Out1_bit = %d" %Out1_bit)
        print("     * bit_1 = RTS_bit  = %d" %RTS_bit)
        print("     * bit_0 = DTR_bit  = %d\n" %DTR_bit)

    b200_UART_reg = Utsspi.read_mod_register8(SPI_ADDR_UART)
    ctsn_bit  = b200_UART_reg & 0x1
    rtsn_bit  = (b200_UART_reg & 0x2)/2
    dtrn_bit  = (b200_UART_reg & 0x4)/4
    dtrn_re_bit  = (b200_UART_reg & 0x8)/8
    dtrn_fe_bit  = (b200_UART_reg & 0x10)/16

    if debug:
        print("* B200_UART_reg  after writing '0' = 0x%x" % b200_UART_reg, "@ addr = 0x%x" %SPI_ADDR_UART)
        print("     * bit_4 = OSB_UART_DTR_N_FE  = %d" %dtrn_fe_bit)
        print("     * bit_3 = OSB_UART_DTR_N_RE  = %d" %dtrn_re_bit)
        print("     * bit_2 = OSB_UART_DTR_N     = %d" %dtrn_bit)
        print("     * bit_1 = OSB_UART_RTS_N     = %d" %rtsn_bit)
        print("     * bit_0 = OSB_UART_CTS_N_bit = %d\n" %ctsn_bit)

    data_val =  0x0     # drive RTS_N and DTR_N high
    if debug:
        print("Write = 0x%x" % data_val, " @ addr = 0x%x (MCR reg.)\n" %UART_MCR)
    reg_write(glu_reg_base_addr + (UART_BASE_ADDR + UART_MCR), data_val)

    MCR_value  = get_reg_value(glu_reg_base_addr + (UART_BASE_ADDR + UART_MCR))
    DTR_bit = MSR_value & 0x1
    RTS_bit = (MCR_value & 0x2)/2
    Out1_bit = (MCR_value & 0x4)/4
    Out2_bit = (MCR_value & 0x8)/8
    loop_bit  = (MCR_value & 0x10)/16

    if debug:
        print("Read OSB MCR_value = 0x%x" % MCR_value, "@ addr = 0x%x (MCR reg.)" %UART_MCR)
        print("     * bit_4 = loop_bit = %d" %loop_bit)
        print("     * bit_3 = Out2_bit = %d" %Out2_bit)
        print("     * bit_2 = Out1_bit = %d" %Out1_bit)
        print("     * bit_1 = RTS_bit  = %d" %RTS_bit)
        print("     * bit_0 = DTR_bit  = %d\n" %DTR_bit)

    b200_UART_reg = Utsspi.read_mod_register8(SPI_ADDR_UART)
    ctsn_bit  = b200_UART_reg & 0x1
    rtsn_bit  = (b200_UART_reg & 0x2)/2
    dtrn_bit  = (b200_UART_reg & 0x4)/4
    dtrn_re_bit  = (b200_UART_reg & 0x8)/8
    dtrn_fe_bit  = (b200_UART_reg & 0x10)/16

    if debug:
        print("* B200_UART_reg  after writing '0' = 0x%x" % b200_UART_reg, "@ addr = 0x%x" %SPI_ADDR_UART)
        print("     * bit_4 = OSB_UART_DTR_N_FE  = %d" %dtrn_fe_bit)
        print("     * bit_3 = OSB_UART_DTR_N_RE  = %d" %dtrn_re_bit)
        print("     * bit_2 = OSB_UART_DTR_N     = %d" %dtrn_bit)
        print("     * bit_1 = OSB_UART_RTS_N     = %d" %rtsn_bit)
        print("     * bit_0 = OSB_UART_CTS_N_bit = %d\n" %ctsn_bit)

    my_verbose = False
    periph_reset_gen("release", my_verbose)

    ver = Utsspi.read_mod_register8(SPI_ADDR_VERSION)

    if debug:
        print("* SWITCH CPLD Version 0x%2x\n" % ver)

    b200_UART_reg = Utsspi.read_mod_register8(SPI_ADDR_UART)
    ctsn_bit  = b200_UART_reg & 0x1
    rtsn_bit  = (b200_UART_reg & 0x2)/2
    dtrn_bit  = (b200_UART_reg & 0x4)/4
    dtrn_re_bit  = (b200_UART_reg & 0x8)/8
    dtrn_fe_bit  = (b200_UART_reg & 0x10)/16

    if debug:
        print("* B200_UART_reg  after reset = 0x%x" % b200_UART_reg, "@ addr = 0x%x" %SPI_ADDR_UART)
        print("     * bit_4 = OSB_UART_DTR_N_FE  = %d" %dtrn_fe_bit)
        print("     * bit_3 = OSB_UART_DTR_N_RE  = %d" %dtrn_re_bit)
        print("     * bit_2 = OSB_UART_DTR_N     = %d" %dtrn_bit)
        print("     * bit_1 = OSB_UART_RTS_N     = %d" %rtsn_bit)
        print("     * bit_0 = OSB_UART_CTS_N_bit = %d\n" %ctsn_bit)

    my_verbose = False
    osb_uart_mod_init (my_verbose)

    b200_UART_reg = Utsspi.read_mod_register8(SPI_ADDR_UART)
    ctsn_bit  = b200_UART_reg & 0x1
    rtsn_bit  = (b200_UART_reg & 0x2)/2
    dtrn_bit  = (b200_UART_reg & 0x4)/4
    dtrn_re_bit  = (b200_UART_reg & 0x8)/8
    dtrn_fe_bit  = (b200_UART_reg & 0x10)/16

    if debug:
        print("* B200_UART_reg  after uart_mode_init = 0x%x" % b200_UART_reg, "@ addr = 0x%x" %SPI_ADDR_UART)
        print("     * bit_4 = OSB_UART_DTR_N_FE  = %d" %dtrn_fe_bit)
        print("     * bit_3 = OSB_UART_DTR_N_RE  = %d" %dtrn_re_bit)
        print("     * bit_2 = OSB_UART_DTR_N     = %d" %dtrn_bit)
        print("     * bit_1 = OSB_UART_RTS_N     = %d" %rtsn_bit)
        print("     * bit_0 = OSB_UART_CTS_N_bit = %d\n" %ctsn_bit)

    # Read LCR register (0x100C) : verify LCR(7) = 0
    LCR_value = get_reg_value(glu_reg_base_addr + (UART_BASE_ADDR + UART_LCR))
    if debug:
        print("Verify LCR(7) = 0 before sending Tx value")
        print(" LCR_value Read = 0x%x" % LCR_value, "@ addr = 0x%x (LCR reg.)" %UART_LCR)

    Tx_value = 0x71
    reg_write(glu_reg_base_addr + (UART_BASE_ADDR + UART_RBR_DLL), Tx_value)
    if debug:
        print("****** Write = 0x%x" % Tx_value, "@ addr = 0x%x (RBR reg.)" %UART_RBR_DLL)

    b200_UART_reg = Utsspi.read_mod_register8(SPI_ADDR_UART)
    ctsn_bit  = b200_UART_reg & 0x1
    rtsn_bit  = (b200_UART_reg & 0x2)/2
    dtrn_bit  = (b200_UART_reg & 0x4)/4
    dtrn_re_bit  = (b200_UART_reg & 0x8)/8
    dtrn_fe_bit  = (b200_UART_reg & 0x10)/16

    if debug:
        print("* B200_UART_reg  after reset = 0x%x" % b200_UART_reg, "@ addr = 0x%x" %SPI_ADDR_UART)
        print("     * bit_4 = OSB_UART_DTR_N_FE  = %d" %dtrn_fe_bit)
        print("     * bit_3 = OSB_UART_DTR_N_RE  = %d" %dtrn_re_bit)
        print("     * bit_2 = OSB_UART_DTR_N     = %d" %dtrn_bit)
        print("     * bit_1 = OSB_UART_RTS_N     = %d" %rtsn_bit)
        print("     * bit_0 = OSB_UART_CTS_N_bit = %d\n" %ctsn_bit)

    # Read LCR register (0x100C) : verify LCR(7) = 0
    LCR_value = get_reg_value(glu_reg_base_addr + (UART_BASE_ADDR + UART_LCR))
    if debug:
        print("Read LCR_value = 0x%x" % LCR_value, "@ addr = 0x%x (LCR reg.)" %UART_LCR)

    # LCR(7) = 0 : read @ 0x01000 addr i.e RBR register (Receive Buffer Register)
    RBR_value = get_reg_value(glu_reg_base_addr + (UART_BASE_ADDR + UART_RBR_DLL))
    if debug:
        print("Read RBR_value = 0x%x" % RBR_value, "@ addr = 0x%x (RBR_DLL reg.)" %UART_RBR_DLL)

    # LCR(7) = 0 : read @0x01004 addr i.e IER register (Interrupt Enable register)

    IER_value = get_reg_value(glu_reg_base_addr + (UART_BASE_ADDR + UART_DLM))
    EDSSI_bit = (IER_value & 0x8)/8
    ELSI_bit  = (IER_value & 0x4)/4
    ETBEI_bit = (IER_value & 0x2)/2
    ERBFI_bit = IER_value & 0x1

    if debug:
        print("Read IER_value = 0x%x" % IER_value, "@ addr = 0x%x" %UART_DLM)
        print("     * bit_3 = EDSSI_bit = %d" %EDSSI_bit)
        print("     * bit_2 = ELSI_bit  = %d" %ELSI_bit)
        print("     * bit_1 = ETBEI     = %d" %ETBEI_bit)
        print("     * bit_0 = ERBFI_bit = %d\n" %ERBFI_bit)

    # LCR(7) = 0 : read @0x01008 addr i.e IIR register (Interrupt Identification Register)

    IIR_value  = get_reg_value(glu_reg_base_addr + (UART_BASE_ADDR + UART_FCR))
    INTPEND_bit    = IIR_value & 0x1
    INTID2_bit1to3 = (IIR_value & 0xe)/2
    FIFOEN_bit6to7 = (IIR_value & 0xc)/64

    if debug:
        print("Read IIR_value = 0x%x" % IIR_value, "@ addr = 0x%x" %UART_FCR)

    return True
#
#================================================================================
#
# OSB_DTSS_SYNC_641K        : DTSS_SYNC_MEASURE     : SYNCHRO_MEASURE1
# PSYNC_EXPCB_700KHZ_CLK    : EXPCB_SYNC_MEASURE    : SYNCHRO_MEASURE2
# P0_PCON_M1_PS_SYNC_CLK    : M1_SYNC_MEASURE       : SYNCHRO_MEASURE3
# P0_PCON_M2_PS_SYNC_CLK    : M2_SYNC_MEASURE       : SYNCHRO_MEASURE4
#
#================================================================================
#
#=========================================
@DIAG("B200 : freq_measurement Test")
def t_osb200_freq_meas_test(cmd):
#=========================================
#
    try:
        if ' ' not in cmd:
            verbose = False
        else:
            (command, verbose) = cmd.split()
            if verbose == "verbose":
                verbose = True
            else:
                print()
                print_error("*   Parameter error : arg must be : verbose")
                print()
                return False

    except:
        print_error("   Syntax error : Command must be : t_osb200_freq_meas_test <verbose_flag> ")
        print_error("                                                                           ")
        return False

    return_flag = True
    error_nb = 0

    glu_reg_base_addr = get_glu_base_addr()
    b200_module_type_set("DTSS", verbose)

    side = 0
    slice = B200_SLICE
    if (os.path.exists("/dev/uts_spi")):
        Utsspi = utsspi.SpiModule(side, slice, "/dev/uts_spi")
    else:
        print("Utsspi driver (/dev/uts_spi) not found")
        return False

    wr_data = 0x10
    Utsspi.write_mod_register8(SPI_ADDR_MISC, wr_data)

    if verbose:
        value = Utsspi.read_mod_register8(SPI_ADDR_MISC)
        print(" Read cAddress_Misc reg. value @ 0x%1x after launching measure: 0x%x" %(SPI_ADDR_MISC, value))

        show_z112_B200_misc_reg_contents()

    time.sleep(1)

    # OSB_DTSS_SYNC_641K measure : 641KHz
    #--------------------------------------
    
    sync1_lsb_value = Utsspi.read_mod_register8(SPI_ADDR_SYNC_MEAS1_LSB)
    sync1_msb_value = Utsspi.read_mod_register8(SPI_ADDR_SYNC_MEAS1_MSB)

    if verbose:
        print("sync1_msb_value = 0x%x ; sync1_lsb_value = 0x%x " %(sync1_msb_value, sync1_lsb_value))

    sync1_val = (float(sync1_msb_value) * 256) + float(sync1_lsb_value)
    sync1_period = (sync1_val * 30.3)/1000000000

    if sync1_period == 0.0:
        sync1_freq = 0.0
    else:
        sync1_freq = 1.0/sync1_period

    if sync1_freq > 630000.0 and sync1_freq < 650000.0:
        msg = "PASS"
        print(" - OSB_DTSS_SYNC_641K frequency = %5.3fHz : %s" %(sync1_freq, msg))
    else:
        msg = "FAIL"
        print_error(" - OSB_DTSS_SYNC_641K frequency = %5.3fHz : %s" %(sync1_freq, msg))
        error_nb += 1

    # PSYNC_EXPCB_700KHZ_CLK measure : 700KHz
    #-----------------------------------------
    
#   os_cmde = "echo 1 > /sys/class/i2c-dev/i2c-5/device/5-0021/gpiochip6/gpio/gpio481/value"
    os_cmde = "qdbus --system com.viavisolutions.platform.PowerBudget /com/viavisolutions/platform/PowerBudget com.viavisolutions.platform.PowerBudget.RequestSubmodulePowerOn 0 1 > /dev/null"
    (os.system(os_cmde))

    sync2_lsb_value = Utsspi.read_mod_register8(SPI_ADDR_SYNC_MEAS2_LSB)
    sync2_msb_value = Utsspi.read_mod_register8(SPI_ADDR_SYNC_MEAS2_MSB)

    if verbose:
        print("sync2_msb_value = 0x%x ; sync2_lsb_value = 0x%x " %(sync2_msb_value, sync2_lsb_value))

    sync2_val = (float(sync2_msb_value) * 256) + float(sync2_lsb_value)
    sync2_period = (sync2_val * 30.3)/1000000000

    if sync2_period == 0.0:
        sync2_freq = 0.0
    else:
        sync2_freq = 1.0/sync2_period

    if sync2_freq > 690000.0 and sync2_freq < 720000.0:
        msg = "PASS"
        print_ok(" - PSYNC_EXPCB_700KHZ_CLK frequency = %5.3fHz : %s" %(sync2_freq, msg))
    else:
        msg = "FAIL"
        print_error(" - PSYNC_EXPCB_700KHZ_CLK frequency = %5.3fHz : %s" %(sync2_freq, msg))
        error_nb += 1

    # P0_PCON_M1_PS_SYNC_CLK measure : 1.4MHz
    #-----------------------------------------

    sync3_lsb_value = Utsspi.read_mod_register8(SPI_ADDR_SYNC_MEAS3_LSB)
    sync3_msb_value = Utsspi.read_mod_register8(SPI_ADDR_SYNC_MEAS3_MSB)

    if verbose:
        print("sync3_msb_value = 0x%x ; sync3_lsb_value = 0x%x " %(sync3_msb_value, sync3_lsb_value))

    sync3_val = (float(sync3_msb_value) * 256) + float(sync3_lsb_value)
    sync3_period = (sync3_val * 30.3)/1000000000

    if sync3_period == 0.0:
        sync3_freq = 0.0
    else:
        sync3_freq = 1.0/sync3_period

    if sync3_freq > 1300000.0 and sync3_freq < 1500000.0:
        msg = "PASS"
        print(" - P0_PCON_M1_PS_SYNC_CLK frequency = %5.3fHz : %s" %(sync3_freq, msg))
    else:
        msg = "FAIL"
        print_error(" - P0_PCON_M1_PS_SYNC_CLK frequency = %5.3fHz : %s" %(sync3_freq, msg))
        error_nb += 1

    # P0_PCON_M2_PS_SYNC_CLK measure : 1.4MHz
    #-----------------------------------------

    sync4_lsb_value = Utsspi.read_mod_register8(SPI_ADDR_SYNC_MEAS4_LSB)
    sync4_msb_value = Utsspi.read_mod_register8(SPI_ADDR_SYNC_MEAS4_MSB)

    if verbose:
        print("sync4_msb_value = 0x%x ; sync4_lsb_value = 0x%x " %(sync4_msb_value, sync4_lsb_value))

    sync4_val = (float(sync4_msb_value) * 256) + float(sync4_lsb_value)
    sync4_period = (sync4_val * 30.3)/1000000000

    if sync4_period == 0.0:
        sync4_freq = 0.0
    else:
        sync4_freq = 1.0/sync4_period

    if sync4_freq > 1300000.0 and sync4_freq < 1500000.0:
        msg = "PASS"
        print(" - P0_PCON_M2_PS_SYNC_CLK frequency = %5.3fHz : %s" %(sync4_freq, msg))
    else:
        msg = "FAIL"
        print_error(" - P0_PCON_M2_PS_SYNC_CLK frequency = %5.3fHz : %s" %(sync4_freq, msg))
        error_nb += 1

    # SCD_EXPCB_PCIE_CLK measure :
    #------------------------------

    sync5_lsb_value = Utsspi.read_mod_register8(SPI_ADDR_SYNC_MEAS5_LSB)
    sync5_msb_value = Utsspi.read_mod_register8(SPI_ADDR_SYNC_MEAS5_MSB)

    if verbose:
        print("sync5_msb_value = 0x%x ; sync5_lsb_value = 0x%x " %(sync5_msb_value, sync5_lsb_value))

    sync5_val = (float(sync5_msb_value) * 256) + float(sync5_lsb_value)
    sync5_freq = (sync5_val) * 10000

    if sync5_freq > 99000000.0 and sync5_freq < 110000000.0:
        msg = "PASS"
        print(" - SCD_EXPCB_PCIE_CLK frequency = %5.3fHz : %s" %(sync5_freq, msg))
    else:
        msg = "FAIL"
        print_error(" - SCD_EXPCB_PCIE_CLK frequency = %5.3fHz : %s" %(sync5_freq, msg))
        error_nb += 1

    # SCD_M1_REF_CLK measure :
    #--------------------------

    sync6_lsb_value = Utsspi.read_mod_register8(SPI_ADDR_SYNC_MEAS6_LSB)
    sync6_msb_value = Utsspi.read_mod_register8(SPI_ADDR_SYNC_MEAS6_MSB)

    if verbose:
        print("sync6_msb_value = 0x%x ; sync6_lsb_value = 0x%x " %(sync6_msb_value, sync6_lsb_value))

    sync6_val = (float(sync6_msb_value) * 256) + float(sync6_lsb_value)
    sync6_freq = (sync6_val) * 10000

    if sync6_freq > 99000000.0 and sync6_freq < 110000000.0:
        msg = "PASS"
        print(" - SCD_M1_REF_CLK frequency = %5.3fHz : %s" %(sync6_freq, msg))
    else:
        msg = "FAIL"
        print_error(" - SCD_M1_REF_CLK frequency = %5.3fHz : %s" %(sync6_freq, msg))
        error_nb += 1

    # SCD_M2_REF_CLK measure :
    #--------------------------

    sync7_lsb_value = Utsspi.read_mod_register8(SPI_ADDR_SYNC_MEAS7_LSB)
    sync7_msb_value = Utsspi.read_mod_register8(SPI_ADDR_SYNC_MEAS7_MSB)

    if verbose:
        print("sync7_msb_value = 0x%x ; sync7_lsb_value = 0x%x " %(sync7_msb_value, sync7_lsb_value))

    sync7_val = (float(sync7_msb_value) * 256) + float(sync7_lsb_value)
    sync7_freq = (sync7_val) * 10000

    if sync7_freq > 99000000.0 and sync7_freq < 110000000.0:
        msg = "PASS"
        print(" - SCD_M2_REF_CLK frequency = %5.3fHz : %s" %(sync7_freq, msg))
    else:
        msg = "FAIL"
        print_error(" - SCD_M2_REF_CLK frequency = %5.3fHz : %s" %(sync7_freq, msg))
        error_nb += 1

    # LVDS_CCAN_CLK measure :
    #--------------------------

    sync8_lsb_value = Utsspi.read_mod_register8(SPI_ADDR_SYNC_MEAS8_LSB)
    sync8_msb_value = Utsspi.read_mod_register8(SPI_ADDR_SYNC_MEAS8_MSB)

    if verbose:
        print("sync8_msb_value = 0x%x ; sync8_lsb_value = 0x%x " %(sync8_msb_value, sync8_lsb_value))

    sync8_val = (float(sync8_msb_value) * 256) + float(sync8_lsb_value)
    sync8_freq = (sync8_val) * 10000

    if sync8_freq > 39000000.0 and sync8_freq < 41000000.0:
        msg = "PASS"
        print(" - LVDS_CCAN_CLK frequency = %5.3fHz : %s" %(sync8_freq, msg))
    else:
        msg = "FAIL"
        print_error(" - LVDS_CCAN_CLK frequency = %5.3fHz : %s" %(sync8_freq, msg))
        error_nb += 1

#   print(" error_nb = %d" %error_nb)

    if error_nb > 0:
        return_flag = False

    return return_flag
#
#================================================================================
#
# MSEL_NB_NOR_CS <= slv_reg15(4 downto 0);
# MSEL_START     <= slv_reg15(5);
# MSEL_CS_RESET  <= slv_reg15(7);
#
# reg_data_out <= slv_reg15(31 downto 10) & MOD_OUT_LOC & MSEL_STATUS & slv_reg15(7 downto 0);
#
#================================================================================
#
#=============================================================================================
@DIAG("B200 : module selection (MSEL) Test")
def t_osb200_msel_test(cmd):
#=============================================================================================
#
    try:
        (command, module_to_select) = cmd.split()
    except:
        print_error("# Command must be : t_osb200_msel_test <module_to_select>")
        print_error("#            with : module_to_select = SWITCH or DTSS")
        return False

    if module_to_select == "DTSS" or module_to_select == "SWITCH":
        error_flag = False
    else:
        print_error("Error : module_to_select MUST be : DTSS or SWITCH")
        return False

    verbose = False

    return_flag = True
    error_nb = 0

    glu_reg_base_addr = get_glu_base_addr()

    # pwrside S3

    side = 0
    slice = B200_SLICE
    if (os.path.exists("/dev/uts_spi")):
        Utsspi = utsspi.SpiModule(side, slice, "/dev/uts_spi")
    else:
        print("Utsspi driver (/dev/uts_spi) not found")
        return False

    b200_module_type_set(module_to_select, verbose)

    periph_reset_gen("release", verbose)

    if module_to_select == "DTSS":
        msel_nb_nor_cs = 0x5
    else:
        msel_nb_nor_cs = 0x15

    msel_start     = 0x0
    msel_cs_reset  = 0x0

    msel_reg_value = (msel_cs_reset * 0x80) | (msel_start * 0x20) | msel_nb_nor_cs
    reg_write(glu_reg_base_addr + REG_MSEL, msel_reg_value)

    msel_value = get_reg_value(glu_reg_base_addr + REG_MSEL)
#   print("msel_value = 0x%x" % msel_value)

    msel_cnter_value = Utsspi.read_mod_register8(SPI_ADDR_MSEL_REG)

    if msel_cnter_value == 0x0:
        pass
    else:
        error_nb += 1

    periph_reset_gen("release", verbose)

    msel_start = 0x1

    msel_reg_value = (msel_cs_reset * 0x80) | (msel_start * 0x20) | msel_nb_nor_cs
    reg_write(glu_reg_base_addr + REG_MSEL, msel_reg_value)

    msel_start = 0x0

    msel_reg_value = (msel_cs_reset * 0x80) | (msel_start * 0x20) | msel_nb_nor_cs
    reg_write(glu_reg_base_addr + REG_MSEL, msel_reg_value)

    msel_cnter_value = Utsspi.read_mod_register8(SPI_ADDR_MSEL_REG)

    exp_value = msel_nb_nor_cs

    if msel_cnter_value == exp_value:
        msg = "PASS"
    else:
        msg = "FAIL"
        error_nb += 1

    print("msel_value = 0x%x (expected 0x%x) : %s" %(msel_cnter_value, exp_value, msg))

    if error_nb > 0:
        return_flag = False

    return return_flag
#
#============================================================================================
@DIAG("B200 : IRQs Test")
def t_osb200_irq_test(cmd):
#=============================================================================================    
#
#---------------------------------------------------------------------------------------------
# B200 board : IRQs are outputs generated from b200_misc reg.
#
#       B200 reg_misc(0) = enable_loop_uart_bit0
#       B200 reg_misc(1) = select_2V5_VIN_bit1
#       B200 reg_misc(2) = nIRQ_SX_bit2 
#       B200 reg_misc(3) = nIRQ_Sn_bit3
#
#       Note : nIRQ_SX <= '0' when reg_misc(2) = '1' else 'Z'
#
# OSB board : has :
#       * 2 IRQs inputs (i_SWITCH_IRQn and i_DTSS_IRQn), readback by REG_DBG_CTRL reg.
#                        (slv_reg14)                             
#               slv_reg14(31) <= dbg_gpio_i(0);     -- ADP
#               slv_reg14(30) <= dbg_gpio_i(1);     -- SWITCH_IRQn
#               slv_reg14(29) <= dbg_gpio_i(2);     -- DTSS_IRQ
#               slv_reg14(28) <= PUSHB;
#
#         Note : i_SWITCH_IRQn has a 10k pullup on OSB board and has an internal pullup 
#                into FPGA
#                Then when B200 is not connected, slv_reg14(30) = SWITCH_IRQn <= '1' (pullup)
#                 
#                i_DTSSS_IRQn has a 10k pullup on OSB board, has an internal pulldown
#                and is inverted into the fpga
#                Then, when B200 is not connected, slv_reg14(29) <= '0' (pullup inverted)
#
#       * 1 IRQ output (o_OSB_IRQn)
#---------------------------------------------------------------------------------------------
#
    try:
        if len(cmd.split()) == 3:
            cmd_lgth = 3
            (command, module_to_select, verbose_flag) = cmd.split()
            if verbose_flag == "verbose":
                verbose_flag = True
                pass
            else :
                print()
                print_info("     * Error : 2nd arg <%s> is not a correct arg : must be : \
                                   verbose" %verbose_flag)
                return False
        else:
            verbose_flag = False
            (command, module_to_select) = cmd.split()

    except:
        print()
        print_error("# Command must be : t_osb200_irq_test <module_to_select> <verbose_flag> ")
        print_error("#            with : <module_to_select> = SWITCH or DTSS                 ")
        print_error("                                                                        ")
        print_error("                    <verbose_flag>     = MUST be verbose ONLY           ")
        print_error("                        Note : <verbose_flag> is optional               ")
        return False

    if module_to_select == "DTSS" or module_to_select == "SWITCH":
        error_flag = False
    else:
        print()
        print_info("* Error : module_to_select MUST be : DTSS or SWITCH")
        print()
        return False

    error_nb = 0

    # pwrside

    side = 0
    slice = B200_SLICE
    if (os.path.exists("/dev/uts_spi")):
        Utsspi = utsspi.SpiModule(side, slice, "/dev/uts_spi")
    else:
        print("Utsspi driver (/dev/uts_spi) not found")
        return False

    b200_module_type_set(module_to_select, verbose_flag)

    glu_reg_base_addr = get_glu_base_addr()
    
    periph_reset_gen("release", verbose_flag)

    if verbose_flag:
        print("\n* B200 : SPI_ADDR_MISC reg. readback value after reset")
        show_z112_B200_misc_reg_contents()

        print("\n* OSB : REG_DBG_CTRL reg. readback value after reset")
        show_irq_dbg_ctrl_contents()
    else:
        print("* B200 : generate 'Z' on Sx_IRQn CPLD pin by seting ADDR_MISC(2) = 0")

    dbg_reg_value = get_reg_value(glu_reg_base_addr + REG_DBG_CTRL)
    osb_dtss_IRQ_bit29 = (dbg_reg_value & 0x20000000) >> 29
    osb_switch_IRQ_bit30 = (dbg_reg_value & 0x40000000) >> 30
    
    if module_to_select == "DTSS":
        IRQ_bit = osb_dtss_IRQ_bit29
        irq_exp_value = 0
    else:
        IRQ_bit = osb_switch_IRQ_bit30
        irq_exp_value = 1
        
    if IRQ_bit == irq_exp_value:
        print_ok("IRQ generation disable : IRQ_bit = %d : PASS" %IRQ_bit)
    else:
        print_info("IRQ generation disable : IRQ_bit = %d : FAIL" %IRQ_bit)
        error_nb =+ 1

    # Validate IRQn :
    #==================
    
    wr_data = 0x4
    
    if verbose_flag:
        print("\n* B200 : Write 0x%x value into SPI_ADDR_MISC reg. (@ addr = 0x%1x) to set nIRQ_SX = 0" \
               %(wr_data, SPI_ADDR_MISC))
        print("* B200 : this generates '0' on nIRQ_SX CPLD pin by seting ADDR_MISC(2) = 0")
    else:
        print("\n* B200 : generate '0' on Sx_IRQn CPLD pin by seting ADDR_MISC(2) = 1")
        
    Utsspi.write_mod_register8(SPI_ADDR_MISC, wr_data)

    if verbose_flag:
        show_z112_B200_misc_reg_contents()

    dbg_reg_value = get_reg_value(glu_reg_base_addr + REG_DBG_CTRL)
    osb_dtss_IRQ_bit29 = (dbg_reg_value & 0x20000000) >> 29
    osb_switch_IRQ_bit30 = (dbg_reg_value & 0x40000000) >> 30

    if verbose_flag:
        show_irq_dbg_ctrl_contents()

    if module_to_select == "DTSS":
        IRQ_bit = osb_dtss_IRQ_bit29
        irq_exp_value = 1 # for DTSS, IRQn input is inverted
    else:
        IRQ_bit = osb_switch_IRQ_bit30
        irq_exp_value = 0 # for SWITCH, IRQn input is not inverted

    if IRQ_bit == irq_exp_value:
        print_ok("IRQ generation enable : IRQ_bit = %d : PASS" %IRQ_bit)
    else:
        print_info("IRQ generation enable : IRQ_bit = %d : FAIL" %IRQ_bit)
        error_nb =+ 1

    # Devalidate IRQn :
    #===================
    
    if 0 == 1:
        wr_data = 0x0

        if verbose_flag:
            print("\n* B200 : Write 0x%x value into SPI_ADDR_MISC reg. (@ addr = 0x%1x) to set nIRQ_SX = 'Z'"\
                %(wr_data, SPI_ADDR_MISC))
            print("* B200 : generate 'Z' on Sx_IRQn CPLD pin by seting ADDR_MISC(2) = 0")
        else:
            print("\n* B200 : generate 'Z' on Sx_IRQn CPLD pin by seting ADDR_MISC(2) = 0")
        Utsspi.write_mod_register8(SPI_ADDR_MISC, wr_data)
    else:
        periph_reset_gen("release", verbose_flag)
        print("\n* B200 : generate 'Z' on Sx_IRQn CPLD pin by seting ADDR_MISC(2) = 0")

    if verbose_flag:
        show_z112_B200_misc_reg_contents()

    dbg_reg_value = get_reg_value(glu_reg_base_addr + REG_DBG_CTRL)

    if verbose_flag:
        show_irq_dbg_ctrl_contents()

    osb_dtss_IRQ_bit29 = (dbg_reg_value & 0x20000000) >> 29
    osb_switch_IRQ_bit30 = (dbg_reg_value & 0x40000000) >> 30

    if module_to_select == "DTSS":
        IRQ_bit = osb_dtss_IRQ_bit29
        irq_exp_value = 0
    else:
        IRQ_bit = osb_switch_IRQ_bit30
        irq_exp_value = 1
        
    if IRQ_bit == irq_exp_value:
        print_ok("IRQ generation disable : IRQ_bit = %d : PASS" %IRQ_bit)
    else:
        print_info("IRQ generation disable : IRQ_bit = %d : FAIL" %IRQ_bit)
        error_nb =+ 1

    if error_nb > 0:
        return False
    else:
        return True
#
#=============================================================================================
@DIAG("B200 : Verify JTAG ID")
def t_osb200_jtag_test(cmd):
#=============================================================================================
#
    verbose = False

    try:
        (command, module_to_select) = cmd.split()
    except:
        print()
        print_error("# Command must be : t_osb200_jtag_test <module_to_select> ")
        print_error("#            with : <module_to_select> = SWITCH or DTSS   ")
        return False

    if module_to_select == "DTSS" or module_to_select == "SWITCH":
        error_flag = False
    else:
        print_error("Error : module_to_select MUST be : DTSS or SWITCH")
        return False

    side = 0
    slice = B200_SLICE
    if (os.path.exists("/dev/uts_spi")):
        Utsspi = utsspi.SpiModule(side, slice, "/dev/uts_spi")
    else:
        print("Utsspi driver (/dev/uts_spi) not found")
        return False

    b200_module_type_set(module_to_select, verbose)

    res = 0

    FileName = "/usr/share/pydiag/oth/"+module_to_select+"_jtag.txt"

    f = open(FileName, "w")
    f.write('cable osb\n')
    f.write('detect\n')
    f.close()
    cmde = "jtag "+FileName

    p = subprocess.Popen(cmde, shell=True, stdin=subprocess.PIPE, stdout=subprocess.PIPE,
                         stderr=subprocess.STDOUT, close_fds=True)
    p.wait()
    err = p.returncode
    lines = p.stdout.readlines()
    for l in lines:
        l = l.decode("utf-8").strip()
        if l:
            print_info("# %s" % (l))
            columns = [item.strip() for item in l.split(':')]
            # print_info("col %s" % columns[0])
            if module_to_select == "DTSS":
                if ((columns[0] == "Part(0)") and (columns[1] == "10M04SCU169 (0x318A)")):
                    res = 1
            else:
                if ((columns[0] == "Device Id") and (columns[1] == "00010100100101010001000111000011 (0x149511C3)")):
                    print("columns[1] is" , columns[1])
                    res = 1

    os_cmde = "rm -f "+FileName
    (os.system(os_cmde))

    return res == 1
#
#=============================================================================================
@DIAG("B200 : Load CPLD")
def t_osb200_load_cpld(cmd):
#=============================================================================================
#
    try:
        if ' ' not in cmd:
            verbose = False
        else:
            (command, verbose) = cmd.split()
            if verbose == "verbose":
                verbose = True
            else:
                print()
                print_error("*   Parameter error : arg must be : verbose")
                print()
                return False
    except:
        print_error("   Syntax error : Command must be : t_osb200_load_cpld <verbose_flag> ")
        print_error("                                                                      ")
        return False

    print()

    svf_file = "/usr/share/pydiag/oth/oth_b200.svf"
    
    if (os.path.exists(svf_file)):
        pass
    else:
        print_error("svf_file not found : abort")
        return False

    # pwrside
    side = 0
    slice = B200_SLICE
    if (os.path.exists("/dev/uts_spi")):
        Utsspi = utsspi.SpiModule(side, slice, "/dev/uts_spi")
    else:
        print_error("Utsspi driver (/dev/uts_spi) not found : abort")
        return False

    #b200_module_type_set("DTSS", verbose)
    #(board_id, toggle_bit, dtss_pres_b_bit, switch_pres_b_bit) = B200_info(verbose)

    FileName = "/usr/share/pydiag/oth/cpld_load.txt"

    f = open(FileName, "w")
    f.write('cable osb\n')
    f.write('detect\n')
    f.close()

    cmde = "jtag "+FileName

    res = False
    
    p = subprocess.Popen(cmde, shell=True, stdin=subprocess.PIPE, stdout=subprocess.PIPE,
                         stderr=subprocess.STDOUT, close_fds=True)
    p.wait()
    err = p.returncode
    lines = p.stdout.readlines()
    for l in lines:
        l = l.decode("utf-8").strip()
        if l:
            print_info("# %s" % (l))
            columns = [item.strip() for item in l.split(':')]
            # print_info("col %s" % columns[0])
            if ((columns[0] == "Part(0)") and (columns[1] == "10M04SCU169 (0x318A)")):
                res = True

    if  res:
        print("\n=> CPLD Detect : PASS\n")
    else:
        print("\n=> CPLD Detect : FAIL")
        print("   CPLD not programmed\n")
        return False

    # CPLD Detected : then program it

    f = open(FileName, "w") 
    f.write('cable osb\n')
    f.write('detect\n')
    f.write('svf %s progress\n' %svf_file)
    f.close()

    cmde = "jtag "+FileName

    res = 0

    p = subprocess.Popen(cmde, shell=True, stdin=subprocess.PIPE, stdout=subprocess.PIPE,
                         stderr=subprocess.STDOUT, close_fds=True)
    p.wait()
    err = p.returncode
    lines = p.stdout.readlines()
    for l in lines:
        l = l.decode("utf-8").strip()
        if l:
            print_info("# %s" % (l))
            columns = [item.strip() for item in l.split(':')]
            # print_info("col %s" % columns[0])
            if ((columns[0] == "Part(0)") and (columns[1] == "10M04SCU169 (0x318A)")):
                ver = Utsspi.read_mod_register8(0x00)
                res += 1

            if ((columns[0] == "detail") and (columns[1] == "Scanned device output matched expected TDO values.")):
                res += 1

    os_cmde = "rm -f "+FileName
    (os.system(os_cmde))

    if res == 2:
        print("\n=> CPLD programation (cpld_version = %2x) : PASS\n" % ver)
        return True
    else:
        print("\n=> CPLD programation : FAIL\n")
        return False
#
#================================================================================
@DIAG("B200 : EXPCB_PWR_EN Test")
def t_osb200_expb_pwr_en_test(cmd):
#================================================================================
#
# To test EXPB_PWR_EN signal coming from CPB board
#
    try:
        if ' ' not in cmd:
            verbose = False
        else:
            (command, consigne) = cmd.split()
            if consigne == "verbose":
                verbose = True
            else:
                print()
                print_error("*   Parameter error : arg must be : verbose")
                print()
                return False

    except:
        print_error("   Syntax error : Command must be : t_osb200_expb_pwr_en_test <verbose_flag> ")
        print_error("                                                                             ")
        print_error("                  <verbose_flag> = MUST be verbose ONLY                      ")
        print_error("                        Note : <verbose_flag> is optional                    ")
        print_error("                                                                             ")
        return False

    print()

    side = 0
    slice = B200_SLICE
    if (os.path.exists("/dev/uts_spi")):
        Utsspi = utsspi.SpiModule(side, slice, "/dev/uts_spi")
    else:
        print("Utsspi driver (/dev/uts_spi) not found")
        return False

    # Allumage :
    #------------

    msg = "# Enable expb_pwr_en using <qdbus> cmd :"
    if verbose:
        print(msg)

    os_cmde = "qdbus --system com.viavisolutions.platform.PowerBudget /com/viavisolutions/platform/PowerBudget com.viavisolutions.platform.PowerBudget.RequestSubmodulePowerOn 0 1 > /dev/null"
    (os.system(os_cmde))

    error_nb = 0

    expb_pwr_en_value = Utsspi.read_mod_register8(SPI_ADDR_EXPCB)

    exp_value = 0x1
    if expb_pwr_en_value == exp_value:
        flag_msg = "PASS"
        print_ok("* SPI_ADDR_EXPCB register read (@ addr 0x%1x) = 0x%x : %s" \
                  %(SPI_ADDR_EXPCB, expb_pwr_en_value, flag_msg))
    else:    
        flag_msg = "FAIL"
        error_nb += 1
        print_info("* SPI_ADDR_EXPCB register read (@ addr 0x%1x) = 0x%x (exp_value = %x): %s" \
                      %(SPI_ADDR_EXPCB, expb_pwr_en_value, exp_value, flag_msg))

    # Extinction :
    #--------------

    msg = "\n# Disable expb_pwr_en using <qdbus> cmd :"
    if verbose:
        print(msg)

    os_cmde = "qdbus --system com.viavisolutions.platform.PowerBudget /com/viavisolutions/platform/PowerBudget com.viavisolutions.platform.PowerBudget.SubmodulePowerOff 0 1 > /dev/null"
    (os.system(os_cmde))

    expb_pwr_en_value = Utsspi.read_mod_register8(SPI_ADDR_EXPCB)

    exp_value = 0x0
    if expb_pwr_en_value == exp_value:
        flag_msg = "PASS"
        print_ok("* SPI_ADDR_EXPCB register read (@ addr 0x%1x) = 0x%x : %s" \
                  %(SPI_ADDR_EXPCB, expb_pwr_en_value, flag_msg))
    else:    
        flag_msg = "FAIL"
        error_nb += 1
        print_info("* SPI_ADDR_EXPCB register read (@ addr 0x%1x) = 0x%x (exp_value = %x): %s" \
                      %(SPI_ADDR_EXPCB, expb_pwr_en_value, exp_value, flag_msg))

    if error_nb > 0:
        return False
    else:
        return True
#
#================================================================================
@DIAG("B200 : EXPCB_PWR_EN check")
def t_osb200_expb_pwr_en_check(cmd):
#================================================================================
#
    # Query :

    os_cmde = "qdbus --system com.viavisolutions.platform.PowerBudget /com/viavisolutions/platform/PowerBudget com.viavisolutions.platform.PowerBudget.IsSubmodulePoweredOn 0 1"
    (os.system(os_cmde))

    return None
#
#================================================================================
@DIAG("B200 : CPLD CLOCK 33MHz presence test")
def t_osb200_cpld_33M_test(cmd):
#================================================================================
#
    try:
        if ' ' not in cmd:
            verbose = False
            pass
        else:
            (command, verbose) = cmd.split()
            if verbose == "verbose":
                verbose = True
            else:
                print()
                print_error("*   Parameter error : arg must be : verbose")
                print()
                return False
    except:
        print_error("   Syntax error : Command must be : t_osb200_cpld_33M_test <verbose_flag> ")
        print_error("                                                                          ")
        return False

    print()

    side = 0
    slice = B200_SLICE
    if (os.path.exists("/dev/uts_spi")):
        Utsspi = utsspi.SpiModule(side, slice, "/dev/uts_spi")
    else:
        print("Utsspi driver (/dev/uts_spi) not found")
        return False

    res = 0
    
    periph_reset_gen("release", verbose)

    exp_value = 0xf
    cpld33M_cnter_value = Utsspi.read_mod_register8(SPI_ADDR_CPLD33_REG)

    if cpld33M_cnter_value == exp_value:
        print_ok("* SPI_ADDR_CPLD33 register read (@ addr 0x%1x) = 0x%x : PASS" %(SPI_ADDR_CPLD33_REG, cpld33M_cnter_value))
    else:
        print_info("* SPI_ADDR_CPLD33 register read (@ addr 0x%1x) = 0x%x (expected = 0x%x) : FAIL" \
                     %(SPI_ADDR_CPLD33_REG, cpld33M_cnter_value, exp_value))
        res = res + 1

    wr_data = 0x1
    ver = Utsspi.write_mod_register8(SPI_ADDR_CPLD33_REG, wr_data)

    time.sleep(0.1)

    exp_value = 0xf7
    cpld33M_cnter_value = Utsspi.read_mod_register8(SPI_ADDR_CPLD33_REG)

    if cpld33M_cnter_value == exp_value:
        print_ok("* SPI_ADDR_CPLD33 register read (@ addr 0x%1x) = 0x%x : PASS" %(SPI_ADDR_CPLD33_REG, cpld33M_cnter_value))
    else:
        print_info("* SPI_ADDR_CPLD33 register read (@ addr 0x%1x) = 0x%x (expected = 0x%x) : FAIL" \
                     %(SPI_ADDR_CPLD33_REG, cpld33M_cnter_value, exp_value))
        res = res + 1

    periph_reset_gen("release", verbose)

    exp_value = 0xf
    cpld33M_cnter_value = Utsspi.read_mod_register8(SPI_ADDR_CPLD33_REG)

    if cpld33M_cnter_value == exp_value:
        print_ok("* SPI_ADDR_CPLD33 register read (@ addr 0x%1x) = 0x%x : PASS" %(SPI_ADDR_CPLD33_REG, cpld33M_cnter_value))
    else:
        print_info("* SPI_ADDR_CPLD33 register read (@ addr 0x%1x) = 0x%x (expected = 0x%x) : FAIL" \
                     %(SPI_ADDR_CPLD33_REG, cpld33M_cnter_value, exp_value))
        res = res + 1

    if res == 0:
        return True
    else:
        return False
#
#=============================================================================================
@DIAG("B200 : OSB LVDS TEST")
def t_osb200_lvds_test(cmd):
#=============================================================================================
#
# Note : for OSB board, LVDS_PLAS and LVDS_CCAN are outputs :
#           * LVDS_PLAS is generated from a register i.e REG_BDT_SEQ_PLAS_DIAG
#           * LVDS_CCAN is generated from a MMCM clock.
#        Then, for a B200 board, LVDS_PLAS and LVDS_CCAN
#        are inputs.
#
    try:
        if ' ' not in cmd:
            verbose = False
        else:
            (command, consigne) = cmd.split()
            if consigne == "verbose":
                verbose = True
            else:
                print()
                print_error("*   Parameter error : arg must be : verbose")
                return False

    except:
        print()
        print_error("   Syntax error : Command must be : t_osb200_lvds_test <verbose_flag>    ")
        print_error("                                                                         ")
        print_error("         <verbose_flag> is : MUST be verbose ONLY                        ")
        print_error("                             Note : <verbose_flag> parameter is optional ")
        return False

    print()

    side = 0
    slice = B200_SLICE
    if (os.path.exists("/dev/uts_spi")):
        Utsspi = utsspi.SpiModule(side, slice, "/dev/uts_spi")
    else:
        print("Utsspi driver (/dev/uts_spi) not found")
        return False

    if verbose:
        # Read B200 CPLD VERSION reg
        version = Utsspi.read_mod_register8(SPI_ADDR_VERSION)
        print("\n* B200 CPLD Version = 0x%2x\n" %version)

    bdt_reg_base_addr = get_pci_bdt_base_addr()
    
    (board_id, toggle_bit, dtss_pres_b_bit, switch_pres_b_bit) = B200_info(verbose)
        
    if board_id == B200_DTSS_MOD:
        print ("* B200_module_detected : DTSS")
    elif board_id == B200_SWITCH_MOD:
        print ("* B200 module detected : SWITCH")
        print ("  => select DTSS module")
        b200_module_type_set("DTSS", verbose)
    else:
        print_info ("* B200 : no module detected : abort")
        return False
    
    error_nb = 0

    # Measure frequency of OSB FPGA LVDS_CLK input :
    #================================================
    
    lvds_clk_reg_value = get_reg_value(bdt_reg_base_addr + REG_BDT_SEQ_LVDS_FREQ)

    if verbose:
        print("lvds_clk_reg_value = 0x%x = %d" %(lvds_clk_reg_value, lvds_clk_reg_value))

    lvds_clk_val = float(lvds_clk_reg_value)
    lvds_clk_freq = lvds_clk_val * 1000

    expected_value = 40000000.0

    if lvds_clk_freq > 38000000.0 and lvds_clk_freq < 42000000.0:
        msg = "PASS"
    else:
        msg = "FAIL"
        error_nb += 1

    if msg == "PASS":
        print_ok("OSB FPGA LVDS_CLK input frequency : %5.3fHz  : %s" %(lvds_clk_freq, msg))
    else:
        print_error("OSB FPGA LVDS_CLK input frequency : %5.3fHz : expected_value = %5.3fHz : %s" %(lvds_clk_freq, expected_value, msg))

    # TEST of LVDS_PLAS register :
    #==============================

    j = 0
    lvds_plas_bit = 0x1
    plas_diag_en = 1   # plas_diag_en MUST be '1'
    
    wr_data = (plas_diag_en << 31) | (lvds_plas_bit << 1)

    while j < 2:

        # OSB board :
        reg_write(bdt_reg_base_addr + REG_BDT_SEQ_PLAS_DIAG, wr_data)
        rd_data = get_reg_value(bdt_reg_base_addr + REG_BDT_SEQ_PLAS_DIAG)

        if rd_data == wr_data:
            msg = "PASS"
        else:
            msg = "FAIL"
            error_nb += 1

        # B200 board :
        read_data = Utsspi.read_mod_register8(SPI_ADDR_CCAN_PLAS)

        if verbose:
            plas_bit = (read_data & 0x2)/2

            print("lvds_plas reg. readback value = 0x%x" % read_data)
            print("     * plas_bit = %d" %plas_bit)

        exp_data = wr_data & 0xf
        if read_data == exp_data:
            msg = "PASS"
        else:
            msg = "FAIL"
            error_nb += 1

        if msg == "PASS":
            print_ok("LVDS_PLAS reg. : read_data = 0x%x : %s" %(read_data, msg))
        else:
            print_error("LVDS_PLAS reg. : read_data = 0x%x : expected_data = 0x%x : %s" %(read_data, exp_data, msg))

        lvds_plas_bit = 0x0
        wr_data = plas_diag_en << 31

        j += 1

    # measure the CCAN frequency : read its value from B200 CPLD SPI_ADDR_SYNC_MEAS8_LSB reg.
    # B200 CPLD register

    if error_nb == 0:
        return True
    else:
        return False







