from viavi.evm import *
from viavi.diag import *
import viavi.mts.uts_spi as utsspi
import viavi.mts.uts_bdt as usbdt  # /usr/lib/python3.8/site-packages/viavi/mts/uts_bdt.py
import time, os
import smbus
import serial

import subprocess
from datetime import datetime

from viavi.mts.fth_reg_def import *

# Function to open the relay chosen by rel_id were rel_id is an integer between 1 and 5
def open_relay(rel_id):
    relay_file_path = "/sys/option_board_relay/cmd_rel_" + str(rel_id) + "/value"
    with open(relay_file_path,'w') as relay_value:
        relay_value.write('1')
    relay_value.close()

# Function to close the relay chosen by rel_id were rel_id is an integer between 1 and 5
def close_relay(rel_id):
    relay_file_path = "/sys/option_board_relay/cmd_rel_" + str(rel_id) + "/value"
    with open(relay_file_path,'w') as relay_value:
        relay_value.write('0')
    relay_value.close()    

# Function to read the state of the relay chosen by rel_id were rel_id is an integer between 1 and 5
def read_relay(rel_id):
    relay_file_path = "/sys/option_board_relay/cmd_rel_" + str(rel_id) + "/value"
    with open(relay_file_path,'r') as relay_value:
        return int(relay_value.read())
    
def get_oob_bus():
    sys_cmd ="i2cdetect -l"
    p = subprocess.Popen(sys_cmd, shell=True, stdin=subprocess.PIPE, stdout=subprocess.PIPE)
    p.wait()

    lines = p.stdout.readlines()
    tab_i2c = []
    for line in lines :
        line = line.decode("utf-8")
        splitted_line = line.split()
        if (splitted_line[3] != "I2C") :
            tab_i2c.append([splitted_line[0],splitted_line[4]]) # We keep only the number of the bus ['i2c_XX'] and the number of the channel ['X)']

    channel_found = False
    index = 0
    oob_i2c_bus = -1
    # We know from schematic that the i2c channel for option board is channel 6
    while(not(channel_found) and (index < len(tab_i2c))) :
        if (tab_i2c[index][1] == '6)') :
            channel_found = True
            oob_i2c_bus = tab_i2c[index][0][4:] #The format of the element is i2c_XX where XX is the number of the bus
        else :
            index += 1
    
    return int(oob_i2c_bus)

# Pydiag command to open the relays : the command can take up to 5 arguments which can be integer between 1 and 5 (Ex : "t_oob_open_relays 1 4" opens relays 1 and 4)
@DIAG("Open relays")
def t_oob_open_relays(cmd):
    # Validity of the arguments 
    params = cmd.split()[1:]
    param_number = len(params) 
    if param_number > 0 and param_number <= 5:

        relays_to_open = []
        try :
            for i in range(0,param_number):
            
                if (float(params[i])%1 == 0) : #Generate an error if the argument is not a number -> goes to 'except'
                    relays_to_open.append(params[i])
                else :
                    print_error("#WARNING: Argument n°",i+1, "is not valid. Arguments must be integer between 1 and 5")
        except:
            print_error("#ERROR : Unvalid arguments. Arguments must be integer between 1 and 5")
            return False
    else : 
        if param_number == 0 :
            print_error("#ERROR : No arguments specified")
        else :
            print_error("#ERROR : The command can take a maximum of 8 arguments")     
        print_error("#Command must be 't_oob_option_board <relay_id> <relay_id>'   (1 < relay_id < 5)")
        print_error("#Example : To open relays 1,4 and 5 type 't_oob_open_relays 1 4 5") 
        return False
    
    #Opening the chosen relays and checking if they were opened
    for rel_id in relays_to_open :
        open_relay(rel_id)
        if (read_relay(rel_id) == 1) :
            print("OK : Relay",rel_id,"is OPENED")
        elif(read_relay(rel_id) == 0) :
            print_error("ERROR : Relay",rel_id,"is still closed")
        else :
            print_error("ERROR : Unknown value found in /sys/option_board_relay/cmd_rel_" + str(rel_id) + "/value")
    

# Pydiag command to close the relays : the command can take up to 5 arguments which can be integer between 1 and 5 (Ex : "t_oob_close_relays 1 4" closes relays 1 and 4)
@DIAG("Close relays")
def t_oob_close_relays(cmd):
    # Validity of the arguments 
    params = cmd.split()[1:]
    param_number = len(params) 
    if param_number > 0 and param_number <= 5:

        relays_to_open = []
        try :
            for i in range(0,param_number):
            
                if (float(params[i])%1 == 0) : #Generate an error if the argument is not a number -> goes to 'except'
                    relays_to_open.append(params[i])
                else :
                    print_error("#WARNING: Argument n°",i+1, "is not valid. Arguments must be integer between 1 and 5")
        except:
            print_error("#ERROR : Unvalid arguments. Arguments must be integer between 1 and 5")
            return False
    else : 
        if param_number == 0 :
            print_error("#ERROR : No arguments specified")
        else :
            print_error("#ERROR : The command can take a maximum of 8 arguments")
        print_error("#Command must be 't_oob_option_board <relay_id> <relay_id>'   (1 < relay_id < 5)")
        print_error("#Example : To open relays 1,4 and 5 type 't_oob_open_relays 1 4 5") 
        return False
    
    #Closing the chosen relays and checking if they were closed
    for rel_id in relays_to_open :
        close_relay(rel_id)
        if (read_relay(rel_id) == 0) :
            print("OK : Relay",rel_id,"is CLOSED")
        elif(read_relay(rel_id) == 1) :
            print_error("ERROR : Relay",rel_id,"is still open")
        else :
            print_error("ERROR : Unknown value found in /sys/option_board_relay/cmd_rel_" + str(rel_id) + "/value")
    
# Pydiag command to read the states of the 5 relays
@DIAG("Read the states of the 5 relays")
def t_oob_read_relays_state(cmd):
    try:
        (command) = cmd.split()
    except:
        print_error("# Command must be: t_oob_read_relays_state")
    for rel_id in range(1,6) :
        if (read_relay(rel_id) == 0) :
            print("Relay",rel_id,": CLOSED")
        else :
            print("Relay",rel_id,": OPENED")



# Check if the EEPROM is detected
@DIAG("Check Option board EEPROM")
def t_oob_check_eeprom(cmd):
    try:
        (command) = cmd.split()
    except:
        print_error("# Command must be: t_oob_check_eeprom")
    oob_i2c_bus = get_oob_bus()
    eeprom = smbus.SMBus(oob_i2c_bus)
    address = 0x50
    try:
        val = eeprom.read_i2c_block_data(address, 0, 4)
        print("Option board EEPROM detected at address", hex(address))
        return True
    except:
        print("Option board EEPROM NOT detected")
        return False
    


# Check if the IO Expander is detected
@DIAG("Check Option board's IO Expander")
def t_oob_check_io_expander(cmd):
    try:
        (command) = cmd.split()
    except:
        print_error("# Command must be: t_oob_check_eeprom")
    try :
        read_relay(1)
        print("Option board's IO Expander detected")
        return True
    except :
        print_error("Option board's IO Expander not detected")
        return False 
    
