from viavi.evm import *
from viavi.diag import *
import select
import os
import os.path
import subprocess
import struct
import hashlib
import datetime
import time

import fcntl
import sys

import ctypes
import struct

import serial
import viavi.mts.uts_spi as utsspi

# constant for linux portability
_IOC_NRBITS = 8
_IOC_TYPEBITS = 8

# architecture specific
_IOC_SIZEBITS = 14
_IOC_DIRBITS = 2

_IOC_NRMASK = (1 << _IOC_NRBITS) - 1
_IOC_TYPEMASK = (1 << _IOC_TYPEBITS) - 1
_IOC_SIZEMASK = (1 << _IOC_SIZEBITS) - 1
_IOC_DIRMASK = (1 << _IOC_DIRBITS) - 1

_IOC_NRSHIFT = 0
_IOC_TYPESHIFT = _IOC_NRSHIFT + _IOC_NRBITS
_IOC_SIZESHIFT = _IOC_TYPESHIFT + _IOC_TYPEBITS
_IOC_DIRSHIFT = _IOC_SIZESHIFT + _IOC_SIZEBITS

_IOC_NONE = 0
_IOC_WRITE = 1
_IOC_READ = 2

FAN_CH1_TEMP_REG            = 0x0   # RO
FAN_CH2_TEMP_REG            = 0x1   # RO
FAN_STATUS_REG              = 0x2   # RO
FAN_MASK_REG                = 0x3   # R/W
FAN_GCONF_REG               = 0x4   # R/W
FAN_CH1_EXTDTEMP_REG        = 0x5   # RO
FAN_CH2_EXTDTEMP_REG        = 0x6   # RO
FAN_CH1_ALERTLIM_REG        = 0x8   # R/W
FAN_CH2_ALERTLIM_REG        = 0x9   # R/W
FAN_CH1_OTLIM_REG           = 0xA   # R/W
FAN_CH2_OTLIM_REG           = 0xB   # R/W
FAN_CH1_THERMLIM_REG        = 0xC   # R/W
FAN_CH2_THERMLIM_REG        = 0xD   # R/W

FAN1_CONF1_REG              = 0x10  # R/W
FAN1_CONF2a_REG             = 0x11  # R/W
FAN1_CONF2b_REG             = 0x12  # R/W
FAN1_CONF3_REG              = 0x13  # R/W
FAN2_CONF1_REG              = 0x14  # R/W
FAN2_CONF2a_REG             = 0x15  # R/W
FAN2_CONF2b_REG             = 0x16  # R/W
FAN2_CONF3_REG              = 0x17  # R/W

FAN1_TACH_CNT_REG           = 0x20   # RO
FAN2_TACH_CNT_REG           = 0x21   # RO
FAN_CH1_START_TACH_CNT_REG  = 0x22  # R/W
FAN_CH2_START_TACH_CNT_REG  = 0x23  # R/W
FAN1_PULSE_MINRPM_REG       = 0x24  # R/W
FAN2_PULSE_MINRPM_REG       = 0x25  # R/W
FAN1_CURRENT_DUTY_REG       = 0x26  # RO
FAN1_TARGET_DUTY_REG        = 0x26  # WO
FAN2_CURRENT_DUTY_REG       = 0x27  # RO
FAN2_TARGET_DUTY_REG        = 0x27  # WO
FAN_CH1_MIN_START_TEMP_REG  = 0x28  # R/W
FAN_CH2_MIN_START_TEMP_REG  = 0x29  # R/W

READ_DEVICE_ID_REG          = 0x3D  # RO
READ_MANUFACTURER_ID_REG    = 0x3E  # RO
READ_DEVICE_REV_REG         = 0x3F  # RO

SET_CHANNEL                 = 0x1
GET_CHANNEL                 = 0x2
GET_ALARM                   = 0x2
FW_COMMIT                   = 0x6
SOFT_RST                    = 0x7
GET_INFO                    = 0x8


reg_name_list = ['FAN_CH1_TEMP_REG', 'FAN_CH2_TEMP_REG', 'FAN_STATUS_REG', 'FAN_MASK_REG', 'FAN_GCONF_REG', \
                 'FAN_CH1_EXTDTEMP_REG', 'FAN_CH2_EXTDTEMP_REG', 'NONE', 'FAN_CH1_ALERTLIM_REG', 'FAN_CH2_ALERTLIM_REG', \
                 'FAN_CH1_OTLIM_REG', 'FAN_CH2_OTLIM_REG', 'FAN_CH1_THERMLIM_REG', 'FAN_CH2_THERMLIM_REG', \
                 'NONE', 'NONE', \
                 'FAN1_CONF1_REG', 'FAN1_CONF2a_REG', 'FAN1_CONF2b_REG', 'FAN1_CONF3_REG',\
                 'FAN2_CONF1_REG', 'FAN2_CONF2a_REG', 'FAN2_CONF2b_REG', 'FAN2_CONF3_REG', \
                 'NONE', 'NONE','NONE', 'NONE','NONE', 'NONE','NONE', 'NONE', \
                 'FAN1_TACH_CNT_REG', 'FAN2_TACH_CNT_REG', 'FAN_CH1_START_TACH_CNT_REG', 'FAN_CH2_START_TACH_CNT_REG', \
                 'FAN1_PULSE_MINRPM_REG', 'FAN2_PULSE_MINRPM_REG', 'FAN1_<CURRENT/TARGET>_DUTY_REG',  'FAN2_<CURRENT/TARGET>_DUTY_REG', 'FAN_CH1_MIN_START_TEMP_REG', 'FAN_CH2_MIN_START_TEMP_REG', \
                 'NONE', 'NONE','NONE', 'NONE','NONE', 'NONE', \
                 'NONE', 'NONE', 'NONE', 'NONE', 'NONE', 'NONE','NONE', 'NONE','NONE', 'NONE','NONE', 'NONE', 'NONE', \
                 'READ_DEVICE_ID_REG', 'READ_MANUFACTURER_ID_REG', 'READ_DEVICE_REV_REG']

reg_access_list = []

gpio_VDD_5V_OPT_SW_en   = 0
gpio_VDD_RS485_en       = 1
gpio_OPT_OPT_RSTn       = 2
gpio_FT232L_RSTn        = 3

SetOn                   = 1
SetOff                  = 0

REG_PUMA_FPGA_VERSION       = 0x600             # RO       <current_version>
REG_PUMA_FPGA_SYNTH_DATE    = 0x604            # RO        <current_synth_date>

global gpio_base_number
gpio_base_number = -1

#*****************************
def get_puma_glu_base_addr():
#*****************************

    debug = False

    FileName = "/usr/share/pydiag/oth/puma_glu_base_addr_tmp.txt"

    # 0000:03:00.0 Communication controller: Device 1d7d:2103

    os_base_cmd = "lspci -s 03:00.0 -v | grep 18110000"
    os_cmde = os_base_cmd+" > "+FileName

    if debug == True:
        print("os_cmde is", os_cmde)

    (os.system(os_cmde))

    with open(FileName,'r') as tmpfile:
        line = tmpfile.read()
    tmpfile.close()

    if debug:
        print("File %s: line is %s" %(FileName, line))

    tmp_list = line.split()

    if debug == True:
        print("tmp_list is" , tmp_list)

    base_addr = tmp_list[2]

    base_address = int(base_addr, base=16)

    if debug == True:
        print("base_address is 0x%x" %base_address)
        print("base_address is d'%d\n" %base_address)

    os_cmde = "rm -f "+FileName
    (os.system(os_cmde))

    return base_address

#****************************
def get_gpio_file(gpio_name):
#****************************
    global gpio_base_number

    debug_get_gpio_file = 0

    gpio_path = "/sys/class/gpio/"

    gpio_names = [  'I2CEXP_EXPCA_PWR_EN',
                    'I2CEXP_EXPCB_PWR_EN',
                    'EXPCA_I2CEXP_TYPE_PCIE_B',
                    'EXPCB_I2CEXP_TYPE_PCIE_B']

    if(gpio_base_number == -1):
        if(debug_get_gpio_file):
            print("gpio_base_number is not inited yet")
        gpiochip_file = ""

        gpio_files = os.listdir(gpio_path)
        for file in gpio_files:
            if( os.path.islink(gpio_path + file)):
                link = os.path.realpath(gpio_path + file)
                if("/5-0021/" in link):
                    if("gpiochip" in file):
                        gpiochip_file = file
                        break

        if(gpiochip_file == ""):
            print("ERROR: gpio file not found");
            return ""

        gpio_base_number = int(gpiochip_file[8:])

    else:
        if(debug_get_gpio_file):
            print("gpio_base_number already inited: " + str(gpio_base_number))

    index = 0
    try:
        index = gpio_names.index(gpio_name)
    except:
        print("ERROR: GPIO name '" + gpio_name + "' is not known !!!")
        return ""

    gpio_file = gpio_path + "gpio" + str(gpio_base_number + index) + "/value"

    return gpio_file


#****************************
def get_reg_value(reg_addr):
#****************************

    debug = False

    var = str(reg_addr)
    FileName = "/usr/share/pydiag/oth/"+var+"_tmp.txt"

    os_base_cmd = "mem 0x%x" %reg_addr+" w"
    os_cmde = os_base_cmd+" > "+FileName

    if debug == True:
        print("os_base_cmd is", os_base_cmd)
        print("os_cmde is ", os_cmde)

    (os.system(os_cmde))

    with open(FileName,'r') as tmpfile:
        line = tmpfile.read()
    tmpfile.close()

    tmp_list = line.split()

    if debug == True:
        print("File %s: line is %s" %(FileName, line))
        print("tmp_list is" , tmp_list)

    reg_val = tmp_list[1]

    register_value = int(reg_val, base=16)

    if debug == True:
        print("register_value is 0x%x %d" %register_value)
        print("register_value is d'%d\n" %register_value)

    os_cmde = "rm -f "+FileName
    (os.system(os_cmde))

    return register_value

#******************************
def IOC(dir, type, nr, size):
#******************************

    if isinstance(size, str):
        size = struct.calcsize(size)
    return dir << _IOC_DIRSHIFT | \
        type << _IOC_TYPESHIFT | \
        nr << _IOC_NRSHIFT | \
        size << _IOC_SIZESHIFT


def IO(type, nr):
    return IOC(_IOC_NONE, type, nr, 0)


def IOR(type, nr, size):
    return IOC(_IOC_READ, type, nr, size)


def IOW(type, nr, size):
    return IOC(_IOC_WRITE, type, nr, size)


def IOWR(type, nr, size):
    return IOC(_IOC_READ | _IOC_WRITE, type, nr, size)



#=============================================================
#
# Following lines comes from test_gpio.py
#
#=============================================================

#from ioctlutil import *

#from gpio_ctrl import CtrlGPIO

_OLX_IOC_MAGIC =0x75
_CTRLGPIO_GET_READY     =          IO(_OLX_IOC_MAGIC, 1)
_CTRLGPIO_SET_PORT      =          IO(_OLX_IOC_MAGIC, 2)
_CTRLGPIO_GET_PORT      =          IO(_OLX_IOC_MAGIC, 3)
_CTRLGPIO_SET_DDR       =          IO(_OLX_IOC_MAGIC, 4)
_CTRLGPIO_GET_DDR       =          IO(_OLX_IOC_MAGIC, 5)

class NotImplemented(Exception):
    pass


class CtrlGPIO(object):
    '''
    Class to use IOCTL from driver eni_gpio_ctrl
    '''
    test = 0
    __fd = None

    def __init__(self, device):
        self.__dev = device
        self.__fd = None

    def open(self):
        if self.__fd is None:
            print("Opening device")
            self.__fd = open(self.__dev, "rb")

    def close(self):
        if self.__fd is not None:
            self.__fd.close()
            self.__fd = None

    def get_direction(self):

        arg = ctypes.c_uint()

        if self.__fd is not None:
            fcntl.ioctl(self.__fd, _CTRLGPIO_GET_DDR,arg)
        else:
            with open(self.__dev, "rb") as f:
                fcntl.ioctl(f, _CTRLGPIO_GET_DDR, arg)
        return arg

    def set_direction(self, gpio_nb):

        arg = ctypes.c_uint()
        arg = gpio_nb


        if self.__fd is not None:
            fcntl.ioctl(self.__fd, _CTRLGPIO_SET_DDR, arg)
        else:
            with open(self.__dev, "rb") as f:
                fcntl.ioctl(f, _CTRLGPIO_SET_DDR, arg)
        return 0

    def get_value(self):

        arg = ctypes.c_uint()

        if self.__fd is not None:
            test = fcntl.ioctl(self.__fd, _CTRLGPIO_GET_PORT, arg)
        else:
            with open(self.__dev, "rb") as f:
                test = fcntl.ioctl(f, _CTRLGPIO_GET_PORT, arg)
        return arg


    def set_value(self, gpio_nb):

        arg = ctypes.c_uint()
        arg = gpio_nb


        if self.__fd is not None:
            fcntl.ioctl(self.__fd, _CTRLGPIO_SET_PORT, arg)
        else:
            with open(self.__dev, "rb") as f:
                fcntl.ioctl(f, _CTRLGPIO_SET_PORT, arg)
        return 0
#
#=============================================================================================
#
@DIAG("backplane PSU enable devices")
def t_obb7000_psu_set(cmd):
#
#=============================================================================================
#
    verbose = False

    try:
        (command, consigne) = cmd.split()
        print_info("* consigne is "+consigne)
        print()
        (psu_list, OnOFF_flag) = consigne.split('-')

    except:
        print_error("                                                                   ")
        print_error("   Syntax error : Command must be : t_obb7000_psu_set <consigne>   ")
        print_error("                                                                   ")
        print_error("   with                <consigne> is : <PSU_LIST>-<OnOff_FLAG>     ")
        print_error("                                                                   ")
        print_error("   where              * <PSU_LIST> = VDD_5V|VDD_5V_SW|VDD_RS485|ALL")
        print_error("                      * <OnOff_FLAG> = ON|OFF                      ")
        print_error("                                                                   ")
        print_error("   example : t_obb7000_psu_set VDD_5V|VDD_RS485-ON                 ")
        print_error("                                                                   ")

        return False

    vdd_5v_ind = 0
    vdd_5v_sw_ind = 1
    vdd_rs485_ind = 2

    psu_name_list     = ["VDD_5V", "VDD_5V_SW", "VDD_RS485"]
    psu_todo_list     = ["NO",        "NO",     "NO"]

    arg_error_nb = 0

    arg_list = psu_list.split('|')

    for elt in enumerate(arg_list):
        if elt[1] not in psu_name_list:
            if elt[1] != 'ALL':
                print_error("     * Error : ", elt[1], "is not a correct arg")
                arg_error_nb += 1

    if OnOFF_flag == "ON" or OnOFF_flag == "OFF":
        if OnOFF_flag == "ON":
            psu_cmd = 1
            OnOff_value = 1
            OnOff_msg = "Set ON"
        else:
            psu_cmd = 0
            OnOff_value = 0
            OnOff_msg = "reset OFF"
    else:
        arg_error_nb += 1
        print_error("     * Error : OnOFF_flag = %s is not a correct value\n" %OnOFF_flag)

    if arg_error_nb > 0:
        return False

    i = 0
    if 'ALL' in arg_list:
        while i < len(psu_name_list):
            psu_todo_list[i] = "YES"
            i += 1
    else:
        for elt in enumerate(psu_name_list):
            if elt[1] in arg_list:
                psu_todo_list[i] = "YES"
                if (elt[1] == "VDD_5V_SW" or elt[1] == "VDD_RS485") and OnOFF_flag == "ON":
                    psu_todo_list[0] = "YES"
            i += 1

    if verbose:
        i = 0
        print("")
        while i < len(psu_name_list):
            print("* psu_todo_list[ %s] = %s" %(psu_name_list[i], psu_todo_list[i]))
            i += 1

    if psu_todo_list[vdd_5v_ind] == "YES":
        print("* %s VDD_5V power supply" %(OnOff_msg))
        os_base_cmd = "echo "+ str(psu_cmd) +" > "+ get_gpio_file("I2CEXP_EXPCA_PWR_EN")
        print("os_base_cmd is ", os_base_cmd)
        (os.system(os_base_cmd))

    if psu_todo_list[vdd_5v_sw_ind] == "YES":
        print("* %s VDD_5V_SW power supply" %(OnOff_msg))
        gpio_nb = 0
        bpl_gpio_set(gpio_nb, OnOff_value)

    if psu_todo_list[vdd_rs485_ind] == "YES":
        print("* %s VDD_RS485 power supplies" %(OnOff_msg))
        gpio_nb = 1
        bpl_gpio_set(gpio_nb, OnOff_value)

    return None
#
#=============================================================================================
#
@DIAG("backplane enable devices")
def t_obb7000_gpio_first_test(cmd):
#
#=============================================================================================
#

    os.system("hamma action.write.host port.moduleSelector.MODULE_SEL value.0x04 >& /dev/Null")

    gpio = CtrlGPIO("/dev/eni_ctrlgpio_pw")
    gpio.open()

    r = gpio.get_direction()
    print("\nGPIO Direction settings=%s"%(hex(r.value).rstrip("L")))

    Direction = 0xAAAA
    gpio.set_direction(Direction)

    r = gpio.get_direction()
    print("\nGPIO Direction settings=%s"%(hex(r.value).rstrip("L")))

    Pattern = 0x0002
    x= 0
    while x < 8 :
        print("\nWriting pattern=%s"%(hex(Pattern)))
        gpio.set_value(Pattern)
        r = gpio.get_value()
        read = r.value & Direction
        print("Read Pattern=%s"%(hex(read).rstrip("L")))
        time.sleep(2)
        Pattern = Pattern *4
        x = x+1

    Direction = 0x5555
    gpio.set_direction(Direction)

    r = gpio.get_direction()
    print("\nGPIO Direction settings=%s"%(hex(r.value).rstrip("L")))

    Pattern = 0x0001
    x= 0
    while x < 8 :
        print("\nWriting pattern=%s"%(hex(Pattern)))
        gpio.set_value(Pattern)
        r = gpio.get_value()
        read = r.value & Direction
        print("Read Pattern=%s"%(hex(read).rstrip("L")))
        time.sleep(2)
        Pattern = Pattern *4
        x = x+1
#
#=============================================================================================
#
def bpl_gpio_set(gpio_nb, OnOff_value):
#
# gpio<0> enable VDD_5V_SW
# gpio<1> enable RS485_psu (+5V_RS485 and +12V_RS485)
# gpio<2> reset the Optical Switch
# gpio<3> pilots the Resetn input of FT232RL device
#
#=============================================================================================
#
    debug = False

    os.system("hamma action.write.host port.moduleSelector.MODULE_SEL value.0x04 >& /dev/Null")

    gpio = CtrlGPIO("/dev/eni_ctrlgpio_pw")
    gpio.open()

    r = gpio.get_direction()
    if debug:
        print("\nGPIO Direction initial settings = %s"%(hex(r.value).rstrip("L")))

    Direction = 0x000f
    gpio.set_direction(Direction)

    direction = gpio.get_direction()

    if debug:
        print("\ndbg : direction is", direction, "direction.value is", direction.value)
        print("\nGPIO Direction settings = %s"%(hex(direction.value).rstrip("L")))

    r = gpio.get_value()
    read = r.value & Direction

    if debug:
        print("get_value read is ", read, "get_value_hexa = 0x%x" %read)
        print("Read Pattern = %s"%(hex(read).rstrip("L")))

    if gpio_nb == 0:
        if OnOff_value == SetOn:
            Pattern = read | 0x1
        else:
            Pattern = read & 0xfe
    elif gpio_nb == 1:
        if OnOff_value == SetOn:
            Pattern = read | 0x2
        else:
            Pattern = read & 0xfd
    elif gpio_nb == 2:
        if OnOff_value == SetOn:
            Pattern = read | 0x4
        else:
            Pattern = read & 0xfb
    elif gpio_nb == 3:
        if OnOff_value == SetOn:
            Pattern = read | 0x8
        else:
            Pattern = read & 0xf7
    else:
        print("Error : unknown gpio bit_number")

    if debug:
        print("\nbpl_gpio_set proc.: Writing pattern = %s"%(hex(Pattern)))

    gpio.set_value(Pattern)
#
#=============================================================================================
#
@DIAG("backplane gpio status")
def t_obb7000_gpio_status(cmd):
#
#=============================================================================================
#
    os.system("hamma action.write.host port.moduleSelector.MODULE_SEL value.0x04 >& /dev/Null")

    gpio = CtrlGPIO("/dev/eni_ctrlgpio_pw")
    gpio.open()

    r = gpio.get_direction()
    print("\nGPIO Direction initial settings = %s"%(hex(r.value).rstrip("L")))

    Direction = 0xf
    print("Set GPIO Direction = 0x%x" %Direction)
    gpio.set_direction(Direction)

    r = gpio.get_value()
    read = r.value & Direction
    bit_0 = read & 0x1
    bit_1 = (read & 0x2) >> 1
    bit_2 = (read & 0x4) >> 2
    bit_3 = (read & 0x8) >> 3

    print("\nRead Pattern = %s"%(hex(read).rstrip("L")))
    print("     * gpio[0] = %d (VDD_5V_SW_EN)" %bit_0)
    print("     * gpio[1] = %d (VDD_RS485_EN)" %bit_1)
    print("     * gpio[2] = %d (OPT_RSTn value)" %bit_2)
    print("     * gpio[3] = %d (FT232RL RSTn value)" %bit_3)

    return None
#
#=============================================================================================
#
@DIAG("backplane gpio<0>, gpio<1>, gpio<2>, gpio<3> Set")
def t_obb7000_gpio_set(cmd):
#
#=============================================================================================
#
    arg_error_nb = 0

    try:
        (command, consigne) = cmd.split()
        print_info("* consigne is "+consigne)
        (gpio_str, OnOFF_flag) = consigne.split('-')

    except:
        print_error("                                                                      ")
        print_error("   Syntax error : Command must be : t_obb7000_gpio_set <consigne>     ")
        print_error("                                                                      ")
        print_error("   with                <consigne> is : <GPIO_NB>-<OnOff_FLAG>         ")
        print_error("                                                                      ")
        print_error("   where               <GPIO_NB>  is : {gpio0, gpio1, gpio2, gpio3}   ")
        print_error("                                       *  gpio0 = VDD_5V_SW enable    ")
        print_error("                                       *  gpio1 = RS485 psu enable    ")
        print_error("                                       *  gpio2 = Optical Switch Reset")
        print_error("                                       *  gpio3 = FT232L Reset        ")
        print_error("                                                                      ")
        print_error("                       <OnOff_FLAG> = ON|OFF                          ")
        print_error("                                                                      ")
        return False

    if gpio_str == "gpio0":

        print("\n#*******************************")
        print("# gpio0 pilots VDD_5V_SW enable")
        print("#*******************************\n")

        gpio_nb = 0
    elif gpio_str == "gpio1":

        print("\n#******************************************")
        print("# gpio1 pilots RS485 power supplies enable")
        print("#******************************************\n")

        gpio_nb = 1
    elif gpio_str == "gpio2":

        print("\n#************************************************")
        print("# gpio2 pilots Optical Switch Reset (active low)")
        print("#************************************************\n")

        gpio_nb = 2
    elif gpio_str == "gpio3":

        print("\n#************************************************")
        print("# FT232L Reset (active low)")
        print("#************************************************\n")

        gpio_nb = 3
    else:
        print("     * Error : GPIO_NB = %s is not a correct value" %gpio_str)
        arg_error_nb += 1

    if OnOFF_flag == "ON" or OnOFF_flag == "OFF":
        if OnOFF_flag == "ON":
            OnOff_value = 1
        else:
            OnOff_value = 0
    else:
        arg_error_nb += 1
        print_error("     * Error : OnOFF_flag = %s is not a correct value\n" %OnOFF_flag)

    if arg_error_nb > 0:
        return False

    bpl_gpio_set(gpio_nb, OnOff_value)

    if 0 == 1:
        Pattern = 0x0001
        print("\nWriting pattern=%s"%(hex(Pattern)))
        gpio.set_value(Pattern)
        r = gpio.get_value()
        read = r.value & Direction
        print("Read Pattern=%s"%(hex(read).rstrip("L")))

        Pattern = 0x0002
        print("\nWriting pattern=%s"%(hex(Pattern)))
        gpio.set_value(Pattern)
        r = gpio.get_value()
        read = r.value & Direction
        print("Read Pattern=%s"%(hex(read).rstrip("L")))

        Pattern = 0x0003
        print("\nWriting pattern=%s"%(hex(Pattern)))
        gpio.set_value(Pattern)
        r = gpio.get_value()
        read = r.value & Direction
        print("Read Pattern=%s"%(hex(read).rstrip("L")))

        input("\n Press Enter to continue : ")

        Pattern = 0x0000
        print("\nWriting pattern=%s"%(hex(Pattern)))
        gpio.set_value(Pattern)
        r = gpio.get_value()
        read = r.value & Direction
        print("Read Pattern=%s"%(hex(read).rstrip("L")))
#
#=============================================================================================
#
# backplane i2c devices :
#
#  Identificatyion EEPROM @ I2C_addr = 0x54
#  PCA9535 IO expander @ I2C_addr = 0x20
#  Temperature sensor test @ I2C_addr = 0x48
#  I2C PCA9532_led @ I2C_addr = 0x60
#  I2C PCA9535_gpio_expander @ I2C_addr = 0x20
#
#=============================================================================================
#
@DIAG("backplane i2c devices detection")
def t_obb7000_i2cdetect(cmd):

    debug = False

    try:
        if ' ' not in cmd:
            verbose = False
            pass
        else:
            (command, verbose_flag) = cmd.split()
            if verbose_flag == "verbose":
                print("arg exist : %s" %verbose_flag, "\n")
                verbose = True
            else:
                print_error("   Syntax error : arg must be : verbose")
                print()
                return False
    except:
        print_error("                                                                      ")
        print_error("   Syntax error : Command must be : t_obb7000_i2cdetect <verbose_flag>")
        print_error("                                                                      ")
        print_error("   With           <verbose_flag> = verbose ONLY                       ")
        print_error("                  Note : <verbose_flag> is optional                   ")
        print_error("                                                                      ")
        return False


    FileName = "/usr/share/pydiag/oth/psb_i2c_detect_tmp.txt"

    psb_i2c_bus_nb = '7'

    i2c_cmde = "i2cdetect -y "+psb_i2c_bus_nb

    if verbose:
        print("================")
        print("**** i2c-%s bus:" %psb_i2c_bus_nb)
        print("================\n")

        return_val = (os.system(i2c_cmde))

    os_cmde = i2c_cmde+ " > "+FileName

    return_val = (os.system(os_cmde))

    if verbose:
        print("\n* os_cmde = ", os_cmde)

        print("return_val of os_cmde = ", return_val, "\n")                     # return 0 if os.system(i2c_cmde) is successful

    if psb_i2c_bus_nb == '0':
        i2c_to_detect_list = ['20', '48', '50', '60']
        i2c_device_list = ['PCA9535', 'Temperature sensor', 'EEPROM ident', 'PCA9532']
    else:
        i2c_to_detect_list = ['2e', '54', '71', '74', '75']
        i2c_device_list = ['MAX6639', 'EEPROM ident', 'CPB_U47', 'I2C-2-MUX', 'I2C-6-MUX']

    i2c_detected_list = []

    with open(FileName,'r') as tmpfile:
        for line in tmpfile.readlines():
            col = 0
            if ':' in line:
                (addr_list, data_list) = line.split(': ')
                if debug:
                    print("* addr = ", addr_list, " ; data_list = ", data_list)

                var = data_list.split(' ')
                if debug:
                    print("     - var = ", var, " ; length = %d" %len(var))

                if len(var) > 17:
                    j = 0
                    var1 = []
                    while j < len(var):
                        if var[j] == '':
                            var1.append('  ')
                            j += 2
                        else:
                            var1.append(var[j])
                        j += 1

                    if debug:
                        print("         > var1 = ", var1, " ; length = %d" %len(var1))

                    var = var1

                    if debug:
                        print("         > var  = ", var, " ; length = %d" %len(var))

                for elt in enumerate (var):
                    if elt[1] != '  ' and elt[1] != '--' and  elt[1] != '\n':
                        if debug:
                            print("     - elt[%d][%d]" %(int(addr_list), col), "= %s" %elt[1])
                            print("     - elt[%X][%x]" %(int(addr_list, base=16), col), "= %s" %elt[1])
                            
                        i2c_addr = int(addr_list, base=16) + col
                        i2c_addr_h = "%x" %i2c_addr

                        i2c_detected_list.append(i2c_addr_h)
                    col += 1

    tmpfile.close()

    os_cmde = "rm -f "+FileName

    if debug == True:
        print("os_cmde is", os_cmde)

    (os.system(os_cmde))

    if debug:
        print("i2c_detected_list is ", i2c_detected_list)

    pass_flag = True
    for elt in enumerate (i2c_to_detect_list):
        if (elt[1]) in i2c_detected_list:
            print_ok("I2C device at addr 0x%s" %elt[1]+" detected")
        else:
            print_error("I2C device at addr 0x%s" %elt[1]+" not detected")
            pass_flag = False

    return pass_flag
#
#=============================================================================================
#
@DIAG("Backplane i2c eeprom read")
def t_obb7000_eeprom_read(cmd):

    eeprom_i2c_bus_nb = "7"
    eeprom_i2c_addr = "0x54"

    i2c_cmde = "i2cdump -y "+eeprom_i2c_bus_nb+" "+eeprom_i2c_addr+" c"

    print("i2c cmde is : ", i2c_cmde)
    (os.system(i2c_cmde))

    return True
#
#=============================================================================================
#
# Non functional
#
#=============================================================================================
#
@DIAG("Backplane i2c eeprom write")

def t_obb7000_eeprom_write(cmd):

    debug = True

    eeprom_i2c_bus_nb = "7"
    eeprom_i2c_addr = "0x50"

    eeprom_addr = "0x27"
    eeprom_value = "0x0"

    i2c_cmde = "i2cset -f -y "+eeprom_i2c_bus_nb+" "+eeprom_i2c_addr+" "+eeprom_addr+" "+eeprom_value

    if debug:
        print("i2c_cmde is", i2c_cmde)

    (os.system(i2c_cmde))

    return None
#
#=============================================================================================
def i2c_parser(i2c_bus_nb, dev_i2c_addr, reg_addr, verbose):
#=============================================================================================
#
    start_addr = reg_addr & 0xf0
    reg_addr_first = str(start_addr)
    reg_addr_last  = str(start_addr+0xf)

    if verbose:
        print("\n*** Data Readback @ addr = 0x%x" %reg_addr)
        print("*** Parse from addr = %s to %s\n" %(reg_addr_first, reg_addr_last))

    i2c_cmde = "i2cdump -f -y -r "+reg_addr_first+"-"+reg_addr_last+" "+i2c_bus_nb+" "+dev_i2c_addr+" b"

    if verbose:
        print("i2c cmde is : ", i2c_cmde)

    FileName = "/usr/share/pydiag/oth/psb_i2c_MAX6639_tmp.txt"

    os_cmde = i2c_cmde+ " > "+FileName
    (os.system(os_cmde))

    if verbose:
        print("")

    with open(FileName,'r') as tmpfile:
        for line in tmpfile.readlines():
            if verbose:
                print("line is", line)
            if ':' in line:
                (addr_list, data_list) = line.split(': ')
                if verbose:
                    print("* addr = ", addr_list, " ; data_list = ", data_list)

    tmpfile.close()

    os_cmde = "rm -f "+FileName
    (os.system(os_cmde))

    var = data_list.split(' ')

    if verbose:
        print("var is", var)

    ind = reg_addr & 0xf

    data_value = var[ind]

    return int(data_value, base=16)

#=============================================================================================
def fan_driver(reg_addr, Access, WrData, verbose):
#=============================================================================================
#
    i2c_bus_nb   = "7"
    dev_i2c_addr = "0x2e"

    if Access == "WR":
        if verbose:
            print("\n Write 0x%x into %s reg. @ addr = 0x%x " %(WrData, reg_name_list[reg_addr], reg_addr))

        i2c_cmde = "i2cset -f -y "+i2c_bus_nb+" "+dev_i2c_addr+" "+str(reg_addr)+" "+str(WrData)
        if verbose:
            print("i2cset cmde is :", i2c_cmde)
        (os.system(i2c_cmde))
        ret_flag = None
    else:
        RdData = i2c_parser(i2c_bus_nb, dev_i2c_addr, reg_addr, verbose)
        ret_flag = RdData
        if verbose:
            print("\n* %s reg. readback @ addr 0x%x = 0x%x = d'%d" %(reg_name_list[reg_addr], reg_addr, RdData, RdData))

    return ret_flag

#*********************************************
def show_fan_reg_contents(reg_addr, verbose):
#*********************************************

    device_i2c_bus_nb = "7"
    device_i2c_addr   = "0x2e"

    #print("\nreg_name_str is", reg_name_list[reg_addr])

    if reg_addr == FAN_CH1_TEMP_REG:
        access_str = 'RO'
    elif reg_addr == FAN_CH2_TEMP_REG:
        access_str = 'RO'
    elif reg_addr == FAN_STATUS_REG:
        access_str = 'RO'
    elif reg_addr == FAN_MASK_REG:
        access_str = 'RW'
    elif reg_addr == FAN_GCONF_REG:
        access_str = 'RW'
    elif reg_addr == FAN_CH1_EXTDTEMP_REG:
        access_str = 'RO'
        channel_num = 1
    elif reg_addr == FAN_CH2_EXTDTEMP_REG:
        access_str = 'RO'
        channel_num = 2
    elif reg_addr == FAN_CH1_ALERTLIM_REG:
        access_str = 'RW'
    elif reg_addr == FAN_CH2_ALERTLIM_REG:
        access_str = 'RW'
    elif reg_addr == FAN_CH1_OTLIM_REG:
        access_str = 'RW'
    elif reg_addr == FAN_CH2_OTLIM_REG:
        access_str = 'RW'
    elif reg_addr == FAN_CH1_THERMLIM_REG:
        access_str = 'RW'
    elif reg_addr == FAN_CH2_THERMLIM_REG:
        access_str = 'RW'
    elif reg_addr == FAN1_CONF1_REG:
        access_str = 'RW'
        fan_num = 1
    elif reg_addr == FAN1_CONF2a_REG:
        access_str = 'RW'
        fan_num = 1
    elif reg_addr == FAN1_CONF2b_REG:
        access_str = 'RW'
        fan_num = 1
    elif reg_addr == FAN1_CONF3_REG:
        access_str = 'RW'
        fan_num = 1
    elif reg_addr == FAN2_CONF1_REG:
        access_str = 'RW'
        fan_num = 2
    elif reg_addr == FAN2_CONF2a_REG:
        access_str = 'RW'
        fan_num = 2
    elif reg_addr == FAN2_CONF2b_REG:
        access_str = 'RW'
        fan_num = 2
    elif reg_addr == FAN2_CONF3_REG:
        access_str = 'RW'
        fan_num = 2
    elif reg_addr == FAN1_TACH_CNT_REG:
        access_str = 'RO'
    elif reg_addr == FAN2_TACH_CNT_REG:
        access_str = 'RO'
    elif reg_addr == FAN_CH1_START_TACH_CNT_REG:
        access_str = 'RW'
    elif reg_addr == FAN_CH2_START_TACH_CNT_REG:
        access_str = 'RW'
    elif reg_addr == FAN1_PULSE_MINRPM_REG:
        access_str = 'RW'
        fan_num = 1
    elif reg_addr == FAN2_PULSE_MINRPM_REG:
        access_str = 'RW'
        fan_num = 2
    elif reg_addr == FAN1_CURRENT_DUTY_REG:
        access_str = 'RO'
    elif reg_addr == FAN2_CURRENT_DUTY_REG:
        access_str = 'RO'
    elif reg_addr == FAN_CH1_MIN_START_TEMP_REG:
        access_str = 'R/W'
    elif reg_addr == FAN_CH2_MIN_START_TEMP_REG:
        access_str = 'R/W'
    elif reg_addr == READ_DEVICE_ID_REG:
        access_str = 'RO'
    elif reg_addr == READ_MANUFACTURER_ID_REG:
        access_str = 'RO'
    elif reg_addr == READ_DEVICE_REV_REG:
        access_str = 'RO'
    else:
        pass

    loc_verbose = False
    data_rd = i2c_parser(device_i2c_bus_nb, device_i2c_addr, reg_addr, loc_verbose)

    if verbose:
        print("\n* %s register read (@ addr 0x%x) = 0x%x = %d" %(reg_name_list[reg_addr], reg_addr, data_rd, data_rd))

    if verbose:
        bit_0 = data_rd & 0x1
        bit_1 = int((data_rd & 0x2)/2)
        bit_2 = int((data_rd & 0x4)/4)
        bit_3 = int((data_rd & 0x8)/8)
        bit_4 = int((data_rd & 0x10)/16)
        bit_5 = int((data_rd & 0x20)/32)
        bit_6 = int((data_rd & 0x40)/64)
        bit_7 = int((data_rd & 0x80)/128)

        if reg_addr == FAN_STATUS_REG:
            print("  %s register (%s) content :" %(reg_name_list[reg_addr], access_str))

            print("     - Reserved           (bit_7) = 0x%x" %bit_7)
            print("     - Reserved           (bit_6) = 0x%x" %bit_6)
            print("     - Ch1_OT_B           (bit_5) = 0x%x" %bit_5)
            print("     - Ch2_OT_B           (bit_4) = 0x%x" %bit_4)
            print("     - Ch1_THERM_B        (bit_3) = 0x%x" %bit_3)
            print("     - Ch2_THERM_B        (bit_2) = 0x%x" %bit_2)
            print("     - Fan 1 fault        (bit_1) = 0x%x" %bit_1)
            print("     - Fan 2 fault        (bit_0) = 0x%x" %bit_0)

        elif reg_addr == FAN_MASK_REG:
            print("  %s register (%s) content :" %(reg_name_list[reg_addr], access_str))
            print("     - Reserved           (bit_7) = 0x%x" %bit_7)
            print("     - Reserved           (bit_6) = 0x%x" %bit_6)
            print("     - Ch1_OT_B           (bit_5) = 0x%x" %bit_5)
            print("     - Ch2_OT_B           (bit_4) = 0x%x" %bit_4)
            print("     - Ch1_THERM_B        (bit_3) = 0x%x" %bit_3)
            print("     - Ch2_THERM_B        (bit_2) = 0x%x" %bit_2)
            print("     - Fan 1 fault        (bit_1) = 0x%x" %bit_1)
            print("     - Fan 2 fault        (bit_0) = 0x%x" %bit_0)

        elif reg_addr == FAN_GCONF_REG:
            if bit_3 == 0:
                msg = "(20Hz to 100Hz range)"
            else:
                msg = "(5kHz to 25kHz range)"

            if bit_4 == 0:
                src_msg = "(source is remote_2)"
            else:
                src_msg = "(source is local sensor)"

            if bit_7 == 0:
                run_msg = '(Normal operation)'
            else:
                run_msg = '(conversion suspended : low power mode)'

            print("  %s register (%s) content :" %(reg_name_list[reg_addr], access_str))
            print("     - RUN_B/STDBY        (bit_7) = 0x%x %s" %(bit_7, run_msg))
            print("     - POR                (bit_6) = 0x%x" %bit_6)
            print("     - SMBUS time_out     (bit_5) = 0x%x" %bit_5)
            print("     - Temp Ch2 source    (bit_4) = 0x%x %s" %(bit_4, src_msg))
            print("     - PWM out freq range (bit_3) = 0x%x %s" %(bit_3, msg))
            print("     - Reserved           (bit_2) = 0x%x" %bit_2)
            print("     - Reserved           (bit_1) = 0x%x" %bit_1)
            print("     - Reserved           (bit_0) = 0x%x" %bit_0)

        elif reg_addr == FAN_CH1_EXTDTEMP_REG or reg_addr == FAN_CH2_EXTDTEMP_REG:
            print("  FAN_CH%d_EXTDTEMP_REG (%s) content :" %(channel_num, access_str))
            print("     - Temp val MSB 0.5°C    (bit_7) = 0x%x" %bit_7)
            print("     - Temp val              (bit_6) = 0x%x" %bit_6)
            print("     - Temp val LSB 0.125°C  (bit_5) = 0x%x" %bit_5)
            print("     - Reserved              (bit_4) = 0x%x" %bit_4)
            print("     - Reserved              (bit_3) = 0x%x" %bit_3)
            print("     - Reserved              (bit_2) = 0x%x" %bit_2)
            print("     - Reserved              (bit_1) = 0x%x" %bit_1)
            print("     - Diode Fault           (bit_0) = 0x%x" %bit_0)

            extd_temp_val = bit_7 * 0.5 + (bit_6 * 0.25) + (bit_5 * 0.125)
            print("\n     - extd_temp_value = %3f" %extd_temp_val)

            if bit_0 == 1:
                print("     - Note : a Diode fault has been detected")

        elif reg_addr == FAN1_CONF1_REG or reg_addr == FAN2_CONF1_REG:
            if bit_7 == 1:
                pwm_msg = "(Manual PWM duty cycle control mode)"
            else:
                pwm_msg = "(Automatic RPM control mode)"

            rpm_indice = (bit_1 << 1) | bit_0
            if rpm_indice == 0:
                rpm_range_msg = "(Fan max RPM value = 2000)"
            elif rpm_indice == 1:
                rpm_range_msg = "(Fan max RPM value = 4000)"
            elif rpm_indice == 2:
                rpm_range_msg = "(Fan max RPM value = 8000)"
            else:
                rpm_range_msg = "(Fan max RPM value = 16000)"

            print("  FAN%d_CONF1_REG (%s) content :" %(fan_num, access_str))
            print("     - PWM_mode           (bit_7) = 0x%x %s" %(bit_7, pwm_msg))
            print("     - RateOfChange (MSB) (bit_6) = 0x%x" %bit_6)
            print("     - RateOfChange       (bit_5) = 0x%x" %bit_5)
            print("     - RateOfChange (LSB) (bit_4) = 0x%x" %bit_4)
            print("     - Fan%d Ch1_Ctrl      (bit_3) = 0x%x" %(fan_num, bit_3))
            print("     - Fan%d Ch2_Ctrl      (bit_2) = 0x%x" %(fan_num, bit_2))
            print("     - RPM Range Select   (bit_1) = 0x%x" %bit_1)
            print("     - RPM Range Select   (bit_0) = 0x%x %s" %(bit_0, rpm_range_msg))

        elif reg_addr == FAN1_CONF2a_REG or reg_addr == FAN2_CONF2a_REG:
            # these registers apply to the Automatic RPM control mode
            print("  FAN%d_CONF2a_REG (%s) content :" %(fan_num, access_str))
            print("     - RPM Step Size A(MSB) (bit_7) = 0x%x" %bit_7)
            print("     - RPM Step Size A      (bit_6) = 0x%x" %bit_6)
            print("     - RPM Step Size A      (bit_5) = 0x%x" %bit_5)
            print("     - RPM Step Size A(LSB) (bit_4) = 0x%x" %bit_4)
            print("     - Temp Step Size (MSB) (bit_3) = 0x%x" %bit_3)
            print("     - Temp Step Size (LSB) (bit_2) = 0x%x" %bit_2)
            print("     - PWM Polarity         (bit_1) = 0x%x" %bit_1)
            print("     - Min Fan Speed        (bit_0) = 0x%x" %bit_0)

        elif reg_addr == FAN1_CONF2b_REG or reg_addr == FAN2_CONF2b_REG:
            # these registers apply to the Automatic RPM control mode
            print("  FAN%d_CONF2b_REG %s) content :" %(fan_num, access_str))
            print("     - RPM step size B (MSB)         (bit_7) = 0x%x" %bit_7)
            print("     - RPM step size B               (bit_6) = 0x%x" %bit_6)
            print("     - RPM step size B               (bit_5) = 0x%x" %bit_5)
            print("     - RPM step size B (LSB)         (bit_4) = 0x%x" %bit_4)
            print("     - Start Step size B (MSB)       (bit_3) = 0x%x" %bit_3)
            print("     - Start Step size B             (bit_2) = 0x%x" %bit_2)
            print("     - Start Step size B             (bit_1) = 0x%x" %bit_1)
            print("     - Start Step size B (LSB)       (bit_0) = 0x%x" %bit_0)

        elif reg_addr == FAN1_CONF3_REG or reg_addr == FAN2_CONF3_REG:
            # 0x0 = 20Hz ; 0x1 = 33.33Hz ; 0x2 = 50Hz ; 0x3 = 100hz  (values when pwm_freq_range_bit = 0)
            # 0x0 = 5kHz ; 0x1 = 8.33kHz ; 0x2 = 12.5kHz ; 0x3 = 25kHz (values when pwm_freq_range_bit = 1)
            pwm_freq_val = (bit_1 << 1) | bit_0
            if pwm_freq_val == 0:
                pwm_freq_msg = 'PWM_freq = 20Hz or 5kHz'
            elif pwm_freq_val == 1:
                pwm_freq_msg = 'PWM_freq = 33.33Hz or 8.33kHz'
            elif pwm_freq_val == 2:
                pwm_freq_msg = 'PWM_freq = 50Hz or 12.5kHz'
            else:
                pwm_freq_msg = 'PWM_freq = 100Hz or 25kHz'

            print("  FAN%d_CONF3_REG (%s) content :" %(fan_num, access_str))
            print("     - Spin up disable               (bit_7) = 0x%x" %bit_7)
            print("     - THERM to full speed enable    (bit_6) = 0x%x" %bit_6)
            print("     - Pulse streching disable       (bit_5) = 0x%x" %bit_5)
            print("     - Reserved                      (bit_4) = 0x%x" %bit_4)
            print("     - Reserved                      (bit_3) = 0x%x" %bit_3)
            print("     - Reserved                      (bit_2) = 0x%x" %bit_2)
            print("     - Fan PWM frequency (MSB)       (bit_1) = 0x%x (%s)" %(bit_1, pwm_freq_msg))
            print("     - Fan PWM frequency (LSB)       (bit_0) = 0x%x" %bit_0)

        elif reg_addr == FAN1_PULSE_MINRPM_REG or reg_addr == FAN2_PULSE_MINRPM_REG:
            print("  FAN%d_PULSE_MINRPM_REG (%s) content :" %(fan_num, access_str))
            min_tach_cnt = data_rd & 0x3f
            pulse_per_revolution_indice = (data_rd & 0xc0) >> 6
            if pulse_per_revolution_indice == 0:
                msg = "1 pulse per revolution"
            elif pulse_per_revolution_indice == 1:
                msg = "2 pulses per revolution"
            elif pulse_per_revolution_indice == 1:
                msg = "3 pulses per revolution"
            else:
                msg = "4 pulses per revolution"
            print("     > min_tach_count = 0x%x" %min_tach_cnt)
            print("     > pulse_per_revolution_indice = 0x%x (%s)" %(pulse_per_revolution_indice, msg))
        else:
            pass

    return None
#
#=============================================================================================
#
# snowfan Fan is :
#   - 4 poles
#   - freq_range = 300Hz 30kHz
#   - rpm : 0 @ 0% duty_cycle
#   - rpm : 2000 @ 20% duty_cycle
#   - rpm : 8500 @ 50% duty_cycle
#   - rpm : 12600 @ 100% duty_cycle
#
# SUNON Fan is :
#   - 4 poles
#   - freq_range = 20kHz to 30kHz
#   - rpm : 0 @ 0% duty_cycle
#   - rpm : 5300 @ 50% duty_cycle
#   - rpm : 10000 @ 100% duty_cycle
#
# PWM_mode set :
#       * Set Manual or automatic PWM mode into FAN<n>_CONF1_REG
#       * set PWM_freq_range into FAN_GCONF_REG
#           0 : PWM_freq_range = 20Hz to 100Hz
#           1 : PWM_freq_range = 5kHz to 25khz
#       * select PWM_freq_out into FAN<n>_CONF3_REG
#           # Si PWM_freq_range = 20Hz to 100Hz :
#               0x3 = 100hz ; 0x2 = 50Hz ; 0x1 = 33.33Hz ; 00 = 20Hz
#           # Si PWM_freq_range = 5kHz to 25khz
#               0x3 = 25kHz : 0x2 = 12.5kHz ; 0x1 = 8.33kHz ; 0x0 = 5kHz
#       * select PWM duty cycle into FAN<n>_TARGET_DUTY_REG (WO)
#         Note : current PWM duty cycle can be read from FAN<n>_CURRENT_DUTY_REG (RO)
#
#=============================================================================================
#
@DIAG("Backplane i2c MAX6639 registers debug")
def t_obb7000_MAX6639_fanctrl_dbg(cmd):

    debug = True
    verbose = False

    try:
        if ' ' not in cmd:
            pass
        else:
            (command,consigne) = cmd.split()
            if debug:
                print("arg exist : %s" %consigne)
            if consigne == "verbose":
                verbose = True
            else:
                print_error("   Syntax error : arg must be : verbose\n")
                return False

    except:
        print_error("   Syntax error : Command must be : t_obb7000_MAX6639_fanctrl_dbg <consigne>\n")

    device_i2c_bus_nb = "7"
    device_i2c_addr   = "0x2e"

    # Fan1 control :
    #****************

    print("\n***********************")
    print(" Fan1 PWM control test")
    print("***********************\n")

    print("*** Initial values")

    show_fan_reg_contents(FAN_GCONF_REG, verbose= True)

    show_fan_reg_contents(FAN1_CONF1_REG, verbose = True)

    show_fan_reg_contents(FAN1_CONF3_REG, verbose = True)

    show_fan_reg_contents(FAN1_CURRENT_DUTY_REG, verbose = True)

    show_fan_reg_contents(FAN_CH1_TEMP_REG, verbose = True)     # Temp value for channel1
    show_fan_reg_contents(FAN_CH1_EXTDTEMP_REG, verbose = True) # Extended Temp value for channel1

    show_fan_reg_contents(FAN_CH2_TEMP_REG, verbose = True)     # Temp value for channel2
    show_fan_reg_contents(FAN_CH2_EXTDTEMP_REG, verbose = True) # Extended Temp value for channel2

    input("\n*** 1. Press Enter to continue\n ")

    # FAN_GCONF_REG configuration :
    #-------------------------------

    RunStdby_bit       = 0  # = 0 : Normal mode ; = 1 : Stdby mode (conversion suspended, low power mode)
    POR_bit            = 0  # active high reset : = 0 : no reset ; = 1 : reset
    SMBUS_timeout_bit  = 1  # = 0 : enable timeout ; = 1 : disable Timeout
    temp_ch2_src_bit   = 1  # = 0 : remote_2 src ; = 1 : local sensor
    pwm_freq_range_bit = 0  # = 0 : range from 20Hz to 100Hz ; = 1 : range from 5kHz to 25kHz )

    wr_data = (RunStdby_bit << 7) | (POR_bit << 6) | (SMBUS_timeout_bit << 5) | (temp_ch2_src_bit << 4) | \
              pwm_freq_range_bit << 3

    fan_driver(FAN_GCONF_REG, "WR", wr_data, verbose)

    show_fan_reg_contents(FAN_GCONF_REG, verbose = True)

    input("\n*** 2. Press Enter to force PWM_freq_out = 0x0 (20Hz) :\n ")

    # FAN1_CONF1_REG configuration :
    #--------------------------------

    manual = 1
    automatic = 0
    pwm_mode = manual

    fan1_ch1_ctrl = 0   # use ONLY when pwm_mode = 'automatic'
    fan1_ch2_ctrl = 0   # use ONLY when pwm_mode = 'automatic'

    rpm_range = 0x10    # = 00 : max_rpm_val = 2000 ; = 01 : max_rpm_val = 4000
                        # = 10 : max_rpm_val = 8000 ; = 11 : max_rpm_val = 16000

    DutyCycle_RateOfChange = 0x2   # to control audibility of fan speed changes
                                   # time for fan speed to change from 33% to 100% : 0x2 -> 10s

    wr_data = (pwm_mode << 7) | (DutyCycle_RateOfChange << 4) | (fan1_ch2_ctrl << 3) | (fan1_ch1_ctrl << 2) | rpm_range
    fan_driver(FAN1_CONF1_REG, "WR", wr_data, verbose)

    show_fan_reg_contents(FAN1_CONF1_REG, verbose = True)

    # FAN1_CONF2a_REG and FAN1_CONF2b_REG configuration
    #---------------------------------------------------

    # These registers are used when pwm_mode = 'automatic'

    show_fan_reg_contents(FAN1_CONF2a_REG, verbose = True)
    show_fan_reg_contents(FAN1_CONF2b_REG, verbose = True)

    # FAN1_CONF3_REG configuration
    #------------------------------

    spin_up_en = 1
    THERM_to_full_speed = 0
    Pulse_stretching_en = 1 # for test : must be set to '0' for a 4 wires fan
    PWM_freq_out = 0x0      # 0x0 = 20Hz ; 0x1 = 33.33Hz ; 0x2 = 50Hz ; 0x3 = 100hz  (values when pwm_freq_range_bit = 0)
                            # 0x0 = 5kHz ; 0x1 = 8.33kHz ; 0x2 = 12.5kHz ; 0x3 = 25kHz (values when pwm_freq_range_bit = 1)

    wr_data = (spin_up_en << 7) | (THERM_to_full_speed << 6) | (Pulse_stretching_en) << 5 | PWM_freq_out
    fan_driver(FAN1_CONF3_REG, "WR", wr_data, verbose)

    show_fan_reg_contents(FAN1_CONF3_REG, verbose = True)

    show_fan_reg_contents(FAN1_CURRENT_DUTY_REG, verbose = True)

    show_fan_reg_contents(FAN1_TACH_CNT_REG, verbose = True)

    input("\n Fan1 : Press Enter to force PWM_freq_out = 0x3 (25kHz) : ")

    spin_up_en = 1
    THERM_to_full_speed = 0
    Pulse_stretching_en = 0
    PWM_freq_out = 0x3      # 0x0 = 20Hz ; 0x1 = 33.33Hz ; 0x2 = 50Hz ; 0x3 = 100hz (values when pwm_freq_range_bit = 0)
                            # 0x0 = 5kHz ; 0x1 = 8.33kHz ; 0x2 = 12.5kHz ; 0x3 = 25kHz (values when pwm_freq_range_bit = 1)

    wr_data = (spin_up_en << 7) | (THERM_to_full_speed << 6) | (Pulse_stretching_en) << 5 | PWM_freq_out
    fan_driver(FAN1_CONF3_REG, "WR", wr_data, verbose)

    show_fan_reg_contents(FAN1_CONF3_REG, verbose = True)

    # FAN1_PULSE_MINRPM_REG configuration :
    #---------------------------------------

    min_tach_cnt = 0x1f         # max_value = 0x3f

    pulse_per_revolution = 0x0  # 0x0 = 1 tochometer pulse per revolution ; 0x1 = 2 tochometer pulse per revolution ;
                                # 0x2 = 3 tochometer pulse per revolution ; 0x3 = 4 tochometer pulse per revolution

    wr_data = (pulse_per_revolution << 6) | min_tach_cnt

    fan_driver(FAN1_PULSE_MINRPM_REG, "WR", wr_data, verbose)

    show_fan_reg_contents(FAN1_PULSE_MINRPM_REG, verbose = True)

    # FAN1_TARGET_DUTY_REG Configuration :
    #--------------------------------------

#   wr_data = 0x1e      # duty_cycle = 25% (30/120 where 30 (0x1e) = 1/4 of 120)
#   wr_data = 0x3c      # duty_cycle = 50% (60/120 where 60 (0x3c) = 1/2 of 120)
    wr_data = 0x5a      # duty_cycle = 75% (90/120 where 90 (0x5a) = 3/4 of 120)

    fan_driver(FAN1_TARGET_DUTY_REG, "WR", wr_data, verbose)

    time.sleep(1)

    show_fan_reg_contents(FAN1_CURRENT_DUTY_REG, verbose = True)

    show_fan_reg_contents(FAN1_TACH_CNT_REG, verbose = True)

    input("\n Fan2 : Press Enter to force PWM_freq_out = 0x0 : ")
    print()

    # Fan2 control :
    #****************

    print("\n***********************")
    print(" Fan2 PWM control test")
    print("***********************\n")

    print("*** Initial values")

    # ch2 temp value depends on source selected by temp_Ch2_source
    show_fan_reg_contents(FAN_CH2_TEMP_REG, verbose = True)
    show_fan_reg_contents(FAN_CH2_EXTDTEMP_REG, verbose = True)

    show_fan_reg_contents(FAN2_CONF3_REG, verbose = True)

    data_rd = i2c_parser(device_i2c_bus_nb, device_i2c_addr, FAN2_CONF3_REG, verbose)
    print("\n* test : FAN2_CONF3_REG reg.read (@ addr 0x%x) = 0x%x" %(FAN2_CONF3_REG, data_rd))

    spin_up_en = 1
    THERM_to_full_speed = 0
    Pulse_stretching_en = 1
    PWM_freq_out = 0x0      # 0x3 = 100hz ; 0x2 = 50Hz ; 0x1 = 33.33Hz ; 00 = 20Hz
                            # 0x3 = 25kHz : 0x2 = 12.5kHz ; 0x1 = 8.33kHz ; 0x0 = 5kHz

    wr_data = (spin_up_en << 7) | (THERM_to_full_speed << 6) | (Pulse_stretching_en) << 5 | PWM_freq_out
    fan_driver(FAN2_CONF3_REG, "WR", wr_data, verbose)

    show_fan_reg_contents(FAN2_CONF3_REG, verbose = True)

    rd_data = fan_driver(FAN2_CONF3_REG, "RD", 0x0, verbose)
    print("\n test : FAN2_CONF3_REG reg.readback (@ addr 0x%x) = 0x%x" %(FAN2_CONF3_REG, rd_data))

    input("\n Fan2 : Press Enter to force PWM_freq_out = 0x3 : ")

    spin_up_en = 1
    THERM_to_full_speed = 0
    Pulse_stretching_en = 1
    PWM_freq_out = 0x3      # 0x3 = 100hz ; 0x2 = 50Hz ; 0x1 = 33.33Hz ; 00 = 20Hz
                            # 0x3 = 25kHz : 0x2 = 12.5kHz ; 0x1 = 8.33kHz ; 0x0 = 5kHz

    wr_data = (spin_up_en << 7) | (THERM_to_full_speed << 6) | (Pulse_stretching_en) << 5 | PWM_freq_out
    fan_driver(FAN2_CONF3_REG, "WR", wr_data, verbose)

    show_fan_reg_contents(FAN2_CONF3_REG, verbose = True)

    # Configure DUTY_cycle
    wr_data = 0x1e      # duty_cycle = 25% (30/120 where 30 (0x1e) = 1/4 of 120)
#   wr_data = 0x3c      # duty_cycle = 50% (60/120 where 60 (0x3c) = 1/2 of 120)
#   wr_data = 0x5a      # duty_cycle = 75% (90/120 where 90 (0x5a) = 3/4 of 120)

    fan_driver(FAN2_TARGET_DUTY_REG, "WR", wr_data, verbose)

    time.sleep(1)

    show_fan_reg_contents(FAN2_CURRENT_DUTY_REG, verbose = True)

    return True
#
#=============================================================================================
@DIAG("Backplane reset fans")
def t_obb7000_fan_reset(cmd):
#=============================================================================================

    verbose = True

    print("\n*** FAN_GCONF_REG reg. Initial value")

    show_fan_reg_contents(FAN_GCONF_REG, verbose)

    # FAN_GCONF_REG configuration :
    #-------------------------------

    RunStdby_bit       = 1  # = 0 => Stdby ; = 1 => Normal mode
    POR_bit            = 0  # PowerOnReset (active high reset) : = 0 => no reset ; = 1 => reset
    SMBUS_timeout_bit  = 0  # = 0 : enable timeout ; = 1 : disable Timeout
    temp_ch2_src_bit   = 0  # = 0 => remote_2 src ; = 1 => local sensor
    pwm_freq_range_bit = 1  # = 0 => range from 20Hz to 100Hz ; = 1 => range from 5kHz to 25kHz )

    wr_data = (RunStdby_bit << 7) | (POR_bit << 6) | (SMBUS_timeout_bit << 5) | (temp_ch2_src_bit << 4) | \
               pwm_freq_range_bit << 3

    fan_driver(FAN_GCONF_REG, "WR", wr_data, verbose)

    show_fan_reg_contents(FAN_GCONF_REG, verbose)

    print("*** FAN_GCONF_REG reg. : reset fan registers")

    RunStdby_bit       = 0  # = 0 : Stdby ; = 1 : Normal mode
    POR_bit            = 1  # active high reset : = 0 : no reset ; = 1 : reset
    SMBUS_timeout_bit  = 0  # = 0 : enable timeout ; = 1 : disable Timeout
    temp_ch2_src_bit   = 0  # = 0 : remote_2 src ; = 1 : local sensor
    pwm_freq_range_bit = 0  # = 0 : range from 20Hz to 100Hz ; = 1 : range from 5kHz to 25kHz )

    wr_data = (RunStdby_bit << 7) | (POR_bit << 6) | (SMBUS_timeout_bit << 5) | (temp_ch2_src_bit << 4) | \
               pwm_freq_range_bit << 3

    fan_driver(FAN_GCONF_REG, "WR", wr_data, verbose)

    show_fan_reg_contents(FAN_GCONF_REG, verbose)

    return None
#
#=============================================================================================
@DIAG("Backplane rear panel fans set")
def t_obb7000_fan_set(cmd):
#
# VCC_5V_EN must be set to '1' for fan to run.
# Temp Ch2 source into GCONF reg. must be set to LOCAL
#
#t_obb7000_fan_set RIGHT-PWM-100
#
#=============================================================================================
#
    debug = False

    try:
        (command,consigne) = cmd.split()

        if len(consigne.split('-')) == 2:
            consigne_lgth = 2
            (fan_position, reg_type) = consigne.split('-')
        else:
            consigne_lgth = 3
            (fan_position, reg_type, reg_type_value_str) = consigne.split('-')

        if debug == True:
            print("   command = ", command, " ; consigne = ", consigne)
            print("   fan_position = %s ; reg_type = %s ; fan_pwm_value = %s" %(fan_position, reg_type, reg_type_value_str))

    except:
        print_error("                                                                                        ")
        print_error("   Syntax error : Command must be : t_obb7000_fan_set <consigne>                        ")
        print_error("                                                                                        ")
        print_error("   where <consigne> is : <FAN_POSITION>-<REG_TYPE>-<REG_VALUE>                          ")
        print_error("                                                                                        ")
        print_error("   With                : <FAN_POSITION> = RIGHT|LEFT|ALL                                ")
        print_error("                         <REG_TYPE>  = PWM|PWM_FREQ_RANGE|MAX_RPM|PULSE_MINRPM|THERMLIM ")
        print_error("                         <PWM_VALUE>          = {0 to 255}                              ")
        print_error("                         <PWM_FREQ_RGE_VALUE> = 0 : 20Hz to 100Hz range                 ")
        print_error("                                              = 1 : 5kHz to 25kHz range                 ")
        print_error("                         <MAX_RPM_VALUE>      = {2000, 4000, 8000, 16000}               ")
        print_error("                         <THERMLIM_VALUE>     = from 40 to 70                           ")
        print_error("                         <PULSE_MINRPM_VALUE> = {1, 2, 3, 4}                            ")
        print_error("                                                                                        ")
        return False

    #print_info("# VERSION: 0.0.1")
    time.sleep(0.6)

    error_flag = False

    position_list = ['RIGHT', 'LEFT']

    if fan_position == "RIGHT" or fan_position == "LEFT" or fan_position == "ALL":
        print("   * fan_position is %s" %fan_position)
        if fan_position == "ALL":
            position_to_do_list = ['YES', 'YES']
        elif fan_position == "RIGHT":
            position_to_do_list = ['YES', 'NO']
        else:
            position_to_do_list = ['NO', 'YES']
    else:
        print("   * Error : undefined fan_position : MUST be RIGHT or LEFT or ALL")
        error_flag = True

    if reg_type == "PWM" or reg_type == "PWM_FREQ_RANGE" or reg_type == "MAX_RPM" or reg_type == "PULSE_MINRPM" or\
       reg_type == "THERMLIM":
        print("   * <REG_TYPE> is ", reg_type)
    else:
        print("   * Error : undefined reg_type : must be PWM or PWM_FREQ_RANGE or MAX_RPM or PULSE_MINRPM or THERMLIM")
        error_flag = True

    if reg_type == "PWM":
        if consigne_lgth == 2:
            print_error("   * Error : PWM_VALUE : unknown value : MUST be 0 or 0 < value < 256")
            error_flag = True
        else:
            fan_pwm_value = int(reg_type_value_str)
            if (fan_pwm_value == 0 or (fan_pwm_value > 0 and fan_pwm_value < 256)):
                print("   * fan_pwm_value is %d" %fan_pwm_value)
            else:
                print("   * Error : fan_pwm_value : incorrect value : MUST be 0 or 0 < value < 256")
                error_flag = True

    if reg_type == "PWM_FREQ_RANGE":
            if consigne_lgth == 2:
                print_error("   * Error : PWM_FREQ_RGE_VALUE : unknown value : MUST be 0 or 1")
                error_flag = True
            else:
                fan_pwm_range_value = int(reg_type_value_str)
                if fan_pwm_range_value == 0 or fan_pwm_range_value == 1:
                    print("   * fan_pwm_range_value is %d" %fan_pwm_range_value)
                else:
                    print("   * Error : fan_pwm_range_value : incorrect value : MUST be 0 or 1")
                    error_flag = True

    if reg_type == "MAX_RPM":
        if consigne_lgth == 2:
            print_error("   * Error : MAX_RPM_VALUE : unknown value : MUST be {2000, 4000, 8000, 16000}")
            error_flag = True
        else:
            max_rpm_value_list = [2000, 4000, 8000,  16000]

            max_rpm_value = int(reg_type_value_str)
            if max_rpm_value not in max_rpm_value_list:
                print("\n     * Error : MAX_RPM_VALUE = ", max_rpm_value, "is not a correct value MUST be {2000, 4000, 8000, 16000}\n")
                error_flag = True

    if reg_type == "PULSE_MINRPM":
        if consigne_lgth == 2:
            print_error("   * Error : PULSE_MINRPM_VALUE : unknown value : MUST be {1, 2, 3, 4}")
            error_flag = True
        else:
            pulse_nb_list = [1, 2, 3,  4]

            selected_pulse_nb = int(reg_type_value_str)
            if selected_pulse_nb not in pulse_nb_list:
                print("\n     * Error : PULSE_MINRPM_VALUE = ", selected_pulse_nb, "is not a correct value MUST be {1, 2, 3, 4}\n")
                error_flag = True

    if reg_type == "THERMLIM":
        if consigne_lgth == 2:
            print_error("   * Error : THERMLIM_VALUE : unknown value : MUST be 40 < value < 70")
            error_flag = True
        else:
            therm_limit_value = int(reg_type_value_str)
            if therm_limit_value > 40 and therm_limit_value < 71:
                pass
            else:
                error_flag = True

    if error_flag:
        return False

    device_i2c_bus_nb = "7"
    device_i2c_addr   = "0x2e"

    # To enable VCC_5V :
    #====================

    psu_enable = 1
    print("\nenable VCC_5V")
    os_base_cmd = "echo "+ str(psu_enable) +" > "+ get_gpio_file("I2CEXP_EXPCA_PWR_EN")
    #print("os_base_cmd is ", os_base_cmd)

    (os.system(os_base_cmd))

    verbose = True

    show_flag = True

    if 0 == 1:

        print("\n***====================")
        print("*** Common registers :")
        print("***=====================")

        if show_flag:
            show_fan_reg_contents(READ_DEVICE_ID_REG, verbose)
            show_fan_reg_contents(READ_MANUFACTURER_ID_REG, verbose)
            show_fan_reg_contents(READ_DEVICE_REV_REG, verbose)

            show_fan_reg_contents(FAN_STATUS_REG, verbose)
            show_fan_reg_contents(FAN_MASK_REG, verbose)
            show_fan_reg_contents(FAN_GCONF_REG, verbose)
        else:
            loc_verbose = False
            device_id_rd  = fan_driver(READ_DEVICE_ID_REG, "RD", 0x0, loc_verbose)
            mfg_id_rd     = fan_driver(READ_MANUFACTURER_ID_REG, "RD", 0x0, loc_verbose)
            device_rev_rd = fan_driver(READ_DEVICE_REV_REG, "RD", 0x0, loc_verbose)

            fan_status_rd = fan_driver(FAN_STATUS_REG, "RD", 0x0, loc_verbose)
            fan_mask_rd   = fan_driver(FAN_MASK_REG, "RD", 0x0, loc_verbose)
            fan_gconf_rd  = fan_driver(FAN_GCONF_REG, "RD", 0x0, loc_verbose)

    if reg_type == "THERMLIM":

        print("\n**********************************")
        print("*** Force new THERMLIM value :")
        print("***********************************\n")

        fan_driver(FAN_CH2_THERMLIM_REG, "WR", therm_limit_value, verbose = False)

        show_fan_reg_contents(FAN_CH2_THERMLIM_REG, verbose = True)

    elif reg_type == "PWM_FREQ_RANGE":

        print("\n**********************************")
        print("*** Force new PWM_FREQ_RANGE value :")
        print("***********************************\n")

        # FAN_GCONF_REG configuration :
        #-------------------------------

        RunStdby_bit       = 0  # = 0 => Normal mode ; = 1 => Stdby mode (conversion suspended, low power mode)
        POR_bit            = 0  # active high reset : = 0 : no reset ; = 1 : reset
        SMBUS_timeout_bit  = 1  # = 0 : enable timeout ; = 1 : disable Timeout
        temp_ch2_src_bit   = 1  # = 0 => remote_2 src ; = 1 => local sensor

        pwm_freq_range_bit = fan_pwm_range_value  # = 0 => range from 20Hz to 100Hz ; = 1 => range from 5kHz to 25kHz )

        wr_data = (RunStdby_bit << 7) | (POR_bit << 6) | (SMBUS_timeout_bit << 5) | (temp_ch2_src_bit << 4) | \
                pwm_freq_range_bit << 3

        fan_driver(FAN_GCONF_REG, "WR", wr_data, verbose)

        show_fan_reg_contents(FAN_GCONF_REG, verbose = True)

    else:
        i = 0
        while i < len(position_list):

            if position_to_do_list[i] == "YES":

                if position_list[i] == 'RIGHT':

                    #***********************
                    # Fan1 (J8 connector) :
                    #***********************

                    FAN_NUM_STR = "FAN1"

                    CONF1_REG        = FAN1_CONF1_REG
                    CONF2a_REG       = FAN1_CONF2a_REG
                    CONF2b_REG       = FAN1_CONF2b_REG
                    CONF3_REG        = FAN1_CONF3_REG
                    CURRENT_DUTY_REG = FAN1_CURRENT_DUTY_REG    # Read Only
                    TARGET_DUTY_REG  = FAN1_TARGET_DUTY_REG     # Write Only
                    TACH_CNT_REG     = FAN1_TACH_CNT_REG
                    PULSE_MINRPM_REG = FAN1_PULSE_MINRPM_REG
                else:

                    #***********************
                    # Fan2 (J9 connector) :
                    #***********************

                    FAN_NUM_STR = "FAN2"

                    CONF1_REG        = FAN2_CONF1_REG
                    CONF2a_REG       = FAN2_CONF2a_REG
                    CONF2b_REG       = FAN2_CONF2b_REG
                    CONF3_REG        = FAN2_CONF3_REG
                    CURRENT_DUTY_REG = FAN2_CURRENT_DUTY_REG
                    TARGET_DUTY_REG  = FAN2_TARGET_DUTY_REG     # Write Only
                    TACH_CNT_REG     = FAN2_TACH_CNT_REG
                    PULSE_MINRPM_REG = FAN2_PULSE_MINRPM_REG

                print("\n***===========================")
                print("*** %s registers readback :" %FAN_NUM_STR)
                print("***===========================")

                show_fan_reg_contents(CONF1_REG, verbose)
                #show_fan_reg_contents(CONF2a_REG, verbose)
                #show_fan_reg_contents(CONF2b_REG, verbose)
                show_fan_reg_contents(CONF3_REG, verbose)
                show_fan_reg_contents(PULSE_MINRPM_REG, verbose)
                show_fan_reg_contents(CURRENT_DUTY_REG, verbose)
                show_fan_reg_contents(TACH_CNT_REG, verbose)

                # Channel1 T° monitor is unused (for remote_diode1)

                #show_fan_reg_contents(FAN_CH1_START_TACH_CNT_REG, verbose)
                #show_fan_reg_contents(FAN_CH1_MIN_START_TEMP_REG, verbose)
                #show_fan_reg_contents(FAN_CH1_TEMP_REG, verbose)
                #show_fan_reg_contents(FAN_CH1_EXTDTEMP_REG, verbose)
                #show_fan_reg_contents(FAN_CH1_ALERTLIM_REG, verbose)
                #show_fan_reg_contents(FAN_CH1_OTLIM_REG, verbose)
                #show_fan_reg_contents(FAN_CH1_THERMLIM_REG, verbose)

                if 0 == 1:
                    print("\n***===================================")
                    print("*** Channel2 T° monitor reg. readback :")
                    print("***=====================================")

                    show_fan_reg_contents(FAN_CH2_TEMP_REG, verbose)
                    show_fan_reg_contents(FAN_CH2_EXTDTEMP_REG, verbose)
                    show_fan_reg_contents(FAN_CH2_ALERTLIM_REG, verbose)
                    show_fan_reg_contents(FAN_CH2_OTLIM_REG, verbose)
                    show_fan_reg_contents(FAN_CH2_THERMLIM_REG, verbose)
                    show_fan_reg_contents(FAN_CH2_START_TACH_CNT_REG, verbose)
                    show_fan_reg_contents(FAN_CH2_MIN_START_TEMP_REG, verbose)

                if reg_type == "MAX_RPM":

                    print("\n******************************")
                    print("*** Force new MAX RPM value :")
                    print("******************************\n")

                    # From MAX6639 table6 (Fan_maximum_rpm_value) and table3 (Internal_clock_freq):

                    fan_cfg1_rd = i2c_parser(device_i2c_bus_nb, device_i2c_addr, CONF1_REG, verbose = False)
                    print("* %s_CONF1_REG reg.read (@ addr 0x%x) = 0x%x" %(FAN_NUM_STR, CONF1_REG, fan_cfg1_rd))

                    fan_rpm_rang_ind = fan_cfg1_rd & 0x3
                    if fan_rpm_rang_ind == 0:
                        Fan_maximum_rpm_value = 2000
                        Internal_clock_freq   = 1000  # Hz
                    elif fan_rpm_rang_ind == 1:
                        Fan_maximum_rpm_value = 4000
                        Internal_clock_freq   = 2000  # Hz
                    elif fan_rpm_rang_ind == 2:
                        Fan_maximum_rpm_value = 8000
                        Internal_clock_freq   = 4000  # Hz
                    else:
                        Fan_maximum_rpm_value = 16000
                        Internal_clock_freq   = 8000 # Hz

                    print("\nCurrent MAX_RPM_VALUE = %d :" %Fan_maximum_rpm_value)
                    print("      => max_rpm_range indice = %d" %fan_rpm_rang_ind)
                    print("      => Internal_clock_freq value = %d (Hz)" %Internal_clock_freq)

                    if max_rpm_value == 2000:
                        Fan_max_rpm_value_ind = 0x0
                        Internal_clock_freq   = 1000  # Hz
                    elif max_rpm_value == 4000:
                        Fan_max_rpm_value_ind = 0x1
                        Internal_clock_freq   = 2000  # Hz
                    elif max_rpm_value == 8000:
                        Fan_max_rpm_value_ind = 0x2
                        Internal_clock_freq   = 4000  # Hz
                    else:
                        Fan_max_rpm_value_ind = 0x3
                        Internal_clock_freq   = 8000 # Hz

                    print("\nNew MAX_RPM_VALUE = %d :" %max_rpm_value)
                    print("      => max_rpm_range indice = %d" %Fan_max_rpm_value_ind)
                    print("      => Internal_clock_freq value = %d (Hz)" %Internal_clock_freq)

                    fan_cfg1_wr = (fan_cfg1_rd & 0xfc) | Fan_max_rpm_value_ind

                    fan_driver(CONF1_REG, "WR", fan_cfg1_wr, verbose = False)

                    show_fan_reg_contents(CONF1_REG, verbose)

                    show_fan_reg_contents(CURRENT_DUTY_REG, verbose)
                    show_fan_reg_contents(TACH_CNT_REG, verbose)

                elif reg_type == "PWM":

                    print("\n******************************")
                    print("*** Force new PWM value = %d :" %fan_pwm_value)
                    print("******************************\n")

                    # PWM_MODE must be set to '1' :

                    fan_cfg1_rd = i2c_parser(device_i2c_bus_nb, device_i2c_addr, CONF1_REG, verbose = False)
                    print("* %s_CONF1_REG reg.read (@ addr 0x%x) = 0x%x" %(FAN_NUM_STR, CONF1_REG, fan_cfg1_rd))

                    conf1_reg_value = fan_cfg1_rd | 0x80
                    fan_driver(CONF1_REG, "WR", conf1_reg_value, verbose = False)

                    show_fan_reg_contents(CONF1_REG, verbose = True)

                    # FAN<n>_TARGET_DUTY_REG (WR Only) Configuration :
                    #---------------------------------------------------

                    #   duty_reg = 0x1e      # duty_cycle = 25% (30/120 where 30 (0x1e) = 1/4 of 120)
                    #   duty_reg = 0x3c      # duty_cycle = 50% (60/120 where 60 (0x3c) = 1/2 of 120)
                    #   duty_reg = 0x5a      # duty_cycle = 75% (90/120 where 90 (0x5a) = 3/4 of 120)

                    duty_cycle_percent = int((fan_pwm_value * 100)/255)     # en %
                    if duty_cycle_percent != 0:
                        duty_reg_value = 120 / ((1/duty_cycle_percent)*100)
                    else:
                        duty_reg_value = 0

                    duty_reg_int = int(duty_reg_value)
                    print("\n* duty_cycle_percent = %d => duty_reg_value = %3.2f => duty_reg = 0x%x" %(duty_cycle_percent, duty_reg_value, duty_reg_int))

                    fan_driver(TARGET_DUTY_REG, "WR", duty_reg_int, verbose = False)

                    print("\nWait for 10s")
                    time.sleep(10)

                    show_fan_reg_contents(CURRENT_DUTY_REG, verbose)
                    show_fan_reg_contents(TACH_CNT_REG, verbose)

                else:

                    print("\n*******************************************************")
                    print("*** Force new TACHOMETER PULSES PER REVOLUTION  value :")
                    print("*******************************************************")

                    show_fan_reg_contents(PULSE_MINRPM_REG, verbose)

                    fan_pulse_minprm_rd = i2c_parser(device_i2c_bus_nb, device_i2c_addr, PULSE_MINRPM_REG, verbose = False)
                    print("* Current %s_PULSE_MINRPM_REG reg.read (@ addr 0x%x)" %(FAN_NUM_STR, PULSE_MINRPM_REG))
                    #print("* Current %s_PULSE_MINRPM_REG reg.read (@ addr 0x%x) = 0x%x" %(FAN_NUM_STR, PULSE_MINRPM_REG, fan_pulse_minprm_rd)

                    print("\nselected_pulse_nb to program : %d" %(selected_pulse_nb))

                    if selected_pulse_nb == 1:
                        pulse_nb_per_revolution_ind = 0x0
                    elif selected_pulse_nb == 2:
                        pulse_nb_per_revolution_ind = 0x1
                    elif selected_pulse_nb == 3:
                        pulse_nb_per_revolution_ind = 0x2
                    else:
                        pulse_nb_per_revolution_ind = 0x3

                    wr_data = (fan_pulse_minprm_rd & 0x3f) | (pulse_nb_per_revolution_ind << 6)
                    fan_driver(PULSE_MINRPM_REG, "WR", wr_data, verbose)

                    show_fan_reg_contents(PULSE_MINRPM_REG, verbose = True)

                    show_fan_reg_contents(CURRENT_DUTY_REG, verbose)
                    show_fan_reg_contents(TACH_CNT_REG, verbose)

            i += 1

    return None


#
#=============================================================================================
@DIAG("Backplane rear panel fans stop")
def t_obb7000_fan_stop(cmd):
#
# VCC_5V_EN must be set to '1' for fan to run.
# Temp Ch2 source into GCONF reg. must be set to LOCAL
#
# t_obb7000_fan_stop
#
#=============================================================================================
    print("Disable PWN-FAN driver")
    os.system("rmmod pwm-fan")

    position_list = ['RIGHT', 'LEFT']
    position_to_do_list = ['YES', 'YES']
    fan_pwm_value = 0

    device_i2c_bus_nb = "7"
    device_i2c_addr   = "0x2e"

    # To enable VCC_5V :
    #====================

    psu_enable = 1
    print("\nenable VCC_5V")
    os_base_cmd = "echo "+ str(psu_enable) +" > "+ get_gpio_file("I2CEXP_EXPCA_PWR_EN")
    #print("os_base_cmd is ", os_base_cmd)

    (os.system(os_base_cmd))

    i = 0
    while i < len(position_list):

        if position_list[i] == 'RIGHT':

            #***********************
            # Fan1 (J8 connector) :
            #***********************

            FAN_NUM_STR = "FAN1"

            CONF1_REG        = FAN1_CONF1_REG
            CONF2a_REG       = FAN1_CONF2a_REG
            CONF2b_REG       = FAN1_CONF2b_REG
            CONF3_REG        = FAN1_CONF3_REG
            CURRENT_DUTY_REG = FAN1_CURRENT_DUTY_REG    # Read Only
            TARGET_DUTY_REG  = FAN1_TARGET_DUTY_REG     # Write Only
            TACH_CNT_REG     = FAN1_TACH_CNT_REG
            PULSE_MINRPM_REG = FAN1_PULSE_MINRPM_REG
        else:

            #***********************
            # Fan2 (J9 connector) :
            #***********************

            FAN_NUM_STR = "FAN2"

            CONF1_REG        = FAN2_CONF1_REG
            CONF2a_REG       = FAN2_CONF2a_REG
            CONF2b_REG       = FAN2_CONF2b_REG
            CONF3_REG        = FAN2_CONF3_REG
            CURRENT_DUTY_REG = FAN2_CURRENT_DUTY_REG
            TARGET_DUTY_REG  = FAN2_TARGET_DUTY_REG     # Write Only
            TACH_CNT_REG     = FAN2_TACH_CNT_REG
            PULSE_MINRPM_REG = FAN2_PULSE_MINRPM_REG


        print("\n******************************")
        print("*** Force new PWM value = 0 **")
        print("******************************\n")

        # PWM_MODE must be set to '1' :

        fan_cfg1_rd = i2c_parser(device_i2c_bus_nb, device_i2c_addr, CONF1_REG, verbose = False)
        print("* %s_CONF1_REG reg.read (@ addr 0x%x) = 0x%x" %(FAN_NUM_STR, CONF1_REG, fan_cfg1_rd))

        conf1_reg_value = fan_cfg1_rd | 0x80
        fan_driver(CONF1_REG, "WR", conf1_reg_value, verbose = False)

        show_fan_reg_contents(CONF1_REG, verbose = True)

        # FAN<n>_TARGET_DUTY_REG (WR Only) Configuration :
        #---------------------------------------------------

        #   duty_reg = 0x1e      # duty_cycle = 25% (30/120 where 30 (0x1e) = 1/4 of 120)
        #   duty_reg = 0x3c      # duty_cycle = 50% (60/120 where 60 (0x3c) = 1/2 of 120)
        #   duty_reg = 0x5a      # duty_cycle = 75% (90/120 where 90 (0x5a) = 3/4 of 120)

        duty_cycle_percent = 0
        duty_reg_value = 0

        duty_reg_int = int(duty_reg_value)
        print("\n* duty_cycle_percent = %d => duty_reg_value = %3.2f => duty_reg = 0x%x" %(duty_cycle_percent, duty_reg_value, duty_reg_int))

        fan_driver(TARGET_DUTY_REG, "WR", duty_reg_int, verbose = False)

        i += 1

    return None

#=============================================================================================
@DIAG("Backplane rear panel fans check")
def t_obb7000_fan_check(cmd):
#
# FAN_POSITION = RIGHT : use FAN1 (J8 connector)
# FAN_POSITION = LEFT  : use FAN2 (J9 connector)
#
# The MAX6639 has 2 Temperature channels :
#
#   > channel 1 is for remote diode 1 ONLY
#   > channel 2 is for remote diode 2 or local sensor (selectable
#     by bit 4 in the global configuration register
#     For OBB board, (OTH Backplane Board), channel2 ONLY is used,
#     in local sensor mode.
#
#=============================================================================================

    debug = False
    verbose = True

    try:
        (command,consigne) = cmd.split()

        if debug == True:
            print("   command = ", command, " ; consigne = ", consigne)
            print("   fan_position = %s" %consigne)

    except:
        print_error("                                                                       ")
        print_error("   Syntax error : Command must be : t_obb7000_fan_check <FAN_POSITION> ")
        print_error("                                                                       ")
        print_error("   With         : <FAN_POSITION> = RIGHT|LEFT|ALL                      ")
        print_error("                                                                       ")
        return False

    #print_info("# VERSION: 0.0.1")
    time.sleep(0.6)

    error_flag = False

    position_list = ['RIGHT', 'LEFT']

    if consigne == "RIGHT" or consigne == "LEFT" or consigne == "ALL":
        fan_position =  consigne
        print("   * fan_position is %s" %fan_position)
        if fan_position == "ALL":
            position_to_do_list = ['YES', 'YES']
        elif fan_position == "RIGHT":
            position_to_do_list = ['YES', 'NO']
        else:
            position_to_do_list = ['NO', 'YES']
    else:
        print()
        print_error("   * Error : undefined fan_position : MUST be RIGHT or LEFT or ALL")
        error_flag = True

    if error_flag:
        return False

    print("\n***====================")
    print("*** Common registers :")
    print("***=====================")

    show_fan_reg_contents(READ_DEVICE_ID_REG, verbose)
    show_fan_reg_contents(READ_MANUFACTURER_ID_REG, verbose)
    show_fan_reg_contents(READ_DEVICE_REV_REG, verbose)

    show_fan_reg_contents(FAN_STATUS_REG, verbose)
    show_fan_reg_contents(FAN_MASK_REG, verbose)
    show_fan_reg_contents(FAN_GCONF_REG, verbose)

    i = 0
    while i < len(position_list):

        if position_to_do_list[i] == "YES":

            if position_list[i] == 'RIGHT':

                #***********************
                # Fan1 (J8 connector) :
                #***********************

                FAN_NUM_STR = "FAN1"

                CONF1_REG        = FAN1_CONF1_REG
                CONF2a_REG       = FAN1_CONF2a_REG
                CONF2b_REG       = FAN1_CONF2b_REG
                CONF3_REG        = FAN1_CONF3_REG
                CURRENT_DUTY_REG = FAN1_CURRENT_DUTY_REG    # Read Only
                TARGET_DUTY_REG  = FAN1_TARGET_DUTY_REG     # Write Only
                TACH_CNT_REG     = FAN1_TACH_CNT_REG
                PULSE_MINRPM_REG = FAN1_PULSE_MINRPM_REG
            else:

                #***********************
                # Fan2 (J9 connector) :
                #***********************

                FAN_NUM_STR = "FAN2"

                CONF1_REG        = FAN2_CONF1_REG
                CONF2a_REG       = FAN2_CONF2a_REG
                CONF2b_REG       = FAN2_CONF2b_REG
                CONF3_REG        = FAN2_CONF3_REG
                CURRENT_DUTY_REG = FAN2_CURRENT_DUTY_REG
                TACH_CNT_REG     = FAN2_TACH_CNT_REG
                PULSE_MINRPM_REG = FAN2_PULSE_MINRPM_REG

            print("\n***===========================")
            print("*** %s registers readback :" %FAN_NUM_STR)
            print("***===========================")

            show_fan_reg_contents(CONF1_REG, verbose)
            show_fan_reg_contents(CONF2a_REG, verbose)
            show_fan_reg_contents(CONF2b_REG, verbose)
            show_fan_reg_contents(CONF3_REG, verbose)
            #
            duty_read_value = fan_driver(CURRENT_DUTY_REG, "RD", '0', verbose = False)
            duty_percent = int((duty_read_value * 100) / 120)
            print("  => %s pwm_duty_cycle in percent = %d" %(FAN_NUM_STR, duty_percent))
            #
            show_fan_reg_contents(TACH_CNT_REG, verbose)

            RPM_value = fan_speed_calculation(position_list[i], verbose = True)
            print("\nRPM_value = %d" %int(RPM_value))
            #
            show_fan_reg_contents(PULSE_MINRPM_REG, verbose)

        i += 1

    print("\n***===================================")
    print("*** Channel2 T° monitor reg. readback :")
    print("***=====================================")

    show_fan_reg_contents(FAN_CH2_TEMP_REG, verbose)
    show_fan_reg_contents(FAN_CH2_EXTDTEMP_REG, verbose)
    show_fan_reg_contents(FAN_CH2_ALERTLIM_REG, verbose)
    show_fan_reg_contents(FAN_CH2_OTLIM_REG, verbose)
    show_fan_reg_contents(FAN_CH2_THERMLIM_REG, verbose)
    show_fan_reg_contents(FAN_CH2_START_TACH_CNT_REG, verbose)
    show_fan_reg_contents(FAN_CH2_MIN_START_TEMP_REG, verbose)

    return None

#=============================================================================================
@DIAG("Backplane rear panel fans init")
def t_obb7000_fan_init(cmd):
#
# FAN_POSITION = RIGHT : use FAN1 (J8 connector)
# FAN_POSITION = LEFT  : use FAN2 (J9 connector)
#
# The MAX6639 has 2 Temperature channels :
#
#   > channel 1 is for remote diode 1 ONLY
#   > channel 2 is for remote diode 2 or local sensor (selectable
#     by bit 4 in the global configuration register
#     For OBB board, (OTH Backplane Board), channel2 ONLY is used,
#     in local sensor mode.
#
#=============================================================================================

    verbose = True

    try:
        (command,consigne) = cmd.split()

        (fan_model, fan_position) = consigne.split('-')

        print("   command = ", command, " ; consigne = ", consigne)
        print("   fan_model = %s ; fan_position = %s" %(fan_model, fan_position))

    except:
        print_error("                                                                                  ")
        print_error("   Syntax error : Command must be : t_obb7000_fan_init <FAN_MODEL>-<FAN_POSITION> ")
        print_error("                                                                                  ")
        print_error("   With         : <FAN_MODEL> = SUNON|SNOWFAN                                     ")
        print_error("                : <FAN_POSITION> = RIGHT|LEFT|ALL                                 ")
        print_error("                                                                                  ")
        return False

    time.sleep(0.6)

    error_flag = False

    if fan_model == "SUNON" or fan_model == "SNOWFAN":
        print("   * fan_model is %s" %fan_model)
    else:
        print("   * Error : undefined fan_model : MUST be SUNON or SNOWFAN")
        error_flag = True

    position_list = ['RIGHT', 'LEFT']

    if fan_position == "RIGHT" or fan_position == "LEFT" or fan_position == "ALL":
        print("   * fan_position is %s" %fan_position)
        if fan_position == "ALL":
            position_to_do_list = ['YES', 'YES']
        elif fan_position == "RIGHT":
            position_to_do_list = ['YES', 'NO']
        else:
            position_to_do_list = ['NO', 'YES']
    else:
        print("   * Error : undefined fan_position : MUST be RIGHT or LEFT or ALL")
        error_flag = True

    if error_flag:
        return False

    # FAN_GCONF_REG configuration :
    #-------------------------------

    RunStdby_bit       = 0  # = 0 => Normal mode ; = 1 => Stdby mode (conversion suspended, low power mode)
    POR_bit            = 0  # active high reset : = 0 : no reset ; = 1 : reset
    SMBUS_timeout_bit  = 1  # = 0 : enable timeout ; = 1 : disable Timeout
    temp_ch2_src_bit   = 1  # = 0 => remote_2 src ; = 1 => local sensor
    if fan_model == "SNOWFAN":
        pwm_freq_range_bit = 1  # = 0 => range from 20Hz to 100Hz ; = 1 => range from 5kHz to 25kHz )
    else:
        pwm_freq_range_bit = 1

    wr_data = (RunStdby_bit << 7) | (POR_bit << 6) | (SMBUS_timeout_bit << 5) | (temp_ch2_src_bit << 4) | \
            pwm_freq_range_bit << 3

    fan_driver(FAN_GCONF_REG, "WR", wr_data, verbose)

    show_fan_reg_contents(FAN_GCONF_REG, verbose = True)

    i = 0
    while i < len(position_list):

        if position_to_do_list[i] == "YES":

            if position_list[i] == 'RIGHT':

                #***********************
                # Fan1 (J8 connector) :
                #***********************

                FAN_NUM_STR = "FAN1"

                CONF1_REG  = FAN1_CONF1_REG
                CONF2a_REG = FAN1_CONF2a_REG
                CONF2b_REG = FAN1_CONF2b_REG
                CONF3_REG  = FAN1_CONF3_REG
                CURRENT_DUTY_REG = FAN1_CURRENT_DUTY_REG    # Read Only
                TARGET_DUTY_REG  = FAN1_TARGET_DUTY_REG     # Write Only
                TACH_CNT_REG = FAN1_TACH_CNT_REG
                PULSE_MINRPM_REG = FAN1_PULSE_MINRPM_REG

            else:

                #***********************
                # Fan2 (J9 connector) :
                #***********************

                FAN_NUM_STR = "FAN2"

                CONF1_REG  = FAN2_CONF1_REG
                CONF2a_REG = FAN2_CONF2a_REG
                CONF2b_REG = FAN2_CONF2b_REG
                CONF3_REG  = FAN2_CONF3_REG

                CURRENT_DUTY_REG = FAN2_CURRENT_DUTY_REG    # Read Only
                TARGET_DUTY_REG  = FAN2_TARGET_DUTY_REG     # Write Only
                TACH_CNT_REG = FAN2_TACH_CNT_REG
                PULSE_MINRPM_REG = FAN2_PULSE_MINRPM_REG

            print("\n============================")
            print("Configure %s :" %FAN_NUM_STR)
            print("=============================\n")

            # FAN<n>_CONF1_REG configuration :
            #--------------------------------

            pwm_duty_cycle_mode = 1
            rpm_ctrl_mode = 0
            pwm_mode = pwm_duty_cycle_mode  # pwm_mode : = 0 => fan into RPM control mode ; this mode is automatic
                                            #                   or manual, depending on fan_ch2_ctrl and fan_ch1_ctrl bits
                                            #                   as shown below
                                            #            = 1 => fan into manual PWM duty-cycle control mode:
                                            #                   write duty_cycle into TARGET_DUTY_REG reg.

            fan_ch1_ctrl = 0   # use ONLY when pwm_mode = RPM control mode
            fan_ch2_ctrl = 0   # use ONLY when pwm_mode = RPM control mode
                            # if fan_ch2_ctrl,fan_ch1_ctrl = b'00 => Manual RPM control mode defined by target tach count reg.
                            # if fan_ch2_ctrl,fan_ch1_ctrl = b'01 => channel1 ctrl
                            # if fan_ch2_ctrl,fan_ch1_ctrl = b'10 => channel2 ctrl
                            # if fan_ch2_ctrl,fan_ch1_ctrl = b'11 => higher of both channels

            rpm_range = 0x3     # = 00 : max_rpm_val = 2000 ; = 01 : max_rpm_val = 4000
                                # = 10 : max_rpm_val = 8000 ; = 11 : max_rpm_val = 16000

            DutyCycle_RateOfChange = 0x2    # to control audibility of fan speed changes
                                            # time for fan speed to change from 33% to 100% : 0x2 -> 10s

            wr_data = (pwm_mode << 7) | (DutyCycle_RateOfChange << 4) | (fan_ch2_ctrl << 3) | (fan_ch1_ctrl << 2) | rpm_range
            fan_driver(CONF1_REG, "WR", wr_data, verbose)

            show_fan_reg_contents(CONF1_REG, verbose = True)

            # FAN<n>_CONF3_REG configuration :
            #--------------------------------

            spin_up_en = 1
            THERM_to_full_speed = 0
            Pulse_stretching_en = 1
            PWM_freq_out = 0x3      # 0x3 = 100hz ; 0x2 = 50Hz ; 0x1 = 33.33Hz ; 00 = 20Hz
                                    # 0x3 = 25kHz : 0x2 = 12.5kHz ; 0x1 = 8.33kHz ; 0x0 = 5kHz

            wr_data = (spin_up_en << 7) | (THERM_to_full_speed << 6) | (Pulse_stretching_en) << 5 | PWM_freq_out
            fan_driver(CONF3_REG, "WR", wr_data, verbose)

            show_fan_reg_contents(CONF3_REG, verbose = True)

            # FAN<n>_PULSE_MINRPM_REG reg. :
            #--------------------------------

            selected_fan_pulse_nb = 4

            if selected_fan_pulse_nb == 1:
                pulse_nb_per_revolution_ind = 0x0
            elif selected_fan_pulse_nb == 2:
                pulse_nb_per_revolution_ind = 0x1
            elif selected_fan_pulse_nb == 3:
                pulse_nb_per_revolution_ind = 0x2
            else:
                pulse_nb_per_revolution_ind = 0x3

            wr_data = pulse_nb_per_revolution_ind << 6
            fan_driver(PULSE_MINRPM_REG, "WR", wr_data, verbose)

            show_fan_reg_contents(PULSE_MINRPM_REG, verbose = True)

            # FAN<n>_TARGET_DUTY_REG (WR Only) Configuration :
            #---------------------------------------------------

            if 0 == 1:
                duty_cycle_val = 25 # en %
                duty_reg_value = 120 / ((1/duty_cycle_val)*100)
                duty_reg = int(duty_reg_value)
                print("\nduty_cycle = %d => duty_reg_value = %f => duty_reg = 0x%x" %(duty_cycle_val, duty_reg_value, duty_reg))

                #   duty_reg = 0x1e      # duty_cycle = 25% (30/120 where 30 (0x1e) = 1/4 of 120)
                #   duty_reg = 0x3c      # duty_cycle = 50% (60/120 where 60 (0x3c) = 1/2 of 120)
                #   duty_reg = 0x5a      # duty_cycle = 75% (90/120 where 90 (0x5a) = 3/4 of 120)

                fan_driver(TARGET_DUTY_REG, "WR", duty_reg, verbose)

                time.sleep(1)

            show_fan_reg_contents(CURRENT_DUTY_REG, verbose = True)

            # FAN<n> TACH_CNT_REG Configuration : Only used when (fan_ch2_ctrl, fan_ch1_ctrl) different from 0
            #--------------------------------------

            show_fan_reg_contents(TACH_CNT_REG, verbose = True)

        i += 1

    return None

#=============================================================================================
def fan_speed_calculation(fan_position, verbose):
#=============================================================================================

    device_i2c_bus_nb = "7"
    device_i2c_addr   = "0x2e"

    if fan_position == "RIGHT":
        FAN_NUM_STR      = "FAN1"
        CONF1_REG        = FAN1_CONF1_REG
        CURRENT_DUTY_REG = FAN1_CURRENT_DUTY_REG
        PULSE_MINRPM_REG = FAN1_PULSE_MINRPM_REG
        TACH_CNT_REG     = FAN1_TACH_CNT_REG
    else:
        FAN_NUM_STR      = "FAN2"
        CONF1_REG        = FAN2_CONF1_REG
        CURRENT_DUTY_REG = FAN2_CURRENT_DUTY_REG
        PULSE_MINRPM_REG = FAN2_PULSE_MINRPM_REG
        TACH_CNT_REG     = FAN2_TACH_CNT_REG

    if verbose:
        print("\n===============================")
        print(" %s Speed calculation (RPM) :" %FAN_NUM_STR)
        print("================================")

    show_fan_reg_contents(CONF1_REG, verbose)

    fan_cfg1_rd = i2c_parser(device_i2c_bus_nb, device_i2c_addr, CONF1_REG, verbose)
    if verbose:
        print("* %s_CONF1_REG reg.read (@ addr 0x%x) = 0x%x" %(FAN_NUM_STR, CONF1_REG, fan_cfg1_rd))

    RPM_range_indice = fan_cfg1_rd & 0x3
    if RPM_range_indice == 0:
        freq_value = 1000
    elif RPM_range_indice == 1:
        freq_value = 2000
    elif RPM_range_indice == 2:
        freq_value = 4000
    else:
        freq_value = 8000

    if verbose:
        print("\n=> RPM_range_indice = 0x%x => internal freq_value = %d\n" %(RPM_range_indice, freq_value))

    fan_pulserpm_rd = i2c_parser(device_i2c_bus_nb, device_i2c_addr, PULSE_MINRPM_REG, verbose = False)

    if verbose:
        print(" %s_PULSE_MINRPM_REG reg.read (@ addr 0x%x) = 0x%x" %(FAN_NUM_STR, PULSE_MINRPM_REG, fan_pulserpm_rd))

    pulse_per_revolution = (fan_pulserpm_rd & 0xc0) >> 6

    if pulse_per_revolution == 0:
        selected_pulse_nb = 1
    elif pulse_per_revolution == 1:
        selected_pulse_nb = 2
    elif pulse_per_revolution == 2:
        selected_pulse_nb = 3
    else:
        selected_pulse_nb = 4

    actual_pulse_nb = 4
    pulse_ratio = selected_pulse_nb/actual_pulse_nb
    if verbose:
        print("\n=> selected_pulse_nb = 0x%x ; actual_pulse_nb = %d => Pulse_ratio = %f\n" %(selected_pulse_nb, actual_pulse_nb, pulse_ratio))

    fan_tachcnt_rd = i2c_parser(device_i2c_bus_nb, device_i2c_addr, TACH_CNT_REG, verbose = False)
    if verbose:
        print("* %s_TACH_CNT_REG reg.read (@ addr 0x%x) = 0x%x = %d" %(FAN_NUM_STR, TACH_CNT_REG, fan_tachcnt_rd, fan_tachcnt_rd))

    RPM_value = (freq_value/fan_tachcnt_rd) * 60 * pulse_ratio

    return int(RPM_value)

#=============================================================================================
@DIAG("Backplane rear panel fans speed measure")
def t_obb7000_fan_speed(cmd):
#=============================================================================================

    try:
        if len(cmd.split()) == 3:
            (command, consigne, verbose_flag) = cmd.split()
        else:
            verbose_flag = "None"
            (command, consigne) = cmd.split()

        fan_position = consigne

        print("   command = ", command, " ; consigne = ", consigne)
        print("   fan_position = %s" %(fan_position))

    except:
        print_error("                                                                                  ")
        print_error("   Syntax error : Cmd must be : t_obb7000_fan_speed <FAN_POSITION> <verbose_flag> ")
        print_error("                                                                                  ")
        print_error("   With           <FAN_POSITION> = RIGHT|LEFT|ALL                                 ")
        print_error("                                                                                  ")
        print_error("                  <verbose_flag> = verbose ONLY                                   ")
        print_error("                  Note : <verbose_flag> is optional                               ")
        print_error("                                                                                  ")
        return False

    time.sleep(0.6)

    error_flag = False

    if verbose_flag == "verbose":
        verbose = True
    elif verbose_flag == "None":
        verbose = False
    else:
        print("** WARNING : verbose_flag = %s : uncorrect value" %verbose_flag)
        print("   => verbose = False\n")
        verbose = False

    position_list = ['RIGHT', 'LEFT']

    if fan_position == "RIGHT" or fan_position == "LEFT" or fan_position == "ALL":
        if fan_position == "ALL":
            position_to_do_list = ['YES', 'YES']
        elif fan_position == "RIGHT":
            position_to_do_list = ['YES', 'NO']
        else:
            position_to_do_list = ['NO', 'YES']
    else:
        print()
        print("   * Error : undefined fan_position : MUST be RIGHT or LEFT or ALL")
        error_flag = True

    if error_flag:
        return False

    device_i2c_bus_nb = "7"
    device_i2c_addr   = "0x2e"

    i = 0
    while i < len(position_list):

        if position_to_do_list[i] == "YES":

            if position_list[i] == 'RIGHT':
                FAN_NUM_STR = "FAN1"
                CONF1_REG        = FAN1_CONF1_REG
                CURRENT_DUTY_REG = FAN1_CURRENT_DUTY_REG
                PULSE_MINRPM_REG = FAN1_PULSE_MINRPM_REG
                TACH_CNT_REG     = FAN1_TACH_CNT_REG
            else:
                FAN_NUM_STR = "FAN2"
                CONF1_REG        = FAN2_CONF1_REG
                CURRENT_DUTY_REG = FAN2_CURRENT_DUTY_REG
                PULSE_MINRPM_REG = FAN2_PULSE_MINRPM_REG
                TACH_CNT_REG     = FAN2_TACH_CNT_REG

            fan_duty_rd = i2c_parser(device_i2c_bus_nb, device_i2c_addr, CURRENT_DUTY_REG, verbose)
            print("* %s_CURRENT_DUTY_REG reg.read (@ addr 0x%x) = 0x%x = %d" %(FAN_NUM_STR, CURRENT_DUTY_REG, fan_duty_rd, fan_duty_rd))

            fan_duty_rd_percent = int(fan_duty_rd * 100)/120

            print("\n==============================")
            print(" %s Duty cycle programmed : %d percent (CURRENT_DUTY_REG reg. = 0x%x = %d)" %(FAN_NUM_STR, \
                    fan_duty_rd_percent, fan_duty_rd, fan_duty_rd))
            print("==============================")

            RPM_value = fan_speed_calculation(position_list[i], verbose)
            print("\nRPM_value = %d" %int(RPM_value))

        i += 1

    return None

#
#=============================================================================================
#
@DIAG("Backplane fan temp reg. check")
def t_obb7000_fan_temp_check(cmd):
#
# VCC_5V_EN must be set to '1' for fan to run.
# Temp Ch2 source into GCONF reg. must be set to LOCAL
#
# When fan driver is monted :
#
# cat /sys/class/hwmon/hwmon2/temp2_max
# cat /sys/class/hwmon/hwmon2/temp2_crit
# cat /sys/class/hwmon/hwmon2/temp2_emergency
# echo 20000 > /sys/class/hwmon/hwmon2/temp2_max   -- = 20°C
#
# to mount (bind) fan driver :
# root@fth-7000-00053:~# echo "7-002e" > /sys/bus/i2c/drivers/max6639/bind
#
# to unmount (unbind) fan driver :
# root@fth-7000-00053:~# echo "7-002e" > /sys/bus/i2c/drivers/max6639/unbind
#
#=============================================================================================
#
    verbose = True

    error_flag = False

    device_i2c_bus_nb = "7"
    device_i2c_addr   = "0x2e"

    # To enable VCC_5V :
    #====================

    psu_enable = 1
    print("\nenable VCC_5V")
    os_base_cmd = "echo "+ str(psu_enable) +" > "+ get_gpio_file("I2CEXP_EXPCA_PWR_EN")
    #print("os_base_cmd is ", os_base_cmd)

    (os.system(os_base_cmd))

    print("\n***===================================")
    print("*** Channel2 T° monitor reg. readback :")
    print("***=====================================")

    show_fan_reg_contents(FAN_CH2_TEMP_REG, verbose)
    show_fan_reg_contents(FAN_CH2_EXTDTEMP_REG, verbose)

    show_fan_reg_contents(FAN_CH2_THERMLIM_REG, verbose)
    print("  Note : This THERMLIM value correspond to Max6639 driver temp2_max value")
    show_fan_reg_contents(FAN_CH2_ALERTLIM_REG, verbose)
    print("  Note : This ALERTLIM value correspond to Max6639 driver temp2_crit value")
    show_fan_reg_contents(FAN_CH2_OTLIM_REG, verbose)
    print("  Note : This OTLIM value correspond to Max6639 driver temp2_emergency value")

    show_fan_reg_contents(FAN_CH2_MIN_START_TEMP_REG, verbose)
    show_fan_reg_contents(FAN_CH2_START_TACH_CNT_REG, verbose)

    return None

#
#=============================================================================================
@DIAG("Disable backplane rear panel fans' driver")
def t_obb7000_fan_driver_disable(cmd):
#
# In order to be able to 'play' with fans here,
# the fans' driver needs first to be disabled
# This function takes care of it
#
#=============================================================================================
#
	os.system("rmmod pwm-fan")

	return None

#
#=============================================================================================
@DIAG("Enable backplane rear panel fans' driver")
def t_obb7000_fan_driver_enable(cmd):
#
# In order to be able to 'play' with fans here,
# the fans' driver needs first to be disabled
# It's better to enable it afterwards
# This function takes care of it
#
#=============================================================================================
#
	os.system("modprobe pwm-fan")

	return None

#
#=============================================================================================
@DIAG("Backplane rear panel fans test")
def t_obb7000_fan_test(cmd):
#
# VCC_5V_EN must be set to '1' for fan to run.
# Temp Ch2 source into GCONF reg. must be set to LOCAL
#
# t_obb7000_fan_test RIGHT
#
#=============================================================================================
#
    try:
        if len(cmd.split()) == 3:
            (command, consigne, verbose_flag) = cmd.split()
        else:
            verbose_flag = "None"
            (command, consigne) = cmd.split()

        fan_position = consigne

        print("  command = ", command, " ; consigne = ", consigne)
        print("  fan_position = %s\n" %(fan_position))

    except:
        print_error("   Syntax error : Cmd must be : t_obb7000_fan_test <FAN_POSITION> <verbose_flag>")
        print_error("                                                                                ")
        print_error("   With           <FAN_POSITION> = RIGHT|LEFT|ALL                               ")
        print_error("                                                                                ")
        print_error("                  <verbose_flag> = verbose ONLY                                 ")
        print_error("                  Note : <verbose_flag> is optional                             ")
        print_error("                                                                                ")
        return False


    error_flag = False

    if verbose_flag == "verbose":
        verbose = True
    elif verbose_flag == "None":
        verbose = False
    else:
        print("** WARNING : verbose_flag = %s : uncorrect value" %verbose_flag)
        print("   => verbose = False\n")
        verbose = False

    position_list = ['RIGHT', 'LEFT']

    if fan_position == "RIGHT" or fan_position == "LEFT" or fan_position == "ALL":
        if fan_position == "ALL":
            position_to_do_list = ['YES', 'YES']
        elif fan_position == "RIGHT":
            position_to_do_list = ['YES', 'NO']
        else:
            position_to_do_list = ['NO', 'YES']
    else:
        print("*** Error : undefined fan_position : MUST be RIGHT or LEFT or ALL")
        error_flag = True

    if error_flag:
        return False

    device_i2c_bus_nb = "7"
    device_i2c_addr   = "0x2e"

    # To enable VCC_5V :
    #====================

    psu_enable = 1
    os_base_cmd = "echo "+ str(psu_enable) +" > "+ get_gpio_file("I2CEXP_EXPCA_PWR_EN")
    if verbose:
        print("\n* enable VCC_5V power supply")
        print("  os_base_cmd is ", os_base_cmd)
    (os.system(os_base_cmd))

    time.sleep(0.5)

    err_nb = 0

    i = 0
    while i < len(position_list):

        if position_to_do_list[i] == "YES":

            if position_list[i] == 'RIGHT':
                FAN_NUM_STR = "FAN1"
                CONF1_REG        = FAN1_CONF1_REG
                CURRENT_DUTY_REG = FAN1_CURRENT_DUTY_REG
                PULSE_MINRPM_REG = FAN1_PULSE_MINRPM_REG
                TACH_CNT_REG     = FAN1_TACH_CNT_REG
                TARGET_DUTY_REG  = FAN1_TARGET_DUTY_REG     # Write Only
            else:
                FAN_NUM_STR = "FAN2"
                CONF1_REG        = FAN2_CONF1_REG
                CURRENT_DUTY_REG = FAN2_CURRENT_DUTY_REG
                PULSE_MINRPM_REG = FAN2_PULSE_MINRPM_REG
                TACH_CNT_REG     = FAN2_TACH_CNT_REG
                TARGET_DUTY_REG  = FAN2_TARGET_DUTY_REG     # Write Only

            loop_i = 0
            loop_max = 2

            while loop_i <= loop_max:

                # Program the PWM_value

                if loop_i == 0:
                    fan_pwm_value = 64
                    RPM_val_min = 100
                    RPM_val_max = 2000
                #elif loop_i == 1:
                    #fan_pwm_value = 127
                    #RPM_val_min = 1500
                    #RPM_val_max = 3500
                elif loop_i == 1:
                    fan_pwm_value = 255
                    RPM_val_max = 7000
                else:
                    fan_pwm_value = 0

                # PWM_MODE must be set to '1' :

                fan_cfg1_rd = i2c_parser(device_i2c_bus_nb, device_i2c_addr, CONF1_REG, verbose)
                if verbose:
                    print("* %s_CONF1_REG reg.read (@ addr 0x%x) = 0x%x" %(FAN_NUM_STR, CONF1_REG, fan_cfg1_rd))

                conf1_reg_value = fan_cfg1_rd | 0x80
                fan_driver(CONF1_REG, "WR", conf1_reg_value, verbose)

                show_fan_reg_contents(CONF1_REG, verbose)

                if verbose:
                    print("\n******************************")
                    print("*** Force PWM value = %d :" %fan_pwm_value)
                    print("******************************\n")

                # FAN<n>_TARGET_DUTY_REG (WR Only) Configuration :
                #---------------------------------------------------

                #   duty_reg = 0x1e      # duty_cycle = 25% (30/120 where 30 (0x1e) = 1/4 of 120)
                #   duty_reg = 0x3c      # duty_cycle = 50% (60/120 where 60 (0x3c) = 1/2 of 120)
                #   duty_reg = 0x5a      # duty_cycle = 75% (90/120 where 90 (0x5a) = 3/4 of 120)

                duty_cycle_percent = int((fan_pwm_value * 100)/255)     # en %
                if duty_cycle_percent != 0:
                    duty_reg_value = 120 / ((1/duty_cycle_percent)*100)
                else:
                    duty_reg_value = 0

                duty_reg_int = int(duty_reg_value)

                if verbose:
                    print("* duty_cycle_percent = %d => duty_reg_value = %3.2f => duty_reg = 0x%x" %(duty_cycle_percent, duty_reg_value, duty_reg_int))

                fan_driver(TARGET_DUTY_REG, "WR", duty_reg_int, verbose)

                if loop_i < loop_max:
                    print("* Wait for 7s")
                    #time.sleep(10)
                    time.sleep(7)

                show_fan_reg_contents(CURRENT_DUTY_REG, verbose)
                show_fan_reg_contents(TACH_CNT_REG, verbose)

                fan_duty_rd = i2c_parser(device_i2c_bus_nb, device_i2c_addr, CURRENT_DUTY_REG, verbose)
                if verbose:
                    print("* %s_CURRENT_DUTY_REG reg.read (@ addr 0x%x) = 0x%x = %d" %(FAN_NUM_STR, CURRENT_DUTY_REG, fan_duty_rd, fan_duty_rd))

                fan_duty_rd_percent = int(fan_duty_rd * 100)/120

                if verbose:
                    print("\n==============================")
                    print(" %s Duty cycle programmed : %d percent (CURRENT_DUTY_REG reg. = 0x%x = %d)" %(FAN_NUM_STR, \
                            fan_duty_rd_percent, fan_duty_rd, fan_duty_rd))
                    print("==============================")

                RPM_value = fan_speed_calculation(position_list[i], verbose)

                if verbose:
                    print("\n==============================")
                    print(" RPM_value =  %d" %(RPM_value))
                    print("================================")

                if loop_i < loop_max:
                    if RPM_value > RPM_val_min and RPM_value < RPM_val_max:
                        print_ok("%s fan : PWM value = %d (DutyCycle = %d percent) : RPM_value = %d : PASS" \
                                            %(position_list[i], fan_pwm_value, fan_duty_rd_percent, RPM_value))
                    else:
                        print_error("%s fan : PWM value = %d (DutyCycle = %s percent) : RPM_value = %d : FAIL" \
                                            %(position_list[i], fan_pwm_value, fan_duty_rd_percent, RPM_value))
                        err_nb += 1

                loop_i += 1

        i += 1

    if err_nb > 0:
        return False
    else:
        return True

#=============================================================================================
def opt_sw_cmde_set(cmde_code, channel_num, verbose):
#=============================================================================================

    i2c_bus_nb = "7"
    i2c_dev_addr = "0x50"

    if cmde_code == 0x1:
        tfer_lgth = 5
        payload_lgth = 1
    else:
        channel_num = 0
        tfer_lgth = 4
        payload_lgth = 0

    msg_status   = 0
    checksum = cmde_code + payload_lgth + msg_status + channel_num

    i2c_cmde0 = "i2ctransfer -y "+i2c_bus_nb+" w"+str(tfer_lgth)+"@"+i2c_dev_addr+" "+str(cmde_code)+" "+str(payload_lgth)+" "+str(msg_status)

    if cmde_code == 0x1:
        i2c_cmde = i2c_cmde0 +" "+str(channel_num)+" "+str(checksum)
    else:
        i2c_cmde = i2c_cmde0 +" "+str(checksum)

    if verbose:
        print("i2ctransfer cmde is :", i2c_cmde)
    (os.system(i2c_cmde))

    return None

#=============================================================================================
def opt_sw_get_channel(verbose):
#=============================================================================================

    i2c_bus_nb = "7"
    i2c_dev_addr = "0x50"

    if verbose:
        print("Launch GET_CHANNEL cmde")

    cmde_code = 0x2
    opt_sw_cmde_set(cmde_code, 0x0, verbose)

    tfer_lgth = 10
    i2c_cmde = "i2ctransfer -y "+i2c_bus_nb+" r"+str(tfer_lgth)+"@"+i2c_dev_addr

    if verbose:
        print("i2ctransfer cmde is :", i2c_cmde)

    FileName = "/usr/share/pydiag/oth/get_channel_tmp.txt"

    os_cmde = i2c_cmde+ " > "+FileName
    (os.system(os_cmde))

    data_read_tab = []
    with open(FileName,'r') as tmpfile:
        for line in tmpfile.readlines():
            if verbose:
                print("line is", line)

    tmpfile.close()

    data_read_tab = line.split(" ")

    if verbose:
        print("data_read_tab[0] = %s" %data_read_tab[0])
        print("data_read_tab[1] = %s" %data_read_tab[1])
        print("data_read_tab[3] = %s" %data_read_tab[3])

    os_cmde = "rm -f "+FileName
    (os.system(os_cmde))

    return int(data_read_tab[3], base=16)
#
#=============================================================================================
def opt_sw_get_info(verbose):
#=============================================================================================

    i2c_bus_nb = "7"
    i2c_dev_addr = "0x50"

    if verbose:
        print("* Launch GET_MODULE_INFO cmde\n")

    cmde_code = 0x8
    opt_sw_cmde_set(cmde_code, 0x0, verbose)

    tfer_lgth = 45
    i2c_cmde = "i2ctransfer -y "+i2c_bus_nb+" r"+str(tfer_lgth)+"@"+i2c_dev_addr

    if verbose:
        print("i2ctransfer cmde is :", i2c_cmde)

    FileName = "/usr/share/pydiag/oth/getmoduleinfo_tmp.txt"

    os_cmde = i2c_cmde+ " > "+FileName
    (os.system(os_cmde))

    data_read_tab = []
    with open(FileName,'r') as tmpfile:
        for line in tmpfile.readlines():
            if verbose:
                print("\n  line is", line)

    tmpfile.close()

    data_read_tab = line.split(" ")

    data_read_tab_char = []

    i = 0
    for elt in data_read_tab:
        if i >= 3:
            char_i = chr(int(data_read_tab[i], base=16))
            data_read_tab_char.append(char_i)
        i+= 1

    if verbose:
        print("  data_read_tab_char is", data_read_tab_char, "\n")

    switch_info_tab = []
    var = []
    j = 0

    for elt in data_read_tab_char:
        #print("elt is ", elt)

        if elt != ";":
            var.append(elt)
        else:
            if j == 0:
                mfr_ver_str = ''
                k = 0
                while k < len(var):
                    mfr_ver_str += var[k]
                    k += 1
                if verbose:
                    print("  mfg_str is", mfr_ver_str)
                switch_info_tab.append(mfr_ver_str)
            elif j == 1:
                sw_ver_str = ''
                k = 0
                while k < len(var):
                    sw_ver_str += var[k]
                    k += 1
                if verbose:
                    print("  sw_ver_str is", sw_ver_str)
                switch_info_tab.append(sw_ver_str)
            elif j == 2:
                hw_ver_str = ''
                k = 0
                while k < len(var):
                    hw_ver_str += var[k]
                    k += 1
                if verbose:
                    print("  hw_ver_str is", hw_ver_str)
                switch_info_tab.append(hw_ver_str)
            elif j == 3:
                pn_val_str = ''
                k = 0
                while k < len(var):
                    pn_val_str += var[k]
                    k += 1
                if verbose:
                    print("  pn_val_str is", pn_val_str)
                switch_info_tab.append(pn_val_str)
            elif j == 4:
                sn_val_str = ''
                k = 0
                while k < len(var):
                    sn_val_str += var[k]
                    k += 1
                if verbose:
                    print("  sn_val_str is", sn_val_str)
                switch_info_tab.append(sn_val_str)

            var = []
            j += 1

    mfg_date_str = ''
    k = 0
    while k < len(var):
        mfg_date_str += var[k]
        k += 1

    if verbose:
        print("  mfg_date_str is", mfg_date_str, "\n")

    switch_info_tab.append(mfg_date_str)

    os_cmde = "rm -f "+FileName
    (os.system(os_cmde))

    return switch_info_tab
#
#=============================================================================================
@DIAG("Internal Optical switch test")
def t_obb7000_optical_sw_test(cmd):
#
# gpio480 = U49-1 (P00) = I2CEXP_EXPCA_PWR_EN output
# gpio481 = U49-2 (P01) = I2CEXP_EXPCB_PWR_EN output
# gpio482 = U49-3 (P02) = EXPCA_I2CEXP_TYPE_PCIE_B input
# gpio483 = U49-4 (P03) = EXPCB_I2CEXP_TYPE_PCIE_B input
#
# switch_info_list = ["Oplink", "1.0.0.2", "1.0", "1835070086", "F8251319", "202"]
#
# t_obb7000_optical_sw_test MFR_NAME-Oplink|SW_REV-1.0.0.2|HW_REV-1.0|PN-1835070086|SN-F8251319|MFG_DATE-202|CHAN_NUM-3
#
#=============================================================================================
#
    debug   = False

    err_nb = 0

    try:
        if len(cmd.split()) == 3:
            (command, consigne, verbose_flag) = cmd.split()
        else:
            verbose_flag = "None"
            (command,consigne) = cmd.split()

    except:
        print_error("                                                                                       ")
        print_error("   Syntax error : Cmd must be : t_obb7000_optical_sw_test <consigne> <verbose_flag>    ")
        print_error("                                                                                       ")
        print_error("   where <consigne> is : <INFO_LIST>   = INFO_ELT1|INFO_ELT2|...|INFO_ELT6|CHANNEL_NUM ")
        print_error("                                                                                       ")
        print_error("                         <INFO_ELT1>   = MFR_NAME-<Elt1Value>                          ")
        print_error("                         <INFO_ELT2>   = SW_REV-<Elt2Value>                            ")
        print_error("                         <INFO_ELT3>   = HW_REV-<Elt3Value>                            ")
        print_error("                         <INFO_ELT4>   = PN-<Elt4Value>                                ")
        print_error("                         <INFO_ELT5>   = SN-<Elt5Value>                                ")
        print_error("                         <INFO_ELT6>   = MFG_DATE-<Elt6Value>                          ")
        print_error("                                                                                       ")
        print_error("                         <CHANNEL_NUM> = CHAN_NUM-<ChanValue>                          ")
        print_error("                                                                                       ")
        print_error("   Ex : t_obb7000_optical_sw_test MFR_NAME-Oplink|PN-1835070086|CHAN_NUM-5             ")
        print_error("                                                                                       ")
        return False

    # Parameters validation

    if verbose_flag == "verbose":
        verbose = True
    else:
        verbose = False

    info_elt_type_name = ["MFR_NAME", "SW_REV", "HW_REV", "PN", "SN", "MFG_DATE", "CHAN_NUM"]
    info_elt_value     = ["NONE", "NONE", "NONE", "NONE", "NONE", "NONE", "NONE"]

    param_info_elt_list = []
    param_info_elt_list = consigne.split('|')

    if debug:
        print("param_info_elt_list = ", param_info_elt_list)

    info_elt_tab = []
    for elt in enumerate (param_info_elt_list):
        if debug:
            print("elt = %s => elt[1] = %s" %(elt, elt[1]))
        info_elt_tab.append(elt[1])

    param_info_elt_type = []
    param_info_elt_value = []
    i = 0
    for elt in enumerate (info_elt_tab):
        (info_type, info_value) = info_elt_tab[i].split('-')
        param_info_elt_type.append(info_type)
        param_info_elt_value.append(info_value)

        if debug:
            print("info_elt_tab[%d] = %s" %(i, info_elt_tab[i]))
            print("param_info_elt_type[%d] = %s ; param_info_elt_value[%d] = %s" \
                %(i, param_info_elt_type[i], i, param_info_elt_value[i]))
        i += 1

    i = 0
    err_num = 0
    for elt in enumerate (param_info_elt_type):
        match_ok = False

        for elt_1 in enumerate (info_elt_type_name):
            if elt[1] == elt_1[1]:
                if debug:
                    print("i = %d : %s match %s" %(i, elt[1], elt_1[1]))
                match_ok = True

        if match_ok == False:
            print("*** ERROR : param_info_elt_type = %s is not a correct parameter" %param_info_elt_type[i])
            err_num += 1

        i += 1

    if err_num > 0:
        return False

    i = 0
    for elt in enumerate (info_elt_type_name):
        j = 0
        for elt_1 in enumerate (param_info_elt_type):
            if elt[1] == elt_1[1]:
                info_elt_value[i] = param_info_elt_value[j]
            j += 1
        i += 1

    if debug:
        i = 0
        for elt in enumerate (info_elt_type_name):
            print("info_elt_type_name[%d] = %s ; info_elt_value[%d] = %s" \
                   %(i, info_elt_type_name[i], i, info_elt_value[i]))
            i += 1

    # Set VDD_5V on
    os_base_cmd = "echo "+ str(SetOn) +" > "+ get_gpio_file("I2CEXP_EXPCA_PWR_EN")
    if verbose:
        print("os_base_cmd is ", os_base_cmd)
    (os.system(os_base_cmd))

    gpio_nb = gpio_VDD_5V_OPT_SW_en
    bpl_gpio_set(gpio_nb, SetOn)

    # Optical switch reset is active low ; then release reset
    gpio_nb = gpio_OPT_OPT_RSTn
    bpl_gpio_set(gpio_nb, SetOn)

    time.sleep(1)

    cmde_code = 0x1

    channel_num_str = info_elt_value[6]
    if channel_num_str == "NONE":
        channel_num = 0x3
    else:
        channel_num = int(channel_num_str)

    print("\n* Launch SET_CHANNEL cmde with channel_num = %d" %channel_num)
    opt_sw_cmde_set(cmde_code, channel_num, verbose)

    time.sleep(1)

    channel_rd = opt_sw_get_channel(verbose)

    if channel_rd == channel_num:
        print_ok("      > channel_rd = 0x%x ; exp_data = 0x%x : PASS" %(channel_rd, channel_num))
    else:
        print_error("       > channel_rd = 0x%x ; exp_data = 0x%x : FAIL" %(channel_rd, channel_num))
        err_nb += 1

    print("\n* Get switch info :")

    switch_info_tab = opt_sw_get_info(verbose)

    i = 0
    while i < len(switch_info_tab):
        if switch_info_tab[i] == info_elt_value[i]:
            msg = "PASS"
            print_ok("     > switch_info_tab[ %d] = %s : expected : %s : %s"\
                      %(i, switch_info_tab[i], info_elt_value[i], msg))
        else:
            if info_elt_value[i] == "NONE":
                print("     > switch_info_tab[ %d] = %s : expected : %s"\
                      %(i, switch_info_tab[i], info_elt_value[i]))
            else:
                msg = "FAIL"
                print_error("     > switch_info_tab[ %d] = %s : expected : %s : %s"\
                        %(i, switch_info_tab[i], info_elt_value[i], msg))
                err_nb += 1

        i += 1

    if err_nb == 0:
        return True
    else:
        return False
#
#=============================================================================================
@DIAG("RS485 link debug")
def t_obb7000_rs485_dbg(cmd):
#=============================================================================================
#
    verbose = False

    # Set VDD_5V on
    os_base_cmd = "echo "+ str(SetOn) +" > "+ get_gpio_file("I2CEXP_EXPCA_PWR_EN")
    if verbose:
        print("os_base_cmd is ", os_base_cmd)
    (os.system(os_base_cmd))

    # set On +5V_RS485 and +12V_RS485

    gpio_nb = gpio_VDD_RS485_en
    bpl_gpio_set(gpio_nb, SetOn)

    # Release FT232L resetn pin:

    gpio_nb = gpio_FT232L_RSTn
    bpl_gpio_set(gpio_nb, SetOn)

    just_for_test = 0
    if just_for_test == 1:
        for _ in range(10):
            print("I don't care about index")

    time.sleep(2)

    rs485_device = "/dev/ttyUSB0"

    if not os.path.exists(rs485_device, ):
        print_error("# RS485 not detected")
    else:
        print_ok("# RS485 detected")

    ser = serial.Serial()
    ser.port = rs485_device

    ser.baudrate = 2400
    ser.bytesize = serial.EIGHTBITS  # number of bits per bytes
    ser.parity = serial.PARITY_NONE  # set parity check: no parity
    ser.stopbits = serial.STOPBITS_ONE  # number of stop bits
    # ser.timeout = None          #block read
    ser.timeout = 1  # non-block read
    # ser.timeout = 2              #timeout block read
    ser.xonxoff = False  # disable software flow control
    ser.rtscts = False  # disable hardware (RTS/CTS) flow control
    ser.dsrdtr = False  # disable hardware (DSR/DTR) flow control
    ser.writeTimeout = 2  # timeout for write

    try:
        ser.open()
        print("ok to open %s serial port" %ser.port)
    except:
        print("error open %s serial port " %ser.port)
        return

    test1 = False
    if test1:
        print("\nThis debug test need a scope : timebase = 40us")

        input("\n Press Enter to transmit c (0x63): ")
        ser.write(b"c")

        input("\n Press Enter to transmit d (0x64): ")
        ser.write(b"d")

        input("\n Press Enter to transmit e (0x65): ")
        ser.write(b"e")

        input("\n Press Enter to transmit g (0x67): ")
        ser.write(b"g")

        input("\n Press Enter to transmit o (0x6f): ")
        ser.write(b"o")

    test2 = False
    if test2:
        print("\nThis debug test need a scope : timebase = 40us")

        input("\n Press Enter to transmit 0xa5 : ")
        ser.write(b'\xa5')

        input("\n Press Enter to transmit 0x5a : ")
        ser.write(b'\x5a')

        input("\n Press Enter to transmit 0x81 : ")
        ser.write(b'\x81')

    test3 = False
    if test3 == True:
        print("\nThis debug test need a scope : timebase = 40us")

        input("\n Press Enter to transmit 0x81 0x01 0x00 0x00 0x05 0x00 0x20 0x3 0x01 0x01 0x01 0x49 0xc0: ")
        ser.write(b'\x81\x01\x00\x00\x05\x00\x20\x03\x01\x01\x01\x49\xc0')
        print("")

        i = 0
        for _ in range(1, 3):
            buffer_size = 4
            buffer = ser.read(buffer_size)
            buffer_lgth = len(buffer)
            print("%d : buffer (lgth = %d" %(i,buffer_lgth),") is", buffer)
            i+= 1

    test4 = True
    if test4 == True:
        print("\nSend : idn?\n")

        retry = 0

        while retry <= 1:

            ser.write(b'\x81\x01\x00\x00\x02\x00\x01\x00\x6a\xdc')

            buffer_size = 200
            buffer = ser.read(buffer_size)
            buffer_lgth = len(buffer)

            verbose = False
            if verbose == True:
                print("buffer ( lgth = %d" %buffer_lgth, ") is ", buffer, "---- end of buffer\n")
                if (buffer_lgth > 3):
                    print("buf : ", "_", buffer[0], "_", buffer[1], "_", buffer[2], "_", buffer[3])

            if buffer_lgth == 0:
                retry += 1
            else:
                retry = 2
                if buffer[0] == 129 and buffer[1] == 0 and buffer[2] == 1 and buffer[3] == 1:
                    return True
                else:
                    return False

    test5 = False
    if test5:
        input("\n Press Enter to transmit m (0x6f): ")
        ser.write(b"m")

        input("\n Press Enter to transmit 'mm' (0x6d 0x6d) : ")
        ser.write(b"mm")

        #ser.write(b"mmc")
        #ser.write(b"mmc ")
        #ser.write(b"mmc d")
        #ser.write(b"mmc dev")

        input("\n Press Enter to transmit 'mmc dev 1' (0x6d 0x6d 0x6c) : ")
        ser.write(b"mmc dev 1")

        input("\n Press Enter to transmit 'mmc dev 1\r' (0x6d 0x6d 0x6c 0x20 0x64 0x65 0x76 0x20 0x31 0x?) : ")
        ser.write(b"mmc dev 1\r")

        input("\n Press Enter to transmit 'mmc dev 1\r' (0x6d 0x6d 0x6c 0x20 0x64 0x65 0x76 0x20 0x31 0x? 0x?) : ")
        ser.write(b"mmc dev 1\r\n")

    return None

#
#=============================================================================================
@DIAG("RS485 link test")
def t_obb7000_rs485_test(cmd):
#=============================================================================================
#
    try:
        if len(cmd.split()) == 1:
            verbose_flag = "None"
        elif len(cmd.split()) == 2:
            (command, verbose_flag) = cmd.split()
        else:
            (command, consigne) = cmd.split()

    except:
        print_error("   Syntax error : Command must be : t_obb7000_rs485_test <verbose_flag>         ")
        print_error("   Note : <verbose_flag> is optional : When exist, <verbose_flag> = verbose ONLY")
        print_error("")
        return False

    if verbose_flag == "verbose":
        print("\n** Note : verbose_flag = %s" %verbose_flag)
        print("   => verbose = True\n")
        verbose = True
    elif verbose_flag == "None":
        verbose = False
    else:
        print("\n** WARNING : verbose_flag = %s : uncorrect value" %verbose_flag)
        print("   => verbose = False\n")
        verbose = False

    # Set VDD_5V on

    os_base_cmd = "echo "+ str(SetOn) +" > "+ get_gpio_file("I2CEXP_EXPCA_PWR_EN")
    if verbose:
        print("* Set VDD_5V power supply ON :")
        print("  os_base_cmd is ", os_base_cmd, "\n")
    (os.system(os_base_cmd))

    # set On +5V_RS485 and +12V_RS485

    if verbose:
        print("* Set 5V_RS485 and 12V_RS485 power supplies ON :")

    gpio_nb = gpio_VDD_RS485_en
    bpl_gpio_set(gpio_nb, SetOn)

    # Release FT232L resetn pin:

    if verbose:
        print("* Release FT232L device resetn pin")

    gpio_nb = gpio_FT232L_RSTn
    bpl_gpio_set(gpio_nb, SetOn)

    # Let's wait a little for the USB link to be detected by Linux
    # 1 second seems enough but just to be sure, wait a little bit more
    if verbose:
        print("* Wait for the FT232L to boot up and Linux to detect it")

    time.sleep(1.5)

    rs485_device = "/dev/ttyUSB0"

    if not os.path.exists(rs485_device, ):
        print_error("# RS485 not detected")
    else:
        print_ok("# RS485 detected")

    ser = serial.Serial()
    ser.port = rs485_device

    ser.baudrate = 2400
    ser.bytesize = serial.EIGHTBITS  # number of bits per bytes
    ser.parity = serial.PARITY_NONE  # set parity check: no parity
    ser.stopbits = serial.STOPBITS_ONE  # number of stop bits
    # ser.timeout = None          #block read
    ser.timeout = 1  # non-block read
    # ser.timeout = 2              #timeout block read
    ser.xonxoff = False  # disable software flow control
    ser.rtscts = False  # disable hardware (RTS/CTS) flow control
    ser.dsrdtr = False  # disable hardware (DSR/DTR) flow control
    ser.writeTimeout = 2  # timeout for write

    try:
        ser.open()
        print_ok("ok to open %s serial port" %ser.port)
    except:
        print_error("error open %s serial port " %ser.port)
        return

    # Begin with flushing all input/output buffers
    ser.reset_output_buffer()
    ser.reset_input_buffer()

    print("\n* Send <idn?> command :\n")

    retry = 0

    while retry <= 1:

        ser.write(b'\x81\x01\x00\x00\x02\x00\x01\x00\x6a\xdc')

        time.sleep(1)

        buffer_size = 200
        buffer = ser.read(buffer_size)
        buffer_lgth = len(buffer)

        if verbose:
            print("buffer read ( lgth = %d" %buffer_lgth, ") is ", buffer, "---- end of buffer")
            if (buffer_lgth > 3):
                print("buf : ", "_", buffer[0], "_", buffer[1], "_", buffer[2], "_", buffer[3])

        if buffer_lgth == 0:
            retry += 1
            if retry == 2:
                print_error("> idn Response length = 0 : Cable not connected ?" )
                return False
        else:
            retry = 2
            if buffer[0] == 129 and buffer[1] == 0 and buffer[2] == 1 and buffer[3] == 1:
                print_ok("idn Response : PASS" )
                return True
            else:
                print_error("idn Response : FAIL" )
                return False

#******************************************************************************************************************
# Puma stuff
#******************************************************************************************************************

#******************************************************
def spi_master_transfer(readNwrite, address, wr_data):
#******************************************************

    debug_flag = True

    if readNwrite == 1:
        print("readNwrite = Read")
        header = 0xf0
    else:
        print("readNwrite = Write")
        header = 0xe0

    print("address = 0x%x" %address)
    print("wr_data = 0x%x" %wr_data)

    # header trfer :
    #================

    glu_reg_base_addr = get_glu_base_addr()

    print("\n** Header : set OSB SPI Master SPI_TRANSMIT value = 0x%x" % header)
    reg_write(glu_reg_base_addr + REG_OSB_SPI_TRANSMIT, (header * 65536))

    if debug_flag:
        header_value = get_reg_value(glu_reg_base_addr + REG_OSB_SPI_TRANSMIT)
        print("            => OSB SPI Master SPI_TRANSMIT reg. read value = 0x%x" % header_value)

    time.sleep(0.5)

    mod_spi_sel16 = 0x0
    mod_spi_cpol  = 0x0
    mod_spi_cpha  = 0x0
    mod_spi_freq  = 0x12

    mod_spi_start = 0x1
    spi_ctrl = (mod_spi_freq * 256) | (mod_spi_cpha * 8) | (mod_spi_cpol * 4) | (mod_spi_sel16 *2) | mod_spi_start

    if debug_flag:
        print("            Launch SPI transfer with OSB SPI Master SPI_CTRL write value = 0x%x" % spi_ctrl)
    reg_write(glu_reg_base_addr + REG_OSB_SPI_CTRL, spi_ctrl)

    # reg_addr trfer :
    #==================

    if debug_flag:
        input("\nAddress transfer : Enter")
        print("")

    reg_addr_value = address * 2

    print("** Register Address : Set OSB SPI Master SPI_TRANSMIT value = 0x%x" % reg_addr_value)
    reg_write(glu_reg_base_addr + REG_OSB_SPI_TRANSMIT, ( reg_addr_value * 65536))

    if debug_flag:
        addr_value = get_reg_value(glu_reg_base_addr + REG_OSB_SPI_TRANSMIT)
        print("                   => OSB SPI Master SPI_TRANSMIT reg. read value = 0x%x" % addr_value)

    mod_spi_start = 0x1
    spi_ctrl = (mod_spi_freq * 256) | (mod_spi_cpha * 8) | (mod_spi_cpol * 4) | (mod_spi_sel16 *2) | mod_spi_start

    if debug_flag:
        print("                   Launch SPI transfer with OSB SPI Master SPI_CTRL write value = 0x%x" % spi_ctrl)
    reg_write(glu_reg_base_addr + REG_OSB_SPI_CTRL, spi_ctrl)

    # reg_addr_value = SPI_ADDR_VERSION

    if debug_flag:
        input("\nData transfer : Enter")
        print("")

    # data trfer :
    #==============

    print("** Write_data : OSB SPI Master SPI_TRANSMIT value = 0x%x" % wr_data)
    reg_write(glu_reg_base_addr + REG_OSB_SPI_TRANSMIT, (wr_data * 65536))

    if debug_flag:
        data_wr_value = get_reg_value(glu_reg_base_addr + REG_OSB_SPI_TRANSMIT)
        print("             => OSB SPI Master SPI_TRANSMIT reg. read value = 0x%x" % data_wr_value)

    mod_spi_start = 0x1
    spi_ctrl = (mod_spi_freq * 256) | (mod_spi_cpha * 8) | (mod_spi_cpol * 4) | (mod_spi_sel16 *2) | mod_spi_start

    if debug_flag:
        print("             Launch SPI transfer with OSB SPI Master SPI_CTRL write value = 0x%x" % spi_ctrl)
    reg_write(glu_reg_base_addr + REG_OSB_SPI_CTRL, spi_ctrl)

    time.sleep(0.5)

    if readNwrite == 1:
        if debug_flag:
            print("\nOSB SPI Master SPI_TRANSMIT Receive value = 0x%x" % wr_data)

        reg_data_value = get_reg_value(glu_reg_base_addr + REG_OSB_SPI_TRANSMIT)
        return_value = reg_data_value & 0xff
        if debug_flag:
            print("             OSB SPI Master SPI_TRANSMIT read value = 0x%x" % return_value)

    if readNwrite == 1:
        return return_value
    else:
        return None

#
#=============================================================================================
@DIAG("Puma fpga version and synthyesis date")
def t_obb7000_puma_fpga_revision(cmd):
#=============================================================================================
#
    puma_glu_reg_base_addr = get_puma_glu_base_addr()

    puma_fpga_version = get_reg_value(puma_glu_reg_base_addr + REG_PUMA_FPGA_VERSION)
    print("\n* Puma fpga_version = 0x%x" % puma_fpga_version)

    pcb_hw_vld = (puma_fpga_version & 0x80000000) >> 31
    boot_mode  = (puma_fpga_version & 0x70000000) >> 28
    PCB_hw_rev = (puma_fpga_version & 0x0f000000) >> 24
    FPGA_version = puma_fpga_version & 0x00ffffff

    print("     * pcb_hw_vld   (31)     = %d" %pcb_hw_vld)
    print("     * boot_mode    (30:28)  = 0x%x" %boot_mode)
    print("     * PCB_hw_rev   (27:24)  = 0x%x" %PCB_hw_rev)
    print("     * FPGA_version (23:0)   = 0x%x" %FPGA_version)

    puma_fpga_synth_date = get_reg_value(puma_glu_reg_base_addr + REG_PUMA_FPGA_SYNTH_DATE)
    print("\n* fpga_synth_date_value = 0x%x" % puma_fpga_synth_date)

    day   = (puma_fpga_synth_date & 0xf8000000) >> 27
    month = (puma_fpga_synth_date & 0x07800000) >> 23
    year  = (puma_fpga_synth_date & 0x007e0000) >> 17
    print("     * Day-Month-Year = %d-%d-%d" %(day, month, 2000+year))
    hour   = (puma_fpga_synth_date & 0x0001f000) >> 12
    mn     = (puma_fpga_synth_date & 0x00000fc0) >> 6
    second = puma_fpga_synth_date & 0x0000003f
    print("     * hour-mn-second = %d-%d-%d" %(hour, mn, second))

    return None
#
#=============================================================================================
#
# Puma i2c devices :
#
#  ? @ I2C_addr = 0x21
#  ? @ I2C_addr = 0x41
#  ? @ I2C_addr = 0x48
#  Identification EEPROM @ I2C_addr = 0x50
#  Identification EEPROM @ I2C_addr = 0x52
#  ? @ I2C_addr = 0x71
#  ? @ I2C_addr = 0x74
#
#=============================================================================================
#
#=============================================================================================
@DIAG("Puma i2c devices detection")
def t_obb7000_puma_i2cdetect(cmd):
#=============================================================================================

    verbose = False

    try:
        if ' ' not in cmd:
            pass
        else:
            (command,consigne) = cmd.split()
            if consigne == "verbose":
                verbose = True
            else:
                print_error("   Syntax error : arg must be : verbose\n")
                return False
    except:
        print_error("   Syntax error : Command must be : t_obb7000_puma_i2cdetect <consigne>\n")
        print_error("                  <verbose_flag> = verbose ONLY                                 ")
        print_error("                  Note : <verbose_flag> is optional                             ")
        print_error("                                                                                ")
        return False

    FileName = "/usr/share/pydiag/oth/puma_i2c_detect_tmp.txt"

    psb_i2c_bus_nb = '11'

    i2c_cmde = "i2cdetect -y "+psb_i2c_bus_nb

    if verbose:
        i2c_bus0_my_list = (os.system(i2c_cmde))

    os_cmde = i2c_cmde+ " > "+FileName

    i2c_bus0_my_list = (os.system(os_cmde))

    i2c_to_detect_list = ['21', '41', '48', '50', '52', '71', '74']
    i2c_device_list = ['PCA9535', 'I2C-6-MUX', 'Temperature sensor', 'EEPROM ident', 'EEPROM ident', 'PCA9532', 'CPB_U47']

    i2c_detected_list = []

    with open(FileName,'r') as tmpfile:
        for line in tmpfile.readlines():
            col = 0
            if ':' in line:
                (addr_list, data_list) = line.split(': ')
                var = data_list.split(' ')

                if len(var) > 17:
                    j = 0
                    var1 = []
                    while j < len(var):
                        if var[j] == '':
                            var1.append('  ')
                            j += 2
                        else:
                            var1.append(var[j])
                        j += 1
                    var = var1
                for elt in enumerate (var):
                    if elt[1] != '  ' and elt[1] != '--' and  elt[1] != '\n':
                        i2c_addr = int(addr_list, base=16) + col
                        i2c_addr_h = "%x" %i2c_addr

                        i2c_detected_list.append(i2c_addr_h)
                    col += 1

    tmpfile.close()

    os_cmde = "rm -f "+FileName
    (os.system(os_cmde))

    if verbose:
        print("i2c_detected_list is ", i2c_detected_list)

    pass_flag = True
    for elt in enumerate (i2c_to_detect_list):
        if (elt[1]) in i2c_detected_list:
            print_ok("I2C device at addr 0x%s" %elt[1]+" detected")
        else:
            print_error("I2C device at addr 0x%s" %elt[1]+" not detected")
            pass_flag = False

    return pass_flag
#
#=============================================================================================
@DIAG("Puma spi reg. test")
def t_obb7000_puma_spi_reg_test(cmd):
#=============================================================================================

    side  = 1
    slice = 2
    Utsspi = utsspi.SpiModule(side, slice, "/dev/uts_spi")

    puma_fpga_version = Utsspi.read_mod_register8(REG_PUMA_FPGA_VERSION)
    print("\n* REG_PUMA_FPGA_VERSION reg. read_32 = 0x%x" %puma_fpga_version)

#=============================================================================================
@DIAG("Piranha spi reg. test")
def t_obb7000_pir_spi_reg_test(cmd):
#
# gpio480 = U49-1 (P00) = I2CEXP_EXPCA_PWR_EN output
# gpio481 = U49-2 (P01) = I2CEXP_EXPCB_PWR_EN output
# gpio482 = U49-3 (P02) = EXPCA_I2CEXP_TYPE_PCIE_B input
#   Note : EXPCA_I2CEXP_TYPE_PCIE_B is tied to GND on FTH-7000 Backplane
# gpio483 = U49-4 (P03) = EXPCB_I2CEXP_TYPE_PCIE_B input
#
#=============================================================================================

    #FileName = "/usr/share/pydiag/oth/pir.txt"
    #os_base_cmd = "cat /sys/clasF481s/gpio/gpio483/value"
    #print("os_base_cmd is ", os_base_cmd)
    #os_cmde = os_base_cmd+" > "+FileName

    gpio_480_value = sysfs_read_string(get_gpio_file("I2CEXP_EXPCA_PWR_EN"))
    print("gpio_480_value (I2CEXP_EXPCA_PWR_EN) is", gpio_480_value)

    gpio_481_value = sysfs_read_string(get_gpio_file("I2CEXP_EXPCB_PWR_EN"))
    print("gpio_481_value (I2CEXP_EXPCB_PWR_EN) is", gpio_481_value)

    gpio_482_value = sysfs_read_string(get_gpio_file("EXPCA_I2CEXP_TYPE_PCIE_B"))
    print("gpio_482_value (EXPCA_I2CEXP_TYPE_PCIE_B) is", gpio_482_value)

    gpio_483_value = sysfs_read_string(get_gpio_file("EXPCB_I2CEXP_TYPE_PCIE_B"))
    print("gpio_483_value (EXPCB_I2CEXP_TYPE_PCIE_B) is", gpio_483_value)

