from viavi.evm import *
from viavi.diag import *
import os
from struct import unpack

@DIAG("Print board DTS variables")
def boardinfo(cmd):
    c = cmd.split()
    l = os.listdir("/proc/device-tree/board")
    if len(c) < 2 or c[1] not in l:
        print("%s <%s>"%(c[0], "|".join(l)))
        return False
    data = None
    with open("/proc/device-tree/board/%s"%c[1], "rb") as f:
        data = f.read()
    if data is None:
        return False
    if c[1] in ["screen-type", "power-adapter", "key-on-pressed", "board-version", "info-otu-board", "customer-services-mode", "env-size", "spi-tsc", "nand-size", "backplane-id"]:
        print_info("# %s"%hex(unpack(">i", data)[0]))
    else:
        print_info("# %s"%data.decode('ASCII'))

    return True


@DIAG("Read PCB Version")
def getPCBVersion(cmd):
     with open("/proc/device-tree/board/board-version","rb") as f:
        revb = f.read(2)
     rev = unpack("<H",revb)
     rev = rev[0] & 0x0F
     print_info("#PCB Revision Code = %d" % (rev ))

