import QtQuick 2.3
import QtQuick.Layouts 1.2
import QtQuick.Controls 2.0

import com.viavi.style 1.0
import com.viavi.style.components 1.0


ViaviMenuLineControl {
    id: root

    // Signals
    signal sgnOptionClicked( int index );

    property variant model

    property Component optionDelegate: Component{                
                ViaviOptionButton {
                    text: modelText
                    selected: modelChecked
                    implicitHeight: modelImplicitHeight
                    implicitWidth: modelImplicitWidth                    
                }
            }

    mainContentItem:
    Item{
        id: fullRow
        width: root.width - root.textWidth - root.contentSpacing
        height: ViaviStyle.layout.menuLineHeight
        Row {
            id: row       

            spacing: ViaviStyle.layout.largeMargin

            Repeater {
                id: repeater
                model: root.model
                Loader{
                    sourceComponent: optionDelegate
                    
                    property string modelText: model.text !== undefined ? model.text : modelData
                    property bool modelChecked: model.checked !== undefined ? model.checked : false
                    property int modelImplicitHeight: ViaviStyle.layout.setupMenuLineHeight
                    property int modelImplicitWidth: Math.min(ViaviStyle.layout.menuTextFieldWidth,
                            (fullRow.width - row.spacing * (repeater.count - 1)) / repeater.count)

                    Connections {
                       target: item
                        function onClicked() { 
                            root.sgnOptionClicked(model.index) 
                        }
                    }
                }
            }
        }
    }
}
