import QtQuick 2.0
import QtQuick.Layouts 1.8
import QtQuick.Controls 2.1

import com.viavi.style 1.0
import com.viavi.style.components 1.0
import com.viavi.style.components.menudata 1.0

ViaviMenuLineCheckCombo {
    id: root
    
    property alias textData: textFieldProperties
    TextFieldData {
        id: textFieldProperties
    }

    signal textClicked()

    tailContentItem2: ViaviInputText {
        id: textField
        text: textFieldProperties.text
        enabled: textFieldProperties.enabled
        visible: textFieldProperties.visible
        width: ViaviStyle.layout.menuTextFieldWidth
        onTextEdited: {
            if (textFieldProperties.text !== text)
                textFieldProperties.text = text
        }
        onClicked: {
            root.textClicked()
        }
        implicitHeight: ViaviStyle.layout.setupMenuLineHeight
    }
}
