import QtQuick 2.8
import QtQuick.Layouts 1.8

import com.viavi.style 1.0
import com.viavi.style.components 1.0
import com.viavi.style.components.menudata 1.0

ViaviMenuLineCheckBox {
    
    property Component tailContentItem2: null

    property alias comboBoxData: comboProperties
    ComboBoxData {
        id: comboProperties
    }

    tailContentItem: RowLayout {
        ViaviComboBox {
            id: comboBox
            model: comboProperties.model
       	    
	     Connections{
                target: comboProperties
                function onCurrentIndexChanged(){
                    comboBox.currentIndex = comboProperties.currentIndex
        	}
            }
            currentIndex: comboProperties.currentIndex
            onCurrentIndexChanged: {
                if (comboProperties.currentIndex !== currentIndex)
                    comboProperties.currentIndex = currentIndex
            }
            enabled: comboProperties.enabled
            visible: comboProperties.visible
            Binding {
                target: comboProperties
                property: 'currentText'
                value: comboBox.currentText
            }
            Binding {
                target: comboProperties
                property: 'count'
                value: comboBox.count
            }
            implicitHeight: ViaviStyle.layout.setupMenuLineHeight
            implicitWidth: ViaviStyle.layout.menuTextFieldWidth
        }
        
        Loader {
            id: tailContentItem2Loader
            sourceComponent: tailContentItem2
        }
    }
}
