import QtQuick 2.3
import QtQuick.Layouts 1.2
import QtQuick.Controls 2.0

import com.viavi.style 1.0
import com.viavi.style.components 1.0
import com.viavi.style.components.virtualkeyboard 1.0

Item {
    id: root

    implicitHeight: ViaviStyle.layout.buttonHeight + 2 * ViaviStyle.layout.smallMargin
    implicitWidth: implicitHeight * 4

    property alias text: lineTitleText.text
    default property alias mainData: mainData.data

    RowLayout {
        anchors.fill: parent
        anchors.margins: ViaviStyle.layout.smallMargin
        spacing: ViaviStyle.layout.mediumMargin

        Text {
            id: lineTitleText

            Layout.preferredWidth: ViaviStyle.layout.defaultButtonWidth
            Layout.minimumWidth: Layout.preferredWidth
            Layout.maximumWidth: Layout.preferredWidth

            horizontalAlignment: Text.AlignLeft
            verticalAlignment: Text.AlignVCenter

            font: ViaviStyle.layout.smallFont
            wrapMode: Text.WordWrap
        }


        Item {


            Layout.preferredWidth: ViaviStyle.layout.buttonHeight * 3.5
            Layout.preferredHeight: ViaviStyle.layout.buttonHeight / 1.5

            Item {
                id: mainData
                anchors.fill: parent
            }
        }
    }
}
