import QtQuick 2.3
import QtQuick.Layouts 1.2
import QtQuick.Controls 2.0

import com.viavi.style 1.0
import com.viavi.style.components 1.0
import com.viavi.style.components.virtualkeyboard 1.0

TextField {
    id: root
    borderColor: enabled ? ViaviStyle.colors.activeColor : ViaviStyle.colors.disabledItemColor

    signal clicked()

    padding: height > 0 ? (height - fontHeight) / 2 : ViaviStyle.layout.mediumMargin

    MouseArea{
        anchors.fill: parent
        onClicked: root.clicked();
    }
    //TODO: needs testing on device to see if these events are generated
    Keys.onReleased: {
        if (event.key === Qt.Key_Return || event.key === Qt.Key_Enter) {
            if (activeFocus) {
                root.clicked();
            }
        }
    }
}
