import QtQuick 2.9

import com.viavi.style.ViaviStyleConfig 1.0

Item {
    id: rootId


    readonly property bool defaultIsSmallScreen: false
    readonly property int defaultScreenWidth: 1280
    readonly property int defaultScreenHeight: 800

    property bool smallScreenLayout: ViaviStyleConfig.isUsed ? ViaviStyleConfig.isSmallScreen : defaultIsSmallScreen
    property int screenWidth: ViaviStyleConfig.width > 0 ? ViaviStyleConfig.width : defaultScreenWidth
    property int screenHeight: ViaviStyleConfig.height > 0 ? ViaviStyleConfig.height : defaultScreenHeight
    property ViaviTheme theme: ViaviTheme { }
    property ViaviLayout layout: (ViaviStyleConfig.layoutSourceURL.toString().length > 0) ? clientLayout.item : layoutId.item
    property ViaviColors colors: ViaviColors {}
    property ViaviImages images: ViaviImages {}

    Component {
        id: viaviLayout
        ViaviLayout{
            id: viaviLayoutFile
            screenWidth: rootId.screenWidth
            screenHeight: rootId.screenHeight
        }
    }

    Component {
        id: viaviLayoutForSmallScreen
        ViaviLayoutForSmallScreen{
            id: viaviLayoutForSmallScreenFile
            screenWidth: rootId.screenWidth
            screenHeight: rootId.screenHeight
        }
    }

    Loader {
        id: clientLayout
        property url layoutSourceURL: ViaviStyleConfig.layoutSourceURL
        //NOTE: feature to set parameters declaratively is not integrated into Qt: https://codereview.qt-project.org/c/qt/qtdeclarative/+/3072 , thus one of the two workarounds is needed
        onLayoutSourceURLChanged: {
            setSource(layoutSourceURL, {'screenWidth': rootId.screenWidth, 'screenHeight': rootId.screenHeight})
        }
    }

    Loader {
        id: layoutId
        sourceComponent: smallScreenLayout ? viaviLayoutForSmallScreen : viaviLayout
    }

    property real waitingAnimationDuration: 3000
}
