import QtQuick 2.3

import com.viavi.style 1.0

Item {
    id: bg
    property int pourcentage : 0
    property bool landscape: false
    property string goodcolor: ViaviStyle.colors.green
    property string badcolor: ViaviStyle.colors.red
    property string nocolor: ViaviStyle.colors.viaviPurple
    property int triggerLow: 20
    property int triggerHigh: 80
    property bool haveTrigger: false

    function get_color(pcent) {
        if (!haveTrigger)
            return nocolor

        if (pcent < triggerLow || pcent > triggerHigh) {
            return badcolor
        }

        return goodcolor
    }

    Rectangle {
        width: parent.width
        height: parent.height
        z: 0

        Rectangle {
            anchors.fill: parent
            border.width: 2
            border.color: ViaviStyle.colors.lightGray2
        }

        Rectangle {
            z: 1
            border.color: ViaviStyle.colors.lightGray2
            border.width: 2
            x: landscape ? (triggerLow * ((parent.width) / 100)) : 0
            y: landscape ? 0 : (triggerLow * ((parent.height) / 100))
            width: landscape ? ((parent.width) / 100) * (triggerHigh - triggerLow) : (parent.width)
            height: landscape ? parent.height : ((triggerHigh - triggerLow) * ((parent.height) / 100))
        }

        Rectangle {
            radius: 5
            id: rec
            color: get_color(pourcentage)
            z : 2
            x : 5
            y: ((landscape) ? 5 : (100 - pourcentage) * ((parent.height - 10) / 100))
            width: landscape ? ((parent.width - 10) / 100) * pourcentage : (parent.width - 10)
            height: landscape ? (parent.height - 10) : parent.height - y - 10
            Behavior on color {
                ColorAnimation { duration: 100 }
            }
            Behavior on y {
                NumberAnimation { duration: 100 }
            }
            Behavior on width {
                NumberAnimation { duration: 100 }
            }
        }
    }
}
