#! /bin/sh

init_puma_init()
{
    isPUMAUpdated[1]=0
    isPUMAUpdated[2]=0

    # PUMA management
    #
    # Search for HETNET modules in position 1 or 2 and look for a PUMA module
    for i in $(seq 1 2);
    do
		echo -n "PUMA #$i"
		qdbus --literal --system com.viavisolutions.platform.SystemInventory /com/viavisolutions/platform/SystemInventory/$i com.viavisolutions.platform.SystemInventory.ModuleResources.SystemRecords | grep -q "702200B64-"
		[ $? -ne 0 ] && echo " - Not found, continuing" && continue || echo

		# Program the PUMA Module's fpga if needed
		/usr/bin/fiberprogfpga tacb -sf ${i} "/acterna/storage/fpga/u-boot-puma.bin"
		case $? in
			0) # 0  = Flash success - We need to reboot
				echo "FPGA bitstream updated"
				isPUMAUpdated[$i]=1
				;;

			11) # 11 = Already up to date - There is nothing to be done
				echo "FPGA bitstream already up to date."
				isPUMAUpdated[$i]=0
				;;

			*)
				echo "ERROR: FPGA flash failed, continuing anyway"
				isPUMAUpdated[$i]=0
				;;
		esac
    done

	if [ ${isPUMAUpdated[1]} -eq 1 -o ${isPUMAUpdated[2]} -eq 1 ]
    then
        echo "A PUMA module has been updated - Reboot in 5 seconds"

        # Simulate Otu launch to avoid rebooting in rescue mode - if script exists
        [ -f /sbin/otu_confirm_start.sh ] && otu_confirm_start.sh

        sleep 5

        reboot
        exit -1
    fi
}


# This deinit function is only needed for old revisions of Puma modules (rev <= 21), which have a glitch.
# We - sometimes - can not power down the module using the PWR_EN GPIO as some voltages are not correctly dropped.
#
# This function serves no purpose with newer revisions of Puma modules (rev > 21)
# To be removed when it is not needed anymore
init_puma_deinit()
{
    # Search for HETNET modules in position 1 or 2 and look for a PUMA module
    for i in $(seq 1 2);
    do
        qdbus --literal --system com.viavisolutions.platform.SystemInventory /com/viavisolutions/platform/SystemInventory/$i com.viavisolutions.platform.SystemInventory.ModuleResources.SystemRecords | grep -q "702200B64-"
		[ $? -ne 0 ] && continue

		echo "PUMA #$i"

		qdbus --system com.viavisolutions.platform.PowerBudget /com/viavisolutions/platform/PowerBudget com.viavisolutions.platform.PowerBudget.ModulePowerOff ${i}
    done
}
