#!/usr/bin/python3

import os
import sys
import socket
from collections import OrderedDict

VNC_SERVER_SOCKET = "/tmp/vnc_server"
COMMANDS = OrderedDict([
    ("start_server", []),
    ("stop_server", []),
    ("set_password", ["password"]),
    ("get_password", []),
    ("is_server_running", []),
    ("get_client_count", []),
    ("enable_password_check", []),
    ("disable_password_check", [])
])

def print_help():
    print("Commands:")
    for cmd, params in COMMANDS.items():
        print("    %s " % cmd, end="")
        for p in params:
            print("<%s> " % p, end="")
        print()

if len(sys.argv) == 1:
    print_help()
    exit(0)

cmd = sys.argv[1]
if cmd not in COMMANDS.keys():
    print("Invalid command!")
    exit(1)

params = sys.argv[2:]
if COMMANDS[cmd] and len(params) != len(COMMANDS[cmd]):
    print("Invalid number of arguments for \"%s\" command" % cmd)
    exit(2)

if os.path.exists(VNC_SERVER_SOCKET):
    client = socket.socket(socket.AF_UNIX, socket.SOCK_STREAM)
    client.connect(VNC_SERVER_SOCKET)

    data = cmd.encode("utf-8")
    for p in params:
        data = data + len(p).to_bytes(1, byteorder="big")
        data = data + p.encode("utf-8")

    client.send(data)
    response = client.recv(1024)
    print(response.decode("utf-8"))

    client.close()
else:
    print("VNC server socket does not exist. Maybe there is a problem with Weston or the VNC plugin?")
