#!/bin/bash

#
# This script is searching for OTDR hardware requiring OTDR solution to run.
#

# Wait for the scan to be completed
cat /sys/platform/uts_scan/ready

# Check if a SHIM or FMA-1000 board is present - if it is, i2c busses should be set
if grep -x 0 -q /sys/platform/uts_scan/i2c_master_op  /sys/platform/uts_scan/i2c_master_pw; then
  exit 1
fi

# Search for 2k/4k module or 6k other than CAA
if grep -e "^[0-9]" /sys/platform/uts_scan/modules | grep -v CAA | tr -s "\t" " " | cut -d " " -f 3 | grep -v -x -q 0 ; then
  exit 0
fi

# Search if a TACB is present, need Isu to read eeprom data in manufacturing
for i in $(seq 1 2);
do
  qdbus --literal --system com.viavisolutions.platform.SystemInventory /com/viavisolutions/platform/SystemInventory/$i com.viavisolutions.platform.SystemInventory.ModuleResources.SystemRecords | grep -q "703100B10-"
  [ $? -eq 0 ] && exit 0
done

# Check whether a FMA-1000 board is present - if there is one, Isu is needed
for i in $(seq 1 4);
do
  qdbus --literal --system com.viavisolutions.platform.SystemInventory /com/viavisolutions/platform/SystemInventory/$i com.viavisolutions.platform.SystemInventory.ModuleResources.SystemRecords | grep -q "703100B12-"
  [ $? -eq 0 ] && exit 0
done

# When optical option will be manage on ONA add here the way to detect it
if [[ -f /tmp/i2c_optic_opt ]] ; then
  if i2cdetect -y $(cat /tmp/i2c_optic_opt) | grep -q 57 ; then
    exit 0
  fi
fi

exit 1
