#!/bin/bash

#--------------------------------------------
# Gestion du debug
#--------------------------------------------
if [ "$2" == "DEBUG" ]
then
	DEBUG=1
	echo "DEBUG is ON"
fi


function Disconnect_mts_manage
{
   # deconnexion, on supprime le tunnel
   prctokill=$(ps aux | grep ssh | grep MAW_Authentication | grep $MtsHttpTunnelPort | tr -s " " | cut -d " " -f 2)
   if [ "$prctokill" != "" ]
   then
			[ $DEBUG ] && echo "  ps aux | grep ssh | grep MAW_Authentication | grep $MtsHttpTunnelPort | tr -s " " | cut -d " " -f 2"
			[ $DEBUG ] && echo "  Kill tunnel : process to disconnect : $prctokill"
   			kill $(ps aux | grep ssh | grep MAW_Authentication | grep $MtsHttpTunnelPort | tr -s " " | cut -d " " -f 2)
   else
        	[ $DEBUG ] && echo "  nothing to disconnect "
   fi
}


if [ "$1" == "" ]
then
	COMMAND="CONNECT"
else
	COMMAND="$1"
fi

if [ "$COMMAND" == "CONNECT" ]
then
   #--------------------------------------------
   # Message pour patienter
   #--------------------------------------------
   [ $DEBUG ] && echo "affiche message  d'attente "
   echo -en "*rem\nprocess:warning \"\",\"Connecting to Viavi server\", INFO, 0,\"\",\"\",\"Please wait...\"\n" >/dev/tcp/127.0.0.1/8000
fi
   
#--------------------------------------------
# Fermeture des fd de ce processus, fd hrits du process parent Isu,  de faon ? pouvoir faire un restart_Isu sans tout bloquer 
#--------------------------------------------
for fd in $(ls /proc/$$/fd)
do
   if [ $fd -gt 2 -a $fd -lt 255 ]
    then
      eval "exec $fd<&-"
    fi
done

   

#--------------------------------------------
#info de config du MTS
#--------------------------------------------
IS_OTU="no"
[ -f /proc/device-tree/board/info-otu-board ] && [ $(hexdump /proc/device-tree/board/info-otu-board -n 4 -e '"%d"') -eq "3" ] && IS_OTU="yes"
source /etc/platform.conf
PATH=/usr/local/sbin:/usr/local/bin:$PATH:/usr/lib/busybox/bin:/sbin
basedir=$(dirname $0)

#--------------------------------------------
#traitement de l'ident en fonction du model
#--------------------------------------------
if [ "$IS_OTU" == "no" ]
then
      MtsIdent=$(echo "*rem;*idn?" | nc -w2 127.0.0.1 8000  | tr -d " " )
      #on recup meme les licenses non valides
      MtsLic="MTSLIC:"$(echo "*rem;ISU:LIC:LIST? " | nc -w2 127.0.0.1 8000  | tr -d " " )
      #on recup que les licenses valides
      MtsLicValid="MTSLIC:"$(echo "*rem;PROC:LIC:VAL? " | nc -w2 127.0.0.1 8000  | tr -d " " )
      #on recup la langue 
      MtsLang=$(echo "*rem;SYST:COUNTRY:LANG? " | nc -w2 127.0.0.1 8000  | tr -d " " )
   
else
      if [ "$MODEL" == "otu8000v2" ]
      then
            RESCUE_MODE=`hexdump -e '1/4 "%d\n"'  /proc/device-tree/board/rescue-mode`
            IDENTITY="OTU8000E"
      else
            [ "$(cat /proc/device-tree/board/rescue-mode)" == "yes" ] && RESCUE_MODE=1 || RESCUE_MODE=0
            IDENTITY="OTU5000"
      fi

      if [ "$RESCUE_MODE" != "1" ]
      then
            MtsIdent=$(echo "*rem;*idn?" | nc -w2 127.0.0.1 8000  | tr -d " " )
            MtsLic="MTSLIC:"$(echo "*rem;ISU:LIC:LIST? " | nc -w2 127.0.0.1 8000  | tr -d " " )
            MtsLicValid="MTSLIC:"$(echo "*rem;PROC:LIC:VAL? " | nc -w2 127.0.0.1 8000  | tr -d " " )
      else
            MtsIdent="ViaviSolutions,${IDENTITY},"`getserialnb`",ISU,`getinfoversion Isu | cut -f4 -d';' | cut -f2 -d'V'`"
            MtsLic="MTSLIC:"
      fi
fi

[ $DEBUG ] && echo "MtsIdent="$MtsIdent
[ $DEBUG ] && echo "MtsLic="$MtsLic
[ $DEBUG ] && echo "MtsLicValid="MtsLicValid
[ $DEBUG ] && echo "MtsLang="$MtsLang

#--------------------------------------------
#Savoir par quel media on passe
#--------------------------------------------
MtsMedia=$(route | grep default | head -n1 | awk '{print $8}' | sed "s/[0-9]//g")
[ $DEBUG ] && echo "MtsMedia="$MtsMedia

#--------------------------------------------
#test si device is in VIAVI LAN
#--------------------------------------------   
if ping -c 1 intranet3.ds.jdsu.net  &> /dev/null
then
  		#host reachable
  		[ $DEBUG ] && echo "Device is in VIAVI LAN"
  		LAN_VIAVI=1
		#!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
		# pas de tunnel acces direct
		#!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
		MtsHttpTunnelPort=intranet3.ds.jdsu.net
		OvhHttpTunnelPort=
else
  		#host unreachable
  		[ $DEBUG ] && echo "Device is NOT In VIAVI LAN"
		LAN_VIAVI=0
		#--------------------------------------------
		# double tunnel : mts vers OVH et OVH vers intranet3 
		#--------------------------------------------
		MtsHttpTunnelPort=127.0.0.1:7280
		OvhHttpTunnelPort=127.0.0.1:6180
fi   
[ $DEBUG ] && echo "OvhHttpTunnelPort="$OvhHttpTunnelPort
[ $DEBUG ] && echo "MtsHttpTunnelPort="$MtsHttpTunnelPort


#--------------------------------------------
#serveur cible anywhere
#--------------------------------------------
SP_SSH1='mtsanywhere.updatemyunit.net' #serveur public


#--------------------------------------------
#Obtenir la configuration du Proxy dans System Setup sauf dans le cas usb ou ce n'est pas utile (connexion directe internet 3G)
#Pas de gestion du proxy pour l'OTU
#--------------------------------------------
ProxyPac=""
ViaProxy=""

if [ "$MtsMedia" != "usbg" ] && [ "$IS_OTU" == "no" ]
then
      UseProxy=$(echo "*rem;SYST:PROXY:USE?" | nc -w2 127.0.0.1 8000)
   
      case $UseProxy in
         MAN)
            Proxy=$(echo "*rem;SYST:PROXY:ADDR?" | nc -w2 127.0.0.1 8000)
            if [ "$Proxy" != "" ]
            then
                  ViaProxy="-p $Proxy"
            fi
         ;;
      
         PAC)
            ProxyPac=$(echo "*rem;SYST:PROXY:PAC?" | nc -w2 127.0.0.1 8000)
            if [ "$ProxyPac" != "" ]
            then
                  Proxy=$(get_proxy_from_pac $ProxyPac http://$SP_SSH1 $SP_SSH1 | cut -f2 -d "=")
                  if [ "$Proxy" != "" ]
                  then
                        ViaProxy="-p $Proxy"
                  fi
            fi
         ;;
      
         *)  ;;
         esac
fi

#--------------------------------------------
# choix du ssh
# if "ssh-weak" not found, try "ssh"
#--------------------------------------------
ssh=ssh-weak
if ! type -p $ssh >/dev/null 2>&1; 
then
   ssh=ssh
fi

[ $DEBUG ] && echo "ssh="$ssh
[ $DEBUG ] && echo "COMMAND="$COMMAND


if [ "$COMMAND" == "CONNECT" ]
then
	if [ "$LAN_VIAVI" == 0 ]
	then
	
	# on cherche a etablir un tunnel
      
    #--------------------------------------------
    #on force la deconnection (kill du tunnel)
   	#--------------------------------------------
   	Disconnect_mts_manage
	
	   #--------------------------------------------
      # On teste les 3 "chemins" possibles ( port 22 direct, port 443 direct et port 443 via proxy) pour choisir le plus "efficace"
      # temps en 1/100 de seconde
      #--------------------------------------------
      [ $DEBUG ] && echo -n "test chemin 22 direct"
      set -o pipefail
      time_22=$(/usr/bin/time 2>&1 -p $ssh -i /root/.ssh/kpriv_mts -o StrictHostKeyChecking=no -o UserKnownHostsFile=/dev/null -o "ProxyCommand=$basedir/ssh-proxy.sh -s $ssh %h %p" MAW_Authentication@$SP_SSH1 -p 22 AskConnectionMTS CHECKTIMEFROMMTS | tail -n 3 | head -n 1 | awk '{print $2}' | sed 's/^0*\([0-9]*\)\.\([0-9]*\)/\1\2/')
      RetCode_22=$?
      [ $DEBUG ] && echo " --> time_22="$time_22" ms"
   
      [ $DEBUG ] && echo -n "test chemin 443 direct"
      time_443=$(/usr/bin/time 2>&1 -p $ssh -i /root/.ssh/kpriv_mts -o StrictHostKeyChecking=no -o UserKnownHostsFile=/dev/null -o "ProxyCommand=$basedir/ssh-proxy.sh -s $ssh %h %p" MAW_Authentication@$SP_SSH1 -p 443 AskConnectionMTS CHECKTIMEFROMMTS | tail -n 3 |  head -n 1 | awk '{print $2}' | sed 's/^0*\([0-9]*\)\.\([0-9]*\)/\1\2/')
      RetCode_443=$?
      [ $DEBUG ] && echo " --> time_443="$time_443" ms"
   
      [ $DEBUG ] && echo -n "test chemin 443 proxy"
      if [ "$ViaProxy" != "" ]
      then
         time_443_proxy=$(/usr/bin/time 2>&1 -p $ssh -i /root/.ssh/kpriv_mts -o StrictHostKeyChecking=no -o UserKnownHostsFile=/dev/null -o "ProxyCommand=$basedir/ssh-proxy.sh -s $ssh $ViaProxy %h %p" MAW_Authentication@$SP_SSH1 -p 443 AskConnectionMTS CHECKTIMEFROMMTS | tail -n 3 |  head -n 1 | awk '{print $2}' | sed 's/^0*\([0-9]*\)\.\([0-9]*\)/\1\2/')
         RetCode_443_Proxy=$?
      else
         time_443_proxy=9999
         RetCode_443_Proxy=255
      fi
      [ $DEBUG ] && echo " --> time_443_proxy="$time_443_proxy" ms"
      set +o pipefail
   
	   #!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
	   #debug forcage for test
	   #time_22=999
	   #time_443=0
	   #!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

      #--------------------------------------------
  	  # On choisit le chemin le plus rapide parmi ceux ayant aboutis
      #--------------------------------------------   
  	   Chemin=$(echo -e "$RetCode_22 $time_22 P22\n$RetCode_443 $time_443 P443\n$RetCode_443_Proxy $time_443_proxy P443P" | grep '^0' | cut -f2-3 -d ' ' | sort -n | head -n 1 | awk '{print $2}')
  	   [ $DEBUG ] && echo "Chemin choisi = "$Chemin

  	   case $Chemin in
         P22)
		      $ssh -i /root/.ssh/kpriv_mts -o ExitOnForwardFailure=yes -o StrictHostKeyChecking=no -o UserKnownHostsFile=/dev/null -o "ProxyCommand=$basedir/ssh-proxy.sh -s $ssh %h %p" MAW_Authentication@$SP_SSH1 -p 22 -fN   -L$MtsHttpTunnelPort:$OvhHttpTunnelPort
            RetCode=$?
            PortUsed=22
            ViaProxy=
            ;;
      
         P443)
            $ssh -i /root/.ssh/kpriv_mts -o ExitOnForwardFailure=yes -o StrictHostKeyChecking=no -o UserKnownHostsFile=/dev/null -o "ProxyCommand=$basedir/ssh-proxy.sh -s $ssh %h %p" MAW_Authentication@$SP_SSH1 -p 443 -fN   -L$MtsHttpTunnelPort:$OvhHttpTunnelPort
            RetCode=$?
            PortUsed=443
            ViaProxy=
            ;;
         
         P443P)
            $ssh -i /root/.ssh/kpriv_mts -o StrictHostKeyChecking=no -o UserKnownHostsFile=/dev/null -o "ProxyCommand=$basedir/ssh-proxy.sh -s $ssh $ViaProxy %h %p" MAW_Authentication@$SP_SSH1 -p 443 AskConnectionMTS $AskConnect $TypCnx $MtsIdent $MtsLic $Media >/tmp/param_mts
            RetCode=$?
            PortUsed=443
            ;;
      
         *)
            RetCode=255
            ;;
   	esac
   else
      #on est en VIAVI LAN
      RetCode=0 
   fi
 
   if [ "$RetCode" != 0 ]
   then
	   #Probleme	
      [ $DEBUG ] && echo "returncode="$RetCode
      if [ "$COMMAND" == "CONNECT" ] && [ "$IS_OTU" == "no" ]
      then
         if [ "$(grep 'forwarding failed' /tmp/MAW_Connection)" != "" ]
            # Avec OpenSSH 6.7 et contrairement ? ce qui se passait avec OpenSSH 5.2, le code de retour est 255 (au lieu de 0) quand il y a
            # un chec de Remote port forwarding
         then
            # affichage warning indiquant qu'il faut attendre que les ports se lib?rent sur le serveur
            echo -en "*rem\nprocess:warning \"\",\"Server ports not available\nRetry in some minutes\", WARNING, 0,\"\",\"\",\"Hit any key to continue\"\n" >/dev/tcp/127.0.0.1/8000
         else
            # affichage warning indiquant echec connexion 
            echo -en "*rem\nprocess:warning \"\",\"Connection failed\", ERROR, 0,\"\",\"\",\"Hit any key to continue\"\n" >/dev/tcp/127.0.0.1/8000
         fi
      fi
   else
      
      # a ce niveau tout semble bien se derouler
     
	  #--------------------------------------------
	  #comme le tunnel est etablie avec http OVH on demande les fichiers a telecharger
	  #--------------------------------------------
	  [ $DEBUG ] && echo "Recup via bootstrap de la liste des fichiers ? tlcharger"
      #fichier tmp qui recupere les infos
	  bootstrap_result=/tmp/mts_manage.bootstrap
      #version live
      cmd="http://$MtsHttpTunnelPort/AppIntranet/glic/MtsManageSoftOptions/scripts/MtsManageSoftOptions_bootstrap.php?MtsIdent=$MtsIdent&MtsLang=$MtsLang&MtsMedia=$MtsMedia&MtsLic=$MtsLic&MtsLicValid=$MtsLicValid&MtsHttpTunnelPort=$MtsHttpTunnelPort"
      #
      #######################################################################
      #!!!!ATTENTION : commenter la version debug mettre a jour avant commit
      #######################################################################
      # version debug : les scripts sont dans Dvt 
      # et dans ce cas la creation de license se fait dans la base "AppIntranetTest" pour ne pas polluer la base "AppIntranet"
      #cmd="http://$MtsHttpTunnelPort/Dvt/AppIntranet/glic/MtsManageSoftOptions/scripts/MtsManageSoftOptions_bootstrap.php?MtsIdent=$MtsIdent&MtsLang=$MtsLang&MtsMedia=$MtsMedia&MtsLic=$MtsLic&MtsLicValid=$MtsLicValid&MtsHttpTunnelPort=$MtsHttpTunnelPort"
      #######################################################################
      #!!!! FIN ATTENTION 
      #######################################################################
      #
   	  [ $DEBUG ] && echo $cmd
   	  wget -q -O -  "$cmd"  > $bootstrap_result

	   #--------------------------------------------
	   #recup la list des fichiers precedement telecharger
	   #--------------------------------------------
	   [ $DEBUG ] && echo " liste des fichiers a tlcharger "$bootstrap_result
	   [ $DEBUG ] && cat $bootstrap_result
	   [ $DEBUG ] && echo "Tlchargement des fichiers via wget "
      while read line  
		do   
      	[ $DEBUG ] && echo "$line"  
      	wget --no-parent $line
	   done < $bootstrap_result

    
	   [ $DEBUG ] && echo "destruction de $bootstrap_result "
      rm -f $bootstrap_result
      
	   #----------------------------------------------------
	   #previent Isu que le QML est pret puis efface message 
	   #----------------------------------------------------
      [ $DEBUG ] && echo "efface message  d'attente "
      echo -en "*rem;proc:qmls;process:warning \"\",\"\", NONE, 0,\"\",\"\",\"\";" >/dev/tcp/127.0.0.1/8000
     
   fi
else
   #cas "$COMMAND" != "CONNECT"	
   [ $DEBUG ] && echo "Deconnection mts_manage"
   Disconnect_mts_manage 
fi

