#!/usr/bin/env bash

set -e

PATTERN="^fth(-[79]000)?(-00001)?$"

HOSTNAME=""
[ -e /etc/hostname ] && HOSTNAME="$(cat /etc/hostname)"

if [[ ${HOSTNAME} =~ ${PATTERN} ]]
then
	SN="$(sicutil -r -sys 0 SerialNumber)"

	OTH_PREFIX="fth-9000"
	[ "$(hexdump /proc/device-tree/board/info-otu-board -n 4 -e '"%d"')" -eq "5" ] && OTH_PREFIX="fth-7000"

	HOSTNAME="${OTH_PREFIX}-${SN:4}"

	hostnamectl set-hostname "${HOSTNAME}"
else
	echo "Hostname already set"
fi
