#!/bin/bash
#
#	Install silently the unused partition with a version given as first agument
#

INSTALLATION_DIR=$1
STATUS_LOG_FILE=/otu/release/current/duplication_status
RELEASE_MANAGER_PID=$(pgrep release-manager)

function log_msg() {
   echo $* >> $STATUS_LOG_FILE
   echo $*
}

function failed() {
    log_msg "Duplication failed"
    rm ${INSTALLATION_DIR}/first_boot_after_upgrade.tmp
    kill ${LOG_REDIRECT}
    exit -1
}

if [ -f /var/volatile/upgrade_in_progress ] ; then
    echo "An upgrade is already in progress (/var/volatile/upgrade_in_progress exists). Exiting..."
    exit -1
fi


function start_service() {
  if $(readlink /sbin/init | grep -q systemd); then
    systemctl start "$1"
  else
    /etc/init.d/"$1" start
  fi
}

function stop_service() {
  if $(readlink /sbin/init | grep -q systemd); then
    systemctl stop "$1"
  else
    /etc/init.d/"$1" stop
  fi
}

rm -f ${STATUS_LOG_FILE}
echo $(date) > ${STATUS_LOG_FILE}

log_msg "Duplicating"

# get back log from release-manager into this log file
if $(readlink /sbin/init | grep -q systemd); then
	journalctl -n 0 -b -u release-manager -f &
else
	tail -n 0 -f /var/log/daemon.log &
fi
LOG_REDIRECT=$!

# Do not sync when duplicating
if $(readlink /sbin/init | grep -q systemd); then
       stop_service otu-rfs-sync
else
       stop_service otu_rfs_sync.sh
fi

# Launch client for release_manager : starting the operation AND doing it
release-manager start_upgrade 0:${INSTALLATION_DIR}/release.xml
if [ "$?"  != "0" ]; then
    logger "Release-manager client has failed to start"
    failed
    exit -1
fi

# First, we wait for the upgrade to start
STATE=$(release-manager get_last_upgrade_state | tail -n1)
nop_counter=0
while [ "$STATE" = "NOP" ] ; do
	sleep 1
	STATE=$(release-manager get_last_upgrade_state | tail -n1)

	# Wait for some time and timeout if release-manager
	# took too much time to start
	let nop_counter++
	[ $nop_counter -ge 60 ] && break
done

# Now, we wait for the upgrade to be completed
while true ; do
	STATE=$(release-manager get_last_upgrade_state | tail -n1)
	[ "$STATE" = "NOP" ] && log_msg "Release-manager never started" && break
	[ "$STATE" = "FAIL" ] && log_msg "Duplication failed" && break
	[ "$STATE" = "PASS" ] && log_msg "Duplication succeed" && break
	[ "$STATE" = "UPGRADING" ] && echo "Duplication in progress"
	sleep 3
done


# If the upgrade succeeded, remove the upgrade_pending U-Boot flag and continue
# else, print an error
# Either way, do not mark the duplication partition as the next to be boot on
fw_setenv mmc_part_volatile
[ "$STATE" = "PASS" ] && fw_setenv upgrade_pending || failed

# At the end check if unused part is mounted and do it if necessary
# Get partition information
source /etc/otu/otuparts.sh
if [ -d /mnt/fs/unused_part ] ; then
    mkdir -p /mnt/fs/unused_part
fi
mountpoint -q /mnt/fs/unused_part || mount -o ro ${ALT_PART} /mnt/fs/unused_part

rm ${INSTALLATION_DIR}/first_boot_after_upgrade.tmp
sync
# Do sync when duplication is complete
if $(readlink /sbin/init | grep -q systemd); then
    start_service otu-rfs-sync
else
    start_service otu_rfs_sync.sh
fi

exit 0
