import QtQuick 2.3

import com.viavi.style 1.0
import com.viavi.style.components 1.0
import com.viavi.fiberutilui.components 1.0

Dialog {
	id: popUpWarning
	


    property string clickToExitText: ""
    
    property alias inProgress: animationId.running
    
    property string warningType: "" // Error/Warning/Info/Progress

    property string pathErrorIcon: "/acterna/storage/look-and-feel/generic/Pop_Up_Icon_Error.png"
    property string pathWarningIcon: "/acterna/storage/look-and-feel/generic/Pop_Up_Icon_Warning.png"
    property string pathInfoIcon: "/acterna/storage/look-and-feel/generic/Pop_Up_Icon_Info.png"
    property string path_spin_img: ViaviStyle.images.iconBusy

    property string typePath:{
        if(popUpWarning.warningType == "Info"){
            return pathInfoIcon
        } else if(popUpWarning.warningType == "Warning"){
            return pathWarningIcon
        } else if(popUpWarning.warningType == "Error"){
            return pathErrorIcon
        } else if(popUpWarning.warningType == "Progress"){
            return path_spin_img
        }

        return ""
    }

    RotationAnimation {
        id: animationId

        target: popUpWarning.imageItem
        property: "rotation"
        from: 0
        to: 360
        direction: RotationAnimation.Clockwise
        duration: ViaviStyle.waitingAnimationDuration
        loops: Animation.Infinite
    }

    exitText: clickToExitText
    iconSource: typePath
}
