import QtQuick 2.3
import libfo 1.0

import com.viavi.style 1.0

Rectangle {
   id: container
   
   color: ViaviStyle.colors.lightGray2
       
  Rectangle {
      id: loadWizard
      width: 650
      height: 100
      radius: 20
      color: ViaviStyle.colors.viaviPurple

      anchors.horizontalCenter: parent.horizontalCenter
      anchors.bottom: parent.verticalCenter
      anchors.bottomMargin: 30

      Text {
		  color: ViaviStyle.colors.white
		  anchors.fill: parent
		  text: wizardWindowManager_res_txtTestAuto.value
		  horizontalAlignment: Text.AlignHCenter
		  verticalAlignment:  Text.AlignVCenter
		  font.pixelSize: 30
      }
      
      MouseArea {
	  anchors.fill: parent
		  onClicked: {
              wizardWindowManager_act_closeConfigModeWindows.invokeWithStringArg("true")
		  }
      }
  }
  
  /* Separator */
  Rectangle {
    width: 300
    height: 6
    
    radius: 3
    
    color: ViaviStyle.colors.secondaryInfoColor
    
    anchors.centerIn: parent
  }
   
  Rectangle {
      id: loadConfig
      width: 650
      height: 100
      radius: 20
      color: ViaviStyle.colors.lightBlue

      anchors.horizontalCenter: parent.horizontalCenter
      anchors.top: parent.verticalCenter
      anchors.topMargin: 30

      Text {
		  color: ViaviStyle.colors.white
		  anchors.fill: parent
		  text: wizardWindowManager_res_txtLoadSmartConfig.value
		  horizontalAlignment: Text.AlignHCenter
		  verticalAlignment:  Text.AlignVCenter
		  font.pixelSize: 30
      }
      
      MouseArea {
	  anchors.fill: parent
		  onClicked: {
            wizardWindowManager_act_closeConfigModeWindows.invokeWithStringArg("false")
		  }
      }
  }

   Text {
       color: ViaviStyle.colors.darkGray
       anchors.top: parent.top
       anchors.right: parent.right
       anchors.margins: 10
       text: wizardWindowManager_res_txtWizardFilename.value
       horizontalAlignment: Text.AlignRight
       verticalAlignment:  Text.AlignVCenter
       font.pixelSize: 20
   }
}
