import QtQuick 2.3
import QtQuick.Controls 2.1
import QtQuick.Layouts 1.2

import com.viavi.style 1.0
import com.viavi.style.components 1.0
import libsetupmenu 1.0

ColumnLayout {
    ViaviMenuLineMultiOption{
        text: menuOtdr.alarmsPage.alarmLevel.name.text
        model: menuOtdr.alarmsPage.alarmLevel.multiOptionModel
        enabled: menuOtdr.alarmsPage.alarmLevel.enabled
        visible: menuOtdr.alarmsPage.alarmLevel.available
        
        Layout.fillWidth: true

        onSgnOptionClicked: {
            menuOtdr.alarmsPage.alarmLevel.validateOption(index)
        }
    }
ViaviMenuLineComboBox {
        id: thresholds
        text: menuOtdr.alarmsPage.thresholds.name.text
        visible: comboBoxData.visible

        comboboxWidth: ViaviStyle.layout.menuTextFieldWidthLarge

        comboBoxData.model: menuOtdr.alarmsPage.thresholds.multiOptionModel 
        comboBoxData.enabled: menuOtdr.alarmsPage.thresholds.enabled
        comboBoxData.visible: menuOtdr.alarmsPage.thresholds.available
        comboBoxData.currentIndex: menuOtdr.alarmsPage.thresholds.selectedIndex

        comboBoxData.onCurrentIndexChanged: {
            menuOtdr.alarmsPage.thresholds.validateOption(comboBoxData.currentIndex)
        }
        Connections {
            target: menuOtdr.alarmsPage.thresholds
            function onSelectedIndexChanged() {
                thresholds.comboBoxData.currentIndex = menuOtdr.alarmsPage.thresholds.selectedIndex;
            }
        }
    }

    MenuSeparator { Layout.fillWidth: true }

    PliableControl {
        title: menuOtdr.alarmsPage.eventSubcategory.name.text
        visible: menuOtdr.alarmsPage.eventSubcategory.available

        ViaviMenuLineCheckText {
            id: spliceLoss
            text: menuOtdr.alarmsPage.spliceLoss.name.text
            enabled: checkBoxData.enabled
            visible: checkBoxData.visible
            
            checkBoxData.checked: menuOtdr.alarmsPage.spliceLoss.switch
            checkBoxData.enabled: menuOtdr.alarmsPage.spliceLoss.enabled
            checkBoxData.visible: menuOtdr.alarmsPage.spliceLoss.available
            onSgnToggled: { menuOtdr.alarmsPage.spliceLoss.validateSwitch(value);}

            textData.text: menuOtdr.alarmsPage.spliceLossInput.value
            textData.enabled: menuOtdr.alarmsPage.spliceLossInput.enabled
            textData.visible: menuOtdr.alarmsPage.spliceLossInput.available
            onTextClicked: { menuOtdr.alarmsPage.spliceLossInput.validateValue(); }
        }
        ViaviMenuLineCheckText {
            id: connectorLoss
            text: menuOtdr.alarmsPage.connectorLoss.name.text
            enabled: checkBoxData.enabled
            visible: checkBoxData.visible
            
            checkBoxData.checked: menuOtdr.alarmsPage.connectorLoss.switch
            checkBoxData.enabled: menuOtdr.alarmsPage.connectorLoss.enabled
            checkBoxData.visible: menuOtdr.alarmsPage.connectorLoss.available
            onSgnToggled: { menuOtdr.alarmsPage.connectorLoss.validateSwitch(value);}

            textData.text: menuOtdr.alarmsPage.connectorLossInput.value
            textData.enabled: menuOtdr.alarmsPage.connectorLossInput.enabled
            textData.visible: menuOtdr.alarmsPage.connectorLossInput.available
            onTextClicked: { menuOtdr.alarmsPage.connectorLossInput.validateValue(); }
        }
        ViaviMenuLineCheckText {
            id: reflectance
            text: menuOtdr.alarmsPage.reflectance.name.text
            enabled: checkBoxData.enabled
            visible: checkBoxData.visible
            
            checkBoxData.checked: menuOtdr.alarmsPage.reflectance.switch
            checkBoxData.enabled: menuOtdr.alarmsPage.reflectance.enabled
            checkBoxData.visible: menuOtdr.alarmsPage.reflectance.available
            onSgnToggled: { menuOtdr.alarmsPage.reflectance.validateSwitch(value);}

            textData.text: menuOtdr.alarmsPage.reflectanceInput.value
            textData.enabled: menuOtdr.alarmsPage.reflectanceInput.enabled
            textData.visible: menuOtdr.alarmsPage.reflectanceInput.available
            onTextClicked: { menuOtdr.alarmsPage.reflectanceInput.validateValue(); }
        }
        ViaviMenuLineCheckText {
            id: muxDemux
            text: menuOtdr.alarmsPage.muxDemux.name.text
            enabled: checkBoxData.enabled
            visible: checkBoxData.visible
            
            checkBoxData.checked: menuOtdr.alarmsPage.muxDemux.switch
            checkBoxData.enabled: menuOtdr.alarmsPage.muxDemux.enabled
            checkBoxData.visible: menuOtdr.alarmsPage.muxDemux.available
            onSgnToggled: { menuOtdr.alarmsPage.muxDemux.validateSwitch(value);}

            textData.text: menuOtdr.alarmsPage.muxDemuxInput.value
            textData.enabled: menuOtdr.alarmsPage.muxDemuxInput.enabled
            textData.visible: menuOtdr.alarmsPage.muxDemuxInput.available
            onTextClicked: { menuOtdr.alarmsPage.muxDemuxInput.validateValue(); }
        }
    }

    PliableControl {
        title: menuOtdr.alarmsPage.linkSubcategory.name.text
        plied: true
        visible: menuOtdr.alarmsPage.linkSubcategory.available

        //curently disable this until further notice from marketing
        //on fully enabling/disabling this
        //ViaviMenuLineCheckBox { text: 'Slope' }

        

        GridLayout {
            id: linkLossRow

            columns: 2
            Layout.fillWidth: true
            columnSpacing: ViaviStyle.layout.largeMargin

            ViaviMenuLineCheckText {
                id: orl
                
                Layout.fillWidth: true
                tailContentFillWidth: true
                textWidth: ViaviStyle.layout.menuTitleWidthSmall

                text: menuOtdr.alarmsPage.orl.name.text
                enabled: checkBoxData.enabled
                visible: checkBoxData.visible
                
                checkBoxData.checked: menuOtdr.alarmsPage.orl.switch
                checkBoxData.enabled: menuOtdr.alarmsPage.orl.enabled
                checkBoxData.visible: menuOtdr.alarmsPage.orl.available
                onSgnToggled: { menuOtdr.alarmsPage.orl.validateSwitch(value);}

                textData.text: menuOtdr.alarmsPage.orlInput.value
                textData.enabled: menuOtdr.alarmsPage.orlInput.enabled
                textData.visible: menuOtdr.alarmsPage.orlInput.available
                onTextClicked: { menuOtdr.alarmsPage.orlInput.validateValue(); }
            }

            Item{
                Layout.fillWidth: true
                implicitWidth: orl.implicitWidth
                width: orl.width
            }

            //NOTE: changes between combo and edit depending on other state
            ViaviMenuLineCheckText {
                id: linkLossMin

                Layout.fillWidth: true
                tailContentFillWidth: true
                textWidth: ViaviStyle.layout.menuTitleWidthSmall

                text: menuOtdr.alarmsPage.linkLossMin.name.text
                enabled: checkBoxData.enabled
                visible: checkBoxData.visible
                
                checkBoxData.checked: menuOtdr.alarmsPage.linkLossMin.switch
                checkBoxData.enabled: menuOtdr.alarmsPage.linkLossMin.enabled
                checkBoxData.visible: menuOtdr.alarmsPage.linkLossMin.available
                onSgnToggled: { menuOtdr.alarmsPage.linkLossMin.validateSwitch(value);}

                textData.text: menuOtdr.alarmsPage.linkLossMinInput.value
                textData.enabled: menuOtdr.alarmsPage.linkLossMinInput.enabled
                textData.visible: menuOtdr.alarmsPage.linkLossMinInput.available
                onTextClicked: { menuOtdr.alarmsPage.linkLossMinInput.validateValue(); }
            }
            ViaviMenuLineCheckText {
                id: linkLossMax

                Layout.fillWidth: true
                tailContentFillWidth: true
                textWidth: ViaviStyle.layout.menuTitleWidthSmall
                text: menuOtdr.alarmsPage.linkLossMax.name.text
                enabled: checkBoxData.enabled
                visible: checkBoxData.visible
                
                checkBoxData.checked: menuOtdr.alarmsPage.linkLossMax.switch
                checkBoxData.enabled: menuOtdr.alarmsPage.linkLossMax.enabled
                checkBoxData.visible: menuOtdr.alarmsPage.linkLossMax.available
                onSgnToggled: { menuOtdr.alarmsPage.linkLossMax.validateSwitch(value);}

                textData.text: menuOtdr.alarmsPage.linkLossMaxInput.value
                textData.enabled: menuOtdr.alarmsPage.linkLossMaxInput.enabled
                textData.visible: menuOtdr.alarmsPage.linkLossMaxInput.available
                onTextClicked: { menuOtdr.alarmsPage.linkLossMaxInput.validateValue(); }
            }


            ViaviMenuLineComboText {
                id: linkLossMaxPon

                Layout.fillWidth: true
                tailContentFillWidth: true
                textWidth: ViaviStyle.layout.menuTitleWidthSmall
                text: menuOtdr.alarmsPage.linkLossMaxPonCombo.name.text
                enabled: comboBoxData.enabled
                visible: comboBoxData.visible

                comboBoxData.visible: menuOtdr.alarmsPage.linkLossMaxPonCombo.available
                comboBoxData.enabled: menuOtdr.alarmsPage.linkLossMaxPonCombo.enabled
                comboBoxData.model: menuOtdr.alarmsPage.linkLossMaxPonCombo.multiOptionModel
                comboBoxData.onCurrentIndexChanged: {
                    menuOtdr.alarmsPage.linkLossMaxPonCombo.validateOption(comboBoxData.currentIndex)
                }

                Connections {
                    target:  menuOtdr.alarmsPage.linkLossMaxPonCombo
                    function onSelectedIndexChanged() { 
                        linkLossMaxPon.comboBoxData.currentIndex = menuOtdr.alarmsPage.linkLossMaxPonCombo.selectedIndex
                    }
                }

                comboBoxData.currentIndex: menuOtdr.alarmsPage.linkLossMaxPonCombo.selectedIndex

                textData.text: menuOtdr.alarmsPage.linkLossMaxPonInput.value
                textData.enabled: menuOtdr.alarmsPage.linkLossMaxPonInput.enabled
                textData.visible: menuOtdr.alarmsPage.linkLossMaxPonInput.available
                onTextClicked: { menuOtdr.alarmsPage.linkLossMaxPonInput.validateValue(); }
            }
        }
    }

    PliableControl {
        title: menuOtdr.alarmsPage.fiberSubcategory.name.text
        plied: true
        visible: menuOtdr.alarmsPage.fiberSubcategory.available
        GridLayout {
            columns: 2
            Layout.fillWidth: true
            columnSpacing: ViaviStyle.layout.largeMargin

            ViaviMenuLineCheckText {
                id: fiberLengthMin

                Layout.fillWidth: true
                tailContentFillWidth: true
                textWidth: ViaviStyle.layout.menuTitleWidthSmall

                text: menuOtdr.alarmsPage.fiberLengthMin.name.text
                enabled: checkBoxData.enabled
                visible: checkBoxData.visible
                
                checkBoxData.checked: menuOtdr.alarmsPage.fiberLengthMin.switch
                checkBoxData.enabled: menuOtdr.alarmsPage.fiberLengthMin.enabled
                checkBoxData.visible: menuOtdr.alarmsPage.fiberLengthMin.available
                onSgnToggled: { menuOtdr.alarmsPage.fiberLengthMin.validateSwitch(value);}

                textData.text: menuOtdr.alarmsPage.fiberLengthMinInput.value
                textData.enabled: menuOtdr.alarmsPage.fiberLengthMinInput.enabled
                textData.visible: menuOtdr.alarmsPage.fiberLengthMinInput.available
                onTextClicked: { menuOtdr.alarmsPage.fiberLengthMinInput.validateValue(); }
            }
            ViaviMenuLineCheckText {
                id: fiberLengthMax

                Layout.fillWidth: true
                tailContentFillWidth: true
                textWidth: ViaviStyle.layout.menuTitleWidthSmall

                text: menuOtdr.alarmsPage.fiberLengthMax.name.text
                enabled: checkBoxData.enabled
                visible: checkBoxData.visible
                
                checkBoxData.checked: menuOtdr.alarmsPage.fiberLengthMax.switch
                checkBoxData.enabled: menuOtdr.alarmsPage.fiberLengthMax.enabled
                checkBoxData.visible: menuOtdr.alarmsPage.fiberLengthMax.available
                onSgnToggled: { menuOtdr.alarmsPage.fiberLengthMax.validateSwitch(value);}

                textData.text: menuOtdr.alarmsPage.fiberLengthMaxInput.value
                textData.enabled: menuOtdr.alarmsPage.fiberLengthMaxInput.enabled
                textData.visible: menuOtdr.alarmsPage.fiberLengthMaxInput.available
                onTextClicked: { menuOtdr.alarmsPage.fiberLengthMaxInput.validateValue(); }
            }
        }
    }

    PliableControl {
        title: menuOtdr.alarmsPage.slopeSubcategory.name.text
        plied: true
        visible: menuOtdr.alarmsPage.slopeSubcategory.available

        GridLayout {
            columns: 2
            Layout.fillWidth: true
            columnSpacing: ViaviStyle.layout.largeMargin

            ViaviMenuLineCheckText {
                id: slope850mm

                Layout.fillWidth: true
                tailContentFillWidth: true
                textWidth: ViaviStyle.layout.menuTitleWidthSmall

                text: menuOtdr.alarmsPage.slope850mm.name.text
                enabled: checkBoxData.enabled
                visible: checkBoxData.visible
                
                checkBoxData.checked: menuOtdr.alarmsPage.slope850mm.switch
                checkBoxData.enabled: menuOtdr.alarmsPage.slope850mm.enabled
                checkBoxData.visible: menuOtdr.alarmsPage.slope850mm.available
                onSgnToggled: { menuOtdr.alarmsPage.slope850mm.validateSwitch(value);}

                textData.text: menuOtdr.alarmsPage.slope850mmInput.value
                textData.enabled: menuOtdr.alarmsPage.slope850mmInput.enabled
                textData.visible: menuOtdr.alarmsPage.slope850mmInput.available
                onTextClicked: { menuOtdr.alarmsPage.slope850mmInput.validateValue(); }
            }
            ViaviMenuLineCheckText {
                id: slope1300mm

                Layout.fillWidth: true
                tailContentFillWidth: true
                textWidth: ViaviStyle.layout.menuTitleWidthSmall

                text: menuOtdr.alarmsPage.slope1300mm.name.text
                enabled: checkBoxData.enabled 
                visible: checkBoxData.visible
                
                checkBoxData.checked: menuOtdr.alarmsPage.slope1300mm.switch
                checkBoxData.enabled: menuOtdr.alarmsPage.slope1300mm.enabled
                checkBoxData.visible: menuOtdr.alarmsPage.slope1300mm.available
                onSgnToggled: { menuOtdr.alarmsPage.slope1300mm.validateSwitch(value);}

                textData.text: menuOtdr.alarmsPage.slope1300mmInput.value
                textData.enabled: menuOtdr.alarmsPage.slope1300mmInput.enabled
                textData.visible: menuOtdr.alarmsPage.slope1300mmInput.available
                onTextClicked: { menuOtdr.alarmsPage.slope1300mmInput.validateValue(); }
            }

            ViaviMenuLineCheckText {
                id: slope1310sm

                Layout.fillWidth: true
                tailContentFillWidth: true
                textWidth: ViaviStyle.layout.menuTitleWidthSmall

                text: menuOtdr.alarmsPage.slope1310sm.name.text
                enabled: checkBoxData.enabled
                visible: checkBoxData.visible
                
                checkBoxData.checked: menuOtdr.alarmsPage.slope1310sm.switch
                checkBoxData.enabled: menuOtdr.alarmsPage.slope1310sm.enabled
                checkBoxData.visible: menuOtdr.alarmsPage.slope1310sm.available
                onSgnToggled: { menuOtdr.alarmsPage.slope1310sm.validateSwitch(value);}

                textData.text: menuOtdr.alarmsPage.slope1310smInput.value
                textData.enabled: menuOtdr.alarmsPage.slope1310smInput.enabled
                textData.visible: menuOtdr.alarmsPage.slope1310smInput.available
                onTextClicked: { menuOtdr.alarmsPage.slope1310smInput.validateValue(); }
            }
            ViaviMenuLineCheckText {
                id: slope1360_1520sm
                
                Layout.fillWidth: true
                tailContentFillWidth: true
                textWidth: ViaviStyle.layout.menuTitleWidthSmall

                text: menuOtdr.alarmsPage.slope1360_1520sm.name.text
                enabled: checkBoxData.enabled
                visible: checkBoxData.visible
                
                checkBoxData.checked: menuOtdr.alarmsPage.slope1360_1520sm.switch
                checkBoxData.enabled: menuOtdr.alarmsPage.slope1360_1520sm.enabled
                checkBoxData.visible: menuOtdr.alarmsPage.slope1360_1520sm.available
                onSgnToggled: { menuOtdr.alarmsPage.slope1360_1520sm.validateSwitch(value);}

                textData.text: menuOtdr.alarmsPage.slope1360_1520smInput.value
                textData.enabled: menuOtdr.alarmsPage.slope1360_1520smInput.enabled
                textData.visible: menuOtdr.alarmsPage.slope1360_1520smInput.available
                onTextClicked: { menuOtdr.alarmsPage.slope1360_1520smInput.validateValue(); }
            }

            ViaviMenuLineCheckText {
                id: slope1550sm

                Layout.fillWidth: true
                tailContentFillWidth: true
                textWidth: ViaviStyle.layout.menuTitleWidthSmall

                text: menuOtdr.alarmsPage.slope1550sm.name.text
                enabled: checkBoxData.enabled
                visible: checkBoxData.visible
                
                checkBoxData.checked: menuOtdr.alarmsPage.slope1550sm.switch
                checkBoxData.enabled: menuOtdr.alarmsPage.slope1550sm.enabled
                checkBoxData.visible: menuOtdr.alarmsPage.slope1550sm.available
                onSgnToggled: { menuOtdr.alarmsPage.slope1550sm.validateSwitch(value);}

                textData.text: menuOtdr.alarmsPage.slope1550smInput.value
                textData.enabled: menuOtdr.alarmsPage.slope1550smInput.enabled
                textData.visible: menuOtdr.alarmsPage.slope1550smInput.available
                onTextClicked: { menuOtdr.alarmsPage.slope1550smInput.validateValue(); }
            }
            ViaviMenuLineCheckText {
                id: slope1590_1650sm

                Layout.fillWidth: true
                tailContentFillWidth: true
                textWidth: ViaviStyle.layout.menuTitleWidthSmall
                text: menuOtdr.alarmsPage.slope1590_1650sm.name.text
                enabled: checkBoxData.enabled
                visible: checkBoxData.visible
                
                checkBoxData.checked: menuOtdr.alarmsPage.slope1590_1650sm.switch
                checkBoxData.enabled: menuOtdr.alarmsPage.slope1590_1650sm.enabled
                checkBoxData.visible: menuOtdr.alarmsPage.slope1590_1650sm.available
                onSgnToggled: { menuOtdr.alarmsPage.slope1590_1650sm.validateSwitch(value);}

                textData.text: menuOtdr.alarmsPage.slope1590_1650smInput.value
                textData.enabled: menuOtdr.alarmsPage.slope1590_1650smInput.enabled
                textData.visible: menuOtdr.alarmsPage.slope1590_1650smInput.available
                onTextClicked: { menuOtdr.alarmsPage.slope1590_1650smInput.validateValue(); }
            }
        }
    }

    PliableControl {
        title: menuOtdr.alarmsPage.splitterSubcategory.name.text
        plied: true
        visible: menuOtdr.alarmsPage.splitterSubcategory.available

        ViaviMenuLineCheckText {
            id: splitter1x2
            text: menuOtdr.alarmsPage.splitter1x2.name.text
            enabled: checkBoxData.enabled
            visible: checkBoxData.visible
            
            checkBoxData.checked: menuOtdr.alarmsPage.splitter1x2.switch
            checkBoxData.enabled: menuOtdr.alarmsPage.splitter1x2.enabled
            checkBoxData.visible: menuOtdr.alarmsPage.splitter1x2.available
            onSgnToggled: { menuOtdr.alarmsPage.splitter1x2.validateSwitch(value);}

            textData.text: menuOtdr.alarmsPage.splitter1x2Input.value
            textData.enabled: menuOtdr.alarmsPage.splitter1x2Input.enabled
            textData.visible: menuOtdr.alarmsPage.splitter1x2Input.available
            onTextClicked: { menuOtdr.alarmsPage.splitter1x2Input.validateValue(); }
        }
        ViaviMenuLineCheckText {
            id: splitter1x4
            text: menuOtdr.alarmsPage.splitter1x4.name.text
            enabled: checkBoxData.enabled
            visible: checkBoxData.visible
            
            checkBoxData.checked: menuOtdr.alarmsPage.splitter1x4.switch
            checkBoxData.enabled: menuOtdr.alarmsPage.splitter1x4.enabled
            checkBoxData.visible: menuOtdr.alarmsPage.splitter1x4.available
            onSgnToggled: { menuOtdr.alarmsPage.splitter1x4.validateSwitch(value);}

            textData.text: menuOtdr.alarmsPage.splitter1x4Input.value
            textData.enabled: menuOtdr.alarmsPage.splitter1x4Input.enabled
            textData.visible: menuOtdr.alarmsPage.splitter1x4Input.available
            onTextClicked: { menuOtdr.alarmsPage.splitter1x4Input.validateValue(); }
        }
        ViaviMenuLineCheckText {
            id: splitter1x8
            text: menuOtdr.alarmsPage.splitter1x8.name.text
            enabled: checkBoxData.enabled
            visible: checkBoxData.visible
            
            checkBoxData.checked: menuOtdr.alarmsPage.splitter1x8.switch
            checkBoxData.enabled: menuOtdr.alarmsPage.splitter1x8.enabled
            checkBoxData.visible: menuOtdr.alarmsPage.splitter1x8.available
            onSgnToggled: { menuOtdr.alarmsPage.splitter1x8.validateSwitch(value);}

            textData.text: menuOtdr.alarmsPage.splitter1x8Input.value
            textData.enabled: menuOtdr.alarmsPage.splitter1x8Input.enabled
            textData.visible: menuOtdr.alarmsPage.splitter1x8Input.available
            onTextClicked: { menuOtdr.alarmsPage.splitter1x8Input.validateValue(); }
        }
        ViaviMenuLineCheckText {
            id: splitter1x16
            text: menuOtdr.alarmsPage.splitter1x16.name.text
            enabled: checkBoxData.enabled
            visible: checkBoxData.visible
            
            checkBoxData.checked: menuOtdr.alarmsPage.splitter1x16.switch
            checkBoxData.enabled: menuOtdr.alarmsPage.splitter1x16.enabled
            checkBoxData.visible: menuOtdr.alarmsPage.splitter1x16.available
            onSgnToggled: { menuOtdr.alarmsPage.splitter1x16.validateSwitch(value);}

            textData.text: menuOtdr.alarmsPage.splitter1x16Input.value
            textData.enabled: menuOtdr.alarmsPage.splitter1x16Input.enabled
            textData.visible: menuOtdr.alarmsPage.splitter1x16Input.available
            onTextClicked: { menuOtdr.alarmsPage.splitter1x16Input.validateValue(); }
        }
        ViaviMenuLineCheckText {
            id: splitter1x32
            text: menuOtdr.alarmsPage.splitter1x32.name.text
            enabled: checkBoxData.enabled
            visible: checkBoxData.visible
            
            checkBoxData.checked: menuOtdr.alarmsPage.splitter1x32.switch
            checkBoxData.enabled: menuOtdr.alarmsPage.splitter1x32.enabled
            checkBoxData.visible: menuOtdr.alarmsPage.splitter1x32.available
            onSgnToggled: { menuOtdr.alarmsPage.splitter1x32.validateSwitch(value);}

            textData.text: menuOtdr.alarmsPage.splitter1x32Input.value
            textData.enabled: menuOtdr.alarmsPage.splitter1x32Input.enabled
            textData.visible: menuOtdr.alarmsPage.splitter1x32Input.available
            onTextClicked: { menuOtdr.alarmsPage.splitter1x32Input.validateValue(); }
        }
        ViaviMenuLineCheckText {
            id: splitter1x64
            text: menuOtdr.alarmsPage.splitter1x64.name.text
            enabled: checkBoxData.enabled
            visible: checkBoxData.visible
            
            checkBoxData.checked: menuOtdr.alarmsPage.splitter1x64.switch
            checkBoxData.enabled: menuOtdr.alarmsPage.splitter1x64.enabled
            checkBoxData.visible: menuOtdr.alarmsPage.splitter1x64.available
            onSgnToggled: { menuOtdr.alarmsPage.splitter1x64.validateSwitch(value);}

            textData.text: menuOtdr.alarmsPage.splitter1x64Input.value
            textData.enabled: menuOtdr.alarmsPage.splitter1x64Input.enabled
            textData.visible: menuOtdr.alarmsPage.splitter1x64Input.available
            onTextClicked: { menuOtdr.alarmsPage.splitter1x64Input.validateValue(); }
        }
        ViaviMenuLineCheckText {
            id: splitter1x128
            text: menuOtdr.alarmsPage.splitter1x128.name.text
            enabled: checkBoxData.enabled
            visible: checkBoxData.visible
            
            checkBoxData.checked: menuOtdr.alarmsPage.splitter1x128.switch
            checkBoxData.enabled: menuOtdr.alarmsPage.splitter1x128.enabled
            checkBoxData.visible: menuOtdr.alarmsPage.splitter1x128.available
            onSgnToggled: { menuOtdr.alarmsPage.splitter1x128.validateSwitch(value);}

            textData.text: menuOtdr.alarmsPage.splitter1x128Input.value
            textData.enabled: menuOtdr.alarmsPage.splitter1x128Input.enabled
            textData.visible: menuOtdr.alarmsPage.splitter1x128Input.available
            onTextClicked: { menuOtdr.alarmsPage.splitter1x128Input.validateValue(); }
        }
    }

    PliableControl {
        title: menuOtdr.alarmsPage.unbalancedSubcategory.name.text
        plied: true
        visible: menuOtdr.alarmsPage.unbalancedSubcategory.available
        GridLayout {
            columns: 2
            Layout.fillWidth: true
            columnSpacing: ViaviStyle.layout.largeMargin

            ViaviMenuLineCheckText {
                id: unbalancedTaps99_1

                Layout.fillWidth: true
                tailContentFillWidth: true
                textWidth: ViaviStyle.layout.menuTitleWidthSmall

                text: menuOtdr.alarmsPage.unbalancedTaps99_1.name.text
                enabled: checkBoxData.enabled
                visible: checkBoxData.visible
                
                checkBoxData.checked: menuOtdr.alarmsPage.unbalancedTaps99_1.switch
                checkBoxData.enabled: menuOtdr.alarmsPage.unbalancedTaps99_1.enabled
                checkBoxData.visible: menuOtdr.alarmsPage.unbalancedTaps99_1.available
                onSgnToggled: { menuOtdr.alarmsPage.unbalancedTaps99_1.validateSwitch(value);}

                textData.text: menuOtdr.alarmsPage.unbalancedTaps99_1Input.value
                textData.enabled: menuOtdr.alarmsPage.unbalancedTaps99_1Input.enabled
                textData.visible: menuOtdr.alarmsPage.unbalancedTaps99_1Input.available
                onTextClicked: { menuOtdr.alarmsPage.unbalancedTaps99_1Input.validateValue(); }
            }
            ViaviMenuLineCheckText {
                id: unbalancedTaps80_20

                Layout.fillWidth: true
                tailContentFillWidth: true
                textWidth: ViaviStyle.layout.menuTitleWidthSmall

                text: menuOtdr.alarmsPage.unbalancedTaps80_20.name.text
                enabled: checkBoxData.enabled
                visible: checkBoxData.visible
                
                checkBoxData.checked: menuOtdr.alarmsPage.unbalancedTaps80_20.switch
                checkBoxData.enabled: menuOtdr.alarmsPage.unbalancedTaps80_20.enabled
                checkBoxData.visible: menuOtdr.alarmsPage.unbalancedTaps80_20.available
                onSgnToggled: { menuOtdr.alarmsPage.unbalancedTaps80_20.validateSwitch(value);}

                textData.text: menuOtdr.alarmsPage.unbalancedTaps80_20Input.value
                textData.enabled: menuOtdr.alarmsPage.unbalancedTaps80_20Input.enabled
                textData.visible: menuOtdr.alarmsPage.unbalancedTaps80_20Input.available
                onTextClicked: { menuOtdr.alarmsPage.unbalancedTaps80_20Input.validateValue(); }
            }
            ViaviMenuLineCheckText {
                id: unbalancedTaps98_2

                Layout.fillWidth: true
                tailContentFillWidth: true
                textWidth: ViaviStyle.layout.menuTitleWidthSmall
                text: menuOtdr.alarmsPage.unbalancedTaps98_2.name.text
                enabled: checkBoxData.enabled
                visible: checkBoxData.visible
                
                checkBoxData.checked: menuOtdr.alarmsPage.unbalancedTaps98_2.switch
                checkBoxData.enabled: menuOtdr.alarmsPage.unbalancedTaps98_2.enabled
                checkBoxData.visible: menuOtdr.alarmsPage.unbalancedTaps98_2.available
                onSgnToggled: { menuOtdr.alarmsPage.unbalancedTaps98_2.validateSwitch(value);}

                textData.text: menuOtdr.alarmsPage.unbalancedTaps98_2Input.value
                textData.enabled: menuOtdr.alarmsPage.unbalancedTaps98_2Input.enabled
                textData.visible: menuOtdr.alarmsPage.unbalancedTaps98_2Input.available
                onTextClicked: { menuOtdr.alarmsPage.unbalancedTaps98_2Input.validateValue(); }
            }
            ViaviMenuLineCheckText {
                id: unbalancedTaps75_25

                Layout.fillWidth: true
                tailContentFillWidth: true
                textWidth: ViaviStyle.layout.menuTitleWidthSmall

                text: menuOtdr.alarmsPage.unbalancedTaps75_25.name.text
                enabled: checkBoxData.enabled
                visible: checkBoxData.visible
                
                checkBoxData.checked: menuOtdr.alarmsPage.unbalancedTaps75_25.switch
                checkBoxData.enabled: menuOtdr.alarmsPage.unbalancedTaps75_25.enabled
                checkBoxData.visible: menuOtdr.alarmsPage.unbalancedTaps75_25.available
                onSgnToggled: { menuOtdr.alarmsPage.unbalancedTaps75_25.validateSwitch(value);}

                textData.text: menuOtdr.alarmsPage.unbalancedTaps75_25Input.value
                textData.enabled: menuOtdr.alarmsPage.unbalancedTaps75_25Input.enabled
                textData.visible: menuOtdr.alarmsPage.unbalancedTaps75_25Input.available
                onTextClicked: { menuOtdr.alarmsPage.unbalancedTaps75_25Input.validateValue(); }
            }
            ViaviMenuLineCheckText {
                id: unbalancedTaps97_3

                Layout.fillWidth: true
                tailContentFillWidth: true
                textWidth: ViaviStyle.layout.menuTitleWidthSmall

                text: menuOtdr.alarmsPage.unbalancedTaps97_3.name.text
                enabled: checkBoxData.enabled
                visible: checkBoxData.visible
                
                checkBoxData.checked: menuOtdr.alarmsPage.unbalancedTaps97_3.switch
                checkBoxData.enabled: menuOtdr.alarmsPage.unbalancedTaps97_3.enabled
                checkBoxData.visible: menuOtdr.alarmsPage.unbalancedTaps97_3.available
                onSgnToggled: { menuOtdr.alarmsPage.unbalancedTaps97_3.validateSwitch(value);}

                textData.text: menuOtdr.alarmsPage.unbalancedTaps97_3Input.value
                textData.enabled: menuOtdr.alarmsPage.unbalancedTaps97_3Input.enabled
                textData.visible: menuOtdr.alarmsPage.unbalancedTaps97_3Input.available
                onTextClicked: { menuOtdr.alarmsPage.unbalancedTaps97_3Input.validateValue(); }
            }
            ViaviMenuLineCheckText {
                id: unbalancedTaps70_30

                Layout.fillWidth: true
                tailContentFillWidth: true
                textWidth: ViaviStyle.layout.menuTitleWidthSmall

                text: menuOtdr.alarmsPage.unbalancedTaps70_30.name.text
                enabled: checkBoxData.enabled
                visible: checkBoxData.visible
                
                checkBoxData.checked: menuOtdr.alarmsPage.unbalancedTaps70_30.switch
                checkBoxData.enabled: menuOtdr.alarmsPage.unbalancedTaps70_30.enabled
                checkBoxData.visible: menuOtdr.alarmsPage.unbalancedTaps70_30.available
                onSgnToggled: { menuOtdr.alarmsPage.unbalancedTaps70_30.validateSwitch(value);}

                textData.text: menuOtdr.alarmsPage.unbalancedTaps70_30Input.value
                textData.enabled: menuOtdr.alarmsPage.unbalancedTaps70_30Input.enabled
                textData.visible: menuOtdr.alarmsPage.unbalancedTaps70_30Input.available
                onTextClicked: { menuOtdr.alarmsPage.unbalancedTaps70_30Input.validateValue(); }
            }
            ViaviMenuLineCheckText {
                id: unbalancedTaps95_5

                Layout.fillWidth: true
                tailContentFillWidth: true
                textWidth: ViaviStyle.layout.menuTitleWidthSmall

                text: menuOtdr.alarmsPage.unbalancedTaps95_5.name.text
                enabled: checkBoxData.enabled
                visible: checkBoxData.visible
                
                checkBoxData.checked: menuOtdr.alarmsPage.unbalancedTaps95_5.switch
                checkBoxData.enabled: menuOtdr.alarmsPage.unbalancedTaps95_5.enabled
                checkBoxData.visible: menuOtdr.alarmsPage.unbalancedTaps95_5.available
                onSgnToggled: { menuOtdr.alarmsPage.unbalancedTaps95_5.validateSwitch(value);}

                textData.text: menuOtdr.alarmsPage.unbalancedTaps95_5Input.value
                textData.enabled: menuOtdr.alarmsPage.unbalancedTaps95_5Input.enabled
                textData.visible: menuOtdr.alarmsPage.unbalancedTaps95_5Input.available
                onTextClicked: { menuOtdr.alarmsPage.unbalancedTaps95_5Input.validateValue(); }
            }
            ViaviMenuLineCheckText {
                id: unbalancedTaps65_35

                Layout.fillWidth: true
                tailContentFillWidth: true
                textWidth: ViaviStyle.layout.menuTitleWidthSmall
                text: menuOtdr.alarmsPage.unbalancedTaps65_35.name.text
                enabled: checkBoxData.enabled
                visible: checkBoxData.visible
                
                checkBoxData.checked: menuOtdr.alarmsPage.unbalancedTaps65_35.switch
                checkBoxData.enabled: menuOtdr.alarmsPage.unbalancedTaps65_35.enabled
                checkBoxData.visible: menuOtdr.alarmsPage.unbalancedTaps65_35.available
                onSgnToggled: { menuOtdr.alarmsPage.unbalancedTaps65_35.validateSwitch(value);}

                textData.text: menuOtdr.alarmsPage.unbalancedTaps65_35Input.value
                textData.enabled: menuOtdr.alarmsPage.unbalancedTaps65_35Input.enabled
                textData.visible: menuOtdr.alarmsPage.unbalancedTaps65_35Input.available
                onTextClicked: { menuOtdr.alarmsPage.unbalancedTaps65_35Input.validateValue(); }
            }
            ViaviMenuLineCheckText {
                id: unbalancedTaps93_7

                Layout.fillWidth: true
                tailContentFillWidth: true
                textWidth: ViaviStyle.layout.menuTitleWidthSmall

                text: menuOtdr.alarmsPage.unbalancedTaps93_7.name.text
                enabled: checkBoxData.enabled
                visible: checkBoxData.visible
                
                checkBoxData.checked: menuOtdr.alarmsPage.unbalancedTaps93_7.switch
                checkBoxData.enabled: menuOtdr.alarmsPage.unbalancedTaps93_7.enabled
                checkBoxData.visible: menuOtdr.alarmsPage.unbalancedTaps93_7.available
                onSgnToggled: { menuOtdr.alarmsPage.unbalancedTaps93_7.validateSwitch(value);}

                textData.text: menuOtdr.alarmsPage.unbalancedTaps93_7Input.value
                textData.enabled: menuOtdr.alarmsPage.unbalancedTaps93_7Input.enabled
                textData.visible: menuOtdr.alarmsPage.unbalancedTaps93_7Input.available
                onTextClicked: { menuOtdr.alarmsPage.unbalancedTaps93_7Input.validateValue(); }
            }
            ViaviMenuLineCheckText {
                id: unbalancedTaps60_40

                Layout.fillWidth: true
                tailContentFillWidth: true
                textWidth: ViaviStyle.layout.menuTitleWidthSmall

                text: menuOtdr.alarmsPage.unbalancedTaps60_40.name.text
                enabled: checkBoxData.enabled
                visible: checkBoxData.visible
                
                checkBoxData.checked: menuOtdr.alarmsPage.unbalancedTaps60_40.switch
                checkBoxData.enabled: menuOtdr.alarmsPage.unbalancedTaps60_40.enabled
                checkBoxData.visible: menuOtdr.alarmsPage.unbalancedTaps60_40.available
                onSgnToggled: { menuOtdr.alarmsPage.unbalancedTaps60_40.validateSwitch(value);}

                textData.text: menuOtdr.alarmsPage.unbalancedTaps60_40Input.value
                textData.enabled: menuOtdr.alarmsPage.unbalancedTaps60_40Input.enabled
                textData.visible: menuOtdr.alarmsPage.unbalancedTaps60_40Input.available
                onTextClicked: { menuOtdr.alarmsPage.unbalancedTaps60_40Input.validateValue(); }
            }
            ViaviMenuLineCheckText {
                id: unbalancedTaps90_10 

                Layout.fillWidth: true
                tailContentFillWidth: true
                textWidth: ViaviStyle.layout.menuTitleWidthSmall

                text: menuOtdr.alarmsPage.unbalancedTaps90_10.name.text
                enabled: checkBoxData.enabled
                visible: checkBoxData.visible
                
                checkBoxData.checked: menuOtdr.alarmsPage.unbalancedTaps90_10.switch
                checkBoxData.enabled: menuOtdr.alarmsPage.unbalancedTaps90_10.enabled
                checkBoxData.visible: menuOtdr.alarmsPage.unbalancedTaps90_10.available
                onSgnToggled: { menuOtdr.alarmsPage.unbalancedTaps90_10.validateSwitch(value);}

                textData.text: menuOtdr.alarmsPage.unbalancedTaps90_10Input.value
                textData.enabled: menuOtdr.alarmsPage.unbalancedTaps90_10Input.enabled
                textData.visible: menuOtdr.alarmsPage.unbalancedTaps90_10Input.available
                onTextClicked: { menuOtdr.alarmsPage.unbalancedTaps90_10Input.validateValue(); }
            }
            ViaviMenuLineCheckText {
                id: unbalancedTaps55_45 
                
                Layout.fillWidth: true
                tailContentFillWidth: true
                textWidth: ViaviStyle.layout.menuTitleWidthSmall

                text: menuOtdr.alarmsPage.unbalancedTaps55_45.name.text
                enabled: checkBoxData.enabled
                visible: checkBoxData.visible
                
                checkBoxData.checked: menuOtdr.alarmsPage.unbalancedTaps55_45.switch
                checkBoxData.enabled: menuOtdr.alarmsPage.unbalancedTaps55_45.enabled
                checkBoxData.visible: menuOtdr.alarmsPage.unbalancedTaps55_45.available
                onSgnToggled: { menuOtdr.alarmsPage.unbalancedTaps55_45.validateSwitch(value);}

                textData.text: menuOtdr.alarmsPage.unbalancedTaps55_45Input.value
                textData.enabled: menuOtdr.alarmsPage.unbalancedTaps55_45Input.enabled
                textData.visible: menuOtdr.alarmsPage.unbalancedTaps55_45Input.available
                onTextClicked: { menuOtdr.alarmsPage.unbalancedTaps55_45Input.validateValue(); }
            }
            ViaviMenuLineCheckText {
                id: unbalancedTaps85_15 

                Layout.fillWidth: true
                tailContentFillWidth: true
                textWidth: ViaviStyle.layout.menuTitleWidthSmall

                text: menuOtdr.alarmsPage.unbalancedTaps85_15.name.text
                enabled: checkBoxData.enabled
                visible: checkBoxData.visible
                
                checkBoxData.checked: menuOtdr.alarmsPage.unbalancedTaps85_15.switch
                checkBoxData.enabled: menuOtdr.alarmsPage.unbalancedTaps85_15.enabled
                checkBoxData.visible: menuOtdr.alarmsPage.unbalancedTaps85_15.available
                onSgnToggled: { menuOtdr.alarmsPage.unbalancedTaps85_15.validateSwitch(value);}

                textData.text: menuOtdr.alarmsPage.unbalancedTaps85_15Input.value
                textData.enabled: menuOtdr.alarmsPage.unbalancedTaps85_15Input.enabled
                textData.visible: menuOtdr.alarmsPage.unbalancedTaps85_15Input.available
                onTextClicked: { menuOtdr.alarmsPage.unbalancedTaps85_15Input.validateValue(); }
            }
            ViaviMenuLineCheckText {
                id: unbalancedTaps50_50 

                Layout.fillWidth: true
                tailContentFillWidth: true
                textWidth: ViaviStyle.layout.menuTitleWidthSmall

                text: menuOtdr.alarmsPage.unbalancedTaps50_50.name.text
                enabled: checkBoxData.enabled
                visible: checkBoxData.visible
                
                checkBoxData.checked: menuOtdr.alarmsPage.unbalancedTaps50_50.switch
                checkBoxData.enabled: menuOtdr.alarmsPage.unbalancedTaps50_50.enabled
                checkBoxData.visible: menuOtdr.alarmsPage.unbalancedTaps50_50.available
                onSgnToggled: { menuOtdr.alarmsPage.unbalancedTaps50_50.validateSwitch(value);}

                textData.text: menuOtdr.alarmsPage.unbalancedTaps50_50Input.value
                textData.enabled: menuOtdr.alarmsPage.unbalancedTaps50_50Input.enabled
                textData.visible: menuOtdr.alarmsPage.unbalancedTaps50_50Input.available
                onTextClicked: { menuOtdr.alarmsPage.unbalancedTaps50_50Input.validateValue(); }
            }
        }
    }
    Item {
        id: spacer
        Layout.fillHeight: true
    }
}

