import QtQuick 2.3
import libfo 1.0

import com.viavi.style 1.0

Rectangle {
    id: container
    
    color: "transparent"

    property int rowSpacing: 4
    property int dotwidth: 4

    property bool isIconElement: EvtType == SchematicViewEventDescription.CShematic_Event_Icons
    property bool isDotElement: EvtType == SchematicViewEventDescription.CShematic_Event_Dot_Line
    property bool isLineElement: EvtType == SchematicViewEventDescription.CShematic_Event_Line
    property bool isMtsElement: EvtType == SchematicViewEventDescription.CShematic_Event_Mts

    property bool isSelected: IsCurrentEvent
    
    // return alarm color due to AlarmStatus value
    function getAlarmColor( AlarmStatus ) 
    {
      var alarm_color = ViaviStyle.colors.slmPurple
      
      switch( AlarmStatus )
      {
      case -2:
         alarm_color = ViaviStyle.colors.yellow;
         break;
      case -1:
         alarm_color = ViaviStyle.colors.red;
         break;
      case 1:
         alarm_color = ViaviStyle.colors.green;
         break;
      default:
         alarm_color = ViaviStyle.colors.slmPurple;
         break;
      }
      
      return alarm_color;
    }

    width: SxSize

    Rectangle {
        id: eventDefinition

        anchors.top: parent.top
        anchors.topMargin: 15

        width: SxSize
        height: 50
        
        radius: 4        

        color: isSelected && !isMtsElement ? "gold" : "transparent"

        Rectangle {
            id: iconDefinition

            visible: isIconElement

            anchors.centerIn: eventDefinition

            width: eventDefinition.width - 10
            height: eventDefinition.width - 12

            radius: 4
            clip: true

            color: IsSlaveEvent ? ViaviStyle.colors.lightBlue : ViaviStyle.colors.white
            border.color: getAlarmColor(AlarmStatus)
            border.width: isSelected ? 4 : 3

            Image {
                anchors.centerIn: iconDefinition
                fillMode: Image.PreserveAspectFit
                smooth: true
                source: IconPath
            }
            
            MouseArea {
               anchors.fill: parent
               onClicked: { schematicViewItem.selectValueChanged(EventIndex); }
            }
        }

        Rectangle {
            id: mtsDefinition

            visible: isMtsElement

            anchors.centerIn: eventDefinition

            width: eventDefinition.width - 8
            height: eventDefinition.width - 12

            clip: true

            Image {
                anchors.centerIn: mtsDefinition
                anchors.fill: parent
                fillMode: Image.PreserveAspectFit
                smooth: true
                source: IconPath
            }
            
        	MouseArea {
               anchors.fill: parent
               onClicked: { schematicViewItem.selectValueChanged(EventIndex); }
	        }
             
        }

        Row {
            anchors.centerIn: eventDefinition

            spacing: rowSpacing

            visible: isDotElement

            clip: true

            Repeater {
                model: (eventDefinition.width - rowSpacing) / (dotwidth + rowSpacing)
                delegate: Rectangle {
                    radius: dotwidth*0.5
                    width: dotwidth
                    height: dotwidth
                    color: ViaviStyle.colors.secondaryInfoColor
                }
            }
        }

         Rectangle {
            visible: isLineElement
            anchors.centerIn: eventDefinition
            
            height: dotwidth
            width: SxSize
            
            color: ViaviStyle.colors.secondaryInfoColor
            clip: true
         }

         Text {
            id: distanceTxt
            
            visible: !isMtsElement
            
            x: ( parent.width - width ) / 2
            y: {
            	if (isMtsElement)
            	{
					return (mtsDefinition.y + mtsDefinition.height + 10)
            	}
            	else if (isIconElement)
            	{
        			return (iconDefinition.y + iconDefinition.height + 10)
        		}
        		else
        		{
            		return -20
        		}
        	}
            
            color: ViaviStyle.colors.darkGray
         
            text: Distance
            font.pixelSize: isSelected ? 18 : 14
            font.bold: isSelected
         }
    }
}
