﻿import QtQuick 2.3
import QtQuick.Controls 2.0
import elf_plugin 1.0

import QtQuick.Layouts 1.2

import com.viavi.style 1.0
import com.viavi.style.components 1.0
import com.viavi.fiberutilui.components 1.0

Row {
    id: rootId

    spacing: ViaviStyle.layout.isSmallScreen ?
                 ViaviStyle.layout.veryLargeMargin * 2 : ViaviStyle.layout.veryLargeMargin

    CheckTextButton{
        height: parent.height

        visible: multigraphsStates_res_isOdmDelayAvailable.value
        checked: multigraphsStates_res_isOdmDelayActive.value

        text: multigraphsStates_res_delayLabel.value

        mouseArea.onClicked: multigraphsStates_act_switchToOdmDelay.invoke()
    }

    CheckTextButton {
        id: traceTabButton
        height: parent.height

        visible: multigraphsStates_res_isOdmDispersionAvailable.value
        checked: multigraphsStates_res_isOdmDispersionActive.value

        text: multigraphsStates_res_dispersionLabel.value

        mouseArea.onClicked: multigraphsStates_act_switchToOdmDispersion.invoke()
    }

    CheckTextButton{
        height: parent.height

        visible: multigraphsStates_res_isOdmSlopeAvailable.value
        checked: multigraphsStates_res_isOdmSlopeActive.value

        text: multigraphsStates_res_slopeLabel.value

        mouseArea.onClicked: multigraphsStates_act_switchToOdmSlope.invoke()
    }

    CheckTextButton{
        height: parent.height

        visible: multigraphsStates_res_isOdmPhaseAvailable.value
        checked: multigraphsStates_res_isOdmPhaseActive.value

        text: multigraphsStates_res_phaseLabel.value

        mouseArea.onClicked: multigraphsStates_act_switchToOdmPhase.invoke()
    }
}
