import QtQuick 2.5
import QtQuick.Layouts 1.1
import QtQuick.Window 2.2

import com.viavi.style 1.0
import com.viavi.style.components 1.0
import com.viavi.fiberutilui.components 1.0

import libsetupmenu 1.0

MainPage {
    id: fiberMainPage

    readonly property real scaleFactor: ViaviStyle.layout.isSmallScreen ? 0.70 : 1

    anchors.fill: parent
    
    function getFiberMainPage() {
        return fiberMainPage
    }

    Shortcut {
        sequence: 'Ctrl+S'
        onActivated: {
            hardkeys_act_onStartStopButton.invoke()
        }
    }

    Shortcut {
        sequence: 'Ctrl+F'
        onActivated: {
            hardkeys_act_onFileButton.invoke()
        }
    }

    Shortcut {
        sequence: 'Ctrl+U'
        onActivated: {
            hardkeys_act_onSetupButton.invoke()
        }
    }

    Shortcut {
        sequence: 'Ctrl+W'
        onActivated: hardkeys_act_onMTSOptionButton.invoke()
    }

    Shortcut {
        sequence: 'Esc'
        onActivated: hardkeys_act_onCancelButton.invoke()
    }

    Shortcut {
        sequence: 'Ctrl+R'
        onActivated: hardkeys_act_onResultsButton.invoke()
    }

    Shortcut {
        sequence: 'Ctrl+H'
        onActivated: hardkeys_act_onHomeButton.invoke()
    }

    Shortcut {
        sequence: 'Ctrl+P'
        onActivated: hardkeys_act_onPrintButton.invoke()
    }
    signal topLevelUpPressed()
    signal topLevelDowPressed()
    signal topLevelLeftPressed()
    signal topLevelRightPressed()
    signal topLevelReturnPressed()
    signal topLevelReleased()
    Keys.onUpPressed: {
        console.log('FiberMainPage - unfocused up caught!')
        topLevelUpPressed()
    }
    Keys.onDownPressed: {
        console.log('FiberMainPage - unfocused down caught!')
        topLevelDowPressed()
    }
    Keys.onLeftPressed: {
        console.log('FiberMainPage - unfocused left caught!')
        topLevelLeftPressed()
    }
    Keys.onRightPressed: {
        console.log('FiberMainPage - unfocused right caught!')
        topLevelRightPressed()
    }
    Keys.onReturnPressed: {
        console.log('FiberMainPage - unfocused return caught!')
        topLevelReturnPressed()
    }
    Keys.onReleased: {
        console.log('FiberMainPage - unfocused released caught!')
        if (event.key === Qt.Key_Left || event.key === Qt.Key_Right) {
            topLevelReleased()
        }
    }
    


    //the forceRefresh is need on mts5800 because window doesn't redraw by itself.
    function forceRefresh(){
        fiberMainPage.visible = false
        refreshTimer.restart()
    }

    Connections{
        target: status_res_refreshMainViewFlag
        function onValueChanged() {
            forceRefresh()
        }
    }

    Timer{
        id: refreshTimer
        interval: 10
        onTriggered: fiberMainPage.visible = true
    }
    

    FocusScope {
        id: contentFocusScope
        width: parent.width
        anchors.top: parent.top
        anchors.bottom: tabsItem.visible ? tabsItem.top: parent.bottom

        Loader {
            id: scopeMain
            source: 'ScopeMain.qml'
            anchors.fill: parent
            active: status_res_scopeEnabled.value
            visible: active
            focus: true
        }

        Loader {
            source: 'LTSMain.qml'
            anchors.fill: parent
            active: status_res_sourceNumericEnabled.value || status_res_powermeterNumericEnabled.value
            visible: active
        }

        Loader {
            id: fcompMain
            source: 'FCompMain.qml'
            anchors.fill: parent
            active: status_res_fcompEnabled.value
            visible: active
        }

        Loader {
            source: "Pow_Pon.qml"
            anchors.fill: parent
            active: status_res_powWindowEnabled.value
            visible: active
        }

        Rectangle {
            visible: status_res_otdrCableCoEnabled.value
            anchors.fill: parent
            color: ViaviStyle.colors.pageBackgroundColor

            ColumnLayout {
                id: otdrCableColumn

                anchors.left : parent.left
                anchors.right:parent.right
                anchors.leftMargin : ViaviStyle.layout.largeMargin
                anchors.rightMargin : ViaviStyle.layout.largeMargin

                anchors.top: parent.top
                anchors.bottom: parent.bottom
                anchors.topMargin : ViaviStyle.layout.mediumMargin
                anchors.bottomMargin : ViaviStyle.layout.mediumMargin

                spacing: ViaviStyle.layout.mediumMargin

                Item {
                    height: ViaviStyle.layout.buttonHeight * fiberMainPage.scaleFactor - otdrCableColumn.spacing
                    Layout.fillWidth: true

                    MainTabRowOtdr {
                        anchors.topMargin: - otdrCableColumn.anchors.topMargin
                        anchors.bottomMargin: - otdrCableColumn.spacing
                        anchors.fill: parent
                    }
                }

                BasicContainer {
                    Layout.fillWidth: true
                    Layout.fillHeight:  true

                    Loader{
                        anchors.fill: parent
                        source: status_res_cableCoState.value
                        visible: status_res_otdrCableCoEnabled.value
                        active: status_res_otdrCableCoEnabled.value
                    }
                }
            }
        }

        Rectangle {
            visible: status_res_fixCableCoEnabled.value
            anchors.fill: parent
            color: ViaviStyle.colors.pageBackgroundColor

            ColumnLayout {
                id: fcompCableColumn

                anchors.left : parent.left
                anchors.right:parent.right
                anchors.leftMargin : ViaviStyle.layout.largeMargin
                anchors.rightMargin : ViaviStyle.layout.largeMargin

                anchors.top: parent.top
                anchors.bottom: parent.bottom
                anchors.topMargin : ViaviStyle.layout.mediumMargin
                anchors.bottomMargin : ViaviStyle.layout.mediumMargin

                spacing: ViaviStyle.layout.mediumMargin

                Item {
                    height: ViaviStyle.layout.buttonHeight * fiberMainPage.scaleFactor - fcompCableColumn.spacing
                    Layout.fillWidth: true

                    FCompTabRow {
                        anchors.topMargin: - fcompCableColumn.anchors.topMargin
                        anchors.bottomMargin: - fcompCableColumn.spacing
                        anchors.fill: parent
                    }
                }

                BasicContainer {
                    Layout.fillWidth: true
                    Layout.fillHeight:  true

                    Loader{
                        anchors.fill: parent
                        source: status_res_cableCoState.value
                        visible: status_res_fixCableCoEnabled.value
                        active: status_res_fixCableCoEnabled.value
                    }
                }
            }
        }

        Loader{
            visible: status_res_dtsTabEnabled.value && dtsBattery_cfg_batteryModeEnabled.value
            enabled: status_res_dtsTabEnabled.value && dtsBattery_cfg_batteryModeEnabled.value

            anchors.fill: parent

            source: "DTSBatteryView.qml"
        }

        Loader{
            visible: status_res_dtsTabEnabled.value && dtsBattery_cfg_heatMapEnabled.value
            enabled: status_res_dtsTabEnabled.value && dtsBattery_cfg_heatMapEnabled.value

            anchors.fill: parent

            source: "DTSHeatMapView.qml"
        }

        Loader{
            visible: status_res_dtsTabEnabled.value && dtsBattery_res_batterySetupEnabled.value
            enabled: status_res_dtsTabEnabled.value && dtsBattery_res_batterySetupEnabled.value
            anchors.fill: parent

            source: "DTSBatterySetup.qml"
        }
    }

    FunctionsTabs{
        id: tabsItem

        visible: status_res_functionsTabsEnabled.value
        width: parent.width
        anchors.bottom: parent.bottom
    }

    Loader{
        source: "Setup_ExpertOTDR_Main.qml"
        anchors.fill: parent
        active: menuOtdr.visible
        visible: active
    }

    DebugInfo{
        id: debugInfoItem

        visible: status_res_debugInfoEnabled.value
        width: parent.width
        anchors.bottom: parent.bottom
    }

    fileExplorerDetailsData: SummaryInfo {
        visible: status_res_fileSummaryEnabled.value
        width: parent.width
    }

    fullScreenData: Item{
        anchors.fill: parent

        OsaGrid{
            visible: status_res_osaGridEnabled.value
        }

        DwdmGrid{
            visible: status_res_dwdmGridEnabled.value
        }

        PibGrid{
            visible: status_res_pibGridEnabled.value
        }

        WdmTable{
            visible: status_res_wdmTableEnabled.value
        }

        FixMessagePopup {
            visible: status_res_fixMessagePopupEnabled.value
        }

        OsaTableFilter {
            visible: osaTableFilter_cfg_osaTableFilterEnabled.value;
        }
        
        ProjectSetup {
            visible: !filebrowser_res_visible.value && project_cfg_setupEnabled.value
        }

        Loader{
            /* Wizard PopUp shown at the end of each measurement */
            source: "PopUp_Box.qml"
            anchors.bottom: parent.bottom
            anchors.bottomMargin: status_res_functionsTabsEnabled.value ? tabsItem.height : 0 + ViaviStyle.layout.largeMargin
            anchors.horizontalCenter: parent.horizontalCenter

            width: parent.width * 0.6
            height: parent.height * 0.45

            visible: status_res_popUpBoxEnabled.value
            active: status_res_popUpBoxEnabled.value
        }

        MouseArea{
            enabled: wizardLoader.active
            //make sure mouse events are not send to items in the background

            anchors.fill: parent

            Loader{
                id: wizardLoader

                /* Wizard component */
                source: status_res_wizardState.value
                visible: status_res_wizardEnabled.value
                active:status_res_wizardEnabled.value
                anchors.fill: parent
            }
        }
    }

    //Activate this to enable gathering and display of performance info (fps for now).
    property bool perfDebugInfoEnabled: false
    Component.onCompleted: {
        logAll('FiberMainPage.onCompleted - start')
        status_cfg_perfDebugInfoEnabled.value = perfDebugInfoEnabled
        logAll('fiberMainPage.onCompleted - end')
    }

    function logAll(msg) {
        console.log(msg + ' - perfDebugInfoEnabled:' + perfDebugInfoEnabled + ', ViaviStyle.layout.isSmallScreen:' + ViaviStyle.smallScreenLayout)
        console.log(msg + ' - fiberMainPage.width:' + fiberMainPage.width + ',  fiberMainPage.height:' + fiberMainPage.height + ', ViaviStyle.screenWidth:' + ViaviStyle.screenWidth + ', ViaviStyle.screenHeight:' + ViaviStyle.screenHeight)
        console.log(msg + ' - ViaviStyle.layout.screenWidth:' + ViaviStyle.layout.screenWidth + ', ViaviStyle.layout.screenHeight:' + ViaviStyle.layout.screenHeight + ',  ViaviStyle.layout.dynamicScaleFactor:' + ViaviStyle.layout.dynamicScaleFactor)
    }

    Rectangle {
        id: perfDebugInfo
        visible: status_cfg_perfDebugInfoEnabled.value
        width: 100
        height: 50
        //NOTE: on desktop Linux refreshes may stop comming whene there are no visual changes - result of some X11 optimisation - making the display of these performance counters to be the sole trigger of further UI updates
        Column {
            Text {
                id: fps
                text: 'fps:' + status_res_perfDebugFPS.value
            }
            Text {
                id: frames
                visible: true
                text: 'frame:' + status_res_perfDebugFrameCount.value
            }
        }

        anchors.right: parent.right
        anchors.bottom: parent.bottom
        border.color: ViaviStyle.colors.mainInfoColor
    }
}
