import QtQuick 2.3

import com.viavi.style 1.0
import com.viavi.style.components 1.0
import com.viavi.fiberutilui 1.0

BasicContainer {
    id: rootItem

    property int event_alarm: 0
    property string event_name : ""
    property string event_problemEvent: ""
    property string event_diagnosisCause: ""
    property string event_threshold1: ""
    property string event_threshold2: ""

    property bool detailsVisible: false

    width: parent.width
    height: parent.height

    Connections {
        target: schematic_cfg_slmCurrentEvent
        function onValueChanged() {
        	detailsVisible = false
        }
    }

    Rectangle {
        id: colorStatusRect
        height: parent.height
        width: parent.width / 4
        anchors.left: parent.left
        color: ViaviStyle.colors.getColor(event_alarm)

        ColorImage {
            id:eventIcon
            height: ViaviStyle.layout.imageButtonHeight
            width: parent.width
            anchors.centerIn: parent
            fillMode: Image.PreserveAspectFit
            source: FiberStyle.images.getAlarmIcon(event_alarm)
            color: ViaviStyle.colors.activeItemTextColor
            visible: source.toString().length > 0
        }
    }

    Item {
        id: detailTextColumn
        anchors.left: colorStatusRect.right
        anchors.right: parent.right
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        anchors.margins: ViaviStyle.layout.smallMargin

        Text {
            id: eventNameText
            anchors.fill: parent
            horizontalAlignment:Text.AlignHCenter
            verticalAlignment: Text.AlignVCenter
            font: ViaviStyle.layout.largeFont
            color: ViaviStyle.colors.mainInfoColor
            wrapMode: Text.WordWrap
            text: event_name
        }

        ImageButton {

            enabled: event_problemEvent.length > 0 || event_diagnosisCause.length > 0
                        || event_threshold1.length > 0 || event_threshold2.length > 0
            anchors.top: parent.top
            anchors.topMargin: ViaviStyle.layout.mediumMargin
            anchors.right: parent.right
            anchors.rightMargin: ViaviStyle.layout.mediumMargin
            source: FiberStyle.images.aboutIcon

            isChecked: detailsVisible
            onClicked: detailsVisible = !detailsVisible
        }
    }
}
