import QtQuick 2.1
import graph_plugin 1.0
import elf_plugin 1.0


CursorDragFiber {
    id: cursorXDragFiber
    isVerticalCursor: true

    anchors.top: parent.top
    anchors.bottom: parent.bottom

    width:  33
    transform: Translate { x: -(dragAreaAlias.width-1)/2 }

    highlightAlias.width: height
    highlightAlias.height: width - 20
    highlightAlias.rotation: 90

    dragAreaAlias.drag.axis: Drag.XAxis
    dragAreaAlias.drag.minimumX: 0
    dragAreaAlias.drag.maximumX: parent.width-1

    nameAlias.x: x + nameAlias.contentWidth > dragAreaAlias.drag.maximumX ? 0 : width - nameAlias.contentWidth


    function updateConnectedCursorOffset(){

        //don't take into account AB cursor as it will be handled in the backend in module_trace
        //this will ensure position updates of connected cursor on the same thread
        //and will get rid of A-B distance flickering number problem
        if (trace_cfg_cursorSelected.enums.ecCursor_AB === trace_cfg_cursorSelected.value)
            return;

        if(connectedCursor){
            connectedCursorOffset = cursorDragAlias.x - connectedCursor.x
        }

    }

	function setPosValue(posValue){
	   if (GraphCursor.cursor !== null){
	      parent.posValue = posValue
          x = parent.posOnScreen
       }
	}
	

    function updatePosition(newPos, fromUser, propagate){

        if (!trace_res_cursorsLocked.value)
        {
            x = newPos
            if(fromUser){
                if(xAxis && xAxis.rangeOrder === ValueAxis.Decreasing){
            	    updateElf.invokeWithStringArg(xAxis.maxValue + xAxis.minValue - GraphCursor.cursor.posValue)   
            	}
            	else{
                    updateElf.invokeWithStringArg(GraphCursor.cursor.posValue)
                }  
                
                
                //don't take into account AB cursor as it will be handled in the backend in module_trace
                //this will ensure position updates of connected cursor on the same thread
                //and will get rid of A-B distance flickering number problem
                if (trace_cfg_cursorSelected.enums.ecCursor_AB === trace_cfg_cursorSelected.value)
                    return;

                if(propagate && connectedCursor){
                    connectedCursor.updatePosition(x - connectedCursorOffset, fromUser, false)
                }
            }
        }
    }


    onXChanged: {

        if (GraphCursor.cursor !== null){

            GraphCursor.cursor.setPosOnScreen(x)
            // anchor drag to graph cursor
            x = GraphCursor.cursor.posOnScreen

            if(pressed){
                updatePosition(x, true, true)
            }
        }
    }

    GraphCursor.onXPosOnScreenChanged: {
        cursorDragAlias.x = GraphCursor.cursor.posOnScreen
    }

    onPressedChanged: {

        if(parentTrace){
            parentTrace.lastUsedCursor = cursorXDragFiber
        }
        updateConnectedCursorOffset()

    }

}


