import QtQuick 2.3
import com.viavi.style 1.0

Rectangle {
    id: cable_Co_Result_Informations
    color: "black"
    
     // Use Q_ENUM when enum not negative or supported in QML
	function cable_get_alarm_color( alarm )
	{
        var cable_back_col = ViaviStyle.colors.lightGray1;
	
		if (alarm == 1) {
			cable_back_col = ViaviStyle.colors.green;
		}
		else if (alarm == -1) {
			cable_back_col = ViaviStyle.colors.red;
		}
		else if (alarm == -2) {
			cable_back_col = ViaviStyle.colors.yellow;
		}
		
		return cable_back_col ;
	}
	
	 // Use Q_ENUM when enum not negative or supported in QML
	function cable_get_alarm_icon( alarm ) 
	{
		var icon = "";
		
		if (alarm == 1) {
			icon = "/acterna/storage/look-and-feel/generic/Check_32.png";
		}
		else if (alarm == -1) {
			icon = "/acterna/storage/look-and-feel/generic/Cross_32.png";
		}
		else if (alarm == -2) {
			icon = "/acterna/storage/look-and-feel/generic/Check_32.png";
		}
		
		return icon;
	}
        
    Component {
    	id: list_Elem
    	
		Rectangle {
			id: head_elem
			width: cable_Co_Result_Informations.width
			height: cable_Co_Result_Informations.height / 4
			
			Repeater {
				model: ["", 
						Lambda,
						Bilan,
						Orl,
						Distance 
						]
				Cable_Co_Result_Widget {
					width: head_elem.width / 5
    				height:  head_elem.height
    				x: index * (head_elem.width  / 5)
    				
                    color: (index == 0) ? cable_get_alarm_color(Alarm) : ViaviStyle.colors.lightGray1
					textcolor: ViaviStyle.colors.viaviPurple
					value: modelData
					
					Image {
						source: (index == 0) ? cable_get_alarm_icon(Alarm) : ""
						width: parent.width
						height: parent.height - 10
						y: 5
						fillMode: Image.PreserveAspectFit
					}
				}
			}
		}
    }

	Rectangle {
		id: head_rec
		width: cable_Co_Result_Informations.width 
		height: cable_Co_Result_Informations.height / 4
		
		Repeater {
			model: [ cable_co_list.Cable_List[cable_co_list.Index].Fiber_Number, cable_co_list.Txt_Laser, cable_co_list.Txt_Bilan, cable_co_list.Txt_ORL, cable_co_list.Txt_Length]
			
			Cable_Co_Result_Widget {
				x: index * (head_rec.width  / 5)
				width: head_rec.width  / 5
				height: head_rec.height
				value: modelData
			}
		}    		
	}

	ListView {	
		y: head_rec.height		
		width: cable_Co_Result_Informations.width
		height: (cable_Co_Result_Informations.height / 4) * 3
	
		delegate: list_Elem
		model:cable_co_list.Result
		
		clip: true
        interactive: true
		boundsBehavior: Flickable.StopAtBounds
	}
}
