import QtQuick 2.3

import com.viavi.style 1.0
import com.viavi.fiberutilui.components 1.0

Item {
    CableToggleFiberPopup { id: enablePopupId }

    width: grid.cellWidth + 2
    height: grid.cellHeight + 2
    clip: true 
    
    // Use Q_ENUM when enum not negative or supported in QML
    function cable_alarm_color ( cable_co_list, i ) 
	{
		var cable_back_col = ViaviStyle.colors.lightGray2;	
	
		if (cable_co_list.Cable_List[i] != undefined) 
		{
		  if (!cable_co_list.Cable_List[i].Fiber_To_Test) 
		  {
		      cable_back_col = ViaviStyle.colors.secondaryInfoColor;
		  } 
		  else if (cable_co_list.Cable_List[i].Fiber_Test_Done) 
		  {
		    var alarm = cable_co_list.Cable_List[i].Alarm_Status;
		    
	    	if (alarm == 1) {
				cable_back_col = ViaviStyle.colors.green;
			}
			else if (alarm == -1) {
				cable_back_col = ViaviStyle.colors.red;
			}
			else if (alarm == -2) {
				cable_back_col = ViaviStyle.colors.yellow;
			}
			else
			{
				cable_back_col = ViaviStyle.colors.lightGray2;
			}
		  }
		}
		
		return cable_back_col;
	}

    Column {
    	Rectangle { 

    		width: grid.cellWidth
    		height: grid.cellHeight
            border.width: 1
            border.color: ViaviStyle.colors.secondaryInfoColor
            opacity: 1
    		
    		color: cable_alarm_color( cable_co_list, index )
    		
    		Text {
            	text: Fiber_Number
				color: ViaviStyle.colors.viaviPurple
                font.pixelSize: 16
                font.family: "Bitstream Vera Sans Roman"
                anchors.horizontalCenter: parent.horizontalCenter
                anchors.verticalCenter: parent.verticalCenter
			}
			
			Rectangle {
				visible: Fiber_Channel != 0
				
				color: ViaviStyle.colors.lightBlue
				
				height: parent.height / 4
				width: height
				
				radius: width / 2
				
				anchors.left: parent.left
				anchors.leftMargin: 2
				
				anchors.top: parent.top
				anchors.topMargin: 2
				
				Text {
	            	text: Fiber_Channel
					color: ViaviStyle.colors.viaviPurple
	                font.pixelSize: 8
	                font.family: "Bitstream Vera Sans Roman"
	                anchors.horizontalCenter: parent.horizontalCenter
	                anchors.verticalCenter: parent.verticalCenter
				}
			}
			
			Rectangle {
				color: (index == cable_co_list.Index) ? ViaviStyle.colors.viaviPurple : "transparent"
				width: parent.width
				height: parent.height / 4
				y:  (parent.height / 4) * 3
			}
			
			Image {
			    visible: (Alarm_Status != 0) && Fiber_Test_Done
				source: Alarm_Status == 1  ? "/acterna/storage/look-and-feel/generic/Check_32.png" : "/acterna/storage/look-and-feel/generic/Cross_32.png"
				width: parent.width / 5
				height: parent.height / 5
				
				anchors.right: parent.right
				anchors.rightMargin: 2
				
				anchors.top: parent.top
				anchors.topMargin: 2
				
				fillMode: Image.PreserveAspectFit
			}
    	}
    }

    PopupMouseArea {
        anchors.fill: parent
        longPressMenu: enablePopupId
        z: parent.z + 1
        onBeforePressAndHold: {
            cable_co_list.Index = index
        }

        onClicked: {
            cable_co_list.Index = index
        }
    }        
}

