#!/bin/sh

# Allow a file to get loaded from the generic File Explorer for Arlandes 

####################################################################
# openIsu : opens the ISU's parser
# without arguments
####################################################################
function openIsu
{
	export rmtSrv=8
	exec 8<>/dev/tcp/$1/5025
	echo "*rem">&$rmtSrv
	read empty_line<&$rmtSrv

	echo "prtm:list?">&$rmtSrv
	read port<&$rmtSrv
	# captures the Isu port by matching Fiber-ISU: <port_no>
	port=`echo $port | sed -e 's/.*Fiber-ISU: \([0-9]*\).*/\1/'`
	export isu=5
	exec 5<>/dev/tcp/$1/$port
	[ "$?" == 0 ] || echo Error opening ISU parser
	echo "*rem">&$isu
}

####################################################################
# closeIsuAndFo : close the ISU's parser
# without arguments
####################################################################
function closeIsu
{
	exec 5<&-
	exec 5>&-
}

####################################################################
# snd : send a command to the parser and checks the ESR
# 1st parameter : $isu or $fo
# 2nd parameter : command to send to the parser
####################################################################
function snd
{
    local rc
    echo -e "$2\n*esr?\n" >&$1
    read rc<&$1
    [ "$rc" == "0" ] || echo "\!\!\!\!\!\!\!\!\!\! WRONG ESR: $rc"
}

####################################################################
# esr : checks the ESR
# 1st parameter : $isu or $fo
####################################################################
function esr
{
    local rc
    echo "*esr?" >&$1
    read rc<&$1
    [ "$rc" == "0" ] || echo "\!\!\!\!\!\!\!\!\!\! WRONG ESR: $rc"
}

####################################################################
# sndrcv : sends a query to the parser, reads the answer and checks
#          the esr
# 1st parameter : $isu or $fo
# 2nd parameter : query to send to the parser
# 3rd parameter : name of the variable to store the answer of the
#                 query
####################################################################
function sndrcv
{
	local rc
	echo "$2" >&$1
	read rc<&$1
	eval $3='$rc'
	#esr $1
}

####################################################################
# sndprt : sends a query to the parser, prints the query and its
#          answer, checks the ESR.
# 1st parameter : $isu or $fo
# 2nd parameter : query to send to the parser
####################################################################
function sndprt
{
    to_print=""
    sndrcv "$1" "$2" to_print
    echo "$2"          returned: "$to_print"
}


if [ $# -lt 1 ]; then
	echo "not enough parameters"
	exit
fi

openIsu localhost
sndprt $isu "*idn?"

for str in $@
do
	if [ -f $str ]; then
		str=`echo $str | sed -e "s/^\/media\/usb_flash_..../\/user\/usbflash/g"`
		echo "handling file:" $str
		echo "handling file:" $str>>/tmp/trace

		path=`dirname $str`
		path=`echo $path | sed -e "s/^\/user//g"`
		file=`basename $str`
		snd $isu "PROC:LOAD \"$file\",\"$path\""
	else
		echo "error" $str "is not a file"
	fi
done

closeIsu

cmsend guitaskmgr cmd raise_task 'Fiber-UI'
