<!DOCTYPE html>
<html>
<head>
<meta http-equiv="X-UA-Compatible" content="IE=10" />
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<link rel="icon" type="image/ico" href="app/view/images/favicon.ico" />
<link rel="stylesheet" type="text/css" href="app/view/stylesheets/App.css" />
<link id="TPZLoginCssId" rel="stylesheet" type="text/css" href="app/view/stylesheets/Login.css" />
<title><?php echo $smartModeDisplay ?></title>
<?php include "header.php" ?>
</head>

<?php use app\admin\SMTLanguage;?>
<body onLoad="selectDefaultInput();">
<?php include "background.php" ?>
<div id="TPZLoginPanelId" class="TPZLoginPanel">

<div class="TPZLoginPanelHeader">
<?php echo $loginWindowTitle ?>
</div>
<div class="TPZLoginPanelBody">

    <form id="localeFormId"  action="/index.php<?php if ($target !== NULL) { echo '#'.$target; } ?>" method="post">

        <?php
        // In case of GWT debug
        if ( $gwtCodesvr !== NULL )
        {?>
            <input type="hidden" name="gwt.codesvr" value="<?php echo $gwtCodesvr ?>" />
        <?php				
        }
        // In case of target
        if ( $target !== NULL )
        {?>
        	<input type="hidden" name="target" value="<?php echo $target ?>" />
        <?php						
        } ?>
		<label for="localeId"><?php echo MSG_LANGUAGE ?></label>
		<select id="localeId" class="TPZLocaleSelector" name="locale" onchange="return localeSelectActionExecute();" tabindex="1">
		<?php 
		foreach (  $supportedLanguages as $supportedlang  )
		{
			if ( $currentLanguage != NULL && $currentLanguage == $supportedlang )
			{
			?>
			<option lang="<?php echo $supportedlang ?>" selected="selected" value="<?php echo $supportedlang ?>"><?php echo SMTLanguage::getDisplayedLanguage( $supportedlang )?></option>
			<?php 
			}
			else
			{
			?>
			<option lang="<?php echo $supportedlang ?>" value="<?php echo $supportedlang ?>"><?php echo SMTLanguage::getDisplayedLanguage( $supportedlang )?></option>
		    <?php
		    }
		}
		?>
		</select>
	</form>
	<form id="loginFormId"  action="/index.php<?php if ($target !== NULL) { echo '#'.$target; } ?>" method="post" autocomplete="off" onsubmit="javascript:encodePassword()">
		<?php
		// In case of GWT debug
		if ( $gwtCodesvr !== NULL )
		{?>
		    <input type="hidden" name="gwt.codesvr" value="<?php echo $gwtCodesvr ?>" />
		<?php
		}
		// In case of target redirect
		if ( $target !== NULL )
		{?>
			<input type="hidden" name="target" value="<?php echo $target ?>" />
		<?php
		}?>
		<input type="hidden" name="locale" value="<?php echo $currentLanguage ?>" />
		<input type="hidden" id="smtId" name="smt" value="" />

		<div>
    		<label for="loginId"><?php echo MSG_LOGIN ?></label>
    		<input id="loginId" class="TPZInput" tabindex="2" name="login" type="text" value="<?php echo $loginStr ?>" />
		</div>
		<div>
			<label for="passwordId"><?php echo MSG_PASSWORD ?></label>
			<input id="passwordId" class="TPZInput" tabindex="3" name="password" type="password" />
			</div>
			<div class="TPZButtonBar">
            <input class="TPZButton" tabindex="4" type="submit" value="<?php echo MSG_CONNECTION ?>" />
        </div>
    </form>
    </div>
    
    <div id="messagesId" class="TPZLoginPanelMessages">
		<noscript>
		    <div class="TPZErrorMessages"> <?php echo MSG_NO_JS ?> </div>
		</noscript>
		<?php
		if ( isset( $errorLoginMessage ) )
		{?>
    		<div class="TPZErrorMessages"> <?php echo $errorLoginMessage ?> </div>
        <?php 
        }?>
    </div>
    
    <script type="text/javascript">
    // <![CDATA[
    // Due to a problem on ie8, we need to remove the noscript element.
    var messagesDiv = document.getElementById ( "messagesId" );
    		var noscript = messagesDiv.getElementsByTagName ( "noscript" );
    		for ( var i = 0; i < noscript.length; i++ )
    		{
    messagesDiv.removeChild ( noscript[i] );
    }
    // Set the focus on the 'login' field, if empty otherwise on the 'password' field
    		selectDefaultInput();
    		// ]]>
    </script>
</div>
<?php include "footer.php" ?>
</body>
</html>