<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************

// WARNING: no namespace for annotations: avoid to add the namespace in the name of the attribute
//namespace app\util;

require_once 'lib/addendum/annotations.php';

/**
 * 
 * @Target("property") 
 * 
 * @author Sylvain Desplat
 */
class SMTAttributeInfosAnnotation extends \Annotation
{    
    /**
     *  Attribute class type or NULL if primitive type
     *  @var string 
     */
    public $classname = NULL;
    
    /**
     *  If the attribute is a DTO (not a primitive type), id is the property of the dto mapping the database table primary key.
     *
     *  @var string
     */
    public $id= NULL;
    
    /**
     * Whether the attribute is a list of objects of the given type. (False by default)
     *
     * @var bool
     */
    public $islist = FALSE;
        
    /**
     * Whether the attribute must be ignored in Dto checksum. (False by default)
     * 
     * @var bool
     */
    public $ignoreCheckSum = FALSE;
    
    /**
     *  Database table name associated to the attribute class
     *  @var string
     */
    public $tablename = NULL;
    

}
?>