#!/usr/bin/env php

<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
/**
 * WARNING: Executable script to monitor a background process.
 * That background process handle the test on demand by querying its status from the PHP Web Server till the end of the test.
 * 
 */

/**
 * include autoloader
 */
require_once 'lib/restler.php';

/**
 * include operation polling class
 */
require_once 'app/http/SMTAsyncOperationPolling.php';

/**
 * Warning: Error stream is redirected to /logfile/path by command line launching that script
 */
app\http\SMTAsyncOperationPolling::trace("testOnDemandThread arguments: ".print_r( $argv[2] ) );

/**
 * Retrieve command line arguments:
 * Command should be:
 * 
 * ./testondemandProcess.php -- testOnDemandClass,operationId,testId,linkId >> /logfile/path 2>&1 &
 * 
 * argv[0] -> ./testondemandProcess.php
 * argv[1] -> --
 * argv[2] -> testOnDemandClass,operationId,testId,linkId
 * 
 */
list( $operationType, $operationId, $testId, $linkId ) = explode( "," ,$argv[2] );

app\http\SMTAsyncOperationPolling::trace("Start testOnDemandThread ".$operationId);

/**
 * launch the polling if the required parameters are set
 */
if ( $operationType != '' && $testId != '' && $operationId != '' && $linkId != '' )
{
    try 
    {
        $pollingOperation = new app\http\SMTAsyncOperationPolling( $operationType, $linkId, $operationId);
        $pollingOperation->poll();        
    } 
    catch (Exception $e) 
    {
        app\http\SMTAsyncOperationPolling::traceException( sprintf( "Failure in testOnDemandThread %s: %s", $operationId, $e->getMessage() ) );
    }
}
else 
{
    app\http\SMTAsyncOperationPolling::traceException( sprintf( "Couldn't start polling, bad parameters for test %s! ", $operationId ) );
}
app\http\SMTAsyncOperationPolling::trace("End testOnDemandThread ".$operationId);

exit(0);

?>