<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\serviceshelper\monitoring;

use app\serviceshelper\otdr\SMTOtdrTraceFileUtil;

/**
 * OTDR reference files info: 
 * - those OTDR files are located in OTU detection and localisation directories.
 * 
 * @author Sylvain Desplat
 *
 */
class SMTOtdrReferenceFiles
{          
    /**
     * OTDR localisation reference file path
     * @var string
     */
    protected $otdrLocFilePath;
    
    /**
     * OTDR detection reference file path
     * @var string
     */
    protected $otdrDetFilePath;
    
    /**
     * OTDR reference file name without path
     * 
     * @var string
     */
    protected $otdrFileName; 
       
    
    /**
     * OTDR reference file name without path
     * @return string
     */
    function getOtdrFileName()
    {
    	return $this->otdrFileName;
    }
    
    /**
     * OTDR reference file name without path and without extension
     * 
     * @return string
     */
    function getOtdrFileNameWithoutExtension()
    {
    	$acquisitionTrace = basename( $this->otdrFileName );
    	return substr($acquisitionTrace, 0,strrpos($acquisitionTrace,"."));
    }
    
    /**
     * Set OTDR reference file name (without path)
     * 
     * @param string $otdrFileName
     */
    function setOtdrFileName ( $otdrFileName )
    {
    	$this->otdrFileName = $otdrFileName;
    }    
    
    function getOtdrDetFilePath()
    {
    	return $this->otdrDetFilePath;
    }
    
    function setOtdrDetFilePath ( $otdrDetFilePath )
    {
    	$this->otdrDetFilePath = $otdrDetFilePath;
    }
    
    function getOtdrLocFilePath()
    {
    	return $this->otdrLocFilePath;
    }
    
    function setOtdrLocFilePath ( $otdrLocFilePath )
    {
    	$this->otdrLocFilePath = $otdrLocFilePath;
    }    
}

?>