<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\serviceshelper\monitoring;

use app\util\SMTException;

/**
 * Link-test exceptions
 * 
 * @author Sylvain Desplat
 *
 */
class SMTLinkTestException extends SMTException
{
    const OTU_ERROR_INVALID_LINK_NAME = "200";
    const ERROR_INVALID_LINK_NAME = "ERROR_INVALID_LINK_NAME";
    const OTU_ERROR_INVALID_LINK_ID = "201";
    const ERROR_INVALID_LINK_ID = "ERROR_INVALID_LINK_ID";
    const OTU_ERROR_INVALID_MODULE_SELECTED = "202";
    const ERROR_INVALID_MODULE_SELECTED = "ERROR_INVALID_MODULE_SELECTED";
    const OTU_ERROR_INVALID_PORT_OUT = "203";
    const ERROR_INVALID_PORT_OUT = "ERROR_INVALID_PORT_OUT";
    const OTU_ERROR_INVALID_TEST_THRESHOLD_PARAMETERS = "204";
    const ERROR_INVALID_TEST_THRESHOLD_PARAMETERS = "ERROR_INVALID_TEST_THRESHOLD_PARAMETERS";
    const OTU_ERROR_MISSING_TEST_THRESHOLD_PARAMETERS = "205";
    const ERROR_MISSING_TEST_THRESHOLD_PARAMETERS = "ERROR_MISSING_TEST_THRESHOLD_PARAMETERS";
    const OTU_ERROR_MISSING_OTDR_TRACE = "206";
    const ERROR_MISSING_OTDR_TRACE = "ERROR_MISSING_OTDR_TRACE";
    const OTU_ERROR_LAST_MARKER_BADLY_SET = "207";
    const ERROR_LAST_MARKER_BADLY_SET = "ERROR_LAST_MARKER_BADLY_SET";
    const OTU_ERROR_TEST_ERROR = "208";
    const ERROR_TEST_ERROR = "ERROR_TEST_ERROR";
    const OTU_ERROR_DELETE_LINK = "209";
    const ERROR_DELETE_LINK = "ERROR_DELETE_LINK";
    const OTU_ERROR_DELETE_TEST = "210";
    const ERROR_DELETE_TEST = "ERROR_DELETE_TEST";
    const OTU_ERROR_CLEAR_TEST_ALARM = "211";
    const ERROR_CLEAR_TEST_ALARM = "ERROR_CLEAR_TEST_ALARM";
    const OTU_ERROR_TEST_ADD_ERROR = "212";
    const ERROR_TEST_ADD_ERROR = "ERROR_TEST_ADD_ERROR";
    const OTU_ERROR_TEST_ALREADY_EXIST = "213";
    const ERROR_TEST_ALREADY_EXIST = "ERROR_TEST_ALREADY_EXIST";    
    const OTU_ERROR_TEST_NOT_FOUND = "214";
    const ERROR_TEST_NOT_FOUND = "ERROR_TEST_NOT_FOUND";
    const OTU_ERROR_LINK_NOT_FOUND = "215";
    const ERROR_LINK_NOT_FOUND = "ERROR_LINK_NOT_FOUND";
    const OTU_ERROR_TEST_UPDATE_FAILED = "216";
    const ERROR_TEST_UPDATE_FAILED = "ERROR_TEST_UPDATE_FAILED";    
    const OTU_ERROR_INVALID_TEST_ID = "217";
    const ERROR_INVALID_TEST_ID = "ERROR_INVALID_TEST_ID";
    const OTU_ERROR_INVALID_PORT = "218";
    const ERROR_INVALID_PORT = "ERROR_INVALID_PORT";
    const OTU_ERROR_TEST_OK                      ="0000";
    const ERROR_TEST_OK          ="ERROR_TEST_OK";
    const OTU_ERROR_TEST_TEST_RUNNING             ="0010";
    const ERROR_TEST_TEST_RUNNING ="ERROR_TEST_TEST_RUNNING";
    const OTU_ERROR_TEST_NO_PARAM             ="0020";
    const ERROR_TEST_NO_PARAM ="ERROR_TEST_NO_PARAM";
    const OTU_ERROR_TEST_MISS_LINK           ="0030";
    const ERROR_TEST_MISS_LINK     ="ERROR_TEST_MISS_LINK";
    const OTU_ERROR_TEST_MISS_REF_TRACE             ="0040";
    const ERROR_TEST_MISS_REF_TRACE ="ERROR_TEST_MISS_REF_TRACE";
    const OTU_ERROR_TEST_SIZE_BUFFER_MARKER      ="0050";
    const ERROR_TEST_SIZE_BUFFER_MARKER="ERROR_TEST_SIZE_BUFFER_MARKER";
    const OTU_ERROR_TEST_BAD_MARKER_BUFFER          ="0060";
    const ERROR_TEST_BAD_MARKER_BUFFER         ="ERROR_TEST_BAD_MARKER_BUFFER";
    const OTU_ERROR_TEST_ALLOCATE_MEMORY         ="0070";
    const ERROR_TEST_ALLOCATE_MEMORY     ="ERROR_TEST_ALLOCATE_MEMORY";
    const OTU_ERROR_TEST_SAVE_CONFIG          ="0080";
    const ERROR_TEST_SAVE_CONFIG    ="ERROR_TEST_SAVE_CONFIG";
    const OTU_ERROR_TEST_SAVE_INFO           ="0090";
    const ERROR_TEST_SAVE_INFO     ="ERROR_TEST_SAVE_INFO";
    const OTU_ERROR_TEST_SAVE_DESC     ="0100";
    const ERROR_TEST_SAVE_DESC ="ERROR_TEST_SAVE_DESC";
    const OTU_ERROR_TEST_TOO_MUCH_TESTS                 ="0110";
    const ERROR_TEST_TOO_MUCH_TESTS     ="ERROR_TEST_TOO_MUCH_TESTS";
    const OTU_ERROR_TEST_TYPE             ="0120";
    const ERROR_TEST_TYPE ="ERROR_TEST_TYPE";
    const OTU_ERROR_TEST_UNDEFINED_TEST               ="0130";
    const ERROR_TEST_UNDEFINED_TEST   ="ERROR_TEST_UNDEFINED_TEST";
    const OTU_ERROR_TEST_TOO_MUCH_LOC         ="0140";
    const ERROR_TEST_TOO_MUCH_LOC    ="ERROR_TEST_TOO_MUCH_LOC";
    const OTU_ERROR_TEST_FUNCT_MISS          ="0150";
    const ERROR_TEST_FUNCT_MISS         ="ERROR_TEST_FUNCT_MISS";
    const OTU_ERROR_TEST_FUNCT        ="0160";
    const ERROR_TEST_FUNCT   ="ERROR_TEST_FUNCT";
    const OTU_ERROR_TEST_ADD_LOC          ="0170";
    const ERROR_TEST_ADD_LOC     ="ERROR_TEST_ADD_LOC";
    const OTU_ERROR_TEST_REF_PARAM       ="0180";
    const ERROR_TEST_REF_PARAM  ="ERROR_TEST_REF_PARAM";
    const OTU_ERROR_TEST_UNDEFINED                      ="9999";
    const ERROR_TEST_UNDEFINED          ="ERROR_TEST_UNDEFINED";
    const ERROR_LINK_ALREADY_EXIST = "ERROR_LINK_ALREADY_EXIST";
    const ERROR_LINK_HARDWARE_CONFIG = "ERROR_LINK_HARDWARE_CONFIG";
    const ERROR_LINK_NO_MODULE = "ERROR_LINK_NO_MODULE";
    const ERROR_ONLY_ONE_TEST_SETUP = "ERROR_ONLY_ONE_TEST_SETUP";
    const ERROR_FAILED_TO_UPDATE_DELTA_POS_PEAK = "ERROR_FAILED_TO_UPDATE_DELTA_POS_PEAK";
    const ERROR_FAILED_TO_UPDATE_PEAK_NAME = "ERROR_FAILED_TO_UPDATE_PEAK_NAME";
    
    /**
     *
     * @param string $stringErrorCode string error code translated from OTU error codes
     * @param string $message detailed message
     */    
    function __construct( $stringErrorCode = NULL, $message = NULL )
    {
    	parent::__construct( $stringErrorCode, $message );
    }    

    /**
     * Get error codes label for tracing without error codes.
     * @param integer $otuErrorCode OTU error code
     *
     * @return string error code as a string
     */
    public static function decodeOtuErrorCode( $otuErrorCode )
    {
    	$errorCode = self::OTU_ERROR_TEST_UNDEFINED;
    	switch( $otuErrorCode )
    	{
    	    case self::OTU_ERROR_INVALID_LINK_NAME:    	    
                $errorCode = self::ERROR_INVALID_LINK_NAME;
                break;  
            case self::OTU_ERROR_INVALID_LINK_ID:
            	$errorCode = self::ERROR_INVALID_LINK_ID;
            	break;                                
            case self::OTU_ERROR_DELETE_LINK:
                $errorCode = self::ERROR_DELETE_LINK;
                break;
            case self::OTU_ERROR_DELETE_TEST:
                $errorCode = self::ERROR_DELETE_TEST;
            	break;
        	case self::OTU_ERROR_CLEAR_TEST_ALARM:
        	    $errorCode = self::ERROR_CLEAR_TEST_ALARM;
        		break;            		 
    		case self::OTU_ERROR_INVALID_PORT_OUT:
    			$errorCode = self::ERROR_INVALID_PORT_OUT;
    			break;        		
            case self::OTU_ERROR_INVALID_TEST_THRESHOLD_PARAMETERS:
                $errorCode = self::ERROR_INVALID_TEST_THRESHOLD_PARAMETERS;
                break;
            case self::OTU_ERROR_MISSING_TEST_THRESHOLD_PARAMETERS:
            	$errorCode = self:: ERROR_MISSING_TEST_THRESHOLD_PARAMETERS;
            	break;                
        	case self::OTU_ERROR_MISSING_OTDR_TRACE:
        		$errorCode = self:: ERROR_MISSING_OTDR_TRACE;
        		break;
    		case self::OTU_ERROR_LAST_MARKER_BADLY_SET:
    			$errorCode = self:: ERROR_LAST_MARKER_BADLY_SET;
    			break;
    		case self::OTU_ERROR_INVALID_MODULE_SELECTED:
    		    $errorCode = self:: ERROR_INVALID_MODULE_SELECTED;
    		    break;
    		case self::OTU_ERROR_TEST_ADD_ERROR:
    		    $errorCode = self:: ERROR_TEST_ADD_ERROR;
    		    break;    		    
		    case self::OTU_ERROR_TEST_OK:
    		    $errorCode = self::ERROR_TEST_OK;
    		    break;
		    case self::OTU_ERROR_TEST_TEST_RUNNING:
    		    $errorCode = self::ERROR_TEST_TEST_RUNNING;
    		    break;
		    case self::OTU_ERROR_TEST_NO_PARAM:
    		    $errorCode = self::ERROR_TEST_NO_PARAM;
    		    break;
		    case self::OTU_ERROR_TEST_MISS_LINK:
    		    $errorCode = self::ERROR_TEST_MISS_LINK;
    		    break;
		    case self::OTU_ERROR_TEST_MISS_REF_TRACE:
    		    $errorCode = self::ERROR_TEST_MISS_REF_TRACE;
    		    break;
		    case self::OTU_ERROR_TEST_SIZE_BUFFER_MARKER:
    		    $errorCode = self::ERROR_TEST_SIZE_BUFFER_MARKER;
    		    break;
		    case self::OTU_ERROR_TEST_BAD_MARKER_BUFFER:
    		    $errorCode = self::ERROR_TEST_BAD_MARKER_BUFFER;
    		    break;
		    case self::OTU_ERROR_TEST_ALLOCATE_MEMORY:
    		    $errorCode = self::ERROR_TEST_ALLOCATE_MEMORY;
    		    break;
		    case self::OTU_ERROR_TEST_SAVE_CONFIG:
    		    $errorCode = self::ERROR_TEST_SAVE_CONFIG;
    		    break;
		    case self::OTU_ERROR_TEST_SAVE_INFO:
    		    $errorCode = self::ERROR_TEST_SAVE_INFO;
    		    break;
		    case self::OTU_ERROR_TEST_SAVE_DESC:
    		    $errorCode = self::ERROR_TEST_SAVE_DESC;
    		    break;
		    case self::OTU_ERROR_TEST_TOO_MUCH_TESTS:
    		    $errorCode = self::ERROR_TEST_TOO_MUCH_TESTS;
    		    break;
		    case self::OTU_ERROR_TEST_TYPE:
    		    $errorCode = self::ERROR_TEST_TYPE;
    		    break;
		    case self::OTU_ERROR_TEST_UNDEFINED_TEST:
    		    $errorCode = self::ERROR_TEST_UNDEFINED_TEST;
    		    break;
		    case self::OTU_ERROR_TEST_TOO_MUCH_LOC:
    		    $errorCode = self::ERROR_TEST_TOO_MUCH_LOC;
    		    break;
		    case self::OTU_ERROR_TEST_FUNCT_MISS:
    		    $errorCode = self::ERROR_TEST_FUNCT_MISS;
    		    break;
		    case self::OTU_ERROR_TEST_FUNCT:
    		    $errorCode = self::ERROR_TEST_FUNCT;
    		    break;
		    case self::OTU_ERROR_TEST_ADD_LOC:
    		    $errorCode = self::ERROR_TEST_ADD_LOC;
    		    break;
		    case self::OTU_ERROR_TEST_REF_PARAM:
    		    $errorCode = self::ERROR_TEST_REF_PARAM;
    		    break;
		    case self::OTU_ERROR_TEST_UNDEFINED:
    		    $errorCode = self::ERROR_TEST_UNDEFINED;
    		    break;
		    case self::OTU_ERROR_TEST_ALREADY_EXIST:
		    	$errorCode = self::ERROR_TEST_ALREADY_EXIST;
		    	break;
	    	case self::OTU_ERROR_TEST_NOT_FOUND:
	    		$errorCode = self::ERROR_TEST_NOT_FOUND;
	    		break;
    		case self::OTU_ERROR_LINK_NOT_FOUND:
    			$errorCode = self::ERROR_LINK_NOT_FOUND;
    			break;
			case self::OTU_ERROR_TEST_UPDATE_FAILED:
				$errorCode = self::ERROR_TEST_UPDATE_FAILED;
				break;
			case self::OTU_ERROR_INVALID_PORT:
				$errorCode = self::ERROR_INVALID_PORT;
				break;				
    		default:
    			break;
    	}
    	return $errorCode;
    } 
    
    /**
     * Get error codes label for tracing without error codes.
     *
     * @return string
     */
    public function getErrorLabel()
    {
    	return $this->getErrorCode();
    }
    
    /**
     * Translates exception error code
     * 
     * @param string $stringErrorCode The exception error code
     * 
     * @return string the exception message
     */
    public function decodeMessage( $stringErrorCode )
    {
        $errorMessage = MSG_ERROR_TEST_UNDEFINED;
        
        switch( $stringErrorCode )
        {
            case self::ERROR_INVALID_LINK_NAME:
                $errorMessage = MSG_ERROR_INVALID_LINK_NAME;
                break;  
            case self::ERROR_INVALID_LINK_ID:
            	$errorMessage = MSG_ERROR_INVALID_LINK_ID;
            	break;                                
            case self::ERROR_DELETE_LINK:
                $errorMessage = MSG_ERROR_DELETE_LINK;
                break;
            case self::ERROR_DELETE_TEST:
                $errorMessage = MSG_ERROR_DELETE_TEST;
            	break;
        	case self::ERROR_CLEAR_TEST_ALARM:
        	    $errorMessage = MSG_ERROR_CLEAR_TEST_ALARM;
        		break;            		 
    		case self::ERROR_INVALID_PORT_OUT:
    			$errorMessage = MSG_ERROR_INVALID_PORT_OUT;
    			break;        		
            case self::ERROR_INVALID_TEST_THRESHOLD_PARAMETERS:
                $errorMessage = MSG_ERROR_INVALID_TEST_THRESHOLD_PARAMETERS;
                break;
            case self::ERROR_MISSING_TEST_THRESHOLD_PARAMETERS:
            	$errorMessage = MSG_ERROR_MISSING_TEST_THRESHOLD_PARAMETERS;
            	break;                
        	case self::ERROR_MISSING_OTDR_TRACE:
        		$errorMessage = MSG_ERROR_MISSING_OTDR_TRACE;
        		break;
    		case self::ERROR_LAST_MARKER_BADLY_SET:
    			$errorMessage = MSG_ERROR_LAST_MARKER_BADLY_SET;
    			break;
    		case self::ERROR_INVALID_MODULE_SELECTED:
    		    $errorMessage = MSG_ERROR_INVALID_MODULE_SELECTED;
    		    break;
    		case self::ERROR_TEST_ADD_ERROR:
    		    $errorMessage = MSG_ERROR_TEST_ADD_ERROR;
    		    break;    		    
		    case self::ERROR_TEST_OK:
    		    $errorMessage =MSG_ERROR_TEST_OK;
    		    break;
		    case self::ERROR_TEST_TEST_RUNNING:
    		    $errorMessage =MSG_ERROR_TEST_TEST_RUNNING;
    		    break;
		    case self::ERROR_TEST_NO_PARAM:
    		    $errorMessage =MSG_ERROR_TEST_NO_PARAM;
    		    break;
		    case self::ERROR_TEST_MISS_LINK:
    		    $errorMessage =MSG_ERROR_TEST_MISS_LINK;
    		    break;
		    case self::ERROR_TEST_MISS_REF_TRACE:
    		    $errorMessage =MSG_ERROR_TEST_MISS_REF_TRACE;
    		    break;
		    case self::ERROR_TEST_SIZE_BUFFER_MARKER:
    		    $errorMessage =MSG_ERROR_TEST_SIZE_BUFFER_MARKER;
    		    break;
		    case self::ERROR_TEST_BAD_MARKER_BUFFER:
    		    $errorMessage =MSG_ERROR_TEST_BAD_MARKER_BUFFER;
    		    break;
		    case self::ERROR_TEST_ALLOCATE_MEMORY:
    		    $errorMessage =MSG_ERROR_TEST_ALLOCATE_MEMORY;
    		    break;
		    case self::ERROR_TEST_SAVE_CONFIG:
    		    $errorMessage =MSG_ERROR_TEST_SAVE_CONFIG;
    		    break;
		    case self::ERROR_TEST_SAVE_INFO:
    		    $errorMessage =MSG_ERROR_TEST_SAVE_INFO;
    		    break;
		    case self::ERROR_TEST_SAVE_DESC:
    		    $errorMessage =MSG_ERROR_TEST_SAVE_DESC;
    		    break;
		    case self::ERROR_TEST_TOO_MUCH_TESTS:
    		    $errorMessage =MSG_ERROR_TEST_TOO_MUCH_TESTS;
    		    break;
		    case self::ERROR_TEST_TYPE:
    		    $errorMessage =MSG_ERROR_TEST_TYPE;
    		    break;
		    case self::ERROR_TEST_UNDEFINED_TEST:
    		    $errorMessage =MSG_ERROR_TEST_UNDEFINED_TEST;
    		    break;
		    case self::ERROR_TEST_TOO_MUCH_LOC:
    		    $errorMessage =MSG_ERROR_TEST_TOO_MUCH_LOC;
    		    break;
		    case self::ERROR_TEST_FUNCT_MISS:
    		    $errorMessage =MSG_ERROR_TEST_FUNCT_MISS;
    		    break;
		    case self::ERROR_TEST_FUNCT:
    		    $errorMessage =MSG_ERROR_TEST_FUNCT;
    		    break;
		    case self::ERROR_TEST_ADD_LOC:
    		    $errorMessage =MSG_ERROR_TEST_ADD_LOC;
    		    break;
		    case self::ERROR_TEST_REF_PARAM:
    		    $errorMessage =MSG_ERROR_TEST_REF_PARAM;
    		    break;
		    case self::ERROR_TEST_UNDEFINED:
    		    $errorMessage =MSG_ERROR_TEST_UNDEFINED;
    		    break;
		    case self::ERROR_TEST_ALREADY_EXIST:
		    	$errorMessage = MSG_ERROR_TEST_ALREADY_EXIST;
		    	break;
		    case self::ERROR_TEST_NOT_FOUND:
		    	$errorMessage = MSG_ERROR_TEST_NOT_FOUND;
		    	break;
		    case self::ERROR_LINK_NOT_FOUND:
		    	$errorMessage = MSG_ERROR_LINK_NOT_FOUND;
		    	break;
	    	case self::ERROR_TEST_UPDATE_FAILED:
	    		$errorMessage = MSG_ERROR_TEST_UPDATE_FAILED;
	    		break;
	        case self::ERROR_LINK_ALREADY_EXIST:
	            $errorMessage = MSG_ERROR_LINK_ALREADY_EXIST;
	            break;
            case self::ERROR_LINK_HARDWARE_CONFIG:
            	$errorMessage = MSG_ERROR_LINK_HARDWARE_CONFIG;
            	break;
            case self::ERROR_LINK_NO_MODULE:
                $errorMessage = MSG_ERROR_LINK_NO_MODULE;
                break;                
            case self::ERROR_ONLY_ONE_TEST_SETUP:
                $errorMessage = MSG_ERROR_ONLY_ONE_TEST_SETUP;
                break;
            case self::ERROR_INVALID_PORT:
            	$errorMessage = MSG_ERROR_INVALID_PORT;
            	break;
            case self::ERROR_FAILED_TO_UPDATE_DELTA_POS_PEAK:
            	$errorMessage = MSG_ERROR_FAILED_TO_UPDATE_DELTA_POS_PEAK;
            	break;
            case self::ERROR_FAILED_TO_UPDATE_PEAK_NAME:
            	$errorMessage = MSG_ERROR_FAILED_TO_UPDATE_PEAK_NAME;
            	break;
            default:
                break;
        }
        return $errorMessage;
    }
}

?>