<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\serviceshelper\media;

use app\util\SMTException;

/**
 * Otu parser socket exception
 * 
 * @author Sylvain Desplat
 *
 */
class SMTMediaException extends SMTException
{
    const ERROR_INVALID_CONFIG = "ERROR_INVALID_CONFIG";
    const ERROR_OPTION_MODEM_NOT_SET = "ERROR_OPTION_MODEM_NOT_SET";
    const ERROR_INVALID_MODEM_TYPE = "ERROR_INVALID_MODEM_TYPE";
    const ERROR_MODEM_NOT_AVAILABLE = "ERROR_MODEM_NOT_AVAILABLE";
    const ERROR_START_EMAIL_TEST = "ERROR_START_EMAIL_TEST";
    const ERROR_START_SMS_TEST = "ERROR_START_SMS_TEST";
    const ERROR_MEDIA = "ERROR_MEDIA";
    const ERROR_SNMP_INVALID_SERVER_NAME = "ERROR_SNMP_INVALID_SERVER_NAME";
    const ERROR_SNMP_INVALID_COMMUNITY = "ERROR_SNMP_INVALID_COMMUNITY";
    const ERROR_SNMP_INVALID_PORT = "ERROR_SNMP_INVALID_PORT";
    const ERROR_SNMP_INVALID_TEST_MESSAGE = "ERROR_SNMP_INVALID_TEST_MESSAGE";
    const ERROR_SNMP_INVALID_HEARTBEAT_PERIOD = "ERROR_SNMP_INVALID_HEARTBEAT_PERIOD";
    
    /**
     *
     * @param string $code integer error code
     * @param string $message detailed message
     */    
    function __construct( $code = NULL, $message = NULL )
    {
    	parent::__construct( $code, $message );
    }

    /**
     * Get error codes label for tracing without error codes.
     *
     * @return string
     */
    public function getErrorLabel()
    {
    	return $this->getErrorCode();
    }
       
    
    /**
     * Translates exception error code
     * 
     * @param string $code The exception error code
     * 
     * @return string the exception message
     */
    public function decodeMessage( $code )
    {
        $errorMessage = MSG_ERROR_MEDIA;
        
        switch( $code )
        {
            case self::ERROR_INVALID_CONFIG:
                $errorMessage = MSG_ERROR_INVALID_CONFIG;
                break;
            case self::ERROR_OPTION_MODEM_NOT_SET:
            	$errorMessage = MSG_ERROR_OPTION_MODEM_NOT_SET;
            	break;
            case self::ERROR_INVALID_MODEM_TYPE:
                $errorMessage = MSG_ERROR_INVALID_MODEM_TYPE;
                break;
        	case self::ERROR_MODEM_NOT_AVAILABLE:
        		$errorMessage = MSG_ERROR_MODEM_NOT_AVAILABLE;
        		break;
            case self::ERROR_START_EMAIL_TEST:
                $errorMessage = MSG_ERROR_START_EMAIL_TEST;
                break;                        	
            case self::ERROR_START_SMS_TEST:
                $errorMessage = MSG_ERROR_START_SMS_TEST;
                break;
            case self::ERROR_SNMP_INVALID_SERVER_NAME:
            	$errorMessage = MSG_ERROR_SNMP_INVALID_SERVER_NAME;
            	break;
        	case self::ERROR_SNMP_INVALID_COMMUNITY:
        		$errorMessage = MSG_ERROR_SNMP_INVALID_COMMUNITY;
        		break;
    		case self::ERROR_SNMP_INVALID_PORT:
    			$errorMessage = MSG_ERROR_SNMP_INVALID_PORT;
    			break;
			case self::ERROR_SNMP_INVALID_TEST_MESSAGE:
				$errorMessage = MSG_ERROR_SNMP_INVALID_TEST_MESSAGE;
				break;    			
			case self::ERROR_SNMP_INVALID_HEARTBEAT_PERIOD:
				$errorMessage = MSG_ERROR_SNMP_INVALID_HEARTBEAT_PERIOD;
				break;				
            default:
                break;
        }
        return $errorMessage;
    }
}

?>