<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2013. All rights reserved.
// *********************************************************
namespace app\serviceshelper\maintenance;

use app\admin\SMTOtuType;
use app\serviceshelper\SMTServiceHelper;


/**
 * Create the activity DTO sent to listening clients
 *
 * @author Sylvain Desplat
*/
class SMTOtuDebug extends SMTServiceHelper
{
    const VAR_LOGS_DIR = "/var/log/";
    
    const OTU_HTTPD_LOGS_DIR = "/var/log/httpd/";
    
    const OTU_LOGS_DIR = "/otu/log/";
    
    const SMARTOTU_AUTOTESTS_DIR = "/otu/smartOTU/autotest/";
    
    const USER_LOG = "user.log";
    
    const SYS_LOG = "syslog";
    
    const AUTOTEST_LOG = "autotest_otu";
    
    const SMART_OTU_LOG = "smart_otu.log";
    
    const OTU_UPGRADE_LOG = "otu_upgrade";
    
    const OTU_QUERY_LOG = "otu_query.log";
    
    const HTTPD_ERROR_LOG = "error_log";
    
    const HTTPD_ACCESS_LOG = "access_log";
    
    /**
     * Snapshot full file path on disk
     *
     */
    static function getSnapshotDir()
    {
        return '/user/harddisk/';
    }    
    
    /**
     * Retrieve the full log file name; returns NULL if not found.
     * 
     * @return the full snapshot file name; returns NULL if not found.
     */
    static function retrieveSnapshotName()
    {
        $directory = self::getSnapshotDir();
        
        //remove previous snapshot
        exec  ('rm -f '.$directory.'get-snapshot.*',$output);
        
        //create snapshot
        exec  ('sudo /sbin/get-snapshot.sh hd', $output, $success);
        
        //retrieve snapshot name
        $snapshotName = NULL;
        $resultArray = glob( $directory.'get-snapshot.*' );
        
        //first snapshot is the snapshot to download; if glob fails, returns false
        if ( $success == 0 && $resultArray != FALSE && !empty( $resultArray ) )
        {
        	$snapshotName = $resultArray[0];
        }

        return $snapshotName;
    }
    
    /**
     * Retrieve the full log file name; returns NULL if not found.
     * @param string $logfilename
     * @return the full log file name; returns NULL if not found.
     */
    static function retrieveLogFileName( $logfilename )
    {
    	$directories = array( self::VAR_LOGS_DIR, self::OTU_LOGS_DIR, self::SMARTOTU_AUTOTESTS_DIR, self::OTU_HTTPD_LOGS_DIR );
    	 
    	$fileName = NULL;
    	//retrieve file name
    	foreach ( $directories as $directory )
    	{
    		$resultArray = glob( $directory.$logfilename );
    		
    		//first file is the file to download; if glob fails, returns false
    		if ( $resultArray != FALSE && !empty( $resultArray ) )
    		{
    			$fileName = $resultArray[0];
    			break;
    		}
    	}
    	return $fileName;
    }
    
    /**
     * Retrieve the log file names;
     * 
     * @return array the log file names;
     */
    static function listLogFileName()
    {    
    	$fileNames = array();
    	$fileNames = self::appendFileNamesIfFound( $fileNames, self::SMARTOTU_AUTOTESTS_DIR, self::AUTOTEST_LOG."*" );
    	$fileNames = self::appendFileNamesIfFound( $fileNames, self::VAR_LOGS_DIR, self::OTU_QUERY_LOG."*" );
    	$fileNames = self::appendFileNamesIfFound( $fileNames, self::VAR_LOGS_DIR, self::OTU_UPGRADE_LOG."*" );    	  	    	
    	$fileNames = self::appendFileNamesIfFound( $fileNames, self::VAR_LOGS_DIR, self::SMART_OTU_LOG."*" );
    	$fileNames = self::appendFileNamesIfFound( $fileNames, self::VAR_LOGS_DIR, self::SYS_LOG."*" );
    	$fileNames = self::appendFileNamesIfFound( $fileNames, self::VAR_LOGS_DIR, self::USER_LOG."*" );
    	$fileNames = self::appendFileNamesIfFound( $fileNames, self::OTU_HTTPD_LOGS_DIR, self::HTTPD_ACCESS_LOG );
    	$fileNames = self::appendFileNamesIfFound( $fileNames, self::OTU_HTTPD_LOGS_DIR, self::HTTPD_ERROR_LOG );
    	
    	return $fileNames;
    }    
    
    /**
     * Search the file names matching the given name, append them to the given array and return the result
     * 
     * @param array $fileNames
     * @param string $dir
     * @param string $fileName
     * @return array New array with file names matching the given name append to the given $fileNames array
     */
    static private function appendFileNamesIfFound( array $fileNames, $dir, $fileName )
    {
        //retrieve file name
        $resultArray = glob( $dir.$fileName );
        if ( $resultArray != FALSE && !empty( $resultArray ) ) 
        { 
            $resultArray = array_map('basename', $resultArray);
            $fileNames = array_merge($fileNames, $resultArray);
        }
        return $fileNames;
    } 
    
}
?>