<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2014. All rights reserved.
// *********************************************************
namespace app\services\setup;

use app\util\SMTStatusDto;

use app\serviceshelper\media\SMTWebService;

use app\services\alarm\webservice\SMTWsOpticalAlarmAttenuationDto;

use app\services\alarm\webservice\SMTWsAlarmDto;

use app\http\SMTHttpPostJson;

use app\settings\SMTSmartOtuSettings;

use app\util\SMTLogger;

use app\services\SMTIService;
use app\services\SMTService;

/**
 * Service to handle the OTU Web service media.
 * 
 * @author Sylvain Desplat
 */
class SMTWebServiceService extends SMTService implements SMTIService
{        
    /**
     * Used to test web service media: process an alarm sent by web service client
     *
     * @url POST /alarm/
     */
    function receiveAlarm( $request_data )
    {
        try 
        {
            $alarmString = sprintf( "received alarm: %s", print_r($request_data, TRUE) );
            SMTLogger::getInstance()->trace($alarmString);
            
            $wsAlarm = SMTWsAlarmDto::getInstance( $request_data );  
    	}
    	catch ( \Exception $e )
    	{		   
    		$this->handleException($e);
    	}    			
    	return $wsAlarm->getJsonData();
    }
    
    /**
     * Used to send a test alarm (system or optical) to the given web service media
     *
     * @url POST /testalarm/
     */
    function sendTestAlarm( $request_data )
    {
        $result = new SMTStatusDto();
        
        try
        {
            $webServiceConfig = $request_data["WebServiceConfig"];
            $webServiceUrl = $request_data["WebServiceUrl"];
            $alarmType = $request_data["AlarmType"];
            $otuSerialNumber = $request_data["OtuSerialNumber"];
            $otuHostName = $request_data["OtuHostName"];
            $ws = new SMTWebService();
            $ws->setContext($this->getContext());
            $ws->setWebServiceUrl($webServiceUrl);
            $ws->sendTestAlarm($alarmType, $otuSerialNumber, $otuHostName);
        }
        catch ( \Exception $e )
        {
            $result->setStatusKO();
            $this->handleException($e);
        }

        return $result->getJsonData();
    }
    
    /**
     * Used to test web service media: send a test alarm to local web service
     *
     * @url GET /test/sendalarm
     */
    function testSendAlarm()
    {
    	if ( SMTSmartOtuSettings::isDebugMode() )
    	{
    		try
    		{
    		    $alarm = new SMTWsAlarmDto();
    		    $alarm->setAlarmId(1, "622");
    		    $attenuation = new SMTWsOpticalAlarmAttenuationDto();
    		    $attenuation->setLinkName("test");    		    
    		    $alarm->setAttenuation($attenuation);
    		    
                $ws = new SMTHttpPostJson();
                $ws->postJsonData( $alarm );
    		}
    		catch ( \Exception $e )
    		{
    			$this->handleException($e);
    		}
    	}
    	return SMTService::RESULT_OK;
    }
    
 }

?>