<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2014. All rights reserved.
// *********************************************************
namespace app\services\setup;

use app\util\SMTInvalidValueException;

use app\util\SMTUtil;

use app\util\SMTRwDto;

/**
 * SNMP configuration DTO.
 * 
 * @author Sylvain Desplat
 */
class SMTSnmpV3Dto extends SMTRwDto
{
    
    /**
     * @var integer
     */
    const SNMP_DEFAULT_PORT = 162;
    
    /**
     * @var integer
     */
    const SNMP_SINGLE_CONFIG_INDEX = 1;
    
    /**
     * @var string
     */    
	protected $manager;
	
	/**
	 * @var string
	 */
	protected $user;
	/**
	 * @var string
	 */
	protected $authType;
	/**
	 * @var string
	 */
	protected $authPassword;
	/**
	 * @var string
	 */
	protected $encryptionType;
	/**
	 * @var string
	 */
	protected $encryptionPassword;
	
	/**
	 * @var integer
	 */
	protected $port = self::SNMP_DEFAULT_PORT;

	/**
	 * @var string
	 */
	protected $trapMessage;
	
	/**
	 * SNMP index = 1 since there is only one configuration
	 * @var integer
	 */
	protected $index = self::SNMP_SINGLE_CONFIG_INDEX;
	
	/**
	 * @param integer
	 */
	public function setPort( $port )
	{
	    if ( !isset($port) || $port === NULL || !SMTUtil::isInt( $port ) )
	    {
	    	throw new SMTInvalidValueException( SMTInvalidValueException::INVALID_VALUE, NULL, "snmp port", $port );
	    }
	    $this->port = SMTUtil::convertToInt( $port );	    
	}
	
	/**
	 * @return integer
	 */
	public function getPort()
	{
		return $this->port;
	}
	
	/**
	 * @param string
	 */
	public function setManager( $manager )
	{
		$this->manager = $manager;
	}

	/**
	 * @return string
	 */
	public function getManager()
	{
		return $this->manager;
	}

	/**
	 * @param string
	 */
	public function setUser( $community )
	{
		$this->user = $community;
	}

	/**
	 * @return string
	 */
	public function getUser()
	{
	    return $this->user;
	}
	
	/**
	 * @return string
	 */
	public function getAuthType()
	{
	    return $this->authType;
	}
	/**
	 * @param string
	 */
	public function setAuthType( $community )
	{
	    $this->authType = $community;
	}
	
	/**
	 * @return string
	 */
	public function getAuthPassword()
	{
	    return $this->authPassword;
	}
	/**
	 * @param string
	 */
	public function setAuthPassword( $community )
	{
	    $this->authPassword = $community;
	}
	
	/**
	 * @return string
	 */
	public function getEncryptionType()
	{
	    return $this->encryptionType;
	}
	/**
	 * @param string
	 */
	public function setEncryptionType( $community )
	{
	    $this->encryptionType = $community;
	}
	
	/**
	 * @return string
	 */
	public function getEncryptionPassword()
	{
	    return $this->encryptionPassword;
	}
	/**
	 * @param string
	 */
	public function setEncryptionPassword( $community )
	{
	    $this->encryptionPassword = $community;
	}
	
	/**
	 * @param string
	 */
	public function setTrapMessage( $message )
	{
		$this->trapMessage = $message;
	}
	
	/**
	 * @return string
	 */
	public function getTrapMessage()
	{
		return $this->trapMessage;
	}
	
	/**
	 * @param number
	 */
	public function setIndex( $index )
	{
		if ( !isset($index) || $index === NULL || !SMTUtil::isInt( $index ) )
		{
			throw new SMTInvalidValueException( SMTInvalidValueException::INVALID_VALUE, NULL, "snmp index", $index );
		}
		$this->index = SMTUtil::convertToInt( $index );
	}
	
	/**
	 * @return number
	 */
	public function getIndex()
	{
		return $this->index;
	}
	
	public function stripHtmlTags()
	{
		$this->user= strip_tags( $this->user);
		$this->manager= strip_tags( $this->manager);
		$this->authType= strip_tags( $this->authType);
		$this->authPassword= strip_tags( $this->authPassword);
		$this->encryptionType= strip_tags( $this->encryptionType);
		$this->encryptionPassword= strip_tags( $this->encryptionPassword);
		
	}
	
	/**
	 * Serialize as Json data the user object.<br>
	 *
	 * @return $objectProperties the object properties serialized as a Json string.
	 */
	function getJsonData()
	{
		$objectProperties = get_object_vars($this);
		$this->serializeObjectAsJsonData( $objectProperties );
		return $objectProperties;
	}

	/**
	 * Returns Dto class name.
	 *
	 * @return string the dtop class name
	 */
	function getDtoClassName()
	{
		return get_class();
	}

	/**
	 * Create the Dto from a Json Dto in an array
	 *
	 * @param array $json_array json data in an array
	 *
	 * @return \app\services\setup\SMTConfEmailDto
	 */
	static function getInstance( array &$json_array )
	{
		$instance = self::forge( get_class(), $json_array );
		$instance->stripHtmlTags();
		return $instance;
	}
}

?>