<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2013. All rights reserved.
// *********************************************************
namespace app\services\autotest;

use app\util\SMTRwDto;

use app\util\SMTUtil;

use app\util\SMTInvalidValueException;

/**
 * Otu autotest setup dto
 * 
 * @author Sylvain Desplat
 */
class SMTAutotestSetupDto extends SMTRwDto
{
    /**
     * Autotest period is fixed to 24h
     * @var integer
     */ 
    const DEFAULT_AUTOTEST_PERIOD_H = 24;
    
    /**
     * Autotest default date in minutes: 0h30
     * @var integer
     */
    const DEFAULT_AUTOTEST_DATE_MIN = 30;

    /**
     * Autotest max date in minutes: 1439 = 23:59
     * @var integer
     */
    const AUTOTEST_MAX_DATE_MIN = 1439;
    
    /**
     * Autotest enabled
     *  
     * @var boolean
     */
    protected $enabled;
    /**
     * Autotest date (in day) in minutes [0-1439]
     * 
     * @var integer
     */
    protected $autotestDateMinutes = self::DEFAULT_AUTOTEST_DATE_MIN;
    
    /**
     * Set the autotest enabled/disabled
     *
     * @param boolean $enabled
     */
    public function setEnabled( $enabled )
    {
    	$this->enabled = $enabled;
    }
    /**
     * Whether the autotest is enabled
     *
     * @return boolean
     */
    public function isEnabled()
    {
    	return $this->enabled;
    }    
    
    /**
     * Set The the autotest date in day in minutes
     *
     * @param integer $autotestDateMinutes [0-1439]
     */
    public function setAutotestDateMinutes( $autotestDateMinutes )
    {
        if ( SMTUtil::isInt( $autotestDateMinutes ) && $autotestDateMinutes >=0 && $autotestDateMinutes <= self::AUTOTEST_MAX_DATE_MIN )
        {
    	    $this->autotestDateMinutes = intval( $autotestDateMinutes );
        }
        else
        {
            throw new SMTInvalidValueException(SMTInvalidValueException::INVALID_VALUE, NULL, "autotestDateMinutes", $autotestDateMinutes);
        }
    }
    /**
     * The the autotest date in day in minutes
     *
     * @return integer
     */
    public function getAutotestDateMinutes()
    {
    	return intval( $this->autotestDateMinutes );
    }
    
    /**
     * Serialize as Json data the object.<br>
     *
     * @return $objectProperties the object properties serialized as a Json array.
     */
    function getJsonData()
    {
    	$objectProperties = get_object_vars($this);
    	$this->serializeObjectAsJsonData( $objectProperties );
    	return $objectProperties;
    }
    
    /**
     * Returns Dto class name.
     *
     * @return string the dtop class name
     */
    function getDtoClassName()
    {
    	return get_class();
    }
    
    /**
     * Create the Dto from a Json Dto in an array
     *
     * @param array $json_array json data in an array
     *
     * @return \app\services\autotest\SMTAutotestSetupDto
     */
    static function getInstance( array &$json_array )
    {
    	return self::forge( get_class(), $json_array );
    }    
}
?>