<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of VIAVI
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from VIAVI
// Copyright JDSU 2016. All rights reserved.
// *********************************************************
namespace app\services\alarm\webservice;

use app\services\alarm\webservice\SMTWsOpticalAlarmAttenuationDto;

use app\util\SMTRwDto;

/**
 * Base OTU optical alarm Dto for web service notification
 * 
 * @author Sylvain Desplat
 */
class SMTWsAlarmDto extends SMTRwDto
{    
    /**
     * AlarmId
     *
     * @var string
     */
    protected $alarmId;
    
    /**
     * OtuSerialNumber
     *
     * @var string
     */
    protected $otuSerialNumber;
    
    /**
     * AlarmType
     *
     * @var string
     */
    protected $alarmType;
    
    /**
     * OTU severity
     *
     * @var string
     */
    protected $alarmSeverity;
    
    /**
     * Alarm creation date timestamp
     *
     * @var integer
     */
    protected $alarmTimestamp;
    
    /**
     * OtuName
     *
     * @var string
     */
    protected $otuName;
    
    /**
     * AlarmSpecificProblem
     *
     * @var string
     */
    protected $alarmSpecificProblem;    
    
    /**
     * AlarmResource
     *
     * @var string
     */
    protected $alarmResource;
    
    /**
     * deviations for the optical alarm
     * @SMTAttributeInfosAnnotation(classname='app\services\alarm\webservice\SMTWsOpticalAlarmAttenuationDto')
     * @var SMTWsOpticalAlarmAttenuationDto
     */        
    protected $opticalAlarmAttenuation = NULL;
        
    /**
     * alarm identifier
     * 
     * @return string
     */
    public function getAlarmId()
    {
    	return $this->alarmId;
    }
    
    /**
     * Set alarm identifier
     *
     * @param string $alarmId
     * @param string $otuSerialNumber
     */
    public function setAlarmId( $alarmId, $otuSerialNumber )
    {
    	$this->alarmId = $otuSerialNumber."_".$alarmId;
    }
    
    /**
     * otu serial number
     *
     * @return string
     */
    public function getOtuSerialNumber()
    {
    	return $this->otuSerialNumber;
    }
    
    /**
     * Set otu serial number
     *
     * @param string $otuSerialNumber
     */
    public function setOtuSerialNumber( $otuSerialNumber )
    {
    	$this->otuSerialNumber = $otuSerialNumber;
    }
    
    /**
     * alarm type
     *
     * @return string
     */
    public function getAlarmType()
    {
    	return $this->alarmType;
    }
    
    /**
     * Set Alarm Type
     *
     * @param string $alarmType
     */
    public function setAlarmType( $alarmType )
    {
    	$this->alarmType = $alarmType;
    }    
    
    /**
     * alarm severity
     *
     * @return string
     */
    public function getAlarmSeverity()
    {
    	return $this->alarmSeverity;
    }
    
    /**
     * Set Alarm Severity
     *
     * @param string $alarmSeverity
     */
    public function setAlarmSeverity( $alarmSeverity )
    {
    	$this->alarmSeverity = $alarmSeverity;
    }    
    
    /**
     * Set otu alarm generation date in UTC
     *
     * @param \SQLite3 $dbConnection
     * @param integer otu alarm generation date
     */
    public function setAlarmTimeStamp( $alarmTimestamp )
    {
    	$this->alarmTimestamp = $alarmTimestamp;
    }
    
    /**
     * Return otu alarm generation date in UTC
     *
     * @return integer otu alarm generation date in UTC
     */
    public function getAlarmTimeStamp()
    {
    	return $this->alarmTimestamp;
    }
    
    /**
     * otu name
     *
     * @return string
     */
    public function getOtuName()
    {
    	return $this->otuName;
    }
    
    /**
     * Set otu name
     *
     * @param string $otuName
     */
    public function setOtuName( $otuName )
    {
    	$this->otuName = $otuName;
    }
    
    /**
     * AlarmSpecificProblem
     *
     * @return string
     */
    public function getAlarmSpecificProblem()
    {
    	return $this->alarmSpecificProblem;
    }
    
    /**
     * Set AlarmSpecificProblem
     *
     * @param string $alarmSpecificProblem
     */
    public function setAlarmSpecificProblem( $alarmSpecificProblem )
    {
    	$this->alarmSpecificProblem = $alarmSpecificProblem;
    }
    
    /**
     * AlarmResource
     *
     * @return string
     */
    public function getAlarmResource()
    {
    	return $this->alarmResource;
    }
    
    /**
     * Set AlarmResource
     *
     * @param string $alarmResource
     */
    public function setAlarmResource( $alarmResource )
    {
    	$this->alarmResource = $alarmResource;
    }
    
    /**
     * Get optical alarm attenuation
     * @return SMTWsOpticalAlarmAttenuationDto
     */
    public function getAttenuation()
    {
    	return $this->opticalAlarmAttenuation;
    }
    
    /**
     * Get optical alarm attenuation
     * @param  SMTWsOpticalAlarmAttenuationDto $attenuation
     */
    public function setAttenuation(SMTWsOpticalAlarmAttenuationDto $attenuation)
    {
    	$this->opticalAlarmAttenuation = $attenuation;
    }
    
    /**
     * severity
     *
     * @return string $severity
     */
    public function getSeverity()
    {
    	return $this->alarmSeverity;
    }
    
    /**
     * set severity
     * 
     * @param string $severity
     */
    public function setSeverity( $severity)
    {
        $this->alarmSeverity = $severity;
    }

    
    /**
     * Serialize as Json data the user object.<br>
     *
     * @return $objectProperties the object properties serialized as a Json string.
     */
    function getJsonData()
    {
    	$objectProperties = get_object_vars($this);
    	$this->serializeObjectAsJsonData( $objectProperties );
    	return $objectProperties;
    }
    
    /**
     * Returns Dto class name.
     *
     * @return string the dtop class name
     */
    function getDtoClassName()
    {
    	return get_class();
    }
    
    /**
     * Create the Dto from a Json Dto in an array
     *
     * @param array $json_array json data in an array
     *
     * @return \app\services\alarm\otu\SMTOtuOpticalAlarmDto
     */
    static function getInstance( array &$json_array )
    {
    	return self::forge( get_class(), $json_array, FALSE );
    }
}
?>