<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\services\alarm\otu;

use app\serviceshelper\alarm\SMTAlarmSeverity;

use app\util\SMTRwDto;


/**
 * OTU alarm peak dto class.
 * 
 * @author Sylvain Desplat
 */
class SMTOtuOpticalAlarmPeakDto extends SMTRwDto
{
// 	OtuOpticalPeaksAlarmSpecificInfoV1.Peaks[ OtuOpticalPeaksAlarmSpecificInfoV1.Peaks.length() - 1 ].ReferenceTopDistanceM = pIn[Index].Reference_Distance;
// 	OtuOpticalPeaksAlarmSpecificInfoV1.Peaks[ OtuOpticalPeaksAlarmSpecificInfoV1.Peaks.length() - 1 ].MeasuredTopDistanceM = pIn[Index].Measure_Distance;
// 	OtuOpticalPeaksAlarmSpecificInfoV1.Peaks[ OtuOpticalPeaksAlarmSpecificInfoV1.Peaks.length() - 1 ].MeasuredBottomDistanceM = pIn[Index].Bottom_Distance;
// 	OtuOpticalPeaksAlarmSpecificInfoV1.Peaks[ OtuOpticalPeaksAlarmSpecificInfoV1.Peaks.length() - 1 ].MeasuredLevelDb = (double)(pIn[Index].Measure_Level / 100.0);
// 	OtuOpticalPeaksAlarmSpecificInfoV1.Peaks[ OtuOpticalPeaksAlarmSpecificInfoV1.Peaks.length() - 1 ].MeasuredLevelValid = pIn[Index].bIs_Valid;
	
    /**
     * @var float
     */
    protected $measuredTopDistanceM;
    
    /**
     * @var float
     */
    protected $measuredBottomDistanceM; 
    
    /**
     * @var float
     */
    protected $referenceTopDistanceM;
    
    /**
     * OTU severity
     * @var string
     */
    protected $severity;
    
    /**
     * Level in dB
     * 
     * @var float
     */
    protected $measuredLevelDb;
    
    /**
     * Whether peak level is valid
     * @var boolean
     */
    protected $measuredLevelValid;
    
    /**
     * peak name
     * @var string
     */
    protected $peakName;
    
    
    /**
     * Whether level attenuation is valid
     * @var boolean
     */
    public function isValidLevel()
    {
        return filter_var( $this->measuredLevelValid, FILTER_VALIDATE_BOOLEAN );
    }
    
    /**
     * Whether top peak level is valid
     * @var boolean
     */
    public function isValidDistance()
    {
    	return filter_var( $this->measuredTopDistanceM, FILTER_VALIDATE_BOOLEAN );        
    }
    
    /**
     * Otu severity
     * 
     * @return string
     */
    public function getOtuSeverity()
    {
    	return $this->severity;
    }
    
    /**
     * SmartOtu Severity
     *
     * @return integer
     */
    public function getSeverityConvertedToSmartOtu()
    {
    	return SMTAlarmSeverity::fromOtuSeverityToSmartOtuSeverity( $this->severity );
    }
    
    /**
     * measuredTopDistanceM in m
     * 
     * @return float
     */
    public function getTopDistance()
    {
    	return $this->measuredTopDistanceM;
    }
    
    /**
     * measuredBottomDistanceM in m
     *
     * @return float
     */
    public function getBottomDistance()
    {
    	return $this->measuredBottomDistanceM;
    }
    
    /**
     * referenceTopDistanceM in m
     *
     * @return float
     */
    public function getReferenceTopDistance()
    {
    	return $this->referenceTopDistanceM;
    }
    
    /**
     * Level in dB
     * 
     * @return float
     */
    public function getLevel()
    {
    	return $this->measuredLevelDb;
    }
    
    /**
     * Otu peak name
     *
     * @return string
     */
    public function getPeakName()
    {
    	return $this->peakName;
    }
    
    /**
     * Serialize as Json data the user object.<br>
     *
     * @return $objectProperties the object properties serialized as a Json string.
     */
    function getJsonData()
    {
    	$objectProperties = get_object_vars($this);
    	$this->serializeObjectAsJsonData( $objectProperties );
    	return $objectProperties;
    }
    
    /**
     * Returns Dto class name.
     *
     * @return string the dtop class name
     */
    function getDtoClassName()
    {
    	return get_class();
    }
    
    /**
     * Create the Dto from a Json Dto in an array
     *
     * @param array $json_array json data in an array
     *
     * @return \app\services\alarm\otu\SMTOtuOpticalAlarmAttenuationDto
     */
    static function getInstance( array &$json_array )
    {
    	return self::forge( get_class(), $json_array, FALSE );
    }
}
?>