<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of VIAVI SOlutions
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from VIAVI Solutions
// Copyright JDSU 2017. All rights reserved.
// *********************************************************
namespace app\services\alarm;


use app\util\SMTDto;

class SMTOpticalAlarmListDto extends SMTDto
{
    /**
     * @SMTAttributeInfosAnnotation(classname='app\services\alarm\SMTPeakOpticalAlarmDto',islist='true')
     * @var array app\services\alarm\SMTPeakOpticalAlarmDto
     */
    protected $peakAlarms = array();     

    /**
     * @SMTAttributeInfosAnnotation(classname='app\services\alarm\SMTAttenuationOpticalAlarmDto')
     * @var SMTAttenuationOpticalAlarmDto
     */
    protected $attenuationOpticalAlarm = NULL;
     
    /**
     * Attach the given optical alarm to its link-test
     *
     * @param SMTOpticalAlarmDto $opticalAlarm
     */
    public function addOpticalAlarm( SMTOpticalAlarmDto $opticalAlarm )
    {
    	if ( $opticalAlarm instanceof SMTAttenuationOpticalAlarmDto )
    	{
    		$this->setAttenuationOpticalAlarm( $opticalAlarm );
    	}
    	else if ( $opticalAlarm instanceof SMTPeakOpticalAlarmDto )
    	{
    		$this->addPeakOpticalAlarm( $opticalAlarm );
    	}
    }
    
    public function setAttenuationOpticalAlarm( SMTAttenuationOpticalAlarmDto $attenuationOpticalAlarm = NULL)
    {
    	$this->attenuationOpticalAlarm = $attenuationOpticalAlarm;
    }
    
    /**
     * @return \app\services\alarm\SMTAttenuationOpticalAlarmDto
     */
    public function getAttenuationOpticalAlarm()
    {
    	return $this->attenuationOpticalAlarm;
    }
        
    /**
     * @param array
     */
    public function setPeakOpticalAlarms( $opticalAlarms )
    {
    	$this->peakAlarms= $opticalAlarms;
    }
    
    /**
     * @param SMTPeakOpticalAlarmDto $peakAlarm
     */
    public function addPeakOpticalAlarm( SMTPeakOpticalAlarmDto $peakAlarm )
    {
    	array_push( $this->peakAlarms, $peakAlarm);
    }
    
    /**
     * @return SMTPeakOpticalAlarmDto
     */
    public function getPeakOpticalAlarms()
    {
    	return $this->peakAlarms;
    }    
        
    /**
     * Serialize as Json data the user object.<br> 
     * 
     * @return $objectProperties the object properties serialized as a Json string.
     */
    function getJsonData()
    {
    	$objectProperties = get_object_vars($this);
        $this->serializeObjectAsJsonData( $objectProperties );
    	return $objectProperties;
    }

    /**
     * Returns Dto class name.
     *
     * @return string the dtop class name
     */
    function getDtoClassName()
    {
        return get_class();
    }      
}


?>