from viavi.evm import *
from viavi.diag import *
import viavi.mts.uts_spi as utsspi
import viavi.mts.uts_bdt as utsbdt  # /usr/lib/python3.8/site-packages/viavi/mts/uts_bdt.py
import time, os
import smbus
import serial

import subprocess
from datetime import datetime

from viavi.mts.fth_reg_def import *
#
#=============================================================================================
@DIAG("OSB : I2C eeprom read at addr 0x50 or 0x54")
def t_osb_eeprom_read(cmd):
#=============================================================================================
#
# OSB board has 2 EEPROMs :
#
# * Legacy (ISU) EEPROM @ address 0x50
# * HETNET EEPROM @ address 0x54
#
# i2cdump -y -f <bus_nb> <i2c_address> c        -- c if for 'char' dump
#                                               -- -f if for 'force' : needed for HETNET EEPROM
#
    try:
        (command, eeprom_i2c_addr) = cmd.split()

        if eeprom_i2c_addr != "0x50" and eeprom_i2c_addr != "0x54":
            print_error("eeprom_i2c_addr : "+eeprom_i2c_addr+" is an invalid value : MUST be 0x50 or 0x54")
            return False

    except:
        print_error("   Syntax error : Command must be : t_osb_eeprom_read <eeprom_i2c_addr>")
        print_error("   where          <eeprom_i2c_addr> = 0x50 or 0x54                     ")
        return False

    eeprom_i2c_bus_nb = sysfs_read_string("/sys/platform/uts_scan/i2c_master_pw")

    i2c_cmde = "i2cdump -y -f "+eeprom_i2c_bus_nb+" "+eeprom_i2c_addr+" c"

    print("i2c cmde is :", i2c_cmde)
    (os.system(i2c_cmde))

    return None
#
#=============================================================================================
@DIAG("OSB : FPGA_VERSION readback using FPGA register access")
def t_osb_fpga_ver_reg(cmd):
#=============================================================================================
#
# Exist /sys/platform/osb_fpga/fpga_ver
# Exist /sys/platform/osb_fpga/fpga_synt_date
#
    glu_reg_base_addr = get_glu_base_addr()

    print("* glu_reg_base_addr = 0x%x\n" % glu_reg_base_addr)

    osb_fpga_version = get_reg_value(glu_reg_base_addr + REG_FPGA_VERSION)
    print("* OSB FPGA version = 0x%x" % osb_fpga_version)

    osb_fpga_synth_date = get_reg_value(glu_reg_base_addr + REG_FPGA_SYNTH_DATE)
    print("* OSB FPGA synthesis date = 0x%x" % osb_fpga_synth_date)

    return True
#
#=============================================================================================
@DIAG("OSB : Periph reset set ON/OFF")
def t_osb_periph_reset_set(cmd):
#=============================================================================================
#
    try:
        (command,consigne) = cmd.split()

    except:
        print_error("   Syntax error : Command must be : t_osb_periph_reset_test <consigne> ")
        print_error("                                                                       ")
        print_error("   where            <consigne> is : <ENABLE|DISABLE>")
        return False

    if consigne == "ENABLE" or consigne == "DISABLE":
        print("   * consigne is %s\n" %consigne)
    else:
        print("   * Error : undefined consigne : MUST be ENABLE or DISABLE")
        return False

    glu_reg_base_addr = get_glu_base_addr()
    print("* glu_reg_base_addr = 0x%x" % glu_reg_base_addr)

    reset_ctrl_value = get_reg_value(glu_reg_base_addr + REG_PERIPH_RST_CTRL)
    print("Current reset_ctrl_value = 0x%x" % reset_ctrl_value)

    if consigne == "ENABLE":
        if reset_ctrl_value == 0:
            print("\nPeriph reset allready Enable")
        else:
            data_val =  0x0
            reg_write(glu_reg_base_addr + REG_PERIPH_RST_CTRL, data_val)

            print ("\n* Enable reset")
            reset_ctrl_value = get_reg_value(glu_reg_base_addr + REG_PERIPH_RST_CTRL)
            print("     => reset_ctrl_value = 0x%x" % reset_ctrl_value)

    if consigne == "DISABLE":
        if reset_ctrl_value == 1:
            print("\nPeriph reset allready Disable")
        else:
            print ("\n* Disable reset")
            data_val =  0x1
            reg_write(glu_reg_base_addr + REG_PERIPH_RST_CTRL, data_val)

            reset_ctrl_value = get_reg_value(glu_reg_base_addr + REG_PERIPH_RST_CTRL)
            print("     => reset_ctrl_value = 0x%x" % reset_ctrl_value)

    return None
#
#=============================================================================================
@DIAG("OSB : XADC PSU Off TEST using /sys/platform drivers")
def t_osb_sys_xadc_psu_off_test(cmd):
#=============================================================================================
#
# Same as t_osb_sys_xadc_test, but to test PSU when they are DISABLE
#
    res = 0

    R1 = 100000
    R2 = 8250
    val_hex = sysfs_read_string("/sys/platform/osb-xadc/aux0")
    print(" * aux0 : val_hex = ", val_hex, "; %d" % int(val_hex, 16))
    val = int(val_hex, 16) / 16
    val_mv = (val * 1000 / 4095)
    print("   VDD12V8 / AUX0 = %d mV" % ( ((R2 + R1) * val_mv) / R2))
    res = res + sysfs_check("/sys/platform/osb-xadc/aux0", "tension VCC12V8",
                            vmin=int(CONST("mtsps.aux0.min", ((((-150 * R2) / (R1 + R2)) * 4095) / 1000) * 16)),
                            vmax=int(CONST("mtsps.aux0.max", ((((150 * R2) / (R1 + R2)) * 4095) / 1000) * 16)))
    print("     VDD12V8. res = %d" %res)

    R1 = 10000
    R2 = 2260
    val_hex = sysfs_read_string("/sys/platform/osb-xadc/aux1")
    print(" * aux1 : val_hex = ", val_hex, "; %d" % int(val_hex, 16))
    val = int(val_hex, 16) / 16
    val_mv = (val * 1000 / 4095)
    print("   VDD5V0 / AUX1 = %d mV" % ( ((R2 + R1) * val_mv) / R2))
    res = res + sysfs_check("/sys/platform/osb-xadc/aux1", "tension VCC5V",
                            vmin=int(CONST("mtsps.aux1.min", ((((-150 * R2) / (R1 + R2)) * 4095) / 1000) * 16)),
                            vmax=int(CONST("mtsps.aux1.max", ((((150 * R2) / (R1 + R2)) * 4095) / 1000) * 16)))
    print("     VDD5V0. res = %d" %res)

    R1 = 10000
    R2 = 6810
    val_hex = sysfs_read_string("/sys/platform/osb-xadc/aux2")
    print(" * aux2 : val_hex = ", val_hex, "; %d" % int(val_hex, 16))
    val = int(val_hex, 16) / 16
    val_mv = (val * 1000 / 4095)
    print("   VDD1V8 / AUX2 = %d mV" % ( ((R2 + R1) * val_mv) / R2))
    res = res + sysfs_check("/sys/platform/osb-xadc/aux2", "tension VCC1V8",
                            vmin=int(CONST("mtsps.aux2.min", ((((-150 * R2) / (R1 + R2)) * 4095) / 1000) * 16)),
                            vmax=int(CONST("mtsps.aux2.max", ((((150 * R2) / (R1 + R2)) * 4095) / 1000) * 16)))
    print("     VDD1V8. res = %d" %res)

    R1 = 10000
    R2 = 1780
    val_hex = sysfs_read_string("/sys/platform/osb-xadc/aux8")
    print(" * aux8 : val_hex = ", val_hex, "; %d" % int(val_hex, 16))
    val = int(val_hex, 16) / 16
    val_mv = (val * 1000 / 4095)
    print("   VDD5V8 / AUX8 = %d mV" % ( ((R2 + R1) * val_mv) / R2))
    res = res + sysfs_check("/sys/platform/osb-xadc/aux8", "tension VCC5V8",
                            vmin=int(CONST("mtsps.aux8.min", ((((-150 * R2) / (R1 + R2)) * 4095) / 1000) * 16)),
                            vmax=int(CONST("mtsps.aux8.max", ((((150 * R2) / (R1 + R2)) * 4095) / 1000) * 16)))
    print("     VDD5V8. res = %d" %res)

    R1 = 10000
    R2 = 3320
    val_hex = sysfs_read_string("/sys/platform/osb-xadc/aux9")
    print(" * aux9 : val_hex = ", val_hex, "; %d" % int(val_hex, 16))
    val = int(val_hex, 16) / 16
    val_mv = (val * 1000 / 4095)
    print("   VDD3V3 / AUX9 = %d mV" % ( ((R2 + R1) * val_mv) / R2))
    res = res + sysfs_check("/sys/platform/osb-xadc/aux9", "tension VCC3V3",
                            vmin=int(CONST("mtsps.aux9.min", ((((-150 * R2) / (R1 + R2)) * 4095) / 1000) * 16)),
                            vmax=int(CONST("mtsps.aux9.max", ((((150 * R2) / (R1 + R2)) * 4095) / 1000) * 16)))
    print("     VDD3V3. res = %d" %res)

    R1 = 10000
    R2 = 2260
    R1P = 22600
    R2P = 8250
    val_hex = sysfs_read_string("/sys/platform/osb-xadc/aux10")
    print(" * aux10 : val_hex = ", val_hex, "; %d" % int(val_hex, 16))
    val = int(val_hex, 16) / 16
    val_mv = (val * 1000 / 4095)
    valn_mv = ((R2 + R1) * val_mv) / R2
    print("   VEE12V8 / AUX10 = -%d mV" % ( ((R1P * valn_mv) / R2P)))
    res = res + sysfs_check("/sys/platform/osb-xadc/aux10", "tension VEE12V8",
                            vmin=int(CONST("mtsps.aux10.min",
                                           (((((R2P * (-150) / R1P) * R2) / (R1 + R2)) * 4095) / 1000) * 16)),
                            vmax=int(CONST("mtsps.aux10.max",
                                           (((((R2P * (150) / R1P) * R2) / (R1 + R2)) * 4095) / 1000) * 16)))
    print("     VEE12V8. res = %d" %res)

    R1 = 10000
    R2 = 2260
    R1P = 22600
    R2P = 17800
    val_hex = sysfs_read_string("/sys/platform/osb-xadc/aux11")
    print(" * aux11 : val_hex = ", val_hex, "; %d" % int(val_hex, 16))
    val = int(val_hex, 16) / 16
    val_mv = (val * 1000 / 4095)
    valn_mv = ((R2 + R1) * val_mv) / R2
    print("   VEE5V8 / AUX11 = -%d mV" % ( (R1P * valn_mv) / R2P))
    res = res + sysfs_check("/sys/platform/osb-xadc/aux11", "tension VEE5V8",
                            vmin=int(CONST("mtsps.aux11.min",
                                           (((((R2P * (-150) / R1P) * R2) / (R1 + R2)) * 4095) / 1000) * 16)),
                            vmax=int(CONST("mtsps.aux11.max",
                                           (((((R2P * (150) / R1P) * R2) / (R1 + R2)) * 4095) / 1000) * 16)))
    print ("    VEE5V8 = %d" %res)

    if res == 7:
        return True
    else:
        return False
#
#=============================================================================================
@DIAG("OSB : sicutil solution read")
def t_osb_sicutil_sol_r(cmd):
#=============================================================================================
#
    try:
        (command, field) = cmd.split()
    except:
        print_error("# Command must be: t_osb_sicutil_sol_r field/'all'")
        return False

    Hetnet_Module = "4"
    if (field == "all"):
        p = subprocess.Popen("sicutil -r -sol %s" % (Hetnet_Module), shell=True, stdin=subprocess.PIPE,
                             stdout=subprocess.PIPE, stderr=subprocess.STDOUT, close_fds=True)
    else:
        print(field)
        p = subprocess.Popen("sicutil -r -sol %s %s" % (Hetnet_Module, field), shell=True, stdin=subprocess.PIPE,
                             stdout=subprocess.PIPE, stderr=subprocess.STDOUT, close_fds=True)
    p.wait()
    err = p.returncode
    lines = p.stdout.readlines()
    #print("err is %s; lines is %s" %(err,lines))
    l = False
    for l in lines:
        l = l.decode("utf-8").strip()
        if l:
            print_info("# %s" % (l))
            columns = [item.strip() for item in l.split(':')]
    if l:
        return True
    else:
        return False
#
#================================================================================
@DIAG("OSB : Master SPI debug")
def t_osb_master_spi_dbg(cmd):
#================================================================================
#
    verbose_flag = True

    (dtss_fpga_rdy, dtss_presence, switch_presence) = module_presence_info(verbose_flag)

    glu_reg_base_addr = get_glu_base_addr()

    if verbose_flag:
        show_mux_ctrl_reg_contents()

    spi_ctrl_value = get_reg_value(glu_reg_base_addr + REG_OSB_SPI_CTRL)
    print("* OSB SPI Master SPI_CTRL register = 0x%x" % spi_ctrl_value)
    print("     - SPI_CTRL(0) = spi_start = %d" %(spi_ctrl_value & 0x1))
    print("     - SPI_CTRL(1) = spi_sel16 = %d" %(spi_ctrl_value & 0x2))
    print("     - SPI_CTRL(2) = spi_cpol  = %d" %(spi_ctrl_value & 0x4))
    print("     - SPI_CTRL(3) = spi_cpha  = %d" %(spi_ctrl_value & 0x8))
    spi_ctrl_freq = (spi_ctrl_value & 0xff00) / 256
    print("     - SPI_CTRL(15:8) = spi_freq  = %d" %spi_ctrl_freq)

    input("\nB200 analysis : Enter")

    side = 0
    slice = B200_SLICE
    if (os.path.exists("/dev/uts_spi")):
        Utsspi = utsspi.SpiModule(side, slice, "/dev/uts_spi")
    else:
        print("Utsspi driver (/dev/uts_spi) not found")
        return False
        
    b200_cpld_version = Utsspi.read_mod_register8(SPI_ADDR_VERSION)
    print("\n* B200 CPLD version is 0x%2x (using utsspi driver)" % b20_cpld_version)

    cpld_version = Utsspi.read_mod_register8(SPI_ADDR_VERSION)
    print("\n* 2nd read of B200 CPLD version is 0x%2x (using utsspi driver)" % cpld_version)

    spi_ctrl_value = get_reg_value(glu_reg_base_addr + REG_OSB_SPI_CTRL)
    print("\n* OSB SPI Master SPI_CTRL register = 0x%x" % spi_ctrl_value)
    print("     - SPI_CTRL(0) = spi_start = %d" %(spi_ctrl_value & 0x1))
    print("     - SPI_CTRL(1) = spi_sel16 = %d" %(spi_ctrl_value & 0x2))
    print("     - SPI_CTRL(2) = spi_cpol  = %d" %(spi_ctrl_value & 0x4))
    print("     - SPI_CTRL(3) = spi_cpha  = %d" %(spi_ctrl_value & 0x8))
    spi_ctrl_freq = (spi_ctrl_value & 0xff00) / 256
    print("     - SPI_CTRL(15:8) = spi_freq = %d" %spi_ctrl_freq)

    input("\nEnter")

    print("\nRead/Write OSB FPGA SPI_Master registers : ")

    data_wr = 0xa5a55a5a
    print("\nSPI Master slv0 write value = 0x%x" % data_wr)
    reg_write(glu_reg_base_addr + REG_OSB_SPI_SLV0, data_wr)

    spi_slv0 = get_reg_value(glu_reg_base_addr + REG_OSB_SPI_SLV0)
    print("SPI Master slv0 read = 0x%x" % spi_slv0)

    data_wr = 0x12345678
    print("SPI Master slv1 write value = 0x%x" % data_wr)
    reg_write(glu_reg_base_addr + REG_OSB_SPI_SLV1, data_wr)

    spi_slv1 = get_reg_value(glu_reg_base_addr + REG_OSB_SPI_SLV1)
    print("SPI Master slv1 read = 0x%x" % spi_slv1)

    input("\nEnter")
    print("\n Initialize SPI Master SPI_CTRL register (SPI_START = '0')")

    # SPI_CTRL (slv2) write access :
    #
    # SPI_CTRL(0)    = MOD_SPI_START
    # SPI_CTRL(1)    = MOD_SPI_SEL16
    # SPI_CTRL(2)    = MOD_SPI_CPOL
    # SPI_CTRL(3)    = MOD_SPI_CPHA
    # SPI_CTRL(15:8) = MOD_SPI_FREQ
    #
    # SPI_CTRL read access : spi_ctrl(31:8) & spi_status & spi_ctrl(6:0)

    mod_spi_start = 0x0
    mod_spi_sel16 = 0x1
    mod_spi_cpol  = 0x1
    mod_spi_cpha  = 0x1
    mod_spi_freq  = 0x5
    spi_ctrl = (mod_spi_freq * 256) | (mod_spi_cpha * 8) | (mod_spi_cpol * 4) | (mod_spi_sel16 *2) | mod_spi_start

    print("SPI Master SPI_CTRL write value = 0x%x" % spi_ctrl)
    reg_write(glu_reg_base_addr + REG_OSB_SPI_CTRL, spi_ctrl)

    spi_ctrl_value = get_reg_value(glu_reg_base_addr + REG_OSB_SPI_CTRL)
    print("SPI Master SPI_CTRL read value = 0x%x" % spi_ctrl_value)

    # SPI_TRANSMIT reg (slv3) Write access : slv3(31:0)

    spi_slv3 = 0x2468ace2
    print("SPI Master SPI_TRANSMIT write value = 0x%x" % spi_slv3)
    reg_write(glu_reg_base_addr + REG_OSB_SPI_TRANSMIT, spi_slv3)

    #
    # SPI_TRANSMIT reg read access : spi_slv3(31:16) & spi_receive_value(15:0)
    #                                where spi_slv3(23:16) = spi_transmit_value(7:0)

    spi_transmit_value = get_reg_value(glu_reg_base_addr + REG_OSB_SPI_TRANSMIT)
    print("SPI Master SPI_TRANSMIT read value = 0x%x" % spi_transmit_value)

    input("\nEnter")

    print("\nLaunch spi_tfer (SPI_START = '1') with data = 0x68")

    mod_spi_sel16 = 0x0
    mod_spi_cpol  = 0x0
    mod_spi_cpha  = 0x0
    mod_spi_freq  = 0x5
    mod_spi_start = 0x1
    spi_ctrl = (mod_spi_freq * 256) | (mod_spi_cpha * 8) | (mod_spi_cpol * 4) | (mod_spi_sel16 *2) | mod_spi_start

    print("SPI Master SPI_CTRL write value = 0x%x" % spi_ctrl)
    reg_write(glu_reg_base_addr + REG_OSB_SPI_CTRL, spi_ctrl)

    input("\nEnter")

    print("\n Initialize SPI Master SPI_CTRL register with new FREQ (SPI_START = '0')")
    mod_spi_start = 0x0
    mod_spi_freq  = 0x20
    spi_ctrl = (mod_spi_freq * 256) | (mod_spi_cpha * 8) | (mod_spi_cpol * 4) | (mod_spi_sel16 *2) | mod_spi_start

    print("\nSPI Master SPI_CTRL write value = 0x%x" % spi_ctrl)
    reg_write(glu_reg_base_addr + REG_OSB_SPI_CTRL, spi_ctrl)

    print("\nLaunch spi_tfer (SPI_START = '1') with data = 0x68")

    mod_spi_start = 0x1
    spi_ctrl = (mod_spi_freq * 256) | (mod_spi_cpha * 8) | (mod_spi_cpol * 4) | (mod_spi_sel16 *2) | mod_spi_start

    print("SPI Master SPI_CTRL write value = 0x%x" % spi_ctrl)
    reg_write(glu_reg_base_addr + REG_OSB_SPI_CTRL, spi_ctrl)

    input("\nEnter")

    print("\n Initialize SPI Master SPI_CTRL register with new FREQ (SPI_START = '0')")
    mod_spi_start = 0x0
    mod_spi_sel16 = 0x0
    mod_spi_cpol  = 0x0
    mod_spi_cpha  = 0x0
    mod_spi_freq  = 0xf
    spi_ctrl = (mod_spi_freq * 256) | (mod_spi_cpha * 8) | (mod_spi_cpol * 4) | (mod_spi_sel16 *2) | mod_spi_start

    print("\nSPI Master SPI_CTRL write value = 0x%x" % spi_ctrl)
    reg_write(glu_reg_base_addr + REG_OSB_SPI_CTRL, spi_ctrl)

    print("\nLaunch spi_tfer (SPI_START = '1') with data = 0x68")
    mod_spi_start = 0x1
    spi_ctrl = (mod_spi_freq * 256) | (mod_spi_cpha * 8) | (mod_spi_cpol * 4) | (mod_spi_sel16 *2) | mod_spi_start

    print("SPI Master SPI_CTRL write value = 0x%x" % spi_ctrl)
    reg_write(glu_reg_base_addr + REG_OSB_SPI_CTRL, spi_ctrl)

    # B200

    input("\nB200 analysis : Enter")

    side = 0
    slice = B200_SLICE
    if (os.path.exists("/dev/uts_spi")):
        Utsspi = utsspi.SpiModule(side, slice, "/dev/uts_spi")
    else:
        print("Utsspi driver (/dev/uts_spi) not found")
        return False

    cpld_version = Utsspi.read_mod_register8(SPI_ADDR_VERSION)
    print("\n* B200 CPLD version is 0x%2x (using utsspi driver)" % cpld_version)

    cpld_version = Utsspi.read_mod_register8(SPI_ADDR_VERSION)
    print("\n* 2nd B200 CPLD version read : 0x%2x (using utsspi driver)" % cpld_version)

    input("\nEnter")

    print("\nRead CPLD reg. cAddress_RegLvds_7_0 using Utsspi driver :")

    value = Utsspi.read_mod_register8(SPI_ADDR_REGLVDS_7_0)
    print("\nreg. value @ 0x%1x (cAddress_RegLvds_7_0) : 0x%x" %(SPI_ADDR_REGLVDS_7_0, value))

    input("\nEnter")

    wr_data = 0x55
    print("\nWrite 0x%x into CPLD reg. cAddress_RegLvds_7_0 using Utsspi driver:" %wr_data)
    ver = Utsspi.write_mod_register8(SPI_ADDR_REGLVDS_7_0, wr_data)

    input("\nEnter")
    print("\nRead CPLD reg. cAddress_RegLvds_7_0 using Utsspi driver:")

    value = Utsspi.read_mod_register8(SPI_ADDR_REGLVDS_7_0)
    print("reg. value after write @ 0x%1x (cAddress_RegLvds_7_0) : 0x%x" %(SPI_ADDR_REGLVDS_7_0, value))

    input("\nEnter")
    wr_data = 0x1
    print("\nWrite 0x%x into CPLD reg. cAddress_RegLvds_7_0 using Utsspi driver:" %wr_data)
    ver = Utsspi.write_mod_register8(SPI_ADDR_REGLVDS_7_0, wr_data)

    input("\nEnter")
    print("\nRead CPLD reg. cAddress_RegLvds_7_0 using Utsspi driver:")
    value = Utsspi.read_mod_register8(SPI_ADDR_REGLVDS_7_0)
    print("reg. value after reset @ 0x%1x (cAddress_RegLvds_7_0) : 0x%x" %(SPI_ADDR_REGLVDS_7_0, value))

    input("\n header transfer : Enter")

    # header trfer :
    #================

    header = 0xc0

    print("\nSPI Master SPI_TRANSMIT write value = 0x%x" % header)
    reg_write(glu_reg_base_addr + REG_OSB_SPI_TRANSMIT, (header * 65536))

    header_value = get_reg_value(glu_reg_base_addr + REG_OSB_SPI_TRANSMIT)
    print("SPI Master SPI_TRANSMIT read value = 0x%x" % header_value)

    time.sleep(0.5)

    mod_spi_sel16 = 0x0
    mod_spi_cpol  = 0x0
    mod_spi_cpha  = 0x0
    mod_spi_freq  = 0xf

    mod_spi_start = 0x1
    spi_ctrl = (mod_spi_freq * 256) | (mod_spi_cpha * 8) | (mod_spi_cpol * 4) | (mod_spi_sel16 *2) | mod_spi_start

    print("SPI Master SPI_CTRL write value = 0x%x" % spi_ctrl)
    reg_write(glu_reg_base_addr + REG_OSB_SPI_CTRL, spi_ctrl)

    input("\n reg_addr transfer : Enter")

    # reg_addr trfer :
    #==================

    reg_addr_value = SPI_ADDR_REGLVDS_7_0 * 2

    print("\nSPI Master SPI_TRANSMIT write value = 0x%x" % reg_addr_value)
    reg_write(glu_reg_base_addr + REG_OSB_SPI_TRANSMIT, ( reg_addr_value * 65536))

    addr_value = get_reg_value(glu_reg_base_addr + REG_OSB_SPI_TRANSMIT)
    print("SPI Master SPI_TRANSMIT read value = 0x%x" % addr_value)

    print("SPI Master SPI_CTRL write value = 0x%x" % spi_ctrl)
    reg_write(glu_reg_base_addr + REG_OSB_SPI_CTRL, spi_ctrl)

    # reg_addr_value = SPI_ADDR_VERSION

    input("\n data transfer : Enter")

    # data trfer :
    #==============

    data_reg_value = 0x55

    print("\nSPI Master SPI_TRANSMIT write value = 0x%x" % data_reg_value)
    reg_write(glu_reg_base_addr + REG_OSB_SPI_TRANSMIT, (data_reg_value * 65536))

    print("SPI Master SPI_CTRL write value = 0x%x" % spi_ctrl)
    reg_write(glu_reg_base_addr + REG_OSB_SPI_CTRL, spi_ctrl)

    input("\n Verify spi transfer using utsspi driver : Enter")

    time.sleep(3)

    spi_ctrl_value = get_reg_value(glu_reg_base_addr + REG_OSB_SPI_CTRL)
    print("\n\n* OSB SPI Master SPI_CTRL register = 0x%x" % spi_ctrl_value)
    print("     - SPI_CTRL(0) = spi_start = %d" %(spi_ctrl_value & 0x1))
    print("     - SPI_CTRL(1) = spi_sel16 = %d" %(spi_ctrl_value & 0x2))
    print("     - SPI_CTRL(2) = spi_cpol  = %d" %(spi_ctrl_value & 0x4))
    print("     - SPI_CTRL(3) = spi_cpha  = %d" %(spi_ctrl_value & 0x8))
    spi_ctrl_freq = (spi_ctrl_value & 0xff00) / 256
    print("     - SPI_CTRL(15:8) = spi_freq  = %d" %spi_ctrl_freq)

    cpld_version = Utsspi.read_mod_register8(SPI_ADDR_VERSION)
    print("\n* B200 CPLD version read : 0x%2x (using utsspi driver)" % cpld_version)

    time.sleep(0.5)

    cpld_version = Utsspi.read_mod_register8(SPI_ADDR_VERSION)
    print("\n* B200 CPLD version read : 0x%2x (using utsspi driver)" % cpld_version)

    input("\nEnter")

    print("\nRead CPLD reg. cAddress_RegLvds_7_0 using Utsspi driver:")
    value = Utsspi.read_mod_register8(SPI_ADDR_REGLVDS_7_0)
    print("reg. value after reset @ 0x%1x (cAddress_RegLvds_7_0) : 0x%x" %(SPI_ADDR_REGLVDS_7_0, value))

    input("\nEnter")

    cpld_version = Utsspi.read_mod_register8(SPI_ADDR_VERSION)
    print("\n* B200 CPLD version read : 0x%2x (using utsspi driver)" % cpld_version)

    input("\nEnter")

    print("\n* OSB SPI Master SPI_CTRL register = 0x%x" % spi_ctrl_value)
    print("     - SPI_CTRL(0) = spi_start = %d" %(spi_ctrl_value & 0x1))
    print("     - SPI_CTRL(1) = spi_sel16 = %d" %(spi_ctrl_value & 0x2))
    print("     - SPI_CTRL(2) = spi_cpol  = %d" %(spi_ctrl_value & 0x4))
    print("     - SPI_CTRL(3) = spi_cpha  = %d" %(spi_ctrl_value & 0x8))
    spi_ctrl_freq = (spi_ctrl_value & 0xff00) / 256
    print("     - SPI_CTRL(15:8) = spi_freq  = %d" %spi_ctrl_freq)

    return None
#
#********************************************
@DIAG("OSB : UIC (IT_CTRLER) Registers CHECK")
def t_osb_uic_reg_check(cmd):
#********************************************
#
    try:
        if len(cmd.split()) == 3:
            (command, consigne, verbose_flag) = cmd.split(' ')

            if verbose_flag == "verbose":
                verbose = True
            else:
                print_error("   * Syntax error : 2nd arg is <%s> must be : verbose" %verbose_flag)
                return False
        else:
            (command, consigne) = cmd.split()
            verbose = False

        print_info("* consigne is "+consigne)
        arg_list = consigne.split('|')

    except:
        print("")
        print_error("   Syntax error : Cmd must be : t_osb_uic_reg_check <consigne>              ")
        print_error("                                                                            ")
        print_error("   with               <consigne> is : <REG_LIST> <verbose_flag>             ")
        print_error("   where              * <REG_LIST> = IT_TYPE|IT_STATUS|IT_CLEAR|IT_MASK|ALL ")
        print_error("                                                                            ")
        print_error("                         Note : <verbose_flag> parameter is optional        ")
        print("")
        return False

    reg_name_list = ['IT_TYPE', 'IT_STATUS', 'IT_CLEAR', 'IT_MASK']
    todo_list     = ['NO', 'NO', 'NO', 'NO']

    if verbose:
        print("\narg_list is ", arg_list, "\n")

    arg_error_nb = 0
    for elt in enumerate(arg_list):
        if elt[1] not in reg_name_list:
            if elt[1] != 'ALL':
                print_error("     * Error : ", elt[1], "is not a correct arg")
                arg_error_nb += 1

    if arg_error_nb > 0:
        return False

    if 'ALL' in arg_list:
        i = 0
        while i < len(todo_list):
            todo_list[i] = "YES"
            i += 1
    else:
        for elt in enumerate(arg_list):
            if elt[1] in reg_name_list:
                if elt[1] == "IT_TYPE":
                    j = 0
                elif elt[1] == "IT_STATUS":
                    j = 1
                elif elt[1] == "IT_CLEAR":
                    j = 2
                else:
                    j = 3
                todo_list[j] = 'YES'

    i = 0
    while i < len(todo_list):
        if verbose:
            print("todo_list[%d] = %s" %(i, clear_todo_list[i]))
        if todo_list[i] == "YES":
            reg_name = reg_name_list[i]
            show_uic_reg_contents(reg_name)
        i += 1

    return None
#
#*****************************************************
@DIAG("OSB : UIC IT_CTRLER CLEAR_Register SET ON/OFF")
def t_osb_uic_clear_reg_set(cmd):
#*****************************************************
#
    try:
        if len(cmd.split()) == 3:
            (command, consigne, verbose_flag) = cmd.split(' ')

            if verbose_flag == "verbose":
                verbose = True
            else:
                print_error("   Syntax error : 2nd arg is <%s> must be : verbose" %verbose_flag)
                return False

        else:
            (command, consigne) = cmd.split()
            verbose = False

        print_info("* consigne is "+consigne)
        (clear_list, OnOFF_flag) = consigne.split('-')

    except:
        print("")
        print_error("   Syntax error : Cmd must be : t_osb_uic_clear_reg_set <consigne>              ")
        print_error("                                                                                ")
        print_error("   with           <consigne> is : <CLEAR_LIST>-<OnOff_FLAG> <verbose_flag>      ")
        print_error("   where          * <CLEAR_LIST> = CLEAR0|..|CLEAR4|ALL                         ")
        print_error("                           example : CLEAR0|CLEAR3|CLEAR4                       ")
        print_error("                  * <OnOff_FLAG> = ON|OFF                                       ")
        print_error("                  * <verbose_flag> = MUST be verbose ONLY                       ")
        print_error("                                     Note : <verbose_flag> parameter is optional")
        print("")
        return False

    clear_name_list    = ["CLEAR0", "CLEAR1", "CLEAR2",  "CLEAR3", "CLEAR4", "CLEAR5", "CLEAR6", "CLEAR7"]
    clear_todo_list    = ["NO",     "NO",     "NO",      "NO",     "NO",     "NO",     "NO",     "NO"]

    arg_error_nb = 0

    if OnOFF_flag == "ON" or OnOFF_flag == "OFF":
        pass
    else:
        arg_error_nb += 1
        print_error("     * Error : OnOFF_flag = %s is not a correct value" %OnOFF_flag)
        print()

    arg_list = clear_list.split('|')

    if verbose:
        print("\narg_list is ", arg_list, "\n")

    for elt in enumerate(arg_list):
        if elt[1] not in clear_name_list:
            if elt[1] != 'ALL':
                print_error("     * Error : ", elt[1], "is not a correct arg")
                arg_error_nb += 1

    if arg_error_nb > 0:
        return False

    glu_reg_base_addr = get_glu_base_addr()

    if 'ALL' in arg_list:
        i = 0
        while i < len(clear_todo_list):
            clear_todo_list[i] = "YES"
            i += 1
    else:
        for elt in enumerate(arg_list):
            if elt[1] in clear_name_list:
                if elt[1] == "CLEAR0":
                    j = 0
                elif elt[1] == "CLEAR1":
                    j = 1
                elif elt[1] == "CLEAR2":
                    j = 2
                elif elt[1] == "CLEAR3":
                    j = 3
                elif elt[1] == "CLEAR4":
                    j = 4
                elif elt[1] == "CLEAR5":
                    j = 5
                elif elt[1] == "CLEAR6":
                    j = 6
                else:
                    j = 7
                clear_todo_list[j] = "YES"

    if OnOFF_flag == "ON":
        bit_value = 0x1
        reg_value = 0x0
    else:
        bit_value = 0
        reg_value = 0xff

    and_mask = [0xfe, 0xfd, 0xfb, 0xf7, 0xef, 0xdf, 0xbf, 0x7f]
    i = 0
    while i < len(clear_todo_list):
        if verbose:
            print("clear_todo_list[%d] = %s" %(i, clear_todo_list[i]))
        if clear_todo_list[i] == "YES":
            bit_val = bit_value << i
            if OnOFF_flag == "ON":
                reg_value |= bit_val
            else:
                reg_value &= and_mask[i]
        i += 1

    if verbose:
        print("reg_value = 0x%x" %reg_value)

    it_clear_reg = get_reg_value(glu_reg_base_addr + REG_IT_CLEAR)
    print("\n* REG_IT_CLEAR (R/W) Initial read value = 0x%x" %it_clear_reg)
    print("  Note : '1' : bit is cleared ; '0' no action")

    if OnOFF_flag == "ON":
        it_clear_wr_value = it_clear_reg | reg_value
    else:
        it_clear_wr_value = it_clear_reg & reg_value

    print("* write 0x%x into REG_IT_CLEAR reg. " %it_clear_wr_value)
    reg_write(glu_reg_base_addr + REG_IT_CLEAR, it_clear_wr_value)

    it_clear_reg = get_reg_value(glu_reg_base_addr + REG_IT_CLEAR)
    print("* REG_IT_CLEAR (R/W) read value = 0x%x" %it_clear_reg)

    if verbose:
        show_uic_reg_contents('IT_CLEAR')

    return None
#
#*****************************************************
@DIAG("OSB : UIC (IT_CTRLER) MASK Register SET ON/OFF")
def t_osb_uic_mask_reg_set(cmd):
#*****************************************************
#
    try:
        if len(cmd.split()) == 3:
            (command, consigne, verbose_flag) = cmd.split(' ')

            if verbose_flag == "verbose":
                verbose = True
            else:
                print_error("   Syntax error : 2nd arg is <%s> must be : verbose" %verbose_flag)
                return False
        else:
            (command, consigne) = cmd.split()
            verbose = False

        print_info("* consigne is "+consigne)
        (mask_list, OnOFF_flag) = consigne.split('-')

    except:
        print("")
        print_error("   Syntax error : Cmd must be : t_osb_uic_mask_reg_set <consigne>             ")
        print_error("                                                                              ")
        print_error("   with             <consigne> is : <MASK_LIST>-<OnOff_FLAG> <verbose_flag>   ")
        print_error("   where            * <REG_LIST> = MASK0|..|MASK4|ALL                         ")
        print_error("                           example : MASK0|MASK3|MASK4                        ")
        print_error("                    * <OnOff_FLAG> = ON|OFF                                   ")
        print_error("                    * <verbose_flag> = MUST be verbose ONLY                   ")
        print_error("                                   Note : <verbose_flag> parameter is optional")
        print("")
        return False

    mask_name_list    = ["MASK0", "MASK1", "MASK2",  "MASK3", "MASK4", "MASK5", "MASK6", "MASK7"]

    mask_todo_list    = ["NO",    "NO",    "NO",     "NO",    "NO",    "NO",    "NO",     "NO"]


    arg_error_nb = 0

    if OnOFF_flag == "ON" or OnOFF_flag == "OFF":
        pass
    else:
        arg_error_nb += 1
        print_error("     * Error : OnOFF_flag = %s is not a correct value" %OnOFF_flag)
        print()

    arg_list = mask_list.split('|')

    if verbose:
        print("\narg_list is ", arg_list, "\n")

    for elt in enumerate(arg_list):
        if elt[1] not in mask_name_list:
            if elt[1] != 'ALL':
                print_error("     * Error : ", elt[1], "is not a correct arg")
                arg_error_nb += 1

    if arg_error_nb > 0:
        return Fail

    glu_reg_base_addr = get_glu_base_addr()

    if 'ALL' in arg_list:
        i = 0
        while i < len(mask_todo_list):
            mask_todo_list[i] = "YES"
            i += 1
    else:
        for elt in enumerate(arg_list):
            if elt[1] in mask_name_list:
                if elt[1] == "MASK0":
                    j = 0
                elif elt[1] == "MASK1":
                    j = 1
                elif elt[1] == "MASK2":
                    j = 2
                elif elt[1] == "MASK3":
                    j = 3
                elif elt[1] == "MASK4":
                    j = 4
                elif elt[1] == "MASK5":
                    j = 5
                elif elt[1] == "MASK6":
                    j = 6
                else:
                    j = 7
                mask_todo_list[j] = "YES"

    if OnOFF_flag == "ON":
        bit_value = 0x1
        reg_value = 0x0
    else:
        bit_value = 0
        reg_value = 0xff

    and_mask = [0xfe, 0xfd, 0xfb, 0xf7, 0xef, 0xdf, 0xbf, 0x7f]

    i = 0
    #reg_value = 0x0
    reg_value = get_reg_value(glu_reg_base_addr + REG_IT_MASK)
    while i < len(mask_todo_list):
        if verbose:
            print("mask_todo_list[%d] = %s" %(i, mask_todo_list[i]))
        if mask_todo_list[i] == "YES":
            bit_val = bit_value << i
            if OnOFF_flag == "ON":
                reg_value |= bit_val
            else:
                reg_value &= and_mask[i]
        i += 1

    it_mask_reg = get_reg_value(glu_reg_base_addr + REG_IT_MASK)
    print("\n* REG_IT_MASK (R/W) Initial read value = 0x%x" %it_mask_reg)
    print("  Note : '1' : bit is masked ; '0' no action")

    if OnOFF_flag == "ON":
        it_mask_wr_value = it_mask_reg | reg_value
    else:
        it_mask_wr_value = it_mask_reg & reg_value

    print("* write 0x%x into REG_IT_MASK reg. " %it_mask_wr_value)
    reg_write(glu_reg_base_addr + REG_IT_MASK, it_mask_wr_value)

    if verbose:
        show_uic_reg_contents('IT_MASK')

    return None
#
#=============================================================================================
@DIAG("OSB : IRQ_CTRL register readback")
def t_osb_irq_ctrl_reg_rdback(cmd):
#============================================================================================= 
#
    show_irq_dbg_ctrl_contents()
    
    return None
#
#=============================================================================================
@DIAG("OSB : IRQs Debug")
def t_osb_irq_dbg(cmd):
#=============================================================================================
#
    verbose_flag = True
    debug = True
    
    test1 = False   # bit0 = 0 : Generate an IT
    test2 = False   # bit0 = 1 : Don't Generate an IT
    test3 = False   # positive pulse : Generate an IT
    test4 = True    # negative pulse : Generate an IT
    
    uic_write_access = True
    
    if (os.path.exists("/dev/uts_spi")):
        side = 0
        slice = DTSS_SLICE
        Utsspi = utsspi.SpiModule(side, slice, "/dev/uts_spi")
    else:
        print("Utsspi driver (/dev/uts_spi) not found")
        return False
    
    # Verify if DTSS module presence 
    
    (dtss_fpga_rdy, dtss_presence, switch_presence) = module_presence_info(verbose_flag)
    
    if dtss_presence:
        if dtss_fpga_rdy:
            msg = "DTSS module detected : FPGA loaded"
        else:
            msg = "DTSS module detected : FPGA notloaded"
            
        print_info("\n   *** %s" %msg)
    else:
        # Verify if Z112 board present :
        z112_cpld_version = Utsspi.read_mod_register8(Z112_SPI_XVERSION)

        if z112_cpld_version == 0x90:
            print("Z112 board detected (CPLD Version 0x%2x)" %z112_cpld_version)
        else:
            print("Z112 board detected (CPLD Version = 0x%x (expected = 0x90)" %z112_cpld_version)

    glu_reg_base_addr = get_glu_base_addr()
    
    print("\n* Display UIC registers before launching test :")
    
    show_uic_reg_contents('ALL')

    print("\n OSB UIC register : clear all ITs :")
    
    if 0 == 1:
        it_clear_wr_value = 0xffffffff
        print("* write 0x%x into REG_IT_CLEAR reg. " %it_clear_wr_value)
        reg_write(glu_reg_base_addr + REG_IT_CLEAR, it_clear_wr_value)
        
        show_uic_reg_contents('ALL')
        
        it_clear_wr_value = 0xffffffe0
        print("* write 0x%x into REG_IT_CLEAR reg. " %it_clear_wr_value)
        reg_write(glu_reg_base_addr + REG_IT_CLEAR, it_clear_wr_value)
    
    if 0 == 1:
        # Unmask REG_DBG_CTRL IT :
        
        print("\n OSB UIC register : unmask DBG_GPIO_IT :") 
        
        it_mask_value = 0xfffffff7
        print("* write 0x%x into REG_IT_MASK reg." %it_mask_value)
        reg_write(glu_reg_base_addr + REG_IT_MASK, it_mask_value)
    
    print("\n* OSB UIC register values :")

    show_uic_reg_contents('ALL')
    
    print("\n* OSB : Reset REG_DBG_CTRL register (gpio_IRQ_o = 1) :")
    wr_data = 0x0
    reg_write(glu_reg_base_addr + REG_DBG_CTRL, wr_data)
    
    show_irq_dbg_ctrl_contents()

    if test1:
        print("\n* OSB : Test1 : REG_DBG_CTRL bit0 write access to generate an IRQ") 
        if debug:
            input("* Press Enter to launch test1")
            print()

        print("\n    * REG_DBG_CTRL reg. write bit0 = 0 (bit_0_write mask (bit16) = 1)")
        
        bit_0 = 0
        bit0_mask = 1
        wr_data = (bit0_mask << 16) | bit_0
        reg_write(glu_reg_base_addr + REG_DBG_CTRL, wr_data)
        
        #dbg_ctrl_val = get_reg_value(glu_reg_base_addr + REG_DBG_CTRL)

        # DBG_GPIO_IRQ IT is generated : clear IT fastly :
        
        print("\nverify if DBG_GPIO_IRQ IT is generated")
        it_status_reg = get_reg_value(glu_reg_base_addr + REG_IT_STATUS)
        
        it_clear_wr_value = 0xffffffe8
        #print("\n* write 0x%x into REG_IT_CLEAR reg. " %it_clear_wr_value)
        reg_write(glu_reg_base_addr + REG_IT_CLEAR, it_clear_wr_value)

        it_clear_wr_value = 0xffffffe0
        #print("\n* write 0x%x into REG_IT_CLEAR reg. " %it_clear_wr_value)
        reg_write(glu_reg_base_addr + REG_IT_CLEAR, it_clear_wr_value)
        
        if ((it_status_reg & 0x8) >> 3):
            print_ok("\nDBG_GPIO_IRQ IT generated : PASS")
        else:
            print_error("\nDBG_GPIO_IRQ IT Not generated : FAIL")

        # verify gpio_IRQ_o (REG_DBG_CTRL bit27) is equal to bit_0
        
        show_irq_dbg_ctrl_contents()
        
        dbg_ctrl_val = get_reg_value(glu_reg_base_addr + REG_DBG_CTRL)
        gpio_IRQ_o = (dbg_ctrl_val & 0x8000000) >> 27
        
        if gpio_IRQ_o  == bit_0:
            print_ok("\nTest1 : write bit0 = %d : gpio_IRQ_o = %d : PASS" %(bit_0, gpio_IRQ_o))
        else:
            print_error("\nTest1 : write bit0 = %d : gpio_IRQ_o = %d : FAIL" %(bit_0, gpio_IRQ_o))

        print("\nverify DBG_GPIO_IRQ Status bit goes 1")
        
        show_uic_reg_contents('ALL')
        
    if test2:
        print("\n    * REG_DBG_CTRL reg. write bit0 = 1 (bit_0_write mask (bit16) = 1)")
        if debug:
            input("    * Press Enter to continue")
            print()
        
        bit_0 = 1
        bit0_mask = 1
        wr_data = (bit0_mask << 16) | bit_0
        reg_write(glu_reg_base_addr + REG_DBG_CTRL, wr_data)

        print("\nverify if DBG_GPIO_IRQ IT is generated")
        it_status_reg = get_reg_value(glu_reg_base_addr + REG_IT_STATUS)
        
        if ((it_status_reg & 0x8) >> 3):
            print_ok("\nDBG_GPIO_IRQ IT generated : FAIL")
        else:
            print_error("\nDBG_GPIO_IRQ IT not generated : PASS")
            
        # verify gpio_IRQ_o (REG_DBG_CTRL bit27) is equal to bit_0
        
        show_irq_dbg_ctrl_contents()

        dbg_ctrl_val = get_reg_value(glu_reg_base_addr + REG_DBG_CTRL)
        gpio_IRQ_o = (dbg_ctrl_val & 0x8000000) >> 27
        
        if gpio_IRQ_o  == bit_0:
            print_ok("\nTest2 : write bit0 = %d : gpio_IRQ_o = %d : PASS" %(bit_0, gpio_IRQ_o))
        else:
            print_error("\nTest2 : write bit0 = %d : gpio_IRQ_o = %d : FAIL" %(bit_0, gpio_IRQ_o))
    
    if test3:
        print("\n* OSB : Test3 : positive pulse generation")
        if debug:
            input("* Press Enter to launch test3")
            print()

        # print("\nOSB : Reset REG_DBG_CTRL register (gpio_IRQ_o = 1) :")
        # wr_data = 0
        # reg_write(glu_reg_base_addr + REG_DBG_CTRL, wr_data)

        bit17_mask = 1 << 17
        
        wr_data = bit17_mask
        reg_write(glu_reg_base_addr + REG_DBG_CTRL, wr_data)
        
        print("\nverify if DBG_GPIO_IRQ IT is generated")
        it_status_reg = get_reg_value(glu_reg_base_addr + REG_IT_STATUS)

        # DBG_GPIO_IRQ IT is generated : clear IT fastly :

        it_clear_wr_value = 0xffffffe8
        #print("\n* write 0x%x into REG_IT_CLEAR reg. " %it_clear_wr_value)
        reg_write(glu_reg_base_addr + REG_IT_CLEAR, it_clear_wr_value)
        
        it_clear_wr_value = 0xffffffe0
        #print("\n* write 0x%x into REG_IT_CLEAR reg. " %it_clear_wr_value)
        reg_write(glu_reg_base_addr + REG_IT_CLEAR, it_clear_wr_value)
        
        if ((it_status_reg & 0x8) >> 3):
            print_ok("\nDBG_GPIO_IRQ IT generated : PASS")
        else:
            print_error("\nDBG_GPIO_IRQ IT not generated : FAIL")

        # verify gpio_IRQ_o (REG_DBG_CTRL bit27) raising to '1' has been detected
        
        show_irq_dbg_ctrl_contents()
        
        dbg_ctrl_val = get_reg_value(glu_reg_base_addr + REG_DBG_CTRL)
        gpio_IRQ_o = (dbg_ctrl_val & 0x8000000) >> 27
        exp_val = 0
        
        if gpio_IRQ_o  == 0:
            print_ok("\nTest3 : positive pulse : gpio_IRQ_o = %d : PASS" %exp_val)
        else:
            print_error("\nTest3 : positive pulse : gpio_IRQ_o = %d : FAIL" %exp_val)    

    if test4:
        print("\n******************************************")
        print("* OSB : Test4 : negative pulse generation")
        print("******************************************")
         
        if debug:
            input("\n* Press Enter to launch test4")
            print()
        
        # print("\nOSB : Reset REG_DBG_CTRL register :")
        # wr_data = 0
        # reg_write(glu_reg_base_addr + REG_DBG_CTRL, wr_data)
        
        #time.sleep(0.1)
        
        bit18_mask = 1 << 18
        wr_data = bit18_mask
        reg_write(glu_reg_base_addr + REG_DBG_CTRL, wr_data)
        
        # Note : 2 following lines have no impact regarding IT clear operation
        
        #dbg_ctrl_val = get_reg_value(glu_reg_base_addr + REG_DBG_CTRL)
        #reg_write(glu_reg_base_addr + REG_DBG_CTRL, 0x0)
        
        print("\nVerify DBG_GPIO_IRQ IT is generated")
        it_status_reg = get_reg_value(glu_reg_base_addr + REG_IT_STATUS)

        # DBG_GPIO_IRQ IT is generated : clear IT fastly :

        if uic_write_access:
            it_clear_wr_value = 0xffffffe8
            #print("\n* write 0x%x into REG_IT_CLEAR reg. " %it_clear_wr_value)
            reg_write(glu_reg_base_addr + REG_IT_CLEAR, it_clear_wr_value)
            
            it_clear_wr_value = 0xffffffe0
            #print("\n* write 0x%x into REG_IT_CLEAR reg. " %it_clear_wr_value)
            reg_write(glu_reg_base_addr + REG_IT_CLEAR, it_clear_wr_value)

        if ((it_status_reg & 0x8) >> 3):
            print_ok("\nDBG_GPIO_IRQ IT generated : PASS")
        else:
            print_error("\nDBG_GPIO_IRQ IT not generated : FAIL")

        # verify gpio_IRQ_o (REG_DBG_CTRL bit27) raising to '1' has been detected

        show_irq_dbg_ctrl_contents()
        
        dbg_ctrl_val = get_reg_value(glu_reg_base_addr + REG_DBG_CTRL)
        gpio_IRQ_o = (dbg_ctrl_val & 0x8000000) >> 27
        exp_val = 1
        
        if gpio_IRQ_o == 1:
            print_ok("\nTest4 : negative pulse : gpio_IRQ_o = %d : PASS" %exp_val)
        else:
            print_error("\nTest4 : negative pulse : gpio_IRQ_o = %d : FAIL" %exp_val)    
    
    print("\n* Display UIC registers at test completion :")
    show_uic_reg_contents('ALL')

    return None
#
#=============================================================================================
@DIAG("OSB : JTAG registers test")
def t_osb_jtag_reg_test(cmd):
#=============================================================================================
#
# FPGA JTAG registers :
#
# * REG_URJTAG_FREQ(31:0)
#
#   REG_URJTAG_IO :
#
#       REG_URJTAG_IO(0)    = TDI_MASK
#       REG_URJTAG_IO(1)    = TDI_VAL
#       REG_URJTAG_IO(2)    = TMS_MASK
#       REG_URJTAG_IO(3)    = TMS_VAL
#       REG_URJTAG_IO(31:4) = TCK_NBVAL
#
# Note : writing into REG_URJTAG_IO register generates a jtag_start (if jtag_busy = 0)
#
# * REG_URJTAG_STATUS :
#
#       RD_BCK = SLV2(31:2) & (busy or start) & tdo
#
# * REG_URJTAG_FREQ(31:0)
#
#=============================================================================================
#
    glu_reg_base_addr = get_glu_base_addr()
    print("* glu_reg_base_addr = 0x%x" %glu_reg_base_addr, "\n")

    print("REG_URJTAG_FREQ register Test\n")

    wr_value = 0xffffffff
    reg_write(glu_reg_base_addr + REG_URJTAG_FREQ, wr_value)

    rd_value = get_reg_value(glu_reg_base_addr + REG_URJTAG_FREQ)
    print("rd_value = 0x%x (exp-data = 0x%x)" %(rd_value, wr_value))

    wr_value = 0x0
    reg_write(glu_reg_base_addr + REG_URJTAG_FREQ, wr_value)

    rd_value = get_reg_value(glu_reg_base_addr + REG_URJTAG_FREQ)
    print("rd_value = 0x%x (exp-data = 0x%x)" %(rd_value, wr_value))

    wr_value = 0xa5a55a5a
    reg_write(glu_reg_base_addr + REG_URJTAG_FREQ, wr_value)

    rd_value = get_reg_value(glu_reg_base_addr + REG_URJTAG_FREQ)
    print("rd_value = 0x%x (exp-data = 0x%x)" %(rd_value, wr_value))

    print("")
    #
    print("REG_URJTAG_IO register Test\n")

    wr_value = 0xffffffff
    reg_write(glu_reg_base_addr + REG_URJTAG_IO, wr_value)

    rd_value = get_reg_value(glu_reg_base_addr + REG_URJTAG_IO)
    print("rd_value = 0x%x (exp-data = 0x%x)" %(rd_value, wr_value))

    wr_value = 0x0
    reg_write(glu_reg_base_addr + REG_URJTAG_IO, wr_value)

    rd_value = get_reg_value(glu_reg_base_addr + REG_URJTAG_IO)
    print("rd_value = 0x%x (exp-data = 0x%x)" %(rd_value, wr_value))

    wr_value = 0x5a5aa5a5
    reg_write(glu_reg_base_addr + REG_URJTAG_IO, wr_value)

    rd_value = get_reg_value(glu_reg_base_addr + REG_URJTAG_IO)
    print("rd_value = 0x%x (exp-data = 0x%x)" %(rd_value, wr_value))

    print("")
    #
    print("REG_URJTAG_DUMMY register Test\n")

    wr_value = 0xffffffff
    reg_write(glu_reg_base_addr + REG_URJTAG_DUMMY, wr_value)

    rd_value = get_reg_value(glu_reg_base_addr + REG_URJTAG_DUMMY)
    print("rd_value = 0x%x (exp-data = 0x%x)" %(rd_value, wr_value))

    wr_value = 0x0
    reg_write(glu_reg_base_addr + REG_URJTAG_DUMMY, wr_value)

    rd_value = get_reg_value(glu_reg_base_addr + REG_URJTAG_IO)
    print("rd_value = 0x%x (exp-data = 0x%x)" %(rd_value, wr_value))

    wr_value = 0x5a5aa5a5
    reg_write(glu_reg_base_addr + REG_URJTAG_DUMMY, wr_value)

    rd_value = get_reg_value(glu_reg_base_addr + REG_URJTAG_DUMMY)
    print("rd_value = 0x%x (exp-data = 0x%x)" %(rd_value, wr_value))

    print("")
    #

    print("REG_URJTAG_STATUS register Test\n")

    wr_value = 0x0
    reg_write(glu_reg_base_addr + REG_URJTAG_STATUS, wr_value)

    rd_value = get_reg_value(glu_reg_base_addr + REG_URJTAG_STATUS)
    print("rd_value = 0x%x (exp-data = 0x%x)" %(rd_value, wr_value))

    wr_value = 0xffffffff
    reg_write(glu_reg_base_addr + REG_URJTAG_STATUS, wr_value)

    rd_value = get_reg_value(glu_reg_base_addr + REG_URJTAG_STATUS)
    print("rd_value = 0x%x (exp-data = 0x%x)" %(rd_value, wr_value))

    print("")

    return None
#
#=============================================================================================
@DIAG("OSB : JTAG debug")
def t_osb_jtag_dbg(cmd):
#=============================================================================================
#
    glu_reg_base_addr = get_glu_base_addr()
    print("glu_reg_base_addr = 0x%x" %glu_reg_base_addr, "\n")

    # Verify REG_MUX_CTRL reg. correctly set :

    rd_value = get_reg_value(glu_reg_base_addr + REG_MUX_CTRL)
    mux_sel = rd_value & 0x1
    mux_oen  = (rd_value & 0x2) >> 1
    if mux_sel == 1:
        msg = "(DTSS)"
    else:
        msg = "(SWITCH)"

    print("REG_MUX_CTRL reg. rd_value = 0x%x => mux_sel = %d %s ; mux_oen = %d\n" %(rd_value, mux_sel, msg, mux_oen))

    if mux_oen == 1:
        print("mux_oen = %d => no module detected" %mux_oen)
        return False
    else:
        print("************************************")
        if mux_sel == 0:
            print("****** SWITCH module detected ******")
        else:
            print("****** DTSS module detected ******")
        print("************************************\n")

    # Verify busy = 0

    rd_value = get_reg_value(glu_reg_base_addr + REG_URJTAG_STATUS)

    busy_or_start = (rd_value & 0x2)/2
    tdo = rd_value & 0x1

    if busy_or_start == 0:
        print("REG_URJTAG_STATUS reg. : rd_value = 0x%x : busy_or_start_bit = %d ; tdo = %d" %(rd_value, busy_or_start, tdo))
    else:
        print("Error (busy = 1) : REG_URJTAG_STATUS reg. : rd_value = 0x%x : busy_or_start_bit = %d ; tdo = %d" %(rd_value, busy_or_start, tdo))

    # Set jtag_tck frequency (period = 700ns)

    freq_value = 0x20
    reg_write(glu_reg_base_addr + REG_URJTAG_FREQ, freq_value)

    # lauch a jtag_start :

    tdi_msk_0 = 0x0 # TDI masked
    tdi_msk_1 = 0x1 # TDI unmasked
    tdi_val_0 = 0x0
    tdi_val_1 = 0x2
    tms_msk_0 = 0x0
    tms_msk_1 = 0x4
    tms_val_0 = 0x0
    tms_val_1 = 0x8

    # lauch 4 TCK pulses

    tck_nb    = 0x40

    wr_value = tck_nb | tms_val_0 | tms_msk_1 | tdi_val_0 | tdi_msk_1
    print("REG_URJTAG_IO reg. wr_value = 0x%x => jtag_start generated" %wr_value)
    print("     * tck_nb | tms_val_1 | tms_msk_1 | tdi_val_0 | tdi_msk_1")
    print("         TCK : %d pulses ; TMS = 0 (unmasked); TDI = 0 (unmasked)" %(tck_nb/16))

    reg_write(glu_reg_base_addr + REG_URJTAG_IO, wr_value)

    rd_value = get_reg_value(glu_reg_base_addr + REG_URJTAG_STATUS)

    busy_or_start = (rd_value & 0x2)/2
    tdo = rd_value & 0x1

    if busy_or_start == 0:
        print("REG_URJTAG_STATUS reg. : rd_value = 0x%x : busy_or_start_bit = %d ; tdo = %d" %(rd_value, busy_or_start, tdo))
    else:
        print("Error (busy = 1) : REG_URJTAG_STATUS reg. : rd_value = 0x%x : busy_or_start_bit = %d ; tdo = %d" %(rd_value, busy_or_start, tdo))

    input("\nEnter")

    # lauch 16 TCK pulses

    tck_nb    = 0x100

    print("\n*************")
    print("* Toggle TDI")
    print("*************")

    wr_value = tck_nb | tms_val_0 | tms_msk_0 | tdi_val_1 | tdi_msk_1
    print("\nI.1. REG_URJTAG_IO reg : wr_value = 0x%x" %wr_value)
    print("     * tck_nb | tms_val_0 | tms_msk_0 | tdi_val_1 | tdi_msk_1")
    print("         TCK : %d pulses ; TMS = unchanged (masked); TDI toggle = 1 (toggle ; unmasked)" %(tck_nb/16))
    reg_write(glu_reg_base_addr + REG_URJTAG_IO, wr_value)

    input("\nEnter")

    tck_nb    = 0x20

    wr_value = tck_nb | tms_val_0 | tms_msk_0 | tdi_val_1 | tdi_msk_0
    print("\nI.2. REG_URJTAG_IO reg : wr_value = 0x%x" %wr_value)
    print("     * tck_nb | tms_val_0 | tms_msk_0 | tdi_val_1 | tdi_msk_0")
    print("         TCK : %d pulses ; TMS = unchanged (masked) ; TDI = unchanged (masked)" %(tck_nb/16))
    reg_write(glu_reg_base_addr + REG_URJTAG_IO, wr_value)

    input("\nEnter")

    tck_nb    = 0x100

    wr_value = tck_nb | tms_val_0 | tms_msk_0 | tdi_val_0 | tdi_msk_0
    print("\nI.3. REG_URJTAG_IO reg : wr_value = 0x%x" %wr_value)
    print("     * tck_nb | tms_val_0 | tms_msk_0 | tdi_val_0 | tdi_msk_0")
    print("         TCK : %d pulses ; TMS = unchanged (masked) ; TDI = unchanged (masked)" %(tck_nb/16))
    reg_write(glu_reg_base_addr + REG_URJTAG_IO, wr_value)

    input("\nEnter")

    wr_value = tck_nb | tms_val_0 | tms_msk_0 | tdi_val_0 | tdi_msk_1
    print("\nI.4. REG_URJTAG_IO reg : wr_value = 0x%x" %wr_value)
    print("     * tck_nb | tms_val_0 | tms_msk_0 | tdi_val_0 | tdi_msk_1")
    print("         TCK : %d pulses ; TMS = unchanged (masked) ; TDI = 1 (toggle ; unmasked)" %(tck_nb/16))
    reg_write(glu_reg_base_addr + REG_URJTAG_IO, wr_value)

    print("\n***********")
    print("Toggle TMS")
    print("***********")

    # lauch 8 TCK pulses

    tck_nb    = 0x080

    wr_value = tck_nb | tms_val_1 | tms_msk_1 | tdi_val_1 | tdi_msk_1
    print("\nII.1. REG_URJTAG_IO reg : wr_value = 0x%x" %wr_value)
    print("     * tck_nb | tms_val_1 | tms_msk_1 | tdi_val_1 | tdi_msk_1")
    print("         TCK : %d pulses ; TMS = 1 (unmasked) ; TDI = 1 (unmasked)" %(tck_nb/16))
    reg_write(glu_reg_base_addr + REG_URJTAG_IO, wr_value)

    input("\nEnter")

    wr_value = tck_nb | tms_val_0 | tms_msk_1 | tdi_val_0 | tdi_msk_0
    print("\nII.2. REG_URJTAG_IO reg : wr_value = 0x%x" %wr_value)
    print("     * tck_nb | tms_val_0 | tms_msk_1 | tdi_val_1 | tdi_msk_1")
    print("         TCK : %d pulses ; TMS = 0 (toggle ; unmasked) ; TDI = unchanged (masked)" %(tck_nb/16))
    reg_write(glu_reg_base_addr + REG_URJTAG_IO, wr_value)

    input("\nEnter")

    wr_value = tck_nb | tms_val_1 | tms_msk_0 | tdi_val_0 | tdi_msk_1
    print("\nII.3. REG_URJTAG_IO reg : wr_value = 0x%x" %wr_value)
    print("     * tck_nb | tms_val_1 | tms_msk_0 | tdi_val_1 | tdi_msk_1")
    print("         TCK : %d pulses ; TMS = unchanged (masked) ; TDI = 0 (toggle ; unmasked)" %(tck_nb/16))
    reg_write(glu_reg_base_addr + REG_URJTAG_IO, wr_value)

    input("\nEnter")

    wr_value = tck_nb | tms_val_1 | tms_msk_1 | tdi_val_1 | tdi_msk_1
    print("\nII.4. REG_URJTAG_IO reg : wr_value = 0x%x" %wr_value)
    print("     * tck_nb | tms_val_1 | tms_msk_1 | tdi_val_1 | tdi_msk_1")
    print("         TCK : %d pulses ; TMS = 1 (toggle ; unmasked) ; TDI = 1 (toggle ; unmasked)" %(tck_nb/16))
    reg_write(glu_reg_base_addr + REG_URJTAG_IO, wr_value)

    return None
#
#**********************************************************
@DIAG("OSB : BDT seq_core_misc and bdt_ctrl reg. status")
def t_osb_bdt_status(cmd):
#**********************************************************

    show_seq_core_misc_reg_contents()   # defined into fth_reg_def.py
    show_bdt_ctrl_reg_contents()        # defined into fth_reg_def.py

    return None
#
#=============================================================================================
@DIAG("OSB : FPGA GLU registers check")
def t_osb_glu_reg_check(cmd):
#=============================================================================================
#
# BAR_64K=$(lspci -s 06:00.0 -v | grep size=128K | cut -f 3 -d " ")
# BAR_1=$(echo $BAR_64K | awk '{print $1}');echo -n "BAR 1 : ";echo  $BAR_1
#
    glu_reg_base_addr = get_glu_base_addr()
    print("glu_reg_base_addr = 0x%x" % glu_reg_base_addr)

    fpga_version_value = get_reg_value(glu_reg_base_addr + REG_FPGA_VERSION)
    print("fpga_version_value = 0x%x" % fpga_version_value)

    fpga_synth_date_value = get_reg_value(glu_reg_base_addr + REG_FPGA_SYNTH_DATE)
    print("fpga_synth_date_value = 0x%x" % fpga_synth_date_value)

    psu_ctrl_value = get_reg_value(glu_reg_base_addr + REG_PSU_CTRL)
    print("psu_ctrl_value = 0x%x" % psu_ctrl_value)

    shifter_ctrl_value = get_reg_value(glu_reg_base_addr + REG_SHIFTER_CTRL)
    print("shifter_ctrl_value = 0x%x" % shifter_ctrl_value)

    mux_ctrl_value = get_reg_value(glu_reg_base_addr + REG_MUX_CTRL)
    print("mux_ctrl_value = 0x%x" % mux_ctrl_value)

    msel_value = get_reg_value(glu_reg_base_addr + REG_MSEL)
    print("msel_value = 0x%x" % msel_value)

    sys_fan1_value = get_reg_value(glu_reg_base_addr + REG_SYS_FAN1_CTRL)
    print("sys_fan1_value = 0x%x" % sys_fan1_value)

    sys_fan2_value = get_reg_value(glu_reg_base_addr + REG_SYS_FAN2_CTRL)
    print("sys_fan2_value = 0x%x" % sys_fan2_value)

    sys_fan3_value = get_reg_value(glu_reg_base_addr + REG_SYS_FAN3_CTRL)
    print("sys_fan3_value = 0x%x" % sys_fan3_value)

    sys_fan1_tachi_value = get_reg_value(glu_reg_base_addr + REG_SYS_FAN1_TACHI_VAL)
    sys_fan1_freq = float(sys_fan1_tachi_value)
    print("sys_fan1_tachi_value = 0x%x (freq = %fHz)" % (sys_fan1_tachi_value, sys_fan1_freq))

    sys_fan2_tachi_value = get_reg_value(glu_reg_base_addr + REG_SYS_FAN2_TACHI_VAL)
    sys_fan2_freq = float(sys_fan2_tachi_value)
    print("sys_fan2_tachi_value = 0x%x (freq = %5.3fHz)" % (sys_fan2_tachi_value, sys_fan2_freq))

    sys_fan3_tachi_value = get_reg_value(glu_reg_base_addr + REG_SYS_FAN3_TACHI_VAL)
    sys_fan3_freq = float(sys_fan3_tachi_value)
    print("sys_fan3_tachi_value = 0x%x (freq = %fHz)" % (sys_fan3_tachi_value, sys_fan3_freq))

    osb_fan1_value = get_reg_value(glu_reg_base_addr + REG_OSB_FAN1_CTRL)
    print("osb_fan1_value = 0x%x" % osb_fan1_value)

    osb_fan2_value = get_reg_value(glu_reg_base_addr + REG_OSB_FAN2_CTRL)
    print("osb_fan2_value = 0x%x" % osb_fan2_value)

    osb_fan1_tachi_value = get_reg_value(glu_reg_base_addr + REG_OSB_FAN1_TACHI_VAL)
    osb_fan1_freq = float(osb_fan1_tachi_value)
    print("osb_fan1_tachi_value = 0x%x (%fHz)" % (osb_fan1_tachi_value, osb_fan1_freq))

    osb_fan2_tachi_value = get_reg_value(glu_reg_base_addr + REG_OSB_FAN2_TACHI_VAL)
    osb_fan2_freq = float(osb_fan2_tachi_value)
    print("osb_fan2_tachi_value = 0x%x (%fHz)" % (osb_fan2_tachi_value, osb_fan2_freq))

    osb_pusb_value = get_reg_value(glu_reg_base_addr + REG_OSB_PUSHB_VAL)
    print("osb_pusb_value = 0x%x" % osb_pusb_value)

    psync_700K_value = get_reg_value(glu_reg_base_addr + REG_SYS_PSYNC_700K_MEAS)
    psync_700K_freq = float(psync_700K_value)
    print("psync_700K_value = 0x%x (freq = %fHz)" % (psync_700K_value, psync_700K_freq))

    module_fan_rdback_value = get_reg_value(glu_reg_base_addr + REG_MOD_FAN_RDBCK)
    print("module_fan_rdback_value = 0x%x" % module_fan_rdback_value)

    module_presence_rdback_value = get_reg_value(glu_reg_base_addr + REG_MOD_PRESENCE_RDBCK)
    print("module_presence_readback_value = 0x%x" % module_presence_rdback_value)

    reset_ctrl_value = get_reg_value(glu_reg_base_addr + REG_PERIPH_RST_CTRL)
    print("reset_ctrl_value = 0x%x" % reset_ctrl_value)

    return None
#
#*****************************************
@DIAG("OSB : FPGA BDT registers check")
def t_osb_bdt_reg_check(cmd):
#*****************************************
#
# REG_BDT_CTRL(1) = fifo_reset
# REG_BDT_CTRL(0) = OSAnotOTDR
#
# REG_BDT_SEQ_MISC(2) = RESET_PLL
#
    print()
    bdt_reg_base_addr = get_pci_bdt_base_addr()

    #print("\nbdt_reg_base_addr = 0x%x" % bdt_reg_base_addr)

    pci_bdt_slv0 = get_reg_value(bdt_reg_base_addr + REG_BDT_IP_VERSION)
    print("PCI_BDT IP version reg. readback (@ addr = 0x%x) = 0x%x " %(bdt_reg_base_addr + REG_BDT_IP_VERSION, pci_bdt_slv0))

    pci_bdt_slv1 = get_reg_value(bdt_reg_base_addr + REG_BDT_CTRL)
    print("PCI_BDT BDT_CTRL reg. readback (@ addr = 0x%x) = 0x%x " %(bdt_reg_base_addr + REG_BDT_CTRL, pci_bdt_slv1))

    data_wr = 0xa5a55a5a
    print("\nPCI_BDT BDT_CTRL reg. write value = 0x%x (@ addr = 0x%x)" %(data_wr, bdt_reg_base_addr + REG_BDT_CTRL))
    reg_write(bdt_reg_base_addr + REG_BDT_CTRL, data_wr)

    pci_bdt_slv1 = get_reg_value(bdt_reg_base_addr + REG_BDT_CTRL)
    print("PCI_BDT BDT_CTRL reg. readback (@ addr = 0x%x) = 0x%x" %(bdt_reg_base_addr + REG_BDT_CTRL, pci_bdt_slv1))

    print("\n*****************************")
    print("sequencer_core registers test")
    print("*****************************\n")

    pci_bdt_seq_core_ver = get_reg_value(bdt_reg_base_addr + REG_BDT_SEQ_VERSION)
    print("PCI_BDT SEQ_CORE IP version readback (@ addr = 0x%x) = 0x%x " %(bdt_reg_base_addr + REG_BDT_SEQ_VERSION, pci_bdt_seq_core_ver))

    data_wr = 0x73738282
    print("\nPCI_BDT SEQ_CORE slv1 write value = 0x%x (@ addr = 0x%x)" %(data_wr, bdt_reg_base_addr + REG_BDT_SEQ_SLV1))
    reg_write(bdt_reg_base_addr + REG_BDT_SEQ_SLV1, data_wr)

    pci_bdt_seq_core_slv1 = get_reg_value(bdt_reg_base_addr + REG_BDT_SEQ_SLV1)
    print("PCI_BDT SEQ_CORE slv1 readback = 0x%x (@ addr = 0x%x)" %(pci_bdt_seq_core_slv1, bdt_reg_base_addr + REG_BDT_SEQ_SLV1))

    # SEQ_MISC reg.

    pci_bdt_seq_core_misc = get_reg_value(bdt_reg_base_addr + REG_BDT_SEQ_MISC)
    print("\nPCI_BDT SEQ_CORE SEQ_MISC reg. readback before write = 0x%x" % pci_bdt_seq_core_misc)

    data_wr = 0xffffffff
    print("\nPCI_BDT SEQ_CORE SEQ_MISC write value = 0x%x" % data_wr)
    reg_write(bdt_reg_base_addr + REG_BDT_SEQ_MISC, data_wr)

    pci_bdt_seq_core_misc = get_reg_value(bdt_reg_base_addr + REG_BDT_SEQ_MISC)
    print("PCI_BDT SEQ_CORE SEQ_MISC readback after write = 0x%x" % pci_bdt_seq_core_misc)
    #
    # to verify misc(2) settings :
    # misc(2) = 0 => SLV30_reg = 0xffff0000
    # misc(2) = 1 => SLV30_reg = 0xffff1111
    #
    data_wr = 0x0
    print("\nPCI_BDT SEQ_CORE SEQ_MISC reset (SEQ_MISC(2) = RESET_PLL = 0) : write value = 0x%x" % data_wr)
    reg_write(bdt_reg_base_addr + REG_BDT_SEQ_MISC, data_wr)

    pci_bdt_seq_core_misc = get_reg_value(bdt_reg_base_addr + REG_BDT_SEQ_MISC)
    print("PCI_BDT SEQ_CORE SEQ_MISC readback : 0x%x" % pci_bdt_seq_core_misc)

    data_wr = 0x4
    print("\nSet PCI_BDT SEQ_CORE SEQ_MISC(2) = RESET_PLL = 1 : write value = 0x%x" % data_wr)
    reg_write(bdt_reg_base_addr + REG_BDT_SEQ_MISC, data_wr)

    pci_bdt_seq_core_misc = get_reg_value(bdt_reg_base_addr + REG_BDT_SEQ_MISC)
    print("PCI_BDT SEQ_CORE SEQ_MISC readback after write = 0x%x" % pci_bdt_seq_core_misc)

    return None
#
#===============================================================================
def osb_clock_freq_meas(clock_type, expected_value, verbose):
#===============================================================================
#
    if clock_type == "LVDS_CLK":
        REG_BDT_CLK_MEAS = REG_BDT_SEQ_LVDS_FREQ
        if expected_value == 0:
            exp_value_min = -1
            exp_value_max = 1000
        else:
            exp_value_min = expected_value - 2000000.0
            exp_value_max = expected_value + 2000000.0
    elif clock_type == "AXIS_CLK":
        REG_BDT_CLK_MEAS = REG_AXIS_CLK_FREQ_MEAS
        if expected_value == 0:
            exp_value_min = -1
            exp_value_max = 1000
        else:
            exp_value_min = expected_value - 2000000.0
            exp_value_max = expected_value + 2000000.0
    else:
        REG_BDT_CLK_MEAS = REG_BDT_SEQ_MMCM_CLK_IN_FREQ
        if expected_value == 0:
            exp_value_min = -1
            exp_value_max = 1000
        else:
            exp_value_min = expected_value - 2000000.0
            exp_value_max = expected_value + 2000000.0

    bdt_reg_base_addr = get_pci_bdt_base_addr()

    clk_reg_value = get_reg_value(bdt_reg_base_addr + REG_BDT_CLK_MEAS)

    if verbose:
        print("%s clk_reg_value = 0x%x = %d" %(clock_type, clk_reg_value, clk_reg_value))

    clk_val = float(clk_reg_value)
    clk_freq = clk_val * 1000

    if clk_freq > exp_value_min and clk_freq < exp_value_max:
        msg = "PASS"
    else:
        msg = "FAIL"

    if msg == "PASS":
        print_ok("OSB : %s_freq  : %5.3fHz  : %s" %(clock_type, clk_freq, msg))
    else:
        print_error("OSB : %s_freq  : %5.3fHz : expected_value = %5.3fHz : %s" %(clock_type, clk_freq, expected_value, msg))

    return None
#
#*************************************************
@DIAG("OSB : deserializer clocks freq measurement")
def t_osb_deserializer_check(cmd):
#*************************************************
#
    try:
        if ' ' not in cmd:
            pass
            verbose = False
        else:
            length = len(cmd.split(' '))
            if length > 2:
                print_info("\nError : This command accepts 1 (optional) parameter ONLY ")
                raise
            elif length == 2:
                (command, verbose_flag) = cmd.split(' ')
                if verbose_flag == "verbose":
                    verbose = True
                else:
                    print()
                    print_error("   Parameter error : 2nd arg must be : verbose")
                    return False
            else:
                verbose = False
                pass

    except:
        print()
        print_error("   Syntax error : Command must be : t_osb_deserializer_check <verbose_flag> ")
        print_error("                                                                            ")
        print_error("         <verbose_flag> is : MUST be verbose ONLY                           ")
        print_error("                             Note : <verbose_flag> parameter is optional    ")
        print()
        return False

    bdt_reg_base_addr = get_pci_bdt_base_addr()

    pci_bdt_seq_core_misc  = get_reg_value(bdt_reg_base_addr + REG_BDT_SEQ_MISC)                     
    clk_25M_locked = (pci_bdt_seq_core_misc & 0x40000) >> 18
    
    if clk_25M_locked:
        pass
    else:
        print()
        print_error ("Free running clk 25MHz not locked")

    print()
    clock_type = "LVDS_CLK"
    expected_value = 40000000
    osb_clock_freq_meas(clock_type, expected_value, verbose)
    
    show_bdt_ctrl_reg_contents()
    
    print()
    clock_type = "MMCM_CLK"
    expected_value = 40000000
    osb_clock_freq_meas(clock_type, expected_value, verbose)
    
    clock_type = "AXIS_CLK"
    expected_value = 40000000
    osb_clock_freq_meas(clock_type, expected_value, verbose)
    
    return None
#
#=============================================================================================
@DIAG("OSB : module board detection")
def t_osb_module_detect(cmd):
#=============================================================================================
#
# MUX_CTRL(0) = mux_sel = 0 : SWITCH selected
# MUX_CTRL(0) = mux_sel = 1 : DTSS selected
# MUX_CTRL(1) = mux_oen = 0
#
# REG_URJTAG_IO wr_value = tck_nb | tms_val | tms_msk | tdi_val | tdi_msk
#
    glu_reg_base_addr = get_glu_base_addr()
    print("* glu_reg_base_addr = 0x%x" %glu_reg_base_addr, "\n")

    # Verify REG_MUX_CTRL reg. correctly set :

    rd_value = get_reg_value(glu_reg_base_addr + REG_MUX_CTRL)
    mux_sel = rd_value & 0x1
    mux_oen  = (rd_value & 0x2) >> 1
    if mux_sel == 1:
        msg = "(DTSS)"
    else:
        msg = "(SWITCH)"

    print("REG_MUX_CTRL reg. rd_value = 0x%x => mux_sel = %d %s ; mux_oen = %d\n" %(rd_value, mux_sel, msg, mux_oen))

    print("**************************************")
    if mux_oen == 1:
        print("** mux_oen = %d => no module detected **" %mux_oen)
    else:
        if mux_sel == 0:
            print("****** SWITCH module detected ********")
        else:
            print("****** DTSS module detected ********")
    print("**************************************\n")
        
    return None
#
#**********************************************************************************************
#************************ OSB fans functionalities ********************************************
#**********************************************************************************************
#
#=============================================================================================
@DIAG("OSB : Fan topology function")
def t_osb_fan_topology(cmd):
#=============================================================================================
#
    debug = True

    fan_topo_list = OSB_fan_topology()  # OSB_fan_topology fct : see fth_reg_def.py

    if debug:
        print ("\nfan_topo_list is ", fan_topo_list, " : length = ", len(fan_topo_list))
    else:
        print ("")

    fan_list = ["fan0", "fan1", "fan2", "fan3", "fan4"]
    fan_indice = []

    for elt in enumerate(fan_list):
        fan_name = elt[1]
        if debug:
            print("fan_name is", fan_name)
        for elt1 in enumerate(fan_topo_list):
            if elt1[1] == fan_name:
                fan_indice.append(elt1[0])
                if debug:
                    print("elt1 is", elt1, "fan_indice is ", fan_indice)

    if debug:
        print ("\nfan_indice is ", fan_indice, " : length = ", len(fan_indice))

    if len(fan_indice) == 0:
        print_error("Error : Fan topology CAN'T be extracted")
        return False
    else:
        i = 0
        for elt in enumerate(fan_list):
            fan_name = elt[1]
            hwmon_indice = fan_indice[i]
            hwmon = fan_topo_list[hwmon_indice-1]
            print("*", fan_name, " : hwmon is", hwmon)
            i += 1

    return None
#
#================================================================================
@DIAG("OSB periphal and front_panel fans PWM/TACHI check")
def t_osb_fans_check(cmd):
#================================================================================
#
    verbose = False
    debug   = False

    error_flag = False

    try:
        (command, consigne) = cmd.split()

        if len(consigne.split('-')) == 2:
            (fan_localisation, fct_type) = consigne.split('-')

            if fan_localisation == "LATERAL" or fan_localisation == "FRONT_PANEL" or fan_localisation == "ALL":
                print_info("fan_localisation is %s" %fan_localisation)
            else:
                print_error("fan_localisation : incorrect value : MUST be LATERAL or FRONT_PANEL or ALL")
                error_flag = True

            if fct_type == "PWM" or fct_type == "TACHI":
                print_info("function_type is %s" %fct_type)
            else:
                print_error("function_type : incorrect value : must be PWM or TACHI")
                error_flag = True

            if error_flag:
                return False

        if debug:
            print("   command = ", command, " ; consigne = ", consigne)
            print("   fan_localisation = %s ; function_type = %s" %(fan_localisation, fct_type))

    except:
        print_error("   Syntax error : Command must be : t_osb_fans_check <consigne>")
        print_error("                                                                    ")
        print_error("   where <consigne> is : <FAN_LOCALISATION>-<FUNCTION_TYPE>")
        print_error("   With                : <FAN_LOCALISATION> = LATERAL|FRONT_PANEL|ALL")
        print_error("                         <FUNCTION_TYPE> = PWM|TACHI")

        return False

    glu_reg_base_addr = get_glu_base_addr()

    fan_topo_list = OSB_fan_topology()

    if verbose:
        print ("\n  * fan_topo_list is ", fan_topo_list, "\n")

    if len(fan_topo_list) == 0:
        print_error("WARNING : Fan topology CAN'T be extracted")
        driver_state = "OFF"
        fan_topo_list =  ['hwmon_x', 'fan0', 'hwmon_y', 'fan1', 'hwmon_z', 'fan2', 'hwmon_f', 'fan3',  'hwmon_g', 'fan4']
#       return False
    else:
        driver_state = "ON"

    driver_list = []
    fan_list = []
    localisation_list = []
    position_list = []
    enable_list = []
    osb_fpga_reg_str_list = []
    osb_fpga_pwm_reg_list = []
    osb_fpga_tachi_reg_list = []

    i = 0
    for elt in enumerate(fan_topo_list):
        if debug:
            print("****** elt_%d = " %i, elt)
        if i == 0 or i%2 == 0:
            driver_list.append(elt[1])
        else:
            fan_list.append(elt[1])
            if "fan0" in elt[1]:
                localisation_list.append("LATERAL")
                position_list.append("REAR")
                enable_list.append("FAN_EN")
                osb_fpga_reg_str_list.append("REG_SYS_FAN1_CTRL")
                osb_fpga_pwm_reg_list.append(REG_SYS_FAN1_CTRL)
                osb_fpga_tachi_reg_list.append(REG_SYS_FAN1_TACHI_VAL)

            elif "fan1" in elt[1]:
                localisation_list.append("LATERAL")
                position_list.append("MIDDLE")
                enable_list.append("FAN_EN")
                osb_fpga_reg_str_list.append("REG_SYS_FAN2_CTRL")
                osb_fpga_pwm_reg_list.append(REG_SYS_FAN2_CTRL)
                osb_fpga_tachi_reg_list.append(REG_SYS_FAN2_TACHI_VAL)

            elif "fan2" in elt[1]:
                localisation_list.append("LATERAL")
                position_list.append("FRONT")
                enable_list.append("FAN_EN")
                osb_fpga_reg_str_list.append("REG_SYS_FAN3_CTRL")
                osb_fpga_pwm_reg_list.append(REG_SYS_FAN3_CTRL)
                osb_fpga_tachi_reg_list.append(REG_SYS_FAN3_TACHI_VAL)

            elif "fan4" in elt[1]:
                localisation_list.append("FRONT_PANEL")
                position_list.append("RIGHT")
                enable_list.append("FAN_DIS")
                osb_fpga_reg_str_list.append("REG_OSB_FAN2_CTRL")
                osb_fpga_pwm_reg_list.append(REG_OSB_FAN2_CTRL)
                osb_fpga_tachi_reg_list.append(REG_OSB_FAN2_TACHI_VAL)
            else:
                localisation_list.append("FRONT_PANEL")
                position_list.append("LEFT")
                enable_list.append("FAN_DIS")
                osb_fpga_reg_str_list.append("REG_OSB_FAN1_CTRL")
                osb_fpga_pwm_reg_list.append(REG_OSB_FAN1_CTRL)
                osb_fpga_tachi_reg_list.append(REG_OSB_FAN1_TACHI_VAL)

        if debug:
            print("\ndriver_list is", driver_list)
            print("fan_list is", fan_list)
            print("position_list is", position_list,"\n")
        i += 1

    if fct_type == "PWM":

        print("\nReadback of selected fans PWM value :\n")

        if driver_state == "ON":
            print("> using driver (hwmon) readback :")

            if fan_localisation == "LATERAL" or fan_localisation == "ALL":
                i = 0
                for elt in enumerate(fan_list):
                    if localisation_list[i] == "LATERAL":
                        hwmon_val = driver_list[i]
                        fan_pwm_cmde = "/sys/class/hwmon/"+hwmon_val+"/pwm1"
                        pwm_rdback = int(sysfs_read(fan_pwm_cmde))
                        speed_val = pwm_rdback & 0xff
                        speed_percent = int((speed_val * 100) / 255)
                        print("     *", localisation_list[i], fan_list[i], "(%s)" %position_list[i], hwmon_val,  "pwm_rdback is", pwm_rdback, "(speed = %d" %speed_percent, "%)" )
                    i += 1

            if fan_localisation == "FRONT_PANEL" or fan_localisation == "ALL":
                i = 0
                for elt in enumerate(fan_list):
                    if localisation_list[i] == "FRONT_PANEL":
                        hwmon_val = driver_list[i]
                        fan_pwm_cmde = "/sys/class/hwmon/"+hwmon_val+"/pwm1"
                        pwm_rdback = int(sysfs_read_string(fan_pwm_cmde))
                        speed_val = pwm_rdback & 0xff
                        speed_percent = int((speed_val * 100) / 255)
                        print("     *", localisation_list[i], fan_list[i], "(%s)" %position_list[i], hwmon_val,  "pwm_rdback is", pwm_rdback, "(speed = %d" %speed_percent, "%)")
                    i += 1

        print("\n> using OSB_FPGA fans PWM_reg. readback :")

        if fan_localisation == "LATERAL" or fan_localisation == "ALL":
            i = 0
            for elt in enumerate(fan_list):
                if localisation_list[i] == "LATERAL":
                    osb_fpga_reg = osb_fpga_pwm_reg_list[i]
                    sys_fan_value = get_reg_value(glu_reg_base_addr + osb_fpga_reg)
                    speed_val = sys_fan_value & 0xff
                    print("     * LATERAL", fan_list[i], "(%s)" %position_list[i], "PWM value = 0x%x (speed = %d" %(sys_fan_value, speed_val), "%)")
                i += 1

        if fan_localisation == "FRONT_PANEL" or fan_localisation == "ALL":
            i = 0
            for elt in enumerate(fan_list):
                if localisation_list[i] == "FRONT_PANEL":
                    osb_fpga_reg = osb_fpga_pwm_reg_list[i]
                    osb_fan_value = get_reg_value(glu_reg_base_addr + osb_fpga_reg)
                    speed_val = osb_fan_value & 0xff
                    print("     * FRONT_PANEL", fan_list[i], "(%s)" %position_list[i], "PWM value = 0x%x (speed = %d" %(osb_fan_value, speed_val), "%)")
                i += 1

    else:

        print("\nReadback of selected fans TACHI value :\n")

        if driver_state == "ON":
            print("> using driver (/sys/platform) readback :")

            if fan_localisation == "LATERAL" or fan_localisation == "ALL":

                i = 0
                for elt in enumerate(fan_list):
                    if localisation_list[i] == "LATERAL":
                        fan_num = fan_list[i]
                        fan_tachi_cmde = "/sys/platform/osb_tachi/"+fan_num
                        #print("    * sys_cmde is :", "cat "+fan_tachi_cmde)
                        tachi_value = sysfs_read(fan_tachi_cmde)
                        print("     *", localisation_list[i], fan_list[i], "(%s)" %position_list[i], "fan tachi_value is 0x%x" %tachi_value)
                    i += 1

            if fan_localisation == "FRONT_PANEL" or fan_localisation == "ALL":
                i = 0
                for elt in enumerate(fan_list):
                    if localisation_list[i] == "FRONT_PANEL":
                        fan_num = fan_list[i]
                        fan_tachi_cmde = "/sys/platform/osb_tachi/"+fan_num
                        #print("    * sys_cmde is :", "cat "+fan_tachi_cmde)
                        tachi_value = sysfs_read(fan_tachi_cmde)
                        print("     *", localisation_list[i], fan_list[i], "(%s)" %position_list[i], "fan tachi_value is 0x%x" %tachi_value)
                    i += 1

        print("\n> using OSB_FPGA fans TACHI_reg. readback :")

        if fan_localisation == "LATERAL" or fan_localisation == "ALL":

            i = 0
            for elt in enumerate(fan_list):
                if localisation_list[i] == "LATERAL":
                    fan_num = fan_list[i]
                    sys_fan_tachi_value = get_reg_value(glu_reg_base_addr + osb_fpga_tachi_reg_list[i])
                    print("     *", localisation_list[i], fan_list[i], "(%s)" %position_list[i], "tachi_value is 0x%x" %sys_fan_tachi_value)
                i += 1

        if fan_localisation == "FRONT_PANEL" or fan_localisation == "ALL":

            i = 0
            for elt in enumerate(fan_list):
                if localisation_list[i] == "FRONT_PANEL":
                    fan_num = fan_list[i]
                    osb_fan_tachi_value = get_reg_value(glu_reg_base_addr + osb_fpga_tachi_reg_list[i])
                    print("     *", localisation_list[i], fan_list[i], "(%s)" %position_list[i], "tachi_value is 0x%x" %osb_fan_tachi_value)
                i += 1

    return None
#
#=============================================================================================
@DIAG("OSB front_panel fans Set using OSB_FPGA registers")
def t_osb_fans_front_panel_reg_set(cmd):
#=============================================================================================
#
# PWM_value is the pourcentage (%) of the PWM speed : 100% means max speed
# ex : PWM_VALUE = 25 => 25% of max_speed
#
    debug = False

    try:
        (command, consigne) = cmd.split()

        if len(consigne.split('-')) == 2:
            consigne_lgth = 2
            (fan_position, access_type) = consigne.split('-')
        else:
            consigne_lgth = 3
            (fan_position, access_type, fan_pwm_value_str) = consigne.split('-')

        if debug:
            if len(consigne.split('-')) == 2:
                print("   command = ", command, " ; consigne = ", consigne)
                print("   fan_position = %s ; access_type = %s" %(fan_position, access_type))
            else:
                print("   command = ", command, " ; consigne = ", consigne)
                print("   fan_position = %s ; access_type = %s ; fan_pwm_value = %s" %(fan_position, access_type, fan_pwm_value_str))
    except:
        print_error("   Syntax error : Command must be : t_osb_fans_front_panel_reg_set <consigne>")
        print_error("                                                                            ")
        print_error("   where <consigne> is : <FAN_POSITION>-<ACCESS_TYPE>-<PWM_VALUE>")
        print_error("   with                : <FAN_POSITION> = RIGHT|LEFT|ALL")
        print_error("                         <ACCESS_TYPE>  = PWM|TACHI")
        print_error("                         <PWM_VALUE>    = {0 to 100}")
        return False

    error_flag = False

    position_list = ["RIGHT", "LEFT", "ALL"]
    access_list = ["PWM", "TACHI"]

    if fan_position not in position_list:
        print_error("   * Error : undefined FAN_POSITION : MUST be RIGHT or LEFT or ALL")
        error_flag = True
    else:
        print_info("   * fan_position is %s" %fan_position)

    if access_type not in access_list:
        print_error("   * Error : undefined ACCESS_TYPE : must be PWM or TACHI")
        error_flag = True
    else:
        print_info("   * access_type is %s" %access_type)

    if access_type == "PWM":
        if consigne_lgth == 2:
            print_error("   * Error : PWM_VALUE : unknown value : MUST be 0 or 0 < value < 101")
            error_flag = True
        else:
            fan_pwm_value = int(fan_pwm_value_str)
            if (fan_pwm_value == 0 or (fan_pwm_value > 0 and fan_pwm_value < 101)):
                print_info("   * fan_pwm_value is %d (0x%x)" %(fan_pwm_value, fan_pwm_value))
            else:
                print_error("   * Error : PWM_VALUE : incorrect value : MUST be 0 or 0 < value < 101")
                error_flag = True

    if error_flag:
        return False

    glu_reg_base_addr = get_glu_base_addr()
    if debug:
        print("glu_reg_base_addr = 0x%x" % glu_reg_base_addr)

    psu_ctrl_value = get_reg_value(glu_reg_base_addr + REG_PSU_CTRL)
    psu_mask_FAN_12V = 0x200

    if (psu_ctrl_value  & psu_mask_FAN_12V) == psu_mask_FAN_12V:
        psu_currently_en = 'Yes'
        print("FAN_12V is currently enable (psu_ctrl_value = 0x%x" %psu_ctrl_value+")")
    else:
        psu_currently_en = 'No'
        print("FAN_12V need to be enable (psu_ctrl_value = 0x%x" %psu_ctrl_value+")")
        data_val = psu_ctrl_value | psu_mask_FAN_12V
        reg_write(glu_reg_base_addr + REG_PSU_CTRL, data_val)
        time.sleep(0.5)

    if access_type == "PWM":

        print("")
        pwm_duty_value = 0x90000 + fan_pwm_value
        if debug:
            print("pwm_duty_value = 0x%x" % pwm_duty_value)

        if fan_position == "RIGHT" or fan_position == "ALL":
            reg_write(glu_reg_base_addr + REG_OSB_FAN2_CTRL, pwm_duty_value)
            osb_fan2_ctrl_value = get_reg_value(glu_reg_base_addr + REG_OSB_FAN2_CTRL)
            print("osb_fan2_ctrl_value value (RIGHT) = 0x%x" % osb_fan2_ctrl_value)

        if fan_position == "LEFT" or fan_position == "ALL":
            reg_write(glu_reg_base_addr + REG_OSB_FAN1_CTRL, pwm_duty_value)
            osb_fan1_ctrl_value = get_reg_value(glu_reg_base_addr + REG_OSB_FAN1_CTRL)
            print("osb_fan1_ctrl_value value (LEFT) = 0x%x" % osb_fan1_ctrl_value)

    else:
        print("")
        if fan_position == "RIGHT" or fan_position == "ALL":
            osb_fan2_tachi_value = get_reg_value(glu_reg_base_addr + REG_OSB_FAN2_TACHI_VAL)
            print("osb_fan2_tachi_reg value (RIGHT) = 0x%x" % osb_fan2_tachi_value)

        if fan_position == "LEFT" or fan_position == "ALL":
            osb_fan1_tachi_value = get_reg_value(glu_reg_base_addr + REG_OSB_FAN1_TACHI_VAL)
            print("osb_fan1_tachi_reg value (LEFT) = 0x%x" % osb_fan1_tachi_value)

    return None

#
#=============================================================================================
@DIAG("OSB : lateral fans Set using OSB_FPGA registers")
def t_osb_periph_fans_reg_set(cmd):
#=============================================================================================
#
# PWM_value is the pourcentage (%) of the PWM speed : 100% means max speed
# ex : PWM_VALUE = 25 => 25% of max_speed
#
    debug = False

    try:
        (command, consigne) = cmd.split()

        if len(consigne.split('-')) == 2:
            consigne_lgth = 2
            (fan_position, access_type) = consigne.split('-')
        else:
            consigne_lgth = 3
            (fan_position, access_type, fan_pwm_value_str) = consigne.split('-')

        if debug:
            if len(consigne.split('-')) == 2:
                print("   command = ", command, " ; consigne = ", consigne)
                print("   fan_position = %s ; access_type = %s" %(fan_position, access_type))
            else:
                print("   command = ", command, " ; consigne = ", consigne)
                print("   fan_position = %s ; access_type = %s ; fan_pwm_value = %s" %(fan_position, access_type, fan_pwm_value_str))

    except:
        print_error("   Syntax error : Command must be : t_osb_periph_fans_reg_set <consigne>")
        print_error("                                                                            ")
        print_error("   where <consigne> is : <FAN_POSITION>-<ACCESS_TYPE>-<PWM_VALUE>")
        print_error("   with                : <FAN_POSITION> = FRONT|MIDDLE|REAR|ALL")
        print_error("                         <ACCESS_TYPE>  = PWM|TACHI")
        print_error("                         <PWM_VALUE>    = {0 to 100}")
        return False

    error_flag = False

    position_list = ["FRONT", "MIDDLE", "REAR", "ALL"]
    access_list = ["PWM", "TACHI"]

    if fan_position not in position_list:
        print_error("   * Error : undefined FAN_POSITION : MUST be FRONT or MIDDLE or REAR or ALL")
        error_flag = True
    else:
        print_info("   * fan_position is %s" %fan_position)

    if access_type not in access_list:
        print_error("   * Error : undefined ACCESS_TYPE : must be PWM or TACHI")
        error_flag = True
    else:
        print_info("   * access_type is %s" %access_type)

    if access_type == "PWM":
        if consigne_lgth == 2:
            print_error("   * Error : PWM_VALUE : unknown value : MUST be 0 or 0 < value < 101")
            error_flag = True
        else:
            fan_pwm_value = int(fan_pwm_value_str)
            if (fan_pwm_value == 0 or (fan_pwm_value > 0 and fan_pwm_value < 101)):
                print_info("   * fan_pwm_value is %d (0x%x)" %(fan_pwm_value, fan_pwm_value))
            else:
                print_error("   * Error : PWM_VALUE : incorrect value : MUST be 0 or 0 < value < 101")
                error_flag = True

    if error_flag:
        return False

    glu_reg_base_addr = get_glu_base_addr()
    if debug:
        print("glu_reg_base_addr = 0x%x" % glu_reg_base_addr)

    if access_type == "PWM":

        print("")
        pwm_duty_value = 0x90000 + fan_pwm_value
        if debug:
            print("pwm_duty_value = 0x%x" % pwm_duty_value)

        if fan_position == "REAR" or fan_position == "ALL":
            reg_write(glu_reg_base_addr + REG_SYS_FAN1_CTRL, pwm_duty_value)
            sys_fan1_ctrl_value = get_reg_value(glu_reg_base_addr + REG_SYS_FAN1_CTRL)
            print("sys_fan1_ctrl_reg value (REAR) = 0x%x" % sys_fan1_ctrl_value)

        if fan_position == "MIDDLE" or fan_position == "ALL":
            reg_write(glu_reg_base_addr + REG_SYS_FAN2_CTRL, pwm_duty_value)
            sys_fan2_ctrl_value = get_reg_value(glu_reg_base_addr + REG_SYS_FAN2_CTRL)
            print("sys_fan2_ctrl_reg value (MIDDLE) = 0x%x" % sys_fan2_ctrl_value)

        if fan_position == "FRONT" or fan_position == "ALL":
            reg_write(glu_reg_base_addr + REG_SYS_FAN3_CTRL, pwm_duty_value)
            sys_fan3_ctrl_value = get_reg_value(glu_reg_base_addr + REG_SYS_FAN3_CTRL)
            print("sys_fan3_ctrl_reg value (FRONT) = 0x%x" % sys_fan3_ctrl_value)

    else:
        print("")
        if fan_position == "REAR" or fan_position == "ALL":
            sys_fan1_tachi_value = get_reg_value(glu_reg_base_addr + REG_SYS_FAN1_TACHI_VAL)
            print("sys_fan1_tachi_reg value (REAR) = 0x%x" % sys_fan1_tachi_value)

        if fan_position == "MIDDLE" or fan_position == "ALL":
            sys_fan2_tachi_value = get_reg_value(glu_reg_base_addr + REG_SYS_FAN2_TACHI_VAL)
            print("sys_fan2_tachi_reg value (MIDDLE) = 0x%x" % sys_fan2_tachi_value)

        if fan_position == "FRONT" or fan_position == "ALL":
            sys_fan3_tachi_value = get_reg_value(glu_reg_base_addr + REG_SYS_FAN3_TACHI_VAL)
            print("sys_fan3_tachi_reg value (FRONT) = 0x%x" % sys_fan3_tachi_value)

    return None
#
#=============================================================================================
@DIAG("OSB : lateral fans set using hwmon drivers")
def t_osb_periph_fans_set(cmd):
#=============================================================================================
#
# peripheral (Latteral) SYS fans :
#
# t_osb_peripheral_fans REAR-PWM-255    SYS_FAN1_CTRL : MSR=$(( 0x$BAR_1 + 0x01418 )) ; mem $MSR w  => @reset 0x0009003A
# t_osb_peripheral_fans MIDDLE-PWM-255  SYS_FAN2_CTRL : MSR=$(( 0x$BAR_1 + 0x0141C )) ; mem $MSR w  => @reset 0x0009003A
# t_osb_peripheral_fans FRONT-PWM-255   SYS_FAN3_CTRL : MSR=$(( 0x$BAR_1 + 0x01420 )) ; mem $MSR w  => @reset 0x0009003A
#
# t_osb_peripheral_fans REAR-TACHI-0    SYS_FAN1_TACHI_VAL : MSR=$(( 0x$BAR_1 + 0x01440 )) ; mem $MSR w
# t_osb_peripheral_fans MIDDLE-TACHI-0  SYS_FAN2_TACHI_VAL : MSR=$(( 0x$BAR_1 + 0x01444 )) ; mem $MSR w
# t_osb_peripheral_fans FRONT-TACHI-0   SYS_FAN3_TACHI_VAL : MSR=$(( 0x$BAR_1 + 0x01448 )) ; mem $MSR w
#
    debug = False

    try:
        (command,consigne) = cmd.split()

        if len(consigne.split('-')) == 2:
            consigne_lgth = 2
            (fan_position, access_type) = consigne.split('-')
        else:
            consigne_lgth = 3
            (fan_position, access_type, fan_pwm_value_str) = consigne.split('-')

        if debug == True:
            print("   command = ", command, " ; consigne = ", consigne)
            print("   fan_position = %s ; access_type = %s ; fan_pwm_value = %s" %(fan_position, access_type, fan_pwm_value_str))

    except:
        print_error("   Syntax error : Command must be : t_osb_periph_fans_set <consigne>")
        print_error("                                                                    ")
        print_error("   where <consigne> is : <FAN_POSITION>-<ACCESS_TYPE>-<PWM_VALUE>")
        print_error("   With                : <FAN_POSITION> = FRONT|MIDDLE|REAR|ALL")
        print_error("                         <ACCESS_TYPE>  = PWM|TACHI")
        print_error("                         <PWM_VALUE>    = {0 to 255}")
        return False

    error_flag = False

    if fan_position == "FRONT" or fan_position == "MIDDLE" or fan_position == "REAR" or fan_position == "ALL":
        print_info("fan_position is %s" %fan_position)
    else:
        print("fan_position : incorrect value : MUST be FRONT or MIDDLE or REAR or ALL")
        error_flag = True

    if access_type == "PWM" or access_type == "TACHI":
        print_info("access_type is %s" %access_type)
    else:
        print("fan access_type is undefined : must be PWM or TACHI")
        error_flag = True

    if access_type == "PWM":
        if consigne_lgth == 2:
            print_error("   * Error : PWM_VALUE : unknown value : MUST be 0 or 0 < value < 256")
            error_flag = True
        else:
            fan_pwm_value = int(fan_pwm_value_str)
            if fan_pwm_value == 0 or (fan_pwm_value > 0 and fan_pwm_value < 256):
                print_info("fan_pwm_value is %d" %fan_pwm_value)
            else:
                print("fan_pwm_value : incorrect value: MUST be 0 or 0 < value < 256")
                error_flag = True

    if error_flag:
        return False

    fan_topo_list = OSB_fan_topology()

    if len(fan_topo_list) == 0:
        print_error("Error : Fan topology CAN'T be extracted")
        return False

    if debug:
        print ("\nfan_topo_list is ", fan_topo_list)

    # enable_list : to validate this test for fan_0 (REAR) , fan_1 (MIDDLE), fan_2 (FRONT) ONLY :
    # enable_list = ["FAN_EN", "FAN_EN", "FAN_DIS","FAN_DIS","FAN_EN"]

    glu_reg_base_addr = get_glu_base_addr()

    driver_list = []
    fan_list = []
    position_list = []
    enable_list = []
    osb_fpga_reg_list = []
    osb_fpga_reg_str_list = []
    i = 0
    for elt in enumerate(fan_topo_list):
        if debug == True:
            print("elt_%d = " %i, elt)
        if i == 0 or i%2 == 0:
            driver_list.append(elt[1])
        else:
            fan_list.append(elt[1])
            if "fan0" in elt[1]:
                position_list.append("REAR")
                enable_list.append("FAN_EN")
                osb_fpga_reg_list.append(REG_SYS_FAN1_CTRL)
                osb_fpga_reg_str_list.append("REG_SYS_FAN1_CTRL")

            elif "fan1" in elt[1]:
                position_list.append("MIDDLE")
                enable_list.append("FAN_EN")
                osb_fpga_reg_list.append(REG_SYS_FAN2_CTRL)
                osb_fpga_reg_str_list.append("REG_SYS_FAN2_CTRL")

            elif "fan2" in elt[1]:
                position_list.append("FRONT")
                enable_list.append("FAN_EN")
                osb_fpga_reg_list.append(REG_SYS_FAN3_CTRL)
                osb_fpga_reg_str_list.append("REG_SYS_FAN3_CTRL")

            elif "fan4" in elt[1]:
                position_list.append("RIGHT")
                enable_list.append("FAN_DIS")
                osb_fpga_reg_list.append(REG_OSB_FAN1_CTRL)
                osb_fpga_reg_str_list.append("REG_OSB_FAN1_CTRL")
            else:
                position_list.append("LEFT")
                enable_list.append("FAN_DIS")
                osb_fpga_reg_list.append(REG_OSB_FAN1_CTRL)
                osb_fpga_reg_str_list.append("REG_OSB_FAN2_CTRL")

        if debug == True:
            print("driver_list is", driver_list)
            print("fan_list is", fan_list)
            print("position_list is", position_list)

        i += 1

    debug = False

    i = 0
    while i < 5:
        hwmon_val = driver_list[i]
        fan_num   = fan_list[i]
        position  = position_list[i]

        if debug:
            print("\nhwmon_val[%d] :" %i, hwmon_val)
            print("fan_num[%d] :" %i, fan_num)
            print("position[%d] :" %i, position)
            print("enable_list[%d] :" %i, enable_list[i])

        if enable_list[i] == 'FAN_EN' :

            if (position == fan_position or fan_position == 'ALL'):

                if access_type == "TACHI":
                    fan_tachi_cmde = "/sys/platform/osb_tachi/"+fan_num
                    if debug:
                        print("sys_cmde is :", "cat "+fan_tachi_cmde)

                    tachi_value = sysfs_read(fan_tachi_cmde)
                    print(" * ", fan_num, "fan tachi_value is 0x%x" %tachi_value)
                else:
                    fan_pwm_cmde = "/sys/class/hwmon/"+hwmon_val+"/pwm1"
                    print("     * sys_cmde is :", "echo "+fan_pwm_value_str+" > "+fan_pwm_cmde)
                    sysfs_write(fan_pwm_cmde, fan_pwm_value_str)
                    pwm_rdback = sysfs_read_string(fan_pwm_cmde)
                    pwm_value_reg = get_reg_value(glu_reg_base_addr + osb_fpga_reg_list[i])
                    print("         - %s readback value is" %hwmon_val, pwm_rdback)
                    print("         - %s (%s) pwm_value_reg value is 0x%x" %(fan_num, position, pwm_value_reg))
        i += 1

    return None
#
#==================================================================================================
@DIAG("OSB front panel fans set using hwmon drivers")
def t_osb_front_panel_fans_set(cmd):
#==================================================================================================
#
# OSB Fans at front panel :
#
# ENABLE_OSB_FAN_12V : PSU_CTRL(9) : MSR=$(( 0x$BAR_1 + 0x01408 )) ; mem $MSR w 0x2FF
#
# OSB_FAN1_CTRL : MSR=$(( 0x$BAR_1 + 0x01424 )) ; mem $MSR w  => @reset x0013001E <= Fan3 (LEFT)
# OSB_FAN2_CTRL : MSR=$(( 0x$BAR_1 + 0x01428 )) ; mem $MSR w  => @reset x00130028 <= Fan4 (RIGHT)
#
# OSB_FAN1_TACH : MSR=$(( 0x$BAR_1 + 0x0144C )) ; mem $MSR w
# OSB_FAN1_TACH : MSR=$(( 0x$BAR_1 + 0x01450 )) ; mem $MSR w
#
# root@afth-00005:# echo 255 > /sys/class/hwmon/hwmon9/pwm1
# root@afth-00005:# echo 255 > /sys/class/hwmon/hwmon10/pwm1*
#
# t_osb_fans LEFT-PWM-255
# t_osb_fans RIGHT-PWM-255
#
# t_osb_fans LEFT-TACHI
# t_osb_fans RIGHT-TACHI
#
    debug = False

    try:
        (command,consigne) = cmd.split()

        if len(consigne.split('-')) == 2:
            consigne_lgth = 2
            (fan_position, access_type) = consigne.split('-')
        else:
            consigne_lgth = 3
            (fan_position, access_type, fan_pwm_value_str) = consigne.split('-')

        if debug == True:
            print("   command = ", command, " ; consigne = ", consigne)
            print("   fan_position = %s ; access_type = %s ; fan_pwm_value = %s" %(fan_position, access_type, fan_pwm_value_str))

    except:
        print_error("   Syntax error : Command must be : t_osb_front_panel_fans_set <consigne>")
        print_error("                                                                     ")
        print_error("   where <consigne> is : <FAN_POSITION>-<ACCESS_TYPE>-<PWM_VALUE>")
        print_error("   With                : <FAN_POSITION> = RIGHT|LEFT|ALL")
        print_error("                         <ACCESS_TYPE>  = PWM|TACHI")
        print_error("                         <PWM_VALUE>    = {0 to 255}")
        return False

    time.sleep(0.6)

    error_flag = False

    if fan_position == "RIGHT" or fan_position == "LEFT" or fan_position == "ALL":
        print("   * fan_position is %s" %fan_position)
    else:
        print("   * Error : undefined fan_position : MUST be RIGHT or LEFT or ALL")
        error_flag = True

    if access_type == "PWM" or access_type == "TACHI":
        print("   * access_type is ", access_type)
    else:
        print("   * Error : undefined access_type : must be PWM or TACHI")
        error_flag = True

    if access_type == "PWM":
        if consigne_lgth == 2:
            print_error("   * Error : PWM_VALUE : unknown value : MUST be 0 or 0 < value < 256")
            error_flag = True
        else:
            fan_pwm_value = int(fan_pwm_value_str)
            if (fan_pwm_value == 0 or (fan_pwm_value > 0 and fan_pwm_value < 256)):
                print("   * fan_pwm_value is %d" %fan_pwm_value)
            else:
                print("   * Error : fan_pwm_value : incorrect value : MUST be 0 or 0 < value < 256")
                error_flag = True

    if error_flag:
        return False

    fan_topo_list = OSB_fan_topology()

    if len(fan_topo_list) == 0:
        print_error("Error : Fan topology CAN'T be extracted")
        return False

    if debug:
        print ("\nfan_topo_list is ", fan_topo_list, "\n")

    # enable_list : to validate this test for fan_3 (LEFT) , fan_4 (RIGHT) ONLY :
    enable_list = []
    driver_list = []
    fan_list = []
    position_list = []

    i = 0
    for elt in enumerate(fan_topo_list):
        if debug == True:
            print("elt_%d = " %i, elt)
        if i == 0 or i%2 == 0:
            driver_list.append(elt[1])
        else:
            fan_list.append(elt[1])
            if "fan0" in elt[1]:
                position_list.append("REAR")
                enable_list.append("FAN_DIS")
            elif "fan1" in elt[1]:
                position_list.append("MIDDLE")
                enable_list.append("FAN_DIS")
            elif "fan2" in elt[1]:
                position_list.append("FRONT")
                enable_list.append("FAN_DIS")
            elif "fan4" in elt[1]:
                position_list.append("RIGHT")
                enable_list.append("FAN_EN")
            else:
                position_list.append("LEFT")
                enable_list.append("FAN_EN")

        if debug:
            print("driver_list is", driver_list)
            print("fan_list is", fan_list)
            print("position_list is", position_list)

        i += 1

    debug = False

    i = 0
    while i < 5:
        hwmon_val = driver_list[i]
        fan_num   = fan_list[i]
        position  = position_list[i]

        if debug:
            print("\nhwmon_val[%d] :" %i, hwmon_val)
            print("fan_num[%d] :" %i, fan_num)
            print("position[%d] :" %i, position)
            print("enable_list[%d] :" %i, enable_list[i])

        if enable_list[i] == 'FAN_EN' and (position == fan_position or fan_position == 'ALL'):

            if access_type == "TACHI":
                if fan_num == 'fann':
                    fan_num = 'fan3'
                fan_tachi_cmde = "/sys/platform/osb_tachi/"+fan_num
                if debug:
                    print("sys_cmde is :", "cat "+fan_tachi_cmde)

                tachi_value = sysfs_read(fan_tachi_cmde)
                print(" * ", fan_num, "("+position+")", "tachi_value is 0x%x" %tachi_value)
            else:
                fan_pwm_cmde = "/sys/class/hwmon/"+hwmon_val+"/pwm1"
                print("* sys_cmde is :", "echo "+fan_pwm_value_str+" > "+fan_pwm_cmde, "("+fan_num+" : "+position+")")
                sysfs_write(fan_pwm_cmde, fan_pwm_value_str)
                pwm_rdback = sysfs_read_string(fan_pwm_cmde)
                print("* hwmon readback is ", pwm_rdback)
        i += 1

    return None
#
#=============================================================================================
@DIAG("OSB fans test using OSB_FPGA registers")
def t_osb_fans_test(cmd):
#=============================================================================================
#
# PWM_value is the pourcentage (%) of the PWM max speed : i.e 100% means max speed
#   ex : PWM_VALUE = 25 => 25% of max_speed
#
    debug = False
    error_nb = 0

    side_list     =["LATERAL", "FRONT_PANEL"]
    position_list = ["FRONT", "MIDDLE", "REAR", "RIGHT", "LEFT", "ALL"]

    try:
        error_flag = False

        if len(cmd.split()) == 2:
            (command, consigne) = cmd.split()
            verbose_str = "desactivated"
            verbose = False
        else:
            (command, consigne, verbose_info) = cmd.split()
            if verbose_info == "verbose":
                verbose_str = "activated"
                verbose = True
            else:
                verbose_str = "not recognized (Must be verbose)"
                verbose = False

        (fan_info, precision) = consigne.split(';')
        (fan_side, fan_pwm_value_str) = fan_info.split('-')
        (min_value_str, max_value_str) = precision.split('_')

        min_value = int(min_value_str)
        max_value = int(max_value_str)

        if debug:
            print("   command = ", command, " ; consigne = ", consigne)
            print("   fan_side = %s ; fan_pwm_value = %s" %(fan_side, fan_pwm_value_str))

        if fan_side not in side_list:
            print_error("   * Error : undefined FAN_SIDE : MUST be LATERAL or FRONT_PANEL")
            error_flag = True
        else:
            print_info("   * FAN_SIDE is %s" %fan_side)

        fan_pwm_value = int(fan_pwm_value_str)

        if (fan_pwm_value == 0 or (fan_pwm_value > 0 and fan_pwm_value < 101)):
            print_info("   * PWM value is %d" %fan_pwm_value+"%")
        else:
            print_error("   * Error : PWM_VALUE : incorrect value : MUST be 0 or 0 < value < 101")
            error_flag = True

        if min_value > max_value:
            print_error("   * Error : min_value > max_value")
            error_flag = True
        else:
            print_info("   * TACHI value : min_value : %d ; max_value = %d" %(min_value, max_value))

        print_info("# Note : verbose mode is %s\n" %verbose_str)

    except:
        print_error("   Syntax error : Command must be : t_osb_fans_test <consigne>")
        print_error("                                                                            ")
        print_error("   where <consigne> is : <FAN_SIDE>-<PWM_VALUE>;<Min_value>_<Max_value>")
        print_error("   with                : <FAN_SIDE>  = LATERAL|FRONT_PANEL")
        print_error("                         <PWM_VALUE> = {0 to 100}%")
        print_error("                         <Min_value>_<Max_value> = resp. min and max values of")
        print_error("                                                   expected TACHI return value")
        return False

    if error_flag:
        return False

    os_cmde = "modprobe -r pwm-fan"
    (os.system(os_cmde))

    glu_reg_base_addr = get_glu_base_addr()

    fan_pwm_val = int((fan_pwm_value * 255)/100)
    pwm_duty_value = 0x90000 + fan_pwm_val

    if debug:
        print("pwm_duty_value = 0x%x" % pwm_duty_value)

    if fan_side == "FRONT_PANEL":
        psu_ctrl_value = get_reg_value(glu_reg_base_addr + REG_PSU_CTRL)
        psu_mask_FAN_12V = 0x200

        if (psu_ctrl_value  & psu_mask_FAN_12V) == psu_mask_FAN_12V:
            if verbose:
                print("\n * Note : FRONT_PANEL fans test : ")
                print("            FAN_12V is currently enable (psu_ctrl_reg value = 0x%x)" %psu_ctrl_value)
        else:
            if verbose:
                print("\n * Note : FRONT_PANEL fans test : ")
                print("            FAN_12V need to be enable (psu_ctrl_reg value = 0x%x)" %psu_ctrl_value)
            data_val = psu_ctrl_value | psu_mask_FAN_12V
            reg_write(glu_reg_base_addr + REG_PSU_CTRL, data_val)
            time.sleep(0.5)

    if fan_pwm_value > 74:
        delay = 15
    elif fan_pwm_value > 49:
         delay = 10
    else:
        delay = 8

    if fan_side == "LATERAL":
        position_list = ["FRONT", "MIDDLE", "REAR"]
    else:
        position_list = ["RIGHT", "LEFT"]

    i = 0
    for elt in enumerate(position_list):

        if "RIGHT" in elt[1]:
            osb_fpga_pwm_reg = REG_OSB_FAN2_CTRL
            osb_fpga_tachi_reg = REG_OSB_FAN2_TACHI_VAL
            fan_ctrl_reg_str   = "osb_fan2_ctrl"
            fan_tachi_reg_str  = "osb_fan2_tachi"
        elif "LEFT" in elt[1]:
            osb_fpga_pwm_reg = REG_OSB_FAN1_CTRL
            osb_fpga_tachi_reg = REG_OSB_FAN1_TACHI_VAL
            fan_ctrl_reg_str   = "osb_fan1_ctrl"
            fan_tachi_reg_str  = "osb_fan1_tachi"
        elif "FRONT" in elt[1]:
            osb_fpga_pwm_reg = REG_SYS_FAN3_CTRL
            osb_fpga_tachi_reg = REG_SYS_FAN3_TACHI_VAL
            fan_ctrl_reg_str   = "sys_fan3_ctrl"
            fan_tachi_reg_str  = "sys_fan3_tachi"
        elif "MIDDLE" in elt[1]:
            osb_fpga_pwm_reg = REG_SYS_FAN2_CTRL
            osb_fpga_tachi_reg = REG_SYS_FAN2_TACHI_VAL
            fan_ctrl_reg_str   = "sys_fan2_ctrl"
            fan_tachi_reg_str  = "sys_fan2_tachi"
        else:
            osb_fpga_pwm_reg = REG_SYS_FAN1_CTRL
            osb_fpga_tachi_reg = REG_SYS_FAN1_TACHI_VAL
            fan_ctrl_reg_str   = "sys_fan1_ctrl"
            fan_tachi_reg_str  = "sys_fan1_tachi"

        # force PWM_value

        reg_write(glu_reg_base_addr + osb_fpga_pwm_reg, pwm_duty_value)
        fan_ctrl_value = get_reg_value(glu_reg_base_addr + osb_fpga_pwm_reg)
        if verbose:
            print("*** %s fan : " %elt[1])
            print("     * force PWM value = 0x%x into %s reg." %(fan_ctrl_value, fan_ctrl_reg_str))

        if verbose:
            print("     * Wait for %ds" %delay)
        time.sleep(delay)

        # Read TACHI value

        tachi_value = get_reg_value(glu_reg_base_addr + osb_fpga_tachi_reg)

        if verbose:
            print("     * %s fan : TACHI read value from %s reg. = 0x%x" %(elt[1], fan_tachi_reg_str, tachi_value))

        display_msg = "* "+ elt[1] + " fan : PWM value = " + str(fan_pwm_value) + "% : TACHI value = " + \
                      str(tachi_value) + " : "

        if (tachi_value >= min_value) and (tachi_value <= max_value):
            msg = "PASS"
            print_ok("%s %s" %(display_msg, msg))
        else:
            error_nb += 1
            msg = "FAIL"
            print_error("%s %s" %(display_msg, msg))

        # Reset PWM_value

        pwm_0_value = 0x90000 + 0x0

        reg_write(glu_reg_base_addr + osb_fpga_pwm_reg, pwm_0_value)
        fan_ctrl_value = get_reg_value(glu_reg_base_addr + osb_fpga_pwm_reg)
        if verbose:
            print("     * %s fan : reset PWM value = 0x%x into %s reg." %(elt[1], fan_ctrl_value, fan_ctrl_reg_str))
    i += 1

    if error_nb == 0:
        return True
    else:
        return False
#
#================================================================================
@DIAG("OSB periph and front fans debug")
def t_osb_fans_dbg(cmd):
#================================================================================
#
# lateral_fans are :
#
#   fan0 : lateral_fan0 (REAR)
#   fan1 : lateral_fan1 (MIDDLE)
#   fan2 : lateral_fan2 (FRONT)
#
# OSB_front_fans are :

#   fan3 : OSB_front_fan1 (RIGHT/LEFT)
#   fan4 : OSB_front_fan2 (RIGHT/LEFT)
#
# /sys/class/hwmon/hwmon<x>/pwm1 = 64  => osb_fan_value = 0x90019
# /sys/class/hwmon/hwmon<x>/pwm1 = 128 => osb_fan_value = 0x90032
# /sys/class/hwmon/hwmon<x>/pwm1 = 255 => osb_fan_value = 0x90063
#
#================================================================================
#
    verbose = True
    debug   = False

    glu_reg_base_addr = get_glu_base_addr()

    fan_topo_list = OSB_fan_topology()

    if verbose:
        print ("\nfan_topo_list is ", fan_topo_list, "\n")

    driver_list = []
    fan_list = []
    position_list = []
    enable_list = []
    osb_fpga_reg_str_list = []
    osb_fpga_reg_list = []

    i = 0
    for elt in enumerate(fan_topo_list):
        if debug:
            print("****** elt_%d = " %i, elt)
        if i == 0 or i%2 == 0:
            driver_list.append(elt[1])
        else:
            fan_list.append(elt[1])
            if "fan0" in elt[1]:
                position_list.append("REAR")
                enable_list.append("FAN_EN")
                osb_fpga_reg_str_list.append("REG_SYS_FAN1_CTRL")
                osb_fpga_reg_list.append(REG_SYS_FAN1_CTRL)

            elif "fan1" in elt[1]:
                position_list.append("MIDDLE")
                enable_list.append("FAN_EN")
                osb_fpga_reg_str_list.append("REG_SYS_FAN2_CTRL")
                osb_fpga_reg_list.append(REG_SYS_FAN2_CTRL)

            elif "fan2" in elt[1]:
                position_list.append("FRONT")
                enable_list.append("FAN_EN")
                osb_fpga_reg_str_list.append("REG_SYS_FAN3_CTRL")
                osb_fpga_reg_list.append(REG_SYS_FAN3_CTRL)

            elif "fan4" in elt[1]:
                position_list.append("RIGHT")
                enable_list.append("FAN_DIS")
                osb_fpga_reg_str_list.append("REG_OSB_FAN1_CTRL")
                osb_fpga_reg_list.append(REG_OSB_FAN1_CTRL)
            else:
                position_list.append("LEFT")
                enable_list.append("FAN_DIS")
                osb_fpga_reg_str_list.append("REG_OSB_FAN2_CTRL")
                osb_fpga_reg_list.append(REG_OSB_FAN2_CTRL)

        if debug:
            print("\ndriver_list is", driver_list)
            print("fan_list is", fan_list)
            print("position_list is", position_list,"\n")
        i += 1

    i = 0
    fan_pwm_value_str = "0"

    print("* Reset all fans pwm value @ 0 :")

    for elt in enumerate(fan_list):
        hwmon_val = driver_list[i]
        fan_pwm_cmde = "/sys/class/hwmon/"+hwmon_val+"/pwm1"
        if verbose:
            print("     * sys_cmde is :", "echo "+fan_pwm_value_str+" > "+fan_pwm_cmde)
        sysfs_write(fan_pwm_cmde, fan_pwm_value_str)
        i += 1

    print("\n* hwmon readback all fans pwm value :")

    i = 0
    for elt in enumerate(fan_list):
        fan = fan_list[i]
        hwmon_val = driver_list[i]
        fan_pwm_cmde = "/sys/class/hwmon/"+hwmon_val+"/pwm1"
        pwm_rdback = sysfs_read_string(fan_pwm_cmde)
        if verbose:
            print("     *", fan, hwmon_val, "pwm_rdback is", pwm_rdback)
        i += 1

    print("\n* OSB FPGA reg. readback all fans pwm value :")
    sys_fan1_value = get_reg_value(glu_reg_base_addr + REG_SYS_FAN1_CTRL)
    print("     * sys_fan1_value = 0x%x" % sys_fan1_value)
    sys_fan2_value = get_reg_value(glu_reg_base_addr + REG_SYS_FAN2_CTRL)
    print("     * sys_fan2_value = 0x%x" % sys_fan2_value)
    sys_fan3_value = get_reg_value(glu_reg_base_addr + REG_SYS_FAN3_CTRL)
    print("     * sys_fan3_value = 0x%x\n" % sys_fan3_value)

    osb_fan1_value = get_reg_value(glu_reg_base_addr + REG_OSB_FAN1_CTRL)
    print("     * osb_fan1_value = 0x%x" % osb_fan1_value)
    osb_fan2_value = get_reg_value(glu_reg_base_addr + REG_OSB_FAN2_CTRL)
    print("     * osb_fan2_value = 0x%x\n" % osb_fan2_value)

    i = 0
    for elt in enumerate(fan_list):
        if fan_list[i] == "fan0":
            fan = fan_list[i]
            hwmon_val = driver_list[i]
            osb_fpga_reg_str = osb_fpga_reg_str_list[i]
            osb_fpga_reg = osb_fpga_reg_list[i]
            position = position_list[i]
        i += 1

    if verbose:
        print("for %s (%s)" %(fan, position), ": hwmon_val =", hwmon_val)
        print("                    OSB FPGA reg. is %s @ 0x%x\n" %(osb_fpga_reg_str, osb_fpga_reg))
    fan_pwm_value_str = "0"

    fan_pwm_cmde = "/sys/class/hwmon/"+hwmon_val+"/pwm1"

    if verbose:
        print("sys_cmde is :", "echo "+fan_pwm_value_str+" > "+fan_pwm_cmde)

    sysfs_write(fan_pwm_cmde, fan_pwm_value_str)
    pwm_rdback = sysfs_read_string(fan_pwm_cmde)
    if verbose:
        print(hwmon_val,"pwm_rdback is", pwm_rdback)

    osb_fan_value = get_reg_value(glu_reg_base_addr + osb_fpga_reg)
    print("osb_fan_ctrl_reg = 0x%x\n" % osb_fan_value)

    fan_pwm_value_str = "1"

    if verbose:
        print("sys_cmde is :", "echo "+fan_pwm_value_str+" > "+fan_pwm_cmde)

    sysfs_write(fan_pwm_cmde, fan_pwm_value_str)
    pwm_rdback = sysfs_read_string(fan_pwm_cmde)
    if verbose:
        print(hwmon_val, "pwm_rdback is", pwm_rdback)

    osb_fan_value = get_reg_value(glu_reg_base_addr + osb_fpga_reg)
    print("osb_fan_ctrl_reg = 0x%x\n" % osb_fan_value)

    sys_fan1_value = get_reg_value(glu_reg_base_addr + REG_SYS_FAN1_CTRL)
    print("     * sys_fan1_value = 0x%x" % sys_fan1_value)
    sys_fan2_value = get_reg_value(glu_reg_base_addr + REG_SYS_FAN2_CTRL)
    print("     * sys_fan2_value = 0x%x" % sys_fan2_value)
    sys_fan3_value = get_reg_value(glu_reg_base_addr + REG_SYS_FAN3_CTRL)
    print("     * sys_fan3_value = 0x%x\n" % sys_fan3_value)

    osb_fan1_value = get_reg_value(glu_reg_base_addr + REG_OSB_FAN1_CTRL)
    print("     * osb_fan1_value = 0x%x" % osb_fan1_value)
    osb_fan2_value = get_reg_value(glu_reg_base_addr + REG_OSB_FAN2_CTRL)
    print("     * osb_fan2_value = 0x%x\n" % osb_fan2_value)

    fan_pwm_value_str = "64"

    if verbose:
        print("sys_cmde is :", "echo "+fan_pwm_value_str+" > "+fan_pwm_cmde)

    sysfs_write(fan_pwm_cmde, fan_pwm_value_str)

    pwm_rdback = sysfs_read_string(fan_pwm_cmde)
    if verbose:
        print(hwmon_val, "pwm_rdback is", pwm_rdback)

    osb_fan_value = get_reg_value(glu_reg_base_addr + osb_fpga_reg)
    print("osb_fan_ctrl_reg = 0x%x\n" % osb_fan_value)

    sys_fan1_value = get_reg_value(glu_reg_base_addr + REG_SYS_FAN1_CTRL)
    print("     * sys_fan1_value = 0x%x" % sys_fan1_value)
    sys_fan2_value = get_reg_value(glu_reg_base_addr + REG_SYS_FAN2_CTRL)
    print("     * sys_fan2_value = 0x%x" % sys_fan2_value)
    sys_fan3_value = get_reg_value(glu_reg_base_addr + REG_SYS_FAN3_CTRL)
    print("     * sys_fan3_value = 0x%x\n" % sys_fan3_value)

    osb_fan1_value = get_reg_value(glu_reg_base_addr + REG_OSB_FAN1_CTRL)
    print("     * osb_fan1_value = 0x%x" % osb_fan1_value)
    osb_fan2_value = get_reg_value(glu_reg_base_addr + REG_OSB_FAN2_CTRL)
    print("     * osb_fan2_value = 0x%x\n" % osb_fan2_value)

    fan_pwm_value_str = "128"

    if verbose:
        print("sys_cmde is :", "echo "+fan_pwm_value_str+" > "+fan_pwm_cmde)

    sysfs_write(fan_pwm_cmde, fan_pwm_value_str)
    pwm_rdback = sysfs_read_string(fan_pwm_cmde)
    if verbose:
        print(hwmon_val, "pwm_rdback is", pwm_rdback)

    osb_fan_value = get_reg_value(glu_reg_base_addr + osb_fpga_reg)
    print("osb_fan_ctrl_reg = 0x%x\n" % osb_fan_value)

    sys_fan1_value = get_reg_value(glu_reg_base_addr + REG_SYS_FAN1_CTRL)
    print("     * sys_fan1_value = 0x%x" % sys_fan1_value)
    sys_fan2_value = get_reg_value(glu_reg_base_addr + REG_SYS_FAN2_CTRL)
    print("     * sys_fan2_value = 0x%x" % sys_fan2_value)
    sys_fan3_value = get_reg_value(glu_reg_base_addr + REG_SYS_FAN3_CTRL)
    print("     * sys_fan3_value = 0x%x\n" % sys_fan3_value)

    osb_fan1_value = get_reg_value(glu_reg_base_addr + REG_OSB_FAN1_CTRL)
    print("     * osb_fan1_value = 0x%x" % osb_fan1_value)
    osb_fan2_value = get_reg_value(glu_reg_base_addr + REG_OSB_FAN2_CTRL)
    print("     * osb_fan2_value = 0x%x\n" % osb_fan2_value)

    fan_pwm_value_str = "255"

    if verbose:
        print("sys_cmde is :", "echo "+fan_pwm_value_str+" > "+fan_pwm_cmde)

    sysfs_write(fan_pwm_cmde, fan_pwm_value_str)
    pwm_rdback = sysfs_read_string(fan_pwm_cmde)
    if verbose:
        print(hwmon_val, "pwm_rdback is", pwm_rdback)

    osb_fan_value = get_reg_value(glu_reg_base_addr + osb_fpga_reg)
    print("osb_fan_ctrl_reg value = 0x%x\n" % osb_fan_value)

    sys_fan1_value = get_reg_value(glu_reg_base_addr + REG_SYS_FAN1_CTRL)
    print("     * sys_fan1_value = 0x%x" % sys_fan1_value)
    sys_fan2_value = get_reg_value(glu_reg_base_addr + REG_SYS_FAN2_CTRL)
    print("     * sys_fan2_value = 0x%x" % sys_fan2_value)
    sys_fan3_value = get_reg_value(glu_reg_base_addr + REG_SYS_FAN3_CTRL)
    print("     * sys_fan3_value = 0x%x\n" % sys_fan3_value)

    osb_fan1_value = get_reg_value(glu_reg_base_addr + REG_OSB_FAN1_CTRL)
    print("     * osb_fan1_value = 0x%x" % osb_fan1_value)
    osb_fan2_value = get_reg_value(glu_reg_base_addr + REG_OSB_FAN2_CTRL)
    print("     * osb_fan2_value = 0x%x\n" % osb_fan2_value)

    print("\n******************************************************")
    print(" print now into register and read corresponding hwmon")
    print("******************************************************\n")

    osb_fan_ctrl_value = 0x90025
    reg_write(glu_reg_base_addr + osb_fpga_reg, osb_fan_ctrl_value)

    if verbose:
        print("Write 0x%x at %s reg. FPGA_addr = 0x%x" %(osb_fan_ctrl_value, osb_fpga_reg_str, osb_fpga_reg))

    hwmon_pwm_rdback = sysfs_read_string(fan_pwm_cmde)
    if verbose:
        print("hwmon pwm_rdback is", hwmon_pwm_rdback, "\n")

    i = 0
    for elt in enumerate(fan_list):
        fan = fan_list[i]
        hwmon_val = driver_list[i]
        fan_pwm_cmde = "/sys/class/hwmon/"+hwmon_val+"/pwm1"
        pwm_rdback = sysfs_read_string(fan_pwm_cmde)
        if verbose:
            print(fan, hwmon_val, "pwm_rdback is", pwm_rdback)
        i += 1

    return None
#
#***********************
def OSB_fan_func():
#***********************
#
    debug = False

    # Test OSB_fan functionality
    #============================

    glu_reg_base_addr = get_glu_base_addr()
    #print("glu_reg_base_addr = 0x%x" % glu_reg_base_addr)

    psu_ctrl_value = get_reg_value(glu_reg_base_addr + REG_PSU_CTRL)

    if debug:
        print("psu_ctrl_value = 0x%x\n" % psu_ctrl_value)

    #var = psu_ctrl_value and 0x200
    #print("var = %x" %var)

    if psu_ctrl_value and 0x200 == 0x0200:
        print("\n1. OSB_FAN power supply DISABLE")
    else:
        print("\n1. OSB_FAN power supply ENABLE : DISABLE it")

        data_val = psu_ctrl_value and 0x1FF
        reg_write(glu_reg_base_addr + REG_PSU_CTRL, data_val)

        psu_ctrl_value = get_reg_value(glu_reg_base_addr + REG_PSU_CTRL)

        if debug == True:
            print("psu_ctrl_value = 0x%x" % psu_ctrl_value)

        time.sleep(3)   # wait for fan stabilization

    print(" * OSB fans tachi values @ STANDBY mode")

    osb_fan1_value1 = get_reg_value(glu_reg_base_addr + REG_OSB_FAN1_TACHI_VAL)
    print("     > osb_fan1_tachi_value = 0x%x" % osb_fan1_value1)

    osb_fan2_value1 = get_reg_value(glu_reg_base_addr + REG_OSB_FAN2_TACHI_VAL)
    print("     > osb_fan2_tachi_value = 0x%x\n" % osb_fan2_value1)

    print("2. Turn \"ON\" OSB_FAN power supply\n")

    psu_ctrl_value = get_reg_value(glu_reg_base_addr + REG_PSU_CTRL)

    if debug:
        print("psu_ctrl_value = 0x%x" % psu_ctrl_value)

    data_val = psu_ctrl_value | 0x200
    reg_write(glu_reg_base_addr + REG_PSU_CTRL, data_val)

    time.sleep(3)

    print("3. Turn \"OFF\" OSB_FAN power supply")

    psu_ctrl_value = get_reg_value(glu_reg_base_addr + REG_PSU_CTRL)
    data_val = psu_ctrl_value and 0x1ff
    reg_write(glu_reg_base_addr + REG_PSU_CTRL, data_val)

    print(" * OSB fans tachi values @ RUNNING mode")

    osb_fan1_value2 = get_reg_value(glu_reg_base_addr + REG_OSB_FAN1_TACHI_VAL)
    print("     > osb_fan1_tachi_value = 0x%x" % osb_fan1_value2)

    osb_fan2_value2 = get_reg_value(glu_reg_base_addr + REG_OSB_FAN2_TACHI_VAL)
    print("     > osb_fan2_tachi_value = 0x%x\n" % osb_fan2_value2)

    if osb_fan1_value1 == osb_fan1_value2:
        if osb_fan1_value2 == 0:
            print("OSB fan1 functionality : KO : fan absent")
        else:
            print("OSB fan1 functionality : KO")
    else:
        print("OSB fan1 functionality : OK")

    if osb_fan2_value1 == osb_fan2_value2:
        if osb_fan2_value2 == 0:
            print("OSB fan2 functionality : KO : fan absent")
        else:
            print("OSB fan2 functionality : KO")
    else:
        print("OSB fan2 functionality : OK")

    return None
#
#=============================================================================================
@DIAG("OSB Fan functionality test")
def t_osb_fan_func(cmd):
#=============================================================================================
#
    OSB_fan_func()

    return None
#
#=========================================================================================
#============== OSB with Z50 tooling cassette (Z112) functionalities =====================
#=========================================================================================
#
#===============================================
def z112_lvds_reg_verif(Access, Data):
#===============================================
#
    err_nb = 0

    # pwrside S3/S4
    side = 0
    slice = Z112_SLICE
    Utsspi = utsspi.SpiModule(side, slice, "/dev/uts_spi")

    WrdataL = Data & 0xff
    WrdataM = (Data & 0xff00) >> 8
    WrdataH = (Data & 0xff0000) >> 16

    exp_valueL = WrdataL
    exp_valueM = WrdataM
    exp_valueH = WrdataH & 0x1f

    if Access == "WO" or Access == "RW":
        Addr = SPI_ADDR_REGLVDS_7_0
        Utsspi.write_mod_register8(Addr, WrdataL)
        Addr = SPI_ADDR_REGLVDS_15_8
        Utsspi.write_mod_register8(Addr, WrdataM)
        Addr = SPI_ADDR_REGLVDS_20_16
        Utsspi.write_mod_register8(Addr, WrdataH)

    if Access == "RO" or Access == "RW":
        Addr = SPI_ADDR_REGLVDS_7_0
        reglvds_7_0_value = Utsspi.read_mod_register8(Addr)
        Addr = SPI_ADDR_REGLVDS_15_8
        reglvds_15_8_value = Utsspi.read_mod_register8(Addr)
        Addr = SPI_ADDR_REGLVDS_20_16
        reglvds_20_16_value = Utsspi.read_mod_register8(Addr)

        if reglvds_7_0_value == exp_valueL:
            msg = "PASS"
            if Access == "RO":
                print_ok("* SPI_ADDR_REGLVDS_7_0 reg. : rd_data = 0x%x (exp_data = 0x%x) : %s" %( \
                            reglvds_7_0_value, exp_valueL, msg))
            else:
                print_ok("* SPI_ADDR_REGLVDS_7_0 reg. : wr_data = 0x%x : rd_data = 0x%x (exp_data = 0x%x) : %s" %(\
                            WrdataL, reglvds_7_0_value, exp_valueL, msg))
        else:
            msg = "FAIL"
            if Access == "RO":
                print_error("* SPI_ADDR_REGLVDS_7_0 reg. : rd_data = 0x%x (exp_data = 0x%x) : %s" %( \
                         reglvds_7_0_value, exp_valueL, msg))
            else:
                print_error("* SPI_ADDR_REGLVDS_7_0 reg. : wr_data = 0x%x : rd_data = 0x%x (exp_data = 0x%x) : %s" %( \
                             WrdataL, reglvds_7_0_value, exp_valueL, msg))
            err_nb += 1

        if reglvds_15_8_value == exp_valueM:
            msg = "PASS"
            if Access == "RO":
                print_ok("* SPI_ADDR_REGLVDS_15_8 reg. : rd_data = 0x%x (exp_data = 0x%x) : %s" %(\
                            reglvds_15_8_value, exp_valueM, msg))
            else:
                print_ok("* SPI_ADDR_REGLVDS_15_8 reg. : wr_data = 0x%x : rd_data = 0x%x (exp_data = 0x%x) : %s" %(\
                            WrdataM, reglvds_15_8_value, exp_valueM, msg))
        else:
            msg = "FAIL"
            if Access == "RO":
                print_error("* SPI_ADDR_REGLVDS_15_8 reg. : rd_data = 0x%x (exp_data = 0x%x) : %s" %(\
                               reglvds_15_8_value, exp_valueM, msg))
            else:
                print_error("* SPI_ADDR_REGLVDS_15_8 reg. : wr_data = 0x%x : rd_data = 0x%x (exp_data = 0x%x) : %s" %(\
                               WrdataM, reglvds_15_8_value, exp_valueM, msg))
            err_nb += 1

        if reglvds_20_16_value == exp_valueH:
            msg = "PASS"
            if Access == "RO":
                print_ok("* SPI_ADDR_REGLVDS_20_16 reg. : rd_data = 0x%x (exp_data = 0x%x) : %s" %(\
                            reglvds_20_16_value, exp_valueH, msg))
            else:
                print_ok("* SPI_ADDR_REGLVDS_20_16 reg. : wr_data = 0x%x : rd_data = 0x%x (exp_data = 0x%x) : %s" %(\
                            WrdataH, reglvds_20_16_value, exp_valueH, msg))
        else:
            msg = "FAIL"
            if Access == "RO":
                print_error("* SPI_ADDR_REGLVDS_20_16 reg. : rd_data = 0x%x (exp_data = 0x%x) : %s" %(\
                             reglvds_20_16_value, exp_valueH, msg))
            else:
                print_error("* SPI_ADDR_REGLVDS_20_16 reg. : wr_data = 0x%x : rd_data = 0x%x (exp_data = 0x%x) : %s" %(\
                             WrdataH, reglvds_20_16_value, exp_valueH, msg))
            err_nb += 1

    return err_nb
#
#=============================================================================================
@DIAG("OSB Z112 cassette IRQs Test")
def t_osb_Z112_irq_test(cmd):
#
# Z112 board has 2 IRQn outputs : PWSID_S1_IRQn (J1_99) and PWSID_SX_IRQn (J1_20)
#
#=============================================================================================
#
    try:
        if ' ' not in cmd:
            debug = False
            verbose = False
            pass
        else:
            #lgth = len(cmd.split())
            #print("\n lgth = %d" %lgth)

            if len(cmd.split()) > 3:
                print_error("   Syntax error : too much arguments")
                raise 
            elif len(cmd.split()) == 3:
                (command, debug_flag, verbose_flag) = cmd.split(' ')
                print(" 2 args given : %s %s" %(debug_flag, verbose_flag))
                err_nb = 0
                if debug_flag == "debug":
                    debug = True
                else:
                    err_nb += 1
                    print_error("   Syntax error : 1st arg must be : debug  ")

                if verbose_flag == "verbose":
                    verbose = True
                else:
                    err_nb += 1
                    print_error("   Syntax error : 2nd arg must be : verbose")
                if err_nb != 0:
                    #print("err_nb = %d" %err_nb)
                    raise
            else:
                (command, arg_str) = cmd.split(' ')
                if arg_str == 'debug' or arg_str == 'verbose':
                    if arg_str == 'debug':
                        debug = True
                        verbose = False
                    else:
                        debug = False
                        verbose = True                        
                else:
                    print_error("  Syntax error : arg must be : debug or verbose")
                    raise
                pass

    except:
        print()
        print_error("   Syntax error : Command must be : t_osb_Z112_irq_test <consigne>       ")
        print_error("         where consigne = <debug> <verbose>                              ")
        print_error("                                                                         ")
        print_error("         <debug> parameter is optional                                   ")
        print_error("         <verbose> parameter is optional                                 ")
        return False

    if debug:
        print("\n * debug = %d" %debug)

    error_nb = 0
    
    z112_module = True

    if z112_module:
        module_str = "Z112"
        cpld_version_exp = 0x90
    else:
        module_str = "SWITCH"
        cpld_version_exp = 0x91

    glu_reg_base_addr = get_glu_base_addr()
    
    if verbose:
        mux_ctrl_value = get_reg_value(glu_reg_base_addr + REG_MUX_CTRL)
        mux_sel = mux_ctrl_value & 0x1
        mux_oen = (mux_ctrl_value & 0x2) >> 1
        
        print("\n* OSB mux_ctrl_value = 0x%x" % mux_ctrl_value)
        print("     - MUX_CTRL(0) = mux_sel = %d (0 : switch selected ; 1 : DTSS selected)" %mux_sel)
        print("     - MUX_CTRL(1) = mux_oen  = %d\n" %mux_oen)
        
        if mux_oen == 1:
            print("mux_oen = %d => no module detected" %mux_oen)
            return False
        else:
            print("************************************")
            if mux_sel == 0:
                print("****** SWITCH module detected ******")
            else:
                print("****** DTSS module detected ******")
            print("************************************\n")

        msel_value = get_reg_value(glu_reg_base_addr + REG_MSEL)
        print("msel register initial value = 0x%x\n" % msel_value)

        if 0 == 1:
            msel_reg_value = 0x81
            print("write msel value = 0x%x" % msel_reg_value)
            reg_write(glu_reg_base_addr + REG_MSEL, msel_reg_value)

            msel_reg_value = 0xA1
            print("write msel value = 0x%x" % msel_reg_value)
            reg_write(glu_reg_base_addr + REG_MSEL, msel_reg_value)
            
            msel_value = get_reg_value(glu_reg_base_addr + REG_MSEL)
            print("msel_value = 0x%x" % msel_value)
        
    if (os.path.exists("/dev/uts_spi")):
        side = 0
        slice = DTSS_SLICE
        Utsspi = utsspi.SpiModule(side, slice, "/dev/uts_spi")
    else:
        print("Utsspi driver (/dev/uts_spi) not found")
        return False

    cpld_version = Utsspi.read_mod_register8(Z112_SPI_XVERSION)

    if cpld_version == cpld_version_exp:
        print_ok("%s CPLD Version 0x%2x : PASS" %(module_str, cpld_version))
    else:
        print_error("%s CPLD version readback : 0x%x (expected = 0x%x)" %(module_str, cpld_version, cpld_version_exp))
        print_error("=> Error : %s board has not been detected!      " %module_str)
        return False

    if verbose:
        print("\n %s board : MISC_REG reg. initial values :" %module_str)
        show_z112_B200_misc_reg_contents()
        
        print("\n OSB board : IRQ REG_DBG_CTRL reg. initial values :")
        show_irq_dbg_ctrl_contents()

    if debug:
        input("\n* Press Enter to Initialize Z112 cAddress_Misc reg. value @ 0")
        print()
        
    # Devalidate IRQ generation
    #
    print("\n* %s : generate 'Z' on S1_IRQn CPLD pin by seting ADDR_MISC(3) = 0" %module_str)
    
    wr_data = 0x0
    Utsspi.write_mod_register8(SPI_ADDR_MISC, wr_data)
     
    if verbose:
        show_z112_B200_misc_reg_contents()
    
    dbg_reg_value = get_reg_value(glu_reg_base_addr + REG_DBG_CTRL)
    
    if verbose:
        show_irq_dbg_ctrl_contents()

    dbg_reg_value = get_reg_value(glu_reg_base_addr + REG_DBG_CTRL)
    osb_dtss_IRQ_bit29 = dbg_reg_value & 0x20000000 >> 29
    osb_switch_IRQ_bit30 = (dbg_reg_value & 0x40000000) >> 30
    
    if z112_module:
        IRQ_bit = osb_dtss_IRQ_bit29
        irq_exp_value = 0   # pullup inverted
    else:
        IRQ_bit = osb_switch_IRQ_bit30
        irq_exp_value = 1   # pullup

    if IRQ_bit == irq_exp_value:
        print_ok("IRQ generation disable : IRQ_bit = %d : PASS" %IRQ_bit)
    else:
        print_info("IRQ generation disable : IRQ_bit = %d : FAIL" %IRQ_bit)
        error_nb =+ 1
    
    # Validate IRQ generation
    # Generate Z112 MISC_REG nIRQ_Sn_en bit3 : nIRQ_Sn_en_bit3 = 1 => nIRQ_Sn CPLD output pin = 0
    
    if debug:
        input("\n* Press Enter to generate '0' on Z112 S1_IRQn CPLD pin")
        print()
    
    print("\n* %s : generate '0' on S1_IRQn CPLD pin by seting ADDR_MISC(3) = 1" %module_str)

    wr_data = 0x1 << 3
    Utsspi.write_mod_register8(SPI_ADDR_MISC, wr_data)

    if verbose:
        show_z112_B200_misc_reg_contents()
        show_irq_dbg_ctrl_contents()

    dbg_reg_value = get_reg_value(glu_reg_base_addr + REG_DBG_CTRL)
    osb_dtss_IRQ_bit29 = (dbg_reg_value & 0x20000000) >> 29
    osb_switch_IRQ_bit30 = (dbg_reg_value & 0x40000000) >> 30

    if z112_module:
        IRQ_bit = osb_dtss_IRQ_bit29
        irq_exp_value = 1 # IRQn input is inverted
    else:
        IRQ_bit = osb_switch_IRQ_bit30
        irq_exp_value = 0 # IRQn input is not inverted
        
    if IRQ_bit == irq_exp_value:
        print_ok("IRQ generation enable : IRQ_bit = %d : PASS" %IRQ_bit)
    else:
        print_info("IRQ generation enable : IRQ_bit = %d : FAIL" %IRQ_bit)
        error_nb =+ 1

    time.sleep (1)
    
    if debug:
        input("\n* Press Enter to generate 'Z' on Z112 S1_IRQn CPLD pin")
        print()
      
    if 0 == 1:
        print("\n* %s board : generate 'Z' on S1_IRQn CPLD pin by seting ADDR_MISC(3) = 0" %module_str)
        wr_data = 0x0
        Utsspi.write_mod_register8(SPI_ADDR_MISC, wr_data)
    else:
        print("\n* OSB  : generate a rst to reset the module")
        print("* %s : this generates 'Z' on S1_IRQn CPLD pin by seting ADDR_MISC(3) = 0" %module_str)
        periph_reset_gen("release", verbose)

    if verbose:
        show_z112_B200_misc_reg_contents()
        show_irq_dbg_ctrl_contents()

    dbg_reg_value = get_reg_value(glu_reg_base_addr + REG_DBG_CTRL)
    osb_dtss_IRQ_bit29 = (dbg_reg_value & 0x20000000) >> 29
    osb_switch_IRQ_bit30 = (dbg_reg_value & 0x40000000) >> 30

    if z112_module:
        IRQ_bit = osb_dtss_IRQ_bit29
        irq_exp_value = 0
    else:
        IRQ_bit = osb_switch_IRQ_bit30
        irq_exp_value = 1 # IRQn input is not inverted

    if IRQ_bit == irq_exp_value:
        print_ok("IRQ generation disable : IRQ_bit = %d : PASS" %IRQ_bit)
    else:
        print_info("IRQ generation disable : IRQ_bit = %d : FAIL" %IRQ_bit)
        error_nb =+ 1

    if error_nb > 0:
        return False
    else:
        return True
# 
#===============================================
@DIAG("OSB-Z112 : Z112 LVDS register test")
def t_osb_Z112_lvds_reg_test(cmd):
#===============================================
#
    err_nb = 0

    print()
    reg_data_value = 0x5a6b7e
    loc_err_nb = z112_lvds_reg_verif("RW", reg_data_value)

    err_nb += loc_err_nb

    if err_nb > 0:
        return False
    else:
        return True
#
#=============================================================================================
@DIAG("OSB : Test DTSS module connector using Z50 tooling cassette")
def t_osb_Z112_test(cmd):
#=============================================================================================
#
    try:
        (command, version) = cmd.split()
    except:
        print_error("# Command must be: t_osb_Z112_test version_nb(hex)")
        return False

    error_nb = 0

    print()
    verbose = True
    (dtss_fpga_rdy, dtss_presence, switch_presence) = module_presence_info(verbose)

    # Z112 on pwrside S3 position

    side = 0
    slice = Z112_SLICE
    Utsspi = utsspi.SpiModule(side, slice, "/dev/uts_spi")

    # Read VERSION reg at@0x00
    ver = Utsspi.read_mod_register8(Z112_SPI_XVERSION)

    if ver == int(version, 16):
        print_ok("Z112 CPLD Version 0x%2x : PASS" % ver)
    else:
        error_nb += 1
        print_error("Z112 : version readback : 0x%x (expected = 0x%x)" %(ver, int(version, 16)))

    # Z112 : REG LVDS registers

    print("Z112 : Check with pattern 0xAA55")
    data_wrL = 0x55
    Utsspi.write_mod_register8(Z112_ADDR_REGLVDS_7_0, data_wrL)
    data_wrL_rdbck =  Utsspi.read_mod_register8(Z112_ADDR_REGLVDS_7_0)

    if data_wrL_rdbck == data_wrL:
        print_ok("Z112 : reg. readback @ address 0x%x : 0x%x : PASS" %(Z112_ADDR_REGLVDS_7_0, data_wrL_rdbck))
    else:
        print_error("Z112 : reg. readback @ address 0x%x : 0x%x (expected = 0x%x) : FAIL" %(Z112_ADDR_REGLVDS_7_0, data_wrL_rdbck, data_wrL))
        error_nb += 1

    data_wrH = 0xaa
    Utsspi.write_mod_register8(Z112_ADDR_REGLVDS_15_8, data_wrH)
    data_wrH_rdbck =  Utsspi.read_mod_register8(Z112_ADDR_REGLVDS_15_8)

    if data_wrH_rdbck == data_wrH:
        print_ok("Z112 : reg. readback @ address 0x%x : 0x%x : PASS" %(Z112_ADDR_REGLVDS_15_8, data_wrH_rdbck))
    else:
        print_error("Z112 : reg. readback @ address 0x%x : 0x%x (expected = 0x%x): FAIL " %(Z112_ADDR_REGLVDS_15_8, data_wrH_rdbck, data_wrH))
        error_nb += 1

    if error_nb == 0:
        return True
    else:
        return False
#
#**********************************************************************************************
#*********************** OSB with B200 tool board functionalities *****************************
#**********************************************************************************************
#
#=============================================================================================
@DIAG("B200 : Reset CPLD")
def t_osb200_reset_gen(cmd):
#=============================================================================================
#
    verbose = True

    try:
        (command, release_flag) = cmd.split()
    except:
        print_error("# Command must be: t_osb200_reset_gen <release_flag>")
        print_error("   where            <release_flag> is : release or no_release")
        return False

    print(" release_flag is", release_flag)
    periph_reset_gen(release_flag, verbose)     # defined into fth_reg_def.py

    return None
#
#================================================================================
@DIAG("B200 : CPLD detection")
def t_osb200_cpld_detect(cmd):
#================================================================================
#
    osb200_cpld_detect()
    return None
#
#=============================================================================================
@DIAG("B200 : module type detect")
def t_osb200_module_type_detect(cmd):
#=============================================================================================
#
    try:
        if ' ' not in cmd:
            verbose = False
            pass
        else:
            (command,consigne) = cmd.split()
            if consigne == "verbose":
                verbose = True
            else:
                print("")
                print_error("*   Error : arg must be : verbose")
                print("")
                return False

    except:
        print_error("   Syntax error : Command must be : t_osb200_module_type_detect <consigne>")
        print("")
        return False

    print()
    
    glu_reg_base_addr = get_glu_base_addr()

    side = 0
    slice = B200_SLICE
    if (os.path.exists("/dev/uts_spi")):
        Utsspi = utsspi.SpiModule(side, slice, "/dev/uts_spi")
    else:
        print("Utsspi driver (/dev/uts_spi) not found")
        return False

    module_presence_rdback_value = get_reg_value(glu_reg_base_addr + REG_MOD_PRESENCE_RDBCK)

    switch_bit        = module_presence_rdback_value & 0x1
    dtss_bit          = (module_presence_rdback_value & 0x2)/2
    dtss_fpga_rdy_bit = (module_presence_rdback_value & 0x4)/4

    if verbose:
        print("* OSB module_presence_rdback register details :")
        print("     * module_presence_rdback_value read = 0x%x" % module_presence_rdback_value)
        print("         - module_presence_rdback(2) = DTSS_FPGA_RDY = %d ('0' = ABSENT ; '1' = present)" %dtss_fpga_rdy_bit)
        print("         - module_presence_rdback(1) = DTSS_PRES     = %d ('0' = ABSENT ; '1' = present)" %dtss_bit)
        print("         - module_presence_rdback(0) = SWITCH_PRES   = %d ('0' = ABSENT ; '1' = present)" %switch_bit, "\n")


    value = Utsspi.read_mod_register8(SPI_ADDR_BOARD_PRES)

    switch_pres_b_bit = value & 0x1
    dtss_pres_b_bit   = (value & 0x2)/2
    toggle_bit        = (value & 0x4)/4
    board_id          = (value & 0xc0)/64

    if verbose:
        print("* B200 CPLD module_presence_rdback register details :")
        print("     * module_presence_rdback read (@ addr 0x%1x) = 0x%x" %(SPI_ADDR_BOARD_PRES, value))
        print("         - BOARD_ID           = %d (2 = SWITCH ; 1 = DTSS)" %board_id)
        print("         - toggle_board_state = %d " %toggle_bit)
        print("         - DTSS_PRES_B        = %d ('0' = Selected ; '1' = DeSelected)" %dtss_pres_b_bit)
        print("         - SWITCH_PRES_B      = %d ('0' = Selected ; '1' = DeSelected)\n" %switch_pres_b_bit)

    if switch_bit == 1 and switch_pres_b_bit == 0:
        print ("Module SWITCH config. detected" )
    else:
        if dtss_bit == 1 and dtss_pres_b_bit == 0:
            print ("Module DTSS config. detected" )
        else:
            print ("Module config. NOT detected" )

    return None
#
#=============================================================================================
@DIAG("B200 : module set (SWITCH or DTSS)")
def t_osb200_module_type_set(cmd):
#=============================================================================================
#
    verbose = False

    try:
        (command, module_to_select) = cmd.split()
    except:
        print_error("# Command must be : t_osb200_module_type_set <module_to_select>")
        print_error("#            with : module_to_select = SWITCH or DTSS")
        return False

    print_info("  module_to_select = %s" %module_to_select)

    if module_to_select == "DTSS" or module_to_select == "SWITCH" or\
       module_to_select == "DTSS-VERBOSE" or module_to_select == "SWITCH-VERBOSE" :
        error_flag = False
        if module_to_select == "DTSS-VERBOSE" or module_to_select == "SWITCH-VERBOSE":
            verbose = True
    else:
        error_flag = True
        print_error("Error : module_to_select MUST be : DTSS or SWITCH")
        return False

    b200_module_type_set(module_to_select, verbose)
    
    return None
#
#===============================================================================================
@DIAG("B200 : Read registers (DTSS_spi side)")
def t_osb200_spi_reg_check(cmd):
#===============================================================================================
#
#constant cAddress_Version          : std_logic_vector(6 downto 0) := "0000000";--"0"   -- RO
#constant cAddress_RegLvds_7_0      : std_logic_vector(6 downto 0) := "0000001";--"1"   -- R/W
#constant cAddress_RegLvds_15_8     : std_logic_vector(6 downto 0) := "0000010";--"2"   -- R/W
#constant cAddress_RegLvds_20_16    : std_logic_vector(6 downto 0) := "0000011";--"3"   -- R/W
#constant cAddress_Misc             : std_logic_vector(6 downto 0) := "0000100";--"4"   -- R/W
#constant cAddress_SyncMeas1LSB     : std_logic_vector(6 downto 0) := "0000101";--"5"   -- RO
#constant cAddress_SyncMeas1MSB     : std_logic_vector(6 downto 0) := "0000110";--"6"   -- RO
#constant cAddress_SyncMeas2LSB     : std_logic_vector(6 downto 0) := "0000111";--"7"   -- RO
#constant cAddress_SyncMeas2MSB     : std_logic_vector(6 downto 0) := "0001000";--"8"   -- RO
#constant cAddress_SyncMeas3LSB     : std_logic_vector(6 downto 0) := "0001001";--"9"   -- RO
#constant cAddress_SyncMeas3MSB     : std_logic_vector(6 downto 0) := "0001010";--"A"   -- RO
#constant cAddress_SyncMeas4LSB     : std_logic_vector(6 downto 0) := "0001011";--"B"   -- RO
#constant cAddress_SyncMeas4MSB     : std_logic_vector(6 downto 0) := "0001100";--"C"   -- RO
#constant cAddress_BoardPresence    : std_logic_vector(6 downto 0) := "0001101";--"D"   -- RO
#

    side = 0
    slice = B200_SLICE
    if (os.path.exists("/dev/uts_spi")):
        Utsspi = utsspi.SpiModule(side, slice, "/dev/uts_spi")
    else:
        print("Utsspi driver (/dev/uts_spi) not found")
        return False

    # Read VERSION reg
    b200_cpld_version = Utsspi.read_mod_register8(SPI_ADDR_VERSION)
    print("B200 CPLD_VERSION readback value = 0x%2x" % b200_cpld_version)

    # SPI_ADDR_REGLVDS_7_0 access :

    value = Utsspi.read_mod_register8(SPI_ADDR_REGLVDS_7_0)
    print("B200 CPLD : cAddress_RegLvds_7_0 reg. (addr = 0x%1x) readback value : 0x%x" %(SPI_ADDR_REGLVDS_7_0, value))

    wr_data = 0x55
    print("B200 CPLD : write 0x%x into cAddress_RegLvds_7_0 reg.")
    Utsspi.write_mod_register8(SPI_ADDR_REGLVDS_7_0, wr_data)

    value = Utsspi.read_mod_register8(SPI_ADDR_REGLVDS_7_0)
    print("B200 CPLD : cAddress_RegLvds_7_0 reg. (addr = 0x%1x) readback value : 0x%x" %(SPI_ADDR_REGLVDS_7_0, value))

    # SPI_ADDR_REGLVDS_15_8 access :
    
    value = Utsspi.read_mod_register8(SPI_ADDR_REGLVDS_15_8)
    print("B200 CPLD : cAddress_RegLvds_15_8 reg. (addr = 0x%1x) readback value : 0x%x" %(SPI_ADDR_REGLVDS_15_8, value))

    wr_data = 0xaa
    Utsspi.write_mod_register8(SPI_ADDR_REGLVDS_15_8, wr_data)

    value = Utsspi.read_mod_register8(SPI_ADDR_REGLVDS_15_8)
    print("B200 CPLD : reg. value after write @ 0x%1x (cAddress_RegLvds_15_8) : 0x%x" %(SPI_ADDR_REGLVDS_15_8, value))

    # cAddress_RegLvds_20_16 access :

    value = Utsspi.read_mod_register8(SPI_ADDR_REGLVDS_20_16)
    print("B200 CPLD : reg. value @ 0x%1x (cAddress_RegLvds_20_16) : 0x%x" %(SPI_ADDR_REGLVDS_20_16, value))

    wr_data = 0x3f
    ver = Utsspi.write_mod_register8(SPI_ADDR_REGLVDS_20_16, wr_data)

    value = Utsspi.read_mod_register8(SPI_ADDR_REGLVDS_20_16)
    print("B200 CPLD : reg. value after write @ 0x%1x (cAddress_RegLvds_20_16) : 0x%x\n" %(SPI_ADDR_REGLVDS_20_16, value))

    # SPI_ADDR_MISC access

    value = Utsspi.read_mod_register8(SPI_ADDR_MISC)
    print("* B200 CPLD : SPI_ADDR_MISC reg. (addr = 0x%1x) readback value : 0x%x" %(SPI_ADDR_MISC, value))

    # following register are RO

    addr = 0x5
    value = Utsspi.read_mod_register8(addr)
    print("B200 CPLD : reg. value @ 0x%2x (cAddress_SyncMeas1LSB) : 0x%x" %(addr, value))

    addr = 0x6
    value = Utsspi.read_mod_register8(addr)
    print("B200 CPLD : reg. value @ 0x%2x (cAddress_SyncMeas1MSB) : 0x%x" %(addr, value))

    addr = 0x7
    value = Utsspi.read_mod_register8(addr)
    print("B200 CPLD : reg. value @ 0x%2x (cAddress_SyncMeas2LSB) : 0x%x" %(addr, value))

    addr = 0x8
    value = Utsspi.read_mod_register8(addr)
    print("B200 CPLD : reg. value @ 0x%2x (cAddress_SyncMeas2MSB) : 0x%x" %(addr, value))

    addr = 0x9
    value = Utsspi.read_mod_register8(addr)
    print("B200 CPLD : reg. value @ 0x%2x (cAddress_SyncMeas3LSB) : 0x%x" %(addr, value))

    addr = 0xa
    value = Utsspi.read_mod_register8(addr)
    print("B200 CPLD : reg. value @ 0x%2x (cAddress_SyncMeas3MSB) : 0x%x" %(addr, value))

    addr = 0xb
    value = Utsspi.read_mod_register8(addr)
    print("B200 CPLD : reg. value @ 0x%2x (cAddress_SyncMeas4LSB) : 0x%x" %(addr, value))

    addr = 0xc
    value = Utsspi.read_mod_register8(addr)
    print("B200 CPLD : reg. value @ 0x%2x (cAddress_SyncMeas4MSB) : 0x%x" %(addr, value))

    # cAddress_BoardPresence reg. : x"0" & "00" & DTSS_PRES_B & SWITCH_PRES_B

    addr = 0xd
    value = Utsspi.read_mod_register8(addr)
    switch_pres_b = value & 0x1
    dtss_pres_b   = (value & 0x2) >> 2

    if value == 0x2 :
        msg = "SWITCH module present"
    else:
        msg = "DTSS module present"

    print("B200 CPLD : reg. value @ 0x%1x (cAddress_BoardPresence) : 0x%x => %s" %(addr, value, msg))
    print("     * SWITCH_PRES_B = %d" %switch_pres_b)
    print("     * DTSS_PRES_B   = %d" %dtss_pres_b)

    return None
#
#================================================================================
@DIAG("B200 : DTSS_FAN_ON and DTSS_FPGA_READY_N test")
def t_osb200_dtss_fan_on_fpga_rdy_test(cmd):
#================================================================================
#
# To test DTSS_OSB_FAN_ON and DTSS_OSB_FPGA_READY_N bits coming from DTSS
# connector 
#
    try:
        if ' ' not in cmd:
            pass
            verbose = False
        else:
            length = len(cmd.split(' '))
            if length > 2:
                print_info("\nError : This command accepts 1 (optional) parameter ONLY ")
                raise
            elif length == 2:
                (command, verbose_flag) = cmd.split(' ')
                if verbose_flag == "verbose":
                    verbose = True
                else:
                    print()
                    print_error("   Parameter error : 2nd arg must be : verbose")
                    return False
            else:
                verbose = False
                pass

    except:
        print()
        print_error("   Syntax error : Command must be : t_osb200_dtss_test <verbose_flag>       ")
        print_error("                                                                            ")
        print_error("         <verbose_flag> is : MUST be verbose ONLY                           ")
        print_error("                             Note : <verbose_flag> parameter is optional    ")
        print()
        return False

    side = 0
    slice = B200_SLICE
    if (os.path.exists("/dev/uts_spi")):
        Utsspi = utsspi.SpiModule(side, slice, "/dev/uts_spi")
    else:
        print("Utsspi driver (/dev/uts_spi) not found")
        return False

    periph_reset_gen("release", verbose)    # defined into fth_reg_test.py

    (board_id, toggle_bit, dtss_pres_b_bit, switch_pres_b_bit) = B200_info(verbose) # defined into fth_reg_test.py
     
    if board_id == 2:
        if verbose:
            print (" Run b200_module_type_set(DTSS)")
        b200_module_type_set("DTSS", my_verbose)
    elif board_id == 3:
        print_info (" B200 : Error : No module (DTSS or SWITCH) detected")
        return False

    error_flag = 0

    wr_data = 0x0
    Utsspi.write_mod_register8(SPI_ADDR_DTSS_REG, wr_data)
    value = Utsspi.read_mod_register8(SPI_ADDR_DTSS_REG)

    if value == wr_data:
        pass
    else:
        error_flag += 1

    wr_data = 0x3
    Utsspi.write_mod_register8(SPI_ADDR_DTSS_REG, wr_data)
    value = Utsspi.read_mod_register8(SPI_ADDR_DTSS_REG)

    if value == wr_data:
        pass
    else:
        error_flag += 1

    if error_flag > 0:
        return False
    else:
        return True
#
#**********************************************************************************************
#************************ OSB fans functionalities ********************************************
#**********************************************************************************************
#
#************************************
def osbdtss_fpga_version(verbose):
#************************************
#
    if verbose == 0:
        print()
    (dtss_fpga_rdy, dtss_presence, switch_presence) = module_presence_info(verbose)

    if dtss_presence:
        if dtss_fpga_rdy:
            if (os.path.exists("/dev/uts_spi")):
                side = 0
                slice = DTSS_SLICE
                Utsspi = utsspi.SpiModule(side, slice, "/dev/uts_spi")
            else:
                print("Utsspi driver (/dev/uts_spi) not found")
                return False

            dtss_fpga_ver = Utsspi.read_mod_register8(DTSS_SPI_XVERSION)
            print("\n* dtss_fpga_ver (using Utsspi.read_mod_register8) = 0x%x" %dtss_fpga_ver)
            
            #dtss_fpga_ver32 = Utsspi.read_mod_register32(DTSS_SPI_XVERSION)
            #print("\n* dtss_fpga_ver (using Utsspi.read_mod_register32) = 0x%x" %dtss_fpga_ver32)
            
            value = spi_master_transfer(cRead, DTSS_SPI_XVERSION, 0)
            print("* dtss_fpga_ver (using spi_master_transfer proc.) = 0x%x" %(value))
        else:
            print("DTSS module present BUT DTSS module FPGA is not loaded")
    else:
        print("\nDTSS module is not present")

    return None
#
#*****************************************
@DIAG("OSB DTSS FPGA STATUS (Ready)")
def t_osbdtss_fpga_status(cmd):
#*****************************************
#
    try:
        if ' ' not in cmd:
            pass
            verbose = False
        else:
            length = len(cmd.split(' '))
            if length > 2:
                print_info("\nError : This command accepts 1 (optional) parameter ONLY ")
                raise
            elif length == 2:
                (command, verbose_flag) = cmd.split(' ')
                if verbose_flag == "verbose":
                    verbose = True
                else:
                    print()
                    print_error("   Parameter error : 2nd arg must be : verbose")
                    return False
            else:
                verbose = False
                pass

    except:
        print()
        print_error("   Syntax error : Command must be : t_osbdtss_fpga_status <verbose_flag> ")
        print_error("                                                                         ")
        print_error("         <verbose_flag> is : MUST be verbose ONLY                        ")
        print_error("                             Note : <verbose_flag> parameter is optional ")
        print()
        return False
    
    print()
    (dtss_fpga_rdy_bit, dtss_bit, switch_bit) = module_presence_info(verbose)
    
    if verbose == False:
        print("dtss_module_presence   = %d " %dtss_bit)
        print("switch_module_presence = %d " %switch_bit)
        print("dtss_fpga_rdy          = %d " %dtss_fpga_rdy_bit)
    
    return None
#
#**********************************
@DIAG("DTSS FPGA version")
def t_osbdtss_fpga_version(cmd):
#**********************************
#
    try:
        length = len(cmd.split(' '))
        if length > 2:
            print()
            print_info("Error : This command accepts 1 (optional) parameter ONLY ")
            raise
        elif length == 2:
            (command, verbose_flag) = cmd.split(' ')
            if verbose_flag == "verbose":
                verbose = True
            else:
                print()
                print_error("   Parameter error : 2nd arg must be : verbose")
                return False
        else:
            verbose = False
            pass

    except:
        print()
        print_error("   Syntax error : Command must be : t_osbdtss_fpga_version <verbose_flag> ")
        print_error("                                                                           ")
        print_error("         <verbose_flag> is : MUST be verbose ONLY                          ")
        print_error("                             Note : <verbose_flag> parameter is optional   ")
        return False

    osbdtss_fpga_version(verbose)

    return None
#
#===============================================================================
@DIAG("OSB-DTSS : Load DTSS FPGA")
def t_osbdtss_load_fpga(cmd):
# 
# Note : module_presence_info() defined into fth_reg_def.py
#===============================================================================
#
    verbose = False
    (dtss_fpga_rdy, dtss_presence, switch_presence) = module_presence_info(verbose)
    
    if dtss_presence:
        pass
    else:
        print("Error : DTSS board is not present")
        return False
    
    svf_file = "/acterna/storage/fpga/CobraV2.svf"
    
    if (os.path.exists(svf_file)):
        FileName = "/usr/share/pydiag/oth/dtss_fpga_load.txt"
        print()
    else:
        print("Error : %s not found" %svf_file)
        return False

    f = open(FileName, "w")
    f.write('cable osb\n')
    f.write('detect\n')
    f.close()

    cmde = "jtag "+FileName

    p = subprocess.Popen(cmde, shell=True, stdin=subprocess.PIPE, stdout=subprocess.PIPE,
                         stderr=subprocess.STDOUT, close_fds=True)
    p.wait()
    err = p.returncode
    lines = p.stdout.readlines()
    for l in lines:
        l = l.decode("utf-8").strip()
        if l:
            print_info("# %s" % (l))
            columns = [item.strip() for item in l.split(':')]
            # print_info("col %s" % columns[0])
            if ((columns[0] == "Part(0)") and (columns[1] == "xc7k160t (0x364C)")):
                res = 1

    if  res == 1:
        print("\n=> FPGA Detect : PASS\n")
    else:
        print("\n=> FPGA Detect : FAIL\n")
        print("\n   Error : FPGA CAN'T be programmed\n")
        return False

    f = open(FileName, "w")
    f.write('cable osb\n')
    f.write('detect\n')
    f.write('svf %s' %svf_file)
    f.close()

    cmde = "jtag "+FileName

    res = 0

    print("Please wait while FPGA is programming.....")

    p = subprocess.Popen(cmde, shell=True, stdin=subprocess.PIPE, stdout=subprocess.PIPE,
                         stderr=subprocess.STDOUT, close_fds=True)
    p.wait()
    err = p.returncode
    
    #print("\n*** err = %d\n" %err)
    
    lines = p.stdout.readlines()
    
    #print("\n lines are", lines, '\n')
    
    for l in lines:
        l = l.decode("utf-8").strip()
        if l:
            #print_info("# %s" % (l))
            columns = [item.strip() for item in l.split(':')]
            #print_info("col %s" % columns[0])
            if ((columns[0] == "detail") and (columns[1] == "Scanned device output matched expected TDO values.")):
                res += 1

    os_cmde = "rm -f "+FileName
    (os.system(os_cmde))

    time.sleep(1)

    side = 0
    slice = DTSS_SLICE
    if (os.path.exists("/dev/uts_spi")):
        Utsspi = utsspi.SpiModule(side, slice, "/dev/uts_spi")
        ver = Utsspi.read_mod_register8(DTSS_SPI_XVERSION)
    else:
        print("Utsspi driver (/dev/uts_spi) not found")
        return False

    if res == 0:
        print("\n=> FPGA programation completed (FPGA_version = 0x%2x)" % ver)
        verbose = False
        (dtss_fpga_rdy, dtss_presence, switch_presence) = module_presence_info(verbose)
        print("   dtss_fpga_rdy = %d\n" %dtss_fpga_rdy)
        return True
    else:
        print("\n=> FPGA programation : FAIL\n")
        return False
#
#**********************************
@DIAG("DTSS DMA mode check")
def t_osbdtss_i2c_detect(cmd):
#**********************************
#
    eeprom_i2c_addr_str = "0x52"
    
    ### Process pour slectionner le module Cobra depuis la carte solution
    
    if (os.path.exists("/sys/platform/msel_osb/register_msel")):
        sysfs_write("/sys/platform/msel_osb/register_msel", "0x00000081")
        sysfs_write("/sys/platform/msel_osb/register_msel", "0x000000A1")
        sysfs_write("/sys/platform/msel_osb/register_msel", "0x0")
    else:
        print("/sys/platform/msel_osb/register_msel not found")
        return False

    if (os.path.exists("/sys/platform/uts_scan/i2c_master_s4_pw")):
        eeprom_i2c_bus_nb_str = sysfs_read_string("/sys/platform/uts_scan/i2c_master_s4_pw")
    else:
        print("/sys/platform/uts_scan/i2c_master_s4_pw not found")
        return False

    i2c_cmde = "i2cdump -y -f "+eeprom_i2c_bus_nb_str+" "+eeprom_i2c_addr_str+" c"

    print("\n* i2c cmde is :", i2c_cmde,"\n")
    (os.system(i2c_cmde))

    ### Process pour d-slectionner le module Cobra depuis la carte solution
    
    if (os.path.exists("/sys/platform/msel_osb/register_msel")):
        sysfs_write("/sys/platform/msel_osb/register_msel", "0x00000080")
        sysfs_write("/sys/platform/msel_osb/register_msel", "0x000000A0")
        sysfs_write("/sys/platform/msel_osb/register_msel", "0x0")
    else:
        print("/sys/platform/uts_scan/i2c_master_s4_pw not found")
        return False

    return None
#***************************************************
def show_dtss_reg_contents(reg_name, reg_value):
#***************************************************

    print("\n* %s register read value = 0x%x" %(reg_name,reg_value))

    #---------------------------------
    # DTSS "TimeBase" (bdt) registers
    #---------------------------------
    
    if reg_name == 'DTSS_TNUMBER':
        reg_msg = "  read_data(31:0) = '0000000' & TEETH_NUMBER(24:0)"
        print(reg_msg)
        teeth_number_value = reg_value & 0x1ffffff
        print("     > %s(24:0) = 0x%x" %(reg_name, teeth_number_value))

    elif reg_name == 'DTSS_NDURATION':
        reg_msg = "  read_data(31:8) = x\"0\"' & 000' & NOISE_NUMBER(16:0)"
        print(reg_msg)
        noise_number = (reg_value >> 8) & 0x1ffff
        print("     > %s(16:0) = 0x%x" %(reg_name, noise_number))

    elif reg_name == "DTSS_ANUMBER":
        reg_msg = "  read_data(31:8) = '000000' & AVERAGE_NUMBER(17:0)"
        print(reg_msg)
        Anumber_value = (reg_value >> 8) & 0x3ffff
        print("     > %s(17:0) = 0x%x" %(reg_name, Anumber_value))

    elif reg_name == 'DTSS_ARMAX':
        reg_msg = "  read_data(31:24) = '000000' & RAMP_MAX(7:0)"
        print(reg_msg)
        ramp_max = (reg_value >> 24) & 0xff
        print("     > %s(7:0) = 0x%x" %(reg_name, ramp_max))

    elif reg_name == 'DTSS_ARINC':
        reg_msg = "  read_data(31:24) = x\"0\"' & RAMP_INC(3:0)"
        print(reg_msg)

    elif reg_name == 'DTSS_CNUMBER':
        reg_msg = "  read_data(31:24) = x\"0\"' & '0' & COMB_NUMBER(2:0)"
        print(reg_msg)
        ramp_inc = (reg_value >> 24) & 0x7
        print("     > %s(2:0) = 0x%x" %(reg_name, ramp_max))

    elif reg_name == 'DTSS_PULSE':
        reg_msg = "  read_data(31:0) = PULSES_VALUE(31:0)"
        print(reg_msg)
        print("     > %s(31:0) = 0x%x" %(reg_name, reg_value))

    elif reg_name == 'DTSS_CRNUMBER':
        reg_msg = "  read_data(31:24) = CRUNCH_NUMBER(7:0)"
        print(reg_msg)
        crunch_number = (reg_value >> 24) & 0xff
        print("     > %s(7:0) = 0x%x" %(reg_name, crunch_number))

    elif reg_name == 'DTSS_OFFSET_TM':
        reg_msg = "  read_data(31:16) = x\"0\"' & OFFSET_TM(11:0)"
        print(reg_msg)
        offset_tm = (reg_value >> 16) & 0xffff
        print("     > %s(11:0) = 0x%x" %(reg_name, offset_tm))

    elif reg_name == 'DTSS_OFFSET_TE':
        reg_msg = "  read_data(31:16) = x\"0\"' & OFFSET_TE(11:0)"
        print(reg_msg)
        offset_te = (reg_value >> 16) & 0xffff
        print("     > %s(11:0) = 0x%x" %(reg_name, offset_te))

    elif reg_name == "DTSS_STATUS":
        reg_msg = "  read_data(31:24) = STATUS(7:0)"
        print(reg_msg)

        register_status = (reg_value >> 24) & 0xffff
        print("  => register_status = 0x%x" %register_status)

        mmc_bdt_locked     = register_status & 0x1
        mmc_pulse_locked   = (register_status >> 1) & 0x1
        mmc_bus_locked     = (register_status >> 2) & 0x1
        bdt_meas_in_prog   = (register_status >> 3) & 0x1
        new_data_pt100     = (register_status >> 4) & 0x1
        ddr3_sts           = (register_status >> 5) & 0x1
        sts_irq_bdt        = (register_status >> 6) & 0x1
        sts_irq_freq       = (register_status >> 7) & 0x1
        print("     > %s(0)  = mmc_bdt_locked   = %d" %(reg_name, mmc_bdt_locked))
        print("     > %s(1)  = mmc_pulse_locked = %d" %(reg_name, mmc_pulse_locked))
        print("     > %s(2)  = mmc_bus_locked   = %d" %(reg_name, mmc_bus_locked))
        print("     > %s(3)  = bdt_meas_in_prog = %d" %(reg_name, bdt_meas_in_prog))
        print("     > %s(4)  = new_data_pt100   = %d" %(reg_name, new_data_pt100))
        print("     > %s(5)  = ddr3_sts         = %d" %(reg_name, ddr3_sts))
        print("     > %s(6)  = sts_irq_bdt      = %d" %(reg_name, sts_irq_bdt))
        print("     > %s(7)  = sts_irq_freq     = %d" %(reg_name, sts_irq_freq))

    elif reg_name == "DTSS_MISC":
        reg_msg = "  read_data(31:0) = x\"00\" & MISC(23:0)"
        print(reg_msg)
        bdt_meas_start     = reg_value & 0x1
        test_adc           = (reg_value >> 1) & 0x1
        bdt_on             = (reg_value >> 3) & 0x1
        rmem_from_micro    = (reg_value >> 4) & 0x1

        clear_irq_bdt      = (reg_value >> 6) & 0x1
        clear_irq_freq     = (reg_value >> 7) & 0x1
        write_ddr3         = (reg_value >> 8) & 0x1
        read_ddr3          = (reg_value >> 9) & 0x1
        reset_mmc_bus      = (reg_value >> 11) & 0x1
        LVDS_MSB           = (reg_value >> 12) & 0x1
        LVDS_LSB_VOIE      = (reg_value >> 13) & 0x1
        LVDS_START_XFER    = (reg_value >> 14) & 0x1
        MULT_CAN_TX        = (reg_value >> 15) & 0x1
        pulse_diff         = (reg_value >> 16) & 0x1
        reset_xadc         = (reg_value >> 17) & 0x1
        reset_mmc_bdt      = (reg_value >> 18) & 0x1
        reset_mmc_pulse    = (reg_value >> 19) & 0x1
        LVDS_RESET_SER     = (reg_value >> 20) & 0x1
        nRESET_DDR3        = (reg_value >> 21) & 0x1

        print("     > %s(0)  = bdt_meas_start   = %d" %(reg_name, bdt_meas_start))
        print("     > %s(1)  = test_adc         = %d" %(reg_name, test_adc))
        print("     > %s(2)  = unused           = 0 " %(reg_name))
        print("     > %s(3)  = bdt_on           = %d" %(reg_name, bdt_on))
        print("     > %s(4)  = rmem_from_micro  = %d" %(reg_name, rmem_from_micro))
        print("     > %s(5)  = unused           = 0" %(reg_name))
        print("     > %s(6)  = clear_irq_bdt    = %d" %(reg_name, clear_irq_bdt))
        print("     > %s(7)  = clear_irq_freq   = %d" %(reg_name, clear_irq_freq))
        print("     > %s(8)  = write_ddr3       = %d" %(reg_name, write_ddr3))
        print("     > %s(9)  = read_ddr3        = %d" %(reg_name, read_ddr3))
        print("     > %s(10) = unused           = 0" %(reg_name))
        print("     > %s(11) = reset_mmc_bus    = %d" %(reg_name, reset_mmc_bus))
        print("     > %s(12) = LVDS_MSB         = %d" %(reg_name, LVDS_MSB))
        print("     > %s(13) = LVDS_LSB_VOIE    = %d" %(reg_name, LVDS_LSB_VOIE))
        print("     > %s(14) = LVDS_START_XFER  = %d" %(reg_name, LVDS_START_XFER))
        print("     > %s(15) = MULT_CAN_TX      = %d" %(reg_name, MULT_CAN_TX))

        print("     > %s(16) = pulse_diff       = %d" %(reg_name, pulse_diff))
        print("     > %s(17) = reset_xadc       = %d" %(reg_name, reset_xadc))
        print("     > %s(18) = reset_mmc_bdt    = %d" %(reg_name, reset_mmc_bdt))
        print("     > %s(19) = reset_mmc_pulse  = %d" %(reg_name, reset_mmc_pulse))
        print("     > %s(20) = LVDS_RESET_SER   = %d" %(reg_name, LVDS_RESET_SER))
        print("     > %s(21) = nRESET_DDR3      = %d" %(reg_name, nRESET_DDR3))
        print("     > %s(22) = unused           = 0" %(reg_name))
        print("     > %s(23) = unused           = 0" %(reg_name))

    #--------------------------------
    # DTSS "hardware" (hw) registers
    #--------------------------------
    
    elif reg_name == 'DTSS_ON_ALIM':
        reg_msg = "  read_data(31:16) = REGISTER_ON_ALIM(15:0)"
        print(reg_msg)
        register_on_alim = (reg_value >> 16) & 0xffff

        on_alim           = register_on_alim & 0x1
        on_alim_16V       = (register_on_alim >> 1) & 0x1
        on_alim_5V8       = (register_on_alim >> 2) & 0x1
        on_alim_pulseur   = (register_on_alim >> 3) & 0x1
        on_alim_sync_puls = (register_on_alim >> 6) & 0x1
        fan_on            = (register_on_alim >> 7) & 0x1
        led_on            = (register_on_alim >> 8) & 0x1
        reset_clk_div     = (register_on_alim >> 10) & 0x1
        soa_inh_regul_las = (register_on_alim >> 12) & 0x1
        en_soa_pulse      = (register_on_alim >> 13) & 0x1
        i2c_valid_adp5050 = (register_on_alim >> 14) & 0x1
        nouvelle_data_lmk = (register_on_alim >> 15) & 0x1

        print("     > %s(0)  = on_alim           = %d" %(reg_name, on_alim))
        print("     > %s(1)  = on_alim_16V       = %d" %(reg_name, on_alim_16V))
        print("     > %s(2)  = on_alim_5V8       = %d " %(reg_name, on_alim_5V8))
        print("     > %s(3)  = on_alim_pulseur   = %d" %(reg_name, on_alim_pulseur))
        print("     > %s(4)  = unused            = 0" %(reg_name))
        print("     > %s(5)  = unused            = 0" %(reg_name))
        print("     > %s(6)  = on_alim_sync_puls = %d" %(reg_name, on_alim_sync_puls))
        print("     > %s(7)  = fan_on            = %d" %(reg_name, fan_on))
        print("     > %s(8)  = led_on            = %d" %(reg_name, led_on))
        print("     > %s(9)  = unused            = 0" %(reg_name))
        print("     > %s(10) = reset_clk_div     = %d" %(reg_name, reset_clk_div))
        print("     > %s(11) = unused            = 0" %(reg_name))
        print("     > %s(12) = soa_inh_regul_las = %d" %(reg_name, soa_inh_regul_las))
        print("     > %s(13) = en_soa_pulse      = %d" %(reg_name, en_soa_pulse))
        print("     > %s(14) = i2c_valid_adp5050 = %d" %(reg_name, i2c_valid_adp5050))
        print("     > %s(15) = nouvelle_data_lmk = %d" %(reg_name, nouvelle_data_lmk))

    elif reg_name == 'DTSS_LAS_FURU_SL':
        reg_msg = " Not implemented"
        print(reg_msg)
    elif reg_name == 'DTSS_LAS_FURU_OL':
        reg_msg = " Not implemented"
        print(reg_msg)
    elif reg_name == 'DTSS_AMPLI_RF':
        reg_msg = " Not implemented"
        print(reg_msg)
    elif reg_name == 'DTSS_RS232':
        reg_msg = " Not implemented"
        print(reg_msg)
    elif reg_name == 'DTSS_DAC_SL':
        reg_msg = " Not implemented"
        print(reg_msg)
    elif reg_name == 'DTSS_DAC_OL':
        reg_msg = " Not implemented"
        print(reg_msg)
    elif reg_name == 'DTSS_FREQUENCE':
        reg_msg = " Not implemented"
        print(reg_msg)
    elif reg_name == 'DTSS_FREQ_WIN':
        reg_msg = " Not implemented"
        print(reg_msg)
    elif reg_name == 'DTSS_OPTICAL_SW':
        reg_msg = " Not implemented"
        print(reg_msg)
    elif reg_name == 'DTSS_DATA_LMK':
        reg_msg = " Not implemented"
        print(reg_msg)
    elif reg_name == 'DTSS_FAN_PWM_DUTY':
        reg_msg = "  read_data(31:24) = '0' & REGISTER_FAN_DUTY(6:0)"
        print(reg_msg)
        fan_duty = (reg_value >> 24) & 0x7f
        print("     > %s(6:0) = 0x%x" %(reg_name, fan_duty))

    elif reg_name == 'DTSS_FREQUENCE_READ':
        reg_msg = "  read_data(31:0) = REGISTER_FREQUENCE_READ(31:0)"
        print(reg_msg)
        print("     > %s(31:0) = 0x%x" %(reg_name, reg_value))

    elif reg_name == 'DTSS_FAN_PWM_DIV':
        reg_msg = "  read_data(31:16) = x\"0\" & REGISTER_FAN_PWM_DIV(11:0)"
        print(reg_msg)
        fan_pwm_div = (reg_value >> 16) & 0xfff
        print("     > %s(11:0) = 0x%x" %(reg_name, fan_pwm_div))

    elif reg_name == 'DTSS_PT100_CMDE':
        reg_msg = " Not implemented"
        print(reg_msg)

    elif reg_name == 'DTSS_PT100_INT':
        reg_msg = " Not implemented"
        print(reg_msg)

    elif reg_name == 'DTSS_PT100_EXT':
        reg_msg = " Not implemented"
        print(reg_msg)

    elif reg_name == 'DTSS_PT100_REG':
        reg_msg = " Not implemented"
        print(reg_msg)

    elif reg_name == 'DTSS_FREQ_REGUL':
        reg_msg = " Not implemented"
        print(reg_msg)

    elif reg_name == 'DTSS_FREQ_REGUL_WIN':
        reg_msg = " Not implemented"
        print(reg_msg)
    else:
        pass

    return None
#
#********************************************
@DIAG("DTSS BDT registers read access")
def t_osbdtss_bdt_reg_rdbk(cmd):
#********************************************
#
    try:
        if len(cmd.split(' ')) == 2:
            cmd_lgth = 2
            (command, reg_name) = cmd.split(' ')
            verbose = False
        else:
            cmd_lgth = 3
            (command, reg_name, verbose_flag) = cmd.split(' ')

            if verbose_flag == "verbose":
                verbose = True
            else:
                print_error("   Syntax error : 2nd arg must be : verbose")
                return False

    except:
        print()
        print_error("   Syntax error : Command must be : t_osbdtss_bdt_reg_rdbk <reg_name> ")
        print_error("   where <reg_name> is :                                              ")
        print_error("                         DTSS_TNUMBER                                 ")
        print_error("                         DTSS_NDURATION                               ")
        print_error("                         DTSS_ANUMBER                                 ")
        print_error("                         DTSS_ARMAX                                   ")
        print_error("                         DTSS_ARINC                                   ")
        print_error("                         DTSS_CNUMBER                                 ")
        print_error("                         DTSS_PULSE                                   ")
        print_error("                         DTSS_CRNUMBER                                ")
        print_error("                         DTSS_MISC                                    ")
        print_error("                         DTSS_STATUS                                  ")
        print_error("                         DTSS_OFFSET_TM                               ")
        print_error("                         DTSS_OFFSET_TE                               ")
        print_error("                                                                      ")
        print_error("       <verbose_flag> = MUST be verbose ONLY                          ")
        print_error("                        Note : <verbose_flag> is optional             ")
        print()
        return False

    if verbose:
        print("\nreg_name is", reg_name)

    if reg_name == 'DTSS_TNUMBER':
        DTSS_SPI_REG = DTSS_SPI_TNUMBER
    elif reg_name == 'DTSS_NDURATION':
        DTSS_SPI_REG = DTSS_SPI_NDURATION
    elif reg_name == 'DTSS_ANUMBER':
        DTSS_SPI_REG = DTSS_SPI_ANUMBER
    elif reg_name == 'DTSS_ARMAX':
        DTSS_SPI_REG = DTSS_SPI_ARMAX
    elif reg_name == 'DTSS_ARINC':
        DTSS_SPI_REG = DTSS_SPI_ARINC
    elif reg_name == 'DTSS_CNUMBER':
        DTSS_SPI_REG = DTSS_SPI_CNUMBER
    elif reg_name == 'DTSS_PULSE':
        DTSS_SPI_REG = DTSS_SPI_PULSE
    elif reg_name == 'DTSS_CRNUMBER':
        DTSS_SPI_REG = DTSS_SPI_CRNUMBER
    elif reg_name == 'DTSS_MISC':
        DTSS_SPI_REG = DTSS_SPI_MISC
    elif reg_name == 'DTSS_STATUS':
        DTSS_SPI_REG = DTSS_SPI_STATUS
    elif reg_name == 'DTSS_OFFSET_TM':
        DTSS_SPI_REG = DTSS_SPI_OFFSET_TM
    elif reg_name == 'DTSS_OFFSET_TE':
        DTSS_SPI_REG = DTSS_SPI_OFFSET_TE
    else:
        print()
        print_error("* Error : Unknown register")
        return False

    if is_dtss_fpga_present() == True:
        pass
    else:
        return False

    if os.path.exists('/dev/uts_spi'):
        side  = 0
        slice = DTSS_SLICE
        Utsspi = utsspi.SpiModule(side, slice, "/dev/uts_spi")
    else:
        print("Utsspi driver (/dev/uts_spi) not found")
        return False
            
    reg_value = Utsspi.read_mod_register32(DTSS_SPI_REG)
    print("\n* %s reg_value read (@ addr = 0x%x) = 0x%x" %(reg_name, DTSS_SPI_REG, reg_value))

    if verbose:
        show_dtss_reg_contents(reg_name, reg_value)

    return None
#
#********************************************
@DIAG("DTSS HW registers read access")
def t_osbdtss_hw_reg_rdbk(cmd):
#********************************************
#
    try:
        if len(cmd.split(' ')) == 2:
            cmd_lgth = 2
            (command, reg_name) = cmd.split(' ')
            verbose = False
        else:
            cmd_lgth = 3
            (command, reg_name, verbose_flag) = cmd.split(' ')

            if verbose_flag == "verbose":
                verbose = True
            else:
                print_error("   Syntax error : 2nd arg must be : verbose")
                return False

    except:
        print()
        print_error("   Syntax error : Command must be : t_osbdtss_hw_reg_rdbk <reg_name>")
        print_error("   where <reg_name> is :                                            ")
        print_error("                         DTSS_ON_ALIM                               ")
        print_error("                         DTSS_LAS_FURU_SL                           ")
        print_error("                         DTSS_LAS_FURU_OL                           ")
        print_error("                         DTSS_AMPLI_RF                              ")
        print_error("                         DTSS_RS232                                 ")
        print_error("                         DTSS_DAC_SL                                ")
        print_error("                         DTSS_DAC_OL                                ")
        print_error("                         DTSS_FREQUENCE                             ")
        print_error("                         DTSS_FREQ_WIN                              ")
        print_error("                         DTSS_OPTICAL_SW                            ")
        print_error("                         DTSS_DATA_LMK                              ")
        print_error("                         DTSS_FAN_PWM_DUTY                          ")
        print_error("                         DTSS_FREQUENCE_READ                        ")
        print_error("                         DTSS_FAN_PWM_DIV                           ")
        print_error("                         DTSS_PT100_CMDE                            ")
        print_error("                         DTSS_PT100_INT                             ")
        print_error("                         DTSS_PT100_EXT                             ")
        print_error("                         DTSS_PT100_REG                             ")
        print_error("                         DTSS_FREQ_REGUL                            ")
        print_error("                         DTSS_FREQ_REGUL_WIN                        ")
        print_error("                                                                    ")
        print_error("       <verbose_flag> = MUST be verbose ONLY                        ")
        print_error("                        Note : <verbose_flag> is optional           ")
        print()
        return False

    if verbose:
        print("\n* reg_name is", reg_name)

    if reg_name == 'DTSS_ON_ALIM':
        DTSS_SPI_REG = DTSS_SPI_ON_ALIM
    elif reg_name == 'DTSS_LAS_FURU_SL':
        DTSS_SPI_REG = DTSS_SPI_LAS_FURU_SL
    elif reg_name == 'DTSS_LAS_FURU_OL':
        DTSS_SPI_REG = DTSS_SPI_LAS_FURU_OL
    elif reg_name == 'DTSS_AMPLI_RF':
        DTSS_SPI_REG = DTSS_SPI_AMPLI_RF
    elif reg_name == 'DTSS_RS232':
        DTSS_SPI_REG = DTSS_SPI_RS232
    elif reg_name == 'DTSS_DAC_SL':
        DTSS_SPI_REG = DTSS_SPI_DAC_SL
    elif reg_name == 'DTSS_DAC_OL':
        DTSS_SPI_REG = DTSS_SPI_DAC_OL
    elif reg_name == 'DTSS_FREQUENCE':
        DTSS_SPI_REG = DTSS_SPI_FREQUENCE
    elif reg_name == 'DTSS_FREQ_WIN':
        DTSS_SPI_REG = DTSS_SPI_FREQ_WIN
    elif reg_name == 'DTSS_OPTICAL_SW':
        DTSS_SPI_REG = DTSS_SPI_OPTICAL_SW
    elif reg_name == 'DTSS_DATA_LMK':
        DTSS_SPI_REG = DTSS_SPI_DATA_LMK
    elif reg_name == 'DTSS_FAN_PWM_DUTY':
        DTSS_SPI_REG = DTSS_SPI_FAN_PWM_DUTY
    elif reg_name == 'DTSS_FREQUENCE_READ':
        DTSS_SPI_REG = DTSS_SPI_FREQUENCE_READ
    elif reg_name == 'DTSS_FAN_PWM_DIV':
        DTSS_SPI_REG = DTSS_SPI_FAN_PWM_DIV
    elif reg_name == 'DTSS_PT100_CMDE':
        DTSS_SPI_REG = DTSS_SPI_PT100_CMDE
    elif reg_name == 'DTSS_PT100_INT':
        DTSS_SPI_REG = DTSS_SPI_PT100_INT
    elif reg_name == 'DTSS_PT100_EXT':
        DTSS_SPI_REG = DTSS_SPI_PT100_EXT
    elif reg_name == 'DTSS_PT100_REG':
        DTSS_SPI_REG = DTSS_SPI_PT100_REG
    elif reg_name == 'DTSS_FREQ_REGUL':
        DTSS_SPI_REG = DTSS_SPI_FREQ_REGUL
    elif reg_name == 'DTSS_FREQ_REGUL_WIN':
        DTSS_SPI_REG = DTSS_SPI_FREQ_REGUL_WIN
    else:
        print()
        print_error("* Error : Unknown register")
        return False

    if is_dtss_fpga_present() == True:
        pass
    else:
        return False

    if os.path.exists('/dev/uts_spi'):
        side  = 0
        slice = DTSS_SLICE
        Utsspi = utsspi.SpiModule(side, slice, "/dev/uts_spi")
    else:
        print("Utsspi driver (/dev/uts_spi) not found")
        return False

    reg_value = Utsspi.read_mod_register32(DTSS_SPI_REG)

    if verbose:
        show_dtss_reg_contents(reg_name, reg_value)
    else:
        print("\n* %s reg_value read (@ addr = 0x%x) = 0x%x" %(reg_name, DTSS_SPI_REG, reg_value))

    return None
#
#*************************************************
@DIAG("DTSS DTSS_ON_ALIM register access test")
def t_osbdtss_on_alim_reg_set(cmd):
#************************************************
#
    error_flag = False

    try:
        if len(cmd.split(' ')) == 2:
            cmd_lgth = 2
            (command, reg_value) = cmd.split(' ')
        else:
            cmd_lgth = 3
            (command, reg_value, verbose_flag) = cmd.split(' ')

        if cmd_lgth == 3:
            if verbose_flag == "verbose":
                verbose = True
            else:
                print()
                print_error("   Syntax error : 2nd arg must be : verbose")
                error_flag = True
        else:
            verbose = False
    except:
        print_error("# Command must be: t_osbdtss_on_alim_reg_set <value>")

        return False

    if error_flag:
        return False

    if is_dtss_fpga_present() == True:
        pass
    else:
        return False

    if os.path.exists('/dev/uts_spi'):
        side  = 0
        slice = DTSS_SLICE
        Utsspi = utsspi.SpiModule(side, slice, "/dev/uts_spi")
    else:
        print("Utsspi driver (/dev/uts_spi) not found")
        return False

    reg_name = 'DTSS_ON_ALIM'
    reg_addr = DTSS_SPI_ON_ALIM
    reg_range = '(15:0)'

    reg_mask = 0x1ffffff

    wr_data = int(reg_value, 16)

    print("\n ******************************************************")
    print(" * DTSS %s %s SPI write_32 : 0x%x" %(reg_name, reg_range, wr_data))
    print(" ******************************************************")
    test = Utsspi.write_mod_register32(reg_addr, wr_data)

    reg_value_rdback = Utsspi.read_mod_register32(reg_addr)

    show_dtss_reg_contents(reg_name, reg_value_rdback)

    return None
#
#*************************************************
@DIAG("DTSS DTSS_TNUMBER register access test")
def t_osbdtss_reg_access_test(cmd):
#************************************************
#
    try:
        if len(cmd.split(' ')) == 2:
            cmd_lgth = 2
            (command, data_value_str) = cmd.split(' ')
            verbose = False
        else:
            cmd_lgth = 3
            (command, data_value_str, verbose_flag) = cmd.split(' ')

            if verbose_flag == "verbose":
                verbose = True
            else:
                print_error("   Syntax error : 2nd arg must be : verbose")
                return False

    except:
        print_error("                                                                                        ")
        print_error("   Syntax error : Command must be : t_osbdtss_reg_access_test <consigne> <verbose_flag> ")
        print_error("                                                                                        ")
        print_error("   where <consigne> is     : <data_value> in hexa  (ex : 0x5a2b3456)                    ")
        print_error("         <verbose_flag> is : MUST be verbose ONLY                                       ")
        print_error("                             Note : <verbose_flag> parameter is optional                ")
        print_error("                                                                                        ")
        print_error("          Register concerned : tnumber_reg                                              ")
        print()

        return False
    
    wr_data = int(data_value_str, base=16)
 
    if is_dtss_fpga_present() == True:
        pass
    else:
        return False

    if os.path.exists('/dev/uts_spi'):
        side  = 0
        slice = DTSS_SLICE
        Utsspi = utsspi.SpiModule(side, slice, "/dev/uts_spi")
    else:
        print("Utsspi driver (/dev/uts_spi) not found")
        return False

    if verbose:
        print("\n*********** Side = %d ; slice = %d **************" %(side, slice))

    reg_name = 'DTSS_TNUMBER'
    reg_range = '(24:0)'

    reg_mask = 0x1ffffff

    if verbose:
        print("\n ***************************************************")
        print(" * DTSS %s %s write_32 : 0x%x" %(reg_name, reg_range, wr_data))
        print(" ***************************************************")

    Utsspi.write_mod_register32(DTSS_SPI_TNUMBER, wr_data)

    expected_value = wr_data & reg_mask

    reg_value = Utsspi.read_mod_register32(DTSS_SPI_TNUMBER)

    if verbose:
        print("\n ***************************************************")
        print(" * DTSS tnumber_reg(24:0) readback_32 : 0x%x" %reg_value)
        print(" ***************************************************")

    if reg_value == expected_value:
        msg = 'PASS'
        print_ok("\n * DTSS tnumber_reg(24:0) readback value : 0x%x : exp_value = 0x%x : %s" %(reg_value, expected_value, msg))
        return_flag = True
    else:
        msg = 'FAIL'
        print_error("\n * DTSS tnumber_reg(24:0) readback value : 0x%x : exp_value = 0x%x : %s" %(reg_value, expected_value, msg))
        return_flag = False

    if verbose:
        show_dtss_reg_contents(reg_name, reg_value)

    return return_flag
#
#********************************************
@DIAG("DTSS BDT registers write access")
def t_osbdtss_bdt_reg_set(cmd):
#********************************************
#
    try:
        if len(cmd.split(' ')) == 2:
            cmd_lgth = 2
            (command, consigne) = cmd.split(' ')
            verbose = False
        else:
            cmd_lgth = 3
            (command, consigne, verbose_flag) = cmd.split(' ')
            
            if verbose_flag == "verbose":
                verbose = True
            else:
                print_error("   Syntax error : 2nd arg must be : verbose")
                return False

        (reg_name, reg_value_str) = consigne.split('-')
        reg_value_wr = int(reg_value_str, base=16)
    
    except:
        print()
        print_error("   Syntax error : Command must be : t_osbdtss_bdt_reg_set <consigne> <verbose> ")
        print_error("   where <consigne is : <reg_name>-<reg_value>                                 ")
        print_error("                                                                               ")
        print_error("                        <reg_name> is :                                        ")
        print_error("                           DTSS_TNUMBER                                        ")
        print_error("                           DTSS_NDURATION                                      ")
        print_error("                           DTSS_ANUMBER                                        ")
        print_error("                           DTSS_ARMAX                                          ")
        print_error("                           DTSS_ARINC                                          ")
        print_error("                           DTSS_CNUMBER                                        ")
        print_error("                           DTSS_PULSE                                          ")
        print_error("                           DTSS_CRNUMBER                                       ")
        print_error("                           DTSS_MISC                                           ")
        print_error("                           DTSS_STATUS                                         ")
        print_error("                           DTSS_OFFSET_TM                                      ")
        print_error("                           DTSS_OFFSET_TE                                      ")
        print_error("                                                                               ")
        print_error("                       <reg_value> is : hexa data value to write into register ")
        print_error("                                                                               ")
        print_error("         <verbose_flag> = MUST be verbose ONLY                                 ")
        print_error("                          Note : <verbose_flag> is optional                    ")
        print()
        return False

    if reg_name == 'DTSS_TNUMBER':
        DTSS_SPI_REG = DTSS_SPI_TNUMBER
    elif reg_name == 'DTSS_NDURATION':
        DTSS_SPI_REG = DTSS_SPI_NDURATION
    elif reg_name == 'DTSS_ANUMBER':
        DTSS_SPI_REG = DTSS_SPI_ANUMBER
    elif reg_name == 'DTSS_ARMAX':
        DTSS_SPI_REG = DTSS_SPI_ARMAX
    elif reg_name == 'DTSS_ARINC':
        DTSS_SPI_REG = DTSS_SPI_ARINC
    elif reg_name == 'DTSS_CNUMBER':
        DTSS_SPI_REG = DTSS_SPI_CNUMBER
    elif reg_name == 'DTSS_PULSE':
        DTSS_SPI_REG = DTSS_SPI_PULSE
    elif reg_name == 'DTSS_CRNUMBER':
        DTSS_SPI_REG = DTSS_SPI_CRNUMBER
    elif reg_name == 'DTSS_MISC':
        DTSS_SPI_REG = DTSS_SPI_MISC
    elif reg_name == 'DTSS_STATUS':
        DTSS_SPI_REG = DTSS_SPI_STATUS
    elif reg_name == 'DTSS_OFFSET_TM':
        DTSS_SPI_REG = DTSS_SPI_OFFSET_TM
    elif reg_name == 'DTSS_OFFSET_TE':
        DTSS_SPI_REG = DTSS_SPI_OFFSET_TE
    else:
        print()
        print_error("* Error : Unknown register")
        return False

    if is_dtss_fpga_present() == True:
        pass
    else:
        return False

    if (os.path.exists("/dev/uts_spi")):
        side  = 0
        slice = DTSS_SLICE
        Utsspi = utsspi.SpiModule(side, slice, "/dev/uts_spi")
    else:
        print("Utsspi driver (/dev/uts_spi) not found")
        return False

    reg_value = Utsspi.read_mod_register32(DTSS_SPI_REG)
    print("\n%s (@ addr = 0x%x) reg_value read  before write = 0x%x" %(reg_name, DTSS_SPI_REG, reg_value))

    Utsspi.write_mod_register32(DTSS_SPI_REG, reg_value_wr)

    reg_value = Utsspi.read_mod_register32(DTSS_SPI_REG)
    
    if verbose:
        show_dtss_reg_contents(reg_name, reg_value)
    else:
        print("%s (@ addr = 0x%x) reg_value read  after write = 0x%x" %(reg_name, DTSS_SPI_REG, reg_value))

    return None
#
#********************************************
@DIAG("OSB DTSS hw and BDT status")
def t_osbdtss_regs_status(cmd):
#********************************************
#
    verbose = False

    #DTSS_SPI_FAN_PWM_DIV    = 0x51
    #DTSS_SPI_PT100_CMDE     = 0x52
    #DTSS_SPI_PT100_INT      = 0x53
    #DTSS_SPI_PT100_EXT      = 0x54
    #DTSS_SPI_PT100_REG      = 0x55
    #DTSS_SPI_FREQ_REGUL     = 0x56
    #DTSS_SPI_FREQ_REGUL_WIN = 0x59

    side = 0
    slice = DTSS_SLICE

    print("\n*********** Side = %d ; slice = %d **************" %(side, slice))

    if os.path.exists('/dev/uts_spi'):
        side  = 0
        slice = DTSS_SLICE
        Utsspi = utsspi.SpiModule(side, slice, "/dev/uts_spi")
    else:
        print("Utsspi driver (/dev/uts_spi) not found")
        return False

    #----------------------
    # DTSS BDT registers
    #----------------------

    reg_name  = []
    reg_addr  = []
    reg_range = []

    for elt in enumerate(DTSS_bdt_reg_name_list):
        reg_name.append(elt[1])

    for elt in enumerate(DTSS_bdt_reg_addr_list):
        reg_addr.append(elt[1])

    for elt in enumerate(DTSS_bdt_reg_range_list):
        reg_range.append(elt[1])

    print("")

    i = 0
    while i < len(reg_name):
        reg_value = Utsspi.read_mod_register32(reg_addr[i])

        print("* DTSS %s%s read (@ addr 0x%x) = 0x%x" %(reg_name[i], reg_range[i], reg_addr[i], reg_value))

        if verbose:
            show_dtss_reg_contents(reg_name[i], reg_value)

        i += 1

    #----------------------
    # DTSS hw registers
    #----------------------

    hw_reg_name  = []
    hw_reg_addr  = []
    hw_reg_range = []

    for elt in enumerate(DTSS_hw_reg_list):
        hw_reg_name.append(elt[1])

    for elt in enumerate(DTSS_hw_reg_addr_list):
        hw_reg_addr.append(elt[1])

    for elt in enumerate(DTSS_hw_reg_range_list):
        hw_reg_range.append(elt[1])

    print("")

    i = 0
    while i < len(hw_reg_name):
        reg_value = Utsspi.read_mod_register32(hw_reg_addr[i])

        print("* DTSS %s%s read (@ addr 0x%x) = 0x%x" %(hw_reg_name[i], hw_reg_range[i], hw_reg_addr[i], reg_value))

        if verbose:
            show_dtss_reg_contents(hw_reg_name[i], reg_value)

        i += 1

    return None
#
#================================================================================
#
@DIAG("DTSS SPI Debug")
def t_osbdtss_spi_dbg(cmd):
#================================================================================
#
    error_flag = False

    try:
        (command, consigne) = cmd.split()

        (board_type, spi_driver_flag) = consigne.split('-')

        if board_type == "B200" or board_type == "DTSS":
            pass
        else:
            print_error("Error : board_type MUST be : B200 or DTSS")
            error_flag = True

        if spi_driver_flag == "TRUE":
            Utsspi_driver = True
            if (os.path.exists("/dev/uts_spi")):
                side = 0
                slice = DTSS_SLICE
                Utsspi = utsspi.SpiModule(side, slice, "/dev/uts_spi")
            else:
                print("Utsspi driver (/dev/uts_spi) not found")
                return False
        elif spi_driver_flag == "FALSE":
            Utsspi_driver = False
        else:
            print_error("Error : spi_driver_flag MUST be : TRUE or FALSE")
            error_flag = True

        if error_flag == True:
            return False

    except:
        print_error("# Command must be: t_osbdtss_spi_dbg <board_type>-<spi_driver_flag>")
        print_error("#           with : <board_type> = B200|DTSS")
        print_error("#           with : <spi_driver_flag> = TRUE|FALSE")
        return False

    # Select SPI_DTSS

    verbose = True
    (dtss_fpga_rdy, dtss_presence, switch_presence) = module_presence_info(verbose)
    
    glu_reg_base_addr = get_glu_base_addr()

    # pwrside S3/S4
    if board_type == "B200":
        side = 0
        slice = B200_SLICE
    else:
        side = 0
        slice = DTSS_SLICE

    if board_type == "DTSS":

        if Utsspi_driver:
            if 1 == 0:
                ver_low     = Utsspi.read_mod_register8(DTSS_SPI_XVERSION)
                ver_middle0 = Utsspi.read_mod_register8(DTSS_SPI_XVERSION+1)
                ver_middle1 = Utsspi.read_mod_register8(DTSS_SPI_XVERSION+2)
                ver_high    = Utsspi.read_mod_register8(DTSS_SPI_XVERSION+3)

                print("DTSS ver is", ver_high, ver_middle1, ver_middle0, ver_low)

                tnumber_value = Utsspi.read_mod_register32(DTSS_SPI_TNUMBER)
                print(" * 1. tnumber_reg(24:0) before reset read_32 = 0x%x" %tnumber_value)

                wr_data = 0x0

                print(" * 2. DTSS tnumber_reg(24:0) write_32 : 0x%x" %wr_data)
                test = Utsspi.write_mod_register32(DTSS_SPI_TNUMBER, wr_data)

                tnumber_value = Utsspi.read_mod_register32(DTSS_SPI_TNUMBER)
                print("      DTSS tnumber_reg read_32 : 0x%x" %tnumber_value)

                wr_data = 0xbb5566aa
                print(" * 3. DTSS tnumber_reg(24:0) write_32 : 0x%x" %wr_data)
                test = Utsspi.write_mod_register32(DTSS_SPI_TNUMBER, wr_data)

                # read_data = '1' & 0x66aa & x"00"= wr_data(15:0)
                tnumber_value = Utsspi.read_mod_register32(DTSS_SPI_TNUMBER)
                print("      DTSS tnumber_reg read_32 : 0x%x" %tnumber_value)

                tnumber_value = Utsspi.read_mod_register24(DTSS_SPI_TNUMBER)
                print("      DTSS tnumber_reg read_24 : 0x%x" %tnumber_value)

                tnumber_value = Utsspi.read_mod_register16(DTSS_SPI_TNUMBER)
                print("      DTSS tnumber_reg read_16 : 0x%x" %tnumber_value)

                tnumber_value = Utsspi.read_mod_register8(DTSS_SPI_TNUMBER)
                print("      DTSS tnumber_reg read_8 : 0x%x" %tnumber_value)

                wr_data = 0xbb5466aa
                print(" * 4. DTSS tnumber_reg(24:0) write_32 : 0x%x" %wr_data)
                test = Utsspi.write_mod_register32(DTSS_SPI_TNUMBER, wr_data)

                # TNUMBER(24:0)
                # read_data(31 downto 0) =  "0000000" & TNUMBER(24:0)
                # tnumber_value = '1' & 0x7f64 & x"00" = wr_data(16) & wr_data(15:0) & x"00"

                tnumber_value = Utsspi.read_mod_register32(DTSS_SPI_TNUMBER)
                print("      DTSS tnumber_reg read_32 0x%x" %tnumber_value)

                wr_data = 0x27f64
                print(" * 6. DTSS tnumber_reg(24:0) write_32 : 0x%x" %wr_data)
                test = Utsspi.write_mod_register32(DTSS_SPI_TNUMBER, wr_data)

                # read_data = '1' & 0x7f64 = wr_data(16) & wr_data(15:0) & x"00"
                tnumber_value = Utsspi.read_mod_register32(DTSS_SPI_TNUMBER)
                print("      DTSS tnumber_reg read_32 : 0x%x" %tnumber_value)

                # DTSS_SPI_PULSE register

                wr_data = 0x9a57e681
                print(" * 7. DTSS pulse_reg(31:0) write : 0x%x" %wr_data)
                test = Utsspi.write_mod_register32(DTSS_SPI_PULSE, wr_data)

                # read_data(31 downto 0) = PULSE_VALUE(31 downto 0) =
                # pulse_value = 0xe6810000 = wr_data(15:0) & x"0000"
                pulse_value = Utsspi.read_mod_register32(DTSS_SPI_PULSE)
                print("      DTSS pulse_reg read_32 : 0x%x" %pulse_value)

                # DTSS_SPI_NDURATION register

                wr_data = 0x1234feef
                print(" * 8. DTSS NOISE_DURATION_reg(16:0) write : 0x%x" %wr_data)
                # NOISE_DURATION(16 downto 0)

                # read_data(31 downto 8) = "0000000" & NOISE_DURATION (16 downto 0)
                # duration_value = 0xfeef00 = wr_data(15:0) & x"00"

                Utsspi.write_mod_register32(DTSS_SPI_NDURATION, wr_data)
                duration_value = Utsspi.read_mod_register32(DTSS_SPI_NDURATION)
                print("      DTSS duration_reg read_32 : 0x%x" %duration_value)

                wr_data = 0xb975feef
                print(" * 9. DTSS NOISE_DURATION_reg(16:0) write : 0x%x" %wr_data)
                # NOISE_DURATION(16 downto 0)

                # read_data(31 downto 8) = "0000000" & NOISE_DURATION (16 downto 0)
                # duration_value = 0x01feef00 = wr_data(16) & wr_data(15:0) & x"00"

                Utsspi.write_mod_register32(DTSS_SPI_NDURATION, wr_data)
                duration_value = Utsspi.read_mod_register32(DTSS_SPI_NDURATION)
                print("      DTSS duration_reg read_32 : 0x%x" %duration_value)

                duration_value = Utsspi.read_mod_register24(DTSS_SPI_NDURATION)
                print("      DTSS duration_reg read_24 : 0x%x" %duration_value)

                duration_value = Utsspi.read_mod_register16(DTSS_SPI_NDURATION)
                print("      DTSS duration_reg read_16 : 0x%x" %duration_value)

                duration_value = Utsspi.read_mod_register8(DTSS_SPI_NDURATION)
                print("      DTSS duration_reg read_8 : 0x%x" %duration_value)

                print("****************************")

                wr_data = 0x0

                print(" * 2. DTSS tnumber_reg(24:0) write_16 : 0x%x" %wr_data)
                test = Utsspi.write_mod_register16(DTSS_SPI_TNUMBER, wr_data)

                tnumber_value = Utsspi.read_mod_register16(DTSS_SPI_TNUMBER)
                print("      DTSS tnumber_reg read_16 : 0x%x" %tnumber_value)

                wr_data = 0xb6a5

                print(" * 2. DTSS tnumber_reg(24:0) write_16 : 0x%x" %wr_data)
                test = Utsspi.write_mod_register16(DTSS_SPI_TNUMBER, wr_data)

                tnumber_value = Utsspi.read_mod_register16(DTSS_SPI_TNUMBER)
                print("      DTSS tnumber_reg read_16 : 0x%x" %tnumber_value)

                tnumber_value = Utsspi.read_mod_register16(DTSS_SPI_TNUMBER)
                print("      DTSS tnumber_reg read_16 : 0x%x" %tnumber_value)

                tnumber_value = Utsspi.read_mod_register24(DTSS_SPI_TNUMBER)
                print("      DTSS tnumber_reg read_24 : 0x%x" %tnumber_value)

                tnumber_value = Utsspi.read_mod_register32(DTSS_SPI_TNUMBER)
                print("      DTSS tnumber_reg read_32 : 0x%x" %tnumber_value)

                print("****************************")

                wr_data = 0x0

                print(" * 1. DTSS tnumber_reg(24:0) write_8 : 0x%x" %wr_data)
                test = Utsspi.write_mod_register8(DTSS_SPI_TNUMBER, wr_data)

                tnumber_value = Utsspi.read_mod_register8(DTSS_SPI_TNUMBER)
                print("      DTSS tnumber_reg read_8 : 0x%x" %tnumber_value)

                wr_data = 0x5500
                print(" * 2. DTSS tnumber_reg(24:0) write_8 : 0x%x" %wr_data)
                test = Utsspi.write_mod_register8(DTSS_SPI_TNUMBER, wr_data)

                tnumber_value = Utsspi.read_mod_register8(DTSS_SPI_TNUMBER)
                print("      DTSS tnumber_reg read_8 : 0x%x" %tnumber_value)

                wr_data = 0xaa
                print(" * 3. DTSS tnumber_reg(24:0) write_8 : 0x%x" %wr_data)
                test = Utsspi.write_mod_register8(DTSS_SPI_TNUMBER, wr_data)

                tnumber_value = Utsspi.read_mod_register8(DTSS_SPI_TNUMBER)
                print("      DTSS tnumber_reg read_8 : 0x%x" %tnumber_value)

            else:
                wr_data = 0x3355aa
                print("\n *** 1. DTSS tnumber_reg(24:0) write_8 : 0x%x" %wr_data)
                test = Utsspi.write_mod_register8(DTSS_SPI_TNUMBER, wr_data)

                input("\n* Press Enter to continue")

                tnumber_value = Utsspi.read_mod_register8(DTSS_SPI_TNUMBER)
                print("\n      DTSS tnumber_reg read_8 : 0x%x" %tnumber_value)

                input("\n* Press Enter to continue")

                tnumber_value = Utsspi.read_mod_register16(DTSS_SPI_TNUMBER)
                print("\n      DTSS tnumber_reg read_16 : 0x%x" %tnumber_value)

                input("\n* Press Enter to continue")

                tnumber_value = Utsspi.read_mod_register32(DTSS_SPI_TNUMBER)
                print("\n      DTSS tnumber_reg read_32 : 0x%x" %tnumber_value)

                input("\n* Press Enter to continue")

                wr_data = 0x55aa
                print("\n *** 2. DTSS tnumber_reg(24:0) write_16 : 0x%x" %wr_data)
                test = Utsspi.write_mod_register16(DTSS_SPI_TNUMBER, wr_data)

                tnumber_value = Utsspi.read_mod_register8(DTSS_SPI_TNUMBER)
                print("\n      DTSS tnumber_reg read_8 : 0x%x" %tnumber_value)

                tnumber_value = Utsspi.read_mod_register16(DTSS_SPI_TNUMBER)
                print("\n      DTSS tnumber_reg read_16 : 0x%x" %tnumber_value)

                tnumber_value = Utsspi.read_mod_register32(DTSS_SPI_TNUMBER)
                print("\n      DTSS tnumber_reg read_32 : 0x%x" %tnumber_value)

                input("\n* Press Enter to continue")

                wr_data = 0x3355aa
                print("\n *** 3. DTSS tnumber_reg(24:0) write_32 : 0x%x" %wr_data)
                test = Utsspi.write_mod_register32(DTSS_SPI_TNUMBER, wr_data)

                tnumber_value = Utsspi.read_mod_register8(DTSS_SPI_TNUMBER)
                print("\n      DTSS tnumber_reg read_8 : 0x%x" %tnumber_value)

                tnumber_value = Utsspi.read_mod_register16(DTSS_SPI_TNUMBER)
                print("\n      DTSS tnumber_reg read_16 : 0x%x" %tnumber_value)

                tnumber_value = Utsspi.read_mod_register32(DTSS_SPI_TNUMBER)
                print("\n      DTSS tnumber_reg read_32 : 0x%x" %tnumber_value)
        else:
            data_wr = 0x73
            print(" * DTSS tnumber_reg(24:0) write_8 : 0x%x" %data_wr)
            value = spi_master_transfer(cWrite, DTSS_SPI_TNUMBER, data_wr)
            time.sleep(1)
            value = spi_master_transfer(cRead, DTSS_SPI_TNUMBER, 0)
            print("\nSPI Received Data Value = 0x%x" %value)

    #===============
    # B200 board :
    #===============

    else:
        if Utsspi_driver:
            cpld_version = Utsspi.read_mod_register8(SPI_ADDR_VERSION)
            print("\n* B200 CPLD version read : 0x%2x (using utsspi driver)" % cpld_version)

            input("\nEnter")

            wr_data = 0x55
            print("\nWrite 0x%x into CPLD reg. cAddress_RegLvds_7_0 using Utsspi driver:" %wr_data)
            ver = Utsspi.write_mod_register8(SPI_ADDR_REGLVDS_7_0, wr_data)

            input("\nEnter")

            print("\nRead CPLD reg. cAddress_RegLvds_7_0 using Utsspi driver:")

            value = Utsspi.read_mod_register8(SPI_ADDR_REGLVDS_7_0)
            print("reg. value after writing @ addr 0x%1x (cAddress_RegLvds_7_0) : 0x%x" %(SPI_ADDR_REGLVDS_7_0, value))

            input("\nEnter")

            wr_data = 0xaa
            print("\nWrite 0x%x into CPLD reg. cAddress_RegLvds_15_8 using Utsspi driver:" %wr_data)
            ver = Utsspi.write_mod_register8(SPI_ADDR_REGLVDS_15_8, wr_data)

            input("\nEnter")

            print("\nRead CPLD reg. cAddress_RegLvds_15_8 using Utsspi driver:")

            value = Utsspi.read_mod_register8(SPI_ADDR_REGLVDS_15_8)
            print("reg. value after writing @ addr 0x%1x (cAddress_RegLvds_5_8) : 0x%x" %(SPI_ADDR_REGLVDS_15_8, value))

            input("\nEnter")

            print("\nRead/Write OSB FPGA SPI_Master registers : ")

            spi_ctrl_value = get_reg_value(glu_reg_base_addr + REG_OSB_SPI_CTRL)
            print("\n* OSB SPI Master SPI_CTRL register = 0x%x" % spi_ctrl_value)
            print("     - SPI_CTRL(0) = spi_start = %d" %(spi_ctrl_value & 0x1))
            print("     - SPI_CTRL(1) = spi_sel16 = %d" %(spi_ctrl_value & 0x2))
            print("     - SPI_CTRL(2) = spi_cpol  = %d" %(spi_ctrl_value & 0x4))
            print("     - SPI_CTRL(3) = spi_cpha  = %d" %(spi_ctrl_value & 0x8))
            spi_ctrl_freq = (spi_ctrl_value & 0xff00) / 256
            print("     - SPI_CTRL(15:8) = spi_freq = %d" %spi_ctrl_freq)

            data_wr = 0xa5a55a5a
            print("\nSPI Master slv0 write value = 0x%x" % data_wr)
            reg_write(glu_reg_base_addr + REG_OSB_SPI_SLV0, data_wr)

            spi_slv0 = get_reg_value(glu_reg_base_addr + REG_OSB_SPI_SLV0)
            print("SPI Master slv0 read = 0x%x" % spi_slv0)

            data_wr = 0x12345678
            print("SPI Master slv1 write value = 0x%x" % data_wr)
            reg_write(glu_reg_base_addr + REG_OSB_SPI_SLV1, data_wr)

            spi_slv1 = get_reg_value(glu_reg_base_addr + REG_OSB_SPI_SLV1)
            print("SPI Master slv1 read = 0x%x" % spi_slv1)
        else:
            data_wr = 0x37
            value = spi_master_transfer(cWrite, SPI_ADDR_REGLVDS_7_0, data_wr)
            time.sleep(1)
            value = spi_master_transfer(cRead, SPI_ADDR_REGLVDS_7_0, 0)
            print("\nSPI Received Data Value = 0x%x" %value)

    return None
#
#***********************************
@DIAG("DTSS CPLD Frequency test")
def t_osbdtss_fan_check(cmd):
#***********************************
#
    verbose = False

    # DTSS module can control fans, by generating a Fan_on ctrl bit and a fan_PWM signal :

    (dtss_fpga_rdy, dtss_presence, switch_presence) = module_presence_info(verbose)

    if dtss_presence:
        if is_dtss_fpga_present():
            print("\n* DTSS board detected : FPGA loaded")
        else:
            print("\n* DTSS board detected :  FPGA not loaded")
    else:
        print("\n* DTSS board Not detected : check aborted")
        return False
    
    glu_reg_base_addr = get_glu_base_addr()
    fan_ON_bit_value = get_reg_value(glu_reg_base_addr + REG_MOD_FAN_RDBCK)

    print("\n* DTSS fan_ON_bit value readback = 0x%x" %fan_ON_bit_value)

    reg_val = get_reg_value(glu_reg_base_addr + REG_DTSS_FAN_TACHI_VAL)

    period_nb_for_1s = float(reg_val)

    print("* DTSS FAN PWM frequency readback = %5.3fHz" %period_nb_for_1s)

    return None
#
#***********************************************
@DIAG("OSB DTSS LVDS CLOCK FREQ MEASUREMENT")
def t_osbdtss_lvds_clk_meas(cmd):
#***********************************************
#
    verbose = True
    error_nb = 0

    bdt_reg_base_addr = get_pci_bdt_base_addr()
    
    if os.path.exists('/dev/uts_spi'):
        side  = 0
        slice = DTSS_SLICE
        Utsspi = utsspi.SpiModule(side, slice, "/dev/uts_spi")
    else:
        print("Utsspi driver (/dev/uts_spi) not found")
        return False

    reg_name = 'DTSS_ON_ALIM'
    reg_addr = DTSS_SPI_ON_ALIM
    reg_range = '(15:0)'
    reg_mask = 0x1ffffff

    wr_data = 0x7

    print("\n ******************************************************")
    print(" * DTSS %s %s SPI write_32 : 0x%x" %(reg_name, reg_range, wr_data))
    print(" ******************************************************")
    
    Utsspi.write_mod_register32(reg_addr, wr_data)

    reg_name = 'DTSS_MISC'
    reg_addr = DTSS_SPI_MISC
    reg_range = '(23:0)'
    reg_mask = 0xffffff

    bdt_on = 1
    lvds_reset_ser = 1
    wr_data = (lvds_reset_ser << 20) | (bdt_on << 3)

    print("\n ******************************************************")
    print(" * DTSS %s %s SPI write_32 : 0x%x" %(reg_name, reg_range, wr_data))
    print(" ******************************************************")
    
    Utsspi.write_mod_register32(reg_addr, wr_data)

    time.sleep (0.1)
    
    wr_data = (bdt_on << 3)

    print("\n ******************************************************")
    print(" * DTSS %s %s SPI write_32 : 0x%x" %(reg_name, reg_range, wr_data))
    print(" ******************************************************")
    
    Utsspi.write_mod_register32(reg_addr, wr_data)
    
    time.sleep (1)
    
    # TEST of LVDS_CLK frequency :
    #==============================
    
    # verify  LVDS_CLK is running :
    
    show_seq_core_misc_reg_contents()
    
    seq_core_misc = get_reg_value(bdt_reg_base_addr + REG_BDT_SEQ_MISC)
    lvds_clk_running = (seq_core_misc & 0x80000) >> 19
    
    if lvds_clk_running == 0:
        print("WARNING : lvds_clk is not running")
    
    lvds_clk_reg_value = get_reg_value(bdt_reg_base_addr + REG_BDT_SEQ_LVDS_FREQ)

    if verbose:
        print("\nlvds_clk_reg_value = 0x%x = %d" %(lvds_clk_reg_value, lvds_clk_reg_value))

    lvds_clk_val = float(lvds_clk_reg_value)
    lvds_clk_freq = lvds_clk_val * 1000

    expected_value = 40000000.0

    if lvds_clk_freq > 38000000.0 and lvds_clk_freq < 42000000.0:
        msg = "PASS"
    else:
        msg = "FAIL"
        error_nb += 1

    if msg == "PASS":
        print_ok("lvds_clk_freq  : %5.3fHz  : %s" %(lvds_clk_freq, msg))
#       print_ok("lvds_clk_freq : %5.3fHz : expected_value = %5.3fHz " %(lvds_clk_freq, expected_value), "+/- 5% :", msg)
    else:
        print_error("lvds_clk_freq  : %5.3fHz : expected_value = %5.3fHz : %s" %(lvds_clk_freq, expected_value, msg))

    reg_name = 'DTSS_ON_ALIM'
    reg_addr = DTSS_SPI_ON_ALIM
    reg_range = '(15:0)'

    reg_mask = 0x1ffffff

    wr_data = 0x0

    print("\n ******************************************************")
    print(" * DTSS %s %s SPI write_32 : 0x%x" %(reg_name, reg_range, wr_data))
    print(" ******************************************************")
    
    Utsspi.write_mod_register32(reg_addr, wr_data)

    if error_nb == 0:
        return True
    else:
        return False
#
#*****************************************************************************************
#************** OSB DTSS DMA functionalities *********************************************
#*****************************************************************************************
#
#=========================================================================================
#============== DTSS firmware DMA functionalities ========================================
#=========================================================================================
#
# Following functions/procedure uses an internal register of the DTSS fpga firmware
# This register is not implemented into released DTSS firmware ; it needs a specific DTSS
# debug firmware
#=========================================================================================
#
#***********************************************************
def osbdtss_dma_mode_dbg_check():
#***********************************************************
#
    if is_dtss_fpga_present() == True:
        pass
    else:
        return False

    if (os.path.exists("/dev/uts_spi")):
        side = 0
        slice = DTSS_SLICE
        Utsspi = utsspi.SpiModule(side, slice, "/dev/uts_spi")
    else:
        print("Utsspi driver (/dev/uts_spi) not found")
        return False

    dma_mode_value = Utsspi.read_mod_register32(DTSS_SPI_DMA_DBG)
    print("* DTSS_SPI_DMA_DBG_reg readback value : 0x%x" %dma_mode_value)

    return None
#
#***********************************************************
@DIAG("DTSS DMA mode check")
def t_osbdtss_dma_mode_check(cmd):
#
# This procedure needs a specific DTSS fpga debug firmware
#***********************************************************
#
    osbdtss_dma_mode_check()
    return None
#
#***********************************************************
def osbdtss_dma_mode_dbg_set(OnOff_flag):
#
# This function needs a specific DTSS fpga debug firmware
#***********************************************************
#
    slice = DTSS_SLICE
    side = 0
    Utsspi = utsspi.SpiModule(side, slice, "/dev/uts_spi")

    if OnOff_flag:
        wr_data = 0x80000000
    else:
        wr_data = 0x0

    Utsspi.write_mod_register32(DTSS_SPI_DMA_DBG, wr_data)

    print(" *** Set DTSS dma_mode : DTSS_SPI_DMA_DBG reg. wr value : 0x%x\n" %wr_data)

    dma_mode_value = Utsspi.read_mod_register32(DTSS_SPI_DMA_DBG)
    print("* DTSS_SPI_DMA_DBG_reg readback value : 0x%x" %dma_mode_value)

    return None
#
#***********************************************************
@DIAG("OSB DTSS DMA Debug mode set")
def t_osbdtss_dma_mode_dbg_set(cmd):
#
# This procedure needs a specific DTSS fpga debug firmware
#***********************************************************
#
    try:
        if len(cmd.split()) == 3:
            cmd_lgth = 3
            (command, consigne, verbose_flag) = cmd.split()

            if verbose_flag == "verbose":
                verbose = True
            else:
                print_error("   * Syntax error : 2nd arg is <%s> must be : verbose" %verbose_flag)
                return False
        else:
            cmd_lgth = 2
            (command, consigne) = cmd.split()
            verbose = False

        print_info("* consigne is "+consigne)

    except:
        print_error("   Syntax error : Command must be : t_osbdtss_dma_mode_dbg_set <consigne> <verbose_flag>  ")
        print_error("                                                                                          ")
        print_error("   with               <consigne> is : <OnOff_FLAG>                                        ")
        print_error("                                                                                          ")
        print_error("   where              * <OnOff_FLAG> = ON|OFF                                             ")
        print_error("                      * <verbose_flag> = verbose ONLY                                     ")
        print_error("                        Note : <verbose_flag> is optional                                 ")
        print()
        return False

    arg_error_nb = 0

    OnOff_flag_str = consigne
    if OnOff_flag_str == "ON" or OnOff_flag_str == "OFF":
        if OnOff_flag_str == "ON":
            OnOff_flag = True
        else:
            OnOff_flag = False
        pass
    else:
        arg_error_nb += 1
        print_error("     * Error : OnOff_flag = %s is not a correct value" %OnOff_flag_str)

    if arg_error_nb > 0:
        return False
    else:
        osbdtss_dma_mode_dbg_set(OnOff_flag)

    return None
#
#=========================================================================================
#============== OSB firmware DMA functionalities =========================================
#=========================================================================================
#
#********************************************
def show_dma_dbg_ctrl_contents():
#********************************************
#
    print("\n***---------------------------------------- ")
    print("*** OSB DMA_DBG_CTRL register contents :")
    print("***-----------------------------------------")

    bdt_reg_base_addr = get_pci_bdt_base_addr()

    dbg_ctrl_value = get_reg_value(bdt_reg_base_addr + REG_DMA_DBG_CTRL)
    dma_start    = dbg_ctrl_value & 0x1
    dma_dbg_rstn = (dbg_ctrl_value & 0x2) >> 1

    print("\n* DMA_DBG_CTRL reg. readback value : 0x%x" % dbg_ctrl_value)
    print("     * dma_start (bit0)      = %d" %dma_start)
    print("     * dma_dbg_rstn (bit1)   = %d" %dma_dbg_rstn)

    return None
#********************************************
def show_dma_dbg_status_contents():
#********************************************

    print("\n***------------------------------------ ")
    print("*** DMA_DBG_STATUS register contents :")
    print("***------------------------------------ ")

    bdt_reg_base_addr = get_pci_bdt_base_addr()

    dma_dbg_status_value = get_reg_value(bdt_reg_base_addr + REG_DMA_DBG_STATUS)

    bit_0to15 = dma_dbg_status_value & 0xffff
    bit_16  = (dma_dbg_status_value & 0x10000) >> 16
    bit_17  = (dma_dbg_status_value & 0x20000) >> 17
    bit_18  = (dma_dbg_status_value & 0x40000) >> 18
    bit_19  = (dma_dbg_status_value & 0x80000) >> 19
    
    # bit_20  = (dma_dbg_status_value & 0x100000) >> 20
    # bit_21  = (dma_dbg_status_value & 0x200000) >> 21
    # bit_22  = (dma_dbg_status_value & 0x400000) >> 22
    # bit_23  = (dma_dbg_status_value & 0x800000) >> 23
    
    bit_20to23 = (dma_dbg_status_value & 0xf00000) >> 20
    
    
    bit_24  = (dma_dbg_status_value & 0x1000000) >> 24
    bit_25  = (dma_dbg_status_value & 0x2000000) >> 25
    bit_26  = (dma_dbg_status_value & 0x4000000) >> 26
    bit_27  = (dma_dbg_status_value & 0x8000000) >> 27
    
    bit_28  = (dma_dbg_status_value & 0x10000000) >> 28
    bit_29  = (dma_dbg_status_value & 0x20000000) >> 29
    bit_30  = (dma_dbg_status_value & 0x40000000) >> 30
    bit_31  = (dma_dbg_status_value & 0x80000000) >> 31

    print("\n* Importante note : contents of DMA_DBG_STATUS register depend on DMA_MODE bit")
    print( "                    set into DMA_DBG_CTRL reg.")

    print("\n* DMA_DBG_STATUS readback value : 0x%x" % dma_dbg_status_value)

    print("     * point_cnter value               = 0x%x" %bit_0to15)
    print("     * m_axis_tready_detected (bit16)  = %d" %bit_16)
    print("     * first_data_detected (bit17)     = %d" %bit_17)
    print("     * last_data_detected (bit18)      = %d" %bit_18)
    print("     * unused_bit19                    = %d" %bit_19)
    print("     * acquisition_nb (bit(23:20)      = 0x%x" %bit_20to23)
    # print("     * unused_bit20                    = %d" %bit_20)
    # print("     * unused_bit21                    = %d" %bit_21)
    # print("     * unused_bit22                    = %d" %bit_22)
    # print("     * unused_bit23                    = %d" %bit_23)
    print("     * dma_tfer_running (bit24)        = %d" %bit_24)
    print("     * unused_bit25                    = %d" %bit_25)
    print("     * unused_bit26                    = %d" %bit_26)
    print("     * dma_running_re_detected (bit27) = %d" %bit_27)
    print("     * req_dt (bit28)                  = %d" %bit_28)
    print("     * fifo_rst (bit29)                = %d (active high reset)" %bit_29)
    print("     * lvds_clock_running (bit30)      = %d" %bit_30)
    print("     * dma_rst_pulse_detected (bit31)  = %d" %bit_31)

    return None

#*****************************************************
def show_dma_number_of_points():
#*****************************************************

    print("\n***----------------------------------------- ")
    print("*** DMA_NUMBER_OF_POINTS register content :")
    print("***----------------------------------------- ")

    bdt_reg_base_addr = get_pci_bdt_base_addr()
    dma_pts_nb_value = get_reg_value(bdt_reg_base_addr + REG_DMA_NUMBER_OF_POINTS)
    print("\n* DMA_NUMBER_OF_POINTS reg. read value : 0x%x (%d) word_32" %(dma_pts_nb_value, dma_pts_nb_value))

    return None

#*****************************************************
@DIAG("OSB : DMA points_nb check ")
def t_osb_dma_points_nb_check(cmd):
#
# point_nb = comb_nb * [teeth_nb / (crunch_nb + 1) ]
#
#*****************************************************

    show_dma_number_of_points()
    return None

#********************************************
def osb_dma_dbg_status():
#********************************************

    show_dma_dbg_ctrl_contents()
    show_dma_dbg_status_contents()
    #show_dma_dbg_data_contents()
    show_dma_number_of_points()

    return None

#********************************************
@DIAG("OSB : dma debug function status")
def t_osb_dma_dbg_status(cmd):
#********************************************

    osb_dma_dbg_status()
    return None
#
#********************************************
def osb_dma_mode_set(OnOFF_flag, verbose):
#********************************************
#
    if OnOFF_flag:
        dma_dbg_mode = 1
    else:
        dma_dbg_mode = 0

    bdt_reg_base_addr = get_pci_bdt_base_addr()
    dbg_ctrl_rd = get_reg_value(bdt_reg_base_addr + REG_DMA_DBG_CTRL)

    if verbose:
        show_dma_dbg_ctrl_contents()

    if OnOFF_flag:
        dma_dbg_mode = 1
        dbg_ctrl_wr = dbg_ctrl_rd | (dma_dbg_mode << 2)
        print("\n* write 0x%x into REG_DMA_DBG_CTRL reg. " %dbg_ctrl_wr)
    else:
        dma_dbg_mode = 0
        dbg_ctrl_wr = dbg_ctrl_rd & 0xfffffffb
        print("\n* write 0x%x into REG_DMA_DBG_CTRL reg. " %dbg_ctrl_wr)

    reg_write(bdt_reg_base_addr + REG_DMA_DBG_CTRL, dbg_ctrl_wr)

    if verbose:
        show_dma_dbg_ctrl_contents()

    return None
#
#********************************************
@DIAG("OSB : DMA debug_mode ON/OFF set")
def t_osb_dma_dbg_mode_set(cmd):
#********************************************
#
    try:
        if len(cmd.split()) == 3:
            cmd_lgth = 3
            (command, consigne, verbose_flag) = cmd.split()

            if verbose_flag == "verbose":
                verbose = True
            else:
                print_error("   * Syntax error : 2nd arg is <%s> must be : verbose" %verbose_flag)
                return False
        else:
            cmd_lgth = 2
            (command, consigne) = cmd.split()
            verbose = False

        print_info("* consigne is "+consigne)

    except:
        print_error("   Syntax error : Command must be : t_osb_dma_dbg_mode_set <consigne> <verbose_flag> ")
        print_error("                                                                                     ")
        print_error("   with               <consigne> is : <OnOff_FLAG>                                   ")
        print_error("                                                                                     ")
        print_error("   where              * <OnOff_FLAG> = ON|OFF                                        ")
        print_error("                      * <verbose_flag> = verbose ONLY                                ")
        print_error("                        Note : <verbose_flag> is optional                            ")
        print()
        return False

    arg_error_nb = 0

    OnOff_flag_str = consigne
    if OnOff_flag_str == "ON" or OnOff_flag_str == "OFF":
        if OnOff_flag_str == "ON":
            OnOff_flag = True
        else:
            OnOff_flag = False
    else:
        arg_error_nb += 1
        print_error("     * Error : OnOff_flag_str = %s is not a correct value" %OnOff_flag_str)

    if arg_error_nb > 0:
        return False
    else:
        osb_dma_mode_set(OnOff_flag, verbose)

    return None
#
#*********************************************
def osb_dma_start_set(OnOFF_flag, verbose):
#*********************************************
#
    bdt_reg_base_addr = get_pci_bdt_base_addr()
    dbg_ctrl_rd = get_reg_value(bdt_reg_base_addr + REG_DMA_DBG_CTRL)

    if OnOFF_flag:
        msg = "ON"
    else:
        msg = "OFF"

    if verbose:
        print("\n** show_dma_dbg_ctrl_contents before setting DMA_START %s" %msg)
        show_dma_dbg_ctrl_contents()

    if OnOFF_flag:
        dma_start = 1
        dbg_ctrl_wr = dbg_ctrl_rd | dma_start
    else:
        dma_start = 0
        dbg_ctrl_wr = dbg_ctrl_rd & 0xfffffffe
    
    print("\n* write 0x%x into REG_DMA_DBG_CTRL reg. " %dbg_ctrl_wr)
    reg_write(bdt_reg_base_addr + REG_DMA_DBG_CTRL, dbg_ctrl_wr)

    if verbose:
        print("\n** show_dma_dbg_ctrl_contents after DMA_START %s" %msg)
        show_dma_dbg_ctrl_contents()

    return None
#
#********************************************
@DIAG("OSB : DMA START ON/OFF set")
def t_osb_dma_start_set(cmd):
#********************************************
#
    try:
        if len(cmd.split()) == 3:
            cmd_lgth = 3
            (command, consigne, verbose_flag) = cmd.split()

            if verbose_flag == "verbose":
                verbose = True
            else:
                print_error("   * Syntax error : 2nd arg is <%s> must be : verbose" %verbose_flag)
                return False
        else:
            cmd_lgth = 2
            (command, consigne) = cmd.split()
            verbose = False

        print_info("* consigne is "+consigne)

    except:
        print_error("   Syntax error : Command must be : t_osb_dma_start_set <consigne> <verbose_flag> ")
        print_error("                                                                                  ")
        print_error("   with               <consigne> is : <OnOff_FLAG>                                ")
        print_error("                                                                                  ")
        print_error("   where              * <OnOff_FLAG> = ON|OFF                                     ")
        print_error("                      * <verbose_flag> = verbose ONLY                             ")
        print_error("                        Note : <verbose_flag> is optional                         ")
        print()
        return False

    arg_error_nb = 0

    OnOff_flag_str = consigne
    if OnOff_flag_str == "ON" or OnOff_flag_str == "OFF":
        if OnOff_flag_str == "ON":
            OnOff_flag = True
        else:
            OnOff_flag = False
        pass
    else:
        arg_error_nb += 1
        print_error("     * Error : OnOff_flag = %s is not a correct value" %OnOff_flag_str)

    if arg_error_nb > 0:
        return False
    else:
        osb_dma_start_set(OnOff_flag, verbose)

    return None
#
#***********************************************
@DIAG("OSB : DMA debug start pulse generation")
def t_osb_dma_start_gen(cmd):
#***********************************************
#
    verbose = True

    print()
    osb_dma_start_set(False, verbose)
    osb_dma_start_set(True, verbose)
    
    return None
#
#********************************************
@DIAG("OSB : DMA debug reset generation ")
def t_osb_dma_rst_gen(cmd):
#********************************************
#
    verbose = True

    bdt_reg_base_addr = get_pci_bdt_base_addr()

    dbg_ctrl_rd = get_reg_value(bdt_reg_base_addr + REG_DMA_DBG_CTRL)

    if verbose:
        show_dma_dbg_ctrl_contents()
        
    RESET_OFFSET = 1

    dbg_ctrl_wr = (dbg_ctrl_rd & ~(1 << RESET_OFFSET)) & 0xFF
    print("\n* write 0x%x into REG_DMA_DBG_CTRL reg. " %dbg_ctrl_wr)

    reg_write(bdt_reg_base_addr + REG_DMA_DBG_CTRL, dbg_ctrl_wr)

    if verbose:
        show_dma_dbg_ctrl_contents()

    dbg_ctrl_wr = dbg_ctrl_rd | (1 << RESET_OFFSET)
    print("\n* write 0x%x into REG_DMA_DBG_CTRL reg. " %dbg_ctrl_wr)
    
    reg_write(bdt_reg_base_addr + REG_DMA_DBG_CTRL, dbg_ctrl_wr)

    if verbose:
        dbg_ctrl_rd = get_reg_value(bdt_reg_base_addr + REG_DMA_DBG_CTRL)
        show_dma_dbg_ctrl_contents()

    return None
#
#*********************************************************
@DIAG("OSB : DMA debug flow generation")
def t_osb_dma_flow_gen(cmd):
#*********************************************************
#
    try:
        pass

    except:
        print_error("   Syntax error : Command must be : t_osb_dma_debug ")
        print_error("                                                    ")
        print_error("                                                    ")
        return False

    glu_reg_base_addr = get_glu_base_addr()
    bdt_reg_base_addr = get_pci_bdt_base_addr()

    print("\n==================================")
    print("***** Launch <osb_fpga_ver>")
    print("==================================\n")

    osb_fpga_version = sysfs_read_string("/sys/platform/osb_fpga/fpga_ver")
    print("OSB FPGA version is", osb_fpga_version)

    osb_fpga_synth_date = sysfs_read_string("/sys/platform/osb_fpga/fpga_synt_date")
    print("OSB FPGA synthesis date is", osb_fpga_synth_date)

    print("\n=======================================")
    print("***** Launch <osbdtss_fpga_version>")
    print("=======================================")

    verbose = True
    osbdtss_fpga_version(verbose)

    # t_osb_dma_dbg_status

    print("\n====================================")
    print("*****Launch <osb_dma_dbg_status>")
    print("====================================")

    osb_dma_dbg_status()

    # t_osbdtss_dma_mode_dbg_set ON

    print("\n============================================")
    print("***** Launch <osbdtss_dma_mode_dbg_set OFF>")
    print("============================================")

    OnOff_flag = True
    verbose = True
    print()
    osbdtss_dma_mode_dbg_set(OnOff_flag)

    return None

    print("\n=====================================")
    print("***** Launch <osb_dma_mode_set ON>")
    print("=====================================")

    verbose = True
    osb_dma_mode_set(OnOff_flag, verbose)

    # t_osb_dma_dbg_tfer_set 0x300 0x134C

    # first_data_value = 0x300
    # trfer_lgth = 0x9a6  # 2470

    # print("\n===================================================")
    # print("***** Launch <osb_dma_dbg_tfer_set 0x%x 0x%x>" %(first_data_value, trfer_lgth))
    # print("===================================================")
    # 
    # dbg_data_wr = (trfer_lgth << 16) | first_data_value
    # print("\n\n* write 0x%x into PW_S1_DMA_DBG_DATA reg. " %dbg_data_wr)
    # reg_write(bdt_reg_base_addr + PW_S1_DMA_DBG_DATA, dbg_data_wr)
    # 
    # show_dma_dbg_data_contents()

    # t_osb_dma_data_src_sel EXTERNAL

    # print("\n***** Launch <t_osb_dma_data_src_sel EXTERNAL>")
    # verbose = True
    # DataSrc_type = "EXTERNAL"
    # osb_dma_data_src_sel(DataSrc_type, verbose)

    # t_osb_bdt_status PWSID_S1

    print("\n=========================================")
    print("***** Launch <t_osb_bdt_status>")
    print("=========================================")

    show_seq_core_misc_reg_contents()
    show_bdt_ctrl_reg_contents(SlotSide)
    #show_BDT_SEQ_PLAS_DIAG_contents()

    ## => launch start test before launching dma_start pulse

    input("\n Press Enter to launch DMA_START pulse ")

    print()

    return None
#
#*****************************************
@DIAG("OSB DMA read buffer")
def osb_dma_rd_buffer(addr, size):
#*****************************************
#
    i = 0
    while i < size/2:
        value = get_reg_value(addr + (i*4))
        print("value @ addr 0x%x is 0x%x" %(addr+ (i*4) , value))
        i += 1

    return None
#
#*****************************************
@DIAG("OSB : DMA read_buffer")
def t_osb_dma_rd_buffer(cmd):
#
# sg stands for Scatter Gather
#
#*****************************************
#
    error_flag = False

    try:
        if len(cmd.split(' ')) == 3:
            cmd_lgth = 3
            (command, sg_addr, sg_size) = cmd.split(' ')
        else:
            cmd_lgth = 4
            (command, sg_addr, sg_size, verbose_flag) = cmd.split(' ')

        if cmd_lgth == 4:
            if verbose_flag == "verbose":
                verbose = True
            else:
                print_error("   Syntax error : 3rd arg must be : verbose")
                error_flag = True
        else:
            verbose = False

        if error_flag:
            return False

    except:
        print()
        print_error("   Syntax error : Command must be : t_osb_dma_rd_buffer <sg_start_address> <sg_size_word16>")
        return False

    tfer_lgth = int(sg_size, base=16)
    sg_0_addr = int(sg_addr, base=16)

    print("Read DMA transfer @ sg addr = 0x%x (size = %d word_16)" %(sg_0_addr, tfer_lgth))
    osb_dma_rd_buffer(sg_0_addr, tfer_lgth)

    return None
#
#********************************************************************
def osb_dma_rd_and_compare_buffer(sg_num, addr, size, start_cnter, verbose):
#********************************************************************
#
    err_nb = 0
    invert_flag = False

    if sg_num == 'sg_0':
        sg_offset = 0x0
    elif sg_num == 'sg_1':
        sg_offset = 0x400
    else:
        sg_offset = 0x800

    size32 = size >> 1

    print("\n*================================================================")
    print("* Dump from addr = 0x%x ; dump_size = 0x%x (%d) word_16" %(addr, size, size))
    print("*                                         = 0x%x (%d) word_32" %(size32, size32))
    print("*================================================================")

    exp_value = start_cnter
    cnter_w16_l = start_cnter & 0xffff
    cnter_w16_h = (start_cnter & 0xffff0000) >> 16
    print("cnter_start_value = 0x%x => cnter_w16_h = 0x%x ; cnter_w16_l = 0x%x"\
           %(start_cnter, cnter_w16_h, cnter_w16_l))

    cnter = (cnter_w16_h << 16) | cnter_w16_l
    cnter_inverted = (cnter_w16_l  << 16) | cnter_w16_h

    if verbose:
        print("cnter = 0x%x ; cnter_inverted = 0x%x" %(cnter, cnter_inverted))

    addr_offset = addr & 0xfff
    addr_offset_div4 = addr_offset >> 2
    point_num = (addr_offset_div4 + 1)

    if verbose:
        print("addr_offset = 0x%x (%d)" %(addr_offset, addr_offset))
        print("addr_offset_div4 = 0x%x correspond to point_num = %d" %(addr_offset_div4, point_num))

    i = 0
    while i < size/2:

        #value = get_reg_value_dma(addr + (i*4))
        value = get_reg_value(addr + (i*4))
        if invert_flag:
            exp_value = ((sg_offset+point_num+i) << 16) | cnter_inverted
        else:
            exp_value = cnter + (sg_offset+point_num+i)

        if value == exp_value:
            if verbose:
                print("value @ addr 0x%x is 0x%x" %(addr+ (i*4) , value))
            pass
        else:
            print("error : value @ addr 0x%x is 0x%x : exp. 0x%x" %(addr+ (i*4) , value, exp_value))
            err_nb += 1

        i += 1

    return err_nb
#
#***********************************************
@DIAG("OSB : DMA read and compare buffer test")
def t_osb_dma_compare_buffer_lite(cmd):
#***********************************************
#
    error_flag = False

    try:
        if len(cmd.split(' ')) == 4:
            cmd_lgth = 4
            (command, sg_num, sg_addr,  tfer_type) = cmd.split(' ')
        else:
            cmd_lgth = 5
            (command, sg_num, sg_addr,  tfer_type, verbose_flag) = cmd.split(' ')

        if cmd_lgth == 5:
            if verbose_flag == "verbose":
                verbose = True
            else:
                print_error("   Syntax error : 4th arg must be : verbose")
                error_flag = True
        else:
            verbose = False

        if error_flag:
            return False

    except:
        print()
        print_error("   Syntax error : Command must be : t_osb_dma_compare_buffer_lite <sg_num> <sg_start_address> <tfer_type> ")
        print_error("                  where sg_num is           : sg_0, sg_1, sg_2                                            ")
        print_error("                        sg_start_address is : correspondin sg_num start_address                           ")
        print_error("                        tfer_type is        : MSB_0_VOIE_0, MSB_0_VOIE_1, MSB_1_VOIE_0                    ")
        print_error("                                                                                                          ")
        print_error("                  <verbose_flag> : MUST be verbose ONLY                                                   ")
        print_error("                                   Note : <verbose_flag> is optional                                      ")
        return False

    if sg_num == 'sg_0' or sg_num == 'sg_1' or sg_num == 'sg_2':
        pass
    else:
        print("error : sg_num has not a correct value : MUST be sg_0 or sg_1 or sg_2")
        return False

    sg_addr = int(sg_addr, base=16)

    sg_0_start_cnter = 0x30000000
    sg_1_start_cnter = 0x50000000
    sg_2_start_cnter = 0x70000000

    if tfer_type == 'MSB_0_VOIE_0':
        start_cnter = sg_0_start_cnter
    elif tfer_type == 'MSB_0_VOIE_1':
        start_cnter = sg_1_start_cnter
    elif tfer_type == 'MSB_1_VOIE_0':
        start_cnter = sg_2_start_cnter
    else:
        print("error : tfer_type is not a correct type : MUST be MSB_0_VOIE_0 or MSB_0_VOIE_1 or MSB_1_VOIE_0")
        return False

    sg_start_addr = sg_addr
    sg_size = 0xff
    err_nb_1 = osb_dma_rd_and_compare_buffer(sg_num, sg_start_addr, sg_size, start_cnter, verbose)

    if sg_num == 'sg_2':
        sg_end_addr = sg_addr + 0x680
    else:
        sg_end_addr = sg_addr + 0xff0

    sg_size = 0x8
    err_nb_2 = osb_dma_rd_and_compare_buffer(sg_num, sg_end_addr, sg_size, start_cnter, verbose)

    err_nb = err_nb_1 + err_nb_2

    if err_nb == 0:
        return True
    else:
        return False
# 
#***********************************************
@DIAG("OSB : DMA read and compare buffer")
def t_osb_dma_compare_buffer(cmd):
#***********************************************
#
    error_flag = False

    try:
        if len(cmd.split(' ')) == 5:
            cmd_lgth = 5
            (command, sg_num, sg_addr, sg_size, tfer_type) = cmd.split(' ')
        else:
            cmd_lgth = 6
            (command, sg_num, sg_addr, sg_size, tfer_type, verbose_flag) = cmd.split(' ')

        if cmd_lgth == 6:
            if verbose_flag == "verbose":
                verbose = True
            else:
                print_error("   Syntax error : 5th arg must be : verbose")
                error_flag = True
        else:
            verbose = False

        if error_flag:
            return False

    except:
        print()
        print_error("   Syntax error : Command must be : t_osb_dma_compare_buffer <sg_num> <sg_start_address> <sg_size> <tfer_type>")
        print_error("                  where sg_num is    : sg_0, sg_1, sg_2                                                       ")
        print_error("                        sg_size is   : size in word16 number to test (i.e 0x7ff word16 for sg_size_max)       ")
        print_error("                        tfer_type is : MSB_0_VOIE_0, MSB_0_VOIE_1, MSB_1_VOIE_0                               ")

        return False

    sg_size = int(sg_size, base=16)
    sg_addr = int(sg_addr, base=16)

    if sg_num == 'sg_0' or sg_num == 'sg_1' or sg_num == 'sg_2':
        pass
    else:
        print("error : sg_num has not a correct value : MUST be sg_0 or sg_1 or sg_2")
        return False

    sg_0_start_cnter = 0x30000000
    sg_1_start_cnter = 0x50000000
    sg_2_start_cnter = 0x70000000

    if tfer_type == 'MSB_0_VOIE_0':
        start_cnter = sg_0_start_cnter
    elif tfer_type == 'MSB_0_VOIE_1':
        start_cnter = sg_1_start_cnter
    elif tfer_type == 'MSB_1_VOIE_0':
        start_cnter = sg_2_start_cnter
    else:
        print("error : tfer_type is not a correct type : MUST be MSB_0_VOIE_0 or MSB_0_VOIE_1 or MSB_1_VOIE_0")
        return False


    err_nb = osb_dma_rd_and_compare_buffer(sg_num, sg_addr, sg_size, start_cnter, verbose)

    if err_nb == 0:
        return True
    else:
        return False
#
#*****************************************
@DIAG("OSB DMA clear buffer")
def osb_dma_clear_buffer(addr, size):
#*****************************************
#
    data_value = 0x0
    i = 0
    while i < size/2:
        reg_write(addr + (i*4), data_value)
        print("clear value @ addr 0x%x" %(addr+ (i*4)))

        i += 1

    return None
#
#*****************************************
@DIAG("OSB : DMA clear buffer")
def t_osb_dma_clear_buffer(cmd):
#
# sg stands for Scatter Gather
#*****************************************
#
    error_flag = False

    try:
        if len(cmd.split(' ')) == 3:
            cmd_lgth = 3
            (command, sg_addr, sg_size) = cmd.split(' ')
        else:
            cmd_lgth = 4
            (command, sg_addr, sg_size, verbose_flag) = cmd.split(' ')

        if cmd_lgth == 4:
            if verbose_flag == "verbose":
                verbose = True
            else:
                print_error("   Syntax error : 2nd arg must be : verbose")
                error_flag = True
        else:
            verbose = False

        if error_flag:
            return False

    except:
        print()
        print_error("   Syntax error : Command must be : t_osb_dma_clear_buffer <sg_start_address> <sg_size_word_16>")
        return False

    tfer_lgth = int(sg_size, base=16)
    sg_addr = int(sg_addr, base=16)

    print("Clear @ sg addr = 0x%x (size = %d word_16)" %(sg_addr, tfer_lgth))
    osb_dma_clear_buffer(sg_addr, tfer_lgth)

    return None
#
#*********************************************************
@DIAG("OSB : DMA size")
def t_osb_dma_size(cmd):
#*********************************************************
#
    try:
        (command, size_value_str) = cmd.split(' ')

    except:
        print()
        print_error("   Syntax error : Command must be : t_osb_size <acq_point_nb in decimal>")
        print_error("                  knowing that one acq_point is coding in word_16       ")
        return False

    size_value = int(size_value_str)

    print("* size_value in word32 = %d => 0x%x" %(size_value, size_value))
    
    size_value_byte = size_value*4
    print("  => size_value in Byte = %d => 0x%x" %(size_value_byte*4, size_value_byte*4))
    
    block_1kByte_nb_need = (size_value_byte >> 10) + 1

    print("* block_1kB number need = %d " %block_1kByte_nb_need)

    return None

