from viavi.evm import *
from viavi.diag import *
import os
import subprocess
import smbus
from time import time, sleep
from datetime import datetime

@DIAG("Test PCIe")
def t_cpb_pcie(cmd):

    npcied = 0
    if(os.path.isdir("/sys/bus/pci/devices/0000:00:00.0")):
        vendor = sysfs_read_string("/sys/bus/pci/devices/0000:00:00.0/vendor")
        device = sysfs_read_string("/sys/bus/pci/devices/0000:00:00.0/device")
        print_info("# iMX8 PCIe root complex 0: %s %s"%(vendor,device))
        npcied = npcied + 1
    else:
        print_error("# iMX8 PCIe root complex 0 not detected")

    if(os.path.isdir("/sys/bus/pci/devices/0001:00:00.0")):
        vendor = sysfs_read_string("/sys/bus/pci/devices/0001:00:00.0/vendor")
        device = sysfs_read_string("/sys/bus/pci/devices/0001:00:00.0/device")
        print_info("# iMX8 PCIe root complex 1: %s %s"%(vendor,device))
        npcied = npcied + 1
    else:
        print_error("# iMX8 PCIe root complex 1 not detected")

    if(os.path.isdir("/sys/bus/pci/devices/0000:01:00.0")):
        vendor = sysfs_read_string("/sys/bus/pci/devices/0000:01:00.0/vendor")
        device = sysfs_read_string("/sys/bus/pci/devices/0000:01:00.0/device")
        print_info("# PEX8606 Upstream port detected: %s %s"%(vendor,device))
        npcied = npcied + 1
    else:
        print_error("# PEX8606 Upstream port not detected")

    if(os.path.isdir("/sys/bus/pci/devices/0000:02:01.0")):
        vendor = sysfs_read_string("/sys/bus/pci/devices/0000:02:01.0/vendor")
        device = sysfs_read_string("/sys/bus/pci/devices/0000:02:01.0/device")
        print_info("# PEX8605 Downstream port 1 detected: %s %s"%(vendor,device))
        npcied = npcied + 1
    else:
        print_error("# PEX8605 Downstream port 1 not detected")

    if(os.path.isdir("/sys/bus/pci/devices/0000:02:04.0")):
        vendor = sysfs_read_string("/sys/bus/pci/devices/0000:02:04.0/vendor")
        device = sysfs_read_string("/sys/bus/pci/devices/0000:02:04.0/device")
        print_info("# PEX8605 Downstream port 2 detected: %s %s"%(vendor,device))
        npcied = npcied + 1
    else:
        print_error("# PEX8605 Downstream port 2 not detected")

    if(os.path.isdir("/sys/bus/pci/devices/0000:02:05.0")):
        vendor = sysfs_read_string("/sys/bus/pci/devices/0000:02:05.0/vendor")
        device = sysfs_read_string("/sys/bus/pci/devices/0000:02:05.0/device")
        print_info("# PEX8605 Downstream port 3 detected: %s %s"%(vendor,device))
        npcied = npcied + 1
    else:
        print_error("# PEX8605 Downstream port 3 not detected")

    if(os.path.isdir("/sys/bus/pci/devices/0000:02:07.0")):
        vendor = sysfs_read_string("/sys/bus/pci/devices/0000:02:07.0/vendor")
        device = sysfs_read_string("/sys/bus/pci/devices/0000:02:07.0/device")
        print_info("# PEX8605 Downstream port 4 detected: %s %s"%(vendor,device))
        npcied = npcied + 1
    else:
        print_error("# PEX8605 Downstream port 4 not detected")

    if(os.path.isdir("/sys/bus/pci/devices/0000:02:09.0")):
        vendor = sysfs_read_string("/sys/bus/pci/devices/0000:02:09.0/vendor")
        device = sysfs_read_string("/sys/bus/pci/devices/0000:02:09.0/device")
        print_info("# PEX8605 Downstream port 5 detected: %s %s"%(vendor,device))
        npcied = npcied + 1
    else:
        print_error("# PEX8605 Downstream port 5 not detected")

    if(os.path.isdir("/sys/bus/pci/devices/0000:04:00.0")):
        vendor = sysfs_read_string("/sys/bus/pci/devices/0000:04:00.0/vendor")
        device = sysfs_read_string("/sys/bus/pci/devices/0000:04:00.0/device")
        print_info("# ALTERA FPGA detected: %s %s"%(vendor,device))
        npcied = npcied + 1
    else:
        print_error("# ALTERA FPGA not detected")

    if(os.path.isdir("/sys/bus/pci/devices/0000:06:00.0")):
        vendor = sysfs_read_string("/sys/bus/pci/devices/0000:06:00.0/vendor")
        device = sysfs_read_string("/sys/bus/pci/devices/0000:06:00.0/device")
        print_info("# OSB FPGA detected: %s %s"%(vendor,device))
        npcied = npcied + 1
    else:
        print_error("# OSB FPGA not detected")

    if(npcied==10):
        print_ok("# PCIe: 10 devices detected")
        return True
    else:
        print_error("# PCIe only %d/10 devices detected"%(npcied))
        return False


@DIAG("Test USB")
def t_cpb_usb(cmd):

    nbusb = 0
    if(os.path.isdir("/sys/bus/usb/devices/3-1.1")):
        mfg = sysfs_read_string("/sys/bus/usb/devices/3-1.1/idVendor")
        prod = sysfs_read_string("/sys/bus/usb/devices/3-1.1/idProduct")
        print_info("# CPB USB HUB 2514: %s %s"%(mfg,prod))
        nbusb = nbusb + 1
    else:
        print_error("# CPB USB HUB 2514 not detected")

    if(os.path.isdir("/sys/bus/usb/devices/3-1.1.1")):
        mfg = sysfs_read_string("/sys/bus/usb/devices/3-1.1.1/idVendor")
        prod = sysfs_read_string("/sys/bus/usb/devices/3-1.1.1/idProduct")
        print_info("# B200 FT232 USB-UART Bridge: %s %s"%(mfg,prod))
        nbusb = nbusb + 1
    else:
        print_error("# B200 FT232 USB-UART Bridge not detected")

    if(os.path.isdir("/sys/bus/usb/devices/3-1.1.4")):
        mfg = sysfs_read_string("/sys/bus/usb/devices/3-1.1.4/idVendor")
        prod = sysfs_read_string("/sys/bus/usb/devices/3-1.1.4/idProduct")
        print_info("# B200 FT232 USB-UART Bridge: %s %s"%(mfg,prod))
        nbusb = nbusb + 1
    else:
        print_error("# B200 FT232 USB-UART Bridge not detected")

    if(os.path.isdir("/sys/bus/usb/devices/3-1.2")):
        mfg = sysfs_read_string("/sys/bus/usb/devices/3-1.2/idVendor")
        prod = sysfs_read_string("/sys/bus/usb/devices/3-1.2/idProduct")
        print_info("# USB J7 on B200: %s %s"%(mfg,prod))
        nbusb = nbusb + 1
    else:
        print_error("# USB J7 on B200 not detected")

    if(os.path.isdir("/sys/bus/usb/devices/3-1.3")):
        mfg = sysfs_read_string("/sys/bus/usb/devices/3-1.3/idVendor")
        prod = sysfs_read_string("/sys/bus/usb/devices/3-1.3/idProduct")
        print_info("# USB A CPB FRONT PANEL: %s %s"%(mfg,prod))
        nbusb = nbusb + 1
    else:
        print_error("# USB A CPB FRONT PANEL not detected")

    if(os.path.isdir("/sys/bus/usb/devices/3-1.4")):
        mfg = sysfs_read_string("/sys/bus/usb/devices/3-1.4/idVendor")
        prod = sysfs_read_string("/sys/bus/usb/devices/3-1.4/idProduct")
        print_info("# USB J17 on B200: %s %s"%(mfg,prod))
        nbusb = nbusb + 1
    else:
        print_error("# USB J17 on B200 not detected")


    if(os.path.isdir("/sys/bus/usb/devices/1-1")):
        mfg = sysfs_read_string("/sys/bus/usb/devices/1-1/idVendor")
        prod = sysfs_read_string("/sys/bus/usb/devices/1-1/idProduct")
        print_info("# USB C FRONT PANEL: %s %s"%(mfg,prod))
        nbusb = nbusb + 1
    else:
        print_error("# USB C FRONT PANEL not detected")

    if(nbusb==7):
        print_ok("# USB: 7 devices detected")
        return True
    else:
        print_error("# USB only %d/7 devices detected"%(nbusb))
        return False


@DIAG("Test PCIe for HW loopback for SlotB, M1 and M2 interfaces on B200")
def t_cpb_pcie_loopback(cmd):

   p = subprocess.Popen("lspci -vv", shell=True, stdin=subprocess.PIPE,
                         stdout=subprocess.PIPE, stderr=subprocess.STDOUT, close_fds=True)
   p.wait()
   err = p.returncode
   #print(err)
   start = 0
   res = 0

   lines = p.stdout.readlines()
   for l in lines:
       l = l.decode("utf-8").strip()
       if l:
           #print_info("# %s" % (l))
           columns = [item.strip() for item in l.split(':')]
           columns1 = [item.strip() for item in l.split(' ')]
           #print_info("## %s" % (columns1[0]))
           if ((columns[0] == "0000") and start == 1):
               #print_info("#### res= %s"%(res))
               if res != 3:
                   print_info("# Error with slot %s"%(slot))
                   err = err + 1
               else:
                   print_info("# Link and training OK for slot %s" % (slot))
               #print_info("# Stop")
               start = 0
               res = 0
           if ((columns[0] == "0000") and (columns[1] == "02") and start == 0 and (columns[2] == "01.0 PCI bridge" or columns[2] == "05.0 PCI bridge" or columns[2] == "09.0 PCI bridge") ):
               #print_info("## %s" % (l))
               start = 1
               slot = "Unknown"
               if columns[2] == "01.0 PCI bridge":
                   slot = "M1"
               if columns[2] == "05.0 PCI bridge":
                   slot = "M2"
               if columns[2] == "09.0 PCI bridge":
                   slot = "2K slot B"
           if (("Train+" in l) and start == 1):
               #print_info("# %s" % (l))
               res = res + 1
           if (("PresDet+" in l) and start == 1):
               #print_info("# %s" % (l))
               res = res + 1

   if err == 0 :
       return True
   else:
       return False


@DIAG("Check if i2c CPB eeprom is present")
def t_cpb_i2c(cmd):
    try:
        (command, Hetnet_Module) = cmd.split()
    except:
        print_error("# Command must be: t_cpb_i2c 0/1/2")

    p = subprocess.Popen("sicutil -r -sys %s"%(Hetnet_Module) , shell=True, stdin=subprocess.PIPE,
                             stdout=subprocess.PIPE, stderr=subprocess.STDOUT, close_fds=True)
    p.wait()
    err = p.returncode
    lines = p.stdout.readlines()
    # print(l)
    if err:
        for l in lines:
            l = l.decode("utf-8").strip()
            if l:
                print_info("# %s" % (l))
                columns = [item.strip() for item in l.split(':')]
        return False
    else:
        return True


@DIAG("Check if i2c module eeprom is present at 0x50/0x51")
def t_cpb_i2c_2k(cmd):
    try:
        (command) = cmd.split()
    except:
        print_error("# Command must be: t_cpb_i2c_2k")

    f = open("/sys/platform/uts_scan/i2c_master_pw", "r")
    i2c_bus_pw = f.readline()
    f.close()
    i2c_bus_pw = int(i2c_bus_pw)
    print(i2c_bus_pw)
    if i2c_bus_pw <= 0:
        print("Bad i2c_bus detected %d in /sys/platform/uts_scan/i2c_master_pw" % (i2c_bus_pw))
        return False
    eeprom = smbus.SMBus(i2c_bus_pw)
    address = 0x50
    try:
        val = eeprom.read_i2c_block_data(address, 0, 4)
        print("PW SIDE EEPROM detected")
    except:
        print("PW SIDE EEPROM Not detected")
        return False


    f = open("/sys/platform/uts_scan/i2c_master_op", "r")
    i2c_bus_op = f.readline()
    f.close()
    i2c_bus_op = int(i2c_bus_op)
    print(i2c_bus_op)
    if i2c_bus_op <= 0:
        print("Bad i2c_bus detected %d in /sys/platform/uts_scan/i2c_master_op" % (i2c_bus_op))
        return False
    eeprom = smbus.SMBus(i2c_bus_op)
    address = 0x51
    try:
        val = eeprom.read_i2c_block_data(address, 0, 4)
        print("OP SIDE EEPROM detected")
        return True
    except:
        print("OP SIDE EEPROM Not detected")
        return False



@DIAG("Check if CPB FPGA is programmed (DONE should be high)")
def t_cpb_fpga_done(cmd):
    try:
        (command) = cmd.split()
    except:
        print_error("# Command must be: t_cpb_fpga_done ")

    res = 0
    f = open(os.open("/tmp/diag_fpga_done",os.O_CREAT | os.O_WRONLY, 0o777), "w")
    f.write('#!/bin/bash\n')
    f.write('PATH_TO_GPIO=$(grep -l gpio@22 /sys/class/gpio/gpiochip*/device/uevent | head -n 1)\n')
    f.write('[ "$PATH_TO_GPIO" == "" ] && exit 1\n')
    f.write('PATH_TO_GPIO=$(dirname "${PATH_TO_GPIO}")\n')
    f.write('cd "$PATH_TO_GPIO" || exit 1\n')
    f.write('cd ..\n')
    f.write('BASE_GPIO=$(cat base)\n')
    f.write('GPIO_PROGRAM_FPGA=$((BASE_GPIO + 15 ))\n')
    f.write('if [ ! -d "/sys/class/gpio/gpio${GPIO_PROGRAM_FPGA}" ] ; then\n')
    f.write('    echo "$GPIO_PROGRAM_FPGA" > /sys/class/gpio/export\n')
    f.write('fi\n')
    f.write('echo in > /sys/class/gpio/gpio${GPIO_PROGRAM_FPGA}/direction\n')
    f.write('DONE=$(cat /sys/class/gpio/gpio${GPIO_PROGRAM_FPGA}/value)\n')
    f.write('[ "$DONE" != "1" ] && exit 1\n')
    f.write('exit 0\n')
    f.close()

    p = subprocess.Popen("/tmp/diag_fpga_done", shell=True, stdin=subprocess.PIPE, stdout=subprocess.PIPE,
                         stderr=subprocess.STDOUT, close_fds=True)
    p.wait()
    err = p.returncode
    lines = p.stdout.readlines()
    for l in lines:
        l = l.decode("utf-8").strip()
        if l:
            print_info("# %s" % (l))
    return err == 0



@DIAG("Ping Ethernet test on CPB ETH0 ethernet interface")
def t_cpb_eth(cmd):
    try:
        (command, hostname_to_ping) = cmd.split()
    except:
        print_error("# Command must be: t_cpb_eth  hostname_to_ping")

    # hostname = "10.33.17.16"
    print("ping -I eth0 -c 1 %s"%(hostname_to_ping))
    response = os.system("ping -I eth0 -c 1 %s"%(hostname_to_ping))
    # and then check the response...
    if response == 0:
        pingstatus = "Network Active"
        print(pingstatus)
        return True
    else:
        pingstatus = "Network Error"
        print(pingstatus)
        return False

def GetSPIDEV(module):
    import re
    p = subprocess.Popen("ls -l /sys/class/spidev | grep %s"%(module), shell=True,
                         stdin=subprocess.PIPE, stdout=subprocess.PIPE, stderr=subprocess.STDOUT, close_fds=True)
    p.wait()
    err = p.returncode
    #print("Err=%d" %(err))

    if (err ==0):
        lines = p.stdout.readlines()
        for l in lines:
            l = l.decode("utf-8").strip()
            if l:
                #print_info("# %s" % (l))
                m = re.search(r"spidev\w+",l)
                spidev = "/dev/" + m.group() + ".0"
                #print_info("### %s" % (spidev))
                return spidev
    else:
        return "spidev_unknown"


def SPI_Xfer(spidev, val):

    print_info("# SPIdev : %s" % (spidev))
    cmd = "spidev-test -D %s -b 8 -p '%s' -v" % (spidev,val)
    print_info("# SPI Transfer command line : %s" % (cmd))
    if (spidev != "spidev_unknown"):
        p = subprocess.Popen(cmd, shell=True,
                             stdin=subprocess.PIPE, stdout=subprocess.PIPE, stderr=subprocess.STDOUT, close_fds=True)
        p.wait()
        err = p.returncode
        #print("Err=%d" % (err))

        if (err == 0):
            lines = p.stdout.readlines()
            for l in lines:
                l = l.decode("utf-8").strip()
                if l:
                    print_info("# %s" % (l))
                    columns = [item.strip() for item in l.split(' ')]
                    #print_info("# %s" % (columns[1]))
                    if columns[0] == "RX":
                        #print_info("#RX# %s" % (columns[2]))
                        return (int(columns[2],16))

    else:
        print_error("Unknown spidev")

    return -1


@DIAG("Test SPI M1& M2 interfaces")
def t_cpb_spi(cmd):
    try:
        (command, Hetnet_Module) = cmd.split()
    except:
        print_error("# Command must be: t_cpb_spi 1/2")

    spidev = "spidev_unknown"

    if (Hetnet_Module == "1"):
        print_info("Checking SPI M1")
        spidev = GetSPIDEV("ale_mod1_spi")

    if (Hetnet_Module == "2"):
        print_info("Checking SPI M2")
        spidev = GetSPIDEV("ale_mod2_spi")

    # transfer should be done twice in order to shift the eight bit ShiftRegister of B200 FPGA
    res = SPI_Xfer(spidev, "U")
    res = SPI_Xfer(spidev, "U")
    print_info("## SPI Read; 0x%x"%(res))
    try:
        answer = chr(res)
        print_info("## SPI Read; 0x%x - %s" % (res,answer))
        if (answer != "U"):
            return False
        else:
            return True
    except:
        return False

@DIAG("Test PCIe clocks frequency")
### TBCOMPLETED - DONE on OSB side
def t_cpb_clkpcie(cmd):
    try:
        (command, Hetnet_Module) = cmd.split()
    except:
        print_error("# Command must be: t_cpb_clkpcie 1/2/B")

    if (Hetnet_Module == "B"):
        print("Checking PCIe clock frequency for SLOTB")
        return True

    if (Hetnet_Module == "1"):
        print("Checking PCIe clock frequency for M1")
        return True

    if (Hetnet_Module == "2"):
        print("Checking PCIe clock frequency for M2")
        return True

    print_error("# Command must be: t_cpb_clkpcie 1/2/B")
    return False

@DIAG("Test pwr sync signal frequency")
### TBCOMPLETED - DONE on OSB side
def t_cpb_pwrsync(cmd):
    try:
        (command, Hetnet_Module) = cmd.split()
    except:
        print_error("# Command must be: t_cpb_pwrsync 1/2/B")

    if (Hetnet_Module == "B"):
        print("Checking power sync. signal frequency for SLOTB")
        return True

    if (Hetnet_Module == "1"):
        print("Checking power sync. signal frequency for M1")
        return True

    if (Hetnet_Module == "2"):
        print("Checking power sync. signal frequency for M2")
        return True

    print_error("# Command must be: t_cpb_pwrsync 1/2/B")
    return False

@DIAG("Check if HD is present on the correct PCI slot")
def t_cpb_check_hd(cmd):
    try:
        (command) = cmd.split()
    except:
        print_error("# Command must be: t_cpb_check_hd")

    pci_hd_slot = "0001:01:00.0"

    p = subprocess.Popen("lspci  -s %s" % (pci_hd_slot), shell=True, stdin=subprocess.PIPE,
                         stdout=subprocess.PIPE, stderr=subprocess.STDOUT, close_fds=True)
    p.wait();
    err = p.returncode;
    lines = p.stdout.readlines()
    for l in lines:
        l = l.decode("utf-8").strip()
        if l:
            print_info("# %s" % (l))
            columns = [item.strip() for item in l.split(' ')]
            if (columns[0] == pci_hd_slot):
                return True
            print_info("## %s" % (columns))
            print_info("### %s" % (columns[0]))

    return False

 ########################################################################
 #
 #    CPB I2C EEPROM initialisation
 #
 ########################################################################
@DIAG("CPB sicutil init")
def t_cpb_sicutil_init(cmd):
    try:
        (command) = cmd.split()
    except:
        print_error("# Command must be: t_cpb_sicutil_init ")
        return False
    fab_date = datetime.today().strftime('%Y%m%d')
    err = 0
    Hetnet_Module = "0"
    p = subprocess.Popen("sicutil -w -sys %s  HardwareSetName CPB" % (Hetnet_Module), shell=True,
                         stdin=subprocess.PIPE, stdout=subprocess.PIPE, stderr=subprocess.STDOUT, close_fds=True)
    p.wait();
    err += p.returncode;
    print(".", end='', flush=True)
    p = subprocess.Popen("sicutil -w -sys %s  HardwareSetId 703100B11-001" % (Hetnet_Module), shell=True,
                         stdin=subprocess.PIPE, stdout=subprocess.PIPE, stderr=subprocess.STDOUT, close_fds=True)
    p.wait();
    err += p.returncode;
    print(".", end='', flush=True)
    p = subprocess.Popen("sicutil -w -sys %s  Revision 2" % (Hetnet_Module), shell=True, stdin=subprocess.PIPE,
                         stdout=subprocess.PIPE, stderr=subprocess.STDOUT, close_fds=True)
    p.wait();
    err += p.returncode;
    print(".", end='', flush=True)
    p = subprocess.Popen("sicutil -w -sys %s  SerialNumber EBAP00001" % (Hetnet_Module), shell=True, stdin=subprocess.PIPE,
                         stdout=subprocess.PIPE, stderr=subprocess.STDOUT, close_fds=True)
    p.wait();
    err += p.returncode;
    print(".", end='', flush=True)
    p = subprocess.Popen("sicutil -w -sys %s  ManufactureDate %s" % (Hetnet_Module, fab_date), shell=True,
                         stdin=subprocess.PIPE, stdout=subprocess.PIPE, stderr=subprocess.STDOUT, close_fds=True)
    p.wait();
    err += p.returncode;
    print(".", end='', flush=True)
    p = subprocess.Popen("sicutil -w -sys %s  CalibrationDate 20000101" % (Hetnet_Module), shell=True,
                         stdin=subprocess.PIPE, stdout=subprocess.PIPE, stderr=subprocess.STDOUT, close_fds=True)
    p.wait();
    err += p.returncode;
    print(".", end='', flush=True)
    p = subprocess.Popen("sicutil -w -sys %s  MinimumPower 6" % (Hetnet_Module), shell=True, stdin=subprocess.PIPE,
                         stdout=subprocess.PIPE, stderr=subprocess.STDOUT, close_fds=True)
    p.wait();
    err += p.returncode;
    print(".", end='', flush=True)
    p = subprocess.Popen("sicutil -w -sys %s  CriticalTemp 85" % (Hetnet_Module), shell=True, stdin=subprocess.PIPE,
                         stdout=subprocess.PIPE, stderr=subprocess.STDOUT, close_fds=True)
    p.wait();
    err += p.returncode;
    print(".", end='', flush=True)
    p = subprocess.Popen("sicutil -w -sys %s  PcieEndpoints 3" % (Hetnet_Module), shell=True, stdin=subprocess.PIPE,
                         stdout=subprocess.PIPE, stderr=subprocess.STDOUT, close_fds=True)
    p.wait();
    err += p.returncode;
    print(".", end='', flush=True)
    p = subprocess.Popen("sicutil -w -sys %s  ParentSerialNumber none" % (Hetnet_Module), shell=True,
                         stdin=subprocess.PIPE, stdout=subprocess.PIPE, stderr=subprocess.STDOUT, close_fds=True)
    p.wait();
    err += p.returncode;
    print(".", end='', flush=True)

    p = subprocess.Popen("sicutil -w -sol %s  ProductName FTH-9000" % (Hetnet_Module), shell=True,
                         stdin=subprocess.PIPE, stdout=subprocess.PIPE, stderr=subprocess.STDOUT, close_fds=True)
    p.wait();
    err += p.returncode;
    print(".", end='', flush=True)


    p = subprocess.Popen("sicutil -r -sys %s" % (Hetnet_Module), shell=True, stdin=subprocess.PIPE,
                         stdout=subprocess.PIPE, stderr=subprocess.STDOUT, close_fds=True)
    p.wait();
    err += p.returncode;
    print(".", flush=True)
    lines = p.stdout.readlines()
    for l in lines:
        l = l.decode("utf-8").strip()
        if l:
            print_info("# %s" % (l))
            columns = [item.strip() for item in l.split(':')]

    p = subprocess.Popen("sicutil -r -sol %s" % (Hetnet_Module), shell=True, stdin=subprocess.PIPE,
                         stdout=subprocess.PIPE, stderr=subprocess.STDOUT, close_fds=True)
    p.wait();
    err += p.returncode;
    print(".", flush=True)
    lines = p.stdout.readlines()
    for l in lines:
        l = l.decode("utf-8").strip()
        if l:
            print_info("# %s" % (l))
            columns = [item.strip() for item in l.split(':')]

    return err == 11


@DIAG("CPB sicutil read")
def t_cpb_sicutil_r(cmd):
    try:
        (command, field) = cmd.split()
    except:
        print_error("# Command must be: t_cpb_sicutil_r field/'all'")
        return False
    Hetnet_Module = "0"
    if (field == "all"):
        p = subprocess.Popen("sicutil -r -sys %s" % (Hetnet_Module), shell=True, stdin=subprocess.PIPE,
                             stdout=subprocess.PIPE, stderr=subprocess.STDOUT, close_fds=True)
    else:
        print(field)
        p = subprocess.Popen("sicutil -r -sys %s %s" % (Hetnet_Module, field), shell=True, stdin=subprocess.PIPE,
                             stdout=subprocess.PIPE, stderr=subprocess.STDOUT, close_fds=True)
    p.wait()
    err = p.returncode
    lines = p.stdout.readlines()
    for l in lines:
        l = l.decode("utf-8").strip()
        if l:
            print_info("# %s" % (l))
            columns = [item.strip() for item in l.split(':')]
    # print(l)
    if l:
        return True
    else:
        return False


@DIAG("CPB sicutil write")
def t_cpb_sicutil_w(cmd):
    try:
        (command, field, field_value) = cmd.split()
    except:
        print_error("# Command must be: t_cpb_sicutil_w field field_value")
        print_error(
            "# Possible field are: # HardwareSetName  # HardwareSetId # Revision # SerialNumber # ManufactureDate # CalibrationDate # MinimumPower # CriticalTemp # PcieEndpoints # ParentSerialNumber")
        return False
    print(field)
    Hetnet_Module = "0"

    p = subprocess.Popen("sicutil -w -sys %s %s %s" % (Hetnet_Module, field, field_value), shell=True,
                         stdin=subprocess.PIPE, stdout=subprocess.PIPE, stderr=subprocess.STDOUT, close_fds=True)
    p.wait()
    err = p.returncode
    print(err)
    lines = p.stdout.readlines()
    for l in lines:
        l = l.decode("utf-8").strip()
        if l:
            print_info("# %s" % (l))
            columns = [item.strip() for item in l.split(':')]
            return False
    return True


@DIAG("CPB sicutil solution read")
def t_cpb_sicutil_sol_r(cmd):
    try:
        (command, field) = cmd.split()
    except:
        print_error("# Command must be: t_cpb_sicutil_sol_r field/'all'")
        return False

    Hetnet_Module = "0"
    if (field == "all"):
        p = subprocess.Popen("sicutil -r -sol %s" % (Hetnet_Module), shell=True, stdin=subprocess.PIPE,
                             stdout=subprocess.PIPE, stderr=subprocess.STDOUT, close_fds=True)
    else:
        print(field)
        p = subprocess.Popen("sicutil -r -sol %s %s" % (Hetnet_Module, field), shell=True, stdin=subprocess.PIPE,
                             stdout=subprocess.PIPE, stderr=subprocess.STDOUT, close_fds=True)
    p.wait()
    err = p.returncode
    lines = p.stdout.readlines()
    for l in lines:
        l = l.decode("utf-8").strip()
        if l:
            print_info("# %s" % (l))
            columns = [item.strip() for item in l.split(':')]
    # print(l)
    if l:
        return True
    else:
        return False


@DIAG("CPB sicutil solution partition write")
def t_cpb_sicutil_sol_w(cmd):
    try:
        (command, field, field_value) = cmd.split()
    except:
        print_error("# Command must be: t_cpb_sicutil_sol_w field field_value")
        print_error(
            "# Possible field are: # ProductName # OTH_Fan_Presence # OTH_Prod_Parameter_[0-9] # OTH_Prod ")
        return False
    print(field)
    Hetnet_Module = "0"
    p = subprocess.Popen("sicutil -w -sol %s %s %s" % (Hetnet_Module, field, field_value), shell=True,
                         stdin=subprocess.PIPE, stdout=subprocess.PIPE, stderr=subprocess.STDOUT, close_fds=True)
    p.wait()
    err = p.returncode
    print(err)
    lines = p.stdout.readlines()
    for l in lines:
        l = l.decode("utf-8").strip()
        if l:
            print_info("# %s" % (l))
            columns = [item.strip() for item in l.split(':')]
            return False
    return True




def Write_Hamma_Register(section, port, value, verbose=0):
    p = subprocess.Popen("hamma action.write port.%s.%s value.%d" % (section, port, value), shell=True,
                         stdin=subprocess.PIPE, stdout=subprocess.PIPE, stderr=subprocess.STDOUT, close_fds=True)
    p.wait()
    err = p.returncode
    #print(err)
    lines = p.stdout.readlines()
    for l in lines:
        l = l.decode("utf-8").strip()
        if l:
            if verbose != 0:
                print_info("# %s" % (l))
                columns = [item.strip() for item in l.split(':')]

def Read_Hamma_Register(section, port, verbose=0):
    p = subprocess.Popen("hamma action.read port.%s.%s" % (section, port), shell=True,
                         stdin=subprocess.PIPE, stdout=subprocess.PIPE, stderr=subprocess.STDOUT, close_fds=True)
    p.wait()
    err = p.returncode
    #print("Err=%d" %(err))

    if (err == 0):
        lines = p.stdout.readlines()
        for l in lines:
            l = l.decode("utf-8").strip()
            if l:
                if verbose != 0:
                    print_info("# %s" % (l))
                columns = [item.strip() for item in l.split(' ')]
                #print_info(("## %s")%columns[3])

        return int(columns[3], base=16)
    else:
        print_info("Can't read port.%s.%s" % (section, port))
        return -1


@DIAG("CPB 2K loopback test using B200")
def t_cpb_loopback_2k(cmd):
    debug = "0"
    try:
        try:
            (command, loopback) = cmd.split()
        except:
            (command, loopback, debug) = cmd.split()
    except:
        print_error("# Command must be: t_cpb_loopback_2k b200/b76")
        return False

    verbose = int(debug)
    #print_info("debug=%d"%(verbose))
##------------------------------------------------------------------------------
## Toggle Test Signals
##------------------------------------------------------------------------------
## The following signals are tied as shown below on the REV_1 loopback board
## Schematic# 22025099-103 rev 001, ASSY# ??
##
## exp_uart_rx      <=>    exp_uart_tx
## exp_lvds_rx[4:0] <=>    exp_lvds_tx[4:0]
## exp_gpio[14]     <=>    exp_gpio[15]
## exp_gpio[12]     <=>    exp_gpio[13]
## exp_gpio[10]     <=>    exp_gpio[11]
## exp_gpio[8]      <=>    exp_gpio[9]
## exp_gpio[6]      <=>    exp_gpio[7]
## exp_gpio[4]      <=>    exp_gpio[5]
## exp_gpio[2]      <=>    exp_gpio[3]
## exp_gpio[1]      <=>    exp_rst_n
## exp_irq_n        <=>    exp_gpio[0]
## expc_icb_ctl[2]  <=>    expc_icb_ctl[1]
## 1'b1             <=>    expc_icb_ctl[0]
##
## BIST Write Register    ->  Part Output      ->  EXPC Input       ->  EXPC Output      ->  Part Input       -> BIST Read Register      NOTES:
## ------------------------------------------------------------------------------------------------------------------------------------------------------------
## csr_gpio_wr[15]        N/A                  N/A                  N/A                  N/A              -> csr_gpio_rd[15]     Allows for bit-by-bit comparison of write/read registers and validates this part's operation without the EXPC.
## csr_gpio_wr[14]    ->  exp_uart_tx      ->  exp_uart_tx      ->  exp_uart_rx      ->  exp_uart_rx      -> csr_gpio_rd[14]
## csr_gpio_wr[13:9]  ->  exp_lvds_tx[4:0] ->  exp_lvds_tx[4:0] ->  exp_lvds_rx[4:0] ->  exp_lvds_rx[4:0] -> csr_gpio_rd[13:9]
## csr_gpio_wr[8]     ->  exp_gpio_out[8]  ->  exp_gpio[14]     ->  exp_gpio[15]     ->  exp_gpio_in[8]   -> csr_gpio_rd[8]
## csr_gpio_wr[7]     ->  exp_gpio_out[7]  ->  exp_gpio[12]     ->  exp_gpio[13]     ->  exp_gpio_in[7]   -> csr_gpio_rd[7]
## csr_gpio_wr[6]     ->  exp_gpio_out[6]  ->  exp_gpio[10]     ->  exp_gpio[11]     ->  exp_gpio_in[6]   -> csr_gpio_rd[6]
## csr_gpio_wr[5]     ->  exp_gpio_out[5]  ->  exp_gpio[8]      ->  exp_gpio[9]      ->  exp_gpio_in[5]   -> csr_gpio_rd[5]
## csr_gpio_wr[4]     ->  exp_gpio_out[4]  ->  exp_gpio[6]      ->  exp_gpio[7]      ->  exp_gpio_in[4]   -> csr_gpio_rd[4]
## csr_gpio_wr[3]     ->  exp_gpio_out[3]  ->  exp_gpio[4]      ->  exp_gpio[5]      ->  exp_gpio_in[3]   -> csr_gpio_rd[3]
## csr_gpio_wr[2]     ->  exp_gpio_out[2]  ->  exp_gpio[2]      ->  exp_gpio[3]      ->  exp_gpio_in[2]   -> csr_gpio_rd[2]
## csr_gpio_wr[1]     ->  exp_rst_n        ->  exp_rst_n        ->  exp_gpio[1]      ->  exp_gpio_in[1]   -> csr_gpio_rd[1]      exp_gpio_out[1] is not used for sanity.
## csr_gpio_wr[0]     ->  exp_gpio_out[0]  ->  exp_gpio[0]      ->  exp_irq_n        ->  exp_irq_n        -> csr_gpio_rd[0]      exp_gpio_in[0]  is ignored  for sanity.

    pattern_list = [0x0000, 0xFFFF, 0XAAAA, 0x5555]
    error = 0

    if (loopback == "b200" or loopback == "B200"):
        Mask=0xFFFF
    else:
        Mask=0xFFF8 #GPIO[0] <-> GPIO[3] not managed the same way on B76 and BIST mode in B11 PFPGA

    #Switch ON Slot B
    p = subprocess.Popen("qdbus --system com.viavisolutions.platform.PowerBudget /com/viavisolutions/platform/PowerBudget com.viavisolutions.platform.PowerBudget.RequestSubmodulePowerOn 0 1", shell=True,
                         stdin=subprocess.PIPE, stdout=subprocess.PIPE, stderr=subprocess.STDOUT, close_fds=True)
    p.wait()
    err = p.returncode
    if err:
        print_error("Can't power ON SLOT B module (%d)" % (err))
        return False
    sleep(0.5)

    ## Switch PFPGA in BIST mode
    if verbose != 0:
        print_info("## Switch PFPGA in BIST mode")
    Write_Hamma_Register("moduleSelectorInstB", "MODULE_SEL", 0x01, verbose )
    sleep(0.5)

    for pattern in pattern_list:
        Write_Hamma_Register("bistMmbRev2P0InstB", "GPIO_WR_REG", pattern, verbose )
        sleep(1)
        rd_val = Read_Hamma_Register("bistMmbRev2P0InstB", "GPIO_RD_REG", verbose)
        if ( (rd_val & Mask) != (pattern & Mask) ) :
            print_error("Expected : 0x%x, Read : 0x%x"%((pattern & Mask), (rd_val & Mask)))
            error = error + 1
        sleep(0.5)

    ## Switch PFPGA in IDLE mode
    if verbose != 0:
        print_info("## Switch PFPGA in IDLE mode")
    Write_Hamma_Register("moduleSelectorInstB", "MODULE_SEL", 0x00, verbose )
    sleep(0.5)

    #Switch OFF Slot B
    p = subprocess.Popen("qdbus --system com.viavisolutions.platform.PowerBudget /com/viavisolutions/platform/PowerBudget com.viavisolutions.platform.PowerBudget.SubmodulePowerOff 0 1", shell=True,
                         stdin=subprocess.PIPE, stdout=subprocess.PIPE, stderr=subprocess.STDOUT, close_fds=True)
    p.wait()
    err = p.returncode
    if err:
        print_error("Can't power OFF SLOT B module (%d)" % (err))
        return False
    sleep(0.5)

    if (error != 0):
        return False
    else:
        return True


@DIAG("CPB 2K loopback test using B200")
def t_cpb_loop(cmd):
    debug = 0
    while t_cpb_loopback_2k("t_cpb_loopback_2k b200 0"):
        debug = debug + 1
        print_info("True,  loop: %d"%(debug))
        sleep(0.5)
