from viavi.evm import *
from viavi.diag import *
from viavi.mts.calib import *
from viavi.mts.blockutils import mount_cal, umount_cal
import os
from shutil import rmtree
import subprocess

OBB7000_EEPROM_FILE = "/sys/devices/platform/soc@0/30800000.bus/30a40000.i2c/i2c-2/i2c-4/i2c-6/i2c-7/7-0054/eeprom"
OBB7000_EEPROM_PROBE = "echo 24c64 0x54 > /sys/devices/platform/soc@0/30800000.bus/30a40000.i2c/i2c-2/i2c-4/i2c-6/i2c-7/new_device"

global cal

OTH_BACKPLANE_BOARD_7000= {
    "Common": {
        "First": {
            "Section_Name": "common",
            "Section_Version": 101
        },
        "Header": {
            "Header_Identity": 47,
            "Module_Design": 0,
            "Cfg_File": "empty.cfg",
            "Module_Name": "OBB7000",
            "Prefix": "",
        }
    },
    "Prod": {
        "First": {
            "Section_Name": "prod",
            "Section_Version": 101,
            "Is_Last_Section": True
        }
    }
}



BOARDS = {
    "OBB7000":       OTH_BACKPLANE_BOARD_7000,
}

def cal_init_obb7000(cal):
    platform_conf = BOARDS["OBB7000"]
    cal.init(platform_conf)
    cal_set_header(cal, "Date_Fab", datetime.datetime.today())


def obb7000_cal_get_base_calibration():
    import os.path
    err = 0
    crc_ok = 0

    if os.path.exists(OBB7000_EEPROM_FILE):
        print("OK")
    else:
        p = subprocess.Popen(OBB7000_EEPROM_PROBE, shell=True,
                             stdin=subprocess.PIPE, stdout=subprocess.PIPE, stderr=subprocess.STDOUT, close_fds=True)
        p.wait();
        err += p.returncode;

    if (err == 0):
        f=open(OBB7000_EEPROM_FILE, 'rb')
        crc = f.read(4)
        print("crc[0]=0x%x"%crc[0])
        print("crc[1]=0x%x"%crc[1])
        print("crc[2]=0x%x"%crc[2])
        print("crc[3]=0x%x"%crc[3])
        if ( ((crc[0] + crc[2]) != 255) and ((crc[1] + crc[3]) != 255) ):
            crc_ok = 1;

    if (crc_ok == 0):
        print("CRC OK, dumping existing Common Header")
        cal = read_struct_from_file(OBB7000_EEPROM_FILE, CommonHeader)
    else:
        cal = CommonHeader()

    return cal

def obb7000_cal_set_base_calibration(cal):
    import os.path
    err = 0

    if os.path.exists(OBB7000_EEPROM_FILE):
        print("OK")
    else:
        p = subprocess.Popen(OBB7000_EEPROM_PROBE, shell=True,
                             stdin=subprocess.PIPE, stdout=subprocess.PIPE, stderr=subprocess.STDOUT, close_fds=True)
        p.wait();
        err += p.returncode;

    if (err == 0):
        cal_set_header(cal, "Date_Calib", datetime.datetime.today())
        write_struct_to_file(OBB7000_EEPROM_FILE, cal)
        return True
    else:
        print("# %s"%err)
        print("FAIL")
        return False


@RESOURCE("obb7000_calibration")
def load_calibration(mode):
    global cal
    if mode:
        Log("Load current calibration")
        cal = obb7000_cal_get_base_calibration()
    else:
        Log("Save current calibration")
        obb7000_cal_set_base_calibration(cal)


@DIAG("OBB7000 I2C EEPROM calibration", depends=["obb7000_calibration"])
def obb7000cal(cmd):
    global cal
    import datetime
    if len(cmd.split()) == 1:
        print(cal)
        return True
    params = cmd.split()[1:]
    params[0] = params[0].lower()
    try:
        if params[0] == "init":
            cal_init_obb7000(cal)

        elif params[0] == "print":
            print(cal)

        elif params[0] == "save":
            obb7000_cal_set_base_calibration(cal)
            return True
            oldcrc = cal.data["Common"].data["First"].data["Crc"].value()
            newcal = cal_get_base_calibration()
            newcrc = newcal.data["Common"].data["First"].data["Crc"].value()
            return (newcrc == oldcrc)

        elif params[0] == "reload":
            cal = obb7000_cal_get_base_calibration()

        elif params[0] == "vhard":
            if len(params) > 1:
                cal_set_header(cal, "Hdw_Release", int(params[1]))
            else:
                print_info("# %s"%cal.data["Common"].data["Header"].data["Hdw_Release"])

        elif params[0] == "nmod":
            if len(params) > 1:
                cal_set_header(cal, "Serial_Number", " ".join(params[1:]))
            else:
                print_info("# %s"%cal.data["Common"].data["Header"].data["Serial_Number"])

        elif params[0] == "name":
            if len(params) > 1:
                cal_set_header(cal, "Module_Name", " ".join(params[1:]))
            else:
                print_info("# %s"%cal.data["Common"].data["Header"].data["Module_Name"])

        elif params[0] == "dfab":
            if len(params) > 1:
                cal_set_header(cal, "Date_Fab", datetime.datetime(int(params[1]), int(params[2]), int(params[3]), 0, 0, 0))
            else:
                print_info("# %s"%cal.data["Common"].data["Header"].data["Date_Fab"])

        elif params[0] == "dcal":
            print_info("# %s"%cal.data["Common"].data["Header"].data["Date_Calib"])

        elif params[0] == "calib":
            if len(params) > 1:
                cal_set_header(cal, "Calibrated", params[1].lower()[0] == "y")
            else:
                print_info("# %s"%cal.data["Common"].data["Header"].data["Calibrated"])

        elif params[0] == "barc":
            if len(params) > 1:
                cal_set_header(cal, "Bar_Code", " ".join(params[1:]))
            else:
                print_info("# %s"%cal.data["Common"].data["Header"].data["Bar_Code"])

        elif params[0] == "serial":
                print_info("# Serial_Number: %s%s"%(cal.data["Common"].data["Header"].data["Prefix"].value(),cal.data["Common"].data["Header"].data["Serial_Number"].value()))

        elif params[0] == "prod":
            if len(params) > 2:
                cal.data["Prod"].data["Prod_Parametres"].item(int(params[1])).value(int(params[2]))
            elif len(params) > 1:
                print_info("# %s"%cal.data["Prod"].data["Prod_Parametres"].item(int(params[1])).value())

        elif params[0] == "prefix":
            if len(params) > 1:
                cal_set_header(cal, "Prefix", " ".join(params[1:]))
            else:
                print_info("# %s"%cal.data["Common"].data["Header"].data["Prefix"])

        elif params[0] == "pbuf":
            if len(params) > 1:
                buf = params[1]
                if buf[0] == "#":
                    buf_size_size = int(buf[1])
                    buf_size = int(buf[2:2+buf_size_size+4]) # +4 : For 2 bytes offset
                    buf = buf[6 + buf_size_size:6 + buf_size_size + buf_size]
                cal.data["Prod"].data["Prod"].value(buf)
            else:
                data = cal.data["Prod"].data["Prod"].value()
                head =  "#4%04d"%len(data)
                print_info("# %s%s"%(head,data))

        elif params[0] == "purge":
            print_info("The purge may take a while - please wait...")
            p = subprocess.Popen(f"dd if=/dev/zero of={OBB7000_EEPROM_FILE} bs=1 count=8192", shell=True,
                                 stdin=subprocess.PIPE, stdout=subprocess.PIPE, stderr=subprocess.STDOUT,
                                 close_fds=True)
            p.wait();
            err = p.returncode;

            if (err):
                print_error(f"Error {err}")
                return False
            else:
                return True
        else:
            print_error("Unknown command %s"%params[0])
            return False
        return True
    except Exception as err:
        print_error("%s"%err)
        return False
