import QtQuick 2.1
import common 1.0
import graph_plugin 1.0

Item {
    id: cursorDrag
    width: 33
    transform: Translate { x: -(cursorDrag.width-1)/2 }

    signal clicked(var mouse)
    signal released(var mouse)
    property alias pressed: dragArea.pressed
    
    property color __color: "red"

    Rectangle {
        id: cursorHighlight
        anchors.centerIn: parent
        width: parent.height
        height: parent.width
        rotation: 90
        opacity: 0
        gradient: Gradient {
            GradientStop { position: 0.0; color: Qt.rgba(__color.r, __color.g, __color.b, 0) }
            GradientStop { position: 0.4; color: Qt.rgba(__color.r, __color.g, __color.b, 128/255) }
            GradientStop { position: 0.5; color: Qt.rgba(__color.r, __color.g, __color.b, 1) }
            GradientStop { position: 0.6; color: Qt.rgba(__color.r, __color.g, __color.b, 128/255) }
            GradientStop { position: 1.0; color: Qt.rgba(__color.r, __color.g, __color.b, 0) }
        }
        Behavior on opacity {
            NumberAnimation { duration: 250 }
        }
    }

    MouseArea {
        id: dragArea
        anchors.fill: parent
        drag.target: parent
        drag.axis: Drag.XAxis
        drag.minimumX: 0
        drag.maximumX: cursorDrag.parent.width-1
        onPressed: cursorHighlight.opacity = 1;
        onReleased: cursorHighlight.opacity = 0;
    }

    onXChanged: {
        GraphCursor.cursor.setPosOnScreen(x);
        // anchor drag to graph cursor
        x = GraphCursor.xPosOnScreen;
    }

    GraphCursor.onXPosOnScreenChanged: {
        cursorDrag.x = GraphCursor.xPosOnScreen;
    }

    Component.onCompleted:
    {
        dragArea.clicked.connect(clicked)
        dragArea.released.connect(released)
    }
}
