import QtQuick 2.5
import QtQuick.Controls 2.0

import com.viavi.style 1.0

Item {
    id: root

    property alias textField: keyboardTextInput.text
    property alias cursorPos: keyboardTextInput.cursorPosition
    property alias titleDescription: textDescription.text
    property alias titleText: title.text
    property bool hasTitleAction: false
    property alias inputTextMaxLength: keyboardTextInput.maximumLength

    signal titleClicked()
    signal inputTextAccepted()
    signal inputTextChanged(string newText)

    height: keyboardUtils.heightKeyboardHeader
    anchors.top: parent.top
    anchors.topMargin: keyboardUtils.keyboardVerticalMargin
    anchors.right: parent.right
    anchors.rightMargin: keyboardUtils.keyboardHorizontalMargin
    anchors.left: parent.left
    anchors.leftMargin: keyboardUtils.keyboardHorizontalMargin

    property string initialText

    Column {
        id: columnId

        anchors.left: parent.left
        anchors.right: parent.right


        spacing: keyboardUtils.spacingKeyboardHeader
        Flow {
            id: flow
            anchors.horizontalCenter: parent.horizontalCenter
            spacing: ViaviStyle.layout.smallMargin
            Text {
                id: textDescription
                width: contentWidth
                height: contentHeight

                font: ViaviStyle.layout.titleTextFont
                color: ViaviColor.mainInfoColor

                visible: text
            }

            Item{
                width: textDescription.visible ? title.contentWidth : title.width
                height: title.height

                clip: true
                /* Keyboard Title */
                Text {
                    id: title

                    width: columnId.width - (textDescription.visible ? textDescription.width + flow.spacing : 0)
                    height: keyboardUtils.heightKeyboardTitle

                    font: ViaviStyle.layout.titleTextFont
                    color: hasTitleAction
                           ? (mouseArea.pressed ? ViaviColor.selectedColor : ViaviColor.activeColor )
                           : ViaviColor.mainInfoColor

                    horizontalAlignment: textDescription.visible ? Text.AlignLeft : Text.AlignHCenter
                    wrapMode: Text.Wrap

                    MouseArea{
                        id: mouseArea

                        anchors.fill: parent
                        enabled: hasTitleAction

                        onClicked: {
                            root.titleClicked()
                        }
                    }

                }
            }
        }

        /* Keyboard Input Field */
        TextField {

            id: keyboardTextInput

            width: parent.width
            height: keyboardUtils.heightKeyboardText

            background: Rectangle {
                border.width:  ViaviStyle.layout.borderSize
                border.color:  ViaviColor.activeColor
            }

            color: ViaviColor.mainInfoColor
            font: ViaviStyle.layout.keyboardTextFont

            maximumLength: 10

            cursorDelegate: Rectangle {
                visible: parent.cursorVisible
                color: ViaviStyle.colors.selectedColor
                width: ViaviStyle.layout.keyboardButtonMargin
            }

            text: root.initialText

            Connections{
                target: root

                function onInitialTextChanged() {
                    if( visible ){
                        keyboardTextInput.text = initialText
                        keyboardTextInput.forceActiveFocus()
                    }
                }
            }

            onVisibleChanged: {
                if( visible ) {
                    keyboardTextInput.text = root.initialText
                    keyboardTextInput.forceActiveFocus()
                }
            }

            onTextChanged: {
                root.inputTextChanged(keyboardTextInput.text)
            }

            onAccepted: {
                root.inputTextAccepted()
            }
        }
    }
}



