import QtQuick 2.5

import com.viavi.style 1.0

Rectangle {
    id: buttonRectangle

    property alias  buttonWidth             : buttonRectangle.width
    property alias  buttonHeight            : buttonRectangle.height
    property alias  buttonBackgroundColor   : buttonRectangle.color
    property alias  buttonLabelVisible      : buttonTextLabel.visible

    /* button label: always make sure to set this values */
    property string buttonLabel             : ""
    property int    buttonType              : keyboardUtils.buttonTypeAlpha
    property bool   buttonPressed           : false
    property bool   buttonEnabled           : true


    width: keyboardUtils.buttonWidthAlphaKeyb
    implicitWidth: keyboardUtils.buttonWidthAlphaKeyb
    height: keyboardUtils.buttonHeightAlphaKeyb
    implicitHeight: keyboardUtils.buttonHeightAlphaKeyb

    border.color: ViaviColor.alternativeBackgroundColor
    border.width: ViaviStyle.layout.keyboardButtonMargin

    color: !buttonEnabled ? ViaviColor.alternativeBackgroundColor :
            buttonPressed ? ViaviColor.activeColor : ViaviColor.contentBackgroundColor


    Text {
        id: buttonTextLabel

        visible: buttonEnabled

        anchors.centerIn: parent

        text: buttonLabel

        font: ViaviStyle.layout.titleTextFont

        color: buttonPressed ? ViaviColor.activeItemTextColor : ViaviColor.activeColor
    }

    MouseArea {
        id: buttonMouseArea

        anchors.fill: parent

        enabled: buttonEnabled

        onPressed: {
            buttonRectangle.buttonPressed = true
        }

        onReleased: {
            buttonRectangle.buttonPressed = false

            if ( buttonType == keyboardUtils.buttonTypeAlpha ||
                    buttonType == keyboardUtils.buttonTypeNumerical)
            {
                charButtonClicked( buttonLabel )
            }
            else if ( buttonType == keyboardUtils.buttonTypeCustom )
            {
                customButtonClicked( buttonLabel )
            }
            else if ( buttonType == keyboardUtils.buttonType2ndPage )
            {
                extraButtonClicked( buttonLabel )
            }
        }
    }
}



