import QtQuick 2.3
import QtQuick.Layouts 1.2
import QtQuick.Controls 2.0

import com.viavi.style 1.0

Button {
    id: button

    property bool selected: false
    property bool centerContent: true

    opacity: enabled ? ViaviStyle.colors.opacityEnabled : ViaviStyle.colors.opacityDisabled

    padding: ViaviStyle.layout.mediumMargin

    background: Rectangle {
        implicitHeight: ViaviStyle.layout.buttonHeight
        color: {
            if (pressed) return ViaviStyle.colors.selectedColor
            else if (selected) return ViaviStyle.colors.activeColor
            else return ViaviStyle.colors.contentBackgroundColor
        }
        border.color: selected ? ViaviStyle.colors.activeColor : ViaviStyle.colors.borderColor
        border.width: ViaviStyle.layout.borderWidth
    }

    implicitWidth: contentItem.implicitWidth + 2 * padding
    implicitHeight: background.implicitHeight

    contentItem: Label {
        id: textComponent

        text: button.text

        color: selected ? ViaviStyle.colors.activeItemTextColor : ViaviStyle.colors.activeColor
        font: button.selected ? ViaviStyle.layout.activeBoldTextFont : ViaviStyle.layout.activeTextFont

        verticalAlignment: Text.AlignVCenter
        horizontalAlignment: centerContent ? Label.AlignHCenter : Label.AlignLeft
    }
}
