import QtQuick 2.3
import QtQuick.Layouts 1.2
import QtQuick.Controls 2.0

import com.viavi.style 1.0
import com.viavi.style.components 1.0
import com.viavi.style.components.menudata 1.0
import com.viavi.style.components.virtualkeyboard 1.0

    
ViaviMenuLineControl {
    id: root

    property alias textData: textFieldProperties
    TextFieldData {
        id: textFieldProperties
    }
    property int inputTextWidth: ViaviStyle.layout.menuTextFieldWidth

    signal textClicked();

    mainContentItem: ViaviInputText {
        id: inputText
        text: textFieldProperties.text
        enabled: textFieldProperties.enabled
        visible: textFieldProperties.visible
        implicitWidth: inputTextWidth
        onTextEdited: {
            if (textFieldProperties.text !== text)
                textFieldProperties.text = text
        }

        onClicked: {
            root.textClicked()
        }
        implicitHeight: ViaviStyle.layout.setupMenuLineHeight
        Layout.fillWidth: mainContentFillWidth
    }
}
